/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bailorg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class BailOrgUtil {
    private static final BailOrgUtil instance = new BailOrgUtil();

    public static BailOrgUtil getInstance() {
        return instance;
    }

    public List<String> getBillTile(boolean isEbModel) {
        ArrayList<String> titles = new ArrayList<String>(10);
        if (!isEbModel) {
            titles.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801*", (String)"BailOrgUtil_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            titles.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe\u540d\u79f0", (String)"BailOrgUtil_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        titles.add(ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u7f16\u7801*", (String)"BailOrgUtil_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        titles.add(ResManager.loadKDString((String)"\u9884\u7b97\u7ec4\u7ec7\u540d\u79f0", (String)"BailOrgUtil_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        titles.add(ResManager.loadKDString((String)"\u53d7\u6258\u7ec4\u7ec7\u7f16\u7801*", (String)"BailOrgUtil_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        titles.add(ResManager.loadKDString((String)"\u53d7\u6258\u7ec4\u7ec7\u540d\u79f0", (String)"BailOrgUtil_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return titles;
    }

    public void modifyTitleRow(BgExcelWriter excelWriter, boolean isErrorExcel, boolean isEbModel) {
        int startColIndex = isErrorExcel ? 1 : 0;
        List<String> billTile = this.getBillTile(isEbModel);
        Sheet sheetAt = excelWriter.getWorkbook().getSheetAt(0);
        Row row = sheetAt.getRow(3);
        for (int i = 0; i < billTile.size(); ++i) {
            row.getCell(i + startColIndex).setCellValue(billTile.get(i));
        }
    }

    public void addOrgViewInfoSheet(BgExcelWriter excelWriter, Long modelId) {
        List dimensionViews = BailOrgService.getInstance().getDimensionViews(modelId, "Entity");
        if (CollectionUtils.isNotEmpty((Collection)dimensionViews)) {
            excelWriter.createSheet(ResManager.loadKDString((String)"\u7ec4\u7ec7\u89c6\u56fe", (String)"BailOrgUtil_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            excelWriter.createRow(new Object[]{"", ResManager.loadKDString((String)"\u89c6\u56fe\u7f16\u7801", (String)"BailOrgUtil_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89c6\u56fe\u540d\u79f0", (String)"BailOrgUtil_11", (String)"epm-eb-formplugin", (Object[])new Object[0])});
            for (Object[] object : dimensionViews) {
                excelWriter.createRow(new Object[]{"", object[0], object[1]});
            }
        }
    }
}

