/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.convert.Convert;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractAdjustMobBillPlugin
extends AbstractMobBillPlugIn {
    private static final String ADJ_DETAIL_ENTITY = "adjdetailentity";
    protected List<String> entryEntityKeys = new ArrayList<String>(Arrays.asList("Entity", "Account", "Metric", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6", "customdim7", "customdim8", "customdim9", "customdim10", "customdim11", "customdim12", "customdim13", "customdim14", "customdim15", "customdim16", "customdim17", "customdim18", "customdim19", "customdim20", "customdim21", "customdim22", "customdim23", "customdim24", "customdim25", "customdim26", "customdim27", "customdim28", "customdim29", "customdim30", "customdim31", "customdim32", "customdim33", "customdim34", "customdim35", "customdim36", "customdim37", "customdim38", "customdim39", "customdim40", "customdim41", "customdim42", "customdim43", "customdim44", "customdim45", "customdim46", "customdim47", "customdim48", "customdim49", "customdim50"));
    private Map<String, String> dataMap;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String reportType = dataEntity.getString("model.reporttype");
        if ("7".equals(reportType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bgmflex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bgflex"});
        } else if ("6".equals(reportType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bgmflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bgflex"});
        }
        DynamicObjectCollection detailList = dataEntity.getDynamicObjectCollection(ADJ_DETAIL_ENTITY);
        this.updateDataBeforeOpen(detailList);
        this.showData(detailList);
    }

    protected Long getBizModelId() {
        return 0L;
    }

    protected Long getModelId() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        return dataEntity.getLong("model.id");
    }

    public abstract void updateDataBeforeOpen(DynamicObjectCollection var1);

    public void updateEntryEntityKeys() {
    }

    protected String getFormType() {
        String formType = (String)this.getModel().getValue("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        return formType;
    }

    public DynamicInfoCollection getCachePeriodInfo() {
        String periodStr = this.getPageCache().get("periodsInfoCache");
        DynamicInfoCollection periodInfos = periodStr == null ? new DynamicInfoCollection(ResManager.loadKDString((String)"\u591a\u9009\u671f\u95f4\u4fe1\u606f-id,\u7f16\u7801\uff0c\u540d\u79f0\uff0c\u5e8f\u53f7", (String)"BaseEbAdjustBillEditPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), new String[]{"id", "number", "name", "order"}) : (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)periodStr);
        return periodInfos;
    }

    public void setHeadDimNumbers(List<String> headDimKeys, Map<String, Set<String>> allDimMembNums, QFBuilder qfBuilder) {
        for (String key : headDimKeys) {
            HashSet<String> membNums;
            if (this.getModel().getValue(key) instanceof DynamicObjectCollection) {
                DynamicObjectCollection budgetPeriods = (DynamicObjectCollection)this.getModel().getValue(key);
                membNums = new HashSet<String>(16);
                HashSet<Long> ids = new HashSet<Long>(budgetPeriods.size());
                for (DynamicObject bperiod : budgetPeriods) {
                    bperiod = (DynamicObject)bperiod.get("fbasedataid");
                    membNums.add(bperiod.getString("number"));
                    ids.add(bperiod.getLong("id"));
                }
                qfBuilder.add(key, "in", ids);
                allDimMembNums.put("BudgetPeriod", membNums);
                continue;
            }
            if (!(this.getModel().getValue(key) instanceof DynamicObject)) continue;
            DynamicObject F7Val = (DynamicObject)this.getModel().getValue(key);
            qfBuilder.add(key, "=", (Object)F7Val.getLong("id"));
            membNums = new HashSet(16);
            membNums.add(F7Val.getString("number"));
            allDimMembNums.put(key, membNums);
        }
    }

    public abstract DynamicInfoCollection getCustomDimsInfo();

    public DynamicInfoCollection getCustomDimsInfoCache() {
        DynamicInfoCollection customDimInfo = this.getCustomDimsInfo();
        if (!customDimInfo.isEmpty()) {
            List id = customDimInfo.getAllValOfOneProp("id");
            ArrayList dimensions = new ArrayList(id.size());
            id.forEach(e -> dimensions.add(Convert.toLong((Object)e, (Long)0L)));
            QFBuilder qb = new QFBuilder("dimension", "in", dimensions);
            qb.add("membersource", "=", (Object)true);
            qb.add("number", "like", (Object)"%None");
            DynamicObjectCollection defMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension,number", (QFilter[])qb.toArray());
            for (DynamicObject member : defMembers) {
                String memberId = member.getString("id");
                String dimensionId = member.getString("dimension");
                DynamicInfoCollection.InfoObject infoOb = customDimInfo.getInfoByOneProp("id", (Object)dimensionId);
                infoOb.setValueByPropName("defMemberId", (Object)memberId);
                infoOb.setValueByPropName("defMemberNum", (Object)member.getString("number"));
            }
        }
        return customDimInfo;
    }

    public void showData(DynamicObjectCollection detailList) {
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return;
        }
        this.dataMap = new HashMap<String, String>(detailList.size());
        for (DynamicObject billDetail : detailList) {
            DynamicObject period = (DynamicObject)billDetail.get(this.getPeriodName());
            String periodNum = period.getString("number");
            BigDecimal budgetData = (BigDecimal)billDetail.get("budgetdata");
            BigDecimal adjustData = (BigDecimal)billDetail.get("adjustdata");
            BigDecimal finalData = (BigDecimal)billDetail.get("finaldata");
            if (this.dataMap.containsKey(periodNum)) {
                String oldDataStr = this.dataMap.get(periodNum);
                String[] oldDataArr = oldDataStr.split("\\|");
                budgetData = budgetData.add(new BigDecimal(oldDataArr[0]));
                adjustData = adjustData.add(new BigDecimal(oldDataArr[1]));
                finalData = finalData.add(new BigDecimal(oldDataArr[2]));
            }
            this.dataMap.put(periodNum, budgetData + "|" + adjustData + "|" + finalData);
        }
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(this.getFlexPanelApId());
        flexPanelAp.setWidth(new LocaleString("98%"));
        flexPanelAp.setGrow(0);
        flexPanelAp.setShrink(0);
        this.drawDetailFlexAp(detailList, flexPanelAp);
        this.getView().updateControlMetadata(this.getFlexPanelApId(), flexPanelAp.createControl());
    }

    private void drawDetailFlexAp(DynamicObjectCollection detailList, FlexPanelAp flexPanelAp) {
        DynamicObject billDetail;
        int i;
        HashMap<String, FlexPanelAp> periodPlexMap = new HashMap<String, FlexPanelAp>(16);
        for (i = 0; i < detailList.size(); ++i) {
            billDetail = (DynamicObject)detailList.get(i);
            DynamicObject period = (DynamicObject)billDetail.get(this.getPeriodName());
            String periodNumber = period.getString("number");
            if (periodPlexMap.containsKey(periodNumber)) continue;
            FlexPanelAp rowFlexPanelAp = this.createRowFlexPanelAp(i);
            periodPlexMap.put(periodNumber, rowFlexPanelAp);
        }
        for (i = 0; i < detailList.size(); ++i) {
            billDetail = (DynamicObject)detailList.get(i);
            this.drawRowBody(billDetail, flexPanelAp, periodPlexMap, i);
        }
    }

    private FlexPanelAp createRowFlexPanelAp(int row) {
        FlexPanelAp rowFlexPanelAp = new FlexPanelAp();
        rowFlexPanelAp.setKey("row_flexpannelap" + row);
        rowFlexPanelAp.setWidth(new LocaleString("98%"));
        rowFlexPanelAp.setGrow(0);
        rowFlexPanelAp.setShrink(0);
        rowFlexPanelAp.setDirection("row");
        rowFlexPanelAp.setJustifyContent("center");
        rowFlexPanelAp.setAlignItems("center");
        return rowFlexPanelAp;
    }

    private void drawRowBody(DynamicObject dynamicObject, FlexPanelAp flexPanelAp, Map<String, FlexPanelAp> periodPlexMap, int row) {
        FlexPanelAp bodyFlexPanelAp = new FlexPanelAp();
        bodyFlexPanelAp.setKey("flex_panelAp" + row);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("10px");
        style.setMargin(margin);
        bodyFlexPanelAp.setWidth(new LocaleString("98%"));
        bodyFlexPanelAp.setGrow(0);
        bodyFlexPanelAp.setShrink(0);
        bodyFlexPanelAp.setDirection("row");
        bodyFlexPanelAp.setJustifyContent("center");
        bodyFlexPanelAp.setAlignItems("center");
        bodyFlexPanelAp.setStyle(style);
        FlexPanelAp rowHeadFlexPanelAp = new FlexPanelAp();
        this.drawDims(dynamicObject, rowHeadFlexPanelAp, row);
        bodyFlexPanelAp.getItems().add(rowHeadFlexPanelAp);
        FlexPanelAp rowEndFlexPanelAp = new FlexPanelAp();
        rowEndFlexPanelAp.setKey("flex_end" + row);
        rowEndFlexPanelAp.setWidth(new LocaleString("50%"));
        rowEndFlexPanelAp.setGrow(0);
        rowEndFlexPanelAp.setShrink(0);
        rowEndFlexPanelAp.setDirection("row");
        rowEndFlexPanelAp.setJustifyContent("space-between");
        rowEndFlexPanelAp.setAlignItems("center");
        FlexPanelAp adjustNameFlex = new FlexPanelAp();
        this.drawAdjustName(adjustNameFlex, row);
        FlexPanelAp adjustValueFlex = new FlexPanelAp();
        this.drawAdjustValue(dynamicObject, adjustValueFlex, row);
        rowEndFlexPanelAp.getItems().add(adjustNameFlex);
        rowEndFlexPanelAp.getItems().add(adjustValueFlex);
        bodyFlexPanelAp.getItems().add(rowEndFlexPanelAp);
        DynamicObject period = (DynamicObject)dynamicObject.get(this.getPeriodName());
        String periodNumber = period.getString("number");
        FlexPanelAp rowFlexPanelAp = periodPlexMap.get(periodNumber);
        rowFlexPanelAp.getItems().add(bodyFlexPanelAp);
        if (!flexPanelAp.getItems().contains(rowFlexPanelAp)) {
            this.drawSplitLine(flexPanelAp, row);
            this.drawRowHead(dynamicObject, flexPanelAp, row);
            flexPanelAp.getItems().add(rowFlexPanelAp);
            this.drawTotalFlexPanelAp(dynamicObject, flexPanelAp, row);
        }
    }

    private void drawSplitLine(FlexPanelAp flexPanelAp, int row) {
        FlexPanelAp lineFlexPanelAp = new FlexPanelAp();
        lineFlexPanelAp.setKey("line_flexpanelap" + row);
        lineFlexPanelAp.setWidth(new LocaleString("98%"));
        lineFlexPanelAp.setHeight(new LocaleString("5px"));
        lineFlexPanelAp.setGrow(0);
        lineFlexPanelAp.setShrink(0);
        lineFlexPanelAp.setBackColor("#F2F6F9");
        flexPanelAp.getItems().add(lineFlexPanelAp);
    }

    private void drawRowHead(DynamicObject dynamicObject, FlexPanelAp flexPanelAp, int row) {
        FlexPanelAp headFlexPanelAp = new FlexPanelAp();
        headFlexPanelAp.setKey("row_head" + row);
        headFlexPanelAp.setWidth(new LocaleString("100%"));
        headFlexPanelAp.setGrow(0);
        headFlexPanelAp.setShrink(0);
        FlexPanelAp periodFlexPanelAp = new FlexPanelAp();
        periodFlexPanelAp.setWidth(new LocaleString("100%"));
        periodFlexPanelAp.setKey("period_flexpanelap" + row);
        periodFlexPanelAp.setJustifyContent("flex-end");
        Style periodStyle = new Style();
        Border periodBorder = new Border();
        Padding periodPadding = new Padding();
        periodPadding.setTop("3px");
        periodPadding.setRight("15px");
        periodBorder.setTop("1px solid #e5e5e5");
        periodStyle.setBorder(periodBorder);
        periodStyle.setPadding(periodPadding);
        periodFlexPanelAp.setGrow(0);
        periodFlexPanelAp.setShrink(0);
        LabelAp periodLabel = new LabelAp();
        periodLabel.setKey("period_label" + row);
        periodLabel.setFontSize(14);
        periodLabel.setForeColor("#666666");
        DynamicObject period = (DynamicObject)dynamicObject.get(this.getPeriodName());
        String periodName = period.getString("name");
        periodLabel.setName(new LocaleString(periodName));
        periodFlexPanelAp.setStyle(periodStyle);
        periodFlexPanelAp.getItems().add(periodLabel);
        headFlexPanelAp.getItems().add(periodFlexPanelAp);
        flexPanelAp.getItems().add(headFlexPanelAp);
    }

    private void drawDims(DynamicObject dynamicObject, FlexPanelAp rowHeadFlexPanelAp, int row) {
        rowHeadFlexPanelAp.setKey("row_head" + row);
        rowHeadFlexPanelAp.setWidth(new LocaleString("50%"));
        rowHeadFlexPanelAp.setGrow(0);
        rowHeadFlexPanelAp.setShrink(0);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("10px");
        padding.setRight("15px");
        style.setPadding(padding);
        rowHeadFlexPanelAp.setStyle(style);
        rowHeadFlexPanelAp.setDirection("column");
        rowHeadFlexPanelAp.setWrap(false);
        LabelAp entityLabel = new LabelAp();
        entityLabel.setKey("entity_label" + row);
        entityLabel.setFontSize(12);
        entityLabel.setForeColor("#999999");
        entityLabel.setAutoTextWrap(true);
        Style entityStyle = new Style();
        Margin entityMargin = new Margin();
        entityMargin.setRight("3px");
        entityStyle.setMargin(entityMargin);
        entityLabel.setStyle(entityStyle);
        DynamicObject entity = (DynamicObject)dynamicObject.get("entity");
        if (entity != null) {
            String entityName = entity.getString("name");
            entityLabel.setName(new LocaleString(" | " + SysDimensionEnum.Entity.getChineseName() + " : " + entityName + " | "));
        } else {
            entityLabel.setName(new LocaleString(""));
        }
        rowHeadFlexPanelAp.getItems().add(entityLabel);
        LabelAp accountLabel = new LabelAp();
        accountLabel.setKey("account_label" + row);
        accountLabel.setFontSize(12);
        accountLabel.setForeColor("#999999");
        accountLabel.setAutoTextWrap(true);
        Style accountStyle = new Style();
        Margin accountMargin = new Margin();
        accountMargin.setRight("3px");
        accountStyle.setMargin(accountMargin);
        accountLabel.setStyle(accountStyle);
        DynamicObject account = (DynamicObject)dynamicObject.get("account");
        if (account != null) {
            String accountName = account.getString("name");
            accountLabel.setName(new LocaleString(" | " + SysDimensionEnum.Account.getChineseName() + " : " + accountName + " | "));
        } else {
            accountLabel.setName(new LocaleString(""));
        }
        rowHeadFlexPanelAp.getItems().add(accountLabel);
        LabelAp metricLabel = new LabelAp();
        metricLabel.setKey("metric_label" + row);
        metricLabel.setFontSize(12);
        metricLabel.setForeColor("#999999");
        metricLabel.setAutoTextWrap(true);
        DynamicObject metric = (DynamicObject)dynamicObject.get("metric");
        if (metric != null) {
            String metricName = metric.getString("name");
            metricLabel.setName(new LocaleString(" | " + SysDimensionEnum.Metric.getChineseName() + " : " + metricName + " | "));
        } else {
            metricLabel.setName(new LocaleString(""));
        }
        rowHeadFlexPanelAp.getItems().add(metricLabel);
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        long modelId = model.getLong("id");
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        for (int i = 1; i <= this.getCustomDimCount(); ++i) {
            LabelAp customDimLabel = new LabelAp();
            customDimLabel.setKey("custom_dim_label" + row + i);
            customDimLabel.setFontSize(12);
            customDimLabel.setForeColor("#999999");
            customDimLabel.setAutoTextWrap(true);
            DynamicObject customDim = (DynamicObject)dynamicObject.get("customdim" + i);
            if (customDim != null) {
                Dimension dimension = orCreate.getDimension(customDim.getString("longnumber").split("!")[0]);
                String customDimName = customDim.getString("name");
                customDimLabel.setName(new LocaleString(" | " + dimension.getName() + " : " + customDimName + " | "));
            } else {
                customDimLabel.setName(new LocaleString(""));
            }
            rowHeadFlexPanelAp.getItems().add(customDimLabel);
        }
    }

    private void drawAdjustName(FlexPanelAp adjustNameFlex, int row) {
        adjustNameFlex.setKey("adjust_name_flex" + row);
        adjustNameFlex.setWidth(new LocaleString("35%"));
        adjustNameFlex.setGrow(0);
        adjustNameFlex.setShrink(0);
        adjustNameFlex.setDirection("column");
        adjustNameFlex.setJustifyContent("center");
        adjustNameFlex.setAlignItems("flex-start");
        LabelAp budgetLabel = new LabelAp();
        budgetLabel.setKey("budget_label" + row);
        budgetLabel.setFontSize(12);
        budgetLabel.setForeColor("#ffaa56");
        budgetLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u524d:", (String)"EbAdjustMobBillPlugIn_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Style budgetStyle = new Style();
        Margin budgetMargin = new Margin();
        budgetMargin.setBottom("3px");
        budgetStyle.setMargin(budgetMargin);
        budgetLabel.setStyle(budgetStyle);
        LabelAp adjustLabel = new LabelAp();
        adjustLabel.setKey("adjust_label" + row);
        adjustLabel.setFontSize(12);
        adjustLabel.setForeColor("#ffaa56");
        adjustLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u6570:", (String)"EbAdjustMobBillPlugIn_1", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Style adjustStyle = new Style();
        Margin adjustMargin = new Margin();
        adjustMargin.setBottom("3px");
        adjustStyle.setMargin(adjustMargin);
        adjustLabel.setStyle(adjustStyle);
        LabelAp finalLabel = new LabelAp();
        finalLabel.setKey("final_label" + row);
        finalLabel.setFontSize(12);
        finalLabel.setForeColor("#ffaa56");
        finalLabel.setName(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u540e:", (String)"EbAdjustMobBillPlugIn_2", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Style finalStyle = new Style();
        Margin finalMargin = new Margin();
        finalMargin.setBottom("3px");
        finalStyle.setMargin(finalMargin);
        finalLabel.setStyle(finalStyle);
        adjustNameFlex.getItems().add(budgetLabel);
        adjustNameFlex.getItems().add(adjustLabel);
        adjustNameFlex.getItems().add(finalLabel);
    }

    private void drawAdjustValue(DynamicObject dynamicObject, FlexPanelAp adjustValueFlex, int row) {
        adjustValueFlex.setKey("adjust_value_flex" + row);
        adjustValueFlex.setWidth(new LocaleString("65%"));
        adjustValueFlex.setGrow(0);
        adjustValueFlex.setShrink(0);
        adjustValueFlex.setDirection("column");
        adjustValueFlex.setAlignItems("flex-end");
        adjustValueFlex.setAlignContent("flex-end");
        Style adjustStyle = new Style();
        Padding totalPadding = new Padding();
        totalPadding.setRight("4px");
        adjustStyle.setPadding(totalPadding);
        adjustValueFlex.setStyle(adjustStyle);
        LabelAp budgetDataLabel = new LabelAp();
        budgetDataLabel.setKey("budget_data_label" + row);
        budgetDataLabel.setFontSize(12);
        budgetDataLabel.setForeColor("#999999");
        BigDecimal budgetData = (BigDecimal)dynamicObject.get("budgetdata");
        budgetDataLabel.setName(new LocaleString(AbstractAdjustMobBillPlugin.getStringData(budgetData)));
        Style budgetDataStyle = new Style();
        Margin budgetDataMargin = new Margin();
        budgetDataMargin.setBottom("3px");
        budgetDataStyle.setMargin(budgetDataMargin);
        budgetDataLabel.setStyle(budgetDataStyle);
        LabelAp adjustDataLabel = new LabelAp();
        adjustDataLabel.setKey("adjust_data_label" + row);
        adjustDataLabel.setFontSize(12);
        adjustDataLabel.setForeColor("#999999");
        BigDecimal adjustData = (BigDecimal)dynamicObject.get("adjustdata");
        adjustDataLabel.setName(new LocaleString(AbstractAdjustMobBillPlugin.getStringData(adjustData)));
        Style adjustDataStyle = new Style();
        Margin adjustDataMargin = new Margin();
        adjustDataMargin.setBottom("3px");
        adjustDataStyle.setMargin(adjustDataMargin);
        adjustDataLabel.setStyle(adjustDataStyle);
        LabelAp finalDataLabel = new LabelAp();
        finalDataLabel.setKey("labelap9" + row);
        finalDataLabel.setFontSize(12);
        finalDataLabel.setForeColor("#999999");
        BigDecimal finalData = (BigDecimal)dynamicObject.get("finaldata");
        finalDataLabel.setName(new LocaleString(AbstractAdjustMobBillPlugin.getStringData(finalData)));
        Style finalDataStyle = new Style();
        Margin finalDataMargin = new Margin();
        finalDataMargin.setBottom("3px");
        finalDataStyle.setMargin(finalDataMargin);
        finalDataLabel.setStyle(finalDataStyle);
        adjustValueFlex.getItems().add(budgetDataLabel);
        adjustValueFlex.getItems().add(adjustDataLabel);
        adjustValueFlex.getItems().add(finalDataLabel);
    }

    public void drawTotalFlexPanelAp(DynamicObject dynamicObject, FlexPanelAp flexPanelAp, int count) {
        FlexPanelAp flexPanelAP = new FlexPanelAp();
        FlexPanelAp totalFlexPanelAp = new FlexPanelAp();
        FlexPanelAp endFlex = new FlexPanelAp();
        FlexPanelAp dataFlexPanelAp = new FlexPanelAp();
        FlexPanelAp finalDataFlex = new FlexPanelAp();
        flexPanelAP.setKey("flexPanelAP" + count);
        Style style_panelAp = new Style();
        Margin margin_panelAp = new Margin();
        margin_panelAp.setTop("10px");
        style_panelAp.setMargin(margin_panelAp);
        flexPanelAP.setWidth(new LocaleString("98%"));
        flexPanelAP.setGrow(0);
        flexPanelAP.setShrink(0);
        flexPanelAP.setDirection("row");
        flexPanelAP.setJustifyContent("center");
        flexPanelAP.setAlignItems("center");
        flexPanelAP.setStyle(style_panelAp);
        endFlex.setKey("endFlex" + count);
        endFlex.setWidth(new LocaleString("50%"));
        endFlex.setGrow(0);
        endFlex.setShrink(0);
        endFlex.setDirection("row");
        endFlex.setJustifyContent("space-between");
        endFlex.setAlignItems("center");
        this.showTotalFlexAp(totalFlexPanelAp, count);
        this.getDataSelf(dataFlexPanelAp, count);
        this.showTotalAmount(dynamicObject, finalDataFlex, count);
        endFlex.getItems().add(dataFlexPanelAp);
        endFlex.getItems().add(finalDataFlex);
        flexPanelAP.getItems().add(totalFlexPanelAp);
        flexPanelAP.getItems().add(endFlex);
        flexPanelAp.getItems().add(flexPanelAP);
    }

    public void showTotalFlexAp(FlexPanelAp totalFlexPanelAp, int count) {
        totalFlexPanelAp.setKey("total" + count);
        totalFlexPanelAp.setWidth(new LocaleString("50%"));
        totalFlexPanelAp.setGrow(0);
        totalFlexPanelAp.setShrink(0);
        Style totalStyle = new Style();
        Padding totalPadding = new Padding();
        totalPadding.setLeft("13px");
        totalPadding.setRight("15px");
        totalStyle.setPadding(totalPadding);
        totalFlexPanelAp.setStyle(totalStyle);
        totalFlexPanelAp.setDirection("column");
        totalFlexPanelAp.setWrap(false);
        LabelAp totalLabelAp = new LabelAp();
        totalLabelAp.setKey("total_label" + count);
        totalLabelAp.setFontSize(12);
        totalLabelAp.setForeColor("#999999");
        totalLabelAp.setAutoTextWrap(true);
        Style totalLabelStyle = new Style();
        Margin totalLabelMargin = new Margin();
        totalLabelMargin.setRight("3px");
        totalLabelStyle.setMargin(totalLabelMargin);
        totalLabelAp.setStyle(totalLabelStyle);
        totalLabelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"PanelUtils_20", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        totalFlexPanelAp.getItems().add(totalLabelAp);
    }

    public void getDataSelf(FlexPanelAp dataFlexPanelAp, int count) {
        dataFlexPanelAp.setKey("dataFlexPanelAp" + count);
        dataFlexPanelAp.setWidth(new LocaleString("35%"));
        dataFlexPanelAp.setGrow(0);
        dataFlexPanelAp.setShrink(0);
        dataFlexPanelAp.setDirection("column");
        dataFlexPanelAp.setJustifyContent("center");
        dataFlexPanelAp.setAlignItems("flex-start");
        LabelAp labelAp4 = new LabelAp();
        labelAp4.setKey("labelAp4" + count);
        labelAp4.setFontSize(12);
        labelAp4.setForeColor("#ffaa56");
        labelAp4.setName(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u524d:", (String)"EbAdjustMobBillPlugIn_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Style labelApStyle4 = new Style();
        Margin labelApMargin4 = new Margin();
        labelApMargin4.setBottom("3px");
        labelApStyle4.setMargin(labelApMargin4);
        labelAp4.setStyle(labelApStyle4);
        LabelAp labelAp5 = new LabelAp();
        labelAp5.setKey("labelAp5" + count);
        labelAp5.setFontSize(12);
        labelAp5.setForeColor("#ffaa56");
        labelAp5.setName(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u6570:", (String)"EbAdjustMobBillPlugIn_1", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Style style_labelap5 = new Style();
        Margin margin_labelap5 = new Margin();
        margin_labelap5.setBottom("3px");
        style_labelap5.setMargin(margin_labelap5);
        labelAp5.setStyle(style_labelap5);
        LabelAp labelAp6 = new LabelAp();
        labelAp6.setKey("labelAp6" + count);
        labelAp6.setFontSize(12);
        labelAp6.setForeColor("#ffaa56");
        labelAp6.setName(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u540e:", (String)"EbAdjustMobBillPlugIn_2", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        Style labelApStyle6 = new Style();
        Margin labelApMargin6 = new Margin();
        labelApMargin6.setBottom("3px");
        labelApStyle6.setMargin(labelApMargin6);
        labelAp6.setStyle(labelApStyle6);
        dataFlexPanelAp.getItems().add(labelAp4);
        dataFlexPanelAp.getItems().add(labelAp5);
        dataFlexPanelAp.getItems().add(labelAp6);
    }

    public void showTotalAmount(DynamicObject dynamicObject, FlexPanelAp totalAmountAp, int count) {
        DynamicObject period = (DynamicObject)dynamicObject.get(this.getPeriodName());
        String periodNum = period.getString("number");
        String totalData = this.dataMap.get(periodNum);
        String[] totalDataArr = totalData.split("\\|");
        totalAmountAp.setKey("flex_total" + count);
        totalAmountAp.setWidth(new LocaleString("65%"));
        totalAmountAp.setGrow(0);
        totalAmountAp.setShrink(0);
        totalAmountAp.setDirection("column");
        totalAmountAp.setAlignItems("flex-end");
        totalAmountAp.setAlignContent("flex-end");
        Style adjustStyle = new Style();
        Padding totalPadding = new Padding();
        totalPadding.setRight("8px");
        adjustStyle.setPadding(totalPadding);
        totalAmountAp.setStyle(adjustStyle);
        LabelAp budgetDataLabel = new LabelAp();
        budgetDataLabel.setKey("budget_data_labelap" + count);
        budgetDataLabel.setFontSize(12);
        budgetDataLabel.setForeColor("#999999");
        BigDecimal budgetData = new BigDecimal(totalDataArr[0]);
        budgetDataLabel.setName(new LocaleString(AbstractAdjustMobBillPlugin.getStringData(budgetData)));
        Style labelApStyle6 = new Style();
        Margin labelApMargin7 = new Margin();
        labelApMargin7.setBottom("3px");
        labelApStyle6.setMargin(labelApMargin7);
        budgetDataLabel.setStyle(labelApStyle6);
        LabelAp adjustDataLabel = new LabelAp();
        adjustDataLabel.setKey("adjust_data_labelap" + count);
        adjustDataLabel.setFontSize(12);
        adjustDataLabel.setForeColor("#999999");
        BigDecimal adjustData = new BigDecimal(totalDataArr[1]);
        adjustDataLabel.setName(new LocaleString(AbstractAdjustMobBillPlugin.getStringData(adjustData)));
        Style labelApStyle8 = new Style();
        Margin labelApMargin8 = new Margin();
        labelApMargin8.setBottom("3px");
        labelApStyle8.setMargin(labelApMargin8);
        adjustDataLabel.setStyle(labelApStyle8);
        LabelAp finalDataLabel = new LabelAp();
        finalDataLabel.setKey("final_data_labelap" + count);
        finalDataLabel.setFontSize(12);
        finalDataLabel.setForeColor("#999999");
        BigDecimal finalData = new BigDecimal(totalDataArr[2]);
        finalDataLabel.setName(new LocaleString(AbstractAdjustMobBillPlugin.getStringData(finalData)));
        Style labelApStyle9 = new Style();
        Margin labelApMargin9 = new Margin();
        labelApMargin9.setBottom("3px");
        labelApStyle9.setMargin(labelApMargin9);
        finalDataLabel.setStyle(labelApStyle9);
        totalAmountAp.getItems().add(budgetDataLabel);
        totalAmountAp.getItems().add(adjustDataLabel);
        totalAmountAp.getItems().add(finalDataLabel);
    }

    public static String getStringData(BigDecimal adjustData) {
        BigDecimal bigDecimal = adjustData.setScale(2, 4);
        String plainString = bigDecimal.toPlainString();
        String[] split = plainString.split("\\.");
        String substring = split[1].substring(0, 2);
        BigDecimal decimal = new BigDecimal(split[0]);
        DecimalFormat decimalFormat = new DecimalFormat("#,###");
        return decimalFormat.format(decimal) + "." + substring;
    }

    public abstract int getCustomDimCount();

    public abstract String getPeriodName();

    public abstract String getFlexPanelApId();
}

