/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.adjust.validator.AbstractAdjustValidator;
import kd.epm.eb.business.adjust.validator.AdjustBillOpValidator;
import kd.epm.eb.business.adjust.validator.IAdjustValidatorSource;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.billimpexp.star.BillExportStart;
import kd.epm.eb.formplugin.billimpexp.util.BillImpExpStarFactory;
import kd.epm.eb.formplugin.custominterface.EpmCustomInterface;
import kd.epm.eb.formplugin.filterContainerModelListPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustBillListPlugin
extends filterContainerModelListPlugin
implements BeforeF7SelectListener {
    private final String formType_adjust = "1";
    private final String formType_adjpst = "2";
    private static Log log = LogFactory.getLog(AdjustBillListPlugin.class);
    private Boolean isCheckOrg = null;

    public void initialize() {
        super.initialize();
    }

    private boolean isCheckOrg() {
        if (this.isCheckOrg == null) {
            IFormView formView = this.getView();
            if (formView == null) {
                return false;
            }
            String entityId = ((ListView)formView).getBillFormId();
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entityId);
            if (formConfig != null) {
                List plugins = formConfig.getPlugins();
                try {
                    for (Plugin plugin : plugins) {
                        Object instance;
                        String className = plugin.getClassName();
                        if (className == null || !plugin.isEnabled() || !((instance = TypesContainer.createInstance((String)className)) instanceof EpmCustomInterface)) continue;
                        EpmCustomInterface customInterface = (EpmCustomInterface)instance;
                        this.isCheckOrg = customInterface.isCheckOrg();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.isCheckOrg == null ? false : this.isCheckOrg;
    }

    private boolean isEB() {
        return AdjustUtil.isEB(this.getView(), this.getModelId());
    }

    private boolean isBGModel() {
        return AdjustUtil.isBG(this.getView(), this.getModelId());
    }

    private boolean isBgm() {
        return AdjustUtil.isBgm(this.getView(), this.getModelId());
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String modelIdStr;
        List modelFilterList;
        List commonFilterColumns = args.getCommonFilterColumns();
        List modelFilterColumns = commonFilterColumns.stream().filter(e -> "model.name".equals(e.getFieldName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(modelFilterColumns)) {
            return;
        }
        CommonFilterColumn modelFilterColumn = (CommonFilterColumn)modelFilterColumns.get(0);
        ControlFilters controlFilters = modelFilterColumn.getContext().getControlFilters();
        if (controlFilters != null && CollectionUtils.isNotEmpty((Collection)(modelFilterList = controlFilters.getFilter("model.id"))) && kd.bos.util.StringUtils.isNotEmpty((String)(modelIdStr = modelFilterList.get(0).toString()))) {
            this.getPageCache().put("KEY_MODEL_ID", modelIdStr);
        }
        if (this.isBGModel()) {
            commonFilterColumns.removeIf(filterColumn -> "bizmodel.name".equals(filterColumn.getFieldName()));
        }
        List<QFilter> modelQFilters = this.getModelQFilter();
        if (this.isCheckOrg()) {
            modelQFilters.clear();
            modelQFilters.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
        }
        Map modelMap = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]));
        ArrayList modelList = new ArrayList(modelMap.size());
        HashSet modelIds = new HashSet(modelMap.size());
        modelFilterColumn.getComboItems().clear();
        modelMap.values().forEach(e -> {
            modelIds.add(e.getLong("id"));
            modelList.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id")));
        });
        if (CollectionUtils.isNotEmpty(modelList)) {
            Long modelId;
            modelFilterColumn.setComboItems(modelList);
            if (kd.bos.util.StringUtils.isNotEmpty((String)this.getPageCache().get("KEY_MODEL_ID"))) {
                modelFilterColumn.setDefaultValue(this.getPageCache().get("KEY_MODEL_ID"));
            } else {
                modelFilterColumn.setDefaultValue(((ComboItem)modelList.get(0)).getValue());
            }
            if (this.getPageCache().get("KEY_MODEL_ID") == null) {
                modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
                if (IDUtils.isNotNull((Long)modelId) && modelIds.contains(modelId)) {
                    modelFilterColumn.setDefaultValue(modelId.toString());
                    this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                } else {
                    this.getPageCache().put("KEY_MODEL_ID", ((ComboItem)modelList.get(0)).getValue());
                }
            }
            modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
            boolean specialBGRPApp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
            if (modelId != 0L && (this.isBgm() || this.isBGModel() || specialBGRPApp)) {
                DynamicObjectCollection bizModelList = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)modelId)}, (String)"createdate desc");
                if (bizModelList.isEmpty()) {
                    return;
                }
                boolean newEbModel = NewEbAppUtil.isNewEbModel((Long)modelId);
                if (this.isBgm() || !newEbModel) {
                    List bizModelFilterColumns = commonFilterColumns.stream().filter(e -> e.getFieldName().equals("bizmodel.name")).collect(Collectors.toList());
                    CommonFilterColumn bizModelFilterColumn = (CommonFilterColumn)bizModelFilterColumns.get(0);
                    bizModelFilterColumn.getComboItems().clear();
                    Long userSelectModelBizModelId = UserSelectUtils.getUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId());
                    String bizModelId = "";
                    HashSet bizModelIds = new HashSet(bizModelList.size());
                    ArrayList bizModelComboItems = new ArrayList(16);
                    bizModelList.forEach(dynamicObject -> {
                        bizModelIds.add(dynamicObject.getLong("id"));
                        bizModelComboItems.add(new ComboItem(new LocaleString(dynamicObject.getString("name")), dynamicObject.getString("id")));
                    });
                    if (!bizModelComboItems.isEmpty()) {
                        bizModelId = ((ComboItem)bizModelComboItems.get(0)).getValue();
                    }
                    if (IDUtils.isNotNull((Long)userSelectModelBizModelId) && bizModelIds.contains(userSelectModelBizModelId)) {
                        bizModelId = String.valueOf(userSelectModelBizModelId);
                    }
                    bizModelFilterColumn.setDefaultValue(bizModelId);
                    bizModelFilterColumn.setComboItems(bizModelComboItems);
                    this.getPageCache().put("KEY_BUSMODEL_ID", bizModelId);
                } else {
                    DynamicObject bizModel = (DynamicObject)bizModelList.get(0);
                    long bizModelId = bizModel.getLong("id");
                    this.getPageCache().put("KEY_BUSMODEL_ID", Long.toString(bizModelId));
                    if (specialBGRPApp) {
                        commonFilterColumns.removeIf(filterColumn -> "bizmodel.name".equals(filterColumn.getFieldName()));
                    }
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u4efb\u4f55\u4f53\u7cfb\u3002", (String)"AdjustRuleListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean isCheckModel() {
        return !this.isCheckOrg();
    }

    private List<QFilter> getModelQFilter() {
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>(16);
        modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
        return modelQFilters;
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            if ("model.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                Long modelId = IDUtils.toLong(((List)currentCommonFilter.get("Value")).get(0));
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
            } else if ("bizmodel.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                Long bizModelId = IDUtils.toLong(((List)currentCommonFilter.get("Value")).get(0));
                UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId(), (long)bizModelId);
                this.getPageCache().put("KEY_BUSMODEL_ID", String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
            }
        }
    }

    @Override
    protected Map<String, List<String>> getResetContainerFilterMap() {
        ArrayList<String> modelFilterList = new ArrayList<String>(16);
        if (this.isBgm() || NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView()) && !NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            modelFilterList.add("bizmodel.id");
        }
        modelFilterList.add("billstatus");
        HashMap<String, List<String>> resetContainerFilterMap = new HashMap<String, List<String>>(16);
        resetContainerFilterMap.put("model.id", modelFilterList);
        return resetContainerFilterMap;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if ("bizmodel.id".equals(fieldName)) {
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("model.id", "=", (Object)IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"))));
        } else if ("model.id".equals(fieldName)) {
            Object specialApp = this.getView().getFormShowParameter().getCustomParam("app_special");
            if (specialApp != null) {
                args.addCustomParam("app_special", specialApp);
            }
            List<QFilter> modelQFilter = this.getModelQFilter();
            if (this.isCheckOrg()) {
                modelQFilter.clear();
                this.getPageCache().put("noNeedDefaultQFilter", "true");
                modelQFilter.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
            }
            args.getQfilters().addAll(modelQFilter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter showParameter = e.getParameter();
        boolean specialBGRPApp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
        long modelId = this.getModelId();
        if (showParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AdjustBillListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                showParameter.setCustomParam("model", (Object)this.getModelId());
                if (this.isBgm() || this.isBGModel() || specialBGRPApp) {
                    long bizModelId = this.getBizModelId();
                    if (bizModelId == 0L) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"AdjustBillListPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    showParameter.setCustomParam("bizmodel", (Object)this.getBizModelId());
                    BillList billlistap = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
                    if (selectedRows.size() == 1) {
                        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)showParameter.getFormId());
                        Long applier = dynamicObject.getLong("applier.id");
                        showParameter.setCustomParam("applier", (Object)String.valueOf(applier));
                    }
                }
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String hiddenKey = this.isBgm() || this.isBGModel() || NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView()) ? "year.name" : "budgetperiods.name";
        List columns = args.getListColumns();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            IListColumn column = (IListColumn)iterator.next();
            if (!hiddenKey.equals(column.getListFieldKey())) continue;
            iterator.remove();
        }
        args.setListColumns(columns);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        Long modelId = this.getModelId();
        QFilter qBillType = new QFilter("billtype", "=", (Object)this.getFormType());
        e.getQFilters().add(qBillType);
        QFilter qModelAndBuilder = new QFilter("model.id", "=", (Object)modelId);
        e.getQFilters().add(qModelAndBuilder);
        if (this.isBgm()) {
            QFilter qBizModel = new QFilter("bizmodel.id", "=", (Object)this.getBizModelId());
            e.getQFilters().add(qBizModel);
        }
        List dataPermQFilters = e.getDataPermQFilters();
        e.setDataPermQFilters(new ArrayList(16));
        Set manageModelIds = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)ModelUtil.queryApp((IFormView)this.getView()));
        if (!manageModelIds.contains(modelId)) {
            Long userId = UserUtils.getUserId();
            QFilter user = new QFilter("applier.id", "=", (Object)userId).or("handler.id", "=", (Object)userId);
            if (dataPermQFilters != null) {
                log.info("AdjustBillListPlugin_preDataPermFilter: " + dataPermQFilters);
                QFilter qFilter = null;
                for (QFilter dataPermQFilter : dataPermQFilters) {
                    if (dataPermQFilter == null) continue;
                    if (qFilter == null) {
                        qFilter = new QFilter(dataPermQFilter.getProperty(), dataPermQFilter.getCP(), dataPermQFilter.getValue());
                    }
                    List qFilterNestList = dataPermQFilter.getNests(true);
                    for (QFilter.QFilterNest qFilterNest : qFilterNestList) {
                        String property = qFilterNest.getFilter().getProperty();
                        if ("model".equals(property)) continue;
                        if (qFilterNest.isAnd()) {
                            qFilter.and(qFilterNest.getFilter());
                            continue;
                        }
                        qFilter.or(qFilterNest.getFilter());
                    }
                }
                user.or(qFilter);
                log.info("AdjustBillListPlugin_setFilter: " + user);
            }
            e.getQFilters().add(user);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "btn_import": {
                if (Long.valueOf(0L).equals(this.getModelId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.importBill();
                break;
            }
            case "btn_export": {
                if (Long.valueOf(0L).equals(this.getModelId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.exportBill();
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        ListSelectedRowCollection rows = args.getListSelectedData();
        if (opType.equals("copy")) {
            if (rows.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"AdjustBillListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (opType.equals("submit")) {
            DynamicObject[] passedBills;
            LogStats stats = new LogStats("adjustBillList-submit-log:");
            stats.addInfo("adjustBillList-submit-start.");
            ArrayList<Long> rowIds = new ArrayList<Long>(10);
            for (ListSelectedRow row : rows) {
                Long id = (Long)row.getPrimaryKeyValue();
                rowIds.add(id);
            }
            boolean isBgm = this.isBgm();
            boolean isEb = this.isEB();
            boolean isBG = this.isBGModel();
            boolean isBgrp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])rowIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(isBgm || isBG || isBgrp ? "bgm_adjustbill" : "eb_adjustbill")));
            AbstractAdjustValidator instance = AbstractAdjustValidator.getInstance((IAdjustValidatorSource)new AdjustBillOpValidator(isEb), (String)"submit");
            Map errorInfos = instance.validateList(isEb, bills);
            stats.add("validateList end.");
            HashSet<String> passedBillIds = new HashSet<String>();
            for (DynamicObject bill : bills) {
                if (errorInfos != null && errorInfos.containsKey(bill.getString("billno"))) continue;
                passedBillIds.add(String.valueOf(bill.getPkValue()));
            }
            int allNum = rows.size();
            if (errorInfos != null && errorInfos.size() > 0) {
                int failNum = errorInfos.size();
                int sussNum = allNum - failNum;
                if (sussNum == 0) {
                    String title = ResManager.loadResFormat((String)"\u5171%1\u5f20\u5355\u636e\uff0c\u6210\u529f%2\u6761\uff0c\u5931\u8d25%3\u6761\u3002", (String)"AdjustBillListPlugin_2_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{allNum, sussNum, failNum});
                    CommonServiceHelper.showErrorInfoFormWithTitle((IFormView)this.getView(), new ArrayList(errorInfos.values()), (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ed3\u679c", (String)"AdjustBillListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)title, (boolean)true);
                    args.setCancel(true);
                } else {
                    Iterator iterator = rows.iterator();
                    while (iterator.hasNext()) {
                        ListSelectedRow row = (ListSelectedRow)iterator.next();
                        if (passedBillIds.contains(String.valueOf(row.getPrimaryKeyValue()))) continue;
                        iterator.remove();
                    }
                }
            }
            Set passedBillIdLongs = IDUtils.toLongs(passedBillIds);
            for (DynamicObject adjustBill : passedBills = BusinessDataServiceHelper.load((Object[])passedBillIdLongs.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)(isBgm || isBG || isBgrp ? "bgm_adjustbill" : "eb_adjustbill")))) {
                String billStatus = adjustBill.getString("billstatus");
                if (AdjustBillStateEnum.NOPASS.getShortNumber().equals(billStatus)) {
                    adjustBill.set("billstatus", (Object)AdjustBillStateEnum.SAVE.getShortNumber());
                }
                AdjustUtil.fillEntityBailOrg(this.getModelId(), adjustBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustBill});
            }
            this.getPageCache().put("submitRowCount", String.valueOf(allNum));
            this.getPageCache().put("submitErrorInfos", errorInfos == null ? "" : SerializationUtils.serializeToBase64(new ArrayList(errorInfos.values())));
            stats.addInfo("adjustBillList-submit-end.");
            log.info(stats.toString());
        } else if ("invalid".equals(opType)) {
            String invalidNeedConfirm = this.getPageCache().get("invalidNeedConfirm");
            if (kd.bos.util.StringUtils.isEmpty((String)invalidNeedConfirm)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5e9f\u5f03\u540e\uff0c\u8bb0\u5f55\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u786e\u5b9a\u8981\u5e9f\u5f03\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"AdjustBillListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("invalidConfirm", (IFormPlugin)this));
                args.setCancel(true);
            } else {
                this.getPageCache().remove("invalidNeedConfirm");
            }
        }
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        Long modelId = 0L;
        if (kd.bos.util.StringUtils.isNotEmpty((String)strModelId)) {
            modelId = Long.valueOf(strModelId);
        }
        return modelId;
    }

    public Long getBizModelId() {
        String strBizModelId = this.getPageCache().get("KEY_BUSMODEL_ID");
        Long bizModelId = 0L;
        if (kd.bos.util.StringUtils.isNotEmpty((String)strBizModelId)) {
            bizModelId = Long.valueOf(strBizModelId);
        }
        return bizModelId;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey;
        super.afterDoOperation(eventArgs);
        switch (operateKey = eventArgs.getOperateKey()) {
            case "submit": {
                int submitRowCount = this.getPageCache().get("submitRowCount") == null ? 0 : Integer.parseInt(this.getPageCache().get("submitRowCount"));
                String submitInfos = this.getPageCache().get("submitErrorInfos");
                List<String> submitErrorInfos = StringUtils.isEmpty((String)submitInfos) ? new ArrayList(1) : (List)SerializationUtils.deSerializeFromBase64((String)submitInfos);
                OperationResult result = eventArgs.getOperationResult();
                result.getAllErrorInfo().forEach(error -> submitErrorInfos.add(error.getMessage()));
                boolean hasError = false;
                if (result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null) {
                    Object fo;
                    HashMap<String, String> billNo = new HashMap<String, String>(16);
                    if (eventArgs.getSource() instanceof FormOperate && (fo = (FormOperate)eventArgs.getSource()).getListSelectedData() != null) {
                        for (Object row : fo.getListSelectedData()) {
                            billNo.put(String.valueOf(row.getPrimaryKeyValue()), row.getNumber());
                        }
                    }
                    for (ValidateResult v : result.getValidateResult().getValidateErrors()) {
                        if (v.getAllErrorInfo() == null) continue;
                        for (OperateErrorInfo error2 : v.getAllErrorInfo()) {
                            String number = (String)billNo.get(String.valueOf(error2.getPkValue()));
                            if (StringUtils.isEmpty((String)number)) {
                                submitErrorInfos.add(error2.getMessage());
                                hasError = true;
                                continue;
                            }
                            hasError = true;
                            submitErrorInfos.add(ResManager.loadResFormat((String)"\u5355\u636e\uff08%1\uff09%2", (String)"AdjustBillListPlugin_11_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{number, error2.getMessage()}));
                        }
                    }
                }
                if (!hasError && !result.isSuccess() && result.getAllErrorInfo().isEmpty() && StringUtils.isNotEmpty((String)result.getMessage())) {
                    submitErrorInfos.add(result.getMessage());
                }
                int succCount = result.getSuccessPkIds().size();
                int failCount = submitRowCount - succCount;
                String title = ResManager.loadResFormat((String)"\u5171%1\u5f20\u5355\u636e\uff0c\u6210\u529f%2\u6761\uff0c\u5931\u8d25%3\u6761\u3002", (String)"AdjustBillListPlugin_2_repair", (String)"epm-eb-formplugin", (Object[])new Object[]{submitRowCount, succCount, failCount});
                if (failCount > 0) {
                    result.setShowMessage(false);
                    CommonServiceHelper.showErrorInfoFormWithTitle((IFormView)this.getView(), submitErrorInfos, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u7ed3\u679c", (String)"AdjustBillListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), (String)title, (boolean)true);
                }
                this.getPageCache().remove("submitRowCount");
                this.getPageCache().remove("submitErrorInfos");
                break;
            }
            case "refresh": {
                this.clearImportCache();
                this.refreshBill();
                break;
            }
            case "unsubmit": {
                break;
            }
            case "invalid": {
                Object o;
                DynamicObject dynamicObject;
                boolean isSuccess = eventArgs.getOperationResult().getValidateResult().isSuccess();
                if (!isSuccess || (dynamicObject = BusinessDataServiceHelper.loadSingle(o = eventArgs.getOperationResult().getSuccessPkIds().get(0), (String)"bgm_adjustbill")) == null) break;
                dynamicObject.set("handler", (Object)0L);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                break;
            }
        }
    }

    private String getFormType() {
        String formType = (String)this.getView().getFormShowParameter().getCustomParam("formType");
        if (formType != null && formType.equals("2")) {
            return "2";
        }
        return "1";
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                long t1 = System.currentTimeMillis();
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                ArrayList pkId = new ArrayList(16);
                collection.forEach(v -> pkId.add(String.valueOf(v.getPkValue())));
                if (pkId.size() > 0) {
                    try {
                        AdjustBillListPlugin.this.setNextAuditor(collection, pkId);
                    }
                    catch (Exception e) {
                        log.info("ErWorkFlowFlexListForOtherPlugin >>>>> \u8bbe\u7f6e\u5ba1\u6279\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38");
                    }
                }
                long t2 = System.currentTimeMillis();
                log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
                return collection;
            }
        });
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> pkId) {
        Map<String, String> auditorsNameMap = this.getNextAuditor(pkId);
        for (DynamicObject doc : collection) {
            String pkIdTemp = String.valueOf(doc.getPkValue());
            try {
                if (auditorsNameMap.get(pkIdTemp) == null) continue;
                doc.set("handlertext", (Object)auditorsNameMap.get(pkIdTemp));
            }
            catch (Exception e) {
                log.info("\u4e0b\u4e00\u6b65\u5ba1\u6279\u4eba\u5b57\u6bb5\u5728\u5217\u8868\u4e2d\u4e0d\u5b58\u5728");
            }
        }
    }

    private Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            String pkid = (String)entry.getKey();
            List node = (List)entry.getValue();
            node.forEach(e -> {
                String nodeStr = e.getCurrentNodeName();
                String auditor = e.getParticipantName();
                if (auditor != null && !"".equals(auditor.trim())) {
                    nodeStr = nodeStr + " / " + auditor;
                }
                nodeMap.put(pkid, nodeStr);
            });
        }
        return nodeMap;
    }

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    private void refreshBill() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
        this.clearImportCache();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("importPage".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void importBill() {
        String entityName;
        String entityKey;
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importPage");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("model", this.getModelId());
        boolean specialBGRPApp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
        if (this.isBgm() || this.isBGModel() || specialBGRPApp) {
            boolean isBGRPBgModel;
            entityKey = "bgm_adjustbill";
            entityName = ResManager.loadKDString((String)"\u5168\u9762\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            boolean bl = isBGRPBgModel = specialBGRPApp && NewEbAppUtil.isNewEbModel((Long)this.getModelId());
            if (this.isBGModel() || isBGRPBgModel) {
                entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            if ("2".equals(this.getFormType())) {
                entityKey = "bgm_adjpstbill";
                entityName = ResManager.loadKDString((String)"\u5168\u9762\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (this.isBGModel() || isBGRPBgModel) {
                    entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
            paramMap.put("bizmodel", this.getBizModelId());
            paramMap.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.OverallBudgetAdjustImportPlugin");
        } else {
            entityKey = "eb_adjustbill";
            entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if ("2".equals(this.getFormType())) {
                entityKey = "eb_adjpstbill";
                entityName = ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            paramMap.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.ExpenseBudgetAdjustImportPlugin");
        }
        paramMap.put("billtype", this.getFormType());
        BillImpExpUtils.openImportPage((IFormView)this.getView(), (String)entityKey, (String)entityName, paramMap, (CloseCallBack)callBack);
    }

    private void exportBill() {
        String billKey;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        boolean specialBGRPApp = NewEbAppUtil.isSpecialBGRPApp((IFormView)this.getView());
        params.put("model", this.getModelId());
        if (this.isBgm() || this.isBGModel() || specialBGRPApp) {
            billKey = "bgm_adjustbill";
            if ("2".equals(this.getFormType())) {
                billKey = "bgm_adjpstbill";
            }
            params.put("bizmodel", this.getBizModelId());
            params.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.OverallBudgetAdjustExportPlugin");
        } else {
            billKey = "eb_adjustbill";
            if ("2".equals(this.getFormType())) {
                billKey = "eb_adjpstbill";
            }
            params.put("IMPORTHANDLERCLASSNAME", "kd.epm.eb.formplugin.bgadjust.impexp.ExpenseBudgetAdjustExportPlugin");
        }
        params.put("billtype", this.getFormType());
        params.put("EXPORTBILLLISTKEY", "billlistap");
        BillExportStart exportStart = BillImpExpStarFactory.getExportStart(billKey, params);
        exportStart.exportData(this.getView(), params);
    }

    private void clearImportCache() {
        long modelId = this.getModelId();
        this.getPageCache().put("header" + modelId, null);
        this.getPageCache().put("dimInfo" + modelId, null);
        this.getPageCache().put("bgmheader" + modelId, null);
        this.getPageCache().put("bgmdimInfo" + modelId, null);
    }

    @Override
    protected String getModelIDFilterKey() {
        return "model.id";
    }

    @Override
    protected String getModelFilterKey() {
        return "model.name";
    }

    public String getBGRPSpecialEntity() {
        return null;
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        block7: {
            String itemKey;
            block6: {
                super.beforeItemClick(evt);
                itemKey = evt.getItemKey();
                AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
                if (!"btn_delete".equals(itemKey)) break block6;
                BillList billlistap = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"AdjustBillListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                } else {
                    for (ListSelectedRow selectedRow : selectedRows) {
                        String billStatus = selectedRow.getBillStatus();
                        if ("A".equals(billStatus) || "D".equals(billStatus) || "H".equals(billStatus)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u201c\u6682\u5b58\u201d\u3001\u201c\u5ba1\u6838\u4e0d\u901a\u8fc7\u201d\u3001\u201c\u5e9f\u5f03\u201d\u7684\u5355\u636e\u3002", (String)"AdjustBillListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                break block7;
            }
            if (!"btn_dumped".equals(itemKey)) break block7;
            BillList billlistap = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"AdjustBillListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                for (ListSelectedRow selectedRow : selectedRows) {
                    String billStatus = selectedRow.getBillStatus();
                    if ("A".equals(billStatus)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5e9f\u5f03\u201c\u6682\u5b58\u201d\u6216\u201c\u88ab\u9a73\u56de\u201d\u7684\u5355\u636e\u3002", (String)"AdjustBillListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        String callBackId = event.getCallBackId();
        if ("invalidConfirm".equals(callBackId) && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getPageCache().put("invalidNeedConfirm", "false");
            this.getView().invokeOperation("invalid");
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            args.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(args);
    }
}

