/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class AdjustRuleEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
CellClickListener {
    private static final String TOOL_BAR_AP = "toolbarap";
    private static final String BIZ_MODEL = "bizmodel";
    private static final String DATASET = "dataset";
    private static final String ADJ_ENTITY = "adjentity";
    private static final String ADJ_ACCOUNT = "adjaccount";
    private static final String ADJ_METRIC = "adjmetric";
    private static final String ASSIGN_TYPE = "assigntype";
    private static final String USER_NAME = "username";
    protected static final String CUSTOM_DIMS_INFO_CACHE = "customDimsInfoCache";

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setModelValue();
        this.buildCustomDims();
        boolean bgModel = ModelUtil.isBGModel((Long)this.getModelId());
        if (bgModel) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BIZ_MODEL});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildCustomDims();
        this.changeCustomDimStyle();
        this.showAssignUser();
        boolean bgModel = ModelUtil.isBGModel((Long)this.getModelId());
        if (bgModel) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BIZ_MODEL});
        }
    }

    private void showAssignUser() {
        String assignType = (String)this.getModel().getValue(ASSIGN_TYPE);
        if ("1".equals(assignType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{USER_NAME});
        }
    }

    private void setModelValue() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        if (modelId != null) {
            this.getModel().setValue("model", (Object)modelId);
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model", "=", (Object)modelId));
            qfBuilder.add(new QFilter("number", "=", (Object)BizModelEnum.AUNNALBUDGET.getNumber()));
            DynamicObject bizModel = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"id, name, number", (QFilter[])qfBuilder.toArrays());
            this.getModel().setValue(BIZ_MODEL, (Object)bizModel);
        }
    }

    private void buildCustomDims() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6", "adjcustomdim7", "adjcustomdim8", "adjcustomdim9", "adjcustomdim10", "adjcustomdim11", "adjcustomdim12", "adjcustomdim13", "adjcustomdim14", "adjcustomdim15", "adjcustomdim16", "adjcustomdim17", "adjcustomdim18", "adjcustomdim19", "adjcustomdim20", "adjcustomdim21", "adjcustomdim22", "adjcustomdim23", "adjcustomdim24", "adjcustomdim25", "adjcustomdim26", "adjcustomdim27", "adjcustomdim28", "adjcustomdim29", "adjcustomdim30", "adjcustomdim31", "adjcustomdim32", "adjcustomdim33", "adjcustomdim34", "adjcustomdim35", "adjcustomdim36", "adjcustomdim37", "adjcustomdim38", "adjcustomdim39", "adjcustomdim40", "adjcustomdim41", "adjcustomdim42", "adjcustomdim43", "adjcustomdim44", "adjcustomdim45", "adjcustomdim46", "adjcustomdim47", "adjcustomdim48", "adjcustomdim49", "adjcustomdim50"});
        DynamicInfoCollection customDimList = AdjustHelper.buildCustomDimInfo((Long)this.getModelId(), (Long)this.getBizModelId());
        if (!customDimList.isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            for (DynamicInfoCollection.InfoObject dimInfo : customDimList.getValues()) {
                String controlKey = (String)dimInfo.getValueByPropName("controlkey");
                String name = (String)dimInfo.getValueByPropName("name");
                entryGrid.setColumnProperty(controlKey, "header", (Object)new LocaleString(name));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{controlKey});
            }
        }
        this.getPageCache().put(CUSTOM_DIMS_INFO_CACHE, SerializationUtils.serializeToBase64((Object)customDimList));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BAR_AP});
        this.addClickListeners(new String[]{USER_NAME, ADJ_ENTITY, ADJ_ACCOUNT, ADJ_METRIC, "adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6", "adjcustomdim7", "adjcustomdim8", "adjcustomdim9", "adjcustomdim10", "adjcustomdim11", "adjcustomdim12", "adjcustomdim13", "adjcustomdim14", "adjcustomdim15", "adjcustomdim16", "adjcustomdim17", "adjcustomdim18", "adjcustomdim19", "adjcustomdim20", "adjcustomdim21", "adjcustomdim22", "adjcustomdim23", "adjcustomdim24", "adjcustomdim25", "adjcustomdim26", "adjcustomdim27", "adjcustomdim28", "adjcustomdim29", "adjcustomdim30", "adjcustomdim31", "adjcustomdim32", "adjcustomdim33", "adjcustomdim34", "adjcustomdim35", "adjcustomdim36", "adjcustomdim37", "adjcustomdim38", "adjcustomdim39", "adjcustomdim40", "adjcustomdim41", "adjcustomdim42", "adjcustomdim43", "adjcustomdim44", "adjcustomdim45", "adjcustomdim46", "adjcustomdim47", "adjcustomdim48", "adjcustomdim49", "adjcustomdim50"});
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addCellClickListener((CellClickListener)this);
        this.addF7SelectListeners(BIZ_MODEL, "datatype", "changetype", "currency", DATASET, "budgetperiods");
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propKey = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (propKey) {
            case "bizmodel": {
                this.getModel().deleteEntryData("entryentity");
                this.buildCustomDims();
                break;
            }
            case "assigntype": {
                if (newValue == null) break;
                if ("1".equals(newValue)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{USER_NAME});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{USER_NAME});
                this.getModel().setValue(USER_NAME, (Object)"");
                this.getModel().setValue("userid", (Object)"");
                break;
            }
            case "dataset": {
                this.clearAccount();
                this.changeCustomDimStyle();
                break;
            }
            case "username": {
                if (!"".equals(newValue)) break;
                this.getModel().setValue("userid", (Object)"");
                break;
            }
            case "adjentity": 
            case "adjaccount": 
            case "adjmetric": 
            case "adjcustomdim1": 
            case "adjcustomdim2": 
            case "adjcustomdim3": 
            case "adjcustomdim4": 
            case "adjcustomdim5": 
            case "adjcustomdim6": 
            case "adjcustomdim7": 
            case "adjcustomdim8": 
            case "adjcustomdim9": 
            case "adjcustomdim10": 
            case "adjcustomdim11": 
            case "adjcustomdim12": 
            case "adjcustomdim13": 
            case "adjcustomdim14": 
            case "adjcustomdim15": 
            case "adjcustomdim16": 
            case "adjcustomdim17": 
            case "adjcustomdim18": 
            case "adjcustomdim19": 
            case "adjcustomdim20": 
            case "adjcustomdim21": 
            case "adjcustomdim22": 
            case "adjcustomdim23": 
            case "adjcustomdim24": 
            case "adjcustomdim25": 
            case "adjcustomdim26": 
            case "adjcustomdim27": 
            case "adjcustomdim28": 
            case "adjcustomdim29": 
            case "adjcustomdim30": 
            case "adjcustomdim31": 
            case "adjcustomdim32": 
            case "adjcustomdim33": 
            case "adjcustomdim34": 
            case "adjcustomdim35": 
            case "adjcustomdim36": 
            case "adjcustomdim37": 
            case "adjcustomdim38": 
            case "adjcustomdim39": 
            case "adjcustomdim40": 
            case "adjcustomdim41": 
            case "adjcustomdim42": 
            case "adjcustomdim43": 
            case "adjcustomdim44": 
            case "adjcustomdim45": 
            case "adjcustomdim46": 
            case "adjcustomdim47": 
            case "adjcustomdim48": 
            case "adjcustomdim49": 
            case "adjcustomdim50": {
                this.entryChange(propKey);
                break;
            }
        }
    }

    private void entryChange(String propKey) {
        Object value = this.getModel().getValue(propKey);
        if (value == null || StringUtils.isEmpty((String)String.valueOf(value))) {
            this.getModel().setValue(propKey.substring(3), null);
        }
    }

    private void clearAccount() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        int selectRow = selectRows[0];
        this.getModel().setValue("account", null, selectRow);
        this.getModel().setValue(ADJ_ACCOUNT, null, selectRow);
    }

    private void changeCustomDimStyle() {
        int rowCounts = this.getModel().getEntryRowCount("entryentity");
        String customDimStr = this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE);
        if (StringUtils.isEmpty((String)customDimStr)) {
            return;
        }
        DynamicInfoCollection customDimList = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
        for (DynamicInfoCollection.InfoObject customDim : customDimList.getValues()) {
            String dimId = (String)customDim.getValueByPropName("id");
            String controlKey = (String)customDim.getValueByPropName("controlkey");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{controlKey});
            for (int i = 0; i < rowCounts; ++i) {
                DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", i);
                Long datasetId = rowObj.getLong("dataset.id");
                DynamicInfoCollection rowCustomDimList = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDimList, (Long)this.getModelId(), (Long)datasetId);
                HashSet<String> dimIds = new HashSet<String>(16);
                for (DynamicInfoCollection.InfoObject rowCustomDim : rowCustomDimList.getValues()) {
                    String rowDimId = (String)rowCustomDim.getValueByPropName("id");
                    dimIds.add(rowDimId);
                }
                if (!dimIds.contains(dimId)) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{controlKey});
                    this.getModel().setValue(controlKey, null, i);
                    continue;
                }
                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{controlKey});
            }
        }
    }

    private void addF7SelectListeners(String ... f7Keys) {
        for (String f7Key : f7Keys) {
            BasedataEdit f7 = (BasedataEdit)this.getControl(f7Key);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilterList = listShowParameter.getListFilterParameter().getQFilters();
        if (BIZ_MODEL.equals(propName)) {
            long modelId = this.getModelId();
            if (modelId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AdjustRuleEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BIZ_MODEL);
            listShowParameter.setCloseCallBack(closeCallBack);
        } else if (DATASET.equals(propName)) {
            qFilterList.add(new QFilter("model", "=", (Object)this.getModelId()));
            long bizModelId = this.getBizModelId();
            if (bizModelId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"AdjustRuleEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            qFilterList.add(new QFilter("businessmodel", "=", (Object)bizModelId));
        } else {
            Long modelId = this.getModelId();
            String dimNumber = this.getCurrentDimNumber(propName);
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(this.getBizModelId());
            f7Param.setViewId(AdjustHelper.getDimDefaultViewId((Long)modelId, (Long)this.getBizModelId(), (String)dimNumber));
            f7Param.setSwitchViewBySelMem(false);
            f7Param.addCustomFilter(this.getDimQFilter(propName));
            if ("budgetperiods".equals(propName)) {
                f7Param.setMultiSelect(true);
            }
            NewF7Utils.openF7((BeforeF7SelectEvent)beforeF7SelectEvent, (MemberF7Parameter)f7Param);
        }
    }

    private QFilter getDimQFilter(String ctrlKey) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AdjustRuleEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("level", ">", (Object)1);
        qf.and(new QFilter("isleaf", "=", (Object)true));
        if ("datatype".equals(ctrlKey)) {
            qf.and(new QFilter("longnumber", "like", (Object)"DataType!Budget%"));
        } else if ("changetype".equals(ctrlKey)) {
            HashSet<String> noIn = new HashSet<String>();
            noIn.add("Occupation");
            noIn.add("Execute");
            noIn.add("ActualChanges");
            noIn.add("DataIntegration");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Map viewIds = modelCacheHelper.getViewsByBusModel(this.getBizModelId());
            Member actualChangesMember = modelCacheHelper.getMember(SysDimensionEnum.ChangeType.getNumber(), (Long)viewIds.get(SysDimensionEnum.ChangeType.getNumber()), "ActualChanges");
            if (ModelServiceHelper.isBGMDModel((Long)modelId) && actualChangesMember != null) {
                List actualChangesLeafMemNumbers = actualChangesMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList());
                noIn.addAll(actualChangesLeafMemNumbers);
            }
            qf.and(new QFilter("number", "not in", noIn));
        }
        return qf;
    }

    @Override
    public Long getModelId() {
        long modelId = 0L;
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model != null) {
            modelId = model.getLong("id");
        }
        return modelId;
    }

    public Long getBizModelId() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(BIZ_MODEL);
        return bizModel == null ? 0L : bizModel.getLong("id");
    }

    public Long getDatasetId() {
        DynamicObject bizModel = (DynamicObject)this.getModel().getValue(DATASET);
        return bizModel == null ? 0L : bizModel.getLong("id");
    }

    public String getCurrentDimNumber(String controlKey) {
        String dimNum = null;
        if (controlKey.contains("custom")) {
            String customDimStr = this.getPageCache().get(CUSTOM_DIMS_INFO_CACHE);
            DynamicInfoCollection customDims = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
            dimNum = (String)customDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)controlKey);
        } else {
            for (SysDimensionEnum dimensionEnum : SysDimensionEnum.values()) {
                if (!controlKey.contains(dimensionEnum.getNumber().toLowerCase())) continue;
                dimNum = dimensionEnum.getNumber();
            }
        }
        return dimNum;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (ADJ_ENTITY.equals(key) || ADJ_ACCOUNT.equals(key) || ADJ_METRIC.equals(key) || key.startsWith("adjcustomdim")) {
            boolean bgModel = ModelUtil.isBGModel((Long)this.getModelId());
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int rowNum = entryGrid.getSelectRows()[0];
            if (bgModel) {
                DynamicObject val = NewEbAppUtil.getDefaultObj((String)"eb_dataset", (Long)this.getModelId());
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", rowNum);
                entryRowEntity.set(DATASET, (Object)val);
            }
            if (!ADJ_ENTITY.equals(key)) {
                long datasetId = this.getDatasetId();
                if (datasetId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"AdjustRuleEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                long bizModelId = this.getBizModelId();
                if (bizModelId == 0L) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"AdjustRuleEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            this.showSelectDimPanel(key, rowNum);
        } else if (USER_NAME.equals(key)) {
            this.showSelectUserPanel();
        }
    }

    private void showSelectDimPanel(String key, int rowNum) {
        String dimNum = this.getCurrentDimNumber(key);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)this.getModelId()));
        if (ADJ_ACCOUNT.equals(key)) {
            qFilters.add(new QFilter(DATASET, "=", (Object)this.getDatasetId()));
        } else if (ADJ_METRIC.equals(key)) {
            HashSet<String> metricMemNums = new HashSet<String>(3);
            metricMemNums.add(MetricDataTypeEnum.CURRENCY.getIndex());
            metricMemNums.add(MetricDataTypeEnum.NONMONETARY.getIndex());
            metricMemNums.add(MetricDataTypeEnum.RATE.getIndex());
            qFilters.add(new QFilter("datatype", "in", metricMemNums));
        }
        ArrayList<MemberCondition> members = null;
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowNum);
        String dimInfo = rowObj.getString(key.substring(3));
        if (StringUtils.isNotEmpty((String)dimInfo)) {
            String[] dimArr;
            members = new ArrayList<MemberCondition>(16);
            for (String dimStr : dimArr = dimInfo.split(";")) {
                MemberCondition memberCondition;
                String[] perDimArr = dimStr.split("!!");
                String type = perDimArr[1];
                String number = perDimArr[0];
                String name = "";
                if (perDimArr.length > 3) {
                    name = perDimArr[3];
                }
                if (ADJ_ENTITY.equals(key)) {
                    if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
                        number = number.split("!")[1];
                        memberCondition = new MemberCondition(number, name, null, perDimArr[2]);
                        memberCondition.setProp(true);
                        memberCondition.setLongnumber(perDimArr[0]);
                        members.add(memberCondition);
                        continue;
                    }
                    memberCondition = new MemberCondition(number, name, null, perDimArr[2]);
                    members.add(memberCondition);
                    continue;
                }
                memberCondition = new MemberCondition(number, perDimArr[2], null, perDimArr[1]);
                members.add(memberCondition);
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        RangeF7Param param = new RangeF7Param();
        param.setCloseCallBack(closeCallBack);
        if (ADJ_ENTITY.equals(key)) {
            param.setOpenProperty(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            param.setShowParameter(formShowParameter);
        }
        param.setSwitchViewBySelMem(false);
        param.setNeedPermCheck(true);
        param.setqFilters(qFilters);
        param.setSign(key);
        param.setEnableView(false);
        param.setQueryDecompose(true);
        param.setCon_list(members);
        param.setBizModelId(this.getBizModelId());
        String viewIdStr = this.getPageCache().get(key + "viewId");
        Long viewId = StringUtils.isNotEmpty((String)viewIdStr) && !"0".equals(viewIdStr) ? Long.valueOf(viewIdStr) : BusinessModelServiceHelper.getInstance().getViewId(this.getBizModelId(), dimNum, this.getModelId());
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)dimNum, (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    private void showSelectUserPanel() {
        HashSet<Long> userIds = new HashSet<Long>(16);
        String userId = (String)this.getModel().getValue("userid");
        if (StringUtils.isNotEmpty((String)userId)) {
            String[] userIdArr;
            for (String perUserId : userIdArr = userId.split(";")) {
                userIds.add(Long.valueOf(perUserId));
            }
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        if (!userIds.isEmpty()) {
            listShowParameter.setSelectedRows(userIds.toArray());
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, USER_NAME));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "bizmodel": {
                this.switchBizModel(evt);
                break;
            }
            case "adjentity": 
            case "adjaccount": 
            case "adjmetric": 
            case "adjcustomdim1": 
            case "adjcustomdim2": 
            case "adjcustomdim3": 
            case "adjcustomdim4": 
            case "adjcustomdim5": 
            case "adjcustomdim6": 
            case "adjcustomdim7": 
            case "adjcustomdim8": 
            case "adjcustomdim9": 
            case "adjcustomdim10": 
            case "adjcustomdim11": 
            case "adjcustomdim12": 
            case "adjcustomdim13": 
            case "adjcustomdim14": 
            case "adjcustomdim15": 
            case "adjcustomdim16": 
            case "adjcustomdim17": 
            case "adjcustomdim18": 
            case "adjcustomdim19": 
            case "adjcustomdim20": 
            case "adjcustomdim21": 
            case "adjcustomdim22": 
            case "adjcustomdim23": 
            case "adjcustomdim24": 
            case "adjcustomdim25": 
            case "adjcustomdim26": 
            case "adjcustomdim27": 
            case "adjcustomdim28": 
            case "adjcustomdim29": 
            case "adjcustomdim30": 
            case "adjcustomdim31": 
            case "adjcustomdim32": 
            case "adjcustomdim33": 
            case "adjcustomdim34": 
            case "adjcustomdim35": 
            case "adjcustomdim36": 
            case "adjcustomdim37": 
            case "adjcustomdim38": 
            case "adjcustomdim39": 
            case "adjcustomdim40": 
            case "adjcustomdim41": 
            case "adjcustomdim42": 
            case "adjcustomdim43": 
            case "adjcustomdim44": 
            case "adjcustomdim45": 
            case "adjcustomdim46": 
            case "adjcustomdim47": 
            case "adjcustomdim48": 
            case "adjcustomdim49": 
            case "adjcustomdim50": {
                this.fillDimData(evt);
                break;
            }
            case "username": {
                this.fillUserData(evt);
                break;
            }
        }
    }

    private void switchBizModel(ClosedCallBackEvent evt) {
        Long bizModelId;
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        if (returnData == null || returnData.size() == 0) {
            return;
        }
        Long oldBizModelId = this.getBizModelId();
        if (!oldBizModelId.equals(bizModelId = (Long)returnData.get(0).getPrimaryKeyValue())) {
            this.getPageCache().put("oldBizModelId", oldBizModelId.toString());
            this.getPageCache().put("bizModelId", bizModelId.toString());
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BIZ_MODEL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u6a21\u578b\u4f1a\u5c06\u5f53\u524d\u89c4\u5219\u660e\u7ec6\u6570\u636e\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdjustRuleEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (BIZ_MODEL.equals(callBackId)) {
            if (MessageBoxResult.Yes == result) {
                Long bizModelId = IDUtils.toLong((Object)this.getPageCache().get("bizModelId"));
                this.getModel().setValue(BIZ_MODEL, (Object)bizModelId);
            } else {
                Long oldBizModelId = IDUtils.toLong((Object)this.getPageCache().get("oldBizModelId"));
                this.getModel().beginInit();
                this.getModel().setValue(BIZ_MODEL, (Object)oldBizModelId);
                this.getModel().endInit();
                this.getView().updateView(BIZ_MODEL);
            }
        }
        if ("save_comfirm".equals(callBackId) && MessageBoxResult.Yes == result) {
            this.removeEmptyEntry();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjustRuleEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillUserData(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        StringBuilder nameInfo = new StringBuilder();
        StringBuilder valueInfo = new StringBuilder();
        for (int i = 0; i < returnData.size(); ++i) {
            ListSelectedRow selectedRow = returnData.get(i);
            valueInfo.append(selectedRow.getPrimaryKeyValue()).append(";");
            nameInfo.append(selectedRow.getName()).append(";");
        }
        if (StringUtils.isNotEmpty((String)valueInfo.toString())) {
            valueInfo.deleteCharAt(valueInfo.lastIndexOf(";"));
        }
        if (StringUtils.isNotEmpty((String)nameInfo.toString())) {
            nameInfo.deleteCharAt(nameInfo.lastIndexOf(";"));
        }
        this.getModel().setValue(USER_NAME, (Object)nameInfo.toString());
        this.getModel().setValue("userid", (Object)valueInfo.toString());
    }

    private void fillDimData(ClosedCallBackEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int row = entryGrid.getSelectRows()[0];
        DynamicObjectCollection returnData = (DynamicObjectCollection)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        if (returnData.isEmpty()) {
            this.getModel().setValue(actionId, null, row);
            this.getModel().setValue(actionId.substring(3), null, row);
        } else {
            boolean isSame;
            StringBuilder showName = new StringBuilder();
            StringBuilder showValue = new StringBuilder();
            for (DynamicObject memberInfo : returnData) {
                String number = memberInfo.getString("number");
                String name = memberInfo.getString("name");
                int scope = memberInfo.getInt("scope");
                this.buildDimShowName(showName, name, scope);
                if (ADJ_ENTITY.equals(actionId)) {
                    String type = memberInfo.getString("type");
                    if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
                        String longnumber = memberInfo.getString("longnumber");
                        this.buildDimShowValue(showValue, longnumber, scope, name, type);
                        continue;
                    }
                    this.buildDimShowValue(showValue, number, scope, name, type);
                    continue;
                }
                this.buildDimShowValue(showValue, number, scope, name, null);
            }
            this.getModel().setValue(actionId, (Object)this.setReturnValue(showName), row);
            this.getModel().setValue(actionId.substring(3), (Object)this.setReturnValue(showValue), row);
            if (ADJ_ACCOUNT.equals(actionId) && (isSame = this.isSameAccount(row))) {
                this.getModel().setValue(actionId, null, row);
                this.getModel().setValue(actionId.substring(3), null, row);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u79d1\u76ee\u4e0e\u5176\u4ed6\u884c\u79d1\u76ee\u5b58\u5728\u4ea4\u96c6\u3002", (String)"AdjustRuleEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{row + 1}));
                return;
            }
        }
    }

    private void buildDimShowValue(StringBuilder returnInfo, String number, int scope, String name, String type) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)type)) {
            returnInfo.append(number).append("!!").append(scope).append("!!").append(name).append(';');
        } else {
            returnInfo.append(number).append("!!").append(type).append("!!").append(scope).append("!!").append(name).append(';');
        }
    }

    private void buildDimShowName(StringBuilder returnInfo, String name, int scope) {
        if (RangeEnum.getRangeByVal((int)scope) == RangeEnum.ONLY) {
            returnInfo.append(name).append(';');
        } else {
            returnInfo.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"AdjustRuleEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)scope).getName()).append(';');
        }
    }

    private String setReturnValue(StringBuilder showInfo) {
        if (showInfo == null || showInfo.length() == 0) {
            return "";
        }
        return showInfo.deleteCharAt(showInfo.lastIndexOf(";")).toString();
    }

    private boolean isSameAccount(int rowNum) {
        boolean isSame = false;
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowNum);
        String currAccount = rowObj.getString("account");
        Set<String> accountNumSet = this.getAccountIds(currAccount);
        HashSet<String> accountNumSetV = new HashSet<String>(16);
        int rowCounts = this.getModel().getEntryRowCount("entryentity");
        for (int num = 0; num < rowCounts; ++num) {
            DynamicObject anotherRowObj;
            String anotherAccount;
            Set<String> anotherAccountNumSet;
            if (rowNum == num || (anotherAccountNumSet = this.getAccountIds(anotherAccount = (anotherRowObj = this.getModel().getEntryRowEntity("entryentity", num)).getString("account"))).isEmpty()) continue;
            accountNumSetV.addAll(accountNumSet);
            accountNumSetV.retainAll(anotherAccountNumSet);
            if (accountNumSetV.isEmpty()) continue;
            isSame = true;
            accountNumSetV.clear();
            break;
        }
        return isSame;
    }

    private Set<String> getAccountIds(String accountStr) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        HashSet<String> accountNumSet = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)accountStr)) {
            String[] accountArr;
            for (String perAccount : accountArr = accountStr.split(";")) {
                String[] perAccountArr = perAccount.split("!!");
                List memberList = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), perAccountArr[0], Integer.parseInt(perAccountArr[1]));
                if (memberList == null) continue;
                List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                accountNumSet.addAll(memberNumbers);
            }
        }
        return accountNumSet;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            args.setCancel(true);
            return;
        }
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        if ("save".equals(opType)) {
            String userId;
            Object value = this.getModel().getValue("rulename");
            if (value == null || StringUtils.isEmpty((String)value.toString())) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustRuleEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            String assignType = (String)this.getModel().getValue(ASSIGN_TYPE);
            if ("1".equals(assignType) && StringUtils.isEmpty((String)(userId = (String)this.getModel().getValue("userid")))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237", (String)"AdjustRuleEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long billId = (Long)this.getModel().getValue("id");
            if (this.isAdjustRuleUsed(billId)) {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u5df2\u88ab\u5f15\u7528\u3002\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"AdjustRuleEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
            } else {
                this.removeEmptyEntry();
            }
            String billNo = (String)this.getModel().getValue("billno");
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "AdjustRuleEditPlugin_13", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u8c03\u6574\u89c4\u5219\uff1a%1$s\u5df2\u4fdd\u5b58\u3002", "AdjustRuleEditPlugin_14", "epm-eb-formplugin");
            this.writeLog(billNo, "save", opName, opDescription, new String[]{billNo});
        }
    }

    private void removeEmptyEntry() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        ArrayList<Integer> needRemove = new ArrayList<Integer>();
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            Object dataset = dynamicObject.get(DATASET);
            Object adjentity = dynamicObject.get(ADJ_ENTITY);
            if (dataset != null && !Objects.equals(0, dataset) || adjentity != null && !StringUtils.isEmpty((String)(adjentity + ""))) continue;
            needRemove.add(i);
        }
        int[] ints = new int[needRemove.size()];
        for (int i = 0; i < needRemove.size(); ++i) {
            ints[i] = (Integer)needRemove.get(i);
        }
        this.getModel().deleteEntryRows("entryentity", ints);
    }

    private boolean isAdjustRuleUsed(Long pkId) {
        if (pkId == 0L) {
            return false;
        }
        String countSql = "select count(1) count from t_eb_adjustbill where fadjustrule=" + pkId;
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)(this.getClass().getName() + "isAdjustRuleUsed"), (DBRoute)DBRoute.of((String)"epm"), (String)countSql, null);){
            while (ds != null && ds.hasNext()) {
                Row r = ds.next();
                count = r.getInteger("count");
            }
        }
        return count > 0;
    }

    public String getModelFieldKey() {
        return "model";
    }

    public String getBizCtrlRangeKey() {
        return "bizModel";
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_close"}));
    }
}

