/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustRuleListPlugin
extends AbstractListPlugin {
    private static final String OP_TYPE_DELETE = "delete";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_BUDGETFORM = "btn_budgetform";
    private static final String MODEL_CACHE = "MODEL_CACHE";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ArrayList modelList;
        String modelIdStr;
        List modelFilterList;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        List filterColumnList = commonFilterColumns.stream().filter(e -> "model.name".equals(e.getFieldName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterColumnList)) {
            return;
        }
        CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumnList.get(0);
        ControlFilters controlFilters = commonFilterColumn.getContext().getControlFilters();
        if (controlFilters != null && CollectionUtils.isNotEmpty((Collection)(modelFilterList = controlFilters.getFilter("model.id"))) && StringUtils.isNotEmpty((String)(modelIdStr = modelFilterList.get(0).toString()))) {
            this.getPageCache().put("KEY_MODEL_ID", modelIdStr);
        }
        if (this.getPageCache().get(MODEL_CACHE) != null) {
            modelList = (ArrayList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(MODEL_CACHE));
        } else {
            this.adaptBgrp();
            ArrayList modelQFilters = new ArrayList(16);
            modelQFilters.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            DynamicObjectCollection col = QueryServiceHelper.query((String)"model", (String)"epm_model", (String)"id,name", (QFilter[])modelQFilters.toArray(new QFilter[0]), null);
            commonFilterColumn.getComboItems().clear();
            ArrayList comboItems = new ArrayList(16);
            col.forEach(e -> comboItems.add(new ComboItem(new LocaleString(e.getString("name")), e.getString("id"))));
            modelList = comboItems;
            this.getPageCache().put(MODEL_CACHE, SerializationUtils.serializeToBase64(modelList));
        }
        if (modelList != null && !modelList.isEmpty()) {
            commonFilterColumn.setComboItems((List)modelList);
            commonFilterColumn.setDefaultValue(((ComboItem)modelList.get(0)).getValue());
            if (this.getPageCache().get("KEY_MODEL_ID") == null) {
                Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
                if (IDUtils.isNotNull((Long)modelId)) {
                    commonFilterColumn.setDefaultValue(modelId.toString());
                    this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
                } else {
                    this.getPageCache().put("KEY_MODEL_ID", ((ComboItem)modelList.get(0)).getValue());
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u4efb\u4f55\u4f53\u7cfb\u3002", (String)"AdjustRuleListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        Long modelId = (Long)args.getSearchClickEvent().getSelectMainOrgIds().get(0);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AdjustRuleListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        }
    }

    public void setFilter(SetFilterEvent e) {
        boolean hasModel = false;
        List filters = e.getMergeQFilters();
        for (QFilter filter : filters) {
            if (filter == null || !filter.getProperty().equals("model")) continue;
            hasModel = true;
            break;
        }
        if (!hasModel) {
            e.getQFilters().add(new QFilter("model", "=", (Object)0L));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter showParameter = e.getParameter();
        if (showParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            long modelId = this.getModelId();
            if (modelId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AdjustRuleListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                showParameter.setCustomParam("model", (Object)this.getModelId());
                showParameter.setCustomParam("isUsed", (Object)false);
            }
        } else if (showParameter.getStatus().equals((Object)OperationStatus.EDIT)) {
            Long pkId = (Long)showParameter.getPkId();
            HashSet<Long> pkIds = new HashSet<Long>(1);
            pkIds.add(pkId);
            boolean isUsed = this.isAdjustRuleUsed(pkIds);
            showParameter.setCustomParam("isUsed", (Object)isUsed);
        }
    }

    @Override
    public Long getModelId() {
        String strModelId = this.getPageCache().get("KEY_MODEL_ID");
        Long modelId = 0L;
        if (StringUtils.isNotEmpty((String)strModelId)) {
            modelId = Long.valueOf(strModelId);
        }
        return modelId;
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "btn_disable": {
                this.updateRuleState("0");
                break;
            }
            case "btn_enable": {
                this.updateRuleState("1");
                break;
            }
            case "btn_budgetform": {
                this.setBudgetFormRule();
                break;
            }
        }
    }

    private void updateRuleState(String value) {
        MultiLangEnumBridge opDescBridge;
        MultiLangEnumBridge opNameBridge;
        String opKey;
        BillList billList = (BillList)this.getControl("billlistap");
        Object[] pkArray = billList.getSelectedRows().getPrimaryKeyValues();
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bgm_adjustrule").getDynamicObjectType());
        StringBuilder billNos = new StringBuilder();
        for (DynamicObject billObj : bills) {
            billObj.set("rulestate", (Object)value);
            billNos.append(billObj.getString("billno")).append(";");
        }
        if (billNos.length() > 0) {
            billNos.deleteCharAt(billNos.length() - 1);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        billList.clearSelection();
        billList.refresh();
        if ("0".equals(value)) {
            opKey = "disable";
            opNameBridge = new MultiLangEnumBridge("\u7981\u7528", "AdjustRuleListPlugin_4", "epm-eb-formplugin");
            opDescBridge = new MultiLangEnumBridge("\u8c03\u6574\u89c4\u5219\uff1a%1$s\u5df2\u7981\u7528\u3002", "AdjustRuleListPlugin_6", "epm-eb-formplugin");
        } else {
            opKey = "enable";
            opNameBridge = new MultiLangEnumBridge("\u542f\u7528", "AdjustRuleListPlugin_5", "epm-eb-formplugin");
            opDescBridge = new MultiLangEnumBridge("\u8c03\u6574\u89c4\u5219\uff1a%1$s\u5df2\u542f\u7528\u3002", "AdjustRuleListPlugin_7", "epm-eb-formplugin");
        }
        OperationLogUtil.log((String)this.getBizAppId(), (String)"bgm_adjustrule", (String)"", (String)opKey, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])new String[]{billNos.toString()});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opType = ((FormOperate)args.getSource()).getType();
        ListSelectedRowCollection rows = args.getListSelectedData();
        if (OP_TYPE_DELETE.equals(opType)) {
            HashSet<Long> pkIds = new HashSet<Long>(rows.size());
            for (ListSelectedRow selectedRow : rows) {
                if (selectedRow == null) continue;
                Long pkId = (Long)selectedRow.getPrimaryKeyValue();
                pkIds.add(pkId);
            }
            if (this.isAdjustRuleUsed(pkIds)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u89c4\u5219\u4e2d\u5305\u542b\u5df2\u88ab\u5f15\u7528\u7684\u8c03\u6574\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AdjustRuleListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean isAdjustRuleUsed(Set<Long> pkIds) {
        StringBuilder countSql = new StringBuilder("select count(1) count from t_eb_adjustbill where fadjustrule in(");
        for (int i = 0; i < pkIds.size(); ++i) {
            countSql.append('?').append(',');
        }
        countSql.setCharAt(countSql.length() - 1, ')');
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)(this.getClass().getName() + "isAdjustRuleUsed"), (DBRoute)DBRoute.of((String)"epm"), (String)countSql.toString(), (Object[])pkIds.toArray());){
            while (ds != null && ds.hasNext()) {
                Row r = ds.next();
                count = r.getInteger("count");
            }
        }
        return count > 0;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        if (this.isNewEbForm()) {
            List listColumns = args.getListColumns();
            List collect = listColumns.stream().filter(e -> !"bizmodel.name".equals(e.getListFieldKey())).collect(Collectors.toList());
            args.setListColumns(collect);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_exit"}));
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            evt.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(evt);
    }

    private void adaptBgrp() {
        IFormView view = this.getView();
        String appId = view.getFormShowParameter().getAppId();
        Object specialApp = view.getFormShowParameter().getCustomParam("app_special");
        if (ApplicationTypeEnum.BGRP.getAppnum().equals(appId) && specialApp == null) {
            view.getFormShowParameter().setCustomParam("app_special", (Object)ApplicationTypeEnum.BGRP.getAppnum());
            view.cacheFormShowParameter();
        }
    }

    protected void setBudgetFormRule() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bgm_adjustrule_budgetform");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getModelId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_budget_form_rule"));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("callback_budget_form_rule".equals(actionId) && (returnData = event.getReturnData()) != null && "success".equals(returnData.toString())) {
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6309\u8868\u589e\u884c\u8bbe\u7f6e", "AdjustRuleEditPlugin_15", "epm-eb-formplugin");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            String modelName = modelCacheHelper.getModelobj().getName();
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u4f53\u7cfb%1$s\u6309\u8868\u589e\u884c\u8bbe\u7f6e\u6210\u529f\u3002", "AdjustRuleEditPlugin_16", "epm-eb-formplugin");
            this.writeLog("update", opName, opDescription, new String[]{modelName});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdjustRuleEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }
}

