/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.formplugin.bgadjust.AbstractAdjustMobBillPlugin;
import kd.epm.eb.model.utils.ModelUtil;

public class EbAdjustMobBillPlugIn
extends AbstractAdjustMobBillPlugin {
    @Override
    public int getCustomDimCount() {
        return 6;
    }

    @Override
    public String getPeriodName() {
        return "period";
    }

    @Override
    public String getFlexPanelApId() {
        return "flexpanelap";
    }

    @Override
    public void updateDataBeforeOpen(DynamicObjectCollection entityRows) {
        IDataModel dataModel = this.getModel();
        String billStatus = (String)dataModel.getValue("billstatus");
        if (AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus) || AdjustBillStateEnum.DISCARD.getShortNumber().equals(billStatus)) {
            return;
        }
        this.updateEntryEntityKeys();
        HashMap<String, Object> rowMembsValInfo = new HashMap<String, Object>(entityRows.size());
        DynamicInfoCollection customDimInfo = this.getCustomDimsInfoCache();
        List customDimCtlKeys = customDimInfo.getAllValOfOneProp("controlkey");
        this.entryEntityKeys.add(0, SysDimensionEnum.Period.getNumber());
        Map<String, Set<String>> numsMap = this.selectAdjustData(entityRows, rowMembsValInfo, customDimCtlKeys, customDimInfo, true, false);
        this.entryEntityKeys.remove(0);
        if (rowMembsValInfo.isEmpty()) {
            return;
        }
        ArrayList<String> headDimKeys = new ArrayList<String>(16);
        Collections.addAll(headDimKeys, "DataType", "Version", "Year", "ChangeType", "Currency");
        HashMap<String, Set<String>> allDimMembNums = new HashMap<String, Set<String>>(16);
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)this.getModelId());
        this.setHeadDimNumbers(headDimKeys, allDimMembNums, qfBuilder);
        SelectCommandInfo commandInfo = new SelectCommandInfo();
        allDimMembNums.forEach((dimNum, memberNums) -> commandInfo.addFilter(dimNum, memberNums.toArray(new String[1])));
        commandInfo.addDims(new String[]{"Period"});
        for (String dimNumber : this.entryEntityKeys) {
            if (numsMap.get(dimNumber) != null) {
                commandInfo.addFilter(dimNumber, numsMap.get(dimNumber).toArray(new String[1]));
            }
            if (dimNumber.startsWith("customdim")) {
                dimNumber = "adj" + dimNumber;
                if (!customDimCtlKeys.contains(dimNumber)) break;
                String tempDimNum = dimNumber;
                dimNumber = (String)customDimInfo.getValOfOnePropByAnotherProp("number", "controlkey", (Object)dimNumber);
                if (numsMap.get(tempDimNum) != null) {
                    commandInfo.addFilter(dimNumber, numsMap.get(tempDimNum).toArray(new String[1]));
                }
            }
            commandInfo.addDims(new String[]{dimNumber});
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)this.getModelId(), (String)this.getFormType(), (boolean)ModelUtil.isEbOrBgModel((Long)this.getModelId()));
        commandInfo.addFilter(SysDimensionEnum.AuditTrail.getNumber(), new String[]{auditTrail});
        commandInfo.addFilter(SysDimensionEnum.Scenario.getNumber(), new String[]{"NoScenario"});
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        if ("ATTotal".equals(auditTrail)) {
            DynamicObject model = (DynamicObject)this.getModel().getValue("model");
            this.aggregate(model.getLong("id"), model.getString("number"), commandInfo);
        }
        this.addOlapBudgetData(commandInfo, rowMembsValInfo);
        this.selectOtherBillsAdjustData(qfBuilder, rowMembsValInfo, customDimCtlKeys, customDimInfo, true);
        for (Object indexAndVal : rowMembsValInfo.values()) {
            Pair vals = (Pair)indexAndVal;
            DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)vals.getKey()).intValue());
            BigDecimal adjustdata = entityObj.getBigDecimal("adjustdata");
            entityObj.set("finaldata", (Object)adjustdata.add((BigDecimal)vals.getValue()));
            entityObj.set("budgetdata", vals.getValue());
        }
    }

    private void addOlapBudgetData(SelectCommandInfo commandInfo, Map<String, Object> allAdjustData) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        Map olapData = EbOlapServiceHelper.queryData((SelectCommandInfo)commandInfo, (String)model.getString("number"));
        for (Map.Entry entry : olapData.entrySet()) {
            Object val = entry.getValue();
            Pair rowVal = (Pair)allAdjustData.get(entry.getKey());
            if (rowVal == null || val == null) continue;
            if (val instanceof Long) {
                rowVal.setValue((Object)((BigDecimal)rowVal.getValue()).add(new BigDecimal((Long)val)));
                continue;
            }
            if (!(val instanceof BigDecimal)) continue;
            rowVal.setValue((Object)((BigDecimal)rowVal.getValue()).add((BigDecimal)val));
        }
    }

    private void aggregate(Long modelId, String cubeNumber, SelectCommandInfo commandInfo) {
        List filterList = commandInfo.getFilter();
        AggregateExpr expr = new AggregateExpr();
        for (DimensionFilterItem filter : filterList) {
            HashSet dimSet = new HashSet(16);
            dimSet.addAll(filter.getValues());
            expr.addMembers(filter.getName(), dimSet);
        }
        Set periodMembers = (Set)expr.getMembers().get(SysDimensionEnum.Period.getNumber());
        if (periodMembers == null) {
            DynamicInfoCollection periodInfos = this.getCachePeriodInfo();
            List periodNums = periodInfos.getAllValOfOneProp("number");
            HashSet periodSet = new HashSet(periodNums.size());
            periodSet.addAll(periodNums);
            expr.addMembers(SysDimensionEnum.Period.getNumber(), periodSet);
        }
        HashSet<String> internalCompanySet = new HashSet<String>(1);
        internalCompanySet.add("ICNone");
        expr.addMembers(SysDimensionEnum.InternalCompany.getNumber(), internalCompanySet);
        HashSet<String> processSet = new HashSet<String>(1);
        processSet.add("IRpt");
        expr.addMembers(SysDimensionEnum.Process.getNumber(), processSet);
        ScriptCommand command = ScriptCommand.getIntance((OlapConnection)ScriptCommand.getOlapConnection((String)cubeNumber));
        command.execute(modelId, (IExpress)expr);
    }

    @Override
    public void updateEntryEntityKeys() {
        this.entryEntityKeys = new ArrayList<String>(Arrays.asList("Entity", "Account", "customdim1", "customdim2", "customdim3", "customdim4", "customdim5", "customdim6"));
    }

    private void selectOtherBillsAdjustData(QFBuilder qb, Map<String, Object> allAdjustData, List<Object> customDimKeys, DynamicInfoCollection customDims, boolean isWithRowNum) {
        if (!ControlParamsSettingUtil.isOnOrder((Long)this.getModelId(), (String)this.getFormType())) {
            return;
        }
        qb.add("billstatus", "in", (Object)new String[]{AdjustBillStateEnum.SUBMIT.getShortNumber(), AdjustBillStateEnum.AUDITING.getShortNumber()});
        String selectTable = "eb_adjustbill";
        Map objs = BusinessDataServiceHelper.loadFromCache((String)selectTable, (QFilter[])qb.toArray());
        Iterator iterator = objs.values().iterator();
        this.entryEntityKeys.add(0, SysDimensionEnum.Period.getNumber());
        Long id = (Long)this.getModel().getValue("id");
        while (iterator.hasNext()) {
            DynamicObject billObj = (DynamicObject)iterator.next();
            if (id != null && id.equals(billObj.getLong("id"))) continue;
            this.selectAdjustData(billObj.getDynamicObjectCollection("adjdetailentity"), allAdjustData, customDimKeys, customDims, isWithRowNum, true);
        }
        this.entryEntityKeys.remove(0);
    }

    public Map<String, Set<String>> selectAdjustData(DynamicObjectCollection entityObjs, Map<String, Object> allAdjustData, List<Object> customDimKeys, DynamicInfoCollection customDims, boolean isWithRowNum, boolean isSelect) {
        HashMap<String, Set<String>> numsMap = new HashMap<String, Set<String>>(16);
        int index = 0;
        StringBuilder sb = new StringBuilder();
        block0: for (DynamicObject entityObj : entityObjs) {
            String membNumStr;
            Object val;
            for (String key : this.entryEntityKeys) {
                String membNum;
                DynamicObject f7Val;
                if (key.startsWith("customdim")) {
                    if (!customDimKeys.contains("adj" + key)) break;
                    f7Val = entityObj.getDynamicObject(key);
                    key = "adj" + key;
                    membNum = f7Val == null ? (String)customDims.getValOfOnePropByAnotherProp("defMemberNum", "controlkey", (Object)key) : f7Val.getString("number");
                } else {
                    f7Val = entityObj.getDynamicObject(key);
                    if (f7Val == null) continue block0;
                    membNum = f7Val.getString("number");
                }
                sb.append(membNum);
                sb.append("!!");
                numsMap.computeIfAbsent(key, v -> new HashSet(10)).add(membNum);
            }
            if ((val = allAdjustData.get(membNumStr = sb.substring(0, sb.length() - 2))) != null) {
                BigDecimal adjustData = entityObj.getBigDecimal("adjustdata");
                if (!adjustData.equals(BigDecimal.ZERO)) {
                    if (isWithRowNum) {
                        ((Pair)val).setValue((Object)((BigDecimal)((Pair)val).getValue()).add(adjustData));
                    } else {
                        allAdjustData.put(membNumStr, adjustData.add((BigDecimal)val));
                    }
                }
            } else if (!isSelect) {
                allAdjustData.put(membNumStr, new Pair((Object)index, (Object)new BigDecimal(0)));
            }
            sb.setLength(0);
            ++index;
        }
        return numsMap;
    }

    @Override
    public DynamicInfoCollection getCustomDimsInfo() {
        int seq = 1;
        DynamicInfoCollection customDimInfo = new DynamicInfoCollection("customDimInfo--controlkey,number,shortnumber,name,id,defMemberId", new String[]{"controlkey", "number", "shortnumber", "name", "id", "defMemberId", "defMemberNum"});
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)this.getModelId());
        qfBuilder.add("issysdimension", "=", (Object)"0");
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,shortnumber", (QFilter[])qfBuilder.toArray(), (String)"dseq");
        for (DynamicObject customDim : dims) {
            String name = customDim.getString("name");
            String number = customDim.getString("number");
            String id = customDim.getString("id");
            String shortNum = customDim.getString("shortnumber");
            customDimInfo.addInfo(new Object[]{"adjcustomdim" + seq++, number, shortNum, name, id, null, null});
        }
        return customDimInfo;
    }

    @Override
    public void showData(DynamicObjectCollection detailList) {
        super.showData(detailList);
    }
}

