/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class EbAdjustProjectPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
CellClickListener,
TreeNodeClickListener,
RowClickEventListener {
    public static final Log log = LogFactory.getLog(EbAdjustProjectPlugin.class);
    private static final String BTN_LSERACHBEF = "btn_lserachbef";
    private static final String BTN_LSEARCHAFT = "btn_lsearchaft";
    private static final String customDimsInfoCache = "customDimsInfoCache";
    private static final String ENTITY = "entity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BNT_ADDROW = "bnt_addrow";
    private static final String BNT_DELROW = "bnt_delrow";
    private static final String BNT_SAVE = "bnt_save";
    private static final String BNT_EXPORT = "bnt_export";
    private static final String BNT_CONFORM = "bnt_conform";
    private static final String BNT_SEARCHAP = "bnt_searchap";
    private static final String selectFiled = "id,adjentity,adjaccount,adjcustomdim1,adjcustomdim2,adjcustomdim3,adjcustomdim4,adjcustomdim5,adjcustomdim6,adjcustomdim7,adjcustomdim8,adjcustomdim9,adjcustomdim10,adjcustomdim11,adjcustomdim12,adjcustomdim13,adjcustomdim14,adjcustomdim15,adjcustomdim16,adjcustomdim17,adjcustomdim18,adjcustomdim19,adjcustomdim20,adjcustomdim21,adjcustomdim22,adjcustomdim23,adjcustomdim24,adjcustomdim25,adjcustomdim26,adjcustomdim27,adjcustomdim28,adjcustomdim29,adjcustomdim30,adjcustomdim31,adjcustomdim32,adjcustomdim33,adjcustomdim34,adjcustomdim35,adjcustomdim36,adjcustomdim37,adjcustomdim38,adjcustomdim39,adjcustomdim40,adjcustomdim41,adjcustomdim42,adjcustomdim43,adjcustomdim44,adjcustomdim45,adjcustomdim46,adjcustomdim47,adjcustomdim48,adjcustomdim49,adjcustomdim50,model,adjust";
    private static final String property = "adjentity,adjaccount,adjcustomdim1,adjcustomdim2,adjcustomdim3,adjcustomdim4,adjcustomdim5,adjcustomdim6,adjcustomdim7,adjcustomdim8,adjcustomdim9,adjcustomdim10,adjcustomdim11,adjcustomdim12,adjcustomdim13,adjcustomdim14,adjcustomdim15,adjcustomdim16,adjcustomdim17,adjcustomdim18,adjcustomdim19,adjcustomdim20,adjcustomdim21,adjcustomdim22,adjcustomdim23,adjcustomdim24,adjcustomdim25,adjcustomdim26,adjcustomdim27,adjcustomdim28,adjcustomdim29,adjcustomdim30,adjcustomdim31,adjcustomdim32,adjcustomdim33,adjcustomdim34,adjcustomdim35,adjcustomdim36,adjcustomdim37,adjcustomdim38,adjcustomdim39,adjcustomdim40,adjcustomdim41,adjcustomdim42,adjcustomdim43,adjcustomdim44,adjcustomdim45,adjcustomdim46,adjcustomdim47,adjcustomdim48,adjcustomdim49,adjcustomdim50,adjmetric";
    private DynamicInfoCollection customdimInfo = null;
    private boolean isBgmOrBg = false;
    private long bizmodelId = 0L;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getModelId() != 0L) {
            this.initParams();
            this.getAdjcustomdim();
            this.buildCustomDimInfo();
            this.initializeData();
        }
    }

    public void initParams() {
        Boolean isBgmTemp = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBgm");
        if (isBgmTemp != null && isBgmTemp.booleanValue()) {
            this.isBgmOrBg = true;
            this.bizmodelId = (Long)this.getView().getFormShowParameter().getCustomParam("bizmodelId");
        }
    }

    public void initializeData() {
        Map<String, DynamicObjectCollection> dataEntity = this.getUserSelectLow();
        if (dataEntity.size() == 0 && !this.opinionState()) {
            if (this.isBgmOrBg && !ModelUtil.isBGModel((Long)this.getModelId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u6a21\u578b\u6682\u65e0\u5df2\u6536\u85cf\u7684\u65b9\u6848\u3002", (String)"EbAdjustProjectPlugin_new_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6682\u65e0\u5df2\u6536\u85cf\u7684\u65b9\u6848\u3002", (String)"EbAdjustProjectPlugin_new_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        String agjustList = (String)this.getView().getFormShowParameter().getCustomParam("agjustList");
        if (StringUtils.isNotEmpty((String)agjustList)) {
            DynamicObjectCollection agjustLists = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)agjustList);
            dataEntity.put("", agjustLists);
        }
        this.getPageCache().put("dataEntity", SerializationUtils.serializeToBase64(dataEntity));
        this.initLeftEntity();
        this.buildEntitryRow(dataEntity);
    }

    private void setCacheLeftKey() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTITY);
        String textfield = ((DynamicObject)entity.get(entity.size() - 1)).getString("textfield");
        this.getPageCache().put("leftKey", textfield);
        this.setEntryLock(textfield);
    }

    private void setEntryLock(String textfield) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTITY);
        EntryGrid control = (EntryGrid)this.getControl(ENTITY);
        int[] index = entity.size() == 1 ? new int[1] : new int[entity.size() - 1];
        int[] indexOne = new int[1];
        int count = 0;
        for (int i = 0; i < entity.size(); ++i) {
            if (!((DynamicObject)entity.get(i)).getString("textfield").equals(textfield)) {
                index[count] = i;
                control.setRowBackcolor("#f2f2f2", index);
                ++count;
                continue;
            }
            indexOne[0] = i;
            control.setRowLock(false, indexOne);
        }
        if (entity.size() > 1) {
            control.setRowLock(true, index);
        }
        this.getView().updateView(ENTITY);
    }

    public void initLeftEntity() {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(ENTITY);
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        if (dataEntity.size() == 0) {
            if (!this.opinionState()) {
                if (this.isBgmOrBg && !ModelUtil.isBGModel((Long)this.getModelId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u6a21\u578b\u6682\u65e0\u5df2\u6536\u85cf\u7684\u65b9\u6848\u3002", (String)"EbAdjustProjectPlugin_new_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6682\u65e0\u5df2\u6536\u85cf\u7684\u65b9\u6848\u3002", (String)"EbAdjustProjectPlugin_new_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                return;
            }
        } else {
            dataModel.beginInit();
            for (Map.Entry<String, DynamicObjectCollection> entry : dataEntity.entrySet()) {
                int row = dataModel.createNewEntryRow(ENTITY);
                dataModel.setValue("textfield", (Object)entry.getKey(), row);
            }
            dataModel.endInit();
        }
        this.getView().updateView(ENTITY);
        this.setCacheLeftKey();
    }

    public boolean opinionState() {
        return "1".equals(this.getView().getFormShowParameter().getCustomParam("ag"));
    }

    public Map<String, DynamicObjectCollection> getUserSelectLow() {
        QFilter qfs = new QFilter("model", "=", (Object)this.getModelId());
        this.initParams();
        if (this.isBgmOrBg) {
            qfs.and(new QFilter("bizmodel", "=", (Object)this.bizmodelId));
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)(this.isBgmOrBg ? "bgm_adjustproject_coll" : "eb_adjustproject_coll"), (String)(this.isBgmOrBg ? "id,adjentity,adjaccount,adjcustomdim1,adjcustomdim2,adjcustomdim3,adjcustomdim4,adjcustomdim5,adjcustomdim6,adjcustomdim7,adjcustomdim8,adjcustomdim9,adjcustomdim10,adjcustomdim11,adjcustomdim12,adjcustomdim13,adjcustomdim14,adjcustomdim15,adjcustomdim16,adjcustomdim17,adjcustomdim18,adjcustomdim19,adjcustomdim20,adjcustomdim21,adjcustomdim22,adjcustomdim23,adjcustomdim24,adjcustomdim25,adjcustomdim26,adjcustomdim27,adjcustomdim28,adjcustomdim29,adjcustomdim30,adjcustomdim31,adjcustomdim32,adjcustomdim33,adjcustomdim34,adjcustomdim35,adjcustomdim36,adjcustomdim37,adjcustomdim38,adjcustomdim39,adjcustomdim40,adjcustomdim41,adjcustomdim42,adjcustomdim43,adjcustomdim44,adjcustomdim45,adjcustomdim46,adjcustomdim47,adjcustomdim48,adjcustomdim49,adjcustomdim50,model,adjust,adjmetric" : selectFiled), (QFilter[])qfs.toArray());
        DynamicObjectCollection dynamicObjec = new DynamicObjectCollection();
        dynamicObjec.addAll(Arrays.asList(dynamicObjects));
        LinkedHashMap<String, DynamicObjectCollection> dataEntity = new LinkedHashMap<String, DynamicObjectCollection>();
        if (dynamicObjec.size() > 0) {
            HashSet<String> dynamicSet = new HashSet<String>(16);
            for (DynamicObject dynamicObject : dynamicObjec) {
                String adjust = dynamicObject.getString("adjust");
                dynamicSet.add(adjust);
            }
            for (String next : dynamicSet) {
                DynamicObjectCollection dynamicObjecs = new DynamicObjectCollection();
                for (DynamicObject dynamicObject : dynamicObjec) {
                    if (!next.equals(dynamicObject.getString("adjust"))) continue;
                    dynamicObjecs.add((Object)dynamicObject);
                }
                dataEntity.put(next, dynamicObjecs);
            }
        }
        return dataEntity;
    }

    public void buildEntitryRow(Map<String, DynamicObjectCollection> dataEntity) {
        IPageCache pageCache = this.getPageCache();
        String leftKey = pageCache.get("leftKey");
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (dataEntity.size() > 0) {
            DynamicObjectCollection dynamicObjects = dataEntity.get(leftKey);
            if (dynamicObjects != null) {
                this.getModel().beginInit();
                this.setEntryValue(dynamicObjects);
                this.getModel().endInit();
                pageCache.put("entityInfo", "1");
            }
        } else if (this.isBgmOrBg && !ModelUtil.isBGModel((Long)this.getModelId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u6a21\u578b\u6682\u65e0\u5df2\u6536\u85cf\u7684\u65b9\u6848\u3002", (String)"EbAdjustProjectPlugin_new_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u6682\u65e0\u5df2\u6536\u85cf\u7684\u65b9\u6848\u3002", (String)"EbAdjustProjectPlugin_new_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void setEntryValue(DynamicObjectCollection dynamicObjects) {
        int infos = this.getAdjcustomdim();
        for (DynamicObject dynamicObject : dynamicObjects) {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("adjentity", dynamicObject.get("adjentity"), row);
            this.getModel().setValue("adjaccount", dynamicObject.get("adjaccount"), row);
            if (this.isBgmOrBg) {
                this.getModel().setValue("adjmetric", dynamicObject.get("adjmetric"), row);
            }
            this.setAdjcustomdin(dynamicObject, row, infos);
        }
    }

    private void setAdjcustomdin(DynamicObject dynamicObject, int rowEntity, int infos) {
        if (infos > 0) {
            for (int j = 1; j <= infos; ++j) {
                this.getModel().setValue("adjcustomdim" + j, dynamicObject.get("adjcustomdim" + j), rowEntity);
            }
        }
    }

    public void buildCustomDimInfo() {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.FALSE, new String[]{"adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6", "adjcustomdim7", "adjcustomdim8", "adjcustomdim9", "adjcustomdim10", "adjcustomdim11", "adjcustomdim12", "adjcustomdim13", "adjcustomdim14", "adjcustomdim15", "adjcustomdim16", "adjcustomdim17", "adjcustomdim18", "adjcustomdim19", "adjcustomdim20", "adjcustomdim21", "adjcustomdim22", "adjcustomdim23", "adjcustomdim24", "adjcustomdim25", "adjcustomdim26", "adjcustomdim27", "adjcustomdim28", "adjcustomdim29", "adjcustomdim30", "adjcustomdim31", "adjcustomdim32", "adjcustomdim33", "adjcustomdim34", "adjcustomdim35", "adjcustomdim36", "adjcustomdim37", "adjcustomdim38", "adjcustomdim39", "adjcustomdim40", "adjcustomdim41", "adjcustomdim42", "adjcustomdim43", "adjcustomdim44", "adjcustomdim45", "adjcustomdim46", "adjcustomdim47", "adjcustomdim48", "adjcustomdim49", "adjcustomdim50"});
        String custom = (String)this.getView().getFormShowParameter().getCustomParam("custom");
        if (StringUtils.isNotEmpty((String)custom)) {
            this.customdimInfo = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)custom);
        }
        if (!this.customdimInfo.isEmpty()) {
            IDataModel dataModel = this.getModel();
            int rowCounts = this.getModel().getEntryRowCount(ENTRYENTITY);
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            for (DynamicInfoCollection.InfoObject info : this.customdimInfo.getValues()) {
                String controlkey = (String)info.getValueByPropName("controlkey");
                for (int i = 0; i < rowCounts; ++i) {
                    if (dataModel.getValue(controlkey, i) != null) continue;
                    dataModel.setValue(controlkey, info.getValueByPropName("defMemberId"), i);
                }
                String name = (String)info.getValueByPropName("name");
                grid.setColumnProperty(controlkey, "header", (Object)new LocaleString(name));
                formView.setVisible(Boolean.TRUE, new String[]{controlkey});
            }
            formView.updateView(ENTRYENTITY);
        }
        this.getPageCache().put(customDimsInfoCache, SerializationUtils.serializeToBase64((Object)this.customdimInfo));
    }

    public int getAdjcustomdim() {
        String custom = (String)this.getView().getFormShowParameter().getCustomParam("custom");
        if (StringUtils.isNotEmpty((String)custom)) {
            this.customdimInfo = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)custom);
        }
        return this.customdimInfo.getValues().size();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BNT_ADDROW, BNT_DELROW, BNT_SAVE, BNT_EXPORT, BNT_CONFORM, BTN_LSERACHBEF, BTN_LSEARCHAFT});
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        EntryGrid entity = (EntryGrid)this.getControl(ENTITY);
        this.addF7SelectListeners("adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6", "adjcustomdim7", "adjcustomdim8", "adjcustomdim9", "adjcustomdim10", "adjcustomdim11", "adjcustomdim12", "adjcustomdim13", "adjcustomdim14", "adjcustomdim15", "adjcustomdim16", "adjcustomdim17", "adjcustomdim18", "adjcustomdim19", "adjcustomdim20", "adjcustomdim21", "adjcustomdim22", "adjcustomdim23", "adjcustomdim24", "adjcustomdim25", "adjcustomdim26", "adjcustomdim27", "adjcustomdim28", "adjcustomdim29", "adjcustomdim30", "adjcustomdim31", "adjcustomdim32", "adjcustomdim33", "adjcustomdim34", "adjcustomdim35", "adjcustomdim36", "adjcustomdim37", "adjcustomdim38", "adjcustomdim39", "adjcustomdim40", "adjcustomdim41", "adjcustomdim42", "adjcustomdim43", "adjcustomdim44", "adjcustomdim45", "adjcustomdim46", "adjcustomdim47", "adjcustomdim48", "adjcustomdim49", "adjcustomdim50", "adjaccount", "adjentity", "adjmetric");
        entry.addCellClickListener((CellClickListener)this);
        entity.addCellClickListener((CellClickListener)this);
        entry.addRowClickListener((RowClickEventListener)this);
        entity.addRowClickListener((RowClickEventListener)this);
        this.regeistSerachop();
    }

    private void regeistSerachop() {
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        final EntryGrid entryGrid = (EntryGrid)this.getControl(ENTITY);
        Search serach = (Search)this.getControl(BNT_SEARCHAP);
        serach.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent event) {
                if (event.getText() != null && !"".equals(event.getText())) {
                    EbAdjustProjectPlugin.this.searchEntry(event, entryGrid, pageCache, view);
                } else {
                    pageCache.remove("searchKey");
                    EbAdjustProjectPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"EbAdjustProjectPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private void searchEntry(SearchEnterEvent event, EntryGrid entryGrid, IPageCache pageCache, IFormView view) {
        int ll = 0;
        String entityInfo = this.getPageCache().get("entityInfo");
        if ("1".equals(entityInfo)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY);
            for (int i = 0; i < entryEntity.size(); ++i) {
                String textfield = ((DynamicObject)entryEntity.get(i)).getString("textfield");
                if (!textfield.contains(event.getText())) continue;
                pageCache.put("searchKey", event.getText());
                this.updateEntity(entryGrid, pageCache, i, textfield);
                ++ll;
                break;
            }
        }
        if (ll == 0) {
            pageCache.remove("searchKey");
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"EbAdjustProjectPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateEntity(EntryGrid entryGrid, IPageCache pageCache, int i, String textfield) {
        this.initParams();
        entryGrid.selectRows(i);
        pageCache.put("leftKey", textfield);
        this.setEntryLock(textfield);
        this.entityClickRow();
    }

    private boolean checkEntry(DynamicObjectCollection collections) {
        int infos = this.getAdjcustomdim();
        for (DynamicObject collection : collections) {
            if (collection.get("adjentity") != null || collection.get("adjaccount") != null) {
                return true;
            }
            if (this.isBgmOrBg) {
                collection.get("adjmetric");
                if (collection.get("adjmetric") != null) {
                    return true;
                }
            }
            if (infos <= 0) continue;
            for (int j = 1; j <= infos; ++j) {
                if (collection.get("adjcustomdim" + j) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void entityClickRow() {
        this.buildEntitryRow(this.getDataEntity());
        this.getView().updateView(ENTRYENTITY);
    }

    private void addF7SelectListeners(String ... f7Keys) {
        BasedataEdit f7 = null;
        for (String f7Key : f7Keys) {
            f7 = (BasedataEdit)this.getControl(f7Key);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String entityInfo = this.getPageCache().get("entityInfo");
        this.initParams();
        if ("1".equals(entityInfo)) {
            switch (key) {
                case "bnt_addrow": {
                    this.addRowEntitry();
                    break;
                }
                case "bnt_delrow": {
                    this.remoRowEntitry();
                    break;
                }
                case "bnt_save": {
                    this.saveRowEntitry();
                    break;
                }
                case "bnt_export": {
                    this.exportEntitry();
                    break;
                }
                case "bnt_conform": {
                    this.conformRowEntitry();
                    break;
                }
                case "btn_lserachbef": 
                case "btn_lsearchaft": {
                    this.upAndDownMove(key);
                    break;
                }
            }
        }
    }

    private void upAndDownMove(String key) {
        EntryGrid entryGrid;
        if (this.getPageCache().get("searchKey") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"EbAdjustProjectPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String searchKey = this.getPageCache().get("searchKey");
        String leftKey = this.getPageCache().get("leftKey");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY);
        LinkedList<String> contains = new LinkedList<String>();
        for (DynamicObject dynamicObject : entryEntity) {
            if (!dynamicObject.getString("textfield").contains(searchKey)) continue;
            contains.add(dynamicObject.getString("textfield"));
        }
        if (BTN_LSERACHBEF.equals(key)) {
            for (int i = 0; i < contains.size(); ++i) {
                if (!((String)contains.get(i)).equals(leftKey)) continue;
                if (i == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u884c\u5185\u5bb9\u3002", (String)"EbAdjustProjectPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                entryGrid = (EntryGrid)this.getControl(ENTITY);
                int row = i - 1;
                for (int j = 0; j < entryEntity.size(); ++j) {
                    if (!((String)contains.get(row)).equals(((DynamicObject)entryEntity.get(j)).getString("textfield"))) continue;
                    this.updateEntity(entryGrid, this.getPageCache(), j, (String)contains.get(row));
                }
            }
        } else {
            for (int i = 0; i < contains.size(); ++i) {
                if (!((String)contains.get(i)).equals(leftKey)) continue;
                if (i == contains.size() - 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u884c\u5185\u5bb9\u3002", (String)"EbAdjustProjectPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    continue;
                }
                entryGrid = (EntryGrid)this.getControl(ENTITY);
                int row = i + 1;
                for (int j = 0; j < entryEntity.size(); ++j) {
                    if (!((String)contains.get(row)).equals(((DynamicObject)entryEntity.get(j)).getString("textfield"))) continue;
                    this.updateEntity(entryGrid, this.getPageCache(), j, (String)contains.get(row));
                }
            }
        }
    }

    private void exportEntitry() {
        this.initParams();
        IPageCache pageCache = this.getPageCache();
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        String textfield = pageCache.get("leftKey");
        if (dataEntity.get(textfield) != null) {
            DynamicObjectCollection dynamicObjects = dataEntity.get(textfield);
            dataEntity.put(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"EbAdjustProjectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), dynamicObjects);
            pageCache.put("dataEntity", SerializationUtils.serializeToBase64(dataEntity));
            this.initLeftEntity();
            this.buildEntitryRow(dataEntity);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (MessageBoxResult.Yes.getValue() == event.getResult().getValue()) {
            this.initParams();
            if ("deleteProject".equals(callBackId)) {
                this.deleteEntryEntity();
            }
        }
    }

    private void deleteEntryEntity() {
        DynamicObject entryRowEntity;
        String textfield;
        IPageCache pageCache = this.getPageCache();
        EntryGrid control = (EntryGrid)this.getControl(ENTITY);
        int[] selectRows = control.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int selectRow = selectRows[0];
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        if (dataEntity.get(textfield = (entryRowEntity = this.getModel().getEntryRowEntity(ENTITY, selectRow)).getString("textfield")) != null) {
            pageCache.remove("leftKey");
            dataEntity.remove(textfield);
            this.deleteData(textfield);
            pageCache.put("dataEntity", SerializationUtils.serializeToBase64(dataEntity));
            if (dataEntity.size() > 0) {
                this.initLeftEntity();
                this.buildEntitryRow(dataEntity);
            } else {
                this.getModel().deleteEntryData(ENTITY);
                this.getModel().deleteEntryData(ENTRYENTITY);
                pageCache.remove("entityInfo");
            }
        }
    }

    private void deleteData(String textfield) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        qFilter.and("adjust", "=", (Object)textfield);
        try {
            DeleteServiceHelper.delete((String)(AdjustUtil.isBgm(this.getView(), 0L) || AdjustUtil.isBG(this.getView(), 0L) ? "bgm_adjustproject_coll" : "eb_adjustproject_coll"), (QFilter[])qFilter.toArray());
        }
        catch (Exception e) {
            log.error("eb_adjustproject_coll:delete" + qFilter.toString());
            throw new KDBizException(e.getMessage());
        }
    }

    private void conformRowEntitry() {
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        if (dataEntity.size() == 0) {
            this.getView().close();
            return;
        }
        for (Map.Entry<String, DynamicObjectCollection> entry : dataEntity.entrySet()) {
            if (!StringUtils.isEmpty((String)entry.getKey())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"EbAdjustProjectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.saveData();
        if (!this.opinionState()) {
            DynamicObjectCollection entryEntity = new DynamicObjectCollection();
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] selectRow = entryentity.getSelectRows();
            if (selectRow.length < 1) {
                entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            } else {
                for (int i = 0; i < selectRow.length; ++i) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow[i]);
                    entryEntity.add((Object)entryRowEntity);
                }
            }
            String viewErrorInfo = this.checkDimMemberView(entryEntity);
            if (StringUtils.isNotEmpty((String)viewErrorInfo)) {
                throw new KDBizException(viewErrorInfo);
            }
            String errorInfo = this.checkDimMemberPerm(entryEntity);
            if (StringUtils.isNotEmpty((String)errorInfo)) {
                throw new KDBizException(errorInfo);
            }
            HashMap<String, DynamicObjectCollection> DynamicObjectMap = new HashMap<String, DynamicObjectCollection>(16);
            DynamicObjectMap.put("import", entryEntity);
            this.getView().returnDataToParent(DynamicObjectMap);
        }
        this.getView().close();
    }

    private void saveData() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (this.isBgmOrBg) {
            qFilter.and(new QFilter("bizmodel", "=", (Object)this.bizmodelId));
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)(this.isBgmOrBg ? "bgm_adjustproject_coll" : "eb_adjustproject_coll"), (QFilter[])qFilter.toArray());
                List<DynamicObject> objectList = this.saveEntityData();
                SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[0]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u6210\u529f\u3002", (String)"EbAdjustProjectPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        String keyName = this.getPageCache().get("leftKey");
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b9\u6848\u4fdd\u5b58", "EbAdjustProjectPlugin_28", "epm-eb-formplugin");
        MultiLangEnumBridge opDescription = new MultiLangEnumBridge("\u8c03\u6574/\u8c03\u5242\u65b9\u6848%1$s\u5df2\u6210\u529f\u4fdd\u5b58\u3002", "EbAdjustProjectPlugin_29", "epm-eb-formplugin");
        this.writeLog(keyName, "save", opName, opDescription, new String[]{keyName});
    }

    private void saveRowEntitry() {
        this.initParams();
        String textfield = this.getPageCache().get("leftKey");
        if (ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"EbAdjustProjectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(textfield) || StringUtils.isEmpty((String)textfield)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"EbAdjustProjectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.saveData();
    }

    public List<DynamicObject> saveEntityData() {
        ArrayList<DynamicObject> addDynamic = new ArrayList<DynamicObject>(16);
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        if (dataEntity.size() > 0) {
            for (Map.Entry<String, DynamicObjectCollection> entry : dataEntity.entrySet()) {
                for (DynamicObject dynamicObject : entry.getValue()) {
                    int infos;
                    DynamicObject dob = BusinessDataServiceHelper.newDynamicObject((String)(AdjustUtil.isBgm(this.getView(), 0L) || AdjustUtil.isBG(this.getView(), 0L) ? "bgm_adjustproject_coll" : "eb_adjustproject_coll"));
                    dob.set("adjentity", dynamicObject.get("adjentity"));
                    dob.set("adjaccount", dynamicObject.get("adjaccount"));
                    dob.set("model", (Object)this.getModelId());
                    dob.set("adjust", (Object)entry.getKey());
                    dob.set("userid", (Object)IDUtils.toLong((Object)RequestContext.get().getUserId()));
                    if (this.isBgmOrBg) {
                        dob.set("bizmodel", (Object)this.bizmodelId);
                        dob.set("adjmetric", dynamicObject.get("adjmetric"));
                    }
                    if ((infos = this.getAdjcustomdim()) > 0) {
                        for (int j = 1; j <= infos; ++j) {
                            dob.set("adjcustomdim" + j, dynamicObject.get("adjcustomdim" + j));
                        }
                    }
                    addDynamic.add(dob);
                }
            }
        }
        return addDynamic;
    }

    private void remoRowEntitry() {
        this.initParams();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRow = entryentity.getSelectRows();
        if (selectRow.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"EbAdjustProjectPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
            if (entryEntity.size() > 1 && selectRow.length < entryEntity.size()) {
                DynamicObjectCollection collection = new DynamicObjectCollection();
                DynamicObjectCollection retained = new DynamicObjectCollection();
                ArrayList<Integer> index = new ArrayList<Integer>(selectRow.length);
                for (int i : selectRow) {
                    index.add(i);
                }
                Object object = entryEntity.iterator();
                while (object.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)object.next();
                    int seq = dynamicObject.getInt("seq") - 1;
                    if (index.contains(seq)) {
                        collection.add((Object)dynamicObject);
                        continue;
                    }
                    retained.add((Object)dynamicObject);
                }
                if (this.checkEntry(retained)) {
                    this.removeEnrty(model, pageCache, entryEntity, retained);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u884c\u8c03\u6574\u660e\u7ec6\u3002", (String)"EbAdjustProjectPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u6709\u4e00\u884c\u8c03\u6574\u660e\u7ec6\u3002", (String)"EbAdjustProjectPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void removeEnrty(IDataModel model, IPageCache pageCache, DynamicObjectCollection entryEntity, DynamicObjectCollection collection) {
        model.deleteEntryData(ENTRYENTITY);
        entryEntity.addAll((Collection)collection);
        this.getModel().beginInit();
        this.setEntryValue(entryEntity);
        this.getModel().endInit();
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        String leftKey = pageCache.get("leftKey");
        dataEntity.put(leftKey, entryEntity);
        pageCache.put("dataEntity", SerializationUtils.serializeToBase64(dataEntity));
    }

    public void entryRowClick(RowClickEvent evt) {
        this.initParams();
        IPageCache pageCache = this.getPageCache();
        EntryGrid source = (EntryGrid)evt.getSource();
        if (ENTITY.equals(source.getEntryKey())) {
            String leftKey;
            if (pageCache.get("cellClick") != null) {
                pageCache.remove("cellClick");
                return;
            }
            DynamicObject entity = this.getModel().getEntryRowEntity(ENTITY, evt.getRow());
            String textfield = entity.getString("textfield");
            if (StringUtils.equals((String)textfield, (String)(leftKey = pageCache.get("leftKey")))) {
                return;
            }
            pageCache.put("leftKey", textfield);
            this.buildEntitryRow(this.getDataEntity());
        }
    }

    private Map<String, DynamicObjectCollection> getDataEntity() {
        IPageCache pageCache = this.getPageCache();
        String data = pageCache.get("dataEntity");
        HashMap<String, DynamicObjectCollection> dataEntity = new HashMap<String, DynamicObjectCollection>(16);
        if (StringUtils.isNotEmpty((String)data)) {
            return (Map)SerializationUtils.deSerializeFromBase64((String)data);
        }
        return dataEntity;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getPageCache();
        String name = e.getProperty().getName();
        String leftKey = pageCache.get("leftKey");
        this.initParams();
        Map<String, DynamicObjectCollection> dataEntity = this.getDataEntity();
        if ("textfield".equals(name)) {
            this.leftKeyChange(e, pageCache, leftKey, dataEntity);
        } else if (property.contains(name)) {
            this.rightEntryChange(pageCache, name, leftKey, dataEntity);
        }
    }

    private void rightEntryChange(IPageCache pageCache, String name, String leftKey, Map<String, DynamicObjectCollection> dataEntity) {
        String propertyChange = pageCache.get("right_change");
        if ("1".equals(propertyChange)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRows[0]);
            DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
            if (this.isEntryRowFill(entryRowEntity) && this.isStringBuffList(entity)) {
                pageCache.put("right_change", "1");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ec4\u5408\u5df2\u5b58\u5728\u3002", (String)"EbAdjustProjectPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                entryRowEntity.set(name, null);
                pageCache.put("right_change", null);
            } else {
                dataEntity.put(leftKey, entity);
                pageCache.put("dataEntity", SerializationUtils.serializeToBase64(dataEntity));
            }
        }
    }

    private void leftKeyChange(PropertyChangedArgs e, IPageCache pageCache, String leftKey, Map<String, DynamicObjectCollection> dataEntity) {
        String propertyChange = pageCache.get("property");
        if ("1".equals(propertyChange)) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        String newValue = (String)changeSet[0].getNewValue();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        DynamicObject entity = this.getModel().getEntryRowEntity(ENTITY, selectRows[0]);
        if (dataEntity.get(newValue) != null) {
            pageCache.put("property", "1");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u65b9\u6848\u540d\u3002", (String)"EbAdjustProjectPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            entity.set("textfield", (Object)leftKey);
            pageCache.put("property", null);
        } else if (StringUtils.isEmpty((String)newValue)) {
            pageCache.put("property", "1");
            entity.set("textfield", (Object)leftKey);
            pageCache.put("property", null);
        } else {
            DynamicObjectCollection remove = dataEntity.remove(leftKey);
            dataEntity.put(newValue, remove);
            pageCache.put("leftKey", newValue);
            pageCache.put("dataEntity", SerializationUtils.serializeToBase64(dataEntity));
        }
    }

    private boolean isEntryRowFill(DynamicObject entryRow) {
        if (entryRow != null) {
            DynamicObject adjentity = (DynamicObject)entryRow.get("adjentity");
            DynamicObject adjaccount = (DynamicObject)entryRow.get("adjaccount");
            if (adjentity == null || adjaccount == null) {
                return false;
            }
            int infos = this.getAdjcustomdim();
            if (infos > 0) {
                for (int i = 1; i <= infos; ++i) {
                    DynamicObject adjcustomdim = (DynamicObject)entryRow.get("adjcustomdim" + i);
                    if (adjcustomdim != null) continue;
                    return false;
                }
            }
            if (this.isBgmOrBg) {
                DynamicObject adjmetric = (DynamicObject)entryRow.get("adjmetric");
                return adjmetric != null;
            }
        }
        return true;
    }

    private void addRowEntitry() {
        this.initParams();
        this.getModel().createNewEntryRow(ENTRYENTITY);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)arg0.getFormShowParameter();
        List qs = showP.getListFilterParameter().getQFilters();
        if ("adjaccount".equals(propName)) {
            this.initParams();
            qs.add(this.getDimQFilter(propName));
            qs.add(new QFilter("isleaf", "=", (Object)true));
            showP.setCustomParam("isOnlyLeaf", (Object)Boolean.TRUE);
            arg0.setFormShowParameter((FormShowParameter)showP);
            LeftTreeF7Parameter f7Parameter = new LeftTreeF7Parameter();
            f7Parameter.setKeepTree(true);
            f7Parameter.setOnlyLeaf(true);
            this.switchLeftTreeF7(arg0, 0L, f7Parameter);
        } else if (!"model".equals(propName)) {
            qs.add(this.getDimQFilter(propName));
            qs.add(new QFilter("isleaf", "=", (Object)true));
            showP.setCustomParam("isOnlyLeaf", (Object)Boolean.TRUE);
            arg0.setFormShowParameter((FormShowParameter)showP);
            LeftTreeF7Parameter f7Parameter = new LeftTreeF7Parameter();
            f7Parameter.setKeepTree(true);
            f7Parameter.setOnlyLeaf(true);
            this.switchLeftTreeF7(arg0, 0L, f7Parameter);
        } else {
            qs = showP.getListFilterParameter().getQFilters();
            qs.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
        }
        AdjustUtil.setWriteDimMemFilter(qs, this.getModelId(), this.bizmodelId, this.getCurrentDimNumber(propName));
    }

    public String getCurrentDimNumber(String controlKey) {
        return this.getCurrentDimNum(controlKey);
    }

    private QFilter getDimQFilter(String ctrlKey) {
        QFilter qf = null;
        long modelId = this.getModelId();
        qf = new QFilter("model", "=", (Object)modelId);
        qf.and("level", ">", (Object)1);
        qf.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        String dimNum = this.getCurrentDimNum(ctrlKey);
        if (ctrlKey.contains("custom")) {
            qf.and(new QFilter("dimension.number", "=", (Object)dimNum));
        } else if ("adjentity".equals(ctrlKey)) {
            qf.and(new QFilter("number", "!=", (Object)"RatePreset"));
        } else if ("version".equals(ctrlKey)) {
            qf.and("isactual", "!=", (Object)1);
        } else if ("year".equals(ctrlKey)) {
            qf.and("longnumber", "like", (Object)"Year!AllYear!%");
        }
        return qf;
    }

    private String getCurrentDimNum(String ctrlKey) {
        String dimNum = null;
        if (ctrlKey.contains("custom")) {
            String customDimStr = this.getPageCache().get(customDimsInfoCache);
            DynamicInfoCollection customDims = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
            dimNum = (String)customDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)ctrlKey);
        } else {
            for (SysDimensionEnum dimensionEnum : SysDimensionEnum.values()) {
                if (!ctrlKey.contains(dimensionEnum.getNumber().toLowerCase())) continue;
                dimNum = dimensionEnum.getNumber();
            }
        }
        return dimNum;
    }

    @Override
    public Long getModelId() {
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        return Convert.toLong((Object)model);
    }

    public void cellClick(CellClickEvent e) {
        String entryKey;
        this.initParams();
        switch (entryKey = e.getFieldKey()) {
            case "operationcolumnap": {
                this.getPageCache().put("cellClick", "1");
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u65b9\u6848?", (String)"EbAdjustProjectPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteProject", (IFormPlugin)this));
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent e) {
        EntryGrid source = (EntryGrid)e.getSource();
        int[] selectRows = source.getSelectRows();
        if (selectRows.length == 1) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTITY, selectRows[0]);
            this.setEntryLock(rowEntity.getString("textfield"));
        }
    }

    private boolean isStringBuffList(DynamicObjectCollection event) {
        HashSet<String> buffList = new HashSet<String>();
        for (DynamicObject dynamicObject : event) {
            StringBuilder stringBuilder = new StringBuilder();
            String adjentity = dynamicObject.getString("adjentity.id");
            String adjaccount = dynamicObject.getString("adjaccount.id");
            stringBuilder.append(adjentity).append(adjaccount);
            int infos = this.getAdjcustomdim();
            if (infos > 0) {
                for (int i = 1; i <= infos; ++i) {
                    stringBuilder.append(dynamicObject.getString("adjcustomdim" + i + ".id"));
                }
            }
            if (this.isBgmOrBg) {
                stringBuilder.append(dynamicObject.getString("adjmetric.id"));
            }
            buffList.add(stringBuilder.toString());
        }
        return event.size() != buffList.size();
    }

    private String checkDimMemberPerm(DynamicObjectCollection entryEntity) {
        ArrayList<String> errorInfoList = new ArrayList<String>(16);
        int rowNum = 0;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(Long.valueOf(this.bizmodelId));
        for (DynamicObject dynamicObject : entryEntity) {
            Set writePermMembIds;
            ++rowNum;
            StringBuilder errorInfo = new StringBuilder();
            if (dynamicObject.get("adjentity") != null) {
                Long entityMemId = dynamicObject.getLong("adjentity.id");
                Long entityViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
                Set writePermMembIds2 = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Entity.getNumber(), (Long)this.getModelId(), (Long)this.bizmodelId, (Long)entityViewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
                if (writePermMembIds2 != null && !writePermMembIds2.contains(entityMemId)) {
                    errorInfo.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6210\u5458\u6ca1\u6709\u5199\u5165\u6743\u9650", (String)"EbAdjustProjectPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
                }
            }
            if (dynamicObject.get("adjaccount") != null) {
                Long accountMemId = dynamicObject.getLong("adjaccount.id");
                writePermMembIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Account.getNumber(), (Long)this.getModelId(), (Long)this.bizmodelId, (Long)0L, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
                if (writePermMembIds != null && !writePermMembIds.contains(accountMemId)) {
                    errorInfo.append(ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u6ca1\u6709\u5199\u5165\u6743\u9650", (String)"EbAdjustProjectPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
                }
            }
            if (this.isBgmOrBg && dynamicObject.get("adjmetric") != null) {
                Long metricMemId = dynamicObject.getLong("adjmetric.id");
                writePermMembIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.Metric.getNumber(), (Long)this.getModelId(), (Long)this.bizmodelId, (Long)0L, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
                if (writePermMembIds != null && !writePermMembIds.contains(metricMemId)) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5ea6\u91cf\u6210\u5458\u6ca1\u6709\u5199\u5165\u6743\u9650", (String)"EbAdjustProjectPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
                }
            }
            for (DynamicInfoCollection.InfoObject info : this.customdimInfo.getValues()) {
                String controlKey = (String)info.getValueByPropName("controlkey");
                if (dynamicObject.get(controlKey) == null) continue;
                Long dimMemberId = dynamicObject.getLong(controlKey + ".id");
                String dimKeyName = this.getCurrentDimNumber(controlKey);
                Long dimViewId = (Long)dimViewMap.get(dimKeyName);
                Set writePermMembIds3 = DimMembPermHelper.getPermMembIds((String)dimKeyName, (Long)this.getModelId(), (Long)this.bizmodelId, (Long)dimViewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
                if (writePermMembIds3 == null || writePermMembIds3.contains(dimMemberId)) continue;
                String name = (String)info.getValueByPropName("name");
                errorInfo.append(name).append(ResManager.loadKDString((String)"\u6210\u5458\u6ca1\u6709\u5199\u5165\u6743\u9650", (String)"EbAdjustProjectPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(",");
            }
            if (!StringUtils.isNotEmpty((String)errorInfo.toString())) continue;
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(","));
            String rowError = ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a%2", (String)"EbAdjustProjectPlugin_new_02", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum, errorInfo});
            errorInfoList.add(rowError);
        }
        return String.join((CharSequence)";", errorInfoList);
    }

    private String checkDimMemberView(DynamicObjectCollection entryEntity) {
        ArrayList<String> errorInfoList = new ArrayList<String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        int rowNum = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            ++rowNum;
            HashSet<String> dimMemberNames = new HashSet<String>(16);
            if (dynamicObject.get("adjentity") != null) {
                Long orgId = dynamicObject.getLong("adjentity.id");
                Long orgViewId = modelCacheHelper.getViewByBusModelAndDimNumber(Long.valueOf(this.bizmodelId), SysDimensionEnum.Entity.getNumber());
                Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, orgId);
                if (member == null) {
                    dimMemberNames.add(dynamicObject.getString("adjentity.name"));
                }
            }
            for (DynamicInfoCollection.InfoObject info : this.customdimInfo.getValues()) {
                Long dimViewId;
                String controlKey = (String)info.getValueByPropName("controlkey");
                if (dynamicObject.get(controlKey) == null) continue;
                Long dimMemberId = dynamicObject.getLong(controlKey + ".id");
                String dimNumber = this.getCurrentDimNumber(controlKey);
                Member member = modelCacheHelper.getMember(dimNumber, dimViewId = modelCacheHelper.getViewByBusModelAndDimNumber(Long.valueOf(this.bizmodelId), dimNumber), dimMemberId);
                if (member != null) continue;
                dimMemberNames.add(dynamicObject.getString(controlKey + ".name"));
            }
            if (dimMemberNames.isEmpty()) continue;
            String errorInfo = String.join((CharSequence)";", dimMemberNames);
            String rowError = ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff1a\u7ef4\u5ea6\u6210\u5458\u201c%2\u201d\u4e0d\u662f\u5f53\u524d\u9ed8\u8ba4\u89c6\u56fe\u7684\u6210\u5458\u3002", (String)"EbAdjustProjectPlugin_new_05", (String)"epm-eb-formplugin", (Object[])new Object[]{rowNum, errorInfo}) + "\n";
            errorInfoList.add(rowError);
        }
        return String.join((CharSequence)"", errorInfoList);
    }
}

