/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.business.adjust.validator.AbstractAdjustValidator;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.calc.impl.LimitBalance;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.formplugin.bgadjust.BaseEbAdjustBillEditPlugin;
import kd.epm.eb.formplugin.bgadjust.CheckAdjust;
import kd.epm.eb.formplugin.bgadjust.CheckAdjustment;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ExpenseBudgetAdjustPlugin
extends BaseEbAdjustBillEditPlugin {
    public void initialize() {
        super.initialize();
        this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)true);
        this.periodGroupKeys = new String[]{"period", "limitbalanceshow", "limitbalance", "budgetbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
        this.periodKey = "period";
    }

    @Override
    public void setF7Visible() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"year", "multperiod"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizmodel", "budgetperiods"});
    }

    @Override
    public void setDefDataTypeMember(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add("number", "=", (Object)"Budget");
        DynamicObject memberObj = QueryServiceHelper.queryOne((String)"epm_datatypemembertree", (String)"id", (QFilter[])qb.toArray());
        if (memberObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9ed8\u8ba4\u7684\u6570\u636e\u7c7b\u578b\u6210\u5458\u9884\u7b97\u6570\u5931\u8d25\u3002", (String)"OverallBudgetAdjustPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("datatype", memberObj.get("id"));
    }

    @Override
    public void setDefChangeTypeMember(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add("number", "=", (Object)"CurrentPeriod");
        DynamicObject memberObj = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id", (QFilter[])qb.toArray());
        if (memberObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9ed8\u8ba4\u7684\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u201c\u672c\u671f\u201d\u5931\u8d25\u3002", (String)"BaseEbAdjustBillEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("changetype", memberObj.get("id"));
    }

    @Override
    public List<Date> getPeriodDateList() {
        ArrayList<Date> periodDateList = new ArrayList<Date>(16);
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        if (yearObj == null) {
            return periodDateList;
        }
        String yearNumber = (String)yearObj.get("number");
        String year = yearNumber.split("Y")[1];
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("multperiod");
        if (periods == null) {
            return periodDateList;
        }
        for (DynamicObject period : periods) {
            Long baseDataId = period.getLong("fbasedataid_id");
            DynamicObject periodDim = QueryServiceHelper.queryOne((String)"epm_periodmembertree", (String)"effmonth,effday,expmonth,expday", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "=", (Object)baseDataId)});
            if (periodDim == null) continue;
            String effMonth = periodDim.getString("effmonth");
            String effDay = periodDim.getString("effday");
            String expMonth = periodDim.getString("expmonth");
            String expDay = periodDim.getString("expday");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                Date effDate = dateFormat.parse(year + "/" + effMonth + "/" + effDay);
                periodDateList.add(effDate);
                Date expDate = dateFormat.parse(year + "/" + expMonth + "/" + expDay);
                periodDateList.add(expDate);
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return periodDateList;
    }

    @Override
    public void buildCustomDimInfo(int index) {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.valueOf(false), new String[]{"adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6"});
        DynamicInfoCollection customDimInfo = this.getCustomDimsInfoCache();
        if (!customDimInfo.isEmpty()) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            for (DynamicInfoCollection.InfoObject info : customDimInfo.getValues()) {
                String controlKey = (String)info.getValueByPropName("controlkey");
                String name = (String)info.getValueByPropName("name");
                grid.setColumnProperty(controlKey, "header", (Object)new LocaleString(name));
                formView.setVisible(Boolean.valueOf(true), new String[]{controlKey});
            }
        }
        this.getPageCache().put("customDimsInfoCache", SerializationUtils.serializeToBase64((Object)customDimInfo));
    }

    @Override
    public DynamicInfoCollection getCustomDimsInfo() {
        return AdjustHelper.buildCustomDimInfo((Long)this.getModelId());
    }

    @Override
    public void setFormShowParameter(FormShowParameter formShowParameter) {
        formShowParameter.setFormId("eb_adjustproject");
    }

    @Override
    public boolean checkAdjustment(String itemClickBar) {
        IDataModel dataModel = this.getModel();
        DynamicInfoCollection customDimsInfoCache = this.getCustomDimsInfoCache();
        if (this.getFormType().equals("1")) {
            return CheckAdjustment.IsAdjustment((IDataModel)dataModel, (DynamicInfoCollection)customDimsInfoCache, (IFormView)this.getView(), (String)itemClickBar, (String)this.getFormType(), (String)AdjustUtil.getFormType(dataModel));
        }
        if (this.getFormType().equals("2")) {
            return CheckAdjust.IsAdjust((IDataModel)dataModel, (DynamicInfoCollection)customDimsInfoCache, (IFormView)this.getView(), (String)itemClickBar, (String)this.getFormType(), (String)AdjustUtil.getFormType(dataModel));
        }
        return false;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        super.beforeF7Select(arg0);
        long modelId = this.getModelId();
        if (modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"BaseEbAdjustBillEditPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String propName = arg0.getProperty().getName();
        DynamicObject dimObj = NewF7Utils.getDimension((Long)this.getModelId(), (String)this.getCurrentDimNumber(propName));
        boolean entryGridKey = this.isEntryGridKey(propName);
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)this.getModelId(), (DynamicObject)dimObj, (String)ListSelectedRow.class.getName());
        if (entryGridKey) {
            f7Param = NewF7Utils.multipleF7((Long)this.getModelId(), (DynamicObject)dimObj, (String)ListSelectedRow.class.getName());
        }
        f7Param.setOnlySelLeaf(true);
        f7Param.setPermType(DimMembPermType.WRITE);
        f7Param.setCanSelectRoot(false);
        if ("multperiod".equals(propName)) {
            f7Param.setMultiSelect(true);
        }
        f7Param.addCustomFilter(this.getDimQFilters(propName));
        f7Param.setCombPermMap(this.getCurrMembers(this.getCurrentDimNumber(propName)));
        if (entryGridKey) {
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
        } else {
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param);
        }
    }

    @Override
    public void setRowEntity(DynamicObjectCollection entryWin, int count) {
        for (DynamicObject dynamicObject : entryWin) {
            int row = this.getModel().createNewEntryRow("entryentity");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", row);
            rowEntity.set("adjentity", dynamicObject.get("adjentity"));
            rowEntity.set("adjaccount", dynamicObject.get("adjaccount"));
            if (count <= 0) continue;
            for (int i = 1; i <= count; ++i) {
                rowEntity.set("adjcustomdim" + i, dynamicObject.get("adjcustomdim" + i));
            }
        }
    }

    @Override
    public void changeBudgetDataForRow(List<Object> periodNums, Set<Integer> completedRowNums) {
        HashSet<Integer> periodColumns = new HashSet<Integer>(periodNums.size());
        for (int i = 0; i < periodNums.size(); ++i) {
            periodColumns.add(i);
        }
        AdjustBill adjustBill = AdjustBillConvertor.dataModel2AdjustBill((IDataModel)this.getModel(), completedRowNums, periodColumns);
        IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.EXPENSE);
        Map rowBudgetData = adjustBillService.getRowBudgetData(adjustBill);
        for (Map.Entry entry : rowBudgetData.entrySet()) {
            String key = (String)entry.getKey();
            String periodNum = key.substring(0, key.indexOf("!!"));
            int periodIndex = periodNums.indexOf(periodNum) + 1;
            for (Pair rowValue : (List)entry.getValue()) {
                this.getModel().setValue("adjbudgetdata" + periodIndex, rowValue.getValue(), ((Integer)rowValue.getKey()).intValue());
                Object value = this.getModel().getValue("adjadjustdata" + periodIndex, ((Integer)rowValue.getKey()).intValue());
                BigDecimal adjustData = BigDecimal.ZERO;
                if (value != null) {
                    adjustData = (BigDecimal)value;
                }
                this.getModel().setValue("adjfinaldata" + periodIndex, (Object)adjustData.add((BigDecimal)rowValue.getValue()), ((Integer)rowValue.getKey()).intValue());
            }
        }
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        boolean isShowBudgetBalance = Boolean.parseBoolean(this.getPageCache().get("isShowBudgetBalance"));
        boolean isShowLimitBalance = Boolean.parseBoolean(this.getPageCache().get("isShowLimitBalance"));
        if (isShowBudgetBalance || isShowLimitBalance) {
            LimitBalance limitCalc = new LimitBalance();
            List<CompareDataPojo> compareDataPojoList = this.getCompareDataList(completedRowNums, true);
            Collection<IBudgetBalance> budgetBalances = this.queryBudgetBalance(completedRowNums, true, compareDataPojoList, this.getFormType());
            for (IBudgetBalance budgetBalance : budgetBalances) {
                for (CompareDataPojo compareDataPojo : compareDataPojoList) {
                    if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)customDims)) continue;
                    String periodNum = compareDataPojo.getPreiod();
                    int periodIndex = periodNums.indexOf(periodNum) + 1;
                    BigDecimal balance = budgetBalance.getBalance();
                    BigDecimal limitbalance = limitCalc.getLimitBalance(budgetBalance);
                    BigDecimal limitbalanceshow = limitCalc.calc(budgetBalance, this.getModel().getValue("adjbudgetdata" + periodIndex, compareDataPojo.getRow()));
                    if (balance == null) {
                        balance = BigDecimal.ZERO;
                    }
                    if (limitbalance == null) {
                        limitbalance = BigDecimal.ZERO;
                    }
                    if (limitbalanceshow == null) {
                        limitbalanceshow = BigDecimal.ZERO;
                    }
                    if (isShowBudgetBalance) {
                        this.getModel().setValue("adjbudgetbalance" + periodIndex, (Object)balance, compareDataPojo.getRow());
                    }
                    if (isShowLimitBalance) {
                        boolean isBeyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                        this.getModel().setValue("adjlimitbalance" + periodIndex, (Object)limitbalance, compareDataPojo.getRow());
                        this.getModel().setValue("adjlimitbalanceshow" + periodIndex, (Object)limitbalanceshow, compareDataPojo.getRow());
                        this.getModel().setValue("adjbeyond" + periodIndex, (Object)isBeyond, compareDataPojo.getRow());
                        continue;
                    }
                    this.getModel().setValue("adjlimitbalance" + periodIndex, null, compareDataPojo.getRow());
                    this.getModel().setValue("adjlimitbalanceshow" + periodIndex, null, compareDataPojo.getRow());
                    this.getModel().setValue("adjbeyond" + periodIndex, (Object)true, compareDataPojo.getRow());
                }
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.setEntryEntityNewAddUserDefinedDimNoneMember();
    }

    @Override
    public void updateDataAfterOpen() {
        if (!this.billHeadOver()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        String billStatus = (String)dataModel.getValue("billstatus");
        if (AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus) || AdjustBillStateEnum.DISCARD.getShortNumber().equals(billStatus)) {
            return;
        }
        this.checkRowsCompleted("adjdetailentity");
        Set<Integer> completedRowNum = this.getCompletedRowNum();
        if (CollectionUtils.isEmpty(completedRowNum)) {
            return;
        }
        AdjustBill adjustBill = AdjustBillConvertor.dataModel2AdjustBill((IDataModel)dataModel, completedRowNum);
        IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.EXPENSE);
        Map rowBudgetData = adjustBillService.getRowBudgetData(adjustBill);
        DynamicObjectCollection entityRows = dataModel.getEntryEntity("adjdetailentity");
        for (List rowValueList : rowBudgetData.values()) {
            for (Pair rowValue : rowValueList) {
                DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)rowValue.getKey()).intValue());
                BigDecimal adjustData = entityObj.getBigDecimal("adjustdata");
                entityObj.set("finaldata", (Object)adjustData.add((BigDecimal)rowValue.getValue()));
                entityObj.set("budgetdata", rowValue.getValue());
            }
        }
        boolean isShowBudgetBalance = Boolean.parseBoolean(this.getPageCache().get("isShowBudgetBalance"));
        boolean isShowLimitBalance = Boolean.parseBoolean(this.getPageCache().get("isShowLimitBalance"));
        if (isShowBudgetBalance || isShowLimitBalance) {
            LimitBalance limitCalc = new LimitBalance();
            List<CompareDataPojo> compareDataPojoList = this.getCompareDataList(completedRowNum, false);
            Collection<IBudgetBalance> budgetBalances = this.queryBudgetBalance(completedRowNum, false, compareDataPojoList, this.getFormType());
            block2: for (IBudgetBalance budgetBalance : budgetBalances) {
                for (CompareDataPojo compareDataPojo : compareDataPojoList) {
                    if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)this.getCustomDimsInfoCache())) continue;
                    DynamicObject entityObj = (DynamicObject)entityRows.get(compareDataPojo.getRow());
                    BigDecimal balance = budgetBalance.getBalance();
                    BigDecimal limitbalance = limitCalc.getLimitBalance(budgetBalance);
                    BigDecimal limitbalanceshow = limitCalc.calc(budgetBalance, entityObj.get("budgetdata"));
                    if (balance == null) {
                        balance = BigDecimal.ZERO;
                    }
                    if (limitbalance == null) {
                        limitbalance = BigDecimal.ZERO;
                    }
                    if (limitbalanceshow == null) {
                        limitbalanceshow = BigDecimal.ZERO;
                    }
                    if (isShowBudgetBalance) {
                        entityObj.set("budgetbalance", (Object)balance);
                    }
                    if (isShowLimitBalance) {
                        boolean beyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                        entityObj.set("limitbalance", (Object)limitbalance);
                        entityObj.set("limitbalanceshow", (Object)limitbalanceshow);
                        entityObj.set("beyond", (Object)beyond);
                        continue block2;
                    }
                    entityObj.set("limitbalance", null);
                    entityObj.set("limitbalanceshow", null);
                    entityObj.set("beyond", (Object)true);
                    continue block2;
                }
            }
        }
    }

    @Override
    public List<Map<String, String>> getDimList(Set<Integer> completedRowNums, boolean isNew) {
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)this.getModelId(), (String)this.getFormType(), (boolean)ModelUtil.isEbOrBgModel((Long)this.getModelId()));
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        DynamicObject dataTypeObj = (DynamicObject)this.getModel().getValue("datatype");
        DynamicObject changeTypeObj = (DynamicObject)this.getModel().getValue("changetype");
        DynamicObject versionObj = (DynamicObject)this.getModel().getValue("version");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("multperiod");
        String yearNumber = yearObj.getString("number");
        String dataTypeNumber = dataTypeObj.getString("number");
        String changeTypeNumber = changeTypeObj.getString("number");
        String versionNumber = versionObj.getString("number");
        String currencyNumber = currencyObj.getString("number");
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(16);
        for (Integer i : completedRowNums) {
            DynamicObject rowObj;
            if (isNew) {
                rowObj = this.getModel().getEntryRowEntity("entryentity", i.intValue());
                String entryNumber = rowObj.getString("adjentity.number");
                String accountNumber = rowObj.getString("adjaccount.number");
                for (int j = 0; j < periods.size(); ++j) {
                    String periodNumber = ((DynamicObject)periods.get(j)).getString("fbasedataid.number");
                    HashMap<Object, String> dimMap = new HashMap<Object, String>(16);
                    dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
                    dimMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
                    dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
                    dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
                    dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                    dimMap.put(SysDimensionEnum.Period.getNumber(), periodNumber);
                    dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
                    dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
                    dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
                    for (DynamicInfoCollection.InfoObject customDim : customDims.getValues()) {
                        String controlKey = (String)customDim.getValueByPropName("controlkey");
                        DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey);
                        if (customDimObj == null) continue;
                        dimMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
                    }
                    dimList.add(dimMap);
                }
                continue;
            }
            rowObj = this.getModel().getEntryRowEntity("adjdetailentity", i.intValue());
            String periodNumber = rowObj.getString("period.number");
            String entryNumber = rowObj.getString("entity.number");
            String accountNumber = rowObj.getString("account.number");
            HashMap<Object, String> dimMap = new HashMap<Object, String>(16);
            dimMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
            dimMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMap.put(SysDimensionEnum.Period.getNumber(), periodNumber);
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            for (DynamicInfoCollection.InfoObject customDim : customDims.getValues()) {
                String controlKey = (String)customDim.getValueByPropName("controlkey");
                DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey = controlKey.substring(3));
                if (customDimObj == null) continue;
                dimMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
            }
            dimList.add(dimMap);
        }
        return dimList;
    }

    private List<CompareDataPojo> getCompareDataList(Set<Integer> completedRowNums, boolean isNew) {
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        DynamicObject yearObj = (DynamicObject)this.getModel().getValue("year");
        DynamicObject versionObj = (DynamicObject)this.getModel().getValue("version");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("multperiod");
        long model = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        String dataTypeNumber = ((DynamicObject)this.getModel().getValue("datatype")).getString("number");
        String yearNumber = yearObj.getString("number");
        String versionNumber = versionObj.getString("number");
        String currencyNumber = currencyObj.getString("number");
        ArrayList<CompareDataPojo> compareDataPojoList = new ArrayList<CompareDataPojo>(16);
        for (Integer i : completedRowNums) {
            DynamicObject rowObj;
            if (isNew) {
                rowObj = this.getModel().getEntryRowEntity("entryentity", i.intValue());
                String entryNumber = rowObj.getString("adjentity.number");
                String accountNumber = rowObj.getString("adjaccount.number");
                for (int j = 1; j < periods.size() + 1; ++j) {
                    DynamicObject periodObj = (DynamicObject)rowObj.get("adjperiod" + j);
                    if (periodObj == null) continue;
                    String periodNumber = periodObj.getString("number");
                    CompareDataPojo compareDataPojo = new CompareDataPojo();
                    compareDataPojo.setRow(i.intValue());
                    compareDataPojo.setPreiod(periodNumber);
                    compareDataPojo.setYearNumber(yearNumber);
                    compareDataPojo.setVersionNumber(versionNumber);
                    compareDataPojo.setCurrencyNumber(currencyNumber);
                    compareDataPojo.setOrgnumber(entryNumber);
                    compareDataPojo.setAccountNumber(accountNumber);
                    compareDataPojo.setSubmitValue(BigDecimal.ZERO);
                    compareDataPojo.setModel(Long.valueOf(model));
                    compareDataPojo.setDatatypeNumber(dataTypeNumber);
                    HashMap<String, String> customDimMap = new HashMap<String, String>(16);
                    HashMap<Object, String> customDimMemberMap = new HashMap<Object, String>(16);
                    for (DynamicInfoCollection.InfoObject customDim : customDims.getValues()) {
                        String controlKey = (String)customDim.getValueByPropName("controlkey");
                        DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey);
                        if (customDimObj == null) continue;
                        customDimMap.put(controlKey, customDimObj.getString("number"));
                        customDimMemberMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
                    }
                    compareDataPojo.setCustomdimMap(customDimMap);
                    compareDataPojo.setCustomdimMemberMap(customDimMemberMap);
                    compareDataPojoList.add(compareDataPojo);
                }
                continue;
            }
            rowObj = this.getModel().getEntryRowEntity("adjdetailentity", i.intValue());
            String periodNumber = rowObj.getString("period.number");
            String entryNumber = rowObj.getString("entity.number");
            String accountNumber = rowObj.getString("account.number");
            CompareDataPojo compareDataPojo = new CompareDataPojo();
            compareDataPojo.setRow(i.intValue());
            compareDataPojo.setPreiod(periodNumber);
            compareDataPojo.setYearNumber(yearNumber);
            compareDataPojo.setVersionNumber(versionNumber);
            compareDataPojo.setCurrencyNumber(currencyNumber);
            compareDataPojo.setOrgnumber(entryNumber);
            compareDataPojo.setAccountNumber(accountNumber);
            compareDataPojo.setSubmitValue(rowObj.getBigDecimal("submitvalue"));
            compareDataPojo.setModel(Long.valueOf(model));
            compareDataPojo.setDatatypeNumber(dataTypeNumber);
            HashMap<String, String> customDimMap = new HashMap<String, String>(16);
            HashMap<Object, String> customDimMemberMap = new HashMap<Object, String>(16);
            for (DynamicInfoCollection.InfoObject customDim : customDims.getValues()) {
                String controlKey = (String)customDim.getValueByPropName("controlkey");
                DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey = controlKey.substring(3));
                if (customDimObj == null) continue;
                customDimMap.put(controlKey, customDimObj.getString("number"));
                customDimMemberMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
            }
            compareDataPojo.setCustomdimMap(customDimMap);
            compareDataPojo.setCustomdimMemberMap(customDimMemberMap);
            compareDataPojoList.add(compareDataPojo);
        }
        return compareDataPojoList;
    }

    private Collection<IBudgetBalance> queryBudgetBalance(Set<Integer> completedRowNums, boolean isNew, List<CompareDataPojo> compareDataPojoList, String formType) {
        List<Map<String, String>> dimList = this.getDimList(completedRowNums, isNew);
        log.info("[ExpenseBudgetAdjust] queryBudgetBalance dimList={}", (Object)dimList.toString());
        ArrayList types = new ArrayList(16);
        if (!AdjustHelper.isExitMixturePeriod(dimList, types)) {
            return AdjustHelper.getAllIbCollection((Long)this.getModelId(), dimList, types, compareDataPojoList, (String)formType);
        }
        return AdjustHelper.queryBalance((Long)this.getModelId(), dimList, types, compareDataPojoList, (String)formType);
    }

    public boolean isEbForm() {
        return true;
    }
}

