/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.AdjustBillConvertor;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.business.adjust.validator.AbstractAdjustValidator;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.adjust.AdjustBill;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AdjustBillStateEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.calc.impl.LimitBalance;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.formplugin.bgadjust.BaseEbAdjustBillEditPlugin;
import kd.epm.eb.formplugin.bgadjust.CheckAdjust;
import kd.epm.eb.formplugin.bgadjust.CheckAdjustment;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;

public class OverallBudgetAdjustPlugin
extends BaseEbAdjustBillEditPlugin {
    public void initialize() {
        super.initialize();
        this.entryEntityKeys = AbstractAdjustValidator.getEntityKeys((boolean)false);
        this.periodGroupKeys = new String[]{"budgetperiod", "limitbalanceshow", "limitbalance", "budgetdata", "adjustdata", "finaldata", "adjexplain", "beyond"};
        this.periodKey = "budgetperiod";
    }

    @Override
    public void setF7Visible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"year", "multperiod"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bizmodel", "budgetperiods"});
        Long id = this.getModelId();
        boolean isBG = AdjustUtil.isBGModel(id);
        if (isBG) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bizmodel"});
        }
    }

    @Override
    public boolean needResponseTheChanged() {
        return super.needResponseTheChanged();
    }

    @Override
    public void setDefDataTypeMember(Long modelId) {
        try {
            if (IDUtils.isNull((Long)modelId)) {
                return;
            }
            Dimension dataTypes = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getDimension(SysDimensionEnum.DataType.getNumber());
            Member budget = dataTypes.getMember(Long.valueOf(0L), "Budget");
            Set writePermMembIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.DataType.getNumber(), (Long)this.getModelId(), (Long)this.getBizModelId(), (Long)0L, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
            if (budget.isLeaf()) {
                if (writePermMembIds != null && !writePermMembIds.contains(budget.getId())) {
                    this.getModel().setValue("datatype", null);
                } else {
                    this.getModel().setValue("datatype", (Object)budget.getId());
                }
            } else {
                ArrayList<Member> leafMembers = new ArrayList<Member>(dataTypes.getLeafMembers());
                long budgetId = budget.getId();
                leafMembers.removeIf(p -> budgetId != p.getParentId());
                leafMembers.sort(Comparator.comparingInt(BaseCache::getSeq));
                if (leafMembers.size() > 0) {
                    if (writePermMembIds != null && !writePermMembIds.contains(((Member)leafMembers.get(0)).getId())) {
                        this.getModel().setValue("datatype", null);
                    } else {
                        this.getModel().setValue("datatype", (Object)((Member)leafMembers.get(0)).getId());
                    }
                } else {
                    this.getModel().setValue("datatype", null);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u9ed8\u8ba4\u7684\u6570\u636e\u7c7b\u578b\u6210\u5458\u201c\u9884\u7b97\u6570\u201d\u5931\u8d25%1\u3002", (String)"OverallBudgetAdjustPlugin_new_01", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getCause()}));
        }
    }

    @Override
    public void setDefChangeTypeMember(Long modelId) {
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add("number", "=", (Object)"CurrentPeriod");
        DynamicObject memberObj = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"id", (QFilter[])qb.toArray());
        if (memberObj != null) {
            Long dimViewId = AdjustHelper.getDimDefaultViewId((Long)this.getModelId(), (Long)this.getBizModelId(), (String)SysDimensionEnum.ChangeType.getNumber());
            Set writePermMembIds = DimMembPermHelper.getPermMembIds((String)SysDimensionEnum.ChangeType.getNumber(), (Long)this.getModelId(), (Long)this.getBizModelId(), (Long)dimViewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
            if (writePermMembIds != null && !writePermMembIds.contains(memberObj.get("id"))) {
                this.getModel().setValue("changetype", null);
            } else {
                this.getModel().setValue("changetype", memberObj.get("id"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9ed8\u8ba4\u7684\u53d8\u52a8\u7c7b\u578b\u6210\u5458\u201c\u672c\u671f\u201d\u5931\u8d25\u3002", (String)"BaseEbAdjustBillEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public List<Date> getPeriodDateList() {
        ArrayList<Date> periodDateList = new ArrayList<Date>(16);
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
        for (DynamicObject period : periods) {
            Long baseDataId = period.getLong("fbasedataid.id");
            String periodNumber = period.getString("fbasedataid.number");
            String year = periodNumber.substring(2, 6);
            DynamicObject periodDim = QueryServiceHelper.queryOne((String)"epm_bperiodmembertree", (String)"effmonth,effday,expmonth,expday", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("id", "=", (Object)baseDataId)});
            if (periodDim == null) continue;
            String effMonth = periodDim.getString("effmonth");
            String effDay = periodDim.getString("effday");
            String expMonth = periodDim.getString("expmonth");
            String expDay = periodDim.getString("expday");
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                Date effDate = dateFormat.parse(year + "/" + effMonth + "/" + effDay);
                periodDateList.add(effDate);
                Date expDate = dateFormat.parse(year + "/" + expMonth + "/" + expDay);
                periodDateList.add(expDate);
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return periodDateList;
    }

    @Override
    public DynamicInfoCollection getCustomDimsInfo() {
        return AdjustHelper.buildCustomDimInfo((Long)this.getModelId(), (Long)this.getBizModelId());
    }

    @Override
    public void setFormShowParameter(FormShowParameter formShowParameter) {
        formShowParameter.setFormId("bgm_adjustproject");
        formShowParameter.setCustomParam("bizmodelId", (Object)this.getBizModelId());
        formShowParameter.setCustomParam("isBgm", (Object)true);
    }

    @Override
    public boolean checkAdjustment(String itemClickBar) {
        IDataModel dataModel = this.getModel();
        DynamicInfoCollection customDimsInfoCache = this.getCustomDimsInfoCache();
        if (this.getFormType().equals("1")) {
            return CheckAdjustment.bgmIsAdjustment((IDataModel)dataModel, (DynamicInfoCollection)customDimsInfoCache, (IFormView)this.getView(), (String)itemClickBar, (String)this.getFormType(), (String)AdjustUtil.getFormType(dataModel));
        }
        if (this.getFormType().equals("2")) {
            return CheckAdjust.bgmIsAdjust((IDataModel)dataModel, (DynamicInfoCollection)customDimsInfoCache, (IFormView)this.getView(), (String)itemClickBar, (String)this.getFormType(), (String)AdjustUtil.getFormType(dataModel));
        }
        return false;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        MemberF7Parameter f7Param;
        Long ruleId;
        super.beforeF7Select(arg0);
        int row = arg0.getRow();
        Long modelId = this.getModelId();
        String propName = arg0.getProperty().getName();
        ListShowParameter showP = (ListShowParameter)arg0.getFormShowParameter();
        List<QFilter> qs = new ArrayList(16);
        ArrayList<Long> datasetList = new ArrayList<Long>(16);
        if (!"bizmodel".equalsIgnoreCase(propName) && !"adjustrule".equalsIgnoreCase(propName) && IDUtils.isNotNull((Long)(ruleId = this.getAdjustRuleId()))) {
            this.setAdjustRuleFilter(qs, propName, ruleId, row, datasetList);
        }
        if ("bizmodel".equals(propName)) {
            qs = showP.getListFilterParameter().getQFilters();
            qs.add(new QFilter("model", "=", (Object)modelId));
        } else if ("datatype".equals(propName)) {
            qs.add(new QFilter("longnumber", "like", (Object)"DataType!Budget%"));
            f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.DataType.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setOnlySelLeaf(true);
            f7Param.setBusModelId(this.getBizModelId());
            f7Param.setPermType(DimMembPermType.WRITE);
            f7Param.addCustomFilter(qs);
            f7Param.setCanSelectRoot(false);
            f7Param.setCombPermMap(this.getCurrMembers(this.getCurrentDimNumber(propName)));
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param);
        } else if ("adjustrule".equals(propName)) {
            if (this.getBizModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"OverallBudgetAdjustPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            qs = showP.getListFilterParameter().getQFilters();
            qs.add(new QFilter("model", "=", (Object)this.getModelId()));
            qs.add(new QFilter("bizmodel", "=", (Object)this.getBizModelId()));
            qs.add(new QFilter("rulestate", "=", (Object)"1"));
            qs.add(new QFilter("billtype", "=", (Object)"0").or(new QFilter("billtype", "=", (Object)this.getFormType())));
            qs.add(new QFilter("assigntype", "=", (Object)"0").or(new QFilter("userid", "like", (Object)("%" + UserUtils.getUserId() + "%"))));
        } else if ("adjentity".equals(propName)) {
            if (this.getBizModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"OverallBudgetAdjustPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            qs.add(new QFilter("number", "!=", (Object)"RatePreset"));
            f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(this.getBizModelId());
            f7Param.setViewId(AdjustHelper.getDefaultOrgViewId((Long)modelId, (Long)this.getBizModelId()));
            f7Param.setSwitchViewBySelMem(false);
            f7Param.setOnlySelLeaf(true);
            f7Param.setPermType(DimMembPermType.WRITE);
            f7Param.addCustomFilter(qs);
            f7Param.setCanSelectRoot(false);
            f7Param.setCombPermMap(this.getCurrMembers(this.getCurrentDimNumber(propName)));
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
        } else if ("adjaccount".equals(propName)) {
            showP.setCustomParam("account", (Object)"adjaccount");
            if (this.getBizModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"OverallBudgetAdjustPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Account.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(this.getBizModelId());
            if (!datasetList.isEmpty()) {
                f7Param.setDatasetIds(datasetList);
            } else {
                f7Param.setDatasetIds(DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(f7Param.getBusModelId()));
            }
            f7Param.setOnlySelLeaf(true);
            f7Param.setPermType(DimMembPermType.WRITE);
            f7Param.addCustomFilter(qs);
            f7Param.setCanSelectRoot(false);
            f7Param.setCombPermMap(this.getCurrMembers(this.getCurrentDimNumber(propName)));
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
        } else if ("adjmetric".equals(propName)) {
            if (this.getBizModelId() == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"OverallBudgetAdjustPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            HashSet<String> metricMemNums = new HashSet<String>(3);
            metricMemNums.add(MetricDataTypeEnum.CURRENCY.getIndex());
            metricMemNums.add(MetricDataTypeEnum.NONMONETARY.getIndex());
            metricMemNums.add(MetricDataTypeEnum.RATE.getIndex());
            qs.add(new QFilter("datatype", "in", metricMemNums));
            MemberF7Parameter f7Param2 = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Metric.getNumber()), (String)ListSelectedRow.class.getName());
            f7Param2.setBusModelId(this.getBizModelId());
            f7Param2.setOnlySelLeaf(true);
            f7Param2.addCustomFilter(qs);
            f7Param2.setPermType(DimMembPermType.WRITE);
            f7Param2.setCanSelectRoot(false);
            f7Param2.setCombPermMap(this.getCurrMembers(this.getCurrentDimNumber(propName)));
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param2, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
        } else if (propName.contains("customdim")) {
            String dimNumber = this.getCurrentDimNumber(propName);
            MemberF7Parameter f7Param3 = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param3.setBusModelId(this.getBizModelId());
            f7Param3.setViewId(AdjustHelper.getDimDefaultViewId((Long)modelId, (Long)this.getBizModelId(), (String)dimNumber));
            f7Param3.setSwitchViewBySelMem(false);
            f7Param3.setOnlySelLeaf(true);
            f7Param3.addCustomFilter(qs);
            f7Param3.setPermType(DimMembPermType.WRITE);
            f7Param3.setCanSelectRoot(false);
            f7Param3.setCombPermMap(this.getCurrMembers(dimNumber));
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param3, (CloseCallBack)new CloseCallBack((IFormPlugin)this, propName));
        } else if (!"model".equals(propName)) {
            QFilter _filter = this.getDimQFilter(propName);
            if (_filter != null) {
                qs.add(_filter);
            }
            String dimNumber = this.getCurrentDimNumber(propName);
            MemberF7Parameter f7Param4 = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param4.setBusModelId(this.getBizModelId());
            if ("budgetperiods".equals(propName)) {
                f7Param4.setMultiSelect(true);
            }
            if ("changetype".equals(propName)) {
                f7Param4.setViewId(AdjustHelper.getDimDefaultViewId((Long)modelId, (Long)this.getBizModelId(), (String)dimNumber));
                f7Param4.setSwitchViewBySelMem(false);
            }
            f7Param4.addCustomFilter(qs);
            f7Param4.setOnlySelLeaf(true);
            f7Param4.setCanSelectRoot(false);
            f7Param4.setCombPermMap(this.getCurrMembers(this.getCurrentDimNumber(propName)));
            NewF7Utils.openF7((BeforeF7SelectEvent)arg0, (MemberF7Parameter)f7Param4);
        } else {
            qs = showP.getListFilterParameter().getQFilters();
            qs.add(ModelUtil.getModelQfilterByApp((IFormView)this.getView()));
        }
    }

    @Override
    public void setRowEntity(DynamicObjectCollection entryWin, int count) {
        this.setResponseTheChanged(false);
        HashMap<Integer, String> rowDimMap = new HashMap<Integer, String>(16);
        for (DynamicObject dynamicObject : entryWin) {
            String rowDims;
            int row = this.getModel().createNewEntryRow("entryentity");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", row);
            rowEntity.set("adjentity", dynamicObject.get("adjentity"));
            rowEntity.set("adjaccount", dynamicObject.get("adjaccount"));
            rowEntity.set("adjmetric", dynamicObject.get("adjmetric"));
            if (count > 0) {
                for (int i = 1; i <= count; ++i) {
                    rowEntity.set("adjcustomdim" + i, dynamicObject.get("adjcustomdim" + i));
                }
            }
            if (!StringUtils.isNotEmpty((String)(rowDims = this.getDimMemsForRow(dynamicObject)))) continue;
            rowDimMap.put(row, rowDims);
        }
        if (!rowDimMap.isEmpty()) {
            this.getPageCache().put("completedRowDimsCache", SerializationUtils.serializeToBase64(rowDimMap));
        }
    }

    @Override
    public void changeBudgetDataForRow(List<Object> periodNums, Set<Integer> completedRowNums) {
        block17: {
            HashSet<Integer> periodColumns = new HashSet<Integer>(periodNums.size());
            for (int i = 0; i < periodNums.size(); ++i) {
                periodColumns.add(i);
            }
            DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
            AdjustBill adjustBill = AdjustBillConvertor.dataModel2AdjustBill((IDataModel)this.getModel(), completedRowNums, periodColumns);
            IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.OVERALL);
            Map rowBudgetData = adjustBillService.getRowBudgetData(adjustBill);
            for (Map.Entry entry : rowBudgetData.entrySet()) {
                String key = (String)entry.getKey();
                String periodNum = key.substring(0, key.indexOf("!!")).split("@")[1];
                int periodIndex = periodNums.indexOf(periodNum) + 1;
                for (Object rowValue : (List)entry.getValue()) {
                    this.getModel().setValue("adjbudgetdata" + periodIndex, rowValue.getValue(), ((Integer)rowValue.getKey()).intValue());
                    Object value = this.getModel().getValue("adjadjustdata" + periodIndex, ((Integer)rowValue.getKey()).intValue());
                    BigDecimal adjustData = BigDecimal.ZERO;
                    if (value != null) {
                        adjustData = (BigDecimal)value;
                    }
                    this.getModel().setValue("adjfinaldata" + periodIndex, (Object)adjustData.add((BigDecimal)rowValue.getValue()), ((Integer)rowValue.getKey()).intValue());
                }
            }
            boolean isShowBudgetBalance = Boolean.parseBoolean(this.getPageCache().get("isShowBudgetBalance"));
            boolean isShowLimitBalance = Boolean.parseBoolean(this.getPageCache().get("isShowLimitBalance"));
            if (!isShowBudgetBalance && !isShowLimitBalance) break block17;
            boolean isExistControlDim = Boolean.parseBoolean(this.getPageCache().get("isExistControlDim"));
            if (isExistControlDim) {
                LimitBalance limitCalc = new LimitBalance();
                List<CompareDataPojo> compareDataPojoList = this.getCompareDataList(completedRowNums, true);
                log.info("queryBudgetBalance start");
                Collection<IBudgetBalance> budgetBalances = this.queryBudgetBalance(completedRowNums, true, compareDataPojoList, this.getFormType());
                log.info("queryBudgetBalance end");
                for (IBudgetBalance budgetBalance : budgetBalances) {
                    if (!CollectionUtils.isNotEmpty(compareDataPojoList)) continue;
                    Iterator<CompareDataPojo> iterator = compareDataPojoList.iterator();
                    while (iterator.hasNext()) {
                        CompareDataPojo compareDataPojo = iterator.next();
                        if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)customDims)) continue;
                        String periodNum = compareDataPojo.getPreiod();
                        int periodIndex = periodNums.indexOf(periodNum) + 1;
                        BigDecimal balance = budgetBalance.getBalance();
                        BigDecimal limitbalance = limitCalc.getLimitBalance(budgetBalance);
                        BigDecimal limitbalanceshow = limitCalc.calc(budgetBalance, this.getModel().getValue("adjbudgetdata" + periodIndex, compareDataPojo.getRow()));
                        if (balance == null) {
                            balance = BigDecimal.ZERO;
                        }
                        if (limitbalance == null) {
                            limitbalance = BigDecimal.ZERO;
                        }
                        if (limitbalanceshow == null) {
                            limitbalanceshow = BigDecimal.ZERO;
                        }
                        if (isShowBudgetBalance) {
                            this.getModel().setValue("adjbudgetbalance" + periodIndex, (Object)balance, compareDataPojo.getRow());
                        }
                        if (isShowLimitBalance) {
                            boolean beyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                            this.getModel().setValue("adjlimitbalance" + periodIndex, (Object)limitbalance, compareDataPojo.getRow());
                            this.getModel().setValue("adjlimitbalanceshow" + periodIndex, (Object)limitbalanceshow, compareDataPojo.getRow());
                            this.getModel().setValue("adjbeyond" + periodIndex, (Object)beyond, compareDataPojo.getRow());
                        } else {
                            this.getModel().setValue("adjlimitbalance" + periodIndex, null, compareDataPojo.getRow());
                            this.getModel().setValue("adjlimitbalanceshow" + periodIndex, null, compareDataPojo.getRow());
                            this.getModel().setValue("adjbeyond" + periodIndex, (Object)true, compareDataPojo.getRow());
                        }
                        iterator.remove();
                    }
                }
            } else {
                adjustBill.setActual(true);
                Map rowActualData = adjustBillService.getRowBudgetData(adjustBill);
                for (Map.Entry entry : rowActualData.entrySet()) {
                    String key = (String)entry.getKey();
                    String periodNum = key.substring(0, key.indexOf("!!")).split("@")[1];
                    int periodIndex = periodNums.indexOf(periodNum) + 1;
                    for (Pair rowValue : (List)entry.getValue()) {
                        Object value = this.getModel().getValue("adjbudgetdata" + periodIndex, ((Integer)rowValue.getKey()).intValue());
                        BigDecimal budgetData = BigDecimal.ZERO;
                        if (value != null) {
                            budgetData = (BigDecimal)value;
                        }
                        BigDecimal budgetBalance = budgetData.subtract((BigDecimal)rowValue.getValue());
                        this.getModel().setValue("adjbudgetbalance" + periodIndex, (Object)(budgetBalance.compareTo(BigDecimal.ZERO) == 0 ? null : budgetBalance), ((Integer)rowValue.getKey()).intValue());
                        this.getModel().setValue("adjlimitbalanceshow" + periodIndex, (Object)LimitBalance.getMinValue((BigDecimal)budgetBalance, (BigDecimal)budgetData), ((Integer)rowValue.getKey()).intValue());
                    }
                }
            }
        }
    }

    @Override
    public void updateDataAfterOpen() {
        block18: {
            if (!this.billHeadOver()) {
                return;
            }
            IDataModel dataModel = this.getModel();
            String billStatus = (String)dataModel.getValue("billstatus");
            if (AdjustBillStateEnum.PASS.getShortNumber().equals(billStatus) || AdjustBillStateEnum.DISCARD.getShortNumber().equals(billStatus)) {
                return;
            }
            this.checkRowsCompleted("adjdetailentity");
            Set<Integer> completedRowNums = this.getCompletedRowNum();
            if (CollectionUtils.isEmpty(completedRowNums)) {
                return;
            }
            AdjustBill adjustBill = AdjustBillConvertor.dataModel2AdjustBill((IDataModel)dataModel, completedRowNums);
            IAdjustBillService adjustBillService = AdjustHelper.getInstance((AdjustBillEnum)AdjustBillEnum.OVERALL);
            Map rowBudgetData = adjustBillService.getRowBudgetData(adjustBill);
            DynamicObjectCollection entityRows = dataModel.getEntryEntity("adjdetailentity");
            for (List rowValueList : rowBudgetData.values()) {
                for (Pair rowValue : rowValueList) {
                    DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)rowValue.getKey()).intValue());
                    BigDecimal adjustData = entityObj.getBigDecimal("adjustdata");
                    entityObj.set("finaldata", (Object)adjustData.add((BigDecimal)rowValue.getValue()));
                    entityObj.set("budgetdata", rowValue.getValue());
                }
            }
            DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
            boolean isShowBudgetBalance = Boolean.parseBoolean(this.getPageCache().get("isShowBudgetBalance"));
            boolean isShowLimitBalance = Boolean.parseBoolean(this.getPageCache().get("isShowLimitBalance"));
            if (!isShowBudgetBalance && !isShowLimitBalance) break block18;
            boolean isExistControlDim = Boolean.parseBoolean(this.getPageCache().get("isExistControlDim"));
            if (isExistControlDim) {
                Set<Integer> completedRowNum = this.getCompletedRowNum();
                if (CollectionUtils.isEmpty(completedRowNum)) {
                    return;
                }
                List<CompareDataPojo> compareDataPojoList = this.getCompareDataList(completedRowNum, false);
                LimitBalance limitCalc = new LimitBalance();
                log.info("updateDataAfterOpen queryBudgetBalance start");
                Collection<IBudgetBalance> budgetBalances = this.queryBudgetBalance(completedRowNum, false, compareDataPojoList, this.getFormType());
                log.info("updateDataAfterOpen queryBudgetBalance end");
                block2: for (IBudgetBalance budgetBalance : budgetBalances) {
                    if (!CollectionUtils.isNotEmpty(compareDataPojoList)) continue;
                    Iterator<CompareDataPojo> iterator = compareDataPojoList.iterator();
                    while (iterator.hasNext()) {
                        CompareDataPojo compareDataPojo = iterator.next();
                        if (!AdjustHelper.isDimMemberSame((IBudgetBalance)budgetBalance, (CompareDataPojo)compareDataPojo, (DynamicInfoCollection)customDims)) continue;
                        DynamicObject entityObj = (DynamicObject)entityRows.get(compareDataPojo.getRow());
                        BigDecimal balance = budgetBalance.getBalance();
                        BigDecimal limitbalance = limitCalc.getLimitBalance(budgetBalance);
                        BigDecimal limitbalanceshow = limitCalc.calc(budgetBalance, entityObj.get("budgetdata"));
                        if (balance == null) {
                            balance = BigDecimal.ZERO;
                        }
                        if (limitbalance == null) {
                            limitbalance = BigDecimal.ZERO;
                        }
                        if (limitbalanceshow == null) {
                            limitbalanceshow = BigDecimal.ZERO;
                        }
                        if (isShowBudgetBalance) {
                            entityObj.set("budgetbalance", (Object)balance);
                        }
                        if (isShowLimitBalance) {
                            boolean beyond = budgetBalance == null || budgetBalance.getSetting() == null || budgetBalance.getSetting().isBeyond();
                            entityObj.set("limitbalance", (Object)limitbalance);
                            entityObj.set("limitbalanceshow", (Object)limitbalanceshow);
                            entityObj.set("beyond", (Object)beyond);
                        } else {
                            entityObj.set("limitbalance", null);
                            entityObj.set("limitbalanceshow", null);
                            entityObj.set("beyond", (Object)true);
                        }
                        iterator.remove();
                        continue block2;
                    }
                }
            } else {
                adjustBill.setActual(true);
                Map rowActualData = adjustBillService.getRowBudgetData(adjustBill);
                for (List rowValueList : rowActualData.values()) {
                    for (Pair rowValue : rowValueList) {
                        DynamicObject entityObj = (DynamicObject)entityRows.get(((Integer)rowValue.getKey()).intValue());
                        BigDecimal budgetData = entityObj.getBigDecimal("budgetdata");
                        entityObj.set("budgetbalance", (Object)budgetData.subtract((BigDecimal)rowValue.getValue()));
                        entityObj.set("limitbalanceshow", (Object)LimitBalance.getMinValue((BigDecimal)budgetData.subtract((BigDecimal)rowValue.getValue()), (BigDecimal)budgetData));
                    }
                }
            }
        }
    }

    @Override
    public void buildCustomDimInfo(int index) {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.valueOf(false), new String[]{"adjcustomdim1", "adjcustomdim2", "adjcustomdim3", "adjcustomdim4", "adjcustomdim5", "adjcustomdim6", "adjcustomdim7", "adjcustomdim8", "adjcustomdim9", "adjcustomdim10", "adjcustomdim11", "adjcustomdim12", "adjcustomdim13", "adjcustomdim14", "adjcustomdim15", "adjcustomdim16", "adjcustomdim17", "adjcustomdim18", "adjcustomdim19", "adjcustomdim20", "adjcustomdim21", "adjcustomdim22", "adjcustomdim23", "adjcustomdim24", "adjcustomdim25", "adjcustomdim26", "adjcustomdim27", "adjcustomdim28", "adjcustomdim29", "adjcustomdim30", "adjcustomdim31", "adjcustomdim32", "adjcustomdim33", "adjcustomdim34", "adjcustomdim35", "adjcustomdim36", "adjcustomdim37", "adjcustomdim38", "adjcustomdim39", "adjcustomdim40", "adjcustomdim41", "adjcustomdim42", "adjcustomdim43", "adjcustomdim44", "adjcustomdim45", "adjcustomdim46", "adjcustomdim47", "adjcustomdim48", "adjcustomdim49", "adjcustomdim50"});
        DynamicInfoCollection customDimInfo = this.getCustomDimsInfoCache();
        this.getPageCache().put("customDimsInfoCache", SerializationUtils.serializeToBase64((Object)customDimInfo));
        if (!customDimInfo.isEmpty()) {
            IDataModel dataModel = this.getModel();
            int rowCounts = this.getModel().getEntryRowCount("entryentity");
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
            for (DynamicInfoCollection.InfoObject info : customDimInfo.getValues()) {
                Member accountMember;
                String controlKey = (String)info.getValueByPropName("controlkey");
                String id = (String)info.getValueByPropName("id");
                String name = (String)info.getValueByPropName("name");
                grid.setColumnProperty(controlKey, "header", (Object)new LocaleString(name));
                formView.setVisible(Boolean.valueOf(true), new String[]{controlKey});
                if (index == -1) {
                    for (int i = 0; i < rowCounts; ++i) {
                        Member accountMember2;
                        DynamicObject rowObj = (DynamicObject)entryEntity.get(i);
                        Long adjAccountId = rowObj.getLong("adjaccount.id");
                        if (IDUtils.isNull((Long)adjAccountId) || (accountMember2 = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), adjAccountId)) == null) continue;
                        Long datasetId = accountMember2.getDatasetId();
                        List dimensions = modelCacheHelper.getDimensionList(datasetId);
                        ArrayList<String> ids = new ArrayList<String>();
                        for (Dimension dimension : dimensions) {
                            if (dimension.isPreset()) continue;
                            ids.add(String.valueOf(dimension.getId()));
                        }
                        if (!ids.contains(id)) {
                            formView.setEnable(Boolean.valueOf(false), i, new String[]{controlKey});
                            dataModel.setValue(controlKey, null, i);
                            continue;
                        }
                        formView.setEnable(Boolean.valueOf(true), i, new String[]{controlKey});
                    }
                    continue;
                }
                DynamicObject rowObj = (DynamicObject)entryEntity.get(index);
                Long adjAccountId = rowObj.getLong("adjaccount.id");
                if (IDUtils.isNull((Long)adjAccountId) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), adjAccountId)) == null) continue;
                Long datasetId = accountMember.getDatasetId();
                List dimensions = modelCacheHelper.getDimensionList(datasetId);
                ArrayList<String> ids = new ArrayList<String>();
                for (Dimension dimension : dimensions) {
                    if (dimension.isPreset()) continue;
                    ids.add(String.valueOf(dimension.getId()));
                }
                if (!ids.contains(id)) {
                    formView.setEnable(Boolean.valueOf(false), index, new String[]{controlKey});
                    dataModel.setValue(controlKey, null, index);
                    continue;
                }
                formView.setEnable(Boolean.valueOf(true), index, new String[]{controlKey});
            }
        }
    }

    @Override
    public void checkRowsCompleted(String entryEntity) {
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        boolean needReplace = StringUtils.equals((String)"adjdetailentity", (String)entryEntity);
        String accountIdKey = needReplace ? "account.id" : "adjaccount.id";
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryEntity);
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        if (!rows.isEmpty()) {
            HashMap<Integer, String> rowDimMap = new HashMap<Integer, String>(16);
            HashSet<Integer> rowNums = new HashSet<Integer>(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                Long accountId = ((DynamicObject)rows.get(i)).getLong(accountIdKey);
                if (IDUtils.isNull((Long)accountId)) {
                    this.removeCompletedRow(i);
                    continue;
                }
                Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
                if (accountMember == null) {
                    this.removeCompletedRow(i);
                    continue;
                }
                Long datasetId = accountMember.getDatasetId();
                DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)this.getModelId(), (Long)datasetId);
                List customDimKeys = rowCustomDims.getAllValOfOneProp("controlkey");
                boolean completed = true;
                for (String key : this.entryEntityKeys) {
                    key = "adj" + key;
                    if (key.contains("customdim") && !customDimKeys.contains(key)) continue;
                    if (needReplace) {
                        key = key.replace("adj", "");
                    }
                    if (((DynamicObject)rows.get(i)).get(key) != null) continue;
                    completed = false;
                    break;
                }
                if (completed) {
                    String rowDims;
                    if (!needReplace && StringUtils.isNotEmpty((String)(rowDims = this.getDimMemsForRow((DynamicObject)rows.get(i))))) {
                        rowDimMap.put(i, rowDims);
                    }
                    rowNums.add(i);
                    continue;
                }
                this.removeCompletedRow(i);
            }
            if (!rowDimMap.isEmpty()) {
                this.getPageCache().put("completedRowDimsCache", SerializationUtils.serializeToBase64(rowDimMap));
            }
            if (!rowNums.isEmpty()) {
                this.updateCompletedRowNum(false, false, rowNums.toArray(new Integer[1]));
            } else {
                this.getPageCache().put("CompletedRowNum", null);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.setEntryEntityNewAddUserDefinedDimNoneMember();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (AdjustBillStateEnum.SAVE.getShortNumber().equals(billStatus)) {
            Long adjustRuleId = this.getAdjustRuleId();
            if (adjustRuleId == 0L) {
                return;
            }
            QFBuilder qb = new QFBuilder("id", "=", (Object)adjustRuleId);
            qb.add(new QFilter("assigntype", "=", (Object)"0").or(new QFilter("userid", "like", (Object)("%" + UserUtils.getUserId() + "%"))));
            DynamicObject adjustRule = BusinessDataServiceHelper.loadSingleFromCache((String)"bgm_adjustrule", (String)"billno,rulestate", (QFilter[])qb.toArray());
            if (adjustRule != null) {
                String ruleCode = adjustRule.getString("billno");
                boolean ruleState = adjustRule.getBoolean("rulestate");
                if (!ruleState) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizmodel", "adjustrule", "budgetperiods", "version", "datatype", "changetype", "currency", "adjustinfoap"});
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8c03\u6574\u89c4\u5219%1\u5df2\u7981\u7528\uff0c\u4ec5\u53ef\u67e5\u770b\u5f53\u524d\u8868\u5355\u3002", (String)"OverallBudgetAdjustPlugin_new_03", (String)"epm-eb-formplugin", (Object[])new Object[]{ruleCode}));
                }
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bizmodel", "adjustrule", "budgetperiods", "version", "datatype", "changetype", "currency", "adjustinfoap"});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0e\u8c03\u6574\u89c4\u5219\u4e0d\u5339\u914d\uff0c\u4ec5\u53ef\u67e5\u770b\u5f53\u524d\u8868\u5355\u3002", (String)"OverallBudgetAdjustPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"projectimport"});
        }
    }

    @Override
    public DynamicObjectCollection getAdjustRuleInfo() {
        Object adjustrule = this.getModel().getValue("adjustrule");
        if (adjustrule == null) {
            return null;
        }
        DynamicObject adjustRule = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)adjustrule).getLong("id"), (String)"bgm_adjustrule");
        if (adjustRule == null) {
            return null;
        }
        return adjustRule.getDynamicObjectCollection("entryentity");
    }

    @Override
    public boolean judgeNeedPresetDefined(String propName, int row, DynamicObjectCollection ruleDetailList) {
        if (ruleDetailList == null || ruleDetailList.size() == 0) {
            return true;
        }
        Set<String> dimMemNums = this.getRuleDimMembers(ruleDetailList, propName, row);
        if (dimMemNums != null) {
            return dimMemNums.contains(this.getCurrentDimNum(propName) + "None");
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("adjustrule".equals(callBackId)) {
            if (MessageBoxResult.Yes == result) {
                QFBuilder qb = new QFBuilder("id", "=", (Object)(this.getModel().getValue("adjustrule") == null ? Long.parseLong("0") : ((DynamicObject)this.getModel().getValue("adjustrule")).getLong("id")));
                DynamicObject adjustRule = BusinessDataServiceHelper.loadSingleFromCache((String)"bgm_adjustrule", (String)"datatype,changetype,currency,budgetperiods", (QFilter[])qb.toArray());
                if (adjustRule == null) {
                    this.getModel().setValue("datatype", null);
                    this.getModel().setValue("changetype", null);
                    this.getModel().setValue("currency", null);
                    this.getModel().setValue("budgetperiods", null);
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"projectimport"});
                    this.getModel().deleteEntryData("entryentity");
                    return;
                }
                IModelCacheHelper modelCache = this.getModelCache(this.getModelId());
                DynamicObject datatype = adjustRule.getDynamicObject("datatype");
                if (datatype != null) {
                    Member member = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), Long.valueOf(0L), Long.valueOf(datatype.getLong("id")));
                    if (member != null && !member.isDisable()) {
                        this.getModel().setValue("datatype", (Object)datatype);
                    } else {
                        this.getModel().setValue("datatype", null);
                    }
                }
                this.getModel().setValue("changetype", adjustRule.get("changetype"));
                this.getModel().setValue("currency", adjustRule.get("currency"));
                this.getModel().setValue("budgetperiods", null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"projectimport"});
                this.getModel().deleteEntryData("entryentity");
                this.getModel().deleteEntryData("adjdetailentity");
            } else {
                this.getModel().beginInit();
                String oldRuleId = this.getPageCache().get("oldRuleId");
                if (StringUtils.isNotEmpty((String)oldRuleId)) {
                    this.getModel().setValue("adjustrule", (Object)IDUtils.toLong((Object)oldRuleId));
                } else {
                    this.getModel().setValue("adjustrule", null);
                }
                this.getModel().endInit();
                this.getView().updateView("adjustrule");
            }
        } else if ("bizModelChange".equals(callBackId)) {
            if (MessageBoxResult.Yes == result) {
                this.getModel().deleteEntryData("entryentity");
                this.getPageCache().remove("CompletedRowNum");
                this.getPageCache().put("rowNumChangedCache", "true");
                this.putControlDimCache();
                this.adjustPeriodGroup(false);
                this.buildCustomDimInfo(-1);
                this.setAdjustRuleMember(this.getModelId());
            } else {
                this.getModel().beginInit();
                Long oldBizModel = IDUtils.toLong((Object)this.getPageCache().get("oldBizModel"));
                this.getModel().setValue("bizmodel", (Object)oldBizModel);
                this.getModel().endInit();
                this.getView().updateView("bizmodel");
            }
        }
    }

    @Override
    public void setAdjustRuleMember(Long modelId) {
        QFBuilder qb = new QFBuilder("model", "=", (Object)modelId);
        qb.add(new QFilter("bizmodel", "=", (Object)this.getBizModelId()));
        qb.add(new QFilter("rulestate", "=", (Object)"1"));
        qb.add(new QFilter("billtype", "=", (Object)"0").or(new QFilter("billtype", "=", (Object)this.getFormType())));
        qb.add(new QFilter("assigntype", "=", (Object)"0").or(new QFilter("userid", "like", (Object)("%" + UserUtils.getUserId() + "%"))));
        DynamicObject[] adjustRuleList = BusinessDataServiceHelper.load((String)"bgm_adjustrule", (String)"id,datatype,changetype,currency,budgetperiods", (QFilter[])qb.toArray(), (String)"modifydate desc", (int)1);
        if (adjustRuleList != null && adjustRuleList.length > 0) {
            DynamicObjectCollection budgetperiods;
            DynamicObject memberObj = adjustRuleList[0];
            this.getModel().beginInit();
            this.getModel().setValue("adjustrule", memberObj.get("id"));
            this.getModel().endInit();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"projectimport"});
            if (memberObj.get("datatype") != null) {
                IModelCacheHelper modelCache = this.getModelCache(this.getModelId());
                DynamicObject datatype = memberObj.getDynamicObject("datatype");
                Member member = modelCache.getMember(SysDimensionEnum.DataType.getNumber(), Long.valueOf(0L), Long.valueOf(datatype.getLong("id")));
                if (member != null && !member.isDisable()) {
                    this.getModel().setValue("datatype", (Object)datatype);
                } else {
                    this.getModel().setValue("datatype", null);
                }
            }
            if (memberObj.get("changetype") != null) {
                this.getModel().setValue("changetype", memberObj.get("changetype"));
            }
            if (memberObj.get("currency") != null) {
                this.getModel().setValue("currency", memberObj.get("currency"));
            }
            if ((budgetperiods = memberObj.getDynamicObjectCollection("budgetperiods")) != null && budgetperiods.size() > 0) {
                LinkedHashSet<Long> selectedPeriodIds = new LinkedHashSet<Long>(16);
                DynamicObjectCollection selectedPeriods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
                for (DynamicObject period2 : selectedPeriods) {
                    Long periodId = period2.getLong("fbasedataid.id");
                    selectedPeriodIds.add(periodId);
                }
                if (!selectedPeriodIds.isEmpty()) {
                    Set rulePeriodIds = budgetperiods.stream().map(period -> period.getLong("fbasedataid.id")).collect(Collectors.toSet());
                    Iterator iterator = selectedPeriodIds.iterator();
                    while (iterator.hasNext()) {
                        Long selectedPeriodId = (Long)iterator.next();
                        if (rulePeriodIds.contains(selectedPeriodId)) continue;
                        iterator.remove();
                    }
                    this.getModel().setValue("budgetperiods", (Object)selectedPeriodIds.toArray());
                    this.budgetPeriodChange();
                }
            }
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("adjustrule", null);
            this.getModel().endInit();
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"projectimport"});
        }
        this.getView().updateView("adjustrule");
    }

    @Override
    public void setBudgetPeriodsForCopy() {
        Object adjustRuleObj = this.getModel().getValue("adjustrule");
        if (adjustRuleObj == null) {
            return;
        }
        DynamicObject adjustRule = (DynamicObject)adjustRuleObj;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)adjustRule.getLong("id"), (String)"bgm_adjustrule");
        DynamicObjectCollection budgetPeriods = dynamicObject.getDynamicObjectCollection("budgetperiods");
        if (budgetPeriods != null && budgetPeriods.size() > 0) {
            LinkedHashSet<Long> selectedPeriodIds = new LinkedHashSet<Long>(16);
            DynamicObjectCollection selectedPeriods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
            for (DynamicObject period2 : selectedPeriods) {
                Long periodId = period2.getLong("fbasedataid.id");
                selectedPeriodIds.add(periodId);
            }
            if (!selectedPeriodIds.isEmpty()) {
                Set rulePeriodIds = budgetPeriods.stream().map(period -> period.getLong("fbasedataid.id")).collect(Collectors.toSet());
                Iterator iterator = selectedPeriodIds.iterator();
                while (iterator.hasNext()) {
                    Long selectedPeriodId = (Long)iterator.next();
                    if (rulePeriodIds.contains(selectedPeriodId)) continue;
                    iterator.remove();
                }
                this.getModel().setValue("budgetperiods", (Object)selectedPeriodIds.toArray());
                this.budgetPeriodChange();
            }
        }
    }

    private void setAdjustRuleFilter(List<QFilter> qFilters, String propName, Long ruleId, int row, List<Long> datasetList) {
        DynamicObject adjustRule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bgm_adjustrule");
        if (adjustRule == null) {
            return;
        }
        if ("datatype".equals(propName) || "changetype".equals(propName) || "currency".equals(propName)) {
            String number = adjustRule.getString(propName + ".number");
            if (StringUtils.isNotEmpty((String)number)) {
                qFilters.add(new QFilter("number", "=", (Object)number));
            }
        } else if ("budgetperiods".equals(propName)) {
            DynamicObjectCollection budgetperiod = adjustRule.getDynamicObjectCollection("budgetperiods");
            if (budgetperiod != null && budgetperiod.size() > 0) {
                Set ids = budgetperiod.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toSet());
                qFilters.add(new QFilter("id", "in", ids));
            }
        } else if (propName.startsWith("adj")) {
            DynamicObjectCollection ruleDetailList = adjustRule.getDynamicObjectCollection("entryentity");
            if (ruleDetailList == null || ruleDetailList.size() == 0) {
                return;
            }
            for (DynamicObject ruleDetail : ruleDetailList) {
                Long datasetId = ruleDetail.getLong("dataset.id");
                if (IDUtils.isNull((Long)datasetId)) {
                    datasetList.clear();
                    if (SysDimensionEnum.Entity.getNumber().equals(this.getCurrentDimNumber(propName))) continue;
                    return;
                }
                if (datasetList.contains(datasetId)) continue;
                datasetList.add(datasetId);
            }
            Set<String> dimMemNums = this.getRuleDimMembers(ruleDetailList, propName, row);
            if (dimMemNums != null) {
                qFilters.add(new QFilter("number", "in", dimMemNums));
            }
        }
    }

    private Set<String> getRuleDimMembers(DynamicObjectCollection ruleDetailList, String propName, int row) {
        HashSet<String> dimMemNums;
        block19: {
            HashSet dimMemSet = new HashSet(16);
            dimMemNums = new HashSet<String>(16);
            IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
            Dimension dimension = modelCacheHelper.getDimension(this.getCurrentDimNumber(propName));
            if ("adjentity".equals(propName)) {
                int i = 0;
                HashSet<String> entityMemSet = new HashSet<String>(16);
                for (DynamicObject ruleDetail : ruleDetailList) {
                    String dimMemberStr = ruleDetail.getString(propName.substring(3));
                    if (StringUtils.isEmpty((String)dimMemberStr)) {
                        ++i;
                        continue;
                    }
                    String[] dimMemberArr = dimMemberStr.split(";");
                    entityMemSet.addAll(Arrays.asList(dimMemberArr));
                }
                if (i > 0) {
                    return null;
                }
                dimMemSet.addAll(entityMemSet);
            } else {
                if ("adjaccount".equals(propName)) {
                    DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", row);
                    String rowEntityMemNum = rowObj.getString("adjentity.number");
                    return AdjustImpExpUtil.getAllAccountNumber(rowEntityMemNum, ruleDetailList, this.getModelId(), this.getBizModelId());
                }
                DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", row);
                String rowAccountMemNum = rowObj.getString("adjaccount.number");
                for (DynamicObject ruleDetail : ruleDetailList) {
                    Long billDatasetId;
                    HashSet accountMemSet = new HashSet(16);
                    String accountMemberStr = ruleDetail.getString("account");
                    if (StringUtils.isNotEmpty((String)accountMemberStr)) {
                        String dimMemberStr;
                        String[] dimMemberArr;
                        for (String perDimMem : dimMemberArr = accountMemberStr.split(";")) {
                            String[] dimMemArr = perDimMem.split("!!");
                            String memNum = dimMemArr[0];
                            int memScope = Integer.parseInt(dimMemArr[1]);
                            List memberList = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), memNum, memScope);
                            if (memberList == null) continue;
                            List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                            accountMemSet.addAll(memberNumbers);
                        }
                        if (StringUtils.isNotEmpty((String)rowAccountMemNum)) {
                            if (!accountMemSet.contains(rowAccountMemNum)) continue;
                            dimMemberStr = ruleDetail.getString(propName.substring(3));
                            if (StringUtils.isEmpty((String)dimMemberStr)) {
                                return null;
                            }
                            String[] accMemberArr = dimMemberStr.split(";");
                            dimMemSet.addAll(Arrays.asList(accMemberArr));
                            continue;
                        }
                        dimMemberStr = ruleDetail.getString(propName.substring(3));
                        if (StringUtils.isEmpty((String)dimMemberStr)) {
                            return null;
                        }
                        String[] accMemberArr = dimMemberStr.split(";");
                        dimMemSet.addAll(Arrays.asList(accMemberArr));
                        continue;
                    }
                    if (StringUtils.isEmpty((String)rowAccountMemNum)) {
                        String dimMemberStr = ruleDetail.getString(propName.substring(3));
                        if (StringUtils.isEmpty((String)dimMemberStr)) {
                            return null;
                        }
                        String[] accMemberArr = dimMemberStr.split(";");
                        dimMemSet.addAll(Arrays.asList(accMemberArr));
                        continue;
                    }
                    long ruleDatasetId = ruleDetail.getLong("dataset.id");
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, rowAccountMemNum);
                    if (member == null || ruleDatasetId != (billDatasetId = member.getDatasetId())) continue;
                    String dimMemberStr = ruleDetail.getString(propName.substring(3));
                    if (StringUtils.isEmpty((String)dimMemberStr)) {
                        return null;
                    }
                    String[] accMemberArr = dimMemberStr.split(";");
                    dimMemSet.addAll(Arrays.asList(accMemberArr));
                }
            }
            if (dimMemSet.isEmpty()) break block19;
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(this.getBizModelId(), SysDimensionEnum.Entity.getNumber());
                MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.getModelId());
                for (String dimMem : dimMemSet) {
                    dimMemNums.addAll(AdjustImpExpUtil.getEntityMemberNumberSet(modelCacheHelper, memberPropCache, dimMem, viewId));
                }
            } else {
                for (String dimMem : dimMemSet) {
                    Long viewId;
                    String[] dimMemArr = dimMem.split("!!");
                    String memNum = dimMemArr[0];
                    int memScope = Integer.parseInt(dimMemArr[1]);
                    String dimNumber = this.getCurrentDimNumber(propName);
                    List memberList = modelCacheHelper.getMember(dimNumber, viewId = modelCacheHelper.getViewByBusModelAndDimNumber(this.getBizModelId(), dimNumber), memNum, memScope);
                    if (!CollectionUtils.isNotEmpty((Collection)memberList)) continue;
                    List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    dimMemNums.addAll(memberNumbers);
                }
            }
        }
        return dimMemNums;
    }

    @Override
    public void checkMetricAndCustomDimAfterSetAccount(PropertyChangedArgs e, int rowNum) {
        super.checkMetricAndCustomDimAfterSetAccount(e, rowNum);
        DynamicObjectCollection adjustRuleInfo = this.getAdjustRuleInfo();
        if (adjustRuleInfo == null || adjustRuleInfo.size() == 0) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        long accountId = ((DynamicObject)newValue).getLong("id");
        if (IDUtils.isNull((long)accountId)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), Long.valueOf(accountId));
        if (accountMember == null) {
            return;
        }
        Long datasetId = accountMember.getDatasetId();
        Map viewIds = modelCacheHelper.getViewsByDataSet(datasetId);
        DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)this.getModelId(), (Long)datasetId);
        List customDimKeys = rowCustomDims.getAllValOfOneProp("controlkey");
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowNum);
        customDimKeys.add(0, "adjmetric");
        HashMap dimMemMap = new HashMap(16);
        boolean needCheckPerm = false;
        for (Object e2 : customDimKeys) {
            String number;
            String propName = (String)e2;
            Set<String> dimMemNums = this.getRuleDimMembers(adjustRuleInfo, propName, rowNum);
            if (dimMemNums == null) continue;
            ArrayList<Long> dimMemIds = new ArrayList<Long>(16);
            for (String dimNum : dimMemNums) {
                String dimensionNumber = this.getCurrentDimNumber(propName);
                Member member = modelCacheHelper.getMember(dimensionNumber, (Long)viewIds.get(dimensionNumber), dimNum);
                if (!member.isLeaf() || member.isDisable()) continue;
                dimMemIds.add(member.getId());
            }
            if (dimMemIds.size() == 1) {
                dimMemMap.put(propName, dimMemIds.get(0));
                needCheckPerm = true;
                continue;
            }
            Object dynamicObject = rowObj.get(propName);
            if (dynamicObject == null || dimMemNums.contains(number = ((DynamicObject)dynamicObject).getString("number"))) continue;
            dimMemMap.put(propName, null);
        }
        if (needCheckPerm) {
            Long modelId = this.getModelId();
            List list = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
            Long userId = UserUtils.getUserId();
            ArrayList<String> permControlDim = new ArrayList<String>(10);
            List dimensionList = ModelUtil.isEbOrBgModel((Long)modelId) ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionListByBusModel(this.getBizModelId());
            for (Dimension dimension : dimensionList) {
                if (!list.contains(dimension.getNumber())) continue;
                permControlDim.add(dimension.getNumber());
            }
            DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)this.getBizModelId(), permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
            for (Map.Entry dimMem : dimMemMap.entrySet()) {
                if (dimMem.getValue() != null) {
                    HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(permControlDim.size());
                    String currentDimNumber = this.getCurrentDimNumber((String)dimMem.getKey());
                    Set refDimGroupNums = DimMembPermHelper.getRefDimGroupNums((Long)this.getModelId(), (String)currentDimNumber);
                    if (!CollectionUtils.isEmpty((Collection)refDimGroupNums)) {
                        Map<String, Set<Long>> currMembers = this.getCurrMembers(currentDimNumber);
                        Long dimViewId = AdjustHelper.getDimDefaultViewId((Long)this.getModelId(), (Long)this.getBizModelId(), (String)currentDimNumber);
                        Set permMembIdsByGroup = DimMembPermHelper.getPermMembIdsByGroup((String)currentDimNumber, (Long)modelId, (Long)this.getBizModelId(), (Long)dimViewId, currMembers, (DimMembPermType)DimMembPermType.WRITE);
                        if (permMembIdsByGroup != null && !permMembIdsByGroup.contains(dimMem.getValue())) continue;
                        this.getModel().setValue((String)dimMem.getKey(), dimMem.getValue(), rowNum);
                        continue;
                    }
                    MemberItem memberItem = new MemberItem(true, (Long)dimMem.getValue());
                    memberGroup.put(currentDimNumber, memberItem);
                    if (!permChecker.check(memberGroup)) continue;
                    this.getModel().setValue((String)dimMem.getKey(), dimMem.getValue(), rowNum);
                    continue;
                }
                this.getModel().setValue((String)dimMem.getKey(), dimMem.getValue(), rowNum);
            }
        } else {
            for (Map.Entry entry : dimMemMap.entrySet()) {
                this.getModel().setValue((String)entry.getKey(), entry.getValue(), rowNum);
            }
        }
    }

    @Override
    public void checkAccountAfterSetEntity(PropertyChangedArgs e, String propKey, int rowNum) {
        super.checkAccountAfterSetEntity(e, propKey, rowNum);
        DynamicObjectCollection adjustRuleInfo = this.getAdjustRuleInfo();
        if (adjustRuleInfo == null || adjustRuleInfo.size() == 0) {
            return;
        }
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowNum);
        String rowAccountMemNum = rowObj.getString("adjaccount.number");
        if (StringUtils.isEmpty((String)rowAccountMemNum)) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        String entityNumber = ((DynamicObject)newValue).getString("number");
        Set<String> accountNumberSet = AdjustImpExpUtil.getAllAccountNumber(entityNumber, adjustRuleInfo, this.getModelId(), this.getBizModelId());
        if (accountNumberSet != null && !accountNumberSet.contains(rowAccountMemNum)) {
            this.getModel().setValue("adjaccount", null, rowNum);
        }
    }

    @Override
    public void cacheCustomDimJson() {
        String customdimjson = this.getPageCache().get("customdimjson");
        if (StringUtils.isNotEmpty((String)customdimjson)) {
            return;
        }
        LinkedHashMap<String, String> customDimJsonMap = new LinkedHashMap<String, String>(16);
        for (String key : this.entryEntityKeys) {
            if ("Entity".equals(key) || "Account".equals(key) || "Metric".equals(key)) continue;
            customDimJsonMap.put("adj" + key, this.getCurrentDimNum("adj" + key));
        }
        if (customDimJsonMap.size() > 0) {
            String string = SerializationUtils.toJsonString(customDimJsonMap);
            this.getPageCache().put("customdimjson", string);
        }
    }

    @Override
    public Map<String, String> getCustomDimMap() {
        this.cacheCustomDimJson();
        String customdimjson = this.getPageCache().get("customdimjson");
        if (StringUtils.isNotEmpty((String)customdimjson)) {
            Map customDimMap = (Map)SerializationUtils.fromJsonString((String)customdimjson, LinkedHashMap.class);
            return customDimMap;
        }
        return null;
    }

    @Override
    public List<Map<String, String>> getDimList(Set<Integer> completedRowNums, boolean isNew) {
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)this.getModelId(), (String)this.getFormType(), (boolean)ModelUtil.isBGModel((Long)this.getModelId()));
        Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        DynamicObject dataTypeObj = (DynamicObject)this.getModel().getValue("datatype");
        DynamicObject changeTypeObj = (DynamicObject)this.getModel().getValue("changetype");
        DynamicObject versionObj = (DynamicObject)this.getModel().getValue("version");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
        String dataTypeNumber = dataTypeObj.getString("number");
        String changeTypeNumber = changeTypeObj.getString("number");
        String versionNumber = versionObj.getString("number");
        String currencyNumber = currencyObj.getString("number");
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        for (Integer i : completedRowNums) {
            DynamicInfoCollection rowCustomDims;
            Long datasetId;
            Member accountMember;
            Long accountId;
            DynamicObject rowObj;
            if (isNew) {
                rowObj = this.getModel().getEntryRowEntity("entryentity", i.intValue());
                accountId = rowObj.getLong("adjaccount.id");
                if (IDUtils.isNull((Long)accountId) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId)) == null) continue;
                datasetId = accountMember.getDatasetId();
                rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)modelId, (Long)datasetId);
                String entryNumber = rowObj.getString("adjentity.number");
                String accountNumber = rowObj.getString("adjaccount.number");
                String metricNumber = rowObj.getString("adjmetric.number");
                for (int j = 0; j < periods.size(); ++j) {
                    String periodNumber = ((DynamicObject)periods.get(j)).getString("fbasedataid.number");
                    HashMap<Object, String> dimMap = new HashMap<Object, String>(16);
                    dimMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
                    dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
                    dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
                    dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                    dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
                    dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
                    dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
                    dimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
                    dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
                    for (DynamicInfoCollection.InfoObject customDim : rowCustomDims.getValues()) {
                        String controlKey = (String)customDim.getValueByPropName("controlkey");
                        DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey);
                        if (customDimObj == null) continue;
                        dimMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
                    }
                    dimList.add(dimMap);
                }
                continue;
            }
            rowObj = this.getModel().getEntryRowEntity("adjdetailentity", i.intValue());
            accountId = rowObj.getLong("account.id");
            if (IDUtils.isNull((Long)accountId) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId)) == null) continue;
            datasetId = accountMember.getDatasetId();
            rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)modelId, (Long)datasetId);
            String periodNumber = rowObj.getString("budgetperiod.number");
            String entryNumber = rowObj.getString("entity.number");
            String accountNumber = rowObj.getString("account.number");
            String metricNumber = rowObj.getString("metric.number");
            HashMap<Object, String> dimMap = new HashMap<Object, String>(16);
            dimMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
            dimMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
            dimMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
            dimMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
            dimMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
            dimMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
            dimMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
            dimMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
            dimMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
            for (DynamicInfoCollection.InfoObject customDim : rowCustomDims.getValues()) {
                String controlKey = (String)customDim.getValueByPropName("controlkey");
                DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey = controlKey.substring(3));
                if (customDimObj == null) continue;
                dimMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
            }
            dimList.add(dimMap);
        }
        return dimList;
    }

    private List<CompareDataPojo> getCompareDataList(Set<Integer> completedRowNums, boolean isNew) {
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        Long modelId = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        DynamicObject dataTypeObj = (DynamicObject)this.getModel().getValue("datatype");
        DynamicObject changeTypeObj = (DynamicObject)this.getModel().getValue("changetype");
        DynamicObject versionObj = (DynamicObject)this.getModel().getValue("version");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
        long model = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
        long bizmodel = ((DynamicObject)this.getModel().getValue("bizmodel")).getLong("id");
        String dataTypeNumber = dataTypeObj.getString("number");
        String changeTypeNumber = changeTypeObj.getString("number");
        String versionNumber = versionObj.getString("number");
        String currencyNumber = currencyObj.getString("number");
        ArrayList<CompareDataPojo> compareDataPojoList = new ArrayList<CompareDataPojo>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        StringBuilder rowDimMembers = new StringBuilder();
        HashMap<String, CompareDataPojo> rowDataMap = new HashMap<String, CompareDataPojo>(16);
        HashMap<String, List> rowListMap = new HashMap<String, List>(16);
        for (Integer n : completedRowNums) {
            DynamicInfoCollection rowCustomDims;
            Long datasetId;
            Member accountMember;
            Long accountId;
            DynamicObject rowObj;
            if (isNew) {
                rowObj = this.getModel().getEntryRowEntity("entryentity", n.intValue());
                if (rowObj == null || IDUtils.isNull((Long)(accountId = Long.valueOf(rowObj.getLong("adjaccount.id")))) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId)) == null) continue;
                datasetId = accountMember.getDatasetId();
                rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)modelId, (Long)datasetId);
                String entryNumber = rowObj.getString("adjentity.number");
                String accountNumber = rowObj.getString("adjaccount.number");
                String metricNumber = rowObj.getString("adjmetric.number");
                for (int j = 1; j < periods.size() + 1; ++j) {
                    DynamicObject periodObj = (DynamicObject)rowObj.get("adjbudgetperiod" + j);
                    if (periodObj == null) continue;
                    String periodNumber = periodObj.getString("number");
                    CompareDataPojo compareDataPojo = new CompareDataPojo();
                    compareDataPojo.setRow(n.intValue());
                    compareDataPojo.setPreiod(periodNumber);
                    compareDataPojo.setDatatypeNumber(dataTypeNumber);
                    compareDataPojo.setChangetypeNumber(changeTypeNumber);
                    compareDataPojo.setVersionNumber(versionNumber);
                    compareDataPojo.setCurrencyNumber(currencyNumber);
                    compareDataPojo.setOrgnumber(entryNumber);
                    compareDataPojo.setAccountNumber(accountNumber);
                    compareDataPojo.setMetricNumber(metricNumber);
                    compareDataPojo.setSubmitValue(BigDecimal.ZERO);
                    compareDataPojo.setModel(Long.valueOf(model));
                    compareDataPojo.setBizmodel(Long.valueOf(bizmodel));
                    HashMap<String, String> customDimMap = new HashMap<String, String>(16);
                    HashMap customDimMemberMap = new HashMap(16);
                    for (DynamicInfoCollection.InfoObject customDim : rowCustomDims.getValues()) {
                        String controlKey = (String)customDim.getValueByPropName("controlkey");
                        DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey);
                        if (customDimObj == null) continue;
                        customDimMap.put(controlKey, customDimObj.getString("number"));
                        customDimMemberMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
                    }
                    compareDataPojo.setCustomdimMap(customDimMap);
                    compareDataPojo.setCustomdimMemberMap(customDimMemberMap);
                    compareDataPojoList.add(compareDataPojo);
                }
                continue;
            }
            rowObj = this.getModel().getEntryRowEntity("adjdetailentity", n.intValue());
            if (rowObj == null || IDUtils.isNull((Long)(accountId = Long.valueOf(rowObj.getLong("account.id")))) || (accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId)) == null) continue;
            datasetId = accountMember.getDatasetId();
            rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)modelId, (Long)datasetId);
            String periodNumber = rowObj.getString("budgetperiod.number");
            String entryNumber = rowObj.getString("entity.number");
            String accountNumber = rowObj.getString("account.number");
            String metricNumber = rowObj.getString("metric.number");
            BigDecimal submitValue = rowObj.getBigDecimal("submitvalue");
            rowDimMembers.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("@").append(periodNumber).append("!!");
            rowDimMembers.append(SysDimensionEnum.Entity.getNumber()).append("@").append(entryNumber).append("!!");
            rowDimMembers.append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!");
            rowDimMembers.append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            CompareDataPojo compareDataPojo = new CompareDataPojo();
            compareDataPojo.setRow(n.intValue());
            compareDataPojo.setPreiod(periodNumber);
            compareDataPojo.setDatatypeNumber(dataTypeNumber);
            compareDataPojo.setChangetypeNumber(changeTypeNumber);
            compareDataPojo.setVersionNumber(versionNumber);
            compareDataPojo.setCurrencyNumber(currencyNumber);
            compareDataPojo.setOrgnumber(entryNumber);
            compareDataPojo.setAccountNumber(accountNumber);
            compareDataPojo.setMetricNumber(metricNumber);
            compareDataPojo.setSubmitValue(submitValue);
            compareDataPojo.setModel(Long.valueOf(model));
            compareDataPojo.setBizmodel(Long.valueOf(bizmodel));
            HashMap<String, String> customDimMap = new HashMap<String, String>(16);
            HashMap<Object, String> customDimMemberMap = new HashMap<Object, String>(16);
            for (DynamicInfoCollection.InfoObject customDim : rowCustomDims.getValues()) {
                String controlKey = (String)customDim.getValueByPropName("controlkey");
                DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey = controlKey.substring(3));
                if (customDimObj == null) continue;
                customDimMap.put(controlKey, customDimObj.getString("number"));
                customDimMemberMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
                rowDimMembers.append("!!").append((String)customDim.getValueByPropName("number")).append("@").append(customDimObj.getString("number")).append("!!");
            }
            compareDataPojo.setCustomdimMap(customDimMap);
            compareDataPojo.setCustomdimMemberMap(customDimMemberMap);
            if (rowDataMap.containsKey(rowDimMembers.toString())) {
                CompareDataPojo dataPojo = (CompareDataPojo)rowDataMap.get(rowDimMembers.toString());
                BigDecimal newSubmitValue = dataPojo.getSubmitValue().add(submitValue);
                dataPojo.setSubmitValue(newSubmitValue);
            } else {
                rowDataMap.put(rowDimMembers.toString(), compareDataPojo);
            }
            List dataList = rowListMap.computeIfAbsent(rowDimMembers.toString(), v -> new ArrayList(16));
            dataList.add(compareDataPojo);
            rowDimMembers.setLength(0);
        }
        for (Map.Entry entry : rowListMap.entrySet()) {
            CompareDataPojo dataPojo = (CompareDataPojo)rowDataMap.get(entry.getKey());
            List dataList = (List)entry.getValue();
            for (CompareDataPojo data : dataList) {
                BigDecimal submitValue = dataPojo.getSubmitValue();
                if (submitValue.compareTo(BigDecimal.ZERO) > 0) {
                    dataPojo.setSubmitValue(BigDecimal.ZERO);
                } else {
                    data.setSubmitValue(submitValue);
                }
                compareDataPojoList.add(data);
            }
        }
        return compareDataPojoList;
    }

    private Collection<IBudgetBalance> queryBudgetBalance(Set<Integer> completedRowNums, boolean isNew, List<CompareDataPojo> compareDataPojoList, String formType) {
        ArrayList types;
        List<Map<String, String>> dimList = this.getDimList(completedRowNums, isNew);
        if (!AdjustHelper.isExitMixturePeriod(dimList, types = new ArrayList(16))) {
            return AdjustHelper.getBgmAllIbCollection((Long)this.getModelId(), (Long)this.getBizModelId(), dimList, types, compareDataPojoList, (String)formType);
        }
        return AdjustHelper.queryBgmBalance((Long)this.getModelId(), (Long)this.getBizModelId(), dimList, types, compareDataPojoList, (String)formType);
    }

    public String getModelFieldKey() {
        return "model";
    }

    public String getBizCtrlRangeKey() {
        return "bizmodel";
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getPageCache().put("isCopyNew", "1");
    }

    @Override
    protected void openBudgetForm() {
        Long bizModelId = this.getBizModelId();
        if (IDUtils.isNull((Long)bizModelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"RpaSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection periods = (DynamicObjectCollection)this.getModel().getValue("budgetperiods");
        if (CollectionUtils.isEmpty((Collection)periods)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u672c\u4fe1\u606f\u7684\u9884\u7b97\u671f\u95f4\u540e\u6309\u8868\u589e\u884c\u3002", (String)"AdjustBudgetForm_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long selectOrgId = this.getSelectOrgId();
        Set<Long> periodIds = this.getAllPeriodIds(periods);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("modelId", this.getModelId());
        paramMap.put("bizModelId", bizModelId);
        paramMap.put("periodIds", SerializationUtils.toJsonString(periodIds));
        paramMap.put("selectOrgId", selectOrgId);
        paramMap.put("isBudgetForm", "true");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParams(paramMap);
        showParameter.setFormId("bgm_adjust_addrow");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_add_row"));
        this.getView().showForm(showParameter);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_budget_form"});
    }

    @Override
    protected Set<Integer> getSameDimRowNums(int rowNum) {
        String completedDimRowCache = this.getPageCache().get("completedRowDimsCache");
        if (StringUtils.isEmpty((String)completedDimRowCache)) {
            return null;
        }
        Map completedRowDimMap = (Map)SerializationUtils.deSerializeFromBase64((String)completedDimRowCache);
        if (!completedRowDimMap.containsKey(rowNum)) {
            return null;
        }
        HashMap<String, Set> sameDimRowMap = new HashMap<String, Set>(16);
        for (Map.Entry entry : completedRowDimMap.entrySet()) {
            int row = (Integer)entry.getKey();
            String rowDimMembers = (String)entry.getValue();
            Set rows = sameDimRowMap.computeIfAbsent(rowDimMembers, v -> new HashSet(16));
            rows.add(row);
        }
        StringBuilder rowDimMembers = new StringBuilder();
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowNum);
        DynamicObject entityObj = rowObj.getDynamicObject("adjentity");
        DynamicObject accountObj = rowObj.getDynamicObject("adjaccount");
        DynamicObject metricObj = rowObj.getDynamicObject("adjmetric");
        if (entityObj == null || accountObj == null || metricObj == null) {
            return null;
        }
        String entityNumber = entityObj.getString("number");
        String accountNumber = accountObj.getString("number");
        String metricNumber = metricObj.getString("number");
        rowDimMembers.append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
        Long accountId = rowObj.getLong("adjaccount.id");
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
        Long datasetId = accountMember.getDatasetId();
        Map customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)this.getModelId(), (Long)this.getBizModelId());
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)this.getModelId(), (Long)datasetId, (Map)customDimMap);
        for (Map.Entry entry : rowCustomDimMap.entrySet()) {
            String dimKey = (String)entry.getKey();
            Dimension dimension = (Dimension)entry.getValue();
            DynamicObject customDimObj = rowObj.getDynamicObject("adj" + dimKey);
            String customDimMem = customDimObj != null ? customDimObj.getString("number") : dimension.getNoneNumber();
            rowDimMembers.append("!!").append(dimension.getNumber()).append("@").append(customDimMem);
        }
        return (Set)sameDimRowMap.get(rowDimMembers.toString());
    }

    private Set<Long> getAllPeriodIds(DynamicObjectCollection periods) {
        HashSet<String> periodNumbers = new HashSet<String>(16);
        for (DynamicObject period : periods) {
            String periodNumber = period.getString("fbasedataid.number");
            String rootNumber = periodNumber.substring(0, 6);
            periodNumbers.add(rootNumber);
        }
        HashSet<Long> allPeriodIds = new HashSet<Long>(16);
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        for (String periodNumber : periodNumbers) {
            List memberList = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), periodNumber, RangeEnum.ALL.getIndex());
            Set memberIds = memberList.stream().map(BaseCache::getId).collect(Collectors.toSet());
            allPeriodIds.addAll(memberIds);
        }
        return allPeriodIds;
    }

    private Long getSelectOrgId() {
        Long selectOrgId = 0L;
        EntryGrid control = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = control.getSelectRows();
        if (selectRows.length > 0) {
            int selectRow = selectRows[0];
            DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", selectRow);
            DynamicObject entityObj = rowObj.getDynamicObject("adjentity");
            if (entityObj != null) {
                selectOrgId = entityObj.getLong("id");
            }
        }
        return selectOrgId;
    }

    private void removeCompletedRow(int row) {
        String sameDimRowCache = this.getPageCache().get("completedRowDimsCache");
        if (StringUtils.isNotEmpty((String)sameDimRowCache)) {
            Map rowDimMap = (Map)SerializationUtils.deSerializeFromBase64((String)sameDimRowCache);
            if (rowDimMap.containsKey(row)) {
                rowDimMap.remove(row);
            }
            this.getPageCache().put("completedRowDimsCache", SerializationUtils.serializeToBase64((Object)rowDimMap));
        }
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    protected void updateEntryShowAfterImport(Object returnDataObj) {
        if (returnDataObj == null) {
            return;
        }
        Map returnData = (Map)returnDataObj;
        Object hasErrorStr = returnData.get("hasError");
        boolean hasError = Boolean.parseBoolean(hasErrorStr.toString());
        Object data = returnData.get("data");
        if (data == null) {
            return;
        }
        Map customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)this.getModelId(), (Long)this.getBizModelId());
        Map billDetailMap = (Map)data;
        int count = billDetailMap.size();
        Map<String, List<Integer>> sameDimMemberMap = AdjustImpExpUtil.getRowCustomDimMap(billDetailMap, this.getModelId(), customDimMap);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection periods = dataEntity.getDynamicObjectCollection("budgetperiods");
        ArrayList<String> periodNumbers = new ArrayList<String>(periods.size());
        for (DynamicObject period : periods) {
            periodNumbers.add(period.getString("fbasedataid.number"));
        }
        boolean isAllowSameDim = AdjustHelper.isAllowSameDim((Long)this.getModelId(), (String)this.getFormType());
        HashMap<Integer, Set<String>> errorRowMap = new HashMap<Integer, Set<String>>(billDetailMap.size());
        StringBuilder rowDimMemberStr = new StringBuilder();
        LinkedHashMap<String, List> sameDimRowMap = new LinkedHashMap<String, List>(billDetailMap.size());
        Iterator iterator = billDetailMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DynamicObject row = (DynamicObject)entry.getValue();
            String periodNumber = row.getString("budgetperiod.number");
            if (!periodNumbers.contains(periodNumber)) {
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u5185\u6240\u9009\u671f\u95f4\u3002", (String)"BaseEbAdjustBillEditPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                HashSet<String> errorMsgSet = new HashSet<String>(1);
                errorMsgSet.add(errorMsg);
                errorRowMap.put((Integer)entry.getKey() + 3, errorMsgSet);
                iterator.remove();
                continue;
            }
            String rowCustomDim = AdjustImpExpUtil.getRowCustomDim(row, this.getModelId(), customDimMap);
            List<Integer> rows = sameDimMemberMap.get(rowCustomDim);
            if (!isAllowSameDim && CollectionUtils.isNotEmpty(rows) && rows.size() > 1) {
                String errorMsg = ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7ec4\u5408\u6570\u636e\u3002", (String)"BaseEbAdjustBillEditPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                HashSet<String> errorMsgSet = new HashSet<String>(1);
                errorMsgSet.add(errorMsg);
                errorRowMap.put((Integer)entry.getKey() + 3, errorMsgSet);
                iterator.remove();
                continue;
            }
            boolean permCheckPass = this.checkImportMemberPerm(dataEntity, row, errorRowMap, Sets.newHashSet(), (Integer)entry.getKey());
            if (!permCheckPass) {
                iterator.remove();
                continue;
            }
            Long entityId = row.getLong("entity.id");
            Long accountId = row.getLong("account.id");
            Long metricId = row.getLong("metric.id");
            rowDimMemberStr.append(entityId).append("!!").append(accountId).append("!!").append(metricId);
            for (Map.Entry customDimEntry : customDimMap.entrySet()) {
                String key = (String)customDimEntry.getKey();
                DynamicObject customDimObj = row.getDynamicObject(key);
                if (customDimObj == null) continue;
                Long customDimId = customDimObj.getLong("id");
                rowDimMemberStr.append("!!").append(customDimId);
            }
            List rowList = sameDimRowMap.computeIfAbsent(rowDimMemberStr.toString(), v -> new ArrayList(16));
            rowList.add(row);
            rowDimMemberStr.setLength(0);
        }
        int i = 0;
        for (Map.Entry entry : sameDimRowMap.entrySet()) {
            List rowList = (List)entry.getValue();
            for (int j = 0; j < rowList.size(); ++j) {
                if (j != 0 && j % periodNumbers.size() == 0) {
                    ++i;
                }
                DynamicObject billDetail = (DynamicObject)rowList.get(j);
                String periodNumber = billDetail.getString("budgetperiod.number");
                int index = periodNumbers.indexOf(periodNumber);
                billDetail.set("ordersign", (Object)(i + ":" + (index + 1)));
            }
            ++i;
        }
        HashSet<String> rowDimMembers = new HashSet<String>(16);
        for (Map.Entry entry : billDetailMap.entrySet()) {
            DynamicObject row = (DynamicObject)entry.getValue();
            Long entityId = row.getLong("entity.id");
            Long accountId = row.getLong("account.id");
            Long metricId = row.getLong("metric.id");
            String rowSign = row.getString("ordersign").split(":")[0];
            StringBuilder rowSignDimMemberStr = new StringBuilder();
            StringBuilder dimKeys = new StringBuilder();
            rowSignDimMemberStr.append(rowSign).append("!!").append(entityId).append("!!").append(accountId).append("!!").append(metricId);
            dimKeys.append(entityId).append("!!").append(accountId).append("!!").append(metricId);
            for (Map.Entry customDimEntry : customDimMap.entrySet()) {
                String key = (String)customDimEntry.getKey();
                DynamicObject customDimObj = row.getDynamicObject(key);
                if (customDimObj == null) continue;
                Long customDimId = customDimObj.getLong("id");
                rowSignDimMemberStr.append("!!").append(customDimId);
                dimKeys.append("!!").append(customDimId);
            }
            if (!rowDimMembers.add(rowSignDimMemberStr.toString())) continue;
            this.getModel().beginInit();
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            int newEntryRow = this.getModel().insertEntryRow("entryentity", rowCount + 1);
            this.getModel().updateCache();
            this.getModel().setValue("adjentity", (Object)entityId, newEntryRow);
            this.getModel().setValue("adjaccount", (Object)accountId, newEntryRow);
            this.getModel().setValue("adjmetric", (Object)metricId, newEntryRow);
            String groupNum = row.getString("groupnum");
            if (StringUtils.isNotEmpty((String)groupNum)) {
                this.getModel().setValue("adjgroupnum", (Object)groupNum, newEntryRow);
            }
            for (Map.Entry customDimEntry : customDimMap.entrySet()) {
                String key = (String)customDimEntry.getKey();
                DynamicObject customDimObj = row.getDynamicObject(key);
                if (customDimObj == null) continue;
                Long customDimId = customDimObj.getLong("id");
                this.getModel().setValue("adj" + key, (Object)customDimId, newEntryRow);
            }
            List rowList = (List)sameDimRowMap.get(dimKeys.toString());
            if (CollectionUtils.isNotEmpty((Collection)rowList)) {
                for (int j = 1; j <= rowList.size(); ++j) {
                    DynamicObject rowObj = (DynamicObject)rowList.get(j - 1);
                    String rowIndex = rowObj.getString("ordersign").split(":")[0];
                    String periodIndex = rowObj.getString("ordersign").split(":")[1];
                    if (!rowIndex.equals(rowSign)) continue;
                    this.getModel().setValue("adjadjustdata" + periodIndex, (Object)rowObj.getBigDecimal("adjustdata"), newEntryRow);
                }
            }
            this.getModel().endInit();
        }
        if (errorRowMap.size() > 0) {
            if (errorRowMap.size() == count) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.adjustPeriodGroup(true);
                this.changeBudgetData(-1);
                this.buildCustomDimInfo(-1);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            AdjustImpExpUtil.downErrorFile(this.getView(), returnData, errorRowMap, hasError);
        } else if (hasError) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u3002", (String)"BaseEbAdjustBillEditPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            AdjustImpExpUtil.downErrorFile(this.getView(), returnData, errorRowMap, true);
            if (errorRowMap.size() != count) {
                this.adjustPeriodGroup(true);
                this.changeBudgetData(-1);
                this.buildCustomDimInfo(-1);
            }
        } else {
            this.adjustPeriodGroup(true);
            this.changeBudgetData(-1);
            this.buildCustomDimInfo(-1);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"BaseEbAdjustBillEditPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionKey = closedCallBackEvent.getActionId();
        if ("callback_add_row".equals(actionKey)) {
            String needUpdateBudgetData = this.getPageCache().get("needFreshBudgetDataCache");
            if (StringUtils.isEmpty((String)needUpdateBudgetData)) {
                return;
            }
            Set periodIds = (Set)SerializationUtils.deSerializeFromBase64((String)needUpdateBudgetData);
            this.getModel().setValue("budgetperiods", (Object)periodIds.toArray());
            this.getView().getPageCache().put("needFreshBudgetDataCache", "");
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.isEmpty((String)fieldName) || !fieldName.startsWith("adjbudgetbalance")) {
            return;
        }
        DynamicObject dataTypeObj = (DynamicObject)this.getModel().getValue("datatype");
        DynamicObject changeTypeObj = (DynamicObject)this.getModel().getValue("changetype");
        DynamicObject versionObj = (DynamicObject)this.getModel().getValue("version");
        DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
        if (dataTypeObj == null || changeTypeObj == null || versionObj == null || currencyObj == null) {
            return;
        }
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (rowObj == null) {
            return;
        }
        String periodIndex = fieldName.substring(16);
        DynamicObject periodObj = (DynamicObject)rowObj.get("adjbudgetperiod" + periodIndex);
        if (periodObj == null) {
            return;
        }
        String periodNumber = periodObj.getString("number");
        Long accountId = rowObj.getLong("adjaccount.id");
        if (IDUtils.isNull((Long)accountId)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = this.getModelCache(this.getModelId());
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
        if (accountMember == null) {
            return;
        }
        Set<Integer> completedRowNums = this.getBgmCompletedRowNum();
        if (!completedRowNums.contains(rowIndex)) {
            return;
        }
        String auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)this.getModelId(), (String)this.getFormType(), (boolean)ModelUtil.isBGModel((Long)this.getModelId()));
        String dataTypeNumber = dataTypeObj.getString("number");
        String changeTypeNumber = changeTypeObj.getString("number");
        String versionNumber = versionObj.getString("number");
        String currencyNumber = currencyObj.getString("number");
        String entryNumber = rowObj.getString("adjentity.number");
        String accountNumber = rowObj.getString("adjaccount.number");
        String metricNumber = rowObj.getString("adjmetric.number");
        HashMap<Object, String> dimMemberMap = new HashMap<Object, String>(16);
        dimMemberMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeNumber);
        dimMemberMap.put(SysDimensionEnum.ChangeType.getNumber(), changeTypeNumber);
        dimMemberMap.put(SysDimensionEnum.Version.getNumber(), versionNumber);
        dimMemberMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
        dimMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), periodNumber);
        dimMemberMap.put(SysDimensionEnum.Entity.getNumber(), entryNumber);
        dimMemberMap.put(SysDimensionEnum.Account.getNumber(), accountNumber);
        dimMemberMap.put(SysDimensionEnum.Metric.getNumber(), metricNumber);
        dimMemberMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrail);
        DynamicInfoCollection customDims = this.getCustomDimsInfoCache();
        DynamicInfoCollection rowCustomDims = AdjustHelper.getRowCustomDimInfo((DynamicInfoCollection)customDims, (Long)this.getModelId(), (Long)accountMember.getDatasetId());
        for (DynamicInfoCollection.InfoObject customDim : rowCustomDims.getValues()) {
            String controlKey = (String)customDim.getValueByPropName("controlkey");
            DynamicObject customDimObj = (DynamicObject)rowObj.get(controlKey);
            if (customDimObj == null) continue;
            dimMemberMap.put(customDim.getValueByPropName("number"), customDimObj.getString("number"));
        }
        log.info("[OverallBudgetAdjust] showBudgetBalance dimMemberMap={}", (Object)((Object)dimMemberMap).toString());
        Collection balances = new BgControlCallerImpl().queryBalance(this.getModelId(), (List)Lists.newArrayList((Object[])new Map[]{dimMemberMap}), (Collection)Lists.newArrayList((Object[])new String[]{BgControlSettingTypeEnum.MONTH.getNumber()}), true, true, this.getBizModelId());
        if (balances == null || balances.size() == 0) {
            return;
        }
        IBudgetBalance balance = (IBudgetBalance)balances.iterator().next();
        Collection userDefineDims = balance.getBizModel().getUserDefinedDimensions();
        String memberString = BgControlUtils.getMemberString((IBudgetBalance)balance, (boolean)true, (Collection)userDefineDims);
        HashMap<String, String> params = new HashMap<String, String>(16);
        Map toMaps = balance.toMap();
        toMaps.put("definedDimMem", memberString);
        params.put("budgetBalance", SerializationUtils.serializeToBase64((Object)toMaps));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("eb_balancecaldetail");
        parameter.setCustomParams(params);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public boolean isEbForm() {
        return false;
    }

    @Override
    public String getDimMemsForRow(DynamicObject rowObj) {
        StringBuilder rowDimMembers = new StringBuilder();
        DynamicObject entityObj = rowObj.getDynamicObject("adjentity");
        DynamicObject accountObj = rowObj.getDynamicObject("adjaccount");
        DynamicObject metricObj = rowObj.getDynamicObject("adjmetric");
        if (entityObj == null || accountObj == null || metricObj == null) {
            return "";
        }
        String entityNumber = entityObj.getString("number");
        String accountNumber = accountObj.getString("number");
        String metricNumber = metricObj.getString("number");
        rowDimMembers.append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
        Long accountId = rowObj.getLong("adjaccount.id");
        Member accountMember = this.getModelCache(this.getModelId()).getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
        Long datasetId = accountMember.getDatasetId();
        Map customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)this.getModelId(), (Long)this.getBizModelId());
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)this.getModelId(), (Long)datasetId, (Map)customDimMap);
        for (Map.Entry entry : rowCustomDimMap.entrySet()) {
            String dimKey = (String)entry.getKey();
            Dimension dimension = (Dimension)entry.getValue();
            DynamicObject customDimObj = rowObj.getDynamicObject("adj" + dimKey);
            String customDimMem = customDimObj != null ? customDimObj.getString("number") : dimension.getNoneNumber();
            rowDimMembers.append("!!").append(dimension.getNumber()).append("@").append(customDimMem);
        }
        return rowDimMembers.toString();
    }
}

