/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class UserDeptListPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    int selectedRow = -1;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String userid = (String)this.getView().getFormShowParameter().getCustomParams().get("user.id");
        if (userid == null) {
            userid = UserUtils.getUserId().toString();
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,enable,entryentity.dpt,entryentity.orgstructure,entryentity.position,entryentity.isincharge,entryentity.ispartjob", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(userid)), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        this.loadEntryEntity(user);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.selectedRow != -1) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            entryGrid.selectRows(this.selectedRow);
        }
    }

    private void loadEntryEntity(DynamicObject dynamicObject) {
        DynamicObjectCollection depts;
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (dynamicObject != null && (depts = dynamicObject.getDynamicObjectCollection(ENTRYENTITY)) != null && depts.size() > 0) {
            String deptid = (String)this.getView().getFormShowParameter().getCustomParams().get("dept.id");
            String position = (String)this.getView().getFormShowParameter().getCustomParams().get("position");
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, depts.size());
            int i = 0;
            this.getModel().beginInit();
            for (DynamicObject dept : depts) {
                this.getModel().setValue("deptid", (Object)dept.getString("dpt.id"), i);
                this.getModel().setValue("deptname", (Object)dept.getString("dpt.name"), i);
                this.getModel().setValue("deptfullname", (Object)dept.getString("orgstructure.fullname"), i);
                this.getModel().setValue("position", (Object)dept.getString("position"), i);
                this.getModel().setValue("isincharge", (Object)dept.getBoolean("isincharge"), i);
                this.getModel().setValue("ispartjob", (Object)dept.getBoolean("ispartjob"), i);
                if (deptid != null && deptid.equals(dept.getString("dpt.id")) && position != null && position.equals(dept.getString("position"))) {
                    this.selectedRow = i;
                }
                ++i;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnAndClose();
            }
        }
    }

    private void returnAndClose() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BizModelSelectPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowKey = selectRows[0];
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("dept.id", String.valueOf(this.getModel().getValue("deptid", rowKey)));
        data.put("position", String.valueOf(this.getModel().getValue("position", rowKey)));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
        this.getView().close();
    }
}

