/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.budgetform;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormService;
import kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskEnum;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskReq;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.templateperm.vo.SearchResult;

public class AdjustBudgetFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"assignschema", "pre_temp", "next_temp", "schema_switch", "btn_continue", "btnok", "vectorap_close"});
        TreeView templateTreeView = (TreeView)this.getControl("templatetree");
        templateTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search searchTemp = (Search)this.getControl("searchap_temp");
        searchTemp.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultValue();
        this.initLeftTree();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportlist"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String focusNodeId = (String)evt.getNodeId();
        TreeNode templateTreeNode = this.getTemplateTreeNode();
        TreeNode checkedNode = templateTreeNode.getTreeNode(focusNodeId, 10);
        Map data = (Map)checkedNode.getData();
        if (data == null) {
            return;
        }
        String hasTemplate = (String)data.get("hasTemplate");
        if ("0".equals(hasTemplate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f", (String)"AdjustBudgetFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long templateId = Long.valueOf(focusNodeId);
        Long orgId = this.getAssignOrgId(templateId);
        if (IDUtils.isNull((Long)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u62a5\u8868\u7f16\u5236\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdjustBudgetFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openReportList(orgId, templateId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("schema_switch".equals(key)) {
            String schemaTaskCache = this.getView().getPageCache().get("schemaTaskCache");
            if (StringUtils.isEmpty((String)schemaTaskCache)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5df2\u4e0b\u8fbe\u7684\u65b9\u6848/\u4efb\u52a1", (String)"AdjustBudgetFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            Long sourceId = IDUtils.toLong((Object)this.getModel().getValue("sourceid"));
            Long periodId = IDUtils.toLong((Object)this.getModel().getValue("periodid"));
            Long dataTypeId = IDUtils.toLong((Object)this.getModel().getValue("datatypeid"));
            Long versionId = IDUtils.toLong((Object)this.getModel().getValue("versionid"));
            String uId = BudgetFormHelper.getUniqueId((Long)sourceId, (Long)periodId, (Long)dataTypeId, (Long)versionId);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bgm_adjust_prtschema");
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u8fbe\u65b9\u6848/\u4efb\u52a1", (String)"AdjustBudgetFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("modelId", (Object)this.getModelId());
            showParameter.setCustomParam("bizModelId", (Object)this.getBizModelId());
            showParameter.setCustomParam("selectSourceId", (Object)uId);
            showParameter.setCustomParam("schemaTaskCache", (Object)schemaTaskCache);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_schema_task"));
            this.getView().showForm(showParameter);
        } else if ("pre_temp".equals(key)) {
            this.moveSearchResult(-1);
        } else if ("next_temp".equals(key)) {
            this.moveSearchResult(1);
        } else if ("btn_continue".equals(key)) {
            this.fillDimMember2Entry();
        } else if ("btnok".equals(key)) {
            boolean isSuccess = this.fillDimMember2Entry();
            if (isSuccess) {
                this.getView().close();
            }
        } else if ("vectorap_close".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("callback_close_report".equals(actionId)) {
            this.getPageCache().remove("focusIdCache");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportlist"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap3"});
        }
        if ((returnData = evt.getReturnData()) == null) {
            return;
        }
        if ("callback_schema_task".equals(actionId)) {
            Long oldVersionId;
            Long oldDataTypeId;
            Long oldPeriodId;
            Map dataMap = (Map)returnData;
            Long sourceId = (Long)dataMap.get("sourceId");
            Long periodId = (Long)dataMap.get("periodId");
            Long dataTypeId = (Long)dataMap.get("dataTypeId");
            Long versionId = (Long)dataMap.get("versionId");
            String newIds = BudgetFormHelper.getUniqueId((Long)sourceId, (Long)periodId, (Long)dataTypeId, (Long)versionId);
            Long oldSourceId = IDUtils.toLong((Object)this.getModel().getValue("sourceid"));
            String oldIds = BudgetFormHelper.getUniqueId((Long)oldSourceId, (Long)(oldPeriodId = IDUtils.toLong((Object)this.getModel().getValue("periodid"))), (Long)(oldDataTypeId = IDUtils.toLong((Object)this.getModel().getValue("datatypeid"))), (Long)(oldVersionId = IDUtils.toLong((Object)this.getModel().getValue("versionid"))));
            if (oldIds.equals(newIds)) {
                return;
            }
            Long orgViewId = (Long)dataMap.get("orgViewId");
            String schemaType = (String)dataMap.get("schemaType");
            String assignName = (String)dataMap.get("assignName");
            this.getModel().setValue("sourceid", (Object)sourceId);
            this.getModel().setValue("schematype", (Object)schemaType);
            this.getModel().setValue("orgviewid", (Object)orgViewId);
            this.getModel().setValue("periodid", (Object)periodId);
            this.getModel().setValue("datatypeid", (Object)dataTypeId);
            this.getModel().setValue("versionid", (Object)versionId);
            Label schemaLabel = (Label)this.getView().getControl("assignschema");
            schemaLabel.setText(assignName);
            this.initLeftTree();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportlist"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap3"});
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode root = this.getCacheTree();
        if (root == null) {
            return;
        }
        String searchText = searchEnterEvent.getText();
        ArrayList<TreeNode> searchNodes = new ArrayList<TreeNode>(16);
        root.getTreeNodeListByText(searchNodes, searchText, 10);
        if (searchNodes.isEmpty()) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("templatetree");
        SearchResult searchResult = new SearchResult(searchNodes);
        TreeNode next = searchResult.next(1);
        treeView.focusNode(next);
        this.getPageCache().put("tempSearchResultCache", SerializationUtils.serializeToBase64((Object)searchResult));
    }

    private void setDefaultValue() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
        Long bizModelId = this.getBizModelId();
        String periodIdStr = (String)this.getView().getFormShowParameter().getCustomParam("periodIds");
        Set periodIds = (Set)SerializationUtils.fromJsonString((String)periodIdStr, Set.class);
        this.getView().getPageCache().put("model", modelId.toString());
        BudgetFormService schemaService = BudgetFormHelper.getBudgetFormService((String)SchemaTaskEnum.SCHEMA.getCode());
        SchemaTaskReq schemaTaskReq = new SchemaTaskReq();
        schemaTaskReq.setModelId(modelId);
        schemaTaskReq.setBizModelId(bizModelId);
        schemaTaskReq.setPeriodIds(periodIds);
        DynamicObject schemaTaskRule = this.getSchemaTaskRule(modelId);
        List schemaDtoList = schemaService.getAssignSchemaTask(schemaTaskReq);
        BudgetFormService taskService = BudgetFormHelper.getBudgetFormService((String)SchemaTaskEnum.TASK.getCode());
        List taskDtoList = taskService.getAssignSchemaTask(schemaTaskReq);
        ArrayList<AssignSchemaTaskDto> assignSchemaTaskList = new ArrayList<AssignSchemaTaskDto>(16);
        if (CollectionUtils.isNotEmpty((Collection)schemaDtoList)) {
            assignSchemaTaskList.addAll(this.filterSchemaTaskList(schemaDtoList, schemaTaskRule, SchemaTaskEnum.SCHEMA.getCode()));
        }
        if (CollectionUtils.isNotEmpty((Collection)taskDtoList)) {
            assignSchemaTaskList.addAll(this.filterSchemaTaskList(taskDtoList, schemaTaskRule, SchemaTaskEnum.TASK.getCode()));
        }
        if (CollectionUtils.isEmpty(assignSchemaTaskList)) {
            return;
        }
        assignSchemaTaskList = assignSchemaTaskList.stream().sorted(Comparator.comparing(AssignSchemaTaskDto::getAssignTime).reversed()).collect(Collectors.toList());
        BudgetFormHelper.saveSchemaTask((Long)this.getModelId(), assignSchemaTaskList);
        this.getView().getPageCache().put("schemaTaskCache", SerializationUtils.serializeToBase64(assignSchemaTaskList));
        AssignSchemaTaskDto assignSchemaTaskDto = this.getDefaultSchemaTask(assignSchemaTaskList, schemaTaskRule);
        if (assignSchemaTaskDto == null) {
            return;
        }
        Label schemaLabel = (Label)this.getView().getControl("assignschema");
        schemaLabel.setText(assignSchemaTaskDto.getAssignName());
        this.getModel().setValue("sourceid", (Object)assignSchemaTaskDto.getId());
        this.getModel().setValue("schematype", (Object)assignSchemaTaskDto.getType());
        this.getModel().setValue("orgviewid", (Object)assignSchemaTaskDto.getOrgViewId());
        this.getModel().setValue("periodid", (Object)assignSchemaTaskDto.getPeriodId());
        this.getModel().setValue("datatypeid", (Object)assignSchemaTaskDto.getDataTypeId());
        this.getModel().setValue("versionid", (Object)assignSchemaTaskDto.getVersionId());
    }

    private void initLeftTree() {
        this.clearPageCache();
        this.buildTemplateTree();
    }

    private void buildTemplateTree() {
        TreeView viewTree = (TreeView)this.getControl("templatetree");
        viewTree.deleteAllNodes();
        this.deleteAllNodeInCache();
        Set<Long> templateIds = this.getTemplateIds();
        if (CollectionUtils.isEmpty(templateIds)) {
            return;
        }
        TreeNode rootNode = BudgetFormHelper.buildTemplateRootNode((Long)this.getModelId(), templateIds);
        viewTree.updateNode(rootNode);
        viewTree.addNode(rootNode);
        List children = rootNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            TreeNode treeNode = (TreeNode)children.get(0);
            viewTree.expand(treeNode.getId());
        } else {
            viewTree.expand(rootNode.getId());
        }
        F7TreeUtils.cacheTreeNodeData((IPageCache)this.getPageCache(), (String)"templatetree", (TreeNode)rootNode);
    }

    private Set<Long> getTemplateIds() {
        Long sourceId = (Long)this.getModel().getValue("sourceid");
        String schemaType = (String)this.getModel().getValue("schematype");
        if (StringUtils.isEmpty((String)schemaType)) {
            return null;
        }
        BudgetFormService budgetFormService = BudgetFormHelper.getBudgetFormService((String)schemaType);
        Set assignTemplateIds = budgetFormService.getAssignTemplateIds(sourceId, this.getModelId());
        Set templateIds = null;
        String ruleTempIdsCache = this.getPageCache().get("ruleTempIdsCache");
        if (StringUtils.isNotEmpty((String)ruleTempIdsCache)) {
            templateIds = (Set)SerializationUtils.deSerializeFromBase64((String)ruleTempIdsCache);
        }
        if (templateIds != null) {
            templateIds.retainAll(assignTemplateIds);
        } else {
            templateIds = assignTemplateIds;
        }
        return templateIds;
    }

    private Long getAssignOrgId(Long templateId) {
        Long defaultOrgId;
        Long assignOrgId;
        Long modelId = this.getModelId();
        Long bizModelId = this.getBizModelId();
        Long sourceId = IDUtils.toLong((Object)this.getModel().getValue("sourceid"));
        Long orgViewId = IDUtils.toLong((Object)this.getModel().getValue("orgviewid"));
        String schemaType = (String)this.getModel().getValue("schematype");
        BudgetFormService budgetFormService = BudgetFormHelper.getBudgetFormService((String)schemaType);
        Set orgIds = budgetFormService.getAssignOrgIds(sourceId, modelId, bizModelId, orgViewId, templateId);
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return 0L;
        }
        Map<Long, Integer> seqMap = this.getOrgNumberSeqOfDeep();
        ArrayList orgIdList = new ArrayList(orgIds);
        orgIdList.sort((o1, o2) -> {
            Integer seq1 = (Integer)seqMap.get(o1);
            Integer seq2 = (Integer)seqMap.get(o2);
            if (seq1 != null && seq2 != null && seq1.compareTo(seq2) != 0) {
                return seq1.compareTo(seq2);
            }
            return 1;
        });
        this.getPageCache().put("orgViewIdCache", orgViewId.toString());
        this.getPageCache().put("orgIdsCache", SerializationUtils.serializeToBase64(orgIdList));
        Long selectOrgId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("selectOrgId"));
        if (orgIdList.contains(selectOrgId)) {
            assignOrgId = selectOrgId;
            defaultOrgId = selectOrgId;
        } else {
            Member orgMember;
            IModelCacheHelper modelCacheHelper;
            List parentMembers;
            List parentIds;
            boolean disjoint;
            defaultOrgId = IDUtils.isNotNull((Long)selectOrgId) ? (!(disjoint = Collections.disjoint(orgIdList, parentIds = (parentMembers = (modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId)).getParents(orgViewId, orgMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, selectOrgId), false)).stream().map(BaseCache::getId).collect(Collectors.toList()))) ? selectOrgId : (Long)orgIdList.get(0)) : (Long)orgIdList.get(0);
            assignOrgId = (Long)orgIdList.get(0);
        }
        this.getPageCache().put("defaultOrgId", defaultOrgId.toString());
        return assignOrgId;
    }

    private void deleteAllNodeInCache() {
        this.getPageCache().remove("templatetree");
    }

    private void openReportList(Long entityId, Long templateId) {
        Long sourceId = IDUtils.toLong((Object)this.getModel().getValue("sourceid"));
        Long periodId = IDUtils.toLong((Object)this.getModel().getValue("periodid"));
        Long datatypeId = IDUtils.toLong((Object)this.getModel().getValue("datatypeid"));
        Long versionId = IDUtils.toLong((Object)this.getModel().getValue("versionid"));
        String schemaType = (String)this.getModel().getValue("schematype");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("reportlist");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        BudgetFormService budgetFormService = BudgetFormHelper.getBudgetFormService((String)schemaType);
        HashMap<String, Long> idMap = new HashMap<String, Long>(4);
        idMap.put("periodId", periodId);
        idMap.put("versionId", versionId);
        idMap.put("datatypeId", datatypeId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(5);
        paramMap.put("isBudgetForm", "true");
        paramMap.put("showReport", true);
        paramMap.put("model", this.getModelId());
        if (SchemaTaskEnum.SCHEMA.getCode().equals(schemaType)) {
            idMap.put("modelId", this.getModelId());
            Set processIds = budgetFormService.getAssignProcessIds(idMap, entityId, templateId);
            if (CollectionUtils.isEmpty((Collection)processIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8fbe\u8be5\u62a5\u8868\u5b9e\u4f8b\u3002", (String)"AdjustBudgetFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("BILL_PROCESSID", SerializationUtils.toJsonString((Object)processIds));
            paramMap.put("source", sourceId);
            formShowParameter.setFormId("bgm_rptpreparation");
        } else {
            idMap.put("sourceId", sourceId);
            Set processIds = budgetFormService.getAssignProcessIds(idMap, entityId, templateId);
            if (CollectionUtils.isEmpty((Collection)processIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728", (String)"AdjustBudgetFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            paramMap.put("taskProcessIds", SerializationUtils.toJsonString((Object)processIds));
            formShowParameter.setFormId("eb_executetask");
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_close_report"));
        formShowParameter.setCustomParams(paramMap);
        this.getView().showForm(formShowParameter);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"reportlist"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
    }

    private Long getBizModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("bizModelId"));
    }

    private void clearPageCache() {
        this.getPageCache().remove("needBuildTemplateTree");
        this.getPageCache().remove("focusIdCache");
    }

    private TreeNode getTemplateTreeNode() {
        String templateTreeRootNodeStr = this.getPageCache().get("templatetree");
        return F7TreeUtils.getCacheTreeNodeData((String)templateTreeRootNodeStr);
    }

    private AssignSchemaTaskDto getDefaultSchemaTask(List<AssignSchemaTaskDto> assignSchemaTaskList, DynamicObject rptSchemaRule) {
        AssignSchemaTaskDto assignSchemaTaskDto = assignSchemaTaskList.get(0);
        if (rptSchemaRule == null) {
            return assignSchemaTaskDto;
        }
        AssignSchemaTaskDto defaultSchemaTask = null;
        Long bizModelId = this.getBizModelId();
        String assignSchemaJson = rptSchemaRule.getString("schemataskjson");
        if (StringUtils.isNotEmpty((String)assignSchemaJson)) {
            List ruleSchemaTaskList = SerializationUtils.fromJsonStringToList((String)assignSchemaJson, AssignSchemaTaskDto.class);
            for (AssignSchemaTaskDto ruleSchemaTask : ruleSchemaTaskList) {
                Long bizModelIdForRule = ruleSchemaTask.getBizModelId();
                if (bizModelIdForRule.compareTo(bizModelId) != 0) continue;
                defaultSchemaTask = ruleSchemaTask;
                break;
            }
        }
        if (defaultSchemaTask != null) {
            HashSet<String> uIds = new HashSet<String>(assignSchemaTaskList.size());
            for (AssignSchemaTaskDto schemaTaskDto : assignSchemaTaskList) {
                String uId = BudgetFormHelper.getUniqueId((Long)schemaTaskDto.getId(), (Long)schemaTaskDto.getPeriodId(), (Long)schemaTaskDto.getDataTypeId(), (Long)schemaTaskDto.getVersionId());
                uIds.add(uId);
            }
            String defaultUId = BudgetFormHelper.getUniqueId((Long)defaultSchemaTask.getId(), (Long)defaultSchemaTask.getPeriodId(), (Long)defaultSchemaTask.getDataTypeId(), (Long)defaultSchemaTask.getVersionId());
            if (!uIds.contains(defaultUId)) {
                defaultSchemaTask = assignSchemaTaskDto;
            }
        } else {
            defaultSchemaTask = assignSchemaTaskDto;
        }
        Set<Long> datasetIds = this.queryDataSetIds(this.getBizModelId());
        DynamicObjectCollection templateColl = rptSchemaRule.getDynamicObjectCollection("entryentity_temp");
        HashSet<Long> ruleTemplateIds = new HashSet<Long>(templateColl.size());
        for (DynamicObject template : templateColl) {
            Long templateId = template.getLong("template.id");
            Long datasetId = template.getLong("template.dataset.id");
            if (!datasetIds.contains(datasetId)) continue;
            ruleTemplateIds.add(templateId);
        }
        if (CollectionUtils.isNotEmpty(ruleTemplateIds)) {
            this.getPageCache().put("ruleTempIdsCache", SerializationUtils.serializeToBase64(ruleTemplateIds));
        }
        return defaultSchemaTask;
    }

    private void moveSearchResult(int moveStep) {
        String searchResultCache = this.getPageCache().get("tempSearchResultCache");
        if (StringUtils.isEmpty((String)searchResultCache)) {
            return;
        }
        SearchResult result = (SearchResult)SerializationUtils.deSerializeFromBase64((String)searchResultCache);
        if (result == null) {
            return;
        }
        TreeNode node = result.next(moveStep);
        if (node == null) {
            if (moveStep == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ApprovalTypeEditPluginNew_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ApprovalTypeEditPluginNew_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        TreeView treeView = (TreeView)this.getControl("templatetree");
        treeView.focusNode(node);
        this.getPageCache().put("tempSearchResultCache", SerializationUtils.serializeToBase64((Object)result));
    }

    private TreeNode getCacheTree() {
        String cacheTreeNode = this.getPageCache().get("templatetree");
        return F7TreeUtils.getCacheTreeNodeData((String)cacheTreeNode);
    }

    private DynamicObject getSchemaTaskRule(Long modelId) {
        QFilter ruleFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject rptSchemaRuleObj = QueryServiceHelper.queryOne((String)"bgm_rptschema_rule", (String)"id", (QFilter[])ruleFilter.toArray());
        if (rptSchemaRuleObj == null) {
            return null;
        }
        Long pkId = rptSchemaRuleObj.getLong("id");
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bgm_rptschema_rule");
    }

    /*
     * Unable to fully structure code
     */
    private List<AssignSchemaTaskDto> filterSchemaTaskList(List<AssignSchemaTaskDto> schemaTaskDtoList, DynamicObject rptSchemaRule, String code) {
        if (rptSchemaRule == null) {
            return schemaTaskDtoList;
        }
        isFilter = false;
        bizModelId = this.getBizModelId();
        assignSchemaJson = rptSchemaRule.getString("schemataskjson");
        if (StringUtils.isNotEmpty((String)assignSchemaJson)) {
            ruleSchemaTaskList = SerializationUtils.fromJsonStringToList((String)assignSchemaJson, AssignSchemaTaskDto.class);
            for (AssignSchemaTaskDto ruleSchemaTask : ruleSchemaTaskList) {
                bizModelIdForRule = ruleSchemaTask.getBizModelId();
                if (bizModelIdForRule.compareTo(bizModelId) != 0) continue;
                isFilter = true;
                break;
            }
        }
        if (!isFilter) {
            return schemaTaskDtoList;
        }
        templateColl = rptSchemaRule.getDynamicObjectCollection("entryentity_temp");
        if (CollectionUtils.isEmpty((Collection)templateColl)) {
            return schemaTaskDtoList;
        }
        datasetIds = this.queryDataSetIds(this.getBizModelId());
        ruleTemplateIds = new HashSet<Long>(templateColl.size());
        for (DynamicObject template : templateColl) {
            templateId = template.getLong("template.id");
            datasetId = template.getLong("template.dataset.id");
            if (!datasetIds.contains(datasetId)) continue;
            ruleTemplateIds.add(templateId);
        }
        if (ruleTemplateIds.isEmpty()) {
            return schemaTaskDtoList;
        }
        schemaIds = new HashSet<Long>(16);
        if (SchemaTaskEnum.SCHEMA.getCode().equals(code)) {
            tempFilter = new QFilter("template.id", "in", ruleTemplateIds);
            templateOrgColl = QueryServiceHelper.query((String)"eb_templateorg", (String)"scheme.id", (QFilter[])tempFilter.toArray());
            for (DynamicObject templateOrg : templateOrgColl) {
                schemaIds.add(templateOrg.getLong("scheme.id"));
            }
        } else {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid from t_eb_taskreftemplate where", new Object[0]);
            sqlBuilder.appendIn("ftemplateid", ruleTemplateIds.toArray());
            ds = DB.queryDataSet((String)"queryTaskIds", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            var13_13 = null;
            try {
                if (ds == null) ** GOTO lbl66
                for (Row row : ds) {
                    schemaIds.add(row.getLong("fid"));
                }
            }
            catch (Throwable var14_17) {
                var13_13 = var14_17;
                throw var14_17;
            }
            finally {
                if (ds != null) {
                    if (var13_13 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable var14_16) {
                            var13_13.addSuppressed(var14_16);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
lbl66:
        // 3 sources

        if (schemaIds.isEmpty()) {
            return new ArrayList<AssignSchemaTaskDto>(16);
        }
        return schemaTaskDtoList.stream().filter((Predicate<AssignSchemaTaskDto>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$filterSchemaTaskList$1(java.util.Set kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto ), (Lkd/epm/eb/common/adjust/budgetform/AssignSchemaTaskDto;)Z)(schemaIds)).collect(Collectors.toList());
    }

    private boolean fillDimMember2Entry() {
        Map cellDimMemMap = null;
        String dimMemberCache = this.getPageCache().get("rptDimMemberCache");
        if (StringUtils.isNotEmpty((String)dimMemberCache)) {
            cellDimMemMap = (Map)SerializationUtils.deSerializeFromBase64((String)dimMemberCache);
        }
        int cellCount = 0;
        String cellCountCache = this.getPageCache().get("rptCellCountCache");
        if (StringUtils.isNotEmpty((String)cellCountCache)) {
            cellCount = Integer.parseInt(cellCountCache);
        }
        IFormView adjustBillView = this.getView().getParentView();
        boolean result = AdjustUtil.handleReportDimMember(adjustBillView, cellDimMemMap, cellCount);
        this.getView().sendFormAction(adjustBillView);
        return result;
    }

    public Map<Long, Integer> getOrgNumberSeqOfDeep() {
        Long orgViewId = IDUtils.toLong((Object)this.getModel().getValue("orgviewid"));
        HashMap<Long, Integer> orgSeqOfDeep = new HashMap<Long, Integer>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List memberSort = modelCacheHelper.getMemberSort(SysDimensionEnum.Entity.getNumber(), orgViewId, SysDimensionEnum.Entity.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)memberSort)) {
            for (int i = 0; i < memberSort.size(); ++i) {
                Member member = (Member)memberSort.get(i);
                orgSeqOfDeep.put(member.getId(), i);
            }
        }
        return orgSeqOfDeep;
    }

    private Set<Long> queryDataSetIds(Long bizModelId) {
        HashSet<Long> datasetIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("businessmodel", "=", (Object)bizModelId);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dc : dcs) {
            datasetIds.add(dc.getLong("id"));
        }
        return datasetIds;
    }

    private static /* synthetic */ boolean lambda$filterSchemaTaskList$1(Set schemaIds, AssignSchemaTaskDto schema) {
        return schemaIds.contains(schema.getId());
    }
}

