/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.budgetform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.utils.IDUtils;

public abstract class BaseSchemaTaskListPlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
SetFilterListener {
    public void initialize() {
        super.initialize();
        TreeView viewTree = (TreeView)this.getControl("treeviewap");
        viewTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String schemaTaskCache = (String)this.getView().getFormShowParameter().getCustomParam("schemaTaskCache");
        if (StringUtils.isEmpty((String)schemaTaskCache)) {
            return;
        }
        List schemaTaskDtoList = (List)SerializationUtils.deSerializeFromBase64((String)schemaTaskCache);
        if (CollectionUtils.isEmpty((Collection)schemaTaskDtoList)) {
            return;
        }
        LinkedHashMap<Long, Set<Long>> bizModelPeriodMap = new LinkedHashMap<Long, Set<Long>>(schemaTaskDtoList.size());
        schemaTaskDtoList.stream().forEach(dto -> {
            Long bizModel = dto.getBizModelId();
            Long periodId = dto.getPeriodId();
            Set periodIds = bizModelPeriodMap.computeIfAbsent(bizModel, v -> new HashSet(16));
            periodIds.add(periodId);
        });
        this.initLeftTree(bizModelPeriodMap);
        this.selectEntryRows();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "cbchildren": {
                this.refreshList();
                break;
            }
        }
    }

    protected abstract void selectEntryRows();

    public void treeNodeClick(TreeNodeEvent evt) {
        String focusNodeId = (String)evt.getNodeId();
        this.cacheNodeId(focusNodeId);
        String schemaTaskCache = (String)this.getView().getFormShowParameter().getCustomParam("schemaTaskCache");
        if (StringUtils.isEmpty((String)schemaTaskCache)) {
            return;
        }
        this.refreshList();
        this.selectEntryRows();
    }

    private void initLeftTree(Map<Long, Set<Long>> bizModelPeriodMap) {
        TreeView viewTree = (TreeView)this.getControl("treeviewap");
        viewTree.deleteAllNodes();
        TreeNode rootNode = this.buildPeriodRootNode(bizModelPeriodMap);
        F7TreeUtils.cacheTreeNodeData((IPageCache)this.getPageCache(), (String)"periodTreeNodeCache", (TreeNode)rootNode);
        viewTree.addNode(rootNode);
        viewTree.updateNode(rootNode);
        List children = rootNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)children)) {
            TreeNode treeNode = (TreeNode)children.get(0);
            viewTree.expand(treeNode.getId());
            viewTree.focusNode(treeNode);
            viewTree.treeNodeClick("", treeNode.getId());
        } else {
            viewTree.expand(rootNode.getId());
            viewTree.focusNode(rootNode);
            viewTree.treeNodeClick("", rootNode.getId());
        }
    }

    private TreeNode buildPeriodRootNode(Map<Long, Set<Long>> bizModelPeriodMap) {
        Map bizModelMap = BusinessDataServiceHelper.loadFromCache((Object[])bizModelPeriodMap.keySet().toArray(), (String)"eb_businessmodel");
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        TreeNode rootNode = new TreeNode();
        rootNode.setId("");
        rootNode.setText("root");
        rootNode.setParentid("");
        for (Map.Entry<Long, Set<Long>> bizModelPeriodEntry : bizModelPeriodMap.entrySet()) {
            Long bizModelId = bizModelPeriodEntry.getKey();
            DynamicObject bizModelObj = (DynamicObject)bizModelMap.get(bizModelId);
            if (bizModelObj == null) continue;
            TreeNode bizModelNode = new TreeNode();
            bizModelNode.setId(bizModelId.toString());
            bizModelNode.setText(bizModelObj.getString("name"));
            HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
            dataMap.put("bizModel", bizModelId);
            dataMap.put("nodeType", "bizmodel");
            bizModelNode.setData(dataMap);
            Set<Long> periodIds = bizModelPeriodEntry.getValue();
            HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(16);
            for (Long l : periodIds) {
                Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), l);
                if (member == null) continue;
                List parentMemberList = modelCacheHelper.getParents(null, member, true);
                for (Member parentMember : parentMemberList) {
                    Long id = parentMember.getId();
                    Long parentId = parentMember.getParentId();
                    if (IDUtils.isNull((Long)parentId)) continue;
                    TreeNode treeNode = this.buildPeriodTreeNode(bizModelId, id, parentMember.getNumber(), parentMember.getName(), parentId);
                    if (treeNodeMap.containsKey(bizModelId + "#" + id)) continue;
                    treeNodeMap.put(bizModelId + "#" + id, treeNode);
                }
            }
            for (Map.Entry entry : treeNodeMap.entrySet()) {
                TreeNode node = (TreeNode)entry.getValue();
                String parentId = node.getParentid();
                if (StringUtils.isEmpty((String)parentId)) {
                    bizModelNode.addChild(node);
                    continue;
                }
                TreeNode parent = this.getParentNode(node, treeNodeMap, modelCacheHelper);
                if (parent == null) {
                    node.setParentid(bizModelNode.getId());
                    bizModelNode.addChild(node);
                    continue;
                }
                ArrayList<TreeNode> children = parent.getChildren();
                if (children == null) {
                    children = new ArrayList<TreeNode>(10);
                    parent.setChildren(children);
                }
                children.add(node);
            }
            rootNode.addChild(bizModelNode);
        }
        this.sortTreeNode(rootNode, this.getPeriodSeqMap(modelCacheHelper));
        return rootNode;
    }

    private TreeNode getParentNode(TreeNode node, Map<String, TreeNode> treeNodeMap, IModelCacheHelper modelCacheHelper) {
        String parentId = node.getParentid();
        TreeNode parent = treeNodeMap.get(parentId);
        if (parent == null) {
            String[] parentNodeIdArr = parentId.split("#");
            Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), IDUtils.toLong((Object)parentNodeIdArr[1]));
            List parentMemberList = modelCacheHelper.getParents(null, member, false);
            for (Member parentMember : parentMemberList) {
                Long parentMemberId = parentMember.getId();
                parent = treeNodeMap.get(parentNodeIdArr[0] + "#" + parentMemberId);
                if (parent == null) continue;
                node.setParentid(parent.getId());
                break;
            }
        }
        return parent;
    }

    private TreeNode buildPeriodTreeNode(Long bizModelId, Long periodId, String number, String name, Long parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(bizModelId + "#" + periodId);
        treeNode.setLongNumber(number);
        treeNode.setText(name);
        treeNode.setParentid(bizModelId + "#" + parentId);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("bizModel", bizModelId);
        dataMap.put("nodeType", "period");
        treeNode.setData(dataMap);
        return treeNode;
    }

    private TreeNode getCacheTree() {
        String treeRootNodeStr = this.getPageCache().get("periodTreeNodeCache");
        return F7TreeUtils.getCacheTreeNodeData((String)treeRootNodeStr);
    }

    private void sortTreeNode(TreeNode treeNode, Map<Long, Integer> periodSeqMap) {
        if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            return;
        }
        List children = treeNode.getChildren();
        children.sort((t1, t2) -> {
            if (!t1.getId().contains("#") || !t2.getId().contains("#")) {
                return 1;
            }
            String[] nodeId1 = t1.getId().split("#");
            String[] nodeId2 = t2.getId().split("#");
            Long periodId1 = IDUtils.toLong((Object)nodeId1[1]);
            Long periodId2 = IDUtils.toLong((Object)nodeId2[1]);
            Integer seq1 = (Integer)periodSeqMap.get(periodId1);
            Integer seq2 = (Integer)periodSeqMap.get(periodId2);
            if (seq1 != null && seq2 != null && seq1.compareTo(seq2) != 0) {
                return seq2.compareTo(seq1);
            }
            return 1;
        });
        for (TreeNode child : children) {
            this.sortTreeNode(child, periodSeqMap);
        }
    }

    private Map<Long, Integer> getPeriodSeqMap(IModelCacheHelper modelCacheHelper) {
        LinkedHashMap<Long, Integer> periodSeqMap = new LinkedHashMap<Long, Integer>(16);
        List memberSort = modelCacheHelper.getMemberSort(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), SysDimensionEnum.BudgetPeriod.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        for (int i = 0; i < memberSort.size(); ++i) {
            Member member = (Member)memberSort.get(i);
            periodSeqMap.put(member.getId(), i);
        }
        return periodSeqMap;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("modelId");
        QFilter filter = new QFilter("model.id", "=", (Object)modelId);
        e.getQFilters().add(filter);
        TreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return;
        }
        String focusNodeId = this.getPageCache().get("nodeIdCache");
        TreeNode treeNode = cacheTree.getTreeNode(focusNodeId, 10);
        Map dataMap = (Map)treeNode.getData();
        String nodeType = (String)dataMap.get("nodeType");
        if ("bizmodel".equals(nodeType)) {
            filter.and(new QFilter("bizmodel.id", "in", (Object)Long.valueOf(focusNodeId)));
        } else {
            String[] nodeIdArr = focusNodeId.split("#");
            Long bizModelId = IDUtils.toLong((Object)nodeIdArr[0]);
            Long periodId = IDUtils.toLong((Object)nodeIdArr[1]);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Member member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), periodId);
            Boolean includeChildren = (Boolean)this.getModel().getValue("cbchildren");
            List memberList = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), member.getNumber(), includeChildren != false ? RangeEnum.ALL.getIndex() : RangeEnum.ONLY.getIndex());
            Set periodIds = memberList.stream().map(BaseCache::getId).collect(Collectors.toSet());
            filter.and(new QFilter("bizmodel.id", "in", (Object)bizModelId));
            filter.and(new QFilter("budgetperiod.id", "in", periodIds));
        }
        e.getQFilters().add(filter);
    }

    public void refreshList() {
        BillList _billList = (BillList)this.getControl("billlistap");
        if (_billList != null) {
            _billList.refreshData();
        }
    }

    private void cacheNodeId(String nodeId) {
        this.getPageCache().put("nodeIdCache", nodeId);
    }
}

