/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.budgetform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.adjust.AdjustDimMem;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import kd.epm.eb.formplugin.report.reportview.DynamicReportProcess;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;

public class BudgetFormDynamicReportProcess
extends DynamicReportProcess {
    public BudgetFormDynamicReportProcess(IFormPlugin parentPlugin) {
        super(parentPlugin);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getSpreadContainer().lockSheets(Collections.singletonList("Sheet1"));
        this.spreadContainer.hideContextMenuItems(this.getHideContextMenuItems(), null);
    }

    @Override
    public void cellClick(SpreadSelector selector) {
        super.cellClick(selector);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        int cellCount = 0;
        LinkedHashMap<AdjustDimMem, List> cellDimMemMap = new LinkedHashMap<AdjustDimMem, List>(16);
        for (int row = selector.getStartRow(); row <= selector.getEndRow(); ++row) {
            for (int col = selector.getStartCol(); col <= selector.getEndCol(); ++col) {
                Map<String, String> dimMemberMap = this.getMemberMapByCell(row, col);
                if (CollectionUtils.isNotEmpty(dimMemberMap)) {
                    Long viewId = this.getEntityViewId(row, col);
                    String cell = ExcelUtils.xy2Pos((int)col, (int)row);
                    AdjustDimMem budgetFormCell = new AdjustDimMem(viewId, dimMemberMap);
                    List cellList = cellDimMemMap.computeIfAbsent(budgetFormCell, v -> new ArrayList(16));
                    cellList.add(cell);
                }
                ++cellCount;
            }
        }
        if (CollectionUtils.isNotEmpty(cellDimMemMap)) {
            parentView.getPageCache().put("rptDimMemberCache", SerializationUtils.serializeToBase64(cellDimMemMap));
        } else {
            parentView.getPageCache().put("rptDimMemberCache", null);
        }
        parentView.getPageCache().put("rptCellCountCache", String.valueOf(cellCount));
    }

    @Override
    public void doubleClickLockedCell(int row, int col) {
        IFormView adjustBillView;
        super.doubleClickLockedCell(row, col);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (adjustBillView = parentView.getParentView()) != null) {
            LinkedHashMap<AdjustDimMem, List<String>> cellDimMemMap = new LinkedHashMap<AdjustDimMem, List<String>>(1);
            Map<String, String> dimMemberMap = this.getMemberMapByCell(row, col);
            if (CollectionUtils.isNotEmpty(dimMemberMap)) {
                Long viewId = this.getEntityViewId(row, col);
                String cell = ExcelUtils.xy2Pos((int)col, (int)row);
                AdjustDimMem budgetFormCell = new AdjustDimMem(viewId, dimMemberMap);
                List cellList = cellDimMemMap.computeIfAbsent(budgetFormCell, v -> new ArrayList(1));
                cellList.add(cell);
            }
            AdjustUtil.handleReportDimMember(adjustBillView, cellDimMemMap, 1);
            this.getView().sendFormAction(adjustBillView);
        }
    }

    @Override
    protected List<ContextMenuItemsEnum> getHideContextMenuItems() {
        return Lists.newArrayList((Object[])ContextMenuItemsEnum.values());
    }

    @Override
    protected void refreshOlapData(OlapQuerySync olapQuerySync) {
    }

    private Long getEntityViewId(int row, int col) {
        CellDimMember entityMember;
        String partition;
        Map rowMems = this.getSpreadManager().getRowpartitionDimMemsByRow(Integer.valueOf(row));
        Map colMems = this.getSpreadManager().getColpartitionDimMemsByCol(Integer.valueOf(col));
        Long entityViewId = IDUtils.toLong((Object)this.getCurrentEntityViewId());
        Map dimensionViews = this.getSpreadManager().getDimemsionViews();
        if (rowMems.containsKey(SysDimensionEnum.Entity.getNumber())) {
            CellDimMember entityMember2 = (CellDimMember)rowMems.get(SysDimensionEnum.Entity.getNumber());
            String partition2 = entityMember2.getPartition();
            if (StringUtils.isNotEmpty((String)partition2) && dimensionViews.containsKey("Entity_" + partition2)) {
                entityViewId = (Long)dimensionViews.get("Entity_" + partition2);
            }
        } else if (colMems.containsKey(SysDimensionEnum.Entity.getNumber()) && StringUtils.isNotEmpty((String)(partition = (entityMember = (CellDimMember)colMems.get(SysDimensionEnum.Entity.getNumber())).getPartition())) && dimensionViews.containsKey("Entity_" + partition)) {
            entityViewId = (Long)dimensionViews.get("Entity_" + partition);
        }
        return entityViewId;
    }
}

