/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.budgetform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.business.adjust.budgetform.BudgetFormService;
import kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskEnum;
import kd.epm.eb.common.adjust.budgetform.SchemaTaskReq;
import kd.epm.eb.common.member.f7.F7TreeUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.templateperm.vo.SearchResult;

public class BudgetFormRuleSettingPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
SearchEnterListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"assignschema", "btn_add", "btn_remove", "btnok", "select_all_temp", "clear_all_temp", "expand_all_temp", "shrink_all_temp", "pre_temp", "next_temp"});
        TreeView templateTree = (TreeView)this.getControl("templatetree");
        templateTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search searchTemp = (Search)this.getControl("temp_search");
        searchTemp.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"));
        this.getModel().setValue("model", (Object)modelId);
        this.getPageCache().put("model", modelId.toString());
        this.initLeftTree();
        this.showRuleData(modelId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("assignschema".equals(key)) {
            List<AssignSchemaTaskDto> assignSchemaTaskList;
            String selectSourceIds = "";
            String selectAssignSchemaJson = (String)this.getModel().getValue("assignschemajson");
            if (StringUtils.isNotEmpty((String)selectAssignSchemaJson)) {
                assignSchemaTaskList = SerializationUtils.fromJsonStringToList((String)selectAssignSchemaJson, AssignSchemaTaskDto.class);
                HashSet<String> uIds = new HashSet<String>(assignSchemaTaskList.size());
                for (AssignSchemaTaskDto schemaTaskDto : assignSchemaTaskList) {
                    Long sourceId = schemaTaskDto.getId();
                    Long periodId = schemaTaskDto.getPeriodId();
                    Long dataTypeId = schemaTaskDto.getDataTypeId();
                    Long versionId = schemaTaskDto.getVersionId();
                    String uId = BudgetFormHelper.getUniqueId((Long)sourceId, (Long)periodId, (Long)dataTypeId, (Long)versionId);
                    uIds.add(uId);
                }
                selectSourceIds = SerializationUtils.serializeToBase64(uIds);
            }
            assignSchemaTaskList = this.getAssignSchemaTaskList(this.getModelId());
            BudgetFormHelper.saveSchemaTask((Long)this.getModelId(), assignSchemaTaskList);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bgm_adjustrule_rptschema");
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e0b\u8fbe\u65b9\u6848/\u4efb\u52a1", (String)"AdjustBudgetFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("modelId", (Object)this.getModelId());
            showParameter.setCustomParam("selectSourceIds", (Object)selectSourceIds);
            showParameter.setCustomParam("schemaTaskCache", (Object)SerializationUtils.serializeToBase64(assignSchemaTaskList));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_schema_task"));
            this.getView().showForm(showParameter);
        } else if ("btn_add".equals(key)) {
            this.addTemplate();
        } else if ("btn_remove".equals(key)) {
            this.removeTemplate();
        } else if ("btnok".equals(key)) {
            this.saveRuleData();
        } else if ("select_all_temp".equals(key)) {
            this.selectAllTemp();
        } else if ("clear_all_temp".equals(key)) {
            this.clearAllTemp();
        } else if ("expand_all_temp".equals(key)) {
            this.expandAllTemp();
        } else if ("shrink_all_temp".equals(key)) {
            this.shrinkAllTemp();
        } else if ("pre_temp".equals(key)) {
            this.moveSearchResult(-1);
        } else if ("next_temp".equals(key)) {
            this.moveSearchResult(1);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("callback_schema_task".equals(actionId)) {
            String assignSchemaTaskStr = (String)returnData;
            List assignSchemaTaskList = (List)SerializationUtils.deSerializeFromBase64((String)assignSchemaTaskStr);
            StringBuilder schemaNameStr = new StringBuilder();
            for (AssignSchemaTaskDto assignSchemaTask : assignSchemaTaskList) {
                schemaNameStr.append(assignSchemaTask.getAssignName()).append(";");
            }
            if (schemaNameStr.length() > 0) {
                schemaNameStr.setLength(schemaNameStr.length() - 1);
            }
            this.getModel().setValue("assignschema", (Object)schemaNameStr.toString());
            this.getModel().setValue("assignschemajson", (Object)SerializationUtils.toJsonString((Object)assignSchemaTaskList));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        TreeView treeView = (TreeView)treeNodeCheckEvent.getSource();
        int count = 0;
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        for (Map checkedNode : checkedNodes) {
            Object isParent = checkedNode.get("isParent");
            String parentId = (String)checkedNode.get("parentid");
            if (StringUtils.isEmpty((String)parentId) || Convert.toBool(isParent).booleanValue()) continue;
            ++count;
        }
        Label label = (Label)this.getControl("label_temp_focus");
        label.setText(String.valueOf(count));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("assignschema".equals(propKey) && "".equals(newValue)) {
            this.getModel().setValue("assignschemajson", (Object)"");
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode root = this.getCacheTree();
        if (root == null) {
            return;
        }
        String searchText = searchEnterEvent.getText();
        ArrayList<TreeNode> searchNodes = new ArrayList<TreeNode>(16);
        root.getTreeNodeListByText(searchNodes, searchText, 10);
        if (searchNodes.isEmpty()) {
            return;
        }
        SearchResult searchResult = new SearchResult(searchNodes);
        TreeNode next = searchResult.next(1);
        TreeView treeView = (TreeView)this.getControl("templatetree");
        treeView.focusNode(next);
        this.getPageCache().put("searchResultCache", SerializationUtils.serializeToBase64((Object)searchResult));
    }

    private List<AssignSchemaTaskDto> getAssignSchemaTaskList(Long modelId) {
        BudgetFormService schemaService = BudgetFormHelper.getBudgetFormService((String)SchemaTaskEnum.SCHEMA.getCode());
        SchemaTaskReq schemaTaskReq = new SchemaTaskReq();
        schemaTaskReq.setModelId(modelId);
        schemaTaskReq.setAll(true);
        List schemaDtoList = schemaService.getAssignSchemaTask(schemaTaskReq);
        BudgetFormService taskService = BudgetFormHelper.getBudgetFormService((String)SchemaTaskEnum.TASK.getCode());
        List taskDtoList = taskService.getAssignSchemaTask(schemaTaskReq);
        ArrayList<AssignSchemaTaskDto> assignSchemaTaskList = new ArrayList(16);
        if (CollectionUtils.isNotEmpty((Collection)schemaDtoList)) {
            assignSchemaTaskList.addAll(schemaDtoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskDtoList)) {
            assignSchemaTaskList.addAll(taskDtoList);
        }
        assignSchemaTaskList = assignSchemaTaskList.stream().sorted(Comparator.comparing(AssignSchemaTaskDto::getAssignTime).reversed()).collect(Collectors.toList());
        return assignSchemaTaskList;
    }

    private void initLeftTree() {
        Long modelId = this.getModelId();
        TreeNode root = BudgetFormHelper.buildTemplateRootNode((Long)modelId);
        TreeView tempTree = (TreeView)this.getControl("templatetree");
        tempTree.deleteAllNodes();
        tempTree.addNode(root);
        tempTree.updateNode(root);
        tempTree.expand(root.getId());
        F7TreeUtils.cacheTreeNodeData((IPageCache)this.getPageCache(), (String)"templatetree", (TreeNode)root);
        List treeNodeList = root.getChildren();
        if (CollectionUtils.isEmpty((Collection)treeNodeList)) {
            return;
        }
        Map dataMap = (Map)root.getData();
        String totalCounts = (String)dataMap.get("leafCounts");
        Label label = (Label)this.getControl("label_temp_all");
        label.setText(totalCounts);
    }

    private void addTemplate() {
        TreeView treeView = (TreeView)this.getView().getControl("templatetree");
        List checkedNodes = treeView.getTreeState().getCheckedNodes();
        if (CollectionUtils.isEmpty((Collection)checkedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u8bb0\u5f55\u3002", (String)"ApprovalTypeRelationPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode cacheTree = this.getCacheTree();
        if (cacheTree == null) {
            return;
        }
        ArrayList<String> selectNodeIds = new ArrayList<String>(checkedNodes.size());
        for (Map checkedNode : checkedNodes) {
            Object isParent;
            String parentId = (String)checkedNode.get("parentid");
            if (StringUtils.isEmpty((String)parentId) || Convert.toBool(isParent = checkedNode.get("isParent")).booleanValue()) continue;
            String selectNodeId = (String)checkedNode.get("id");
            selectNodeIds.add(selectNodeId);
        }
        List<Long> rightTemplateIds = this.getRightTemplateIds();
        for (int i = 0; i < selectNodeIds.size(); ++i) {
            TreeNode treeNode;
            String selectNodeId = (String)selectNodeIds.get(i);
            Long templateId = Long.valueOf(selectNodeId);
            if (rightTemplateIds.contains(templateId) || (treeNode = cacheTree.getTreeNode(selectNodeId, 10)) == null) continue;
            Map dataMap = (Map)treeNode.getData();
            int row = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("tempid", (Object)templateId, row);
            this.getModel().setValue("tempnumber", dataMap.get("number"), row);
            this.getModel().setValue("tempname", dataMap.get("name"), row);
        }
        treeView.uncheckNodes(selectNodeIds);
        Label label = (Label)this.getControl("label_temp_focus");
        label.setText("0");
    }

    private void removeTemplate() {
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entrygrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u8bb0\u5f55\u3002", (String)"ApprovalTypeRelationPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows("entryentity", selectRows);
    }

    private List<Long> getRightTemplateIds() {
        DynamicObjectCollection rightColl = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> templateIds = new ArrayList<Long>(rightColl.size());
        for (DynamicObject rightData : rightColl) {
            Long templateId = rightData.getLong("tempid");
            templateIds.add(templateId);
        }
        return templateIds;
    }

    private TreeNode getCacheTree() {
        String templateTreeRootNodeStr = this.getPageCache().get("templatetree");
        return F7TreeUtils.getCacheTreeNodeData((String)templateTreeRootNodeStr);
    }

    private void showRuleData(Long modelId) {
        DynamicObjectCollection tempColl;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        DynamicObject rptSchemaRuleObj = QueryServiceHelper.queryOne((String)"bgm_rptschema_rule", (String)"id", (QFilter[])qFilter.toArray());
        if (rptSchemaRuleObj == null) {
            return;
        }
        Long pkId = rptSchemaRuleObj.getLong("id");
        DynamicObject rptSchemaRule = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bgm_rptschema_rule");
        if (rptSchemaRule == null) {
            return;
        }
        String assignSchemaJson = rptSchemaRule.getString("schemataskjson");
        this.getModel().setValue("assignschemajson", (Object)assignSchemaJson);
        if (StringUtils.isNotEmpty((String)assignSchemaJson)) {
            List assignSchemaTaskList = SerializationUtils.fromJsonStringToList((String)assignSchemaJson, AssignSchemaTaskDto.class);
            StringBuilder schemaNameStr = new StringBuilder();
            for (AssignSchemaTaskDto assignSchemaTask : assignSchemaTaskList) {
                schemaNameStr.append(assignSchemaTask.getAssignName()).append(";");
            }
            if (schemaNameStr.length() > 0) {
                schemaNameStr.setLength(schemaNameStr.length() - 1);
            }
            this.getModel().setValue("assignschema", (Object)schemaNameStr.toString());
        }
        if (CollectionUtils.isEmpty((Collection)(tempColl = rptSchemaRule.getDynamicObjectCollection("entryentity_temp")))) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().batchCreateNewEntryRow("entryentity", tempColl.size());
        for (int i = 0; i < tempColl.size(); ++i) {
            DynamicObject template = (DynamicObject)tempColl.get(i);
            this.getModel().setValue("tempid", (Object)template.getLong("template.id"), i);
            this.getModel().setValue("tempnumber", (Object)template.getString("template.number"), i);
            this.getModel().setValue("tempname", (Object)template.getString("template.name"), i);
        }
    }

    private void saveRuleData() {
        DynamicObject rptSchemaRule;
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DynamicObject rptSchemaRuleObj = QueryServiceHelper.queryOne((String)"bgm_rptschema_rule", (String)"id", (QFilter[])qFilter.toArray());
        Long userId = UserUtils.getUserId();
        Date currDate = TimeServiceHelper.now();
        if (rptSchemaRuleObj != null) {
            rptSchemaRule = BusinessDataServiceHelper.loadSingle((Object)rptSchemaRuleObj.getLong("id"), (String)"bgm_rptschema_rule");
        } else {
            rptSchemaRule = BusinessDataServiceHelper.newDynamicObject((String)"bgm_rptschema_rule");
            rptSchemaRule.set("model", (Object)this.getModelId());
            rptSchemaRule.set("createrid", (Object)userId);
            rptSchemaRule.set("createdate", (Object)currDate);
        }
        rptSchemaRule.set("modifier", (Object)userId);
        rptSchemaRule.set("modifydate", (Object)currDate);
        rptSchemaRule.set("schemataskjson", this.getModel().getValue("assignschemajson"));
        DynamicObjectCollection tempColl = rptSchemaRule.getDynamicObjectCollection("entryentity_temp");
        tempColl.clear();
        DynamicObjectCollection rightColl = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject rightData : rightColl) {
            DynamicObject templateObj = tempColl.addNew();
            templateObj.set("template", (Object)rightData.getLong("tempid"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rptSchemaRule});
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    private void selectAllTemp() {
        TreeNode treeNode = this.getCacheTree();
        if (treeNode == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("templatetree");
        treeView.checkNode(treeNode);
        List treeNodes = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)treeNodes)) {
            treeView.checkNodes(treeNodes);
        }
        Map data = (Map)treeNode.getData();
        String leafCounts = (String)data.get("leafCounts");
        Label label = (Label)this.getControl("label_temp_focus");
        label.setText(leafCounts);
    }

    private void clearAllTemp() {
        TreeNode treeNode = this.getCacheTree();
        if (treeNode == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl("templatetree");
        treeView.uncheckNode(treeNode.getId());
        List treeNodes = treeNode.getChildren();
        if (kd.bos.util.CollectionUtils.isNotEmpty((Collection)treeNodes)) {
            List nodeIds = treeNodes.stream().map(child -> child.getId()).collect(Collectors.toList());
            treeView.uncheckNodes(nodeIds);
            Label label = (Label)this.getControl("label_temp_focus");
            label.setText("0");
        }
    }

    private void expandAllTemp() {
        TreeView treeView = (TreeView)this.getControl("templatetree");
        TreeNode treeNode = this.getCacheTree();
        BudgetFormHelper.expandOrShrinkNodes((TreeView)treeView, (TreeNode)treeNode, (boolean)true);
    }

    private void shrinkAllTemp() {
        TreeView treeView = (TreeView)this.getControl("templatetree");
        TreeNode treeNode = this.getCacheTree();
        BudgetFormHelper.expandOrShrinkNodes((TreeView)treeView, (TreeNode)treeNode, (boolean)false);
    }

    private void moveSearchResult(int moveStep) {
        String searchResultCache = this.getPageCache().get("searchResultCache");
        if (StringUtils.isEmpty((String)searchResultCache)) {
            return;
        }
        SearchResult result = (SearchResult)SerializationUtils.deSerializeFromBase64((String)searchResultCache);
        if (result == null) {
            return;
        }
        TreeNode node = result.next(moveStep);
        if (node == null) {
            if (moveStep == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"ApprovalTypeEditPluginNew_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"ApprovalTypeEditPluginNew_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        TreeView treeView = (TreeView)this.getControl("templatetree");
        treeView.focusNode(node);
        this.getPageCache().put("searchResultCache", SerializationUtils.serializeToBase64((Object)result));
    }
}

