/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.budgetform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.adjust.budgetform.BudgetFormHelper;
import kd.epm.eb.common.adjust.budgetform.AssignSchemaTaskDto;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.bgadjust.budgetform.BaseSchemaTaskListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class RuleSchemaTaskListPlugin
extends BaseSchemaTaskListPlugin {
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c111\u6761\u8bb0\u5f55\u3002", (String)"RuleSchemaTaskListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Long> bizModelIds = new HashSet<Long>(selectedRows.size());
            HashSet<Long> ids = new HashSet<Long>(selectedRows.size());
            ArrayList<AssignSchemaTaskDto> assignSchemaTaskList = new ArrayList<AssignSchemaTaskDto>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                ids.add(IDUtils.toLong((Object)selectedRow.getPrimaryKeyValue()));
            }
            Map schemaTaskMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"bgm_adjust_schematask");
            for (DynamicObject schemaTaskObj : schemaTaskMap.values()) {
                Long sourceId = schemaTaskObj.getLong("sourceid");
                Long bizModelId = schemaTaskObj.getLong("bizmodel.id");
                if (!bizModelIds.add(bizModelId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u4e1a\u52a1\u6a21\u578b\u53ea\u80fd\u9009\u62e91\u6761\u4e0b\u8fbe\u65b9\u6848/\u4efb\u52a1\u3002", (String)"RuleSchemaTaskListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                Long orgViewId = schemaTaskObj.getLong("orgviewid");
                String schemaType = schemaTaskObj.getString("sourcetype");
                String assignName = schemaTaskObj.getString("assignname");
                Long periodId = schemaTaskObj.getLong("budgetperiod.id");
                Long dataTypeId = schemaTaskObj.getLong("datatype.id");
                Long versionId = schemaTaskObj.getLong("version.id");
                AssignSchemaTaskDto assignSchemaTaskDto = new AssignSchemaTaskDto();
                assignSchemaTaskDto.setId(sourceId);
                assignSchemaTaskDto.setOrgViewId(orgViewId);
                assignSchemaTaskDto.setBizModelId(bizModelId);
                assignSchemaTaskDto.setAssignName(assignName);
                assignSchemaTaskDto.setType(schemaType);
                assignSchemaTaskDto.setPeriodId(periodId);
                assignSchemaTaskDto.setDataTypeId(dataTypeId);
                assignSchemaTaskDto.setVersionId(versionId);
                assignSchemaTaskList.add(assignSchemaTaskDto);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(assignSchemaTaskList));
            this.getView().close();
        }
    }

    @Override
    protected void selectEntryRows() {
        String selectedSourceIdStr = (String)this.getView().getFormShowParameter().getCustomParam("selectSourceIds");
        if (StringUtils.isEmpty((String)selectedSourceIdStr)) {
            return;
        }
        Set uIds = (Set)SerializationUtils.deSerializeFromBase64((String)selectedSourceIdStr);
        if (CollectionUtils.isEmpty((Collection)uIds)) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection allRow = billList.getCurrentListAllRowCollection();
        LinkedHashMap<Long, Integer> idRowMap = new LinkedHashMap<Long, Integer>(allRow.size());
        for (int i = 0; i < allRow.size(); ++i) {
            ListSelectedRow row = allRow.get(i);
            idRowMap.put(IDUtils.toLong((Object)row.getPrimaryKeyValue()), i);
        }
        ArrayList rowNums = new ArrayList(allRow.size());
        Map schemaTaskMap = BusinessDataServiceHelper.loadFromCache((Object[])idRowMap.keySet().toArray(), (String)"bgm_adjust_schematask");
        for (DynamicObject schemaTaskObj : schemaTaskMap.values()) {
            Long versionId;
            Long dataTypeId;
            Long periodId;
            Long id = schemaTaskObj.getLong("id");
            Long sourceId = schemaTaskObj.getLong("sourceid");
            String uId = BudgetFormHelper.getUniqueId((Long)sourceId, (Long)(periodId = Long.valueOf(schemaTaskObj.getLong("budgetperiod.id"))), (Long)(dataTypeId = Long.valueOf(schemaTaskObj.getLong("datatype.id"))), (Long)(versionId = Long.valueOf(schemaTaskObj.getLong("version.id"))));
            if (!uIds.contains(uId)) continue;
            rowNums.add(idRowMap.get(id));
        }
        if (rowNums.size() > 0) {
            int[] rowIndexs = new int[rowNums.size()];
            for (int i = 0; i < rowNums.size(); ++i) {
                rowIndexs[i] = (Integer)rowNums.get(i);
            }
            billList.selectRows(rowIndexs, rowIndexs[0]);
        }
    }
}

