/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.impexp;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.DecimalCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.formplugin.bgadjust.utils.AdjustUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class AdjustImpExpUtil {
    public static final String BILL_TYPE_ADJUST = "1";
    public static final String BILL_TYPE_ADJPST = "2";
    private static final int maxInfoSize = 1000;

    public static List<String> getMustInputColumns() {
        ArrayList<String> mustInputColumns = new ArrayList<String>(4);
        mustInputColumns.add("entity.number");
        mustInputColumns.add("account.number");
        mustInputColumns.add("period.number");
        mustInputColumns.add("adjustdata");
        mustInputColumns.add("customdim1.number");
        mustInputColumns.add("customdim2.number");
        mustInputColumns.add("customdim3.number");
        mustInputColumns.add("customdim4.number");
        mustInputColumns.add("customdim5.number");
        mustInputColumns.add("customdim6.number");
        return mustInputColumns;
    }

    public static List<String> getBgmMustInputColumns() {
        ArrayList<String> mustInputColumns = new ArrayList<String>(5);
        mustInputColumns.add("entity.number");
        mustInputColumns.add("account.number");
        mustInputColumns.add("metric.number");
        mustInputColumns.add("budgetperiod.number");
        mustInputColumns.add("adjustdata");
        return mustInputColumns;
    }

    public static List<String> getHeadHiddenColumns() {
        ArrayList<String> headHiddenColumns = new ArrayList<String>(16);
        headHiddenColumns.add("applier");
        headHiddenColumns.add("company");
        headHiddenColumns.add("department");
        headHiddenColumns.add("position");
        headHiddenColumns.add("billno");
        headHiddenColumns.add("billstatus");
        headHiddenColumns.add("billtype");
        headHiddenColumns.add("applydate");
        headHiddenColumns.add("model");
        headHiddenColumns.add("bizmodel");
        headHiddenColumns.add("budgetperiods");
        headHiddenColumns.add("multperiod");
        headHiddenColumns.add("handler");
        headHiddenColumns.add("dealdate");
        headHiddenColumns.add("bgmcontroldim");
        headHiddenColumns.add("adjustrule");
        headHiddenColumns.add("dataset");
        headHiddenColumns.add("datatype");
        headHiddenColumns.add("changetype");
        headHiddenColumns.add("budgetbalance");
        headHiddenColumns.add("limitbalance");
        headHiddenColumns.add("limitbalanceshow");
        headHiddenColumns.add("beyond");
        return headHiddenColumns;
    }

    public static List<String> getDetailHiddenColumns() {
        ArrayList<String> detailHiddenColumns = new ArrayList<String>(16);
        detailHiddenColumns.add("metric");
        detailHiddenColumns.add("ordersign");
        detailHiddenColumns.add("adjexplain");
        detailHiddenColumns.add("budgetdata");
        detailHiddenColumns.add("finaldata");
        detailHiddenColumns.add("submitvalue");
        detailHiddenColumns.add("budgetperiod");
        detailHiddenColumns.add("budgetbalance");
        detailHiddenColumns.add("limitbalance");
        detailHiddenColumns.add("limitbalanceshow");
        detailHiddenColumns.add("beyond");
        detailHiddenColumns.add("defaultbailorg");
        return detailHiddenColumns;
    }

    public static List<String> getBgmHeadHiddenColumns() {
        ArrayList<String> headHiddenColumns = new ArrayList<String>(16);
        headHiddenColumns.add("applier");
        headHiddenColumns.add("company");
        headHiddenColumns.add("department");
        headHiddenColumns.add("position");
        headHiddenColumns.add("billno");
        headHiddenColumns.add("billstatus");
        headHiddenColumns.add("billtype");
        headHiddenColumns.add("applydate");
        headHiddenColumns.add("model");
        headHiddenColumns.add("budgetperiods");
        headHiddenColumns.add("year");
        headHiddenColumns.add("multperiod");
        headHiddenColumns.add("handler");
        headHiddenColumns.add("dealdate");
        headHiddenColumns.add("bgmcontroldim");
        headHiddenColumns.add("adjustrule");
        headHiddenColumns.add("dataset");
        return headHiddenColumns;
    }

    public static List<String> getBgmDetailHiddenColumns() {
        ArrayList<String> detailHiddenColumns = new ArrayList<String>(16);
        detailHiddenColumns.add("ordersign");
        detailHiddenColumns.add("adjexplain");
        detailHiddenColumns.add("budgetdata");
        detailHiddenColumns.add("submitvalue");
        detailHiddenColumns.add("period");
        detailHiddenColumns.add("budgetbalance");
        detailHiddenColumns.add("limitbalance");
        detailHiddenColumns.add("limitbalanceshow");
        detailHiddenColumns.add("beyond");
        detailHiddenColumns.add("defaultbailorg");
        return detailHiddenColumns;
    }

    public static Map<String, Dimension> getCustomDimsByModel(Long modelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList();
        HashMap<String, Dimension> customDimMap = new HashMap<String, Dimension>(dimensionList.size());
        int seq = 1;
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimMap.put("customdim" + seq++, dimension);
        }
        return customDimMap;
    }

    public static Map<String, String> getUserInfo(Long userid) {
        String positionId = "0";
        String departmentId = "0";
        String companyId = "0";
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userid, (String)"bos_user");
        DynamicObjectCollection userEntity = user.getDynamicObjectCollection("entryentity");
        if (userEntity != null && userEntity.size() > 0) {
            Object id;
            Map companyMap;
            DynamicObject userObj = (DynamicObject)userEntity.get(0);
            positionId = userObj.getString("position");
            DynamicObject dptObj = userObj.getDynamicObject("dpt");
            if (dptObj != null) {
                departmentId = dptObj.getString("id");
            }
            if (StringUtils.isNotEmpty((String)departmentId) && (companyMap = OrgUnitServiceHelper.getCompanyfromOrg((Long)Long.valueOf(departmentId))) != null && (id = companyMap.get("id")) != null) {
                companyId = String.valueOf(id);
            }
        }
        HashMap<String, String> userMap = new HashMap<String, String>(3);
        userMap.put("position", positionId);
        userMap.put("department", departmentId);
        userMap.put("company", companyId);
        return userMap;
    }

    public static void saveOperateLog(Collection<DynamicObject> savedBillobjs, StringBuilder logInfo) {
        String billNumbers;
        if (savedBillobjs.size() == 0) {
            return;
        }
        logInfo.append(";");
        ArrayList billList = Lists.newArrayList(savedBillobjs);
        if (billList.size() == 1) {
            billNumbers = ((DynamicObject)billList.get(0)).getString("billno");
        } else {
            String firstBillNo = ((DynamicObject)billList.get(0)).getString("billno");
            String lastBillNo = ((DynamicObject)billList.get(billList.size() - 1)).getString("billno");
            billNumbers = ResManager.loadResFormat((String)"%1\u5230%2", (String)"OverallBudgetAdjustImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{firstBillNo, lastBillNo});
        }
        String desc = ResManager.loadResFormat((String)"\u751f\u6210\u5355\u636e\u7f16\u53f7%1\u3002", (String)"OverallBudgetAdjustImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{billNumbers});
        logInfo.append(desc);
    }

    public static void setBaseDataQuery(List<QFilter> qFilterList, String baseDataKey, Long modelId) {
        SysDimensionEnum enumByMemberTreemodel = SysDimensionEnum.getEnumByMemberTreemodel((String)baseDataKey);
        if (enumByMemberTreemodel != null) {
            qFilterList.add(new QFilter("model", "=", (Object)modelId));
            qFilterList.add(new QFilter("level", ">", (Object)1));
        } else if ("eb_businessmodel".equals(baseDataKey) || "eb_dataset".equals(baseDataKey)) {
            qFilterList.add(new QFilter("model", "=", (Object)modelId));
        }
    }

    public static Map<String, Dimension> getCustomDimMap(Long modelId, Long bizModelId) {
        if (AdjustUtil.isBGModel(modelId) || AdjustUtil.isBGMModel(modelId)) {
            return AdjustHelper.getCustomDimsByBizModel((Long)modelId, (Long)bizModelId);
        }
        return AdjustImpExpUtil.getCustomDimsByModel(modelId);
    }

    public static void setHiddenEntryData(DynamicObjectCollection adjdetailentity, Long modelId, Map<String, Dimension> customDimMap, String periodKey, List<String> numberList) {
        List<Object> periodNums = new ArrayList(adjdetailentity.size());
        LinkedHashMap billDetailMap = new LinkedHashMap(adjdetailentity.size());
        Map rowCustomDimMap = customDimMap;
        for (DynamicObject billDetail : adjdetailentity) {
            String periodNum;
            ArrayList<DynamicObject> detailBillList;
            StringBuilder rowCustomDims = new StringBuilder();
            String entityNumber = billDetail.getString("entity.number");
            String accountNumber = billDetail.getString("account.number");
            rowCustomDims.append(entityNumber).append("!!").append(accountNumber).append("!!");
            if (AdjustUtil.isBGModel(modelId) || AdjustUtil.isBGMModel(modelId)) {
                String metricNumber = billDetail.getString("metric.number");
                rowCustomDims.append(metricNumber);
                Long l = billDetail.getLong("account.id");
                Long datasetId = AdjustHelper.getDatasetId((Long)l);
                rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)modelId, (Long)datasetId, (Map)customDimMap);
            }
            for (Map.Entry entry : rowCustomDimMap.entrySet()) {
                String customDimKey = (String)entry.getKey();
                DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
                if (customDimObj == null) continue;
                rowCustomDims.append("!!").append(customDimObj.getString("number"));
            }
            if (billDetailMap.containsKey(rowCustomDims.toString())) {
                detailBillList = (ArrayList<DynamicObject>)billDetailMap.get(rowCustomDims.toString());
                detailBillList.add(billDetail);
            } else {
                detailBillList = new ArrayList<DynamicObject>(adjdetailentity.size());
                detailBillList.add(billDetail);
                billDetailMap.put(rowCustomDims.toString(), detailBillList);
            }
            if (periodNums.contains(periodNum = billDetail.getString(periodKey + ".number"))) continue;
            periodNums.add(periodNum);
        }
        if (CollectionUtils.isNotEmpty(numberList)) {
            periodNums = numberList;
        }
        int i = 0;
        for (Map.Entry billEntry : billDetailMap.entrySet()) {
            List billDetailList = (List)billEntry.getValue();
            for (int j = 0; j < billDetailList.size(); ++j) {
                if (j != 0 && j % periodNums.size() == 0) {
                    ++i;
                }
                DynamicObject billDetail = (DynamicObject)billDetailList.get(j);
                String string = billDetail.getString(periodKey + ".number");
                int index = periodNums.indexOf(string);
                billDetail.set("ordersign", (Object)(i + ":" + (index + 1)));
                billDetail.set("finaldata", (Object)billDetail.getString("adjustdata"));
            }
            ++i;
        }
    }

    public static String getRowCustomDim(DynamicObject billDetail, Long modelId, Map<String, Dimension> customDimMap) {
        StringBuilder rowCustomDims = new StringBuilder();
        String periodKey = "period";
        if (AdjustUtil.isBGModel(modelId) || AdjustUtil.isBGMModel(modelId)) {
            periodKey = "budgetperiod";
        }
        String periodNumber = billDetail.getString(periodKey + ".number");
        String entityNumber = billDetail.getString("entity.number");
        String accountNumber = billDetail.getString("account.number");
        String metricNumber = billDetail.getString("metric.number");
        rowCustomDims.append(periodNumber).append("!!").append(entityNumber).append("!!").append(accountNumber).append("!!").append(metricNumber);
        Long accountId = billDetail.getLong("account.id");
        Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)modelId, (Long)datasetId, customDimMap);
        for (Map.Entry customDimEntry : rowCustomDimMap.entrySet()) {
            String customDimKey = (String)customDimEntry.getKey();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            if (customDimObj == null) continue;
            rowCustomDims.append("!!").append(customDimObj.getString("number"));
        }
        return rowCustomDims.toString();
    }

    public static Map<Object, DynamicObject> getCacheDynamicObject(DynamicObjectCollection adjdetail, List<String> entryEntityKeys) {
        return AdjustHelper.getCacheDynamicObject((DynamicObjectCollection)adjdetail, entryEntityKeys);
    }

    public static void writeLog2Sheet(Sheet sheet, Map<Integer, Set<String>> errorRow, boolean hasError) {
        if (!errorRow.isEmpty()) {
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum < 0 || sheet.getRow(0) == null) {
                sheet.createRow(0);
            }
            CellStyle redStyle = POIUtils.getErrorStyle((Workbook)sheet.getWorkbook());
            redStyle.setWrapText(false);
            if (!hasError) {
                WriteExcelUtil.moveColumns((Sheet)sheet, (int)0, (int)1);
            }
            sheet.setColumnWidth(0, 8000);
            Cell firstCell = hasError ? sheet.getRow(0).getCell(0) : sheet.getRow(0).createCell(0);
            firstCell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ImportLogger_1", (String)"epm-eb-business", (Object[])new Object[0]));
            int endRowIndex = sheet.getLastRowNum();
            StringBuilder sb = new StringBuilder();
            errorRow.forEach((rowIndex, infos) -> {
                if (rowIndex >= 0 && rowIndex <= endRowIndex) {
                    Cell cell;
                    infos.forEach(infoStr -> sb.append((String)infoStr).append('\n'));
                    String errorInfo = sb.length() > 1000 ? sb.substring(0, 1000) : sb.toString();
                    Row row = sheet.getRow(rowIndex.intValue());
                    if (row != null && (cell = row.createCell(0)) != null) {
                        cell.setCellStyle(redStyle);
                        cell.setCellValue(errorInfo);
                    }
                    sb.setLength(0);
                }
            });
        }
    }

    public static String getCustomDimNumber(String colKey, Map<String, Dimension> customDimMap) {
        String customDimNumber = "";
        for (Map.Entry<String, Dimension> customDimEntry : customDimMap.entrySet()) {
            String customDimKey = customDimEntry.getKey() + ".";
            Dimension customDim = customDimEntry.getValue();
            if (!colKey.startsWith(customDimKey)) continue;
            customDimNumber = customDim.getNumber();
            break;
        }
        return customDimNumber;
    }

    public static void setBGMAndBGQueryFilter(List<QFilter> qFilterList, String baseDataKey, String colKey, Long modelId, Long bizModelId) {
        if ("epm_datatypemembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("longnumber", "like", (Object)"DataType!Budget%"));
        } else if ("epm_versionmembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("isactual", "!=", (Object)BILL_TYPE_ADJUST));
        } else if ("epm_changetypemembertree".equals(baseDataKey)) {
            HashSet<String> noIn = new HashSet<String>();
            noIn.add("Occupation");
            noIn.add("Execute");
            noIn.add("ActualChanges");
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Map viewIds = modelCacheHelper.getViewsByBusModel(bizModelId);
            Member actualChangesMember = modelCacheHelper.getMember(SysDimensionEnum.ChangeType.getNumber(), (Long)viewIds.get(SysDimensionEnum.ChangeType.getNumber()), "ActualChanges");
            if (ModelServiceHelper.isBGMDModel((Long)modelId) && actualChangesMember != null) {
                List actualChangesLeafMemNumbers = actualChangesMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList());
                noIn.addAll(actualChangesLeafMemNumbers);
            }
            qFilterList.add(new QFilter("number", "not in", noIn));
        } else if ("epm_entitymembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("number", "!=", (Object)"RatePreset"));
        } else if ("epm_userdefinedmembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("dimension.number", "=", (Object)AdjustImpExpUtil.getCustomDimNumber(colKey, AdjustImpExpUtil.getCustomDimMap(modelId, bizModelId))));
        } else if ("epm_metricmembertree".equals(baseDataKey)) {
            HashSet<String> metricMemNums = new HashSet<String>(3);
            metricMemNums.add(MetricDataTypeEnum.CURRENCY.getIndex());
            metricMemNums.add(MetricDataTypeEnum.NONMONETARY.getIndex());
            metricMemNums.add(MetricDataTypeEnum.RATE.getIndex());
            qFilterList.add(new QFilter("datatype", "in", metricMemNums));
        }
    }

    public static Member getMember(String dimensionNumber, Long viewId, Long memberId, IModelCacheHelper modelCacheHelper) {
        return modelCacheHelper.getMember(dimensionNumber, viewId, memberId);
    }

    public static void setEBQueryFilter(List<QFilter> qFilterList, String baseDataKey, String colKey, Long modelId) {
        if ("epm_versionmembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("isactual", "!=", (Object)BILL_TYPE_ADJUST));
        } else if ("epm_entitymembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("number", "!=", (Object)"RatePreset"));
        } else if ("epm_userdefinedmembertree".equals(baseDataKey)) {
            qFilterList.add(new QFilter("dimension.number", "=", (Object)AdjustImpExpUtil.getCustomDimNumber(colKey, AdjustImpExpUtil.getCustomDimsByModel(modelId))));
        }
    }

    public static void scaleBigDecimal(BillColGroup entryGroup, DynamicObject entryRow, Row row) {
        for (ExcelCol col : entryGroup.getBaseCols().values()) {
            Object val = col.getVal(entryRow);
            if (!(col instanceof DecimalCol)) continue;
            BigDecimal data = new BigDecimal((String)val);
            Cell cell = row.getCell(col.getColIndex(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            cell.setCellValue(data.setScale(2, RoundingMode.HALF_UP).toString());
        }
    }

    public static Map<String, List<Integer>> getRowCustomDimMap(Map<Integer, DynamicObject> detailObjMap, Long modelId, Map<String, Dimension> customDimMap) {
        HashMap<String, List<Integer>> fileCustomDimMap = new HashMap<String, List<Integer>>(detailObjMap.size());
        for (Map.Entry<Integer, DynamicObject> entry : detailObjMap.entrySet()) {
            Integer key = entry.getKey();
            DynamicObject value = entry.getValue();
            String rowCustomDim = AdjustImpExpUtil.getRowCustomDim(value, modelId, customDimMap);
            ArrayList<Integer> integers = (ArrayList<Integer>)fileCustomDimMap.get(rowCustomDim);
            if (integers == null) {
                integers = new ArrayList<Integer>(10);
            }
            integers.add(key);
            fileCustomDimMap.put(rowCustomDim, integers);
        }
        return fileCustomDimMap;
    }

    public static void downErrorFile(IFormView view, Map<String, Object> returnData, Map<Integer, Set<String>> errorRow, boolean hasError) {
        Object sheets = returnData.get("sheets");
        if (sheets != null) {
            Sheet sheet = ((Workbook)sheets).getSheetAt(0);
            AdjustImpExpUtil.writeLog2Sheet(sheet, errorRow, hasError);
            WriteExcelUtil.downFile((IFormView)view, (Workbook)((Workbook)sheets), (String)ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u5206\u5f55\u5bfc\u5165\u9519\u8bef\u4fe1\u606f.xlsx", (String)"BaseEbAdjustBillEditPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public static Set<String> getAllAccountNumber(String entityNumber, DynamicObjectCollection adjustRuleInfo, Long modelId, Long bizModelId) {
        if (adjustRuleInfo == null) {
            return null;
        }
        HashSet<String> accountSet = new HashSet<String>(16);
        HashSet<String> accountNumberSet = new HashSet<String>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, SysDimensionEnum.Entity.getNumber());
        for (DynamicObject ruleDetail : adjustRuleInfo) {
            HashSet<String> entityMemSet = new HashSet<String>(16);
            String entityMemberStr = ruleDetail.getString("entity");
            if (StringUtils.isNotEmpty((String)entityMemberStr)) {
                String[] dimMemberArr;
                for (String perDimMem : dimMemberArr = entityMemberStr.split(";")) {
                    entityMemSet.addAll(AdjustImpExpUtil.getEntityMemberNumberSet(modelCacheHelper, memberPropCache, perDimMem, viewId));
                }
                if (!StringUtils.isEmpty((String)entityNumber) && !entityMemSet.contains(entityNumber)) continue;
                String dimMemberStr = ruleDetail.getString("account");
                if (StringUtils.isEmpty((String)dimMemberStr)) {
                    DynamicObject dataset = ruleDetail.getDynamicObject("dataset");
                    if (dataset == null) {
                        return null;
                    }
                    Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
                    accountNumberSet.addAll(dimension.getAllMembersByDataSetId(Long.valueOf(dataset.getLong("id"))).stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                    continue;
                }
                String[] accMemberArr = dimMemberStr.split(";");
                accountSet.addAll(Arrays.asList(accMemberArr));
                continue;
            }
            String dimMemberStr = ruleDetail.getString("account");
            if (StringUtils.isEmpty((String)dimMemberStr)) {
                DynamicObject dataset = ruleDetail.getDynamicObject("dataset");
                if (dataset == null) {
                    return null;
                }
                Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Account.getNumber());
                accountNumberSet.addAll(dimension.getAllMembersByDataSetId(Long.valueOf(dataset.getLong("id"))).stream().map(BaseCache::getNumber).collect(Collectors.toList()));
                continue;
            }
            String[] accMemberArr = dimMemberStr.split(";");
            accountSet.addAll(Arrays.asList(accMemberArr));
        }
        for (String dimMem : accountSet) {
            String[] dimMemArr = dimMem.split("!!");
            String memNum = dimMemArr[0];
            int memScope = Integer.parseInt(dimMemArr[1]);
            List memberList = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), memNum, memScope);
            if (memberList == null) continue;
            List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            accountNumberSet.addAll(memberNumbers);
        }
        return accountNumberSet;
    }

    public static Set<String> getEntityMemberNumberSet(IModelCacheHelper modelCacheHelper, MemberPropCache memberPropCache, String dimMem, Long viewId) {
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        HashSet<String> dimMemNums = new HashSet<String>(16);
        String[] dimMemArr = dimMem.split("!!");
        String memNum = dimMemArr[0];
        String type = dimMemArr[1];
        if (RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(SysDimensionEnum.Entity.getNumber(), memNum);
            List membersByPropValues = memberPropCache.getMembersByPropValues(dimension.getId(), viewId, propertyValue.getId());
            if (membersByPropValues != null) {
                Set memberNumbers = membersByPropValues.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                List allMembers = dimension.getAllMembers(viewId);
                Set allMemberNumber = allMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                memberNumbers.retainAll(allMemberNumber);
                dimMemNums.addAll(memberNumbers);
            }
        } else if (RangeF7PropertyCataEnum.Member.getIndex().equals(type)) {
            int memScope = Integer.parseInt(dimMemArr[2]);
            List memberList = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), viewId, memNum, memScope);
            if (memberList != null) {
                List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                dimMemNums.addAll(memberNumbers);
            }
        }
        return dimMemNums;
    }

    public static DynamicInfoCollection getCustomDimsInfoCache(Long modelId, Long bizModelId) {
        DynamicInfoCollection customDimInfo = AdjustHelper.buildCustomDimInfo((Long)modelId, (Long)bizModelId);
        if (!customDimInfo.isEmpty()) {
            List id = customDimInfo.getAllValOfOneProp("id");
            ArrayList dimensions = new ArrayList(id.size());
            id.forEach(e -> dimensions.add(Convert.toLong((Object)e, (Long)0L)));
            QFBuilder qb = new QFBuilder("dimension", "in", dimensions);
            qb.add("membersource", "=", (Object)true);
            qb.add("number", "like", (Object)"%None");
            DynamicObjectCollection defMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension,number", (QFilter[])qb.toArray());
            for (DynamicObject member : defMembers) {
                String memberId = member.getString("id");
                String dimensionId = member.getString("dimension");
                DynamicInfoCollection.InfoObject infoOb = customDimInfo.getInfoByOneProp("id", (Object)dimensionId);
                infoOb.setValueByPropName("defMemberId", (Object)memberId);
                infoOb.setValueByPropName("defMemberNum", (Object)member.getString("number"));
            }
        }
        return customDimInfo;
    }

    public static Set<String> getAllCustomDimNumbers(String key, DynamicObjectCollection ruleDetailList, String accountNumber, IModelCacheHelper modelCacheHelper, Long modelId, Long bizModelId) {
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        HashSet<String> dimMemSet = new HashSet<String>(16);
        HashSet<String> dimMemNums = new HashSet<String>(16);
        DynamicInfoCollection customDimInfo = AdjustImpExpUtil.getCustomDimsInfoCache(modelId, bizModelId);
        String customDimStr = SerializationUtils.serializeToBase64((Object)customDimInfo);
        for (DynamicObject ruleDetail : ruleDetailList) {
            HashSet accountMemSet = new HashSet(16);
            String accountMemberStr = ruleDetail.getString("account");
            if (StringUtils.isNotEmpty((String)accountMemberStr)) {
                String[] dimMemberArr;
                for (String perDimMem : dimMemberArr = accountMemberStr.split(";")) {
                    String[] dimMemArr = perDimMem.split("!!");
                    String memNum = dimMemArr[0];
                    int memScope = Integer.parseInt(dimMemArr[1]);
                    List memberList = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), memNum, memScope);
                    if (memberList == null) continue;
                    List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    accountMemSet.addAll(memberNumbers);
                }
                if (!StringUtils.isNotEmpty((String)accountNumber) || !accountMemSet.contains(accountNumber)) continue;
                String dimMemberStr = ruleDetail.getString(key);
                if (StringUtils.isEmpty((String)dimMemberStr)) {
                    return null;
                }
                String[] accMemberArr = dimMemberStr.split(";");
                dimMemSet.addAll(Arrays.asList(accMemberArr));
                continue;
            }
            String dimMemberStr = ruleDetail.getString(key);
            if (StringUtils.isEmpty((String)dimMemberStr)) {
                return null;
            }
            String[] accMemberArr = dimMemberStr.split(";");
            dimMemSet.addAll(Arrays.asList(accMemberArr));
        }
        for (String dimMem : dimMemSet) {
            String[] dimMemArr = dimMem.split("!!");
            String memNum = dimMemArr[0];
            int memScope = Integer.parseInt(dimMemArr[1]);
            String currentDimNum = AdjustImpExpUtil.getCurrentDimNum("adj" + key, customDimStr);
            if (StringUtils.isEmpty((String)customDimStr)) {
                return dimMemNums;
            }
            List memberList = modelCacheHelper.getMember(currentDimNum, (Long)dimViewMap.get(currentDimNum), memNum, memScope);
            if (memberList == null) continue;
            List memberNumbers = memberList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            dimMemNums.addAll(memberNumbers);
        }
        return dimMemNums;
    }

    public static String getCurrentDimNum(String ctrlKey, String customDimStr) {
        String dimNum = null;
        if (ctrlKey.contains("custom")) {
            DynamicInfoCollection customDims = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
            dimNum = (String)customDims.getValOfOnePropByAnotherProp("number", "controlkey", (Object)ctrlKey);
        }
        return dimNum;
    }

    public static Map<String, Long> getDimBaseViewMap(Long modelId, Long bizModelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        return modelCacheHelper.getViewsByBusModel(bizModelId);
    }
}

