/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.impexp;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import org.apache.poi.ss.usermodel.Workbook;

public class ExpenseBudgetAdjustEntryImportHandler
extends AbstractBillImportHandler {
    private List<String> detailHiddenColumns;
    private List<String> mustInputColumns;
    private Long modelId;
    private String billType;
    private Map<String, Dimension> customDimMap;

    @Override
    public void init(IFormView formview, Map<String, Object> params, String entityKey) {
        super.init(formview, params, entityKey);
        this.modelId = (Long)params.get("model");
        this.billType = (String)params.get("billtype");
        this.detailHiddenColumns = AdjustImpExpUtil.getDetailHiddenColumns();
        this.mustInputColumns = AdjustImpExpUtil.getMustInputColumns();
        if ("1".equals(this.billType)) {
            this.detailHiddenColumns.add("groupnum");
        }
        this.customDimMap = AdjustImpExpUtil.getCustomDimsByModel(this.modelId);
        int maxCustomDimSize = this.customDimMap.size();
        for (int i = maxCustomDimSize + 1; i < 7; ++i) {
            this.detailHiddenColumns.add("customdim" + i);
        }
    }

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        super.addBillColsInfo(colConfig);
        colConfig.setMustInput(true);
        Map detailColumnMap = colConfig.getBaseCols();
        Iterator detailIterator = detailColumnMap.entrySet().iterator();
        block0: while (detailIterator.hasNext()) {
            Map.Entry excelColEntry = detailIterator.next();
            String key = (String)excelColEntry.getKey();
            ExcelCol excelCol = (ExcelCol)excelColEntry.getValue();
            if (this.mustInputColumns.contains(key)) {
                excelCol.setMustInput(true);
            }
            if ("groupnum".equals(key) && !"1".equals(this.billType)) {
                excelCol.setTitle(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7", (String)"OverallBudgetAdjustImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                excelCol.setMustInput(true);
            }
            for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
                String customDimKey = customDimEntry.getKey() + ".";
                Dimension customDim = customDimEntry.getValue();
                if (!key.startsWith(customDimKey)) continue;
                BaseDataCol col = (BaseDataCol)excelCol;
                col.setTitle(customDim.getName());
                col.setCombineQ(false);
            }
            for (String column : this.detailHiddenColumns) {
                if (!key.startsWith(column)) continue;
                detailIterator.remove();
                continue block0;
            }
        }
    }

    @Override
    public void beforeBaseDataQuery(List<QFilter> qFilterList, String baseDataKey, String colKey) {
        super.beforeBaseDataQuery(qFilterList, baseDataKey, colKey);
        AdjustImpExpUtil.setBaseDataQuery(qFilterList, baseDataKey, this.modelId);
        AdjustImpExpUtil.setEBQueryFilter(qFilterList, baseDataKey, colKey, this.modelId);
    }

    @Override
    public void beforeSaveData(Map<Integer, DynamicObject> billObjs, Workbook book, Map<String, Object> args) {
        super.beforeSaveData(billObjs, book, args);
        this.checkBillDetailColumn(billObjs);
    }

    private void checkBillDetailColumn(Map<Integer, DynamicObject> billMap) {
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(billMap.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        for (Map.Entry<Integer, DynamicObject> billEntry : billMap.entrySet()) {
            Integer billSeq = billEntry.getKey();
            DynamicObject billDetail = billEntry.getValue();
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            String intStr = adjustData.toPlainString().split("\\.")[0];
            if (intStr.length() > 13) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u6574\u6570\u90e8\u5206\u4e0d\u5141\u8bb8\u8d85\u8fc713\u4f4d\u3002", (String)"OverallBudgetAdjustImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (adjustData.scale() > 2) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u6700\u591a\u4fdd\u75592\u4f4d\u5c0f\u6570\u3002", (String)"OverallBudgetAdjustImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            String groupNum = billDetail.getString("groupnum");
            if (groupNum.length() > 10) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u6700\u5927\u957f\u5ea6\u4e3a10\u3002", (String)"OverallBudgetAdjustImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.isNotEmpty((String)(groupNum = groupNum.replaceAll("[a-zA-Z0-9]+", "")))) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u53ea\u80fd\u5305\u542b\u6570\u503c\u548c\u5b57\u6bcd\u3002", (String)"BaseEbAdjustBillEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            boolean isEmpty = this.isRowCustomDimEmpty(billDetail, billSeq, errorBillSeqs);
            if (isEmpty) continue;
            this.checkMemberIsLeaf(billDetail, billSeq, errorBillSeqs, modelCacheHelper);
        }
        errorBillSeqs.forEach(billMap::remove);
    }

    private void checkMemberIsLeaf(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqSet, IModelCacheHelper modelCacheHelper) {
        String entityNumber = billDetail.getString("entity.number");
        String accountNumber = billDetail.getString("account.number");
        Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), null, entityNumber);
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
        if (!entityMember.isLeaf()) {
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u7ec4\u7ec7\u7684\u6210\u5458\u7f16\u7801\u201c%1\u201d\u65e0\u6743\u9650\u6216\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber}));
            return;
        }
        if (!accountMember.isLeaf()) {
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u65e0\u79d1\u76ee\u7684\u6210\u5458\u7f16\u7801\u201c%1\u201d\u7684\u6743\u9650\uff0c\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber}));
            return;
        }
        for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
            String customDimKey = customDimEntry.getKey();
            Dimension customDimension = customDimEntry.getValue();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            String customDimNumber = customDimObj.getString("number");
            Member member = modelCacheHelper.getMember(customDimension.getNumber(), null, customDimNumber);
            if (member.isLeaf()) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{customDimension.getName(), customDimNumber}));
            return;
        }
    }

    private boolean isRowCustomDimEmpty(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqSet) {
        boolean isEmpty = false;
        for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
            String customDimKey = customDimEntry.getKey();
            Dimension customDim = customDimEntry.getValue();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            if (customDimObj != null) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OverallBudgetAdjustImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{customDim.getName()}));
            isEmpty = true;
            break;
        }
        return isEmpty;
    }
}

