/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.impexp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillExportHandler;
import org.apache.poi.ss.usermodel.Row;

public class ExpenseBudgetAdjustExportPlugin
extends AbstractBillExportHandler {
    private List<String> headHiddenColumns;
    private List<String> detailHiddenColumns;
    private List<String> mustInputColumns;
    private String billType;
    private Map<String, Dimension> customDimMap;

    @Override
    public void init(IFormView formview, Map<String, Object> params, String entityKey) {
        super.init(formview, params, entityKey);
        Long modelId = (Long)params.get("model");
        this.billType = (String)params.get("billtype");
        this.headHiddenColumns = AdjustImpExpUtil.getHeadHiddenColumns();
        this.detailHiddenColumns = AdjustImpExpUtil.getDetailHiddenColumns();
        this.mustInputColumns = AdjustImpExpUtil.getMustInputColumns();
        if ("1".equals(this.billType)) {
            this.detailHiddenColumns.add("groupnum");
        }
        this.customDimMap = AdjustImpExpUtil.getCustomDimsByModel(modelId);
        int maxCustomDimSize = this.customDimMap.size();
        for (int i = maxCustomDimSize + 1; i < 7; ++i) {
            this.detailHiddenColumns.add("customdim" + i);
        }
    }

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        super.addBillColsInfo(colConfig);
        Map headColumnMap = colConfig.getBaseCols();
        Iterator headIterator = headColumnMap.entrySet().iterator();
        block0: while (headIterator.hasNext()) {
            Map.Entry headEntry = headIterator.next();
            String fieldKey = (String)headEntry.getKey();
            for (String column : this.headHiddenColumns) {
                if (!fieldKey.startsWith(column)) continue;
                headIterator.remove();
                continue block0;
            }
        }
        Map childMap = colConfig.getChildEntrys();
        Iterator childIterator = childMap.entrySet().iterator();
        while (childIterator.hasNext()) {
            Map.Entry childEntry = childIterator.next();
            String fieldKey = (String)childEntry.getKey();
            if ("entryentity".equals(fieldKey)) {
                childIterator.remove();
                continue;
            }
            if (!"adjdetailentity".equals(fieldKey)) continue;
            BillColGroup billColGroup = (BillColGroup)childEntry.getValue();
            Map detailColumnMap = billColGroup.getBaseCols();
            Iterator detailIterator = detailColumnMap.entrySet().iterator();
            block3: while (detailIterator.hasNext()) {
                Map.Entry excelColEntry = detailIterator.next();
                String key = (String)excelColEntry.getKey();
                ExcelCol excelCol = (ExcelCol)excelColEntry.getValue();
                if (this.mustInputColumns.contains(key)) {
                    excelCol.setMustInput(true);
                }
                if ("groupnum".equals(key) && !"1".equals(this.billType)) {
                    excelCol.setTitle(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7", (String)"OverallBudgetAdjustImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    excelCol.setMustInput(true);
                }
                for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
                    String customDimKey = customDimEntry.getKey() + ".";
                    Dimension customDim = customDimEntry.getValue();
                    if (!key.startsWith(customDimKey)) continue;
                    BaseDataCol col = (BaseDataCol)excelCol;
                    col.setTitle(customDim.getName());
                }
                for (String column : this.detailHiddenColumns) {
                    if (!key.startsWith(column)) continue;
                    detailIterator.remove();
                    continue block3;
                }
            }
        }
    }

    @Override
    public void afterFillOneEntryRow(BillColGroup entryGroup, DynamicObject entryRow, Row row) {
        super.afterFillOneEntryRow(entryGroup, entryRow, row);
        AdjustImpExpUtil.scaleBigDecimal(entryGroup, entryRow, row);
        this.fillNewDimCellValue(entryGroup, entryRow, row, this.customDimMap);
    }
}

