/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.impexp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillExportHandler;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.poi.ss.usermodel.Row;

public class OverallBudgetAdjustEntryExportHandler
extends AbstractBillExportHandler {
    private List<String> detailHiddenColumns;
    private List<String> mustInputColumns;
    private Long modelId;
    private String billType;
    private Map<String, Dimension> customDimMap;

    @Override
    public void init(IFormView formview, Map<String, Object> params, String entityKey) {
        super.init(formview, params, entityKey);
        this.modelId = (Long)params.get("model");
        Long bizModelId = (Long)params.get("bizmodel");
        this.billType = (String)params.get("billtype");
        List<String> headHiddenColumns = AdjustImpExpUtil.getBgmHeadHiddenColumns();
        if (ModelUtil.isBGModel((Long)this.modelId)) {
            headHiddenColumns.add("bizmodel");
        }
        this.detailHiddenColumns = AdjustImpExpUtil.getBgmDetailHiddenColumns();
        this.mustInputColumns = AdjustImpExpUtil.getBgmMustInputColumns();
        if ("1".equals(this.billType)) {
            this.detailHiddenColumns.add("groupnum");
        }
        this.customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)this.modelId, (Long)bizModelId);
        int maxCustomDimSize = this.customDimMap.size();
        for (int i = maxCustomDimSize + 1; i < 51; ++i) {
            this.detailHiddenColumns.add("customdim" + i);
        }
    }

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        super.addBillColsInfo(colConfig);
        if (ModelUtil.isBGModel((Long)this.modelId)) {
            if ("1".equals(this.billType)) {
                colConfig.setTitle(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                colConfig.setTitle(ResManager.loadKDString((String)"\u8d39\u7528\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else if ("1".equals(this.billType)) {
            colConfig.setTitle(ResManager.loadKDString((String)"\u5168\u9762\u9884\u7b97\u8c03\u6574\u5355", (String)"AdjustBillListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            colConfig.setTitle(ResManager.loadKDString((String)"\u5168\u9762\u9884\u7b97\u8c03\u5242\u5355", (String)"AdjustBillListPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map detailColumnMap = colConfig.getBaseCols();
        Iterator detailIterator = detailColumnMap.entrySet().iterator();
        block0: while (detailIterator.hasNext()) {
            Map.Entry excelColEntry = detailIterator.next();
            String key = (String)excelColEntry.getKey();
            ExcelCol excelCol = (ExcelCol)excelColEntry.getValue();
            if (this.mustInputColumns.contains(key)) {
                excelCol.setMustInput(true);
            }
            if ("groupnum".equals(key) && !"1".equals(this.billType)) {
                excelCol.setTitle(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7", (String)"OverallBudgetAdjustImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                excelCol.setMustInput(true);
            }
            for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
                String customDimKey = customDimEntry.getKey() + ".";
                Dimension customDim = customDimEntry.getValue();
                if (!key.startsWith(customDimKey)) continue;
                BaseDataCol col = (BaseDataCol)excelCol;
                col.setTitle(customDim.getName());
            }
            for (String column : this.detailHiddenColumns) {
                if (!key.startsWith(column)) continue;
                detailIterator.remove();
                continue block0;
            }
        }
    }

    @Override
    public void afterFillOneEntryRow(BillColGroup entryGroup, DynamicObject entryRow, Row row) {
        super.afterFillOneEntryRow(entryGroup, entryRow, row);
        AdjustImpExpUtil.scaleBigDecimal(entryGroup, entryRow, row);
    }
}

