/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.impexp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;

public class OverallBudgetAdjustEntryImportHandler
extends AbstractBillImportHandler {
    private List<String> detailHiddenColumns;
    private List<String> mustInputColumns;
    private Long modelId;
    private Long bizModelId;
    private String billType;
    private IModelCacheHelper modelCacheHelper;
    private Map<String, Dimension> customDimMap;
    private Map<String, Long> dimBaseViewMap;
    private List<Long> datasetIds;

    @Override
    public void init(IFormView formview, Map<String, Object> params, String entityKey) {
        super.init(formview, params, entityKey);
        this.modelId = (Long)params.get("model");
        this.bizModelId = (Long)params.get("bizModel");
        this.dimBaseViewMap = AdjustImpExpUtil.getDimBaseViewMap(this.modelId, this.bizModelId);
        this.billType = (String)params.get("billtype");
        List<String> headHiddenColumns = AdjustImpExpUtil.getBgmHeadHiddenColumns();
        if (ModelUtil.isBGModel((Long)this.modelId)) {
            headHiddenColumns.add("bizmodel");
        }
        this.detailHiddenColumns = AdjustImpExpUtil.getBgmDetailHiddenColumns();
        this.mustInputColumns = AdjustImpExpUtil.getBgmMustInputColumns();
        if ("1".equals(this.billType)) {
            this.detailHiddenColumns.add("groupnum");
        }
        this.customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)this.modelId, (Long)this.bizModelId);
        int maxCustomDimSize = this.customDimMap.size();
        for (int i = maxCustomDimSize + 1; i < 51; ++i) {
            this.detailHiddenColumns.add("customdim" + i);
        }
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        this.datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.bizModelId);
    }

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        super.addBillColsInfo(colConfig);
        colConfig.setMustInput(true);
        Map detailColumnMap = colConfig.getBaseCols();
        Iterator detailIterator = detailColumnMap.entrySet().iterator();
        block0: while (detailIterator.hasNext()) {
            Map.Entry excelColEntry = detailIterator.next();
            String key = (String)excelColEntry.getKey();
            ExcelCol excelCol = (ExcelCol)excelColEntry.getValue();
            if (this.mustInputColumns.contains(key)) {
                excelCol.setMustInput(true);
            }
            if ("groupnum".equals(key) && !"1".equals(this.billType)) {
                excelCol.setTitle(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7", (String)"OverallBudgetAdjustImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                excelCol.setMustInput(true);
            }
            for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
                String customDimKey = customDimEntry.getKey() + ".";
                Dimension customDim = customDimEntry.getValue();
                if (!key.startsWith(customDimKey)) continue;
                BaseDataCol col = (BaseDataCol)excelCol;
                col.setTitle(customDim.getName());
                col.setCombineQ(false);
            }
            for (String column : this.detailHiddenColumns) {
                if (!key.startsWith(column)) continue;
                detailIterator.remove();
                continue block0;
            }
        }
    }

    @Override
    public void beforeBaseDataQuery(List<QFilter> qFilterList, String baseDataKey, String colKey) {
        super.beforeBaseDataQuery(qFilterList, baseDataKey, colKey);
        AdjustImpExpUtil.setBaseDataQuery(qFilterList, baseDataKey, this.modelId);
        AdjustImpExpUtil.setBGMAndBGQueryFilter(qFilterList, baseDataKey, colKey, this.modelId, this.bizModelId);
    }

    @Override
    public void beforeSaveData(Map<Integer, DynamicObject> billObjs, Workbook book, Map<String, Object> args) {
        super.beforeSaveData(billObjs, book, args);
        this.checkBillDetailColumn(billObjs, args);
    }

    private void checkBillDetailColumn(Map<Integer, DynamicObject> billMap, Map<String, Object> args) {
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(billMap.size());
        for (Map.Entry<Integer, DynamicObject> billEntry : billMap.entrySet()) {
            boolean isLeaf;
            boolean isExist;
            Integer billSeq = billEntry.getKey();
            DynamicObject billDetail = billEntry.getValue();
            BigDecimal adjustData = billDetail.getBigDecimal("adjustdata");
            String intStr = adjustData.toPlainString().split("\\.")[0];
            if (intStr.length() > 13) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u6574\u6570\u90e8\u5206\u4e0d\u5141\u8bb8\u8d85\u8fc713\u4f4d\u3002", (String)"OverallBudgetAdjustImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (adjustData.scale() > 2) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u6700\u591a\u4fdd\u75592\u4f4d\u5c0f\u6570\u3002", (String)"OverallBudgetAdjustImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            String groupNum = billDetail.getString("groupnum");
            if (groupNum.length() > 10) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u6700\u5927\u957f\u5ea6\u4e3a10\u3002", (String)"OverallBudgetAdjustImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.isNotEmpty((String)(groupNum = groupNum.replaceAll("[a-zA-Z0-9]+", "")))) {
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u53ea\u80fd\u5305\u542b\u6570\u503c\u548c\u5b57\u6bcd\u3002", (String)"BaseEbAdjustBillEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                continue;
            }
            boolean isEmpty = this.isRowCustomDimEmpty(billDetail, billSeq, errorBillSeqs);
            if (isEmpty || !(isExist = this.isViewDetailDimExist(billDetail, billSeq, errorBillSeqs)) || !(isLeaf = this.checkMemberIsLeaf(billDetail, billSeq, errorBillSeqs))) continue;
            this.validAdjustRule(billDetail, billSeq, errorBillSeqs, args);
        }
        errorBillSeqs.forEach(billMap::remove);
    }

    private boolean checkMemberIsLeaf(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqSet) {
        String entityNumber = billDetail.getString("entity.number");
        String accountNumber = billDetail.getString("account.number");
        String metricNumber = billDetail.getString("metric.number");
        Member entityMember = this.modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.dimBaseViewMap.get(SysDimensionEnum.Entity.getNumber()), entityNumber);
        Member accountMember = this.modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
        Member metricMember = this.modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
        if (entityMember != null && !entityMember.isLeaf()) {
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u7ec4\u7ec7\u7684\u6210\u5458\u7f16\u7801\u201c%1\u201d\u65e0\u6743\u9650\u6216\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber}));
            return false;
        }
        if (accountMember != null && !accountMember.isLeaf()) {
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u65e0\u79d1\u76ee\u7684\u6210\u5458\u7f16\u7801\u201c%1\u201d\u7684\u6743\u9650\uff0c\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber}));
            return false;
        }
        if (metricMember != null && !metricMember.isLeaf()) {
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u65e0\u5ea6\u91cf\u7684\u6210\u5458\u7f16\u7801\u201c%1\u201d\u7684\u6743\u9650\uff0c\u6216\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{metricNumber}));
            return false;
        }
        Long datasetId = 0L;
        if (accountMember != null) {
            datasetId = accountMember.getDatasetId();
        }
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)this.modelId, (Long)datasetId, this.customDimMap);
        for (Map.Entry customDimEntry : rowCustomDimMap.entrySet()) {
            String customDimKey = (String)customDimEntry.getKey();
            Dimension customDimension = (Dimension)customDimEntry.getValue();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            if (customDimObj == null) continue;
            String customDimNumber = customDimObj.getString("number");
            Member member = this.modelCacheHelper.getMember(customDimension.getNumber(), this.dimBaseViewMap.get(customDimension.getNumber()), customDimNumber);
            if (member.isLeaf()) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{customDimension.getName(), customDimNumber}));
            return false;
        }
        return true;
    }

    private boolean validAdjustRule(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqSet, Map<String, Object> args) {
        Set<String> allAccountNumber;
        Object adjustrule = args.get("adjustrule");
        if (adjustrule == null) {
            return true;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)adjustrule, (String)"bgm_adjustrule");
        DynamicObjectCollection ruleDetailList = dynamicObject.getDynamicObjectCollection("entryentity");
        String entityNumber = billDetail.getString("entity.number");
        String accountNumber = billDetail.getString("account.number");
        HashSet<String> entityMemSet = new HashSet<String>(16);
        boolean validEntity = false;
        if (CollectionUtils.isEmpty((Collection)ruleDetailList)) {
            return true;
        }
        for (DynamicObject ruleDetail : ruleDetailList) {
            String dimMemberStr = ruleDetail.getString("entity");
            if (StringUtils.isEmpty((String)dimMemberStr)) {
                validEntity = true;
                break;
            }
            String[] dimMemberArr = dimMemberStr.split(";");
            entityMemSet.addAll(Arrays.asList(dimMemberArr));
        }
        if (!validEntity) {
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)this.modelId);
            Long viewId = this.modelCacheHelper.getViewByBusModelAndDimNumber(this.bizModelId, SysDimensionEnum.Entity.getNumber());
            HashSet<String> entityNumberSet = new HashSet<String>(16);
            for (String entityStr : entityMemSet) {
                entityNumberSet.addAll(AdjustImpExpUtil.getEntityMemberNumberSet(this.modelCacheHelper, memberPropCache, entityStr, viewId));
            }
            if (!entityNumberSet.contains(entityNumber)) {
                errorBillSeqSet.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u7ec4\u7ec7%1\u4e0d\u5728\u5355\u636e\u6240\u9009\u8c03\u6574\u89c4\u5219\u53ef\u9009\u8303\u56f4\u5185", (String)"OverallBudgetAdjustEntryImportHandler_1", (String)"epm-eb-formplugin", (Object[])new Object[]{entityNumber}));
                return false;
            }
        }
        if ((allAccountNumber = AdjustImpExpUtil.getAllAccountNumber(entityNumber, ruleDetailList, this.modelId, this.bizModelId)) != null && !allAccountNumber.contains(accountNumber)) {
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u79d1\u76ee%1\u4e0d\u5728\u5355\u636e\u6240\u9009\u8c03\u6574\u89c4\u5219\u53ef\u9009\u8303\u56f4\u5185", (String)"OverallBudgetAdjustEntryImportHandler_2", (String)"epm-eb-formplugin", (Object[])new Object[]{accountNumber}));
            return false;
        }
        for (Map.Entry<String, Dimension> entry : this.customDimMap.entrySet()) {
            Set<String> dimNumberSet;
            String key = entry.getKey();
            DynamicObject customObj = billDetail.getDynamicObject(key);
            if (customObj == null || (dimNumberSet = AdjustImpExpUtil.getAllCustomDimNumbers(key, ruleDetailList, accountNumber, this.modelCacheHelper, this.modelId, this.bizModelId)) == null || dimNumberSet.contains(customObj.getString("number"))) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6%1\u4e0d\u5728\u5355\u636e\u6240\u9009\u8c03\u6574\u89c4\u5219\u53ef\u9009\u8303\u56f4\u5185", (String)"OverallBudgetAdjustEntryImportHandler_3", (String)"epm-eb-formplugin", (Object[])new Object[]{key}));
            return false;
        }
        return true;
    }

    private boolean isViewDetailDimExist(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqs) {
        StringBuilder errorInfo;
        boolean isExistViewDim = true;
        Long accountId = billDetail.getLong("account.id");
        Member accountMember = this.modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
        Long datasetId = 0L;
        if (accountMember != null) {
            datasetId = accountMember.getDatasetId();
        }
        if (!this.datasetIds.contains(datasetId)) {
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u79d1\u76ee\u6240\u5728\u6570\u636e\u96c6\u4e0d\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u5185\u3002", (String)"OverallBudgetAdjustImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map dimensionMap = this.modelCacheHelper.getDimensionMap(datasetId);
        Dimension entityDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
        Dimension accountDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
        Dimension metricDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
        if (entityDimension == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Entity.getChineseName()}));
        }
        if (accountDimension == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Account.getChineseName()}));
        }
        if (metricDimension == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Metric.getChineseName()}));
        }
        Long entityViewId = this.dimBaseViewMap.get(SysDimensionEnum.Entity.getNumber());
        Long entityId = billDetail.getLong("entity.id");
        Member entityMember = AdjustImpExpUtil.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId, this.modelCacheHelper);
        if (entityMember == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u201c%1\u201d\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"OverallBudgetAdjustImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Entity.getChineseName()}));
        }
        Long metricId = billDetail.getLong("metric.id");
        Member metricMember = AdjustImpExpUtil.getMember(SysDimensionEnum.Metric.getNumber(), 0L, metricId, this.modelCacheHelper);
        if (metricMember == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u201c%1\u201d\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"OverallBudgetAdjustImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Metric.getChineseName()}));
        }
        ArrayList<String> dimList = new ArrayList<String>(16);
        ArrayList<String> dimViewList = new ArrayList<String>(16);
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)this.modelId, (Long)datasetId, this.customDimMap);
        for (Map.Entry customDimEntry : rowCustomDimMap.entrySet()) {
            Dimension customDimension = (Dimension)customDimEntry.getValue();
            String dimensionNumber = customDimension.getNumber();
            String dimensionName = customDimension.getName();
            Dimension dimension = (Dimension)dimensionMap.get(dimensionNumber);
            if (dimension == null) {
                dimList.add(dimensionName);
                continue;
            }
            Long dimViewId = this.dimBaseViewMap.get(dimensionNumber);
            if (IDUtils.isNull((Long)dimViewId)) {
                dimViewList.add(dimensionName);
                continue;
            }
            String customDimKey = (String)customDimEntry.getKey();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            if (customDimObj == null) continue;
            String customDimNumber = customDimObj.getString("number");
            Member customMember = this.modelCacheHelper.getMember(dimensionNumber, this.dimBaseViewMap.get(dimensionNumber), customDimNumber);
            if (customMember != null) continue;
            dimViewList.add(dimensionName);
        }
        if (dimList.size() > 0) {
            errorInfo = new StringBuilder();
            for (String name : dimList) {
                errorInfo.append(name).append(";");
            }
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(";"));
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u8be5\u79d1\u76ee\u6240\u5c5e\u7684\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.toString()}));
        }
        if (dimViewList.size() > 0) {
            errorInfo = new StringBuilder();
            for (String name : dimViewList) {
                errorInfo.append(name).append(";");
            }
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(";"));
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"OverallBudgetAdjustImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.toString()}));
        }
        return isExistViewDim;
    }

    private boolean isRowCustomDimEmpty(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqSet) {
        boolean isEmpty = false;
        Long accountId = billDetail.getLong("account.id");
        Member accountMember = this.modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountId);
        Long datasetId = 0L;
        if (accountMember != null) {
            datasetId = accountMember.getDatasetId();
        }
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)this.modelId, (Long)datasetId, this.customDimMap);
        for (Map.Entry customDimEntry : rowCustomDimMap.entrySet()) {
            String customDimKey = (String)customDimEntry.getKey();
            Dimension customDim = (Dimension)customDimEntry.getValue();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            if (customDimObj != null) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OverallBudgetAdjustImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{customDim.getName()}));
            isEmpty = true;
            break;
        }
        return isEmpty;
    }
}

