/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.impexp;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.poi.ss.usermodel.Workbook;

public class OverallBudgetAdjustImportPlugin
extends AbstractBillImportHandler {
    private List<String> headHiddenColumns;
    private List<String> detailHiddenColumns;
    private List<String> mustInputColumns;
    private String formKey;
    private Long modelId;
    private Long bizModelId;
    private String billType;
    private IModelCacheHelper modelCacheHelper;
    private Map<String, Dimension> customDimMap;
    private Map<String, Long> dimBaseViewMap;

    @Override
    public void init(IFormView formview, Map<String, Object> params, String entityKey) {
        super.init(formview, params, entityKey);
        this.formKey = entityKey;
        this.modelId = (Long)params.get("model");
        this.bizModelId = (Long)params.get("bizmodel");
        this.dimBaseViewMap = AdjustImpExpUtil.getDimBaseViewMap(this.modelId, this.bizModelId);
        this.billType = (String)params.get("billtype");
        this.headHiddenColumns = AdjustImpExpUtil.getBgmHeadHiddenColumns();
        if (ModelUtil.isBGModel((Long)this.modelId)) {
            this.headHiddenColumns.add("bizmodel");
        }
        this.detailHiddenColumns = AdjustImpExpUtil.getBgmDetailHiddenColumns();
        this.mustInputColumns = AdjustImpExpUtil.getBgmMustInputColumns();
        if ("1".equals(this.billType)) {
            this.detailHiddenColumns.add("groupnum");
        }
        this.customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)this.modelId, (Long)this.bizModelId);
        int maxCustomDimSize = this.customDimMap.size();
        for (int i = maxCustomDimSize + 1; i < 51; ++i) {
            this.detailHiddenColumns.add("customdim" + i);
        }
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
    }

    @Override
    public void addBillColsInfo(BillColGroup colConfig) {
        super.addBillColsInfo(colConfig);
        Map headColumnMap = colConfig.getBaseCols();
        Iterator headIterator = headColumnMap.entrySet().iterator();
        block0: while (headIterator.hasNext()) {
            Map.Entry headEntry = headIterator.next();
            String fieldKey = (String)headEntry.getKey();
            for (String column : this.headHiddenColumns) {
                if (!fieldKey.startsWith(column)) continue;
                headIterator.remove();
                continue block0;
            }
        }
        Map childMap = colConfig.getChildEntrys();
        Iterator childIterator = childMap.entrySet().iterator();
        while (childIterator.hasNext()) {
            Map.Entry childEntry = childIterator.next();
            String fieldKey = (String)childEntry.getKey();
            if ("entryentity".equals(fieldKey)) {
                childIterator.remove();
                continue;
            }
            if (!"adjdetailentity".equals(fieldKey)) continue;
            BillColGroup billColGroup = (BillColGroup)childEntry.getValue();
            billColGroup.setMustInput(true);
            Map detailColumnMap = billColGroup.getBaseCols();
            Iterator detailIterator = detailColumnMap.entrySet().iterator();
            block3: while (detailIterator.hasNext()) {
                Map.Entry excelColEntry = detailIterator.next();
                String key = (String)excelColEntry.getKey();
                ExcelCol excelCol = (ExcelCol)excelColEntry.getValue();
                if (this.mustInputColumns.contains(key)) {
                    excelCol.setMustInput(true);
                }
                if ("groupnum".equals(key) && !"1".equals(this.billType)) {
                    excelCol.setTitle(ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7", (String)"OverallBudgetAdjustImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    excelCol.setMustInput(true);
                }
                for (Map.Entry<String, Dimension> customDimEntry : this.customDimMap.entrySet()) {
                    String customDimKey = customDimEntry.getKey() + ".";
                    Dimension customDim = customDimEntry.getValue();
                    if (!key.startsWith(customDimKey)) continue;
                    BaseDataCol col = (BaseDataCol)excelCol;
                    col.setTitle(customDim.getName());
                    col.setCombineQ(false);
                }
                for (String column : this.detailHiddenColumns) {
                    if (!key.startsWith(column)) continue;
                    detailIterator.remove();
                    continue block3;
                }
            }
        }
    }

    @Override
    public void beforeBaseDataQuery(List<QFilter> qFilterList, String baseDataKey, String colKey) {
        super.beforeBaseDataQuery(qFilterList, baseDataKey, colKey);
        AdjustImpExpUtil.setBaseDataQuery(qFilterList, baseDataKey, this.modelId);
        AdjustImpExpUtil.setBGMAndBGQueryFilter(qFilterList, baseDataKey, colKey, this.modelId, this.bizModelId);
    }

    @Override
    public void beforeSaveData(Map<Integer, DynamicObject> billObjs, Workbook book, Map<String, Object> args) {
        super.beforeSaveData(billObjs, book, args);
        this.checkBillHeaderColumn(billObjs);
        this.checkBillDetailColumn(billObjs);
        this.checkMemberPerm(billObjs);
    }

    private void checkMemberPerm(Map<Integer, DynamicObject> billObjs) {
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(billObjs.size());
        for (Map.Entry<Integer, DynamicObject> billEntry : billObjs.entrySet()) {
            Integer billSeq = billEntry.getKey();
            DynamicObject billObj = billEntry.getValue();
            boolean hasPerm = this.hasPermForDimMember(billObj, billSeq, errorBillSeqs);
            if (hasPerm) continue;
            break;
        }
        errorBillSeqs.forEach(billObjs::remove);
    }

    @Override
    public void addOpLog(String entityKey, int sussSize, int errorSize, Collection<DynamicObject> savedBillobjs, StringBuilder logInfo) {
        super.addOpLog(entityKey, sussSize, errorSize, savedBillobjs, logInfo);
        AdjustImpExpUtil.saveOperateLog(savedBillobjs, logInfo);
    }

    @Override
    public void afterReadOneBill(int billSeq, DynamicObject billObj) {
        super.afterReadOneBill(billSeq, billObj);
        this.setBillHeadHiddenColumnValue(billObj);
        this.setBillDetailHiddenColumnValue(billObj);
    }

    private void setBillHeadHiddenColumnValue(DynamicObject billObj) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        String billNumber = service.getNumber(this.formKey, billObj, null);
        Long userId = UserUtils.getUserId();
        Map<String, String> userInfo = AdjustImpExpUtil.getUserInfo(userId);
        billObj.set("billno", (Object)billNumber);
        billObj.set("applier", (Object)userId);
        billObj.set("company", (Object)userInfo.get("company"));
        billObj.set("department", (Object)userInfo.get("department"));
        billObj.set("position", (Object)userInfo.get("position"));
        billObj.set("billstatus", (Object)"A");
        billObj.set("billtype", (Object)this.billType);
        billObj.set("applydate", (Object)new Date());
        billObj.set("model", (Object)this.modelId);
        if (ModelUtil.isBGModel((Long)this.modelId)) {
            billObj.set("bizmodel", (Object)this.bizModelId);
        }
    }

    private void setBillDetailHiddenColumnValue(DynamicObject billObj) {
        DynamicObjectCollection billDetails = billObj.getDynamicObjectCollection("adjdetailentity");
        AdjustImpExpUtil.setHiddenEntryData(billDetails, this.modelId, this.customDimMap, "budgetperiod", null);
    }

    private void checkBillHeaderColumn(Map<Integer, DynamicObject> billMap) {
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(billMap.size());
        for (Map.Entry<Integer, DynamicObject> billEntry : billMap.entrySet()) {
            Integer billSeq = billEntry.getKey();
            DynamicObject billObj = billEntry.getValue();
            Long curBizModelId = billObj.getLong("bizmodel.id");
            if (this.bizModelId.equals(curBizModelId) || ModelUtil.isBGModel((Long)this.modelId)) continue;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billObj, ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u4e1a\u52a1\u6a21\u578b\u4e0e\u5f53\u524d\u9009\u4e2d\u7684\u4e1a\u52a1\u6a21\u578b\u4e0d\u7b26\u3002", (String)"OverallBudgetAdjustImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            break;
        }
        errorBillSeqs.forEach(billMap::remove);
    }

    private void checkBillDetailColumn(Map<Integer, DynamicObject> billMap) {
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(billMap.size());
        for (Map.Entry<Integer, DynamicObject> billEntry : billMap.entrySet()) {
            Integer billSeq = billEntry.getKey();
            DynamicObject billObj = billEntry.getValue();
            ArrayList<Long> periodIds = new ArrayList<Long>(16);
            DynamicObjectCollection budgetPeriods = billObj.getDynamicObjectCollection("budgetperiods");
            DynamicObjectCollection billDetails = billObj.getDynamicObjectCollection("adjdetailentity");
            HashSet<String> rowCustomDimSet = new HashSet<String>(billDetails.size());
            for (int i = 0; i < billDetails.size(); ++i) {
                boolean isExist;
                BigDecimal adjustData;
                String intStr;
                DynamicObject billDetail = (DynamicObject)billDetails.get(i);
                Long periodId = billDetail.getLong("budgetperiod.id");
                if (!periodIds.contains(periodId)) {
                    periodIds.add(periodId);
                    DynamicObject period = budgetPeriods.addNew();
                    period.set("fbasedataid_id", (Object)periodId);
                }
                if ((intStr = (adjustData = billDetail.getBigDecimal("adjustdata")).toPlainString().split("\\.")[0]).length() > 13) {
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u6574\u6570\u90e8\u5206\u4e0d\u5141\u8bb8\u8d85\u8fc713\u4f4d\u3002", (String)"OverallBudgetAdjustImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (adjustData.scale() > 2) {
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u6574\u91d1\u989d\u6700\u591a\u4fdd\u75592\u4f4d\u5c0f\u6570\u3002", (String)"OverallBudgetAdjustImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                String groupNum = billDetail.getString("groupnum");
                if (groupNum.length() > 10) {
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u6700\u5927\u957f\u5ea6\u4e3a10\u3002", (String)"OverallBudgetAdjustImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (StringUtils.isNotEmpty((String)(groupNum = groupNum.replaceAll("[a-zA-Z0-9]+", "")))) {
                    errorBillSeqs.add(billSeq);
                    this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u8c03\u5242\u7ec4\u53f7\u53ea\u80fd\u5305\u542b\u6570\u503c\u548c\u5b57\u6bcd\u3002", (String)"BaseEbAdjustBillEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                boolean isEmpty = this.isRowCustomDimEmpty(billDetail, billSeq, errorBillSeqs);
                if (isEmpty || !(isExist = this.isViewDetailDimExist(billDetail, billSeq, errorBillSeqs))) break;
                boolean allowSameDims = AdjustHelper.isAllowSameDim((Long)this.modelId, (String)this.billType);
                boolean isSame = this.isRowCustomDimSame(billDetail, rowCustomDimSet);
                if (!isSame || allowSameDims) continue;
                errorBillSeqs.add(billSeq);
                this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u5355\u636e\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"OverallBudgetAdjustImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            if (periodIds.size() < 20) continue;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billObj, ResManager.loadKDString((String)"\u8bf7\u9009\u62e920\u4e2a\u4ee5\u5185\u7684\u671f\u95f4\u6210\u5458\u3002", (String)"OverallBudgetAdjustImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        errorBillSeqs.forEach(billMap::remove);
    }

    private boolean isViewDetailDimExist(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqs) {
        StringBuilder errorInfo;
        boolean isExistViewDim = true;
        Long accountId = billDetail.getLong("account.id");
        Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
        List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(this.bizModelId);
        if (!datasetIds.contains(datasetId)) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadKDString((String)"\u79d1\u76ee\u6240\u5728\u6570\u636e\u96c6\u4e0d\u5728\u5bf9\u5e94\u4e1a\u52a1\u6a21\u578b\u5185\u3002", (String)"OverallBudgetAdjustImportPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map dimensionMap = this.modelCacheHelper.getDimensionMap(datasetId);
        Dimension entityDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Entity.getNumber());
        Dimension accountDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
        Dimension metricDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
        if (entityDimension == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Entity.getChineseName()}));
        }
        if (accountDimension == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Account.getChineseName()}));
        }
        if (metricDimension == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Metric.getChineseName()}));
        }
        Long entityViewId = this.dimBaseViewMap.get(SysDimensionEnum.Entity.getNumber());
        Long entityId = billDetail.getLong("entity.id");
        Member entityMember = AdjustImpExpUtil.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityId, this.modelCacheHelper);
        if (entityMember == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u201c%1\u201d\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"OverallBudgetAdjustImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Entity.getChineseName()}));
        }
        Long metricId = billDetail.getLong("metric.id");
        Member metricMember = AdjustImpExpUtil.getMember(SysDimensionEnum.Metric.getNumber(), 0L, metricId, this.modelCacheHelper);
        if (metricMember == null) {
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u201c%1\u201d\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"OverallBudgetAdjustImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Metric.getChineseName()}));
        }
        HashSet<Long> customDimMemberIds = new HashSet<Long>(16);
        int maxCustomDimSize = this.customDimMap.size();
        for (int i = 1; i <= maxCustomDimSize; ++i) {
            Long customDimId = billDetail.getLong("customdim" + i + ".id");
            if (!IDUtils.isNotNull((Long)customDimId)) continue;
            customDimMemberIds.add(customDimId);
        }
        ArrayList<String> dimList = new ArrayList<String>(16);
        ArrayList<String> dimViewList = new ArrayList<String>(16);
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and("id", "in", customDimMemberIds);
        Map customDimMap = BusinessDataServiceHelper.loadFromCache((String)"epm_userdefinedmembertree", (QFilter[])filter.toArray());
        for (Map.Entry mapEntry : customDimMap.entrySet()) {
            Object dimMemberId = mapEntry.getKey();
            DynamicObject value = (DynamicObject)mapEntry.getValue();
            DynamicObject dimensionObj = value.getDynamicObject("dimension");
            String dimensionNumber = dimensionObj.getString("number");
            String dimensionName = dimensionObj.getString("name");
            Dimension dimension = (Dimension)dimensionMap.get(dimensionNumber);
            if (dimension == null) {
                dimList.add(dimensionName);
                continue;
            }
            Long dimViewId = this.dimBaseViewMap.get(dimensionNumber);
            if (dimViewId == null || dimViewId == 0L) {
                dimViewList.add(dimensionName);
                continue;
            }
            Member customMember = AdjustImpExpUtil.getMember(dimensionNumber, dimViewId, (Long)dimMemberId, this.modelCacheHelper);
            if (customMember != null) continue;
            dimViewList.add(dimensionName);
        }
        if (dimList.size() > 0) {
            errorInfo = new StringBuilder();
            for (String name : dimList) {
                errorInfo.append(name).append(";");
            }
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(";"));
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"\u8be5\u79d1\u76ee\u6240\u5c5e\u7684\u6570\u636e\u96c6\u4e2d\u65e0%1\u7ef4\u5ea6\u3002", (String)"OverallBudgetAdjustImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.toString()}));
        }
        if (dimViewList.size() > 0) {
            errorInfo = new StringBuilder();
            for (String name : dimViewList) {
                errorInfo.append(name).append(";");
            }
            errorInfo.deleteCharAt(errorInfo.lastIndexOf(";"));
            isExistViewDim = false;
            errorBillSeqs.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u4e0d\u5728\u4e1a\u52a1\u6a21\u578b\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"OverallBudgetAdjustImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{errorInfo.toString()}));
        }
        return isExistViewDim;
    }

    private boolean hasPermForDimMember(DynamicObject dataEntity, Integer billSeq, Set<Integer> errorBillSeqSet) {
        Member member;
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)this.modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Long userId = UserUtils.getUserId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.modelId);
        ArrayList<String> definedDim = new ArrayList<String>(10);
        ArrayList<String> permControlDim = new ArrayList<String>(10);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(this.bizModelId);
        List<String> headCheckLeaf = Arrays.asList("Version", "Currency", "ChangeType", "DataType");
        for (Object dimension : dimensionList) {
            if (!dimension.isPreset()) {
                definedDim.add(dimension.getNumber());
            }
            if (!permControlDims.contains(dimension.getNumber())) continue;
            permControlDim.add(dimension.getNumber());
        }
        DynamicObjectCollection adjdetailentity = dataEntity.getDynamicObjectCollection("adjdetailentity");
        for (Object detail : adjdetailentity) {
            Object var14_15 = null;
            for (int i = 1; i <= definedDim.size(); ++i) {
                DynamicObject dynamicObject = detail.getDynamicObject("customdim" + i);
                if (dynamicObject == null || (member = modelCacheHelper.getMember((String)definedDim.get(i - 1), this.dimBaseViewMap.get(definedDim.get(i - 1)), Long.valueOf(dynamicObject.getLong("id")))).isLeaf()) continue;
                errorBillSeqSet.add(billSeq);
                this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{definedDim.get(i), member.getNumber()}));
                return false;
            }
            DynamicObject entity = detail.getDynamicObject(SysDimensionEnum.Entity.getNumber().toLowerCase());
            DynamicObject account = detail.getDynamicObject(SysDimensionEnum.Account.getNumber().toLowerCase());
            DynamicObject dynamicObject = detail.getDynamicObject(SysDimensionEnum.Metric.getNumber().toLowerCase());
            if (entity == null || account == null || dynamicObject == null) continue;
            Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), this.dimBaseViewMap.get(SysDimensionEnum.Entity.getNumber()), Long.valueOf(entity.getLong("id")));
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), Long.valueOf(account.getLong("id")));
            Member metricMember = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), Long.valueOf(dynamicObject.getLong("id")));
            if (!entityMember.isLeaf()) {
                errorBillSeqSet.add(billSeq);
                this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Entity.getNumber(), entityMember.getNumber()}));
                return false;
            }
            if (!accountMember.isLeaf()) {
                errorBillSeqSet.add(billSeq);
                this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Account.getNumber(), accountMember.getNumber()}));
                return false;
            }
            if (metricMember.isLeaf()) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.Metric.getNumber(), metricMember.getNumber()}));
            return false;
        }
        DynamicObject headObj = null;
        for (String string : headCheckLeaf) {
            Member member2;
            headObj = dataEntity.getDynamicObject(string.toLowerCase());
            if (headObj == null || (member2 = modelCacheHelper.getMember(string, this.dimBaseViewMap.get(string), Long.valueOf(headObj.getLong("id")))).isLeaf()) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{string, member2.getNumber()}));
            return false;
        }
        DynamicObjectCollection budgetperiods = dataEntity.getDynamicObjectCollection("budgetperiods");
        for (DynamicObject budgetperiod : budgetperiods) {
            member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), Long.valueOf(budgetperiod.getLong("fbasedataid_id")));
            if (member.isLeaf()) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e3a\u975e\u660e\u7ec6\u8282\u70b9\u3002", (String)"OverallBudgetAdjustImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[]{SysDimensionEnum.BudgetPeriod.getNumber(), member.getNumber()}));
            return false;
        }
        DimMemberPermChecker dimMemberPermChecker = DimMembPermHelper.getPermChecker((Long)this.modelId, (Long)this.bizModelId, permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
        boolean includeDetail = false;
        for (String string : permControlDim) {
            if (SysDimensionEnum.getEnumByNumber((String)string) != null && !SysDimensionEnum.Entity.getNumber().equals(string) && !SysDimensionEnum.Account.getNumber().equals(string) && !SysDimensionEnum.Metric.getNumber().equals(string)) continue;
            includeDetail = true;
            break;
        }
        HashSet headNeedCheck = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Version.getNumber(), SysDimensionEnum.Currency.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.ChangeType.getNumber()});
        if (includeDetail) {
            for (DynamicObject detail : adjdetailentity) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder dimensionStr = new StringBuilder();
                HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(permControlDim.size());
                for (String dimNum : permControlDim) {
                    DynamicObject dyObj = null;
                    if (SysDimensionEnum.getEnumByNumber((String)dimNum) != null) {
                        if (!(SysDimensionEnum.Entity.getNumber().equals(dimNum) || SysDimensionEnum.Account.getNumber().equals(dimNum) || SysDimensionEnum.Metric.getNumber().equals(dimNum))) {
                            if (headNeedCheck.contains(dimNum)) {
                                dyObj = dataEntity.getDynamicObject(dimNum.toLowerCase());
                            }
                        } else {
                            dyObj = detail.getDynamicObject(dimNum.toLowerCase());
                        }
                    } else {
                        int index = definedDim.indexOf(dimNum) + 1;
                        dyObj = detail.getDynamicObject("customdim" + index);
                    }
                    if (dyObj == null) continue;
                    MemberItem memberItem = new MemberItem(true, Long.valueOf(dyObj.getLong("id")));
                    dimensionStr.append(dimNum).append(",");
                    stringBuilder.append(dyObj.getString("number")).append(",");
                    memberGroup.put(dimNum, memberItem);
                }
                boolean check = dimMemberPermChecker.check(memberGroup);
                if (check) continue;
                errorBillSeqSet.add(billSeq);
                this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e2d\u5b58\u5728\u65e0\u6743\u7684\u6210\u5458", (String)"OverallBudgetAdjustImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionStr.substring(0, dimensionStr.length() - 1), stringBuilder.substring(0, stringBuilder.length() - 1)}));
                return false;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder dimensionStr = new StringBuilder();
            HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(permControlDim.size());
            for (String dimNum : permControlDim) {
                DynamicObject dyObj;
                if (!headNeedCheck.contains(dimNum) || (dyObj = dataEntity.getDynamicObject(dimNum.toLowerCase())) == null) continue;
                MemberItem memberItem = new MemberItem(true, Long.valueOf(dyObj.getLong("id")));
                dimensionStr.append(dimNum).append(",");
                stringBuilder.append(dyObj.getString("number")).append(",");
                memberGroup.put(dimNum, memberItem);
            }
            boolean check = dimMemberPermChecker.check(memberGroup);
            if (!check) {
                errorBillSeqSet.add(billSeq);
                this.addErrorLog(dataEntity, ResManager.loadResFormat((String)"%1\u7684\u6210\u5458\u7f16\u7801\u201c%2\u201d\u4e2d\u5b58\u5728\u65e0\u6743\u7684\u6210\u5458", (String)"OverallBudgetAdjustImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionStr.substring(0, dimensionStr.length() - 1), stringBuilder.substring(0, stringBuilder.length() - 1)}));
                return false;
            }
        }
        return true;
    }

    private boolean isRowCustomDimEmpty(DynamicObject billDetail, Integer billSeq, Set<Integer> errorBillSeqSet) {
        boolean isEmpty = false;
        Long accountId = billDetail.getLong("account.id");
        Long datasetId = AdjustHelper.getDatasetId((Long)accountId);
        Map rowCustomDimMap = AdjustHelper.getCustomDimsByDataset((Long)this.modelId, (Long)datasetId, this.customDimMap);
        for (Map.Entry customDimEntry : rowCustomDimMap.entrySet()) {
            String customDimKey = (String)customDimEntry.getKey();
            Dimension customDim = (Dimension)customDimEntry.getValue();
            DynamicObject customDimObj = billDetail.getDynamicObject(customDimKey);
            if (customDimObj != null) continue;
            errorBillSeqSet.add(billSeq);
            this.addErrorLog(billDetail, ResManager.loadResFormat((String)"%1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OverallBudgetAdjustImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[]{customDim.getName()}));
            isEmpty = true;
            break;
        }
        return isEmpty;
    }

    private boolean isRowCustomDimSame(DynamicObject billDetail, Set<String> rowCustomDimSet) {
        boolean isSame = false;
        String rowCustomDim = AdjustImpExpUtil.getRowCustomDim(billDetail, this.modelId, this.customDimMap);
        if (StringUtils.isNotEmpty((String)rowCustomDim)) {
            if (rowCustomDimSet.contains(rowCustomDim)) {
                isSame = true;
            } else {
                rowCustomDimSet.add(rowCustomDim);
            }
        }
        return isSame;
    }
}

