/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bgadjust.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.adjust.AdjustHelper;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.bailorg.BailOrgService;
import kd.epm.eb.common.adjust.AdjustDimMem;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.bgadjust.impexp.AdjustImpExpUtil;
import kd.epm.eb.model.utils.ModelUtil;

public class AdjustUtil {
    private static final Log log = LogFactory.getLog(AdjustUtil.class);

    private AdjustUtil() {
    }

    public static boolean isBgm(IFormView view, long modelId) {
        ApplicationTypeEnum app;
        if (IDUtils.isNotNull((long)modelId)) {
            return AdjustUtil.isBGMModel(modelId);
        }
        String appnumber = view.getFormShowParameter().getAppId();
        if (!(ApplicationTypeEnum.EB.getAppnum().equals(appnumber) || ApplicationTypeEnum.BG.getAppnum().equals(appnumber) || ApplicationTypeEnum.BGM.getAppnum().equals(appnumber))) {
            appnumber = view.getFormShowParameter().getFormConfig().getAppId();
        }
        return ApplicationTypeEnum.BGM == (app = ApplicationTypeEnum.getEnumByNumber((String)appnumber, (IFormView)view)) || ApplicationTypeEnum.BGMD == app;
    }

    public static boolean isBGMModel(long modelId) {
        if (modelId == 0L) {
            return false;
        }
        String reportType = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType();
        return ApplicationTypeEnum.BGM.getIndex().equals(reportType) || ApplicationTypeEnum.BGMD.getIndex().equals(reportType);
    }

    public static boolean isEB(IFormView view, long modelId) {
        if (IDUtils.isNotNull((long)modelId)) {
            return AdjustUtil.isEBModel(modelId);
        }
        String appnumber = view.getFormShowParameter().getAppId();
        if (!(ApplicationTypeEnum.EB.getAppnum().equals(appnumber) || ApplicationTypeEnum.BG.getAppnum().equals(appnumber) || ApplicationTypeEnum.BGM.getAppnum().equals(appnumber))) {
            appnumber = view.getFormShowParameter().getFormConfig().getAppId();
        }
        return ApplicationTypeEnum.EB == ApplicationTypeEnum.getEnumByNumber((String)appnumber, (IFormView)view);
    }

    public static boolean isEBModel(long modelId) {
        if (modelId == 0L) {
            return false;
        }
        String reportType = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType();
        return ApplicationTypeEnum.EB.getIndex().equals(reportType);
    }

    public static void setWriteDimMemFilter(List<QFilter> qFilters, Long modelId, Long bizModelId, String dimNumber) {
        Long dimViewId = AdjustHelper.getDimDefaultViewId((Long)modelId, (Long)bizModelId, (String)dimNumber);
        Set writePermMembIds = DimMembPermHelper.getPermMembIds((String)dimNumber, (Long)modelId, (Long)bizModelId, (Long)dimViewId, (DimMembPermType)DimMembPermType.WRITE, (boolean)true);
        if (writePermMembIds == null) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List members = modelCacheHelper.getDimension(dimNumber).getMembers((Collection)writePermMembIds, dimViewId);
        Set<Object> numbers = members == null ? new HashSet(16) : members.stream().map(m -> m.getNumber()).collect(Collectors.toSet());
        ModelCacheContext.remove();
        Set<String> numbersQfilter = AdjustUtil.getNumbersQfilter(qFilters);
        if (numbersQfilter.size() > 0) {
            numbers.retainAll(numbersQfilter);
        }
        qFilters.add(new QFilter("number", "in", numbers));
    }

    private static Set<String> getNumbersQfilter(List<QFilter> qFilters) {
        HashSet<String> numbers = new HashSet<String>(16);
        qFilters.removeIf(q -> {
            Object[] ob;
            List nests;
            if ("number".equals(q.getProperty()) && "in".equals(q.getCP()) && ((nests = q.getNests(false)) == null || nests.size() == 0) && (ob = QFilterUtil.getWithoutDuplicateInValues((Object)q.getValue())) != null && ob.length > 0) {
                for (Object o : ob) {
                    numbers.add(o.toString());
                }
                return true;
            }
            return false;
        });
        return numbers;
    }

    public static boolean isBG(IFormView view, long modelId) {
        if (IDUtils.isNotNull((long)modelId)) {
            return AdjustUtil.isBGModel(modelId);
        }
        String appnumber = view.getFormShowParameter().getAppId();
        if (!(ApplicationTypeEnum.EB.getAppnum().equals(appnumber) || ApplicationTypeEnum.BG.getAppnum().equals(appnumber) || ApplicationTypeEnum.BGM.getAppnum().equals(appnumber))) {
            appnumber = view.getFormShowParameter().getFormConfig().getAppId();
        }
        return ApplicationTypeEnum.BG == ApplicationTypeEnum.getEnumByNumber((String)appnumber, (IFormView)view);
    }

    public static boolean isBGModel(long modelId) {
        if (modelId == 0L) {
            return false;
        }
        String reportType = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType();
        return ApplicationTypeEnum.BG.getIndex().equals(reportType);
    }

    public static String getFormType(IDataModel dataModel) {
        String formType = (String)dataModel.getValue("billtype");
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        return formType;
    }

    public static void fillEntityBailOrg(long modelId, DynamicObject adjustBill) {
        DynamicObjectCollection entryEntity = adjustBill.getDynamicObjectCollection("adjdetailentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        Set entityNumbers = entryEntity.stream().map(e -> e.getString("entity.number")).collect(Collectors.toSet());
        Map bailOrgIds = BailOrgService.getInstance().getDefaultBailOrgIds(Long.valueOf(modelId), entityNumbers);
        for (DynamicObject object : entryEntity) {
            object.set("defaultbailorg_id", bailOrgIds.get(object.getString("entity.number")));
        }
    }

    /*
     * Could not resolve type clashes
     */
    public static boolean handleReportDimMember(IFormView formView, Map<AdjustDimMem, List<String>> cellDimMemMap, int cellCount) {
        if (CollectionUtils.isEmpty(cellDimMemMap)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u5143\u683c\u3002", (String)"AdjustBudgetForm_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        log.info("AdjustUtil#handleReportDimMember==>cellDimMemMap size={}, cellCount={}", (Object)cellDimMemMap.size(), (Object)cellCount);
        if (cellCount > 100000) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c0f\u4e8e10\u4e07\u5355\u5143\u683c\u586b\u5145\u884c\u3002", (String)"AdjustBudgetForm_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        IDataModel dataModel = formView.getModel();
        DynamicObject model = (DynamicObject)dataModel.getValue("model");
        DynamicObject bizModel = (DynamicObject)dataModel.getValue("bizmodel");
        Long modelId = model.getLong("id");
        Long bizModelId = bizModel.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        Map customDimMap = AdjustHelper.getCustomDimsByBizModel((Long)modelId, (Long)bizModelId);
        ArrayList<String> incompleteCellList = new ArrayList<String>(16);
        ArrayList<String> noNumCellList = new ArrayList<String>(16);
        ArrayList<String> noCurViewDimMemList = new ArrayList<String>(16);
        ArrayList<String> noDetailCellList = new ArrayList<String>(16);
        ArrayList<String> noRuleCellList = new ArrayList<String>(16);
        ArrayList<String> noPermCellList = new ArrayList<String>(16);
        ArrayList<Map<String, String>> successDimMemList = new ArrayList<Map<String, String>>(16);
        log.info("AdjustUtil#handleReportDimMember==>validate start");
        for (Map.Entry<AdjustDimMem, List<String>> entry : cellDimMemMap.entrySet()) {
            AdjustDimMem adjustDimMem = entry.getKey();
            Map dimMemMap = adjustDimMem.getDimMemMap();
            List<String> cellList = entry.getValue();
            if (!(dimMemMap.containsKey(SysDimensionEnum.Entity.getNumber()) && dimMemMap.containsKey(SysDimensionEnum.Account.getNumber()) && dimMemMap.containsKey(SysDimensionEnum.Metric.getNumber()))) {
                for (String cell : cellList) {
                    incompleteCellList.add(cell);
                }
                continue;
            }
            String entityNumber = (String)dimMemMap.get(SysDimensionEnum.Entity.getNumber());
            String accountNumber = (String)dimMemMap.get(SysDimensionEnum.Account.getNumber());
            String metricNumber = (String)dimMemMap.get(SysDimensionEnum.Metric.getNumber());
            if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)accountNumber) || StringUtils.isEmpty((String)metricNumber)) {
                for (Object cell : cellList) {
                    incompleteCellList.add((String)cell);
                }
                continue;
            }
            String metricType = ModelHelper.getMetricType((Map)dimMemMap, (IModelCacheHelper)modelCacheHelper);
            if (!MetricDataTypeEnum.isNumber((String)metricType)) {
                for (Object cell : cellList) {
                    noNumCellList.add((String)cell);
                }
                continue;
            }
            boolean isCurViewDimMember = AdjustUtil.isCurViewDimMember(modelId, customDimMap, dimMemMap, dimViewMap);
            if (!isCurViewDimMember) {
                Object cell;
                cell = cellList.iterator();
                while (cell.hasNext()) {
                    String cell2 = (String)cell.next();
                    noCurViewDimMemList.add(cell2);
                }
                continue;
            }
            boolean isLeaf = AdjustUtil.isLeafMember(modelId, customDimMap, dimMemMap, dimViewMap);
            if (!isLeaf) {
                for (Object cell : cellList) {
                    noDetailCellList.add((String)cell);
                }
                continue;
            }
            boolean isCheckPass = AdjustUtil.checkAdjustRule(dataModel, customDimMap, dimMemMap);
            if (!isCheckPass) {
                Object cell;
                cell = cellList.iterator();
                while (cell.hasNext()) {
                    String cell3 = (String)cell.next();
                    noRuleCellList.add(cell3);
                }
                continue;
            }
            Long orgViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
            boolean isCheckDimPermPass = AdjustUtil.checkDimPerm(dataModel, dimMemMap, orgViewId);
            if (!isCheckDimPermPass) {
                for (String cell : cellList) {
                    noPermCellList.add(cell);
                }
                continue;
            }
            successDimMemList.add(dimMemMap);
        }
        log.info("AdjustUtil#handleReportDimMember==>validate end");
        if (successDimMemList.size() == cellDimMemMap.size()) {
            formView.showSuccessNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6210\u529f\u3002", (String)"AdjustBudgetForm_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            AdjustUtil.fillMember2EntryEntity(formView, customDimMap, successDimMemList, dimViewMap);
            return true;
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(16);
        StringBuilder errorMsg = new StringBuilder();
        if (!incompleteCellList.isEmpty()) {
            errorMsg.append(ResManager.loadResFormat((String)"%1\u4e2a\u5355\u5143\u683c\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5b8c\u6574\uff1a", (String)"AdjustBudgetForm_6", (String)"epm-eb-formplugin", (Object[])new Object[]{incompleteCellList.size()}));
            AdjustUtil.addErrorMsg(incompleteCellList, errorMsgList, errorMsg);
        }
        if (!noNumCellList.isEmpty()) {
            errorMsg.append(ResManager.loadResFormat((String)"%1\u4e2a\u5355\u5143\u683c\u7684\u5ea6\u91cf\u7ef4\u5ea6\u6210\u5458\u4e3a\u975e\u6570\u503c\uff1a", (String)"AdjustBudgetForm_7", (String)"epm-eb-formplugin", (Object[])new Object[]{noNumCellList.size()}));
            AdjustUtil.addErrorMsg(noNumCellList, errorMsgList, errorMsg);
        }
        if (!noCurViewDimMemList.isEmpty()) {
            errorMsg.append(ResManager.loadResFormat((String)"%1\u4e2a\u5355\u5143\u683c\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5728\u5f53\u524d\u89c6\u56fe\uff1a", (String)"AdjustBudgetForm_12", (String)"epm-eb-formplugin", (Object[])new Object[]{noCurViewDimMemList.size()}));
            AdjustUtil.addErrorMsg(noCurViewDimMemList, errorMsgList, errorMsg);
        }
        if (!noDetailCellList.isEmpty()) {
            errorMsg.append(ResManager.loadResFormat((String)"%1\u4e2a\u5355\u5143\u683c\u7684\u7ef4\u5ea6\u7ec4\u5408\u5b58\u5728\u975e\u660e\u7ec6\u6210\u5458\uff1a", (String)"AdjustBudgetForm_8", (String)"epm-eb-formplugin", (Object[])new Object[]{noDetailCellList.size()}));
            AdjustUtil.addErrorMsg(noDetailCellList, errorMsgList, errorMsg);
        }
        if (!noRuleCellList.isEmpty()) {
            errorMsg.append(ResManager.loadResFormat((String)"%1\u4e2a\u5355\u5143\u683c\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5728\u8c03\u6574\u89c4\u5219\u8303\u56f4\u5185\uff1a", (String)"AdjustBudgetForm_9", (String)"epm-eb-formplugin", (Object[])new Object[]{noRuleCellList.size()}));
            AdjustUtil.addErrorMsg(noRuleCellList, errorMsgList, errorMsg);
        }
        if (!noPermCellList.isEmpty()) {
            errorMsg.append(ResManager.loadResFormat((String)"%1\u4e2a\u5355\u5143\u683c\u6ca1\u6709\u7ef4\u5ea6\u6570\u636e\u6743\u9650\uff1a", (String)"AdjustBudgetForm_10", (String)"epm-eb-formplugin", (Object[])new Object[]{noPermCellList.size()}));
            AdjustUtil.addErrorMsg(noPermCellList, errorMsgList, errorMsg);
        }
        AdjustUtil.showErrorNotification(formView, cellDimMemMap, successDimMemList, errorMsgList);
        AdjustUtil.fillMember2EntryEntity(formView, customDimMap, successDimMemList, dimViewMap);
        return false;
    }

    private static void fillMember2EntryEntity(IFormView formView, Map<String, Dimension> customDimMap, List<Map<String, String>> dimMemMapList, Map<String, Long> dimViewMap) {
        if (CollectionUtils.isEmpty(dimMemMapList)) {
            return;
        }
        log.info("AdjustUtil#fillMember2EntryEntity start, successDimMemList size={}", (Object)dimMemMapList.size());
        IDataModel dataModel = formView.getModel();
        DynamicObject model = (DynamicObject)dataModel.getValue("model");
        Long modelId = model.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<String> rowDimSet = new HashSet<String>(dimMemMapList.size());
        StringBuilder rowDimStr = new StringBuilder();
        LinkedHashSet<Long> periodIds = new LinkedHashSet<Long>(16);
        DynamicObjectCollection periods = (DynamicObjectCollection)dataModel.getValue("budgetperiods");
        for (DynamicObject period : periods) {
            Long periodId = period.getLong("fbasedataid.id");
            periodIds.add(periodId);
        }
        for (Map<String, String> dimMemMap : dimMemMapList) {
            String periodNumber = dimMemMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            Member periodMember = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), periodNumber);
            if (periodMember != null && periodMember.isLeaf()) {
                periodIds.add(periodMember.getId());
            }
            String entityNumber = dimMemMap.get(SysDimensionEnum.Entity.getNumber());
            Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewMap.get(SysDimensionEnum.Entity.getNumber()), entityNumber);
            String accountNumber = dimMemMap.get(SysDimensionEnum.Account.getNumber());
            Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), accountNumber);
            String metricNumber = dimMemMap.get(SysDimensionEnum.Metric.getNumber());
            Member metricMember = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), Long.valueOf(0L), metricNumber);
            rowDimStr.append(SysDimensionEnum.Entity.getNumber()).append("@").append(entityNumber).append("!!").append(SysDimensionEnum.Account.getNumber()).append("@").append(accountNumber).append("!!").append(SysDimensionEnum.Metric.getNumber()).append("@").append(metricNumber);
            for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                Dimension dimension = entry.getValue();
                String dimNumber = dimension.getNumber();
                if (!dimMemMap.containsKey(dimNumber)) continue;
                String dimMemNum = dimMemMap.get(dimNumber);
                rowDimStr.append("!!").append(dimNumber).append("@").append(dimMemNum);
            }
            if (!rowDimSet.add(rowDimStr.toString())) {
                rowDimStr.setLength(0);
                continue;
            }
            rowDimStr.setLength(0);
            dataModel.beginInit();
            int rowCount = dataModel.getEntryRowCount("entryentity");
            int newEntryRow = dataModel.insertEntryRow("entryentity", rowCount + 1);
            dataModel.setValue("adjentity", (Object)entityMember.getId(), newEntryRow);
            dataModel.setValue("adjaccount", (Object)accountMember.getId(), newEntryRow);
            dataModel.setValue("adjmetric", (Object)metricMember.getId(), newEntryRow);
            for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                String key = entry.getKey();
                Dimension dimension = entry.getValue();
                String dimNumber = dimension.getNumber();
                if (!dimMemMap.containsKey(dimNumber)) continue;
                String dimMemNum = dimMemMap.get(dimNumber);
                Member customDimMember = modelCacheHelper.getMember(dimNumber, dimViewMap.get(dimNumber), dimMemNum);
                dataModel.setValue("adj" + key, (Object)customDimMember.getId(), newEntryRow);
            }
            dataModel.endInit();
        }
        formView.updateView("entryentity");
        formView.getPageCache().put("needFreshBudgetDataCache", SerializationUtils.serializeToBase64(periodIds));
        log.info("AdjustUtil#fillMember2EntryEntity end");
    }

    private static boolean isCurViewDimMember(Long modelId, Map<String, Dimension> customDimMap, Map<String, String> dimMemMap, Map<String, Long> dimViewMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        boolean isCurViewEntity = true;
        Long entityViewId = dimViewMap.get(SysDimensionEnum.Entity.getNumber());
        String entityNumber = dimMemMap.get(SysDimensionEnum.Entity.getNumber());
        Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityNumber);
        if (entityMember == null) {
            isCurViewEntity = false;
        }
        boolean isCurViewCustomDim = true;
        for (Dimension dimension : customDimMap.values()) {
            String dimMemNum;
            Long dimViewId;
            Member customDimMember;
            String dimNumber = dimension.getNumber();
            if (!dimMemMap.containsKey(dimNumber) || (customDimMember = modelCacheHelper.getMember(dimNumber, dimViewId = dimViewMap.get(dimNumber), dimMemNum = dimMemMap.get(dimNumber))) != null) continue;
            isCurViewCustomDim = false;
            break;
        }
        return isCurViewEntity && isCurViewCustomDim;
    }

    private static boolean isLeafMember(Long modelId, Map<String, Dimension> customDimMap, Map<String, String> dimMemMap, Map<String, Long> dimViewMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimensionMap = modelCacheHelper.getDimensionMap();
        boolean isEntityLeaf = false;
        String entityNumber = dimMemMap.get(SysDimensionEnum.Entity.getNumber());
        Long entityViewId = dimViewMap.get(SysDimensionEnum.Entity.getNumber());
        Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), entityViewId, entityNumber);
        if (entityMember != null && entityMember.isLeaf()) {
            isEntityLeaf = true;
        }
        boolean isAccountLeaf = false;
        String accountNumber = dimMemMap.get(SysDimensionEnum.Account.getNumber());
        Dimension accountDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Account.getNumber());
        Member accountMember = accountDimension.getMember(Long.valueOf(0L), accountNumber);
        if (accountMember != null && accountMember.isLeaf()) {
            isAccountLeaf = true;
        }
        boolean isMetricLeaf = false;
        String metricNumber = dimMemMap.get(SysDimensionEnum.Metric.getNumber());
        Dimension metricDimension = (Dimension)dimensionMap.get(SysDimensionEnum.Metric.getNumber());
        Member metricMember = metricDimension.getMember(Long.valueOf(0L), metricNumber);
        if (metricMember != null && metricMember.isLeaf()) {
            isMetricLeaf = true;
        }
        boolean isCustomDimLeaf = true;
        for (Dimension dimension : customDimMap.values()) {
            String dimNumber = dimension.getNumber();
            if (!dimMemMap.containsKey(dimNumber)) continue;
            String dimMemNum = dimMemMap.get(dimNumber);
            Long dimViewId = dimViewMap.get(dimNumber);
            Member customDimMember = modelCacheHelper.getMember(dimNumber, dimViewId, dimMemNum);
            if (customDimMember == null || customDimMember.isLeaf()) continue;
            isCustomDimLeaf = false;
            break;
        }
        return isEntityLeaf && isAccountLeaf && isMetricLeaf && isCustomDimLeaf;
    }

    private static boolean checkAdjustRule(IDataModel dataModel, Map<String, Dimension> customDimMap, Map<String, String> dimMemMap) {
        DynamicObjectCollection ruleDetailList;
        Object adjustRuleObj = dataModel.getValue("adjustrule");
        if (adjustRuleObj == null) {
            return true;
        }
        DynamicObject adjustRule = (DynamicObject)adjustRuleObj;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)adjustRule.getLong("id"), (String)"bgm_adjustrule");
        DynamicObjectCollection budgetPeriods = dynamicObject.getDynamicObjectCollection("budgetperiods");
        if (CollectionUtils.isNotEmpty((Collection)budgetPeriods)) {
            String periodNumber = dimMemMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            Set periodNumbers = budgetPeriods.stream().map(period -> period.getString("fbasedataid.number")).collect(Collectors.toSet());
            if (!periodNumbers.contains(periodNumber)) {
                return false;
            }
        }
        if (CollectionUtils.isEmpty((Collection)(ruleDetailList = dynamicObject.getDynamicObjectCollection("entryentity")))) {
            return true;
        }
        boolean validEntity = true;
        HashSet<String> entityMemSet = new HashSet<String>(16);
        for (DynamicObject ruleDetail : ruleDetailList) {
            String dimMemberStr = ruleDetail.getString("entity");
            if (StringUtils.isEmpty((String)dimMemberStr)) {
                validEntity = false;
                break;
            }
            String[] dimMemberArr = dimMemberStr.split(";");
            entityMemSet.addAll(Arrays.asList(dimMemberArr));
        }
        DynamicObject model = (DynamicObject)dataModel.getValue("model");
        DynamicObject bizModel = (DynamicObject)dataModel.getValue("bizmodel");
        Long modelId = model.getLong("id");
        Long bizModelId = bizModel.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String entityNumber = dimMemMap.get(SysDimensionEnum.Entity.getNumber());
        if (validEntity) {
            MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
            Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(bizModelId, SysDimensionEnum.Entity.getNumber());
            HashSet<String> entityNumberSet = new HashSet<String>(16);
            for (String entityStr : entityMemSet) {
                entityNumberSet.addAll(AdjustImpExpUtil.getEntityMemberNumberSet(modelCacheHelper, memberPropCache, entityStr, viewId));
            }
            if (!entityNumberSet.contains(entityNumber)) {
                return false;
            }
        }
        String accountNumber = dimMemMap.get(SysDimensionEnum.Account.getNumber());
        Set<String> allAccountNumber = AdjustImpExpUtil.getAllAccountNumber(entityNumber, ruleDetailList, modelId, bizModelId);
        if (allAccountNumber != null && !allAccountNumber.contains(accountNumber)) {
            return false;
        }
        for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
            Set<String> customNumberSet;
            String key = entry.getKey();
            Dimension dimension = entry.getValue();
            String dimNumber = dimension.getNumber();
            String dimMemNum = dimMemMap.get(dimNumber);
            if (StringUtils.isEmpty((String)dimMemNum) || (customNumberSet = AdjustImpExpUtil.getAllCustomDimNumbers(key, ruleDetailList, accountNumber, modelCacheHelper, modelId, bizModelId)) == null || customNumberSet.contains(dimMemNum)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDimPerm(IDataModel dataModel, Map<String, String> dimMemMap, Long entityViewId) {
        DynamicObject model = (DynamicObject)dataModel.getValue("model");
        DynamicObject bizModel = (DynamicObject)dataModel.getValue("bizmodel");
        Long modelId = model.getLong("id");
        Long bizModelId = bizModel.getLong("id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List permControlDims = DimMembPermUtil.getPermControlDim((Long)modelId).stream().map(BaseCache::getNumber).collect(Collectors.toList());
        ArrayList<String> permControlDim = new ArrayList<String>(16);
        List dimensionList = ModelUtil.isEbOrBgModel((Long)modelId) ? modelCacheHelper.getDimensionList() : modelCacheHelper.getDimensionListByBusModel(bizModelId);
        for (Dimension dimension : dimensionList) {
            if (!permControlDims.contains(dimension.getNumber())) continue;
            permControlDim.add(dimension.getNumber());
        }
        Long userId = UserUtils.getUserId();
        DimMemberPermChecker permChecker = DimMembPermHelper.getPermChecker((Long)modelId, (Long)bizModelId, permControlDim, (Long)userId, (DimMembPermType)DimMembPermType.WRITE);
        HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(permControlDim.size());
        for (String dimNumber : permControlDim) {
            String memberNumber;
            Member member = modelCacheHelper.getMember(dimNumber, entityViewId, memberNumber = dimMemMap.get(dimNumber));
            if (member == null) continue;
            MemberItem memberItem = new MemberItem(true, member.getId());
            memberGroup.put(dimNumber, memberItem);
        }
        return permChecker.check(memberGroup);
    }

    private static void addErrorMsg(List<String> errorCellList, List<String> errorMsgList, StringBuilder errorMsg) {
        for (String cell : errorCellList) {
            errorMsg.append(cell).append("\u3001");
        }
        errorMsg.deleteCharAt(errorMsg.lastIndexOf("\u3001"));
        errorMsgList.add(errorMsg.toString());
        errorMsg.setLength(0);
    }

    private static void showErrorNotification(IFormView formView, Map<AdjustDimMem, List<String>> cellDimMemMap, List<Map<String, String>> successDimMemList, List<String> errorMsgList) {
        int totalSize = cellDimMemMap.size();
        int successSize = successDimMemList.size();
        int failSize = totalSize - successSize;
        String title = ResManager.loadResFormat((String)"\u5df2\u9009\u62e9%1\u4e2a\u6709\u6548\u5355\u5143\u683c\uff0c%2\u4e2a\u6dfb\u52a0\u6210\u529f\uff0c%3\u4e2a\u6dfb\u52a0\u5931\u8d25\uff0c\u5931\u8d25\u8be6\u60c5\uff1a", (String)"AdjustBudgetForm_11", (String)"epm-eb-formplugin", (Object[])new Object[]{totalSize, successSize, failSize});
        String content = String.join((CharSequence)"\r\n", errorMsgList);
        formView.showMessage(title, content, MessageTypes.Default);
    }
}

