/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.billimpexp;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class AbstractImportTempPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(AbstractImportTempPlugin.class);
    protected static final String downTempKey = "btndownload";
    protected static final String importKey = "import";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{downTempKey, importKey});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if (importKey.equals(clickKey)) {
            List<String> currentUrls = this.getCurrentUrls();
            if (currentUrls.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"BillImportStart_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (!this.supportMultiFile() && currentUrls.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5904\u7406\u5355\u4e2a\u6587\u4ef6\u3002", (String)"BillImportStart_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (this.doImport(currentUrls)) {
                if (this.isEmpty(this.getPageCache().get("hasReturnData"))) {
                    this.getView().returnDataToParent((Object)"IMPORTSUSS");
                }
                this.getView().close();
            }
        }
    }

    protected List<String> getCurrentUrls() {
        String cacheStr = this.getPageCache().get("file_url");
        List resultUrls = StringUtils.isNotEmpty((String)cacheStr) ? (List)SerializationUtils.fromJsonString((String)cacheStr, LinkedList.class) : new LinkedList();
        return resultUrls;
    }

    protected boolean doImport(List<String> currentUrls) {
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(16) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        Set<String> typeNames = this.selFileTypeNames();
        for (Object url : evt.getUrls()) {
            String fileName = (String)((Map)url).get("name");
            String fileType = fileName.substring(fileName.lastIndexOf("."));
            if (!typeNames.contains(fileType)) {
                evt.setCancel(true);
                evt.setCancelMsg(this.getFileTypeErrTip());
                return;
            }
            urls.add((String)((Map)url).get("url"));
        }
        if (urls.size() > 0) {
            this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    protected Set<String> selFileTypeNames() {
        return Sets.newHashSet((Object[])new String[]{".xls", ".xlsx"});
    }

    protected boolean supportMultiFile() {
        return false;
    }

    protected String getFileTypeErrTip() {
        return ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6a21\u677f\u6587\u4ef6\u3002", (String)"AbstractImportTempPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }
}

