/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.billimpexp.star;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillExportHandler;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class BillExportStart {
    private List<AbstractBillExportHandler> exportHandlers;
    private BillColGroup billColGroup;
    private String entityKey;
    private static final Log log = LogFactory.getLog(BillExportStart.class);

    public BillExportStart(String entityKey) {
        this.entityKey = entityKey;
    }

    public void exportData(IFormView formView, Map<String, Object> params) {
        this.initContext(formView, params);
        List<Long> selectedBillIds = this.getSelectedBillIds(formView, params);
        DynamicObject[] billObjs = this.readBillObjs(selectedBillIds);
        Workbook sheets = this.writeBillObj2File(billObjs, this.billColGroup);
        this.downFileAndShowInfo(formView, billObjs, sheets);
    }

    protected void downFileAndShowInfo(IFormView formView, DynamicObject[] billObjs, Workbook sheets) {
        int billCount = 0;
        if (billObjs != null) {
            billCount = billObjs.length;
        }
        String logError = this.addOpLog(formView, billObjs);
        formView.showSuccessNotification(ResManager.loadResFormat((String)"\u6210\u529f\u5bfc\u51fa%1\u884c\u6570\u636e\u3002", (String)"BillExportStart_1", (String)"epm-eb-formplugin", (Object[])new Object[]{billCount}));
        if (logError != null) {
            formView.showTipNotification(logError);
        }
        if (sheets != null) {
            ImportAndExportUtil.downFile((IFormView)formView, (Workbook)sheets, (String)ResManager.loadResFormat((String)"%1\u5bfc\u51fa\u6570\u636e", (String)"BillExportStart_2", (String)"epm-eb-formplugin", (Object[])new Object[]{this.billColGroup.getTitle()}));
        }
    }

    protected void initContext(IFormView formView, Map<String, Object> params) {
        BillColGroup billColGroup;
        String entityKey = this.getEntityKey();
        List<AbstractBillExportHandler> exportHandlers = this.parseImportHandler(formView, params, entityKey);
        this.exportHandlers = exportHandlers;
        this.billColGroup = billColGroup = this.initBillColsInfo(entityKey, exportHandlers);
    }

    protected BillColGroup initBillColsInfo(String entityKey, List<AbstractBillExportHandler> exportHandlers) {
        BillColGroup billColGroup = this.loadBillGroupInfo(entityKey);
        exportHandlers.forEach(handler -> handler.addBillColsInfo(billColGroup));
        BillImpExpUtils.updateColIndex((BillColGroup)billColGroup, (Count)new Count(0));
        return billColGroup;
    }

    protected BillColGroup loadBillGroupInfo(String entityKey) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        BillColGroup billColGroup = BillImpExpUtils.getColConfig((String)entityKey, (IDataEntityType)entityType, (boolean)true);
        return billColGroup;
    }

    protected List<Long> getSelectedBillIds(IFormView formView, Map<String, Object> params) {
        ArrayList<Long> ids = null;
        String billListKey = null;
        if (params != null) {
            Object val = params.get("EXPORTBILLIDS");
            if (val != null) {
                ids = (ArrayList<Long>)val;
            } else {
                billListKey = (String)params.get("EXPORTBILLLISTKEY");
            }
        }
        if (ids == null) {
            BillList billList;
            if (billListKey == null) {
                billListKey = "billlistap";
            }
            if ((billList = (BillList)formView.getControl(billListKey)) == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u5217\u8868\u63a7\u4ef6%1\u5931\u8d25\u3002", (String)"BillExportStart_3", (String)"epm-eb-formplugin", (Object[])new Object[]{billListKey}));
            }
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            ids = new ArrayList<Long>(selectedRows.size());
            for (ListSelectedRow row : selectedRows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
        }
        this.fireBillIdsFilter(ids);
        if (ids == null || ids.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"BillExportStart_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return ids;
    }

    protected Workbook writeBillObj2File(DynamicObject[] billObjs, BillColGroup billColGroup) {
        if (billObjs == null || billObjs.length == 0) {
            return null;
        }
        Workbook workbook = BillImpExpUtils.buildXFileWithHead((BillColGroup)billColGroup);
        Sheet sheet = workbook.getSheetAt(0);
        Count count = new Count(billColGroup.isShowEntryColGroup() ? 5 : 4);
        for (DynamicObject billObj : billObjs) {
            int beginIndex = count.getCount();
            this.writeBillObj2File(billObj, sheet, count, billColGroup);
            int endIndex = count.getCount() - 1;
            this.fireAfterFillOneBill(billColGroup, billObj, beginIndex, endIndex, sheet);
        }
        this.fireAfterFillFile(count.getCount(), workbook, billColGroup);
        return workbook;
    }

    private void writeBillObj2File(DynamicObject rowObj, Sheet sheet, Count rowCount, BillColGroup billColGroup) {
        if (rowObj == null) {
            return;
        }
        int rowIndex = rowCount.getCount();
        Row row = WriteExcelUtil.getOrCreateRow((int)rowIndex, (Sheet)sheet);
        for (ExcelCol col : billColGroup.getBaseCols().values()) {
            Object val;
            if (col.isNoDB() || (val = col.getVal(rowObj)) == null) continue;
            Cell cell = row.createCell(col.getColIndex());
            if (val instanceof String) {
                cell.setCellValue((String)val);
                continue;
            }
            if (!(val instanceof Pair)) continue;
            Pair baseDataVal = (Pair)val;
            cell.setCellValue((String)baseDataVal.p1);
            Cell cell1 = row.createCell(col.getColIndex() + 1);
            cell1.setCellValue((String)baseDataVal.p2);
        }
        this.fireAfterFillOneEntryRow(billColGroup, rowObj, row);
        if (billColGroup.getChildEntrys().isEmpty()) {
            rowCount.addOne();
        } else {
            for (BillColGroup entry : billColGroup.getChildEntrys().values()) {
                Count newCount = new Count(rowIndex);
                if (!entry.isNoDb()) {
                    DynamicObjectCollection entryRows = rowObj.getDynamicObjectCollection(entry.getGroupKey());
                    for (DynamicObject rowObject : entryRows) {
                        this.writeBillObj2File(rowObject, sheet, newCount, entry);
                    }
                } else {
                    this.fireFillCustomEntry(entry, rowObj, newCount, sheet);
                }
                if (newCount.getCount() == rowIndex) {
                    newCount.addOne();
                }
                if (rowCount.getCount() >= newCount.getCount()) continue;
                rowCount.setCount(newCount.getCount());
            }
        }
    }

    protected DynamicObject[] readBillObjs(List<Long> selectedBillIds) {
        DynamicObject[] result = null;
        if (selectedBillIds.size() > 0) {
            result = BusinessDataServiceHelper.load((Object[])selectedBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)this.getEntityKey()));
            this.fireAfterQueryBillObjs(result);
        }
        return result;
    }

    protected void fireAfterFillOneEntryRow(BillColGroup entryGroup, DynamicObject entryRow, Row row) {
        this.exportHandlers.forEach(handler -> handler.afterFillOneEntryRow(entryGroup, entryRow, row));
    }

    protected void fireFillCustomEntry(BillColGroup entryGroup, DynamicObject parentRow, Count rowCount, Sheet sheet) {
        this.exportHandlers.forEach(handler -> handler.fillCustomEntry(entryGroup, parentRow, rowCount, sheet));
    }

    protected void fireAfterFillOneBill(BillColGroup billGroup, DynamicObject billObj, int beginRowIndex, int endRowIndex, Sheet sheet) {
        this.exportHandlers.forEach(handler -> handler.afterFillOneBill(billGroup, billObj, beginRowIndex, endRowIndex, sheet));
    }

    protected void fireAfterFillFile(int rowCount, Workbook workbook, BillColGroup billColGroup) {
        this.exportHandlers.forEach(handler -> handler.afterFillData(rowCount, workbook, billColGroup));
    }

    protected void fireAfterQueryBillObjs(DynamicObject[] billObjs) {
        if (billObjs != null && billObjs.length > 0) {
            this.exportHandlers.forEach(handler -> handler.afterQueryBillData(billObjs));
        }
    }

    protected void fireBillIdsFilter(List<Long> selectedBillIds) {
        if (selectedBillIds != null) {
            this.exportHandlers.forEach(handler -> handler.filterSelectedBillIds(selectedBillIds));
        }
    }

    protected List<AbstractBillExportHandler> parseImportHandler(IFormView formView, Map<String, Object> params, String entityKey) {
        Object instance;
        ArrayList<AbstractBillExportHandler> result = new ArrayList<AbstractBillExportHandler>(16);
        String handlerClassName = (String)formView.getFormShowParameter().getCustomParam("IMPORTHANDLERCLASSNAME");
        if (StringUtils.isEmpty((String)handlerClassName)) {
            handlerClassName = formView.getPageCache().get("IMPORTHANDLERCLASSNAME");
        }
        if (StringUtils.isEmpty((String)handlerClassName) && params != null) {
            handlerClassName = (String)params.get("IMPORTHANDLERCLASSNAME");
        }
        if (!StringUtils.isEmpty((String)handlerClassName) && (instance = TypesContainer.createInstance((String)handlerClassName)) instanceof AbstractBillExportHandler) {
            result.add((AbstractBillExportHandler)((Object)instance));
        }
        this.parseExportHandlerOnForm(result, entityKey);
        result.forEach(handler -> handler.init(formView, params, entityKey));
        return result;
    }

    protected void parseExportHandlerOnForm(List<AbstractBillExportHandler> result, String entityKey) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityKey);
        if (formConfig != null) {
            List plugins = formConfig.getPlugins();
            try {
                for (Plugin plugin : plugins) {
                    Object instance;
                    String className = plugin.getClassName();
                    if (className == null || !plugin.isEnabled() || !((instance = TypesContainer.createInstance((String)className)) instanceof AbstractBillExportHandler)) continue;
                    result.add((AbstractBillExportHandler)((Object)instance));
                }
            }
            catch (Exception e) {
                log.error("parseExportHandler", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u8fdb\u884c\u5206\u6790\u3002", (String)"BillImportStart_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public String addOpLog(IFormView formView, DynamicObject[] exportedBillObjs) {
        String errorInfo = null;
        try {
            String appId = formView.getFormShowParameter().getAppId();
            StringBuilder logInfoStr = new StringBuilder();
            int sussSize = exportedBillObjs == null ? 0 : exportedBillObjs.length;
            logInfoStr.append(ResManager.loadResFormat((String)"\u6210\u529f\u5bfc\u51fa%1\u884c\u6570\u636e\u3002", (String)"BillExportStart_1", (String)"epm-eb-formplugin", (Object[])new Object[]{sussSize}));
            this.exportHandlers.forEach(handler -> handler.addOpLog(this.getEntityKey(), logInfoStr, exportedBillObjs));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6587\u4ef6\u5bfc\u51fa", "BillExportStart_5", "epm-eb-formplugin");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6210\u529f\u5bfc\u51fa%1$s\u884c\u6570\u636e\u3002", "BillExportStart_6", "epm-eb-formplugin");
            OperationLogUtil.log((String)appId, (String)this.getEntityKey(), null, (String)"export", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[]{String.valueOf(sussSize)});
        }
        catch (Exception exception) {
            log.error("BillExportStart-addOpLog", (Throwable)exception);
            errorInfo = ResManager.loadKDString((String)"\u6dfb\u52a0\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\u3002", (String)"BillImportStart_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return errorInfo;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }
}

