/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.billimpexp.star;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.billimpexp.BaseDataCell;
import kd.epm.eb.business.billimpexp.BillColGroup;
import kd.epm.eb.business.billimpexp.BillImpExpUtils;
import kd.epm.eb.business.billimpexp.ImportContext;
import kd.epm.eb.business.billimpexp.ImportLogger;
import kd.epm.eb.business.billimpexp.col.BaseDataCol;
import kd.epm.eb.business.billimpexp.col.ExcelCol;
import kd.epm.eb.business.billimpexp.col.ItemClassCol;
import kd.epm.eb.business.billimpexp.col.MulBaseDataCol;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.excel.WriteExcelUtil;
import kd.epm.eb.formplugin.billimpexp.handler.AbstractBillImportHandler;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class BillImportStart {
    private ImportContext importContext;
    private Workbook fileBook;
    private BillColGroup billColGroup;
    private Map<String, List<BaseDataCell>> allBaseDatas = new HashMap<String, List<BaseDataCell>>(16);
    private Map<String, Map<String, Set<String>>> allBaseDataNums = new HashMap<String, Map<String, Set<String>>>(16);
    private Map<String, ExcelCol> allColInfo = new HashMap<String, ExcelCol>(16);
    private Map<String, String> allColGroupName = new HashMap<String, String>(16);
    private Map<Long, Integer> rowIndexIdMap = new HashMap<Long, Integer>(16);
    private boolean ignoreSeqColumn = true;
    private Map<String, String> baseDataMapNumProp = new HashMap<String, String>(16);
    private List<AbstractBillImportHandler> impHandlerList = new ArrayList<AbstractBillImportHandler>(16);
    private static final Log log = LogFactory.getLog(BillImportStart.class);
    private boolean showEntryColGroup = false;
    private String entityKey;

    public BillImportStart(String entityKey) {
        this.entityKey = entityKey;
    }

    public boolean initContext(IFormView formView, Map<String, Object> params) {
        Workbook sheets;
        String entityKey = this.getEntityKey();
        String fileUrl = this.getFileUrl(formView, params);
        if (fileUrl == null) {
            return false;
        }
        List<AbstractBillImportHandler> billImportHandlers = this.parseImportHandler(formView, params, entityKey);
        this.importContext = new ImportContext(fileUrl);
        this.importContext.setRowIndexIdMap(this.rowIndexIdMap);
        this.fileBook = sheets = this.readFile(fileUrl);
        this.billColGroup = this.initBillColsInfo(entityKey, billImportHandlers, sheets.getSheetAt(0));
        if (this.checkAndResetBillErrorSign(true)) {
            return false;
        }
        this.impHandlerList.addAll(billImportHandlers);
        this.importContext.setColGroup(this.billColGroup);
        this.importContext.setAllColGroupName(this.allColGroupName);
        this.importContext.setAllColInfo(this.allColInfo);
        billImportHandlers.forEach(handler -> handler.setImportContext(this.importContext));
        return true;
    }

    public boolean importData(IFormView formView, Map<String, Object> args) {
        boolean result = false;
        if (this.initContext(formView, args)) {
            Workbook sheets = this.fileBook;
            Sheet sheet = sheets.getSheetAt(0);
            Map<Integer, DynamicObject> dynamicObjects = this.readBills(sheet, args);
            Set<Integer> errorBillSeqs = this.dealBaseData();
            errorBillSeqs.forEach(dynamicObjects::remove);
            int sussBillSize = dynamicObjects.size();
            this.fireBeforeSaveData(dynamicObjects, sheets, args);
            this.saveData(dynamicObjects);
            int errorBillSize = this.importContext.getErrorBillSeqs().size() + errorBillSeqs.size() + (sussBillSize - dynamicObjects.size());
            result = this.finishImport(formView, dynamicObjects, sheets, sheet, errorBillSize);
        } else if (this.fileBook != null && !this.getLogger().getLogInfos().isEmpty()) {
            this.getLogger().writeLog2Sheet(this.fileBook.getSheetAt(0));
            String fileName = ResManager.loadResFormat((String)"%1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f.xlsx", (String)"BillImportStart_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.billColGroup == null ? "" : this.billColGroup.getTitle()});
            WriteExcelUtil.downFile((IFormView)formView, (Workbook)this.fileBook, (String)fileName);
            formView.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u8be6\u60c5\u3002", (String)"BillImportStart_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean finishImport(IFormView formView, Map<Integer, DynamicObject> dynamicObjects, Workbook sheets, Sheet sheet, int errorBillSize) {
        boolean result = false;
        String suss = ResManager.loadResFormat((String)"\u6210\u529f\u5bfc\u5165%1\u884c\u6570\u636e\u3002", (String)"BillImportStart_1", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObjects.size()});
        String addLogError = this.addOpLog(formView, dynamicObjects, errorBillSize);
        if (this.getLogger().getLogInfos().isEmpty()) {
            IFormView parentView = formView.getParentView();
            parentView.showSuccessNotification(suss, Integer.valueOf(5000));
            if (addLogError != null) {
                parentView.showTipNotification(addLogError, Integer.valueOf(5000));
            }
            formView.sendFormAction(parentView);
            result = true;
        } else {
            this.getLogger().writeLog2Sheet(sheet);
            formView.showTipNotification(ResManager.loadResFormat((String)"\u6210\u529f\u5bfc\u5165%1\u884c\u6570\u636e\uff0c\u5b58\u5728\u56e0\u9519\u8bef\u800c\u672a\u80fd\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"BillImportStart_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObjects.size()}), Integer.valueOf(5000));
            if (addLogError != null) {
                formView.showTipNotification(addLogError);
            }
            WriteExcelUtil.downFile((IFormView)formView, (Workbook)sheets, (String)ResManager.loadResFormat((String)"%1\u5bfc\u5165\u9519\u8bef\u4fe1\u606f.xlsx", (String)"BillImportStart_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.billColGroup.getTitle()}));
        }
        try {
            sheets.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String addOpLog(IFormView formView, Map<Integer, DynamicObject> savedObjs, int errorBillSize) {
        String errorInfo = null;
        try {
            String appId = formView.getFormShowParameter().getAppId();
            StringBuilder logInfoStr = new StringBuilder();
            int sussSize = savedObjs.size();
            logInfoStr.append(ResManager.loadResFormat((String)"\u6210\u529f\u5bfc\u5165%1\u884c\u6570\u636e\uff0c\u5931\u8d25%2\u884c\u6570\u636e\u3002", (String)"BillImportStart_15", (String)"epm-eb-formplugin", (Object[])new Object[]{sussSize, errorBillSize}));
            Collection<DynamicObject> objs = savedObjs.values();
            this.impHandlerList.forEach(handler -> handler.addOpLog(this.getEntityKey(), sussSize, errorBillSize, objs, logInfoStr));
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6587\u4ef6\u5bfc\u5165", "BillImportStart_16", "epm-eb-formplugin");
            MultiLangEnumBridge opDescription = new MultiLangEnumBridge();
            opDescription.setDescription(logInfoStr.toString());
            OperationLogUtil.log((String)appId, (String)this.getEntityKey(), null, (String)"import", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDescription, null);
        }
        catch (Exception exception) {
            log.error("BillImportStart-addOpLog", (Throwable)exception);
            errorInfo = ResManager.loadKDString((String)"\u6dfb\u52a0\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\u3002", (String)"BillImportStart_17", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return errorInfo;
    }

    public void saveData(Map<Integer, DynamicObject> dynamicObjects) {
        if (!dynamicObjects.isEmpty()) {
            try (TXHandle tx = TX.required((String)"saveData");){
                try {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.values().toArray(new DynamicObject[0]));
                    this.impHandlerList.forEach(handler -> handler.finishSaveData(dynamicObjects));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        this.impHandlerList.forEach(handler -> handler.afterSaveData(dynamicObjects));
    }

    protected ImportLogger getLogger() {
        return this.importContext.getImportLogger();
    }

    public void fireBeforeSaveData(Map<Integer, DynamicObject> dynamicObjects, Workbook book, Map<String, Object> args) {
        this.impHandlerList.forEach(handler -> handler.beforeSaveData(dynamicObjects, book, args));
    }

    public Set<Integer> dealBaseData() {
        HashSet<Integer> errorBillSeqs = new HashSet<Integer>(16);
        HashMap baseDataKeyMapCol = new HashMap(16);
        HashMap<String, String> numberPropMap = new HashMap<String, String>(16);
        this.allBaseDatas.keySet().forEach(colKey -> {
            int signIndex;
            ExcelCol col = this.allColInfo.get(colKey);
            if (col instanceof BaseDataCol) {
                BaseDataCol baseDataCol = (BaseDataCol)col;
                String baseEntityId = baseDataCol.getEntityKey();
                if (baseDataCol.isCombineQ()) {
                    List colKeys = baseDataKeyMapCol.computeIfAbsent(baseEntityId, key -> new LinkedList());
                    colKeys.add(colKey);
                }
                numberPropMap.put(baseEntityId, baseDataCol.getNumberProp());
            } else if (col == null && (signIndex = colKey.lastIndexOf("--|--")) != -1) {
                String baseEntityId = colKey.substring(signIndex + "--|--".length());
                String refColKey = colKey.substring(0, signIndex);
                ItemClassCol itemClassCol = (ItemClassCol)this.allColInfo.get(refColKey);
                if (itemClassCol.isCombineQ()) {
                    List colKeys = baseDataKeyMapCol.computeIfAbsent(baseEntityId, key -> new LinkedList());
                    colKeys.add(colKey);
                }
            }
        });
        numberPropMap.putAll(this.baseDataMapNumProp);
        this.allBaseDataNums.forEach((baseDataKey, numbersMap) -> numbersMap.forEach((refColKey, numbers) -> {
            LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
            String numberProp = (String)numberPropMap.get(baseDataKey);
            qFilters.add(new QFilter(numberProp, "in", numbers));
            List permFilter = FilterUtil.buildDataPermissionFilter((String)baseDataKey, (boolean)true, (boolean)true);
            qFilters.addAll(permFilter);
            this.fireBeforeBaseDataQuery((List<QFilter>)qFilters, (String)baseDataKey, (String)refColKey);
            Map<String, Set<Long>> numbMapId = this.queryBaseDataInfo((String)baseDataKey, numberProp, (List<QFilter>)qFilters);
            if (refColKey == null) {
                List colKeys = (List)baseDataKeyMapCol.get(baseDataKey);
                if (colKeys != null) {
                    for (String colKey : colKeys) {
                        this.fillbackBaseDataInfo(colKey, numbMapId, numberProp, errorBillSeqs);
                    }
                }
            } else {
                this.fillbackBaseDataInfo((String)refColKey, numbMapId, numberProp, errorBillSeqs);
            }
        }));
        this.allBaseDatas.clear();
        this.allBaseDataNums.clear();
        return errorBillSeqs;
    }

    private Map<String, Set<Long>> queryBaseDataInfo(String baseDataKey, String numberProp, List<QFilter> qFilters) {
        HashMap<String, Set<Long>> numbMapId = new HashMap<String, Set<Long>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"BillImportStart--dealBaseData", (String)baseDataKey, (String)(numberProp + ",id"), (QFilter[])qFilters.toArray(new QFilter[1]), (String)"");){
            for (kd.bos.algo.Row row : ds) {
                String number = row.getString(numberProp);
                Long id = row.getLong("id");
                Set ids = numbMapId.computeIfAbsent(number, key -> new HashSet());
                ids.add(id);
            }
        }
        return numbMapId;
    }

    private void fillbackBaseDataInfo(String colKey, Map<String, Set<Long>> numbMapId, String numberProp, Set<Integer> errorBillSeqs) {
        String key = colKey;
        int signIndex = colKey.lastIndexOf("--|--");
        if (signIndex != -1) {
            key = colKey.substring(0, signIndex);
        }
        ExcelCol col = this.allColInfo.get(key);
        boolean isMul = col instanceof MulBaseDataCol;
        List<BaseDataCell> baseDataCells = this.allBaseDatas.get(colKey);
        if (!this.fireFillBackBaseDataInfo(baseDataCells, key, numbMapId, numberProp, errorBillSeqs)) {
            for (BaseDataCell baseDataCell : baseDataCells) {
                DynamicObject baseData = baseDataCell.getBaseData();
                if (baseData == null) continue;
                String number = isMul ? baseData.getDynamicObject("fbasedataid").getString(numberProp) : baseData.getString(numberProp);
                Set<Long> ids = numbMapId.get(number);
                if (ids == null || ids.isEmpty()) {
                    errorBillSeqs.add(baseDataCell.getRefBillObjSeq());
                    this.addErrorInfo(key, ResManager.loadResFormat((String)"%1\u4e0d\u5b58\u5728", (String)"BillImportStart_4", (String)"epm-eb-formplugin", (Object[])new Object[]{number}), baseDataCell.getRowIndex());
                    continue;
                }
                if (ids.size() > 1) {
                    errorBillSeqs.add(baseDataCell.getRefBillObjSeq());
                    this.addErrorInfo(key, ResManager.loadResFormat((String)"%1\u503c\u4e0d\u552f\u4e00", (String)"BillImportStart_5", (String)"epm-eb-formplugin", (Object[])new Object[]{number}), baseDataCell.getRowIndex());
                    continue;
                }
                Long id = ids.iterator().next();
                if (isMul) {
                    baseData.getDynamicObject("fbasedataid").set("id", (Object)id);
                    baseData.set("fbasedataid_id", (Object)id);
                    continue;
                }
                baseData.set("id", (Object)id);
            }
        }
    }

    private boolean fireFillBackBaseDataInfo(List<BaseDataCell> baseDataCells, String colKey, Map<String, Set<Long>> numbMapId, String numberProp, Set<Integer> errorBillSeqs) {
        for (AbstractBillImportHandler handler : this.impHandlerList) {
            if (!handler.fillBackBaseDataInfo(baseDataCells, colKey, numbMapId, numberProp, errorBillSeqs)) continue;
            return true;
        }
        return false;
    }

    private void fireBeforeBaseDataQuery(List<QFilter> qFilters, String baseDataKey, String colKey) {
        this.impHandlerList.forEach(handler -> handler.beforeBaseDataQuery(qFilters, baseDataKey, colKey));
    }

    protected BillColGroup initBillColsInfo(String entityKey, List<AbstractBillImportHandler> impHandlerList, Sheet sheet) {
        BillColGroup billColGroup = this.loadBillGroupInfo(entityKey);
        impHandlerList.forEach(handler -> handler.addBillColsInfo(billColGroup));
        if (sheet != null) {
            Map<String, BillColGroup> billColGroupMap = this.readBillColGroupOnFile(sheet);
            this.checkBillColGroup(billColGroupMap, billColGroup);
        } else {
            BillImpExpUtils.updateColIndex((BillColGroup)billColGroup, (Count)new Count(0));
        }
        return billColGroup;
    }

    protected BillColGroup loadBillGroupInfo(String entityKey) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        BillColGroup billColGroup = BillImpExpUtils.getColConfig((String)entityKey, (IDataEntityType)entityType, (boolean)this.ignoreSeqColumn);
        return billColGroup;
    }

    protected Map<String, BillColGroup> readBillColGroupOnFile(Sheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 3) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u5217\u6807\u9898\u884c", (String)"BillImportStart_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Row headRow = sheet.getRow(0);
        Row numberRow = sheet.getRow(this.showEntryColGroup ? 3 : 2);
        Row nameRow = sheet.getRow(this.showEntryColGroup ? 4 : 3);
        Map<String, BillColGroup> entryCols = this.readSign(headRow);
        this.readCols(numberRow, nameRow, entryCols);
        return entryCols;
    }

    private Map<String, BillColGroup> readSign(Row firstRow) {
        HashMap<String, BillColGroup> entryCols = new HashMap<String, BillColGroup>(16);
        if (firstRow != null) {
            int lastCellNum = firstRow.getLastCellNum();
            BillColGroup colGroup = null;
            for (int i = 0; i < lastCellNum; ++i) {
                String val;
                int markIndex;
                CellType cellType;
                Cell cell = firstRow.getCell(i);
                if (cell == null || (cellType = cell.getCellType()) != CellType.STRING || (markIndex = (val = cell.getStringCellValue()).lastIndexOf(35)) < 0) continue;
                String sign = val.substring(markIndex + 1).trim();
                String name = val.substring(0, markIndex).trim();
                if (colGroup != null) {
                    colGroup.setEndIndex(i - 1);
                }
                colGroup = new BillColGroup();
                colGroup.setBeginIndex(i);
                colGroup.setGroupKey(sign);
                colGroup.setTitle(name);
                entryCols.put(sign, colGroup);
            }
            if (colGroup != null) {
                colGroup.setEndIndex(-1);
            }
        }
        return entryCols;
    }

    private void readCols(Row thirdRow, Row fourRow, Map<String, BillColGroup> entryCols) {
        if (thirdRow != null && fourRow != null) {
            entryCols.forEach((key, group) -> {
                int beginIndex = group.getBeginIndex();
                int endIndex = group.getEndIndex();
                if (endIndex == -1) {
                    endIndex = thirdRow.getLastCellNum();
                }
                for (int index = beginIndex; index <= endIndex; ++index) {
                    String colNum = this.getCellStr(thirdRow, index);
                    String colName = this.getCellStr(fourRow, index);
                    if (!StringUtils.isNotEmpty((String)colNum)) continue;
                    ExcelCol col = new ExcelCol(colNum, index);
                    col.setTitle(colName);
                    group.getBaseCols().put(colNum, col);
                }
            });
        }
    }

    private String getCellStr(Row row, int colIndex) {
        Cell cell = row.getCell(colIndex);
        if (cell != null && cell.getCellType() == CellType.STRING) {
            String colStr = cell.getStringCellValue();
            return colStr;
        }
        return null;
    }

    protected boolean checkBillColGroup(Map<String, BillColGroup> entryCols, BillColGroup group) {
        return this.checkBillColGroup(entryCols, group, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkBillColGroup(Map<String, BillColGroup> entryCols, BillColGroup group, boolean firstGroup) {
        String groupKey = group.getGroupKey();
        BillColGroup colGroup = entryCols.get(groupKey);
        if (colGroup == null) {
            if (!group.isMustInput() && !firstGroup) return true;
            this.addErrorInfo(groupKey, ResManager.loadResFormat((String)"\u7f3a\u5c11\u8868\u5934\u6216\u5206\u5f55\uff1a%1\u3002", (String)"BillImportStart_7", (String)"epm-eb-formplugin", (Object[])new Object[]{group.getTitle()}), 2);
            return false;
        } else {
            this.allColGroupName.putAll(group.getColGroupInfo());
            group.setTitle(colGroup.getTitle());
            Map childEntrys = group.getChildEntrys();
            Iterator iterator = childEntrys.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!this.checkBillColGroup(entryCols, (BillColGroup)next.getValue(), false)) continue;
                iterator.remove();
            }
            Map baseCols = group.getBaseCols();
            Iterator baseColIter = baseCols.entrySet().iterator();
            while (baseColIter.hasNext()) {
                Map.Entry colEntry = baseColIter.next();
                ExcelCol colSource = (ExcelCol)colEntry.getValue();
                ExcelCol col = (ExcelCol)colGroup.getBaseCols().get(colEntry.getKey());
                if (col == null) {
                    if (colSource.isMustInput()) {
                        this.addErrorInfo(null, ResManager.loadResFormat((String)"\u5206\u5f55%1\u7f3a\u5c11\u5b57\u6bb5\u5217%2\u3002", (String)"BillImportStart_8", (String)"epm-eb-formplugin", (Object[])new Object[]{this.entityKey, colEntry.getKey()}), 2);
                        continue;
                    }
                    baseColIter.remove();
                    continue;
                }
                colSource.setTitle(col.getTitle());
                colSource.setColIndex(col.getColIndex());
                this.allColInfo.put(col.getKey(), colSource);
            }
        }
        return false;
    }

    private void addErrorInfo(String colKey, String errorInfo, int rowIndex) {
        this.importContext.addErrorInfo(colKey, errorInfo, rowIndex);
    }

    protected Map<Integer, DynamicObject> readBills(Sheet sheet, Map<String, Object> args) {
        HashMap<Integer, DynamicObject> billObjs = new HashMap<Integer, DynamicObject>(16);
        int lastRowNum = sheet.getLastRowNum();
        DynamicObject currentObj = null;
        Count billSeqCount = new Count(0);
        this.importContext.setCurrentBillHasError(false);
        int beginIndex = 4;
        if (this.billColGroup.isShowEntryColGroup()) {
            ++beginIndex;
        }
        for (int rowIndex = beginIndex; rowIndex <= lastRowNum; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            DynamicObject newBillObj = this.readRow(row, rowIndex, billSeqCount, currentObj, this.billColGroup, args);
            int billSeq = billSeqCount.getCount();
            boolean currentBillHasError = this.checkAndResetBillErrorSign(true);
            if (newBillObj != null) {
                currentObj = newBillObj;
                if (!currentBillHasError) {
                    billObjs.put(billSeq, newBillObj);
                } else {
                    this.addErrorBillSeq(billSeq);
                }
            } else if (currentBillHasError) {
                billObjs.remove(billSeq);
                this.addErrorBillSeq(billSeq);
            }
            if (newBillObj != null) {
                this.finishReadOneBill(billSeq - 1, billObjs);
            }
            if (rowIndex == lastRowNum) {
                this.finishReadOneBill(billSeq, billObjs);
            }
            if (!this.fireAfterReadRow(row, rowIndex, billSeq, currentObj)) continue;
            billObjs.remove(billSeq);
            this.addErrorBillSeq(billSeq);
        }
        return billObjs;
    }

    private void finishReadOneBill(int billSeq, Map<Integer, DynamicObject> billObjs) {
        DynamicObject preObj = billObjs.get(billSeq);
        if (this.fireAfterReadOneBill(billSeq, preObj)) {
            billObjs.remove(billSeq);
            this.addErrorBillSeq(billSeq);
        }
    }

    private boolean fireAfterReadOneBill(int billSeq, DynamicObject billObj) {
        if (billObj != null) {
            this.checkEntryMusinput(billObj, this.billColGroup);
            if (this.checkAndResetBillErrorSign(true)) {
                return true;
            }
            if (!this.checkBillHasError(billSeq)) {
                for (AbstractBillImportHandler handler : this.impHandlerList) {
                    handler.afterReadOneBill(billSeq, billObj);
                    if (!this.checkAndResetBillErrorSign(true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean checkBillHasError(int billSeq) {
        return this.importContext.getErrorBillSeqs().contains(billSeq);
    }

    protected void addErrorBillSeq(int billSeq) {
        this.importContext.getErrorBillSeqs().add(billSeq);
    }

    private void checkEntryMusinput(DynamicObject billObj, BillColGroup billColGroup) {
        if (billObj != null) {
            Long objId = billObj.getLong("id");
            Integer rowIndex = this.rowIndexIdMap.get(objId);
            List<BillColGroup> musinputGroup = billColGroup.getChildEntrys().values().stream().filter(BillColGroup::isMustInput).collect(Collectors.toList());
            if (musinputGroup.size() > 0) {
                musinputGroup.forEach(entryGroup -> {
                    DynamicObjectCollection objectCollection = billObj.getDynamicObjectCollection(entryGroup.getGroupKey());
                    if (objectCollection.isEmpty()) {
                        this.addErrorInfo(billColGroup.getGroupKey(), ResManager.loadResFormat((String)"\u5fc5\u586b\u9879\u5206\u5f55%1\u4e3a\u7a7a\u3002", (String)"BillImportStart_9", (String)"epm-eb-formplugin", (Object[])new Object[]{entryGroup.getTitle()}), rowIndex);
                    } else if (entryGroup.getChildEntrys().size() > 0) {
                        objectCollection.forEach(entryRow -> this.checkEntryMusinput((DynamicObject)entryRow, (BillColGroup)entryGroup));
                    }
                });
            }
        }
    }

    private void fireAfterReadGroupBase(int rowIndex, Row row, BillColGroup colGroup, int billSeq, DynamicObject groupObj) {
        if (groupObj != null && !this.checkBillHasError(billSeq)) {
            for (AbstractBillImportHandler handler : this.impHandlerList) {
                if (this.checkAndResetBillErrorSign(false)) {
                    return;
                }
                handler.afterReadOneGroupBase(rowIndex, row, colGroup, billSeq, groupObj);
            }
        }
    }

    private boolean fireAfterReadRow(Row row, int rowIndex, int billSeq, DynamicObject billObj) {
        if (billObj != null && row != null && !this.checkBillHasError(billSeq)) {
            for (AbstractBillImportHandler handler : this.impHandlerList) {
                handler.afterReadRow(row, rowIndex, billSeq, billObj);
                if (!this.checkAndResetBillErrorSign(true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAndResetBillErrorSign(boolean reset) {
        boolean currentBillHasError = false;
        if (this.importContext.isCurrentBillHasError()) {
            currentBillHasError = true;
            if (reset) {
                this.importContext.setCurrentBillHasError(false);
            }
        }
        return currentBillHasError;
    }

    protected DynamicObject readRow(Row row, int rowIndex, Count billSeq, DynamicObject parentObj, BillColGroup colGroup, Map<String, Object> args) {
        DynamicObject nextObj;
        if (row == null) {
            return null;
        }
        Map<String, Object> baseInfo = this.readEntryBaseInfo(row, colGroup.getBaseCols());
        boolean isNew = false;
        if (!baseInfo.isEmpty()) {
            if (this.getEntityKey().equals(colGroup.getGroupKey())) {
                billSeq.addOne();
            }
            nextObj = this.buildObj(parentObj, colGroup, baseInfo, rowIndex, billSeq.getCount(), args);
            this.fireAfterReadGroupBase(rowIndex, row, colGroup, billSeq.getCount(), nextObj);
            isNew = true;
        } else {
            nextObj = this.getNextParent(parentObj, colGroup);
        }
        if (nextObj != null) {
            for (BillColGroup entryGroup : colGroup.getChildEntrys().values()) {
                DynamicObject object = this.readRow(row, rowIndex, billSeq, nextObj, entryGroup, args);
                if (object == null) continue;
                DynamicObjectCollection collection = nextObj.getDynamicObjectCollection(entryGroup.getGroupKey());
                object.set("seq", (Object)(collection.size() + 1));
                collection.add((Object)object);
            }
        }
        return isNew ? nextObj : null;
    }

    private DynamicObject getNextParent(DynamicObject parentObj, BillColGroup colGroup) {
        if (parentObj != null && !this.getEntityKey().equals(colGroup.getGroupKey())) {
            DynamicObjectCollection collection = parentObj.getDynamicObjectCollection(colGroup.getGroupKey());
            parentObj = !collection.isEmpty() ? (DynamicObject)collection.get(collection.size() - 1) : null;
        }
        return parentObj;
    }

    private DynamicObject buildObj(DynamicObject parentObj, BillColGroup colGroup, Map<String, Object> baseInfo, int rowIndex, int billSeq, Map<String, Object> args) {
        DynamicObject newObj = this.doBuildObj(colGroup, parentObj, args);
        if (newObj != null) {
            for (ExcelCol col : colGroup.getBaseCols().values()) {
                if (col.isNoDB()) continue;
                Object val = baseInfo.get(col.getKey());
                String checkResult = col.setVal(val, newObj);
                if (checkResult != null) {
                    this.addErrorInfo(col.getKey(), checkResult, rowIndex);
                    continue;
                }
                this.selectBaseDataCells(col, newObj, rowIndex, billSeq);
            }
            Long pkId = GlobalIdUtil.genGlobalLongId();
            newObj.set("id", (Object)pkId);
            this.rowIndexIdMap.put(pkId, rowIndex);
        }
        return newObj;
    }

    protected DynamicObject doBuildObj(BillColGroup billColGroup, DynamicObject parentObj, Map<String, Object> args) {
        String groupKey = billColGroup.getGroupKey();
        DynamicObject newObj = null;
        if (this.getEntityKey().equals(groupKey)) {
            newObj = BusinessDataServiceHelper.newDynamicObject((String)groupKey);
        } else if (parentObj != null) {
            newObj = (DynamicObject)parentObj.getDynamicObjectCollection(groupKey).getDynamicObjectType().createInstance();
        }
        return newObj;
    }

    private void selectBaseDataCells(ExcelCol col, DynamicObject newObj, int rowIndex, int billSeq) {
        if (col instanceof BaseDataCol) {
            BaseDataCol baseDataCol = (BaseDataCol)col;
            String numberProp = baseDataCol.getNumberProp();
            String entityKey = baseDataCol.getEntityKey();
            if (baseDataCol instanceof MulBaseDataCol) {
                DynamicObjectCollection dynamicObjects = newObj.getDynamicObjectCollection(col.getRealKey());
                if (dynamicObjects != null) {
                    for (DynamicObject obj : dynamicObjects) {
                        DynamicObject baseDataObj = obj.getDynamicObject("fbasedataid");
                        this.selectBaseDataNumbs(baseDataCol.isCombineQ(), baseDataCol.getKey(), numberProp, entityKey, baseDataObj);
                        List baseDataCells = this.allBaseDatas.computeIfAbsent(col.getKey(), key -> new LinkedList());
                        baseDataCells.add(new BaseDataCell(obj, rowIndex, billSeq));
                    }
                }
            } else {
                DynamicObject dynamicObject = newObj.getDynamicObject(col.getRealKey());
                if (dynamicObject != null) {
                    String colKey = col.getKey();
                    if (baseDataCol instanceof ItemClassCol) {
                        BasedataEntityType basedataEntityType = (BasedataEntityType)dynamicObject.getDynamicObjectType();
                        entityKey = basedataEntityType.getName();
                        numberProp = this.baseDataMapNumProp.computeIfAbsent(entityKey, key -> basedataEntityType.getNumberProperty());
                        colKey = colKey + "--|--" + entityKey;
                    }
                    this.selectBaseDataNumbs(baseDataCol.isCombineQ(), colKey, numberProp, entityKey, dynamicObject);
                    List baseDataCells = this.allBaseDatas.computeIfAbsent(colKey, key -> new LinkedList());
                    baseDataCells.add(new BaseDataCell(dynamicObject, rowIndex, billSeq));
                }
            }
        }
    }

    private void selectBaseDataNumbs(boolean isCombineQ, String recordKey, String numberProp, String baseEntityKey, DynamicObject dynamicObject) {
        String number = dynamicObject.getString(numberProp);
        Map numbersMap = this.allBaseDataNums.computeIfAbsent(baseEntityKey, key -> new HashMap(16));
        String key2 = isCombineQ ? null : recordKey;
        Set numbers = numbersMap.computeIfAbsent(key2, k -> new HashSet(16));
        numbers.add(number);
    }

    private Map<String, Object> readEntryBaseInfo(Row row, Map<String, ExcelCol> baseCols) {
        HashMap<String, Object> vals = new HashMap<String, Object>(baseCols.size());
        baseCols.values().forEach(col -> {
            String realKey = col.getKey();
            Cell cell = row.getCell(col.getColIndex());
            if (cell != null) {
                CellType cellType = cell.getCellType();
                if (cellType == CellType.STRING) {
                    String val = cell.getStringCellValue();
                    if (val != null && !(val = val.trim()).isEmpty()) {
                        vals.put(realKey, val);
                    }
                } else if (cellType == CellType.NUMERIC) {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        vals.put(realKey, cell.getDateCellValue());
                    } else {
                        vals.put(realKey, cell.getNumericCellValue());
                    }
                } else if (cellType == CellType.BOOLEAN) {
                    vals.put(realKey, cell.getBooleanCellValue());
                }
            }
        });
        return vals;
    }

    protected String getEntityKey() {
        return this.entityKey;
    }

    protected void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    private Workbook readFile(String fileUrl) {
        Workbook Workbook2;
        if (StringUtils.isEmpty((String)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a", (String)"BillImportStart_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        try (InputStream fileInputStream = UploadUtil.getFileInputStream((String)fileUrl);){
            Workbook2 = WorkbookFactory.create((InputStream)fileInputStream);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684Excel\u683c\u5f0f\u7684\u6587\u4ef6\u3002", (String)"BillImportStart_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return Workbook2;
    }

    protected List<AbstractBillImportHandler> parseImportHandler(IFormView formView, Map<String, Object> params, String entityKey) {
        Object instance;
        ArrayList<AbstractBillImportHandler> result = new ArrayList<AbstractBillImportHandler>(16);
        String handlerClassName = (String)formView.getFormShowParameter().getCustomParam("IMPORTHANDLERCLASSNAME");
        if (StringUtils.isEmpty((String)handlerClassName)) {
            handlerClassName = formView.getPageCache().get("IMPORTHANDLERCLASSNAME");
        }
        if (StringUtils.isEmpty((String)handlerClassName) && params != null) {
            handlerClassName = (String)params.get("IMPORTHANDLERCLASSNAME");
        }
        if (!StringUtils.isEmpty((String)handlerClassName) && (instance = TypesContainer.createInstance((String)handlerClassName)) instanceof AbstractBillImportHandler) {
            result.add((AbstractBillImportHandler)((Object)instance));
        }
        this.parseImportHandlerOnForm(result, entityKey);
        result.forEach(handler -> handler.init(formView, params, entityKey));
        return result;
    }

    protected void parseImportHandlerOnForm(List<AbstractBillImportHandler> result, String entityKey) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)entityKey);
        if (formConfig != null) {
            List plugins = formConfig.getPlugins();
            try {
                for (Plugin plugin : plugins) {
                    Object instance;
                    String className = plugin.getClassName();
                    if (className == null || !plugin.isEnabled() || !((instance = TypesContainer.createInstance((String)className)) instanceof AbstractBillImportHandler)) continue;
                    result.add((AbstractBillImportHandler)((Object)instance));
                }
            }
            catch (Exception e) {
                log.error("parseImportHandler", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u8fdb\u884c\u5206\u6790\u3002", (String)"BillImportStart_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected String getFileUrl(IFormView formView, Map<String, Object> params) {
        IPageCache pageCache = formView.getPageCache();
        String fileUrl = pageCache.get("file_url");
        String result = null;
        if (fileUrl != null) {
            List urls = (List)SerializationUtils.fromJsonString((String)fileUrl, List.class);
            if (urls.size() == 0) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"BillImportStart_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (urls.size() > 1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5904\u7406\u5355\u4e2a\u6587\u4ef6\u3002", (String)"BillImportStart_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                result = (String)urls.get(0);
            }
        } else {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"BillImportStart_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public BillColGroup getBillColGroup() {
        return this.billColGroup;
    }

    public void dowmTemplate(IFormView formView, Map<String, Object> params, String templateName) {
        String entityKey = this.getEntityKey();
        List<AbstractBillImportHandler> billImportHandlers = this.parseImportHandler(formView, params, entityKey);
        BillColGroup colGroup = this.initBillColsInfo(entityKey, billImportHandlers, null);
        Workbook workbook = BillImpExpUtils.buildXFileWithHead((BillColGroup)colGroup);
        billImportHandlers.forEach(handler -> handler.afterBuildBillTemplate(workbook, colGroup));
        WriteExcelUtil.downFile((IFormView)formView, (Workbook)workbook, (String)ResManager.loadResFormat((String)"%1\u6a21\u677f.xlsx", (String)"BillImportStart_13", (String)"epm-eb-formplugin", (Object[])new Object[]{templateName}));
    }

    public boolean isIgnoreSeqColumn() {
        return this.ignoreSeqColumn;
    }

    public void setIgnoreSeqColumn(boolean ignoreSeqColumn) {
        this.ignoreSeqColumn = ignoreSeqColumn;
    }

    public void setShowEntryColGroup(boolean showEntryColGroup) {
        this.showEntryColGroup = showEntryColGroup;
    }
}

