/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bizRuleGroup2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.quote.QuoteRegDataCheck;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.orm.EbBizruleset;
import kd.epm.eb.common.orm.EbBizrulesetStatusEnum;
import kd.epm.eb.common.pojo.ExecuteRuleCasePojo;
import kd.epm.eb.common.pojo.ReturnDataToParentPojo;
import kd.epm.eb.common.rule.edit.OpenRulePojo;
import kd.epm.eb.common.rule.edit.OpenRulePojoTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.LockUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OrmBuilder;
import kd.epm.eb.formplugin.bizRuleGroup2.BizRuleGroupList2;
import kd.epm.eb.formplugin.bizRuleGroup2.BizRuleGroupListContext;
import kd.epm.eb.formplugin.bizRuleGroup2.RuleGroupListPlugin2Constant;
import kd.epm.eb.formplugin.rulebatch.OpenRuleBatchPojo;
import kd.epm.eb.formplugin.rulebatch.OpenRuleBatchPojoTypeEnum;
import kd.epm.eb.formplugin.rulebatch.RuleBatchListPageContextPojo;
import kd.epm.eb.formplugin.rulebatch.RuleBatchListUtils;
import kd.epm.eb.formplugin.rulebatch.RuleBatchUtils;
import kd.epm.eb.formplugin.rulemanage.RelationGraphService;
import kd.epm.eb.formplugin.rulemanage.RuleManagePlugin3;
import kd.epm.eb.formplugin.rulemanage.RuleReleaseUtils;
import kd.epm.eb.formplugin.rulemanage.ruleexecute.ExecuteRuleCaseUtils;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BizRuleGroupListPlugin2
extends BizRuleGroupList2
implements RuleGroupListPlugin2Constant {
    private static Log log = LogFactory.getLog(BizRuleGroupListPlugin2.class);

    @Override
    public void initialize() {
        try {
            this.formPlugin = this;
            this.dataModel = this.getModel();
            super.initialize();
            FilterContainer fc = (FilterContainer)this.getControl("filtercontainerule");
            if (fc != null) {
                fc.getContext();
                fc.setBillFormId("eb_bizruleset");
                fc.addSearchClickListener(event -> {
                    FilterParameter filterParameter = event.getFilterParameter();
                    List qFilters = filterParameter.getQFilters();
                    List fastQFilters = event.getFastQFilters();
                    qFilters.addAll(fastQFilters);
                    this.getPageCache().put("searchFilters", SerializationUtils.serializeToBase64((Object)qFilters));
                    this.refreshBillList();
                });
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"BizRuleGroupListPlugin2#initialize", (Throwable)e);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        try {
            super.itemClick(evt);
            String key = evt.getItemKey();
            BillList billList = (BillList)this.getControl("billlistap");
            this.getPageCache().get("KEY_MODEL_ID");
            switch (key) {
                case "bar_add": {
                    LambdaUtils.run(() -> {
                        OpenRulePojo openRulePojo = new OpenRulePojo();
                        openRulePojo.setTypeString(OpenRulePojoTypeEnum.NEW.name());
                        openRulePojo.setModelIdLong(this.getModelId());
                        openRulePojo.setBusinessModelIdLong(this.getBizModelId());
                        RuleUtils.openRule(this.getView(), openRulePojo);
                    });
                    break;
                }
                case "bar_edit": {
                    LambdaUtils.run(() -> {
                        ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                        if (listSelectedRowCollection == null || listSelectedRowCollection.size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List<Long> ruleIdLongList = listSelectedRowCollection.stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                        RuleBatchUtils.checkRuleBatchRule(ruleIdLongList);
                        OpenRulePojo openRulePojo = new OpenRulePojo();
                        openRulePojo.setRuleIdLongList(ruleIdLongList);
                        openRulePojo.setTypeString(OpenRulePojoTypeEnum.EDIT.name());
                        RuleUtils.openRule(this.getView(), openRulePojo);
                    });
                    break;
                }
                case "bar_delete": {
                    LambdaUtils.run(() -> {
                        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        Set<Long> ruleIdLongSet = billList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toSet());
                        RuleBatchUtils.checkRuleBatchRule(ruleIdLongSet);
                        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fnumber"}).whereEqual("fstatus", (Object)EbBizrulesetStatusEnum.ENABLE.getDbStatusString()).whereIn("fid", ruleIdLongSet).toRowList();
                        if (CollectionUtils.isNotEmpty((Collection)ebBizrulesetList)) {
                            String cententString = ebBizrulesetList.stream().map(item -> item.getNumberString()).collect(Collectors.joining(","));
                            throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u5e03\u72b6\u6001\u7684\u89c4\u5219\u201c%1\u201d\u65e0\u6cd5\u76f4\u63a5\u5220\u9664\u3002", (String)"BizRuleGroupListPlugin2_45", (String)"epm-eb-formplugin", (Object[])new Object[]{cententString}));
                        }
                        CheckQuote checkQuote = QuoteBuilder.build((Long)this.getModelId(), (Long)0L, ruleIdLongSet, (MemberTypeEnum)MemberTypeEnum.RULE);
                        QuoteCheckResult check = QuoteRegDataCheck.get().checkQuoteResult(checkQuote);
                        if (check.isHasQuote()) {
                            this.getView().showMessage(ResManager.loadKDString((String)"\u89c4\u5219\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664", (String)"DimDeleteAction_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), check.getMsg(), MessageTypes.Default);
                            return;
                        }
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"BizRuleGroupListPlugin2_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletebizrule_comfirm", (IFormPlugin)this));
                    });
                    break;
                }
                case "bar_refresh": {
                    this.resetFilter();
                    break;
                }
                case "bar_updaterule": {
                    LockUtils.lock((String)(RuleManagePlugin3.class.getName() + this.getModelId()), () -> this.updateRules());
                    this.writeLog("update", new MultiLangEnumBridge("\u5347\u7ea7\u89c4\u5219\u4f9d\u8d56", "BizRuleGroupListPlugin2_47", "epm-eb-formplugin"), new MultiLangEnumBridge("\u89c4\u5219\u4f9d\u8d56\u5347\u7ea7\u6210\u529f\u3002", "BizRuleGroupListPlugin2_48", "epm-eb-formplugin"));
                    break;
                }
                case "bar_updateold": {
                    LockUtils.lock((String)(RuleManagePlugin3.class.getName() + this.getModelId()), () -> {
                        Throwable throwable = null;
                        try {
                            this.updateOld();
                            RuleUtils.fixErrorData(this.getModelId());
                            RuleUtils.createMemberReference(this.getModelId());
                        }
                        catch (Throwable e) {
                            throwable = e;
                        }
                        if (!RuleUtils.checkExistErrorBoolean(this.getModelId(), this.getView()) && throwable != null) {
                            throw new KDBizException(throwable.getMessage());
                        }
                    });
                    this.writeLog("update", new MultiLangEnumBridge("\u5347\u7ea7\u65e7\u89c4\u5219", "BizRuleGroupListPlugin2_53", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5347\u7ea7\u65e7\u89c4\u5219\u6210\u529f", "BizRuleGroupListPlugin2_55", "epm-eb-formplugin"));
                    break;
                }
                case "bar_graphlog": {
                    this.showGraphLog();
                    break;
                }
                case "bar_executecase2": {
                    this.executeCase();
                    break;
                }
                case "bar_executecaseold": {
                    this.executeCaseOld();
                    break;
                }
                case "bar_executeinstance": {
                    this.showInstanLog();
                    break;
                }
                case "relation_graph": {
                    LambdaUtils.run(() -> {
                        ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                        if (CollectionUtils.isEmpty((Collection)listSelectedRowCollection) || listSelectedRowCollection.size() != 1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"RelationGraphPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        RelationGraphService.openRelationGraphByRuleIdLong(this.getView(), ObjUtils.getLong((Object)listSelectedRowCollection.get(0).getPrimaryKeyValue()));
                    });
                    break;
                }
                case "force_unlock": {
                    LockUtils.forceUnlock((String)(RuleManagePlugin3.class.getName() + this.getModelId()));
                    break;
                }
                case "variable_set": {
                    this.showVariableSetFrom();
                    break;
                }
                case "check_ruleenlarge": {
                    RuleUtils.checkRuleEnlarge(this.getView(), this.getModelId());
                    break;
                }
                case "btn_release": {
                    LambdaUtils.run(() -> {
                        BillList ruleBillList = (BillList)this.getControl("billlistap");
                        if (ruleBillList.getSelectedRows() == null || ruleBillList.getSelectedRows().size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List<Long> ruleIdLongList = ruleBillList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                        RuleBatchUtils.checkRuleBatchRule(ruleIdLongList);
                        RuleReleaseUtils.openRuleReleasePlugin(this.getView(), ruleIdLongList, new CloseCallBack((IFormPlugin)this, "RULE_RELEASE_PLUGIN_CLOSE_CALL_BACK_ACTION_ID_STRING"));
                    });
                    break;
                }
                case "btn_cancel_release": {
                    LambdaUtils.run(() -> {
                        BillList ruleBillList = (BillList)this.getControl("billlistap");
                        if (ruleBillList.getSelectedRows() == null || ruleBillList.getSelectedRows().size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        LockUtils.lock((String)(RuleManagePlugin3.class.getName() + this.getModelId()), () -> {
                            List<Long> ruleIdLongList = ruleBillList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                            RuleBatchUtils.checkRuleBatchRule(ruleIdLongList);
                            RuleUtils.cancelRelease(ruleIdLongList);
                            this.writeLog("cancel", new MultiLangEnumBridge("\u53d6\u6d88\u53d1\u5e03", "RuleReleasePlugin_15", "epm-eb-formplugin"), new MultiLangEnumBridge("\u53d6\u6d88\u53d1\u5e03\u6210\u529f", "RuleReleasePlugin_16", "epm-eb-formplugin"));
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f", (String)"RuleManagePlugin3_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            this.refreshAll();
                        });
                    });
                    break;
                }
                case "btn_copy_rule": {
                    LambdaUtils.run(() -> {
                        BillList ruleBillList = (BillList)this.getControl("billlistap");
                        if (ruleBillList.getSelectedRows() == null || ruleBillList.getSelectedRows().size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List<Long> ruleIdLongList = ruleBillList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                        RuleBatchUtils.checkRuleBatchRule(ruleIdLongList);
                        OpenRulePojo openRulePojo = new OpenRulePojo();
                        openRulePojo.setTypeString(OpenRulePojoTypeEnum.COPY.name());
                        openRulePojo.setRuleIdLongList(ruleIdLongList);
                        openRulePojo.setModelIdLong(this.getModelId());
                        openRulePojo.setBusinessModelIdLong(this.getBizModelId());
                        RuleUtils.openRule(this.getView(), openRulePojo);
                    });
                    break;
                }
                case "remove_mutex": {
                    LambdaUtils.run(() -> {
                        BillList ruleBillList = (BillList)this.getControl("billlistap");
                        if (ruleBillList.getSelectedRows() == null || ruleBillList.getSelectedRows().size() == 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        List<Long> ruleIdLongList = ruleBillList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toList());
                        RuleUtils.removeRuleMutexPojoList(this.getModelId(), ruleIdLongList);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f", (String)"RuleManagePlugin3_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "rule_batch": {
                    LambdaUtils.run(() -> {
                        RuleBatchListPageContextPojo ruleBatchListPageContextPojo = new RuleBatchListPageContextPojo();
                        ruleBatchListPageContextPojo.setModelIdLong(this.getModelId());
                        RuleBatchListUtils.open(this.getView(), ruleBatchListPageContextPojo, new CloseCallBack((IFormPlugin)this, "rule_batch"));
                    });
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"BizRuleGroupListPlugin2#itemClick", (Throwable)e);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        try {
            String callBackId;
            super.confirmCallBack(mbce);
            switch (callBackId = mbce.getCallBackId()) {
                case "deletebizrule_comfirm": {
                    if (!mbce.getResult().equals((Object)MessageBoxResult.Yes)) break;
                    LockUtils.lock((String)(RuleManagePlugin3.class.getName() + this.getModelId()), () -> {
                        BillList billList = (BillList)this.getControl("billlistap");
                        Set<Long> ruleIdLongSet = billList.getSelectedRows().stream().map(item -> ObjUtils.getLong((Object)item.getPrimaryKeyValue())).collect(Collectors.toSet());
                        if (CollectionUtils.isEmpty(ruleIdLongSet)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4e1a\u52a1\u89c4\u5219\u3002", (String)"BizRuleGroupListPlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        RuleBatchUtils.checkRuleBatchRule(ruleIdLongSet);
                        List ebBizrulesetList = OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"fnumber"}).whereEqual("fstatus", (Object)EbBizrulesetStatusEnum.ENABLE.getDbStatusString()).whereIn("fid", ruleIdLongSet).toRowList();
                        if (CollectionUtils.isNotEmpty((Collection)ebBizrulesetList)) {
                            String cententString = ebBizrulesetList.stream().map(item -> item.getNumberString()).collect(Collectors.joining(","));
                            throw new KDBizException(ResManager.loadResFormat((String)"\u53d1\u5e03\u72b6\u6001\u7684\u89c4\u5219\u201c%1\u201d\u65e0\u6cd5\u76f4\u63a5\u5220\u9664\u3002", (String)"BizRuleGroupListPlugin2_45", (String)"epm-eb-formplugin", (Object[])new Object[]{cententString}));
                        }
                        RuleUtils.deleteRule(this.getModelId(), ruleIdLongSet);
                        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BizRuleGroupListPlugin2_31", "epm-eb-formplugin"), new MultiLangEnumBridge("\u4e1a\u52a1\u89c4\u5219\u5220\u9664\u6210\u529f\u3002", "BizRuleGroupListPlugin2_32", "epm-eb-formplugin"));
                        this.refreshAll();
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"RuleManagePlugin2_101", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    });
                    break;
                }
                case "refresh_comfirm": {
                    this.refreshAll();
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"BizRuleGroupListPlugin2#confirmCallBack", (Throwable)e);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        try {
            String fieldName;
            super.hyperLinkClick(hyperLinkClickEvent);
            switch (fieldName = hyperLinkClickEvent.getFieldName()) {
                case "rule_number": 
                case "number": {
                    LambdaUtils.run(() -> {
                        BillList list = (BillList)hyperLinkClickEvent.getSource();
                        Map<Long, String> ruleMap = this.getSelectRuleIdAndName(list);
                        OpenRulePojo openRulePojo = new OpenRulePojo();
                        openRulePojo.setModelIdLong(this.getModelId());
                        openRulePojo.setRuleIdLongList(new ArrayList<Long>(ruleMap.keySet()));
                        RuleUtils.openRule(this.getView(), openRulePojo);
                    });
                    break;
                }
                case "rulebatch_number": {
                    LambdaUtils.run(() -> {
                        Long primaryKeyLong = ObjUtils.getLong((Object)((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId());
                        EbBizruleset ebBizruleset = (EbBizruleset)OrmBuilder.clazz(EbBizruleset.class).field(new String[]{"frulebatch", "fmodel"}).whereEqual("fid", (Object)primaryKeyLong).getTarget();
                        if (ebBizruleset == null) {
                            this.refreshAll();
                            return;
                        }
                        OpenRuleBatchPojo openRuleBatchPojo = new OpenRuleBatchPojo();
                        openRuleBatchPojo.setModelIdLong(ebBizruleset.getModelLong());
                        openRuleBatchPojo.setRuleBatchIdLong(ebBizruleset.getRulebatchLong());
                        openRuleBatchPojo.setTypeString(OpenRuleBatchPojoTypeEnum.OPEN.name());
                        RuleBatchUtils.open(this.getView(), openRuleBatchPojo);
                    });
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"BizRuleGroupListPlugin2#hyperLinkClick", (Throwable)e);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        try {
            String actionId;
            super.closedCallBack(evt);
            switch (actionId = evt.getActionId()) {
                case "eb_bizruleset": {
                    this.refreshAll();
                    break;
                }
                case "bizmodelclick": {
                    ListSelectedRowCollection returnData;
                    if (evt.getReturnData() instanceof ListSelectedRowCollection && (returnData = (ListSelectedRowCollection)evt.getReturnData()).size() > 0) {
                        String bizModelId = returnData.get(0).getPrimaryKeyValue().toString();
                        this.getModel().setValue("bizmodel", (Object)bizModelId);
                        UserSelectUtils.saveUserSelectBusinessModelId((IFormView)this.getView(), (long)this.getModelId(), (long)Long.parseLong(bizModelId));
                        this.setBizModelCache(bizModelId);
                        this.updateBizModelLabels();
                        this.clearTreeCache();
                        this.refreshAll();
                        CacheUtils.put((IPageCache)this.getPageCache(), (Object)new BizRuleGroupListContext());
                    }
                    break;
                }
                case "RULE_RELEASE_PLUGIN_CLOSE_CALL_BACK_ACTION_ID_STRING": {
                    LambdaUtils.run(() -> {
                        String jsonString = ObjUtils.getString((Object)evt.getReturnData());
                        if (StringUtils.isBlank((CharSequence)jsonString)) {
                            return;
                        }
                        ReturnDataToParentPojo returnDataToParentPojo = (ReturnDataToParentPojo)JsonUtils.readValue((String)jsonString, ReturnDataToParentPojo.class);
                        if (returnDataToParentPojo == null || StringUtils.isBlank((CharSequence)returnDataToParentPojo.getTypeString())) {
                            return;
                        }
                        switch (returnDataToParentPojo.getTypeString()) {
                            case "btn_release": {
                                LambdaUtils.run(() -> {
                                    this.clearTreeCache();
                                    this.refreshAll();
                                });
                                break;
                            }
                            case "btn_release_and_execute": {
                                LambdaUtils.run(() -> {
                                    this.clearTreeCache();
                                    this.refreshAll();
                                    ExecuteRuleCasePojo executeRuleCasePojo = (ExecuteRuleCasePojo)JsonUtils.readValue((String)returnDataToParentPojo.getParamString(), ExecuteRuleCasePojo.class);
                                    ExecuteRuleCaseUtils.open(this.getView(), executeRuleCasePojo, null);
                                });
                                break;
                            }
                        }
                    });
                    break;
                }
                case "btn_batch_modify": {
                    LambdaUtils.run(() -> {
                        String jsonString = ObjUtils.getString((Object)evt.getReturnData());
                        if (StringUtils.isBlank((CharSequence)jsonString)) {
                            return;
                        }
                        ReturnDataToParentPojo returnDataToParentPojo = (ReturnDataToParentPojo)JsonUtils.readValue((String)jsonString, ReturnDataToParentPojo.class);
                        if (returnDataToParentPojo == null || StringUtils.isBlank((CharSequence)returnDataToParentPojo.getTypeString())) {
                            return;
                        }
                        if ("btnok".equals(returnDataToParentPojo.getTypeString())) {
                            LambdaUtils.run(() -> {
                                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u6210\u529f", (String)"RuleBatchModifyPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                                this.clearTreeCache();
                                this.refreshAll();
                            });
                        }
                    });
                    break;
                }
                default: {
                    this.clearTreeCache();
                    this.refreshAll();
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"BizRuleGroupListPlugin2#closedCallBack", (Throwable)e);
        }
    }

    @Override
    public void click(EventObject evt) {
        try {
            Control c = (Control)evt.getSource();
            switch (c.getKey().toLowerCase()) {
                case "bizmodelselect": {
                    this.showBizModelForm();
                    break;
                }
                case "searchbeforedepend": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(this.getControlNameString("bizrulecatalog", "depend"), TreeSearchUtil.SearchBtnStatus.LEFT));
                    break;
                }
                case "searchnextdepend": {
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(this.getControlNameString("bizrulecatalog", "depend"), TreeSearchUtil.SearchBtnStatus.RIGHT));
                    break;
                }
                case "searchbeforedata": {
                    TreeSearchUtil.TreeSearchParam treeSearchParam = new TreeSearchUtil.TreeSearchParam(this.getControlNameString("bizrulecatalog", "data"), "treelistdata1", "data", TreeSearchUtil.SearchBtnStatus.LEFT);
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), treeSearchParam);
                    break;
                }
                case "searchnextdata": {
                    TreeSearchUtil.TreeSearchParam treeSearchParam1 = new TreeSearchUtil.TreeSearchParam(this.getControlNameString("bizrulecatalog", "data"), "treelistdata1", "data", TreeSearchUtil.SearchBtnStatus.RIGHT);
                    TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), treeSearchParam1);
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"BizRuleGroupListPlugin2#click", (Throwable)e);
        }
    }
}

