/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bizRuleGroup2;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.common.utils.base.CacheUtils;
import kd.epm.eb.common.utils.base.DbUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.bizRuleGroup2.BizRuleGroupListCommon2;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BizRuleGroupListTree2 {
    private AbstractListPlugin formPlugin;
    private IDataModel dataModel;

    public static BizRuleGroupListTree2 getInstance(AbstractListPlugin formPlugin, IDataModel dataModel) {
        return new BizRuleGroupListTree2(formPlugin, dataModel);
    }

    private BizRuleGroupListTree2(AbstractListPlugin formPlugin, IDataModel dataModel) {
        this.formPlugin = formPlugin;
        this.dataModel = dataModel;
    }

    public void refreshTree() {
        Long bizModelID = BizRuleGroupListCommon2.getBizModelId(this.dataModel);
        if (bizModelID == null || bizModelID == 0L) {
            ((Label)this.formPlugin.getControl("bizmodellabel")).setText(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BizRuleGroupListTree2_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String tab = BizRuleGroupListCommon2.getTabInfo(this.getTab());
        TreeView tree = (TreeView)this.formPlugin.getControl(BizRuleGroupListCommon2.getControlNameFromTab("bizrulecatalog", this.getTab()));
        tree.deleteAllNodes();
        if (tab.equalsIgnoreCase("depend")) {
            this.initDependTree();
        } else {
            this.initCubeTree();
        }
    }

    public void clearTreeCache() {
        this.formPlugin.getPageCache().put("treelistdata1", null);
        this.formPlugin.getPageCache().put("treeCacheName", null);
    }

    private Long getModelID() {
        return Long.valueOf(this.formPlugin.getPageCache().get("KEY_MODEL_ID"));
    }

    private void initCubeTree() {
        TreeNode rootTreeNode;
        String rootNodeId = "0";
        String rootCache = this.formPlugin.getPageCache().get("treelistdata1");
        if (StringUtils.isEmpty((CharSequence)rootCache)) {
            Long modelIdLong = this.getModelID();
            Long bizModelIdLong = BizRuleGroupListCommon2.getBizModelId(this.dataModel);
            List rowMapList = DbUtils.getRowMapList((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fbizmodels from t_eb_bizruleset where fmodel = ? and fbizctrlrangeid = ?", (Object[])ObjUtils.getObjectArray((Object[])new Object[]{modelIdLong, bizModelIdLong}));
            if (CollectionUtils.isEmpty((Collection)rowMapList)) {
                return;
            }
            LinkedHashSet<Long> appScenIdLongSet = new LinkedHashSet<Long>();
            for (Map rowMap : rowMapList) {
                Object[] fbizmodelIdLongStringArray;
                String fbizmodelsString = ObjUtils.getString(rowMap.get("fbizmodels"));
                if (StringUtils.isBlank((CharSequence)fbizmodelsString) || ArrayUtils.isEmpty((Object[])(fbizmodelIdLongStringArray = StringUtils.split((String)fbizmodelsString, (String)",")))) continue;
                for (Object fbizmodelIdLongString : fbizmodelIdLongStringArray) {
                    Long fbizmodelIdLong = ObjUtils.getLong((Object)fbizmodelIdLongString);
                    if (fbizmodelIdLong == null || fbizmodelIdLong <= 0L) continue;
                    appScenIdLongSet.add(fbizmodelIdLong);
                }
            }
            Map<Long, String> datasetMap = QueryServiceHelper.query((String)"eb_dataset", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", appScenIdLongSet)}).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("name")));
            rootTreeNode = new TreeNode();
            this.getRooTreeNode(rootTreeNode, rootNodeId, ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"BizRuleGroupListTree2_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (Map.Entry<Long, String> dataSetMapEntry : datasetMap.entrySet()) {
                ArrayList<TreeNode> childrenTreeNodeList = rootTreeNode.getChildren();
                if (childrenTreeNodeList == null) {
                    childrenTreeNodeList = new ArrayList<TreeNode>(16);
                    rootTreeNode.setChildren(childrenTreeNodeList);
                }
                TreeNode datasetNode = new TreeNode();
                datasetNode.setParentid(rootTreeNode.getId());
                datasetNode.setId(String.valueOf(dataSetMapEntry.getKey()));
                datasetNode.setText(dataSetMapEntry.getValue());
                HashMap<String, String> data = new HashMap<String, String>(16);
                data.put("id", datasetNode.getId());
                data.put("name", datasetNode.getText());
                data.put("level", "2");
                datasetNode.setData(data);
                childrenTreeNodeList.add(datasetNode);
            }
            this.formPlugin.getPageCache().put(BizRuleGroupListCommon2.getControlNameFromTab("focus_node_id_", this.getTab()), rootNodeId);
            this.formPlugin.getPageCache().put(BizRuleGroupListCommon2.getControlNameFromTab("rootnodeid_", this.getTab()), rootNodeId);
            this.formPlugin.getPageCache().put("treelistdata1", SerializationUtils.toJsonString((Object)rootTreeNode));
            TreeSearchUtil.clearSearchPageCache(this.formPlugin.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        } else {
            rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)rootCache, TreeNode.class);
        }
        this.showTree(rootTreeNode, rootNodeId);
    }

    private void initDependTree() {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("modelIdLong", this.formPlugin.getModelId());
        objectNode.put("bizModelIdLong", BizRuleGroupListCommon2.getBizModelId(this.dataModel));
        String rootNodeId = "0";
        TreeNode root = new TreeNode();
        this.getRooTreeNode(root, rootNodeId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizRuleGroupListTree2_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        boolean noRuleBoolean = CacheUtils.getBoolean((IPageCache)this.formPlugin.getPageCache(), (String)objectNode.toString());
        if (!noRuleBoolean) {
            Long bizModelIdLong = BizRuleGroupListCommon2.getBizModelId(this.dataModel);
            DynamicObjectCollection dataSet = QueryServiceHelper.query((String)"eb_dataset", (String)"id", (QFilter[])new QFilter[]{new QFilter("businessmodel", "=", (Object)bizModelIdLong)});
            Set dataSetId = dataSet.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("dataset", "in", dataSetId);
            qFilter.and("model", "=", (Object)this.getModelID());
            DynamicObjectCollection templateCollection = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, name, number, templatecatalog.id", (QFilter[])new QFilter[]{qFilter});
            Map<Long, Map<String, String>> tempMap = this.getTemplateMap(templateCollection, "id", "templatecatalog.id");
            HashMap templateMap = new HashMap(16);
            if (tempMap.size() != 0) {
                Set templateWithRule = RuleRelationService.getInstance().listTemplateByTemplateId(tempMap.keySet());
                templateWithRule.forEach(e -> {
                    Map info = (Map)tempMap.get(e);
                    Map.Entry entry = info.entrySet().iterator().next();
                    long tempCatalog = Long.parseLong((String)entry.getKey());
                    HashMap info_new = (HashMap)templateMap.get(tempCatalog);
                    if (info_new == null) {
                        info_new = new HashMap(16);
                    }
                    info_new.put(e.toString(), entry.getValue());
                    templateMap.put(tempCatalog, info_new);
                });
            }
            String selectFields = "id,name,number,parent,sequence,longnumber,level";
            QFilter fModelId = new QFilter("model", "=", (Object)this.getModelID());
            QFilter[] filters = new QFilter[]{fModelId};
            String orderBys = "sequence";
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_templatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
            Map<Long, Map<String, String>> templateArrMap = this.getTemplateMap(dys, "parent", "id");
            dys.stream().min(Comparator.comparingInt(e -> e.getInt("level"))).ifPresent(e -> {
                TreeNode minNode = this.getChildNode(root.getId(), e.getString("id"), ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f", (String)"TemplateUserPermPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), "2");
                this.getTreeNode(minNode, templateArrMap, templateMap, "3", "budget");
                root.addChild(minNode);
            });
            QFilter qFilter2 = new QFilter("dataset", "in", dataSetId);
            qFilter2.and("model", "=", (Object)this.getModelID());
            DynamicObjectCollection applyTemplateColl = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id, name, number, templatetype.id", (QFilter[])new QFilter[]{qFilter2});
            Map<Long, Map<String, String>> applyTempMap = this.getTemplateMap(applyTemplateColl, "id", "templatetype.id");
            HashMap applyTemplateMap = new HashMap(16);
            if (applyTempMap.size() > 0) {
                Set templateWithRule = RuleRelationService.getInstance().listApplyTemplateByTemplateId(applyTempMap.keySet());
                templateWithRule.forEach(e -> {
                    Map info = (Map)applyTempMap.get(e);
                    Map.Entry entry = info.entrySet().iterator().next();
                    long tempCatalog = Long.parseLong((String)entry.getKey());
                    Map info_new = applyTemplateMap.computeIfAbsent(tempCatalog, v -> Maps.newHashMap());
                    info_new.put(e.toString(), entry.getValue());
                });
            }
            String applyFields = "id,name,number,parent,sequence,longnumber,level";
            QFilter catFilter = new QFilter("model", "=", (Object)this.getModelID());
            DynamicObjectCollection applyDys = QueryServiceHelper.query((String)"eb_applytemplatelog", (String)applyFields, (QFilter[])catFilter.toArray(), (String)"sequence");
            Map<Long, Map<String, String>> applyTemplateArrMap = this.getTemplateMap(applyDys, "parent", "id");
            applyDys.stream().min(Comparator.comparingInt(e -> e.getInt("level"))).ifPresent(e -> {
                TreeNode applyMinNode = this.getChildNode(root.getId(), e.getString("id"), ResManager.loadKDString((String)"\u7533\u62a5\u6a21\u677f", (String)"TemplateUserPermPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), "2");
                this.getTreeNode(applyMinNode, applyTemplateArrMap, applyTemplateMap, "3", "apply");
                root.addChild(applyMinNode);
            });
        }
        this.formPlugin.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)root));
        TreeSearchUtil.clearSearchPageCache(this.formPlugin.getPageCache(), new TreeSearchUtil.TreeSearchParam());
        this.formPlugin.getPageCache().put(BizRuleGroupListCommon2.getControlNameFromTab("focus_node_id_", this.getTab()), rootNodeId);
        this.formPlugin.getPageCache().put(BizRuleGroupListCommon2.getControlNameFromTab("rootnodeid_", this.getTab()), rootNodeId);
        this.showTree(root, rootNodeId);
    }

    private Map<Long, Map<String, String>> getTemplateMap(DynamicObjectCollection templates, String keyWord, String id) {
        HashMap<Long, Map<String, String>> templateMap = new HashMap<Long, Map<String, String>>(16);
        for (DynamicObject template : templates) {
            Long key = template.getLong(keyWord);
            HashMap<String, String> templateInfoMap = (HashMap<String, String>)templateMap.get(key);
            if (templateInfoMap == null) {
                templateInfoMap = new HashMap<String, String>(16);
            }
            templateInfoMap.put(template.getString(id), template.getString("name"));
            templateMap.put(key, templateInfoMap);
        }
        return templateMap;
    }

    private void showTree(TreeNode root, String rootNodeId) {
        TreeView tree = (TreeView)this.formPlugin.getControl(BizRuleGroupListCommon2.getControlNameFromTab("bizrulecatalog", this.getTab()));
        tree.addNode(root);
        tree.focusNode(root);
        tree.expand(rootNodeId);
        this.expandAll(root, 1);
    }

    private void expandAll(TreeNode root, int level) {
        if (level < 1) {
            return;
        }
        TreeView tree = (TreeView)this.formPlugin.getControl(BizRuleGroupListCommon2.getControlNameFromTab("bizrulecatalog", this.getTab()));
        List child = root.getChildren();
        if (child != null && child.size() != 0) {
            for (TreeNode childNode : child) {
                tree.expand(childNode.getId());
                this.expandAll(childNode, --level);
            }
        }
    }

    private TreeNode getTreeNode(TreeNode node, Map<Long, Map<String, String>> templateArrays, Map<Long, Map<String, String>> templates, String level, String type) {
        TreeNode childNode;
        ArrayList<TreeNode> children = node.getChildren();
        boolean hasNextNode = false;
        if (children == null) {
            children = new ArrayList<TreeNode>(16);
        }
        Map<String, String> templateArraySet = templateArrays.get(Long.parseLong(node.getId()));
        Map<String, String> templateSet = templates.get(Long.parseLong(node.getId()));
        if (templateArraySet != null && templateArraySet.size() != 0) {
            for (Map.Entry<String, String> templateArray : templateArraySet.entrySet()) {
                childNode = this.getChildNode(node.getId(), templateArray.getKey(), templateArray.getValue(), level);
                childNode.setType(type);
                TreeNode nextNode = this.getTreeNode(childNode, templateArrays, templates, String.valueOf(Integer.parseInt(level) + 1), type);
                if (nextNode == null) continue;
                children.add(childNode);
                if (node.getChildren() == null) {
                    node.setChildren(children);
                }
                hasNextNode = true;
            }
        }
        if (templateSet != null && templateSet.size() != 0) {
            for (Map.Entry<String, String> template : templateSet.entrySet()) {
                childNode = this.getChildNode(node.getId(), template.getKey(), template.getValue(), level);
                children.add(childNode);
                if (node.getChildren() != null) continue;
                node.setChildren(children);
            }
        }
        if (!(hasNextNode || templateSet != null && templateSet.size() != 0)) {
            return null;
        }
        return node;
    }

    private TreeNode getChildNode(String parentId, String id, String name, String level) {
        TreeNode childNode = new TreeNode();
        childNode.setParentid(parentId);
        childNode.setId(id);
        childNode.setText(name);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("id", id);
        data.put("name", name);
        data.put("level", level);
        childNode.setData(data);
        return childNode;
    }

    private String getTab() {
        return this.formPlugin.getPageCache().get("cache_tab");
    }

    private void getRooTreeNode(TreeNode root, String rootNodeId, String text) {
        root.setId(rootNodeId);
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)text, (String)"bizRuleGroupListPlugin_6", (String)"BizRuleGroupListTree2_3", (Object[])new Object[0]));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", rootNodeId);
        data.put("name", root.getText());
        data.put("level", "1");
        root.setData(data);
    }
}

