/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bizRuleGroup2;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.rulemanage.utils.RuleUtils;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BizRuleVariablePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String BD_DIMENSION = "dimension";
    public static final String BD_VARIABLE = "variablenumber";
    public static final String VARIABLE = "variable";
    public static final String DELETE_ENTITY = "btn_del";
    public static final String BTN_ADD = "btn_add";
    private static final String ENTRYENTITY = "entryentity";
    public static final String BTN_CONFIRM = "btn_confirm";
    private static final String[] controls = new String[]{"dimension", "variablenumber"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String control : controls) {
            BasedataEdit edit = (BasedataEdit)this.getControl(control);
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{VARIABLE, DELETE_ENTITY, BTN_ADD, BTN_ADD, BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        String type;
        super.afterCreateNewData(e);
        Long model = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        if (model != null) {
            this.getModel().setValue("model", (Object)model);
        }
        if (StringUtils.isNotEmpty((String)(type = (String)PluginUtils.getCustomParams(this.getView(), "type")))) {
            this.getModel().setValue("type", (Object)type);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4", "btn_ok"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_CONFIRM});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap4", "btn_ok"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CONFIRM});
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object obj = e.getSource();
        if (obj instanceof BasedataEdit) {
            String key = ((BasedataEdit)obj).getKey();
            if (BD_DIMENSION.equals(key)) {
                this.dimensionSelect(e);
            } else if (BD_VARIABLE.equals(key)) {
                this.variableSelect(e);
            }
        }
    }

    private void dimensionSelect(BeforeF7SelectEvent e) {
        Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        if (modelId != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            List filters = showParameter.getListFilterParameter().getQFilters();
            QFilter qFilter = new QFilter("model.id", "=", (Object)modelId);
            HashSet<Long> dimensionIds = new HashSet<Long>(16);
            String selects = "id, dimension.id,dimension.number";
            DynamicObjectCollection variableDimension = QueryServiceHelper.query((String)"eb_dimensionvariable", (String)selects, (QFilter[])new QFilter[]{qFilter});
            if (variableDimension != null) {
                for (DynamicObject variable : variableDimension) {
                    if ("1".equals(this.getModel().getValue("type"))) {
                        if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(variable.getString("dimension.number"))) continue;
                        dimensionIds.add(variable.getLong("dimension.id"));
                        continue;
                    }
                    dimensionIds.add(variable.getLong("dimension.id"));
                }
            }
            filters.add(new QFilter("id", "in", dimensionIds));
            e.setFormShowParameter((FormShowParameter)showParameter);
        }
    }

    private void variableSelect(BeforeF7SelectEvent e) {
        Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        if (modelId != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            List filters = showParameter.getListFilterParameter().getQFilters();
            QFilter qFilter = new QFilter("model.id", "=", (Object)modelId);
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION, rows[0]);
            if (dimension == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BgTaskPackagePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            qFilter.and(new QFilter("dimension.id", "=", (Object)dimension.getLong("id")));
            if ("1".equals(this.getModel().getValue("type"))) {
                qFilter.and(new QFilter("grouptype", "=", (Object)"2"));
            }
            HashSet<Long> variableIds = new HashSet<Long>(16);
            int maxSize = entryGrid.getEntryData().getEndIndex();
            for (int i = 0; i < maxSize; ++i) {
                DynamicObject variable;
                if (i == rows[0] || (variable = (DynamicObject)this.getModel().getValue(BD_VARIABLE, i)) == null) continue;
                variableIds.add(variable.getLong("id"));
            }
            qFilter.and(new QFilter("grouptype", "!=", (Object)"2").or("number", "=", (Object)"@BaseY"));
            filters.add(qFilter);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "variableSelect"));
            showParameter.setMultiSelect(true);
            e.setFormShowParameter((FormShowParameter)showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int row = entryGrid.getSelectRows()[0];
        long dimId = ((DynamicObject)this.getModel().getValue(BD_DIMENSION, row)).getLong("id");
        int maxRow = this.getModel().getEntryRowCount(ENTRYENTITY);
        if ("selectMember".equals(key)) {
            ListSelectedRowCollection memberInfo = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (memberInfo == null) {
                return;
            }
            ArrayList memberInfos = new ArrayList(memberInfo.size());
            for (ListSelectedRow memberDetails : memberInfo) {
                DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, row);
                if (dim == null || dim.getLong("id") != dimId) break;
                HashMap<String, Object> memberInfoMap = new HashMap<String, Object>(16);
                memberInfoMap.put("id", memberDetails.getPrimaryKeyValue());
                memberInfoMap.put("name", memberDetails.getName());
                memberInfoMap.put("number", memberDetails.getNumber());
                memberInfos.add(memberInfoMap);
            }
            if (!memberInfos.isEmpty()) {
                String name = memberInfos.stream().map(x -> x.get("name").toString()).collect(Collectors.joining(","));
                this.getModel().setValue(VARIABLE, (Object)name, row);
                String memberJson = SerializationUtils.toJsonString(memberInfos);
                this.getModel().setValue("variablejson", (Object)memberJson, row++);
            }
        } else if ("variableSelect".equals(key)) {
            ListSelectedRowCollection varInfo = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (varInfo == null) {
                return;
            }
            Object firstVar = null;
            Object memberName = this.getModel().getValue(VARIABLE, row);
            Object memberJson = this.getModel().getValue("variablejson", row);
            int index = row;
            for (ListSelectedRow detail : varInfo) {
                if (index >= maxRow) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                } else {
                    DynamicObject dim = (DynamicObject)this.getModel().getValue(BD_DIMENSION, index);
                    if (dim != null && dim.getLong("id") != dimId) break;
                }
                this.getModel().setValue(BD_DIMENSION, (Object)dimId, index);
                if (firstVar == null) {
                    firstVar = detail.getPrimaryKeyValue();
                }
                this.getModel().setValue(BD_VARIABLE, detail.getPrimaryKeyValue(), index++);
            }
            this.getModel().setValue(BD_VARIABLE, firstVar, row);
            this.getModel().setValue(VARIABLE, memberName, row);
            this.getModel().setValue("variablejson", memberJson, row);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            this.checkPermission(this.getView(), ((Control)evt.getSource()).getKey());
        }
        if (VARIABLE.equals(key = ((Control)evt.getSource()).getKey())) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(BD_DIMENSION);
            if (dimension == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"BgTaskPackagePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showMemberSelect(dimension);
        } else if (DELETE_ENTITY.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rowNums = entryGrid.getSelectRows();
            if (rowNums == null || rowNums.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            Long dimId = 0L;
            HashSet<Long> varIds = new HashSet<Long>();
            for (int row : rowNums) {
                QuoteCheckResult quote;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                Long varId = dynamicObject.getLong("variablenumber.id");
                if (varId == null || varId == 0L || dynamicObject.getLong("id") == 0L) continue;
                varIds.add(varId);
                String type = (String)this.getModel().getValue("type");
                String msg = "";
                dimId = dynamicObject.getLong("dimension.id");
                if ("1".equals(type)) {
                    quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)dimId, varIds, (MemberQuoteResourceEnum)MemberQuoteResourceEnum.BizRule));
                    msg = ResManager.loadKDString((String)"\u5220\u9664\u540e\uff0c\u4e1a\u52a1\u89c4\u5219\u7684\u53d8\u91cf\u5c06\u4e0d\u518d\u8d4b\u503c\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"BizRuleVariablePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                    if (!quote.isHasQuote() || !quote.getMsg().contains(MemberQuoteResourceEnum.BizRule.getName())) continue;
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("del_entity", (IFormPlugin)this));
                    return;
                }
                quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)dimId, varIds, (MemberQuoteResourceEnum)MemberQuoteResourceEnum.Examine));
                msg = ResManager.loadKDString((String)"\u5220\u9664\u540e\uff0c\u52fe\u7a3d\u5173\u7cfb\u7684\u53d8\u91cf\u5c06\u4e0d\u518d\u8d4b\u503c\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"BizRuleVariablePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                if (!quote.isHasQuote() || !quote.getMsg().contains(MemberQuoteResourceEnum.Examine.getName())) continue;
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("del_entity", (IFormPlugin)this));
                return;
            }
            this.deleteRow();
        } else if (BTN_ADD.equals(key)) {
            int[] rows;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "model");
            int[] rowNums = entryGrid.getSelectRows();
            if (rowNums == null || rowNums.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            for (int row : rows = entryGrid.getSelectRows()) {
                String selects = "id, dimension.id,dimension.number";
                QFilter qFilter = new QFilter("model.id", "=", (Object)modelId).and("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber());
                DynamicObject variableDimension = QueryServiceHelper.queryOne((String)"eb_dimensionvariable", (String)selects, (QFilter[])new QFilter[]{qFilter});
                if (variableDimension == null) {
                    return;
                }
                this.getModel().setValue(BD_DIMENSION, (Object)variableDimension.getString("dimension.id"), row);
                QFilter qFilter1 = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)"@BaseY").and(BD_DIMENSION, "=", (Object)variableDimension.getLong("dimension.id"));
                DynamicObject periodVariable = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id", (QFilter[])new QFilter[]{qFilter1});
                if (periodVariable == null) continue;
                this.getModel().setValue(BD_VARIABLE, (Object)periodVariable.getLong("id"), row);
                this.getModel().setValue(VARIABLE, null, row);
                this.getModel().setValue("variablejson", null, row);
            }
        } else if (BTN_CONFIRM.equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int[] rowNums = entryGrid.getSelectRows();
            if (rowNums == null || rowNums.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            HashSet variableSet = new HashSet(rowNums.length);
            for (int row : rowNums) {
                Object variablejson = this.getModel().getValue("variablejson", row);
                variableSet.addAll(((List)JsonUtils.readValue((String)variablejson.toString(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(x -> x.get("number").toString()).collect(Collectors.toSet()));
            }
            this.getView().returnDataToParent(variableSet);
            this.getView().close();
        }
    }

    private void showMemberSelect(DynamicObject dimension) {
        Long modelId = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "selectMember");
        MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimension.getString("number")), (String)ListSelectedRow.class.getName());
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BD_VARIABLE);
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u91cf\u7f16\u7801\u3002", (String)"BizRuleVariablePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String grouptype = dynamicObject.getString("grouptype");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if ("2".equals(grouptype)) {
            f7Param.setCanSelectRoot(false);
            filters.add(new QFilter("level", "<=", (Object)2));
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getString("number"))) {
            f7Param.setCanSelectBudgetPeriodRoot(false);
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        String variablejson = (String)this.getModel().getValue("variablejson", rowIndex);
        HashSet ids = new HashSet(16);
        if (StringUtils.isNotEmpty((String)variablejson)) {
            ((List)JsonUtils.readValue((String)variablejson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().forEach(map -> ids.add(Long.parseLong(map.get("id").toString())));
        }
        if (!ids.isEmpty()) {
            f7Param.setSelectIds(ids);
        }
        f7Param.addCustomCommFilter(filters);
        NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)closeCallBack);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (BD_DIMENSION.equals(propName)) {
            int[] rows;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            for (int row : rows = entryGrid.getSelectRows()) {
                this.getModel().setValue(BD_VARIABLE, null, row);
                this.getModel().setValue(VARIABLE, null, row);
                this.getModel().setValue("variablejson", null, row);
            }
        } else if (VARIABLE.equals(propName)) {
            this.getPageCache().put("datachange", "true");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult result = e.getOperationResult();
        if (result == null) {
            return;
        }
        if (result.isSuccess() && "save".equals(e.getOperateKey())) {
            String dataChange;
            List successPkIds = result.getSuccessPkIds();
            if (CollectionUtils.isEmpty((Collection)successPkIds)) {
                return;
            }
            RuleService.getInstance().deleteRuleFromCacheByModel(this.getModelId());
            Long sourceId = (Long)successPkIds.get(0);
            DynamicObjectCollection varInfos = this.getModel().getEntryEntity(ENTRYENTITY);
            ArrayList quotes = new ArrayList(varInfos.size());
            varInfos.forEach(info -> {
                Long varId = info.getLong("variablenumber.id");
                info.getString("variablenumber.number");
                long dimensionId = info.getLong("dimension.id");
                if (IDUtils.isNotNull((Long)varId)) {
                    MemberQuoteDao quote = new MemberQuoteDao(this.getModelId(), Long.valueOf(0L), Long.valueOf(dimensionId), varId, MemberQuoteResourceEnum.BizRuleList, sourceId);
                    quote.setMemberType(MemberTypeEnum.VARIABLE);
                    quotes.add(quote);
                }
            });
            if (quotes.size() > 0) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quotes});
            }
            if ((dataChange = this.getPageCache().get("datachange")) != null && dataChange.equals("true")) {
                EpmThreadPools.EXEC_LONGTIME_POOL.execute(() -> RuleGraphService.getInstance().updateGraphByModel(this.getModelId().longValue()));
            }
            this.getPageCache().remove("datachange");
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BizRuleVariablePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (this.checkEntityIsNull()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u91cf\u503c\u3002", (String)"BizRuleVariablePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String dataChange = this.getPageCache().get("datachange");
            if (dataChange != null && dataChange.equals("true")) {
                this.checkScopeOfApplicationOverlap();
            }
        }
    }

    private void checkScopeOfApplicationOverlap() {
        List bizmodelIds = BusinessModelServiceHelper.getInstance().getBusModelIdsByModelId(this.getModelId());
        if (CollectionUtils.isEmpty((Collection)bizmodelIds)) {
            return;
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (entryentity == null) {
            return;
        }
        HashMap varValues = new HashMap(16);
        for (DynamicObject dynamicObject : entryentity) {
            String json = dynamicObject.getString("variablejson");
            if (json == null || json.isEmpty()) continue;
            String varNumberName = dynamicObject.getString("variablenumber.number") + "!" + dynamicObject.getString("variablenumber.name");
            List valueMap = (List)SerializationUtils.fromJsonString((String)json, List.class);
            for (Map map : valueMap) {
                ReportVarUtil.putValue2MapByRule(varValues, (String)dynamicObject.getString("dimension.number"), (String)varNumberName, (String)map.get("number").toString());
            }
        }
        if (varValues.isEmpty()) {
            return;
        }
        for (Long bizmodelId : bizmodelIds) {
            QFilter qFilter = new QFilter("ruletype", "!=", (Object)"1");
            if (bizmodelId != null && bizmodelId > 0L) {
                qFilter.and("bizctrlrange", "=", (Object)bizmodelId);
            }
            List allRules = RuleService.getInstance().listRule(qFilter, Boolean.valueOf(true), varValues);
            List<RuleDto> enableRules = allRules.stream().filter(RuleDto::getStatus).collect(Collectors.toList());
            RuleUtils.checkScopeOfApplicationOverlap(enableRules, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "del_entity": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.deleteRow();
                break;
            }
        }
    }

    private void deleteRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rowNums = entryGrid.getSelectRows();
        if (rowNums == null || rowNums.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c\u3002", (String)"ControlProcessAddPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, rowNums);
    }

    @Override
    public Long getModelId() {
        Long model = (Long)PluginUtils.getCustomParams(this.getView(), "model");
        if (model != null) {
            return model;
        }
        return 0L;
    }

    private boolean checkEntityIsNull() {
        QFilter qFilter1;
        DynamicObject periodVariable;
        QFilter qFilter;
        String selects;
        DynamicObject variableDimension;
        int maxRow = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (maxRow == 0 && (variableDimension = BusinessDataServiceHelper.loadSingle((String)"eb_dimensionvariable", (String)(selects = "id, dimension.id,dimension.number"), (QFilter[])new QFilter[]{qFilter = new QFilter("model.id", "=", (Object)this.getModelId()).and("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber())})) != null && (periodVariable = QueryServiceHelper.queryOne((String)"eb_periodvariable", (String)"id", (QFilter[])new QFilter[]{qFilter1 = new QFilter("model", "=", (Object)this.getModelId()).and("number", "=", (Object)"@BaseY").and(BD_DIMENSION, "=", (Object)variableDimension.getLong("dimension.id"))})) != null) {
            HashSet<Long> ids = new HashSet<Long>(16);
            ids.add(periodVariable.getLong("id"));
            QuoteCheckResult quote = MemberQuote.get().checkQuoteResult(QuoteBuilder.build((Long)this.getModelId(), (Long)variableDimension.getLong("dimension.id"), ids, (MemberQuoteResourceEnum)MemberQuoteResourceEnum.BizRule));
            String msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5df2\u4f7f\u7528BudgetPeriod\u5e74\u53d8\u91cf\u3002\u8bf7\u5728\u53d8\u91cf\u8d4b\u503c\u754c\u9762\u81f3\u5c11\u4fdd\u5b58\u4e00\u6761\u8d4b\u503c\u8bb0\u5f55\u3002", (String)"BizRuleVariablePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            if (quote.isHasQuote() && quote.getMsg().contains(MemberQuoteResourceEnum.BizRule.getName())) {
                throw new KDBizException(msg);
            }
        }
        for (int i = 0; i < maxRow; ++i) {
            if (!StringUtils.isEmpty((String)((String)this.getModel().getValue(VARIABLE, i))) && !StringUtils.isEmpty((String)((String)this.getModel().getValue("variablejson", i)))) continue;
            return true;
        }
        return false;
    }
}

