/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bizRuleGroup2;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bizrule.RuleExecutionContext;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.bizrule.RuleGraphService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.rulemanage.RelationGraphService;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;

public class RuleInstanceDetailListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String model = (String)this.getView().getFormShowParameter().getCustomParam("model");
        if ("exescope".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            Object objId = this.getFocusRowPkId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)objId, (String)"eb_rule_instance_detail");
            String exescope = dynamicObject.getString("exescope");
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId("eb_rule_scope");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setCustomParam("model", (Object)model);
            lsp.setCustomParam("exescope", (Object)exescope);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "exescope"));
            this.getView().showForm(lsp);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            String itemKeyString;
            super.itemClick(evt);
            switch (itemKeyString = evt.getItemKey()) {
                case "relation_graph": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                    if (CollectionUtils.isEmpty((Collection)listSelectedRowCollection) || listSelectedRowCollection.size() != 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u67e5\u770b\u89c4\u5219\u6267\u884c\u5b9e\u4f8b\u8be6\u60c5\u3002", (String)"RelationGraphPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long ruleInstanceIdDetailLong = ObjUtils.getLong((Object)listSelectedRowCollection.get(0).getPrimaryKeyValue());
                    RelationGraphService.openRelationGraphByRuleInstanceDetailIdLong(this.getView(), ruleInstanceIdDetailLong);
                    break;
                }
                case "recalculate": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                    if (CollectionUtils.isEmpty((Collection)listSelectedRowCollection) || listSelectedRowCollection.size() != 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u89c4\u5219\u6267\u884c\u5b9e\u4f8b\u3002", (String)"RelationGraphPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Set ids = listSelectedRowCollection.stream().map(x -> ObjUtils.getLong((Object)x.getPrimaryKeyValue())).collect(Collectors.toSet());
                    DynamicObject ruleLogDetail = QueryServiceHelper.queryOne((String)"eb_rule_instance_detail", (String)"logid,rule.id,exescope", (QFilter[])new QFilter("id", "in", ids).toArray());
                    DynamicObject ruleLog = QueryServiceHelper.queryOne((String)"eb_rule_instance", (String)"templatescope,bizmodel,model,template,curentorg", (QFilter[])new QFilter("id", "=", ruleLogDetail.get("logid")).toArray());
                    Long modelId = ruleLog.getLong("model");
                    Long datasetId = ruleLog.getLong("bizmodel");
                    Long templateId = ruleLog.getLong("template");
                    String json = ruleLog.getString("templatescope");
                    Map tempScope = (Map)JsonUtils.readValue((String)json, (TypeReference)new TypeReference<Map<String, Set<String>>>(){});
                    String currentOrg = ruleLog.getString("curentorg");
                    String[] split = currentOrg.split("-");
                    IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                    Map viewIds = modelCache.getViewsByDataSet(datasetId);
                    Member member = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()), split[0]);
                    if (member == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"RuleInstanceListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    Long bizCtrlId = modelCache.getBusModelByDataSet(datasetId);
                    List allEnableRuleDto = RuleCacheService.getInstance().listRuleFromLocalCache(bizCtrlId).getRuleDtoList();
                    List allEnableRule = allEnableRuleDto.stream().map(RuleBo::new).collect(Collectors.toList());
                    Map<Long, RuleBo> allEnableRuleMap = allEnableRule.stream().collect(Collectors.toMap(RuleBo::getId, e -> e));
                    RuleBo exeRule = allEnableRuleMap.get(ruleLogDetail.getLong("rule.id"));
                    MutableGraph graph = RuleGraphService.getInstance().getDagGraphByBizmodel(allEnableRuleDto);
                    String exeScopeJson = ruleLogDetail.getString("exescope");
                    if (StringUtils.isEmpty((String)exeScopeJson)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u8303\u56f4\u4e3a\u7a7a:", (String)"RuleInstanceDetailListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    Map leafScope = (Map)JsonUtils.readValue((String)exeScopeJson, (TypeReference)new TypeReference<Map<String, Set<String>>>(){});
                    RuleExecutionContext ctx = new RuleExecutionContext();
                    ctx.setTotalGraph(graph);
                    Set ruleIds = RuleExecutionService.getInstance().getOffsetRuleId(exeRule, graph, graph, ctx);
                    if (ruleIds.size() > 1) {
                        Set offsetRuleIds = ruleIds.stream().filter(e -> !e.equals(exeRule.getId())).collect(Collectors.toSet());
                        RuleExecutionService.getInstance().unionOffsetLeft(offsetRuleIds, leafScope, exeRule, allEnableRuleMap, modelCache);
                    }
                    List ruleDtos = allEnableRule.stream().filter(e -> ruleIds.contains(e.getId())).collect(Collectors.toList());
                    List executeRuleDtos = ruleDtos.stream().map(RuleBo::getRuleDto).collect(Collectors.toList());
                    OlapCommService.getInstance().calcAndSave(new AlgoCalcRequest(modelId, datasetId, leafScope, executeRuleDtos));
                    List leafCells = OlapCommService.getInstance().queryLeafList(new QueryRequest(modelId, datasetId, leafScope));
                    RuleExecutionService.getInstance().executeRuleChain(new RuleTemplateInfo(modelId, templateId, member.getId(), tempScope), datasetId, modelId, leafCells, RuleExecuteTypeEnum.REPEAT_CALC.getType());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecuteRuleProcessPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e2) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleInstanceDetailListPlugin#itemClick", (Throwable)e2);
        }
    }
}

