/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.bizRuleGroup2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.rule.execute.RuleExecuteLogStatusEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.rulemanage.RelationGraphService;
import kd.epm.eb.olap.service.RuleRetryService;
import org.apache.commons.collections4.CollectionUtils;

public class RuleInstanceListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id desc");
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            super.billListHyperLinkClick(args);
            args.setCancel(Boolean.TRUE.booleanValue());
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object focusRowPkId = billList.getFocusRowPkId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"eb_rule_instance");
            String model = dynamicObject.getString("model.id");
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("eb_rule_instance_detail");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setCustomParam("logId", focusRowPkId);
            lsp.setCustomParam("model", (Object)model);
            List<QFilter> filters = Collections.singletonList(new QFilter("logId", "=", focusRowPkId));
            lsp.getListFilterParameter().setQFilters(filters);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "log_close"));
            this.getView().showForm((FormShowParameter)lsp);
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleInstanceListPlugin#billListHyperLinkClick", (Throwable)e);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        try {
            String itemKeyString;
            super.itemClick(evt);
            switch (itemKeyString = evt.getItemKey()) {
                case "relation_graph": {
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                    if (CollectionUtils.isEmpty((Collection)listSelectedRowCollection) || listSelectedRowCollection.size() != 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u89c4\u5219\u6267\u884c\u5b9e\u4f8b\u3002", (String)"RelationGraphPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long ruleInstanceIdLong = ObjUtils.getLong((Object)listSelectedRowCollection.get(0).getPrimaryKeyValue());
                    RelationGraphService.openRelationGraphByRuleInstanceIdLong(this.getView(), ruleInstanceIdLong);
                    break;
                }
                case "recalculate": {
                    String modelIdStr = (String)this.getCustomFormParam("modelId");
                    if (StringUtils.isEmpty((String)modelIdStr)) {
                        return;
                    }
                    Long modelId = Long.parseLong(modelIdStr);
                    IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                    QFilter qf = new QFilter("model", "=", (Object)modelId);
                    qf.and("executestatus", "in", Arrays.asList(RuleExecuteLogStatusEnum.EXECUTING.getCode(), RuleExecuteLogStatusEnum.FAIL.getCode()));
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
                    if (CollectionUtils.isNotEmpty((Collection)listSelectedRowCollection)) {
                        Set ids = listSelectedRowCollection.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                        qf.and("id", "in", ids);
                    } else {
                        qf.and("retrynumber", "<", (Object)1);
                    }
                    RuleRetryService.getInstance().retryErrorCalc(qf, modelCache);
                    billList.refresh();
                    this.writeLog("recalculate", new MultiLangEnumBridge("\u91cd\u65b0\u6267\u884c", "AbstractMultiReportPlugin_128", "epm-eb-budget"), new MultiLangEnumBridge("\u91cd\u65b0\u6267\u884c\u6210\u529f", "AbstractMultiReportPlugin_130", "epm-eb-budget"));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ExecuteRuleProcessPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "errorlog": {
                    ListShowParameter lsp = new ListShowParameter();
                    lsp.setBillFormId("eb_rule_error_log");
                    lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    lsp.getListFilterParameter().setOrderBy("createtime desc");
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "error_log_close"));
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
            }
        }
        catch (Exception e) {
            CommonServiceHelper.dealException((AbstractFormPlugin)this, (String)"RuleInstanceListPlugin#itemClick", (Throwable)e);
        }
    }

    @Override
    public boolean isCheckModel() {
        return false;
    }
}

