/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.catalog.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CatalogServiceHelper {
    public static void antiAllocate(long catalogId) {
        if (catalogId == 0L) {
            return;
        }
        HashSet<Long> templateIds = new HashSet<Long>(16);
        QFilter catalogQfilter = new QFilter("catalog", "=", (Object)catalogId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CatalogServiceHelper", (String)"eb_brallocateentity", (String)"template.id templateid", (QFilter[])catalogQfilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                templateIds.add(next.getLong("templateid"));
            }
        }
        if (templateIds.size() < 1) {
            return;
        }
        QFilter templateQfilter = new QFilter("template", "in", templateIds);
        DynamicObject[] allAllocate = BusinessDataServiceHelper.load((String)"eb_brallocateentity", (String)"id,templatetype,template.id templateid,catalog.id catalogid,execseq", (QFilter[])new QFilter[]{templateQfilter}, (String)"template.id,execseq");
        if (allAllocate.length < 1) {
            return;
        }
        int j = 1;
        Long templateId = allAllocate[0].getLong("template_id");
        for (int i = 0; i < allAllocate.length; ++i) {
            DynamicObject obj = allAllocate[i];
            if (templateId.longValue() != obj.getLong("template_id")) {
                templateId = obj.getLong("template_id");
                j = 1;
            }
            if (catalogId == obj.getLong("catalog_id")) continue;
            obj.set("execseq", (Object)j++);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])allAllocate);
                DeleteServiceHelper.delete((String)"eb_brallocateentity", (QFilter[])new QFilter[]{catalogQfilter});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void antiAllocate(Long templateId, Set<Long> catalogIds) {
        QFilter templateQfilter = new QFilter("template", "=", (Object)templateId);
        DynamicObject[] allAllocate = BusinessDataServiceHelper.load((String)"eb_brallocateentity", (String)"id,catalog.id catalogid,execseq", (QFilter[])new QFilter[]{templateQfilter}, (String)"execseq");
        int j = 1;
        for (int i = 0; i < allAllocate.length; ++i) {
            DynamicObject obj = allAllocate[i];
            if (catalogIds.contains(obj.getLong("catalog_id"))) continue;
            obj.set("execseq", (Object)j++);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])allAllocate);
                QFilter catalogQfilter = new QFilter("catalog", "in", catalogIds);
                DeleteServiceHelper.delete((String)"eb_brallocateentity", (QFilter[])new QFilter[]{templateQfilter, catalogQfilter});
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void moveup(long templateId, HashMap<Integer, String> moveup) {
        DynamicObject[] allocates;
        QFilter templateQfilter = new QFilter("template", "in", (Object)templateId);
        HashSet<Integer> execseq = new HashSet<Integer>(16);
        HashSet<Integer> downSet = new HashSet<Integer>(16);
        for (Integer seq : moveup.keySet()) {
            execseq.add(seq);
            execseq.add(seq - 1);
            downSet.add(seq - 1);
        }
        Set<Integer> upSet = moveup.keySet();
        QFilter seqQfilter = new QFilter("execseq", "in", execseq);
        for (DynamicObject allocate : allocates = BusinessDataServiceHelper.load((String)"eb_brallocateentity", (String)"id,execseq,catalog.id", (QFilter[])new QFilter[]{templateQfilter, seqQfilter})) {
            String catalogId = allocate.getString("catalog.id");
            int seq = allocate.getInt("execseq");
            if (upSet.contains(seq)) {
                if (!catalogId.equals(moveup.get(seq))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u64cd\u4f5c\u8be5\u6a21\u677f\u7684\u516c\u5f0f\uff0c\u8bf7\u7b49\u5f85\u8be5\u7528\u6237\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"CatalogServiceHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                --seq;
            } else if (downSet.contains(seq)) {
                while (downSet.contains(++seq)) {
                }
            }
            allocate.set("execseq", (Object)seq);
        }
        SaveServiceHelper.save((DynamicObject[])allocates);
    }

    public static void movedown(long templateId, HashMap<Integer, String> movedown) {
        DynamicObject[] allocates;
        QFilter templateQfilter = new QFilter("template", "in", (Object)templateId);
        HashSet<Integer> execseq = new HashSet<Integer>(16);
        HashSet<Integer> upSet = new HashSet<Integer>(16);
        for (Integer seq : movedown.keySet()) {
            execseq.add(seq);
            execseq.add(seq + 1);
            upSet.add(seq + 1);
        }
        Set<Integer> downSet = movedown.keySet();
        QFilter seqQfilter = new QFilter("execseq", "in", execseq);
        for (DynamicObject allocate : allocates = BusinessDataServiceHelper.load((String)"eb_brallocateentity", (String)"id,execseq,catalog.id", (QFilter[])new QFilter[]{templateQfilter, seqQfilter})) {
            String catalogId = allocate.getString("catalog.id");
            int seq = allocate.getInt("execseq");
            if (downSet.contains(seq)) {
                if (!catalogId.equals(movedown.get(seq))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u7528\u6237\u6b63\u5728\u64cd\u4f5c\u8be5\u6a21\u677f\u7684\u516c\u5f0f\uff0c\u8bf7\u7b49\u5f85\u8be5\u7528\u6237\u64cd\u4f5c\u5b8c\u6210\u3002", (String)"CatalogServiceHelper_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                ++seq;
            } else if (upSet.contains(seq)) {
                while (upSet.contains(--seq)) {
                }
            }
            allocate.set("execseq", (Object)seq);
        }
        SaveServiceHelper.save((DynamicObject[])allocates);
    }
}

