/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centerscheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApprovePlanUtil;
import kd.epm.eb.business.centralapproval.CentralApprovePlanService;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveMutex;
import kd.epm.eb.common.centralapproval.entity.ApprovePlanDto;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.entity.memberF7.RangeF7Param;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;

public class BgCentralSchemeEditPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final String TOOLBARAP = "tbmain";
    private static final String SAVE = "save";
    private static final String NUMBER = "number";
    private static final String MODEL = "model";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String STATUS = "status";
    private static final String ACCOUNT_NUMBER = "accountnumber";
    private static final String ENTITY_NUMBER1 = "entitynumber1";
    private static final String CHECKER = "checker";
    private static final String BIZRANGE = "bizrange";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String ENTRYENTITY2 = "entryentity2";
    private static final String COLLECT_ORG = "collectorg";
    private static final String NAME = "name";
    private static final String ORG_SCOPE = "orgscope";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setInitData();
    }

    private void setInitData() {
        String model = this.getView().getFormShowParameter().getCustomParam(MODEL).toString();
        if (StringUtils.isEmpty((String)model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e3a\u7a7a\u3002", (String)"BgCentralSchemeEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(MODEL, model);
        this.getModel().setValue(MODEL, (Object)model);
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER, BIZRANGE});
        if (this.checkIsUsed() != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{STATUS});
        }
        this.checkIsMutex();
        this.setInitData();
    }

    private boolean checkIsMutex() {
        List approveMutexes = ApproveBillUtil.getInstance().getApproveMutexes(this.getModelId());
        for (ApproveMutex mutex : approveMutexes) {
            if (!mutex.getCentralSchemes().contains(IDUtils.toLong((Object)this.getModel().getValue("id")))) continue;
            DynamicObject person = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)mutex.getApproverId()).toArray());
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8be5\u5f52\u53e3\u65b9\u6848\u5df2\u88ab\u201c%1\u201d\u6253\u5f00\u7684\u5ba1\u6279\u5355\u201c%2\u201d\u5f15\u7528\uff0c\u5f53\u524d\u4ee5\u53ea\u8bfb\u5f62\u5f0f\u6253\u5f00\u3002", (String)"BgCentralSchemeEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{person.getString(NAME), mutex.getBillNo()}));
            this.getView().setStatus(OperationStatus.VIEW);
            return true;
        }
        return false;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addF7SelectListener(this, new String[]{ENTITY_NUMBER, ACCOUNT_NUMBER, ENTITY_NUMBER1, BIZRANGE, CHECKER});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if ("setItemByNumber".equals(event.getSourceMethod()) && (ENTITY_NUMBER1.equals(key) || ACCOUNT_NUMBER.equals(key))) {
            event.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        QFilter qF1 = new QFilter(MODEL, "=", (Object)this.getModelId());
        if (BIZRANGE.equals(key)) {
            event.getCustomQFilters().add(qF1);
        } else {
            if (this.getBizRangeId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BgCentralSchemeEditPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            if (ENTITY_NUMBER.equals(key)) {
                this.switchSingleTreeF7(event, this.getBizRangeId(), null);
            } else if (ENTITY_NUMBER1.equals(key)) {
                this.openEntitySelectF7();
                event.setCancel(Boolean.TRUE.booleanValue());
            } else if (ACCOUNT_NUMBER.equals(key)) {
                this.openAccountSelectF7();
                event.setCancel(Boolean.TRUE.booleanValue());
            } else if (CHECKER.equals(key)) {
                QFilter qFilter = new QFilter(NUMBER, "!=", (Object)"");
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    private void openEntitySelectF7() {
        RangeF7Param param = new RangeF7Param();
        param.setEnableView(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "entitySelect");
        param.setCloseCallBack(closeCallBack);
        param.setNeedPermCheck(true);
        param.setBizModelId(Long.valueOf(this.getBizRangeId()));
        param.setRangeType(F7RangeTypeEnum.CUSTOMIZE);
        ArrayList<String> useRange = new ArrayList<String>();
        useRange.add("10");
        useRange.add("20");
        useRange.add("30");
        useRange.add("90");
        param.setUserRange(useRange);
        DynamicObjectCollection entities = this.getModel().getEntryEntity(ENTRYENTITY2);
        if (entities != null && entities.size() > 0) {
            ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(16);
            for (DynamicObject dynamicObject : entities) {
                DynamicObject org = dynamicObject.getDynamicObject(ENTITY_NUMBER1);
                if (org == null) continue;
                members.add(new MemberCondition(org.getString(NUMBER), org.getString(NAME), null, dynamicObject.getString(ORG_SCOPE)));
            }
            param.setCon_list(members);
        }
        Long viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(this.getBizRangeId()), SysDimensionEnum.Entity.getNumber(), this.getModelId());
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)SysDimensionEnum.Entity.getNumber(), (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    private void openAccountSelectF7() {
        RangeF7Param param = new RangeF7Param();
        param.setEnableView(false);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "accountSelect");
        param.setCloseCallBack(closeCallBack);
        param.setNeedPermCheck(true);
        param.setBizModelId(Long.valueOf(this.getBizRangeId()));
        List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(Long.valueOf(this.getBizRangeId()));
        if (param.getqFilters() == null) {
            param.setqFilters(new ArrayList());
        }
        param.getqFilters().add(new QFilter("dataset", "in", (Object)datasetIds));
        param.getqFilters().add(new QFilter(MODEL, "=", (Object)this.getModelId()));
        DynamicObjectCollection accouts = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (accouts != null && accouts.size() > 0) {
            ArrayList<MemberCondition> members = new ArrayList<MemberCondition>(16);
            for (DynamicObject dynamicObject : accouts) {
                DynamicObject account = dynamicObject.getDynamicObject(ACCOUNT_NUMBER);
                if (account == null) continue;
                members.add(new MemberCondition(account.getString(NUMBER), account.getString(NAME), null, dynamicObject.getString("accountscope")));
            }
            param.setCon_list(members);
        }
        Long viewId = BusinessModelServiceHelper.getInstance().getViewId(Long.valueOf(this.getBizRangeId()), SysDimensionEnum.Account.getNumber(), this.getModelId());
        param.setUserRange(CollectionUtils.asList((Object[])new String[]{String.valueOf(RangeEnum.ONLY.getIndex()), String.valueOf(RangeEnum.DIRECTSUB_EXCLUDE.getIndex()), String.valueOf(RangeEnum.DIRECTSUB.getIndex()), String.valueOf(RangeEnum.ALL_EXCLUDE.getIndex()), String.valueOf(RangeEnum.ALL.getIndex()), String.valueOf(RangeEnum.ALL_DETAIL.getIndex()), String.valueOf(RangeEnum.ALL_NOTDETAIL.getIndex())}));
        CustomF7utils.openCustomF7Range((Long)this.getModelId(), (String)SysDimensionEnum.Account.getNumber(), (Long)viewId, (IFormView)this.getView(), (RangeF7Param)param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        if ("accountSelect".equals(key)) {
            this.fillDataToAccountEntry(e);
        } else if ("entitySelect".equals(key)) {
            this.fillDataToEntityEntry(e);
        }
    }

    private void fillDataToEntityEntry(ClosedCallBackEvent e) {
        DynamicObjectCollection returnData = (DynamicObjectCollection)e.getReturnData();
        Long sameParentOrgId = this.getSameParentOrgId(returnData);
        if (returnData != null && returnData.size() > 0) {
            this.getModel().deleteEntryData(ENTRYENTITY2);
            this.getModel().beginInit();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRYENTITY2, returnData.size());
            for (int i = 0; i < returnData.size(); ++i) {
                String id = ((DynamicObject)returnData.get(i)).getString("memberid");
                this.getModel().setValue(ENTITY_NUMBER1, (Object)id, rowIndex[i]);
                this.getModel().setValue(ORG_SCOPE, ((DynamicObject)returnData.get(i)).get("scope"), rowIndex[i]);
                this.getModel().setValue(COLLECT_ORG, (Object)sameParentOrgId, i);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY2);
        }
    }

    private void fillDataToAccountEntry(ClosedCallBackEvent evt) {
        DynamicObjectCollection returnData = (DynamicObjectCollection)evt.getReturnData();
        if (returnData != null && returnData.size() > 0) {
            this.getModel().deleteEntryData(ENTRYENTITY1);
            this.getModel().beginInit();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRYENTITY1, returnData.size());
            for (int i = 0; i < returnData.size(); ++i) {
                String id = ((DynamicObject)returnData.get(i)).getString("memberid");
                this.getModel().setValue(ACCOUNT_NUMBER, (Object)id, rowIndex[i]);
                this.getModel().setValue("accountscope", ((DynamicObject)returnData.get(i)).get("scope"), rowIndex[i]);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY1);
        }
    }

    private void fillDataToCollectOrg() {
        Long sameParentOrgId = this.getSameParentOrgId(null);
        int size = this.getModel().getEntryEntity(ENTRYENTITY2).size();
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue(COLLECT_ORG, (Object)sameParentOrgId, i);
        }
    }

    private Long getSameParentOrgId(DynamicObjectCollection returnData) {
        Member member;
        List<String> sameParent;
        ArrayList<String> memberList = new ArrayList<String>();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Long busModelId = this.getBizRangeId();
        Map viewIds = modelCacheHelper.getViewsByBusModel(busModelId);
        if (returnData != null) {
            if (returnData != null && returnData.size() > 0) {
                for (int i = 0; i < returnData.size(); ++i) {
                    int orgScope = ((DynamicObject)returnData.get(i)).getInt("scope");
                    String orgNumber = ((DynamicObject)returnData.get(i)).getString(NUMBER);
                    List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()), orgNumber, orgScope);
                    if (members == null || members.size() <= 0) continue;
                    members.forEach(h -> memberList.add(h.getLongNumber()));
                }
            }
        } else {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY2);
            for (DynamicObject row : rows) {
                if (row == null || row.getString("entitynumber1.longnumber") == null || row.getString("entitynumber1.number") == null) continue;
                String orgNumber = row.getString("entitynumber1.number");
                int orgScope = row.getInt(ORG_SCOPE);
                List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()), orgNumber, orgScope);
                if (members == null || members.size() <= 0) continue;
                members.forEach(h -> memberList.add(h.getLongNumber()));
            }
        }
        if (!(sameParent = this.getSameParent(memberList)).isEmpty() && (member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)viewIds.get(SysDimensionEnum.Entity.getNumber()), sameParent.get(sameParent.size() - 1))) != null) {
            return member.getId();
        }
        return null;
    }

    private List<String> getSameParent(List<String> memberList) {
        List<String> longNumberList = new ArrayList<String>(16);
        for (String longNumber : memberList) {
            String[] longNUmberStrArray = longNumber.split("!");
            if (longNumberList.size() == 0) {
                longNumberList = Arrays.asList(longNUmberStrArray);
                continue;
            }
            int n = longNumberList.size();
            for (int m = 0; m < longNumberList.size(); ++m) {
                if (!longNumberList.get(m).equals(longNUmberStrArray[m])) {
                    n = m;
                    break;
                }
                if (m != longNUmberStrArray.length - 1) continue;
                n = longNUmberStrArray.length - 1;
                break;
            }
            if (n >= longNumberList.size()) continue;
            longNumberList = longNumberList.subList(0, n);
        }
        return longNumberList;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String key;
        super.afterDoOperation(eventArgs);
        switch (key = eventArgs.getOperateKey()) {
            case "deleteentry2": {
                this.fillDataToCollectOrg();
                break;
            }
            case "save": {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{BIZRANGE, NUMBER});
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((FormOperate)args.getSource()).getOperateKey();
        if (SAVE.equals(opKey)) {
            String approveSchemeName = this.checkIsUsed();
            if (!this.checkNumberAndName()) {
                args.setCancel(true);
            } else if (this.checkNullCentralOrg()) {
                args.setCancel(true);
            } else if (this.checkNullRows()) {
                args.setCancel(true);
            } else if (approveSchemeName != null && !((Boolean)this.getModel().getValue(STATUS)).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f52\u53e3\u65b9\u6848\u201c%1\u201d\u5df2\u88ab\u5ba1\u6279\u65b9\u6848\u201c%2\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BgCentralSchemeEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getModel().getValue(NAME).toString(), approveSchemeName}));
                args.setCancel(true);
            }
        }
    }

    private boolean checkNumberAndName() {
        Long id = IDUtils.toLong((Object)this.getModel().getValue("id"));
        String number = (String)this.getModel().getValue(NUMBER);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(NAME);
        if (!CheckStringsUtil.checkAllowNumStart((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7f16\u7801\uff0c\u53ea\u80fd\u4f7f\u7528\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u3002", (String)"BgCentralSchemeEditPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        boolean existRepeatNumber = ApprovePlanUtil.getInstance().exist(this.getModelId(), NUMBER, number, id);
        if (existRepeatNumber) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgCentralSchemeEditPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"BgCentralSchemeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.checkAllowNameStart(name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u683c\u5f0f\u53ea\u80fd\u5305\u542b\u4e2d\u82f1\u6587\u3001\u6570\u5b57\u6216\u82f1\u6587\u62ec\u53f7\u3001\u6a2a\u6760\u3001\u4e0b\u5212\u7ebf\u3002", (String)"BgCentralSchemeEditPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean existRepeatName = ApprovePlanUtil.getInstance().exist(this.getModelId(), NAME, name.toString(), id);
        if (existRepeatName) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540c\u540d\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"BgCentralSchemeEditPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkNullCentralOrg() {
        DynamicObject bizRange = (DynamicObject)this.getModel().getValue(BIZRANGE);
        if (bizRange == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"BgCentralSchemeEditPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        Object value = this.getModel().getValue(ENTITY_NUMBER);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f52\u53e3\u7ec4\u7ec7\u3002", (String)"BgCentralSchemeEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkNullRows() {
        DynamicObjectCollection entities;
        DynamicObjectCollection accounts = this.getModel().getEntryEntity(ENTRYENTITY1);
        if (accounts != null && accounts.size() > 0) {
            for (int i = accounts.size() - 1; i >= 0; --i) {
                DynamicObject account = ((DynamicObject)accounts.get(i)).getDynamicObject(ACCOUNT_NUMBER);
                if (account != null) continue;
                this.getModel().deleteEntryRow(ENTRYENTITY1, i);
            }
            this.getView().updateView(ENTRYENTITY1);
        }
        if ((entities = this.getModel().getEntryEntity(ENTRYENTITY2)) != null && entities.size() > 0) {
            for (int i = entities.size() - 1; i >= 0; --i) {
                DynamicObject org = ((DynamicObject)entities.get(i)).getDynamicObject(ENTITY_NUMBER1);
                if (org != null) continue;
                this.getModel().deleteEntryRow(ENTRYENTITY2, i);
            }
            this.getView().updateView(ENTRYENTITY2);
        }
        if (this.getModel().getEntryRowCount(ENTRYENTITY1) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u79d1\u76ee\u3002", (String)"BgCentralSchemeEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.getModel().getEntryRowCount(ENTRYENTITY2) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7f16\u5236\u7ec4\u7ec7\u3002", (String)"BgCentralSchemeEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (entities == null || entities.size() == 0 || ((DynamicObject)entities.get(0)).getDynamicObject(COLLECT_ORG) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u7f16\u5236\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"BgCentralSchemeEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)entities.get(0)).getDynamicObjectCollection(CHECKER);
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u6279\u4eba\u3002", (String)"BgCentralSchemeEditPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "checker": {
                this.fillDataToChecker(e.getChangeSet()[0]);
                break;
            }
            case "orgscope": {
                this.fillDataToCollectOrg();
                break;
            }
            case "bizrange": {
                DynamicObject value = (DynamicObject)this.getModel().getValue(BIZRANGE);
                if (value != null) {
                    this.getPageCache().put(BIZRANGE, value.getString("id"));
                }
                this.getModel().deleteEntryData(ENTRYENTITY1);
                this.getModel().deleteEntryData(ENTRYENTITY2);
                this.getModel().setValue(ENTITY_NUMBER, null);
                break;
            }
        }
    }

    private void fillDataToChecker(ChangeData changeData) {
        int i;
        DynamicObjectCollection newValue = (DynamicObjectCollection)changeData.getNewValue();
        Object[] baseDataIds = new Object[newValue.size()];
        if (newValue != null && newValue.size() > 0) {
            for (i = 0; i < newValue.size(); ++i) {
                baseDataIds[i] = ((DynamicObject)newValue.get(i)).get("fbasedataid_id");
            }
        }
        this.getModel().beginInit();
        for (i = 0; i < this.getModel().getEntryRowCount(ENTRYENTITY2); ++i) {
            if (i == this.getModel().getEntryCurrentRowIndex(ENTRYENTITY2)) continue;
            this.getModel().setValue(CHECKER, (Object)baseDataIds, i);
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY2);
    }

    private String checkIsUsed() {
        Long id = IDUtils.toLong((Object)this.getModel().getValue("id"));
        List approvePlan = CentralApprovePlanService.getInstance().getApprovePlanByCentralPlanIds(id, this.getModelId());
        if (approvePlan.size() > 0) {
            return ((ApprovePlanDto)approvePlan.get(0)).getName();
        }
        return null;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((String)modelId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(MODEL);
            if (value == null) {
                return 0L;
            }
            modelId = value.getString("id");
            this.getPageCache().put(MODEL, modelId);
        }
        return Long.parseLong(modelId);
    }

    private long getBizRangeId() {
        String bizRangeId = this.getPageCache().get(BIZRANGE);
        if (StringUtils.isEmpty((String)bizRangeId)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(BIZRANGE);
            if (value == null) {
                return 0L;
            }
            bizRangeId = value.getString("id");
            this.getPageCache().put(BIZRANGE, bizRangeId);
        }
        return Long.parseLong(bizRangeId);
    }

    public String getCurrentDimNumber(String controlKey) {
        if (controlKey != null && controlKey.contains("account")) {
            return "Account";
        }
        if (controlKey != null && controlKey.contains("entity")) {
            return "Entity";
        }
        return null;
    }

    private boolean checkAllowNameStart(String name) {
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FA5A-Za-z0-9()_\\-]+$");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }
}

