/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centerscheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.centralapproval.ApprovePlanUtil;
import kd.epm.eb.business.centralapproval.CentralApprovePlanService;
import kd.epm.eb.common.centralapproval.SimpleMemberDto;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centerscheme.CentralSchemeImportExportUtils;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BgCentralSchemeListPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MODEL = "model";
    private static final String TOOLBARAP = "toolbarap";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_DEL = "btn_del";
    private static final String BTN_UNABLE = "btn_unable";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BTN_EXPORT = "btn_export";
    private static final String BTN_IMPORT = "btn_import";
    private static final String ENTRYENTITY = "entryentity";
    private static final String STATUS = "status";
    private static final String SCHEME_NUMBER = "schemenumber";
    private static final String SCHEME_NAME = "schemename";
    private static final String ORG_NUMBER = "orgnumber";
    private static final String ORG_NAME = "orgname";
    private static final String MODIFIER = "modifier";
    private static final String MODIFIDATE = "modifydate";
    private static final String APPROVE_ACCOUNT = "approveaccount";
    private static final String APPROVE_ORG = "approveorg";
    private static final String ADD_CLOSECALLBACK = "addcloseback";
    private static final String EXCEL_IMPORT = "export_import";
    private static final String BIZRANGE = "bizrange";
    private static final String APPROVERS = "approvers";
    private static final String COLLECTENTITY_NUMBER = "collectentitynumber";
    private static final String COLLECTENTITY_NAME = "collectentityname";
    private static final String CREATER = "creater";
    private static final String CREATEDATE = "createdate";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModel();
        this.setModelFilter();
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (key.equals(MODEL)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(MODEL)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList();
            }
            qFilterList.addAll(ModelUtil.getModelFilter((IFormView)this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addF7SelectListener(this, new String[]{MODEL});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.openSchemeEditPage(null);
                break;
            }
            case "btn_enable": 
            case "btn_unable": {
                this.enableAndUnable(key);
                break;
            }
            case "btn_del": {
                List<Long> list = this.getSelectScheme(key);
                if (list == null) {
                    return;
                }
                if (list.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5df2\u542f\u7528\u7684\u5ba1\u6279\u7ec4\u7ec7\u3002", (String)"BgCenterSchemeListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u786e\u8ba4\u5220\u9664%1\u4e2a\u5173\u95ed\u7684\u65b9\u6848\uff1f", (String)"BgCenterSchemeListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{list.size()}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("confirmDel", (IFormPlugin)this));
                break;
            }
            case "btn_refresh": {
                this.refreshEntry();
                break;
            }
            case "btn_export": {
                this.exportExcel();
                break;
            }
            case "btn_import": {
                this.importExcel();
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (ADD_CLOSECALLBACK.equals(key) || EXCEL_IMPORT.equals(key)) {
            this.refreshEntry();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        if ("confirmDel".equals(key) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.deleteScheme();
            this.refreshEntry();
        }
    }

    private void exportExcel() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BgCenterSchemeListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("dataintegration/centralScheme.xlsx");
        this.createBillSheet(excelWriter, selectRows);
        CentralSchemeImportExportUtils.getInstance().createDimExplain(excelWriter);
        String fileName = ResManager.loadResFormat((String)"\u5f52\u53e3\u65b9\u6848%1.xlsx", (String)"BgCenterSchemeListPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    private void createBillSheet(BgExcelWriter excelWriter, int[] selectRows) {
        String enableMsg = ResManager.loadKDString((String)"\u542f\u7528", (String)"BgCenterSchemeListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String unableMag = ResManager.loadKDString((String)"\u5173\u95ed", (String)"BgCenterSchemeListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        HashSet<Long> selectRowIds = new HashSet<Long>(16);
        for (int selectRow : selectRows) {
            selectRowIds.add(IDUtils.toLong((Object)this.getModel().getValue("id", selectRow)));
        }
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"eb_centralscheme", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)this.getModelId()), new QFilter("id", "in", selectRowIds)});
        if (dynamicObjects == null) {
            return;
        }
        List<Map<String, Object>> schemes = this.buildCentralSchemeEntity(dynamicObjects);
        excelWriter.setStarPosition(3, 0);
        CentralSchemeImportExportUtils.getInstance().modifyTitleRow(excelWriter, false);
        for (Map<String, Object> scheme : schemes) {
            ArrayList accountMembers1 = (ArrayList)scheme.get("accountMembers");
            ArrayList entityMembers1 = (ArrayList)scheme.get("entityMembers");
            Set approverMembers1 = (Set)scheme.get("approverMembers");
            Iterator accountMembers = accountMembers1.iterator();
            Iterator entityMembers = entityMembers1.iterator();
            Iterator approverMembers = approverMembers1.iterator();
            SimpleMemberDto account0 = (SimpleMemberDto)accountMembers.next();
            SimpleMemberDto entity0 = (SimpleMemberDto)entityMembers.next();
            SimpleMemberDto approver0 = (SimpleMemberDto)approverMembers.next();
            excelWriter.createRow(new Object[]{scheme.get("number"), scheme.get("name"), scheme.get("bizrangenumber"), scheme.get(BIZRANGE), scheme.get("entitynumber"), scheme.get("entityname"), entity0.getNumber(), entity0.getName(), entity0.getRange().getName(), account0.getNumber(), account0.getName(), account0.getRange().getName(), approver0.getNumber(), approver0.getName(), (Boolean)scheme.get(STATUS) != false ? enableMsg : unableMag});
            int size0 = Math.max(accountMembers1.size(), entityMembers1.size());
            int size = Math.max(size0, approverMembers1.size());
            for (int i = 1; i < size; ++i) {
                SimpleMemberDto next;
                String entityNumber = "";
                String entityName = "";
                String entityScope = "";
                String accountNumber = "";
                String accountName = "";
                String accountScope = "";
                String approverNumber = "";
                String approveName = "";
                if (entityMembers.hasNext()) {
                    next = (SimpleMemberDto)entityMembers.next();
                    entityNumber = next.getNumber();
                    entityName = next.getName();
                    entityScope = next.getRange().getName();
                }
                if (accountMembers.hasNext()) {
                    next = (SimpleMemberDto)accountMembers.next();
                    accountNumber = next.getNumber();
                    accountName = next.getName();
                    accountScope = next.getRange().getName();
                }
                if (approverMembers.hasNext()) {
                    next = (SimpleMemberDto)approverMembers.next();
                    approverNumber = next.getNumber();
                    approveName = next.getName();
                }
                excelWriter.createRow(new Object[]{"", "", "", "", "", "", entityNumber, entityName, entityScope, accountNumber, accountName, accountScope, approverNumber, approveName});
            }
        }
    }

    private void importExcel() {
        if (this.getModelId() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgCenterSchemeListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openImportPage();
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_import");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u5bfc\u5165", (String)"BgCenterSchemeListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_import");
        formConfig.getPlugins().clear();
        showParameter.setFormConfig(formConfig);
        showParameter.addCustPlugin("kd.epm.eb.formplugin.centerscheme.CentralSchemeImportPlugin");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, EXCEL_IMPORT);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
        this.writeLog("import", new MultiLangEnumBridge("\u5bfc\u5165", "BgCenterSchemeListPlugin_20", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u65b9\u6848\u5bfc\u5165", "BgCenterSchemeListPlugin_7", "epm-eb-formplugin"));
    }

    private void deleteScheme() {
        List<Long> ids = this.getSelectScheme(BTN_DEL);
        if (ids == null) {
            return;
        }
        ApprovePlanUtil.getInstance().deleteSchemes(ids);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BgCenterSchemeListPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        this.writeLog("delete", new MultiLangEnumBridge("\u5220\u9664", "BgCenterSchemeListPlugin_19", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "BgCenterSchemeListPlugin_8", "epm-eb-formplugin"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (MODEL.equals(name)) {
            Object obj = this.getModel().getValue(MODEL);
            if (obj != null) {
                Long modelId = ((DynamicObject)obj).getLong("id");
                this.modelChanged(modelId);
            } else {
                this.getPageCache().remove(MODEL);
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.refreshEntry();
            }
        }
    }

    private void enableAndUnable(String key) {
        MultiLangEnumBridge msg;
        MultiLangEnumBridge opName;
        String opKey;
        List<Long> ids = this.getSelectScheme(key);
        if (ids == null || ids.size() == 0) {
            return;
        }
        boolean enable = BTN_ENABLE.equals(key);
        ApprovePlanUtil.getInstance().updateStatus(enable, ids);
        this.refreshEntry();
        if (enable) {
            opKey = "enable";
            opName = new MultiLangEnumBridge("\u542f\u7528", "BgCenterSchemeListPlugin_4", "epm-eb-formplugin");
            msg = new MultiLangEnumBridge("\u542f\u7528\u6210\u529f\u3002", "BgCenterSchemeListPlugin_9", "epm-eb-formplugin");
        } else {
            opKey = "disable";
            opName = new MultiLangEnumBridge("\u5173\u95ed", "BgCenterSchemeListPlugin_5", "epm-eb-formplugin");
            msg = new MultiLangEnumBridge("\u5173\u95ed\u6210\u529f\u3002", "BgCenterSchemeListPlugin_10", "epm-eb-formplugin");
        }
        this.getView().showSuccessNotification(msg.loadKDString());
        this.writeLog(opKey, opName, msg);
    }

    private List<Long> getSelectScheme(String key) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u65b9\u6848\u3002", (String)"BgCenterSchemeListPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        Map quotedCentralSchemeIdInfo = CentralApprovePlanService.getInstance().getQuotedCentralSchemeIds(this.getModelId());
        ArrayList<Long> ids = new ArrayList<Long>(rows.length);
        for (int row : rows) {
            String value;
            Long schemeId = IDUtils.toLong((Object)this.getModel().getValue("id", row));
            String schemeName = (String)this.getModel().getValue(SCHEME_NAME, row);
            if (BTN_UNABLE.equals(key)) {
                if (quotedCentralSchemeIdInfo.containsKey(schemeId)) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f52\u53e3\u65b9\u6848\u201c%1\u201d\u5df2\u88ab\u5ba1\u6279\u65b9\u6848\u201c%2\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"BgCenterSchemeListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeName, StringUtils.join((Object[])((Set)quotedCentralSchemeIdInfo.get(schemeId)).toArray(), (String)",")}));
                    continue;
                }
            } else if (BTN_DEL.equals(key) && "1".equals(value = (String)this.getModel().getValue(STATUS, row))) continue;
            ids.add(schemeId);
        }
        return ids;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.hyperLinkClick(hyperLinkClickEvent);
        String key = hyperLinkClickEvent.getFieldName();
        if (SCHEME_NAME.equals(key)) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            Object id = this.getModel().getValue("id", rowIndex);
            if (id != null) {
                this.openSchemeEditPage(id.toString());
            }
        }
    }

    private void openSchemeEditPage(String id) {
        String model = this.getPageCache().get(MODEL);
        if (StringUtils.isEmpty((CharSequence)model)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BgCenterSchemeListPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setPageId("centralScheme_" + this.getView().getPageId() + "_" + id);
        showParameter.setFormId("eb_centralscheme");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ADD_CLOSECALLBACK);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam(MODEL, (Object)this.getModelId());
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            showParameter.setPkId((Object)id);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("id", (Object)id);
            showParameter.setCaption(ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u4fee\u6539", (String)"BgCenterSchemeListPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("update", new MultiLangEnumBridge("\u4fee\u6539", "BgCenterSchemeListPlugin_23", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u65b9\u6848\u4fee\u6539", "BgCenterSchemeListPlugin_14", "epm-eb-formplugin"));
        } else {
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCaption(ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u65b0\u589e", (String)"BgCenterSchemeListPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.writeLog("addnew", new MultiLangEnumBridge("\u65b0\u589e", "BgCenterSchemeListPlugin_18", "epm-eb-formplugin"), new MultiLangEnumBridge("\u5f52\u53e3\u65b9\u6848\u65b0\u589e", "BgCenterSchemeListPlugin_15", "epm-eb-formplugin"));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initModel() {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u4f53\u7cfb\u3002", (String)"BgCenterSchemeListPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue(MODEL, (Object)modelId);
            this.modelChanged(modelId);
        }
    }

    private void refreshEntry() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return;
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"eb_centralscheme", (QFilter[])new QFilter[]{new QFilter(MODEL, "=", (Object)modelId)});
        if (dynamicObjects == null) {
            return;
        }
        List<Map<String, Object>> centralSchemes = this.buildCentralSchemeEntity(dynamicObjects);
        if (centralSchemes.size() > 0) {
            this.getModel().beginInit();
            int[] rowIndex = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, centralSchemes.size());
            for (int i = 0; i < centralSchemes.size(); ++i) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex[i]);
                rowEntity.set("id", centralSchemes.get(i).get("id"));
                rowEntity.set(SCHEME_NUMBER, centralSchemes.get(i).get("number"));
                rowEntity.set(SCHEME_NAME, centralSchemes.get(i).get("name"));
                rowEntity.set(ORG_NUMBER, centralSchemes.get(i).get("entitynumber"));
                rowEntity.set(ORG_NAME, centralSchemes.get(i).get("entityname"));
                rowEntity.set(BIZRANGE, centralSchemes.get(i).get(BIZRANGE));
                boolean status = (Boolean)centralSchemes.get(i).get(STATUS);
                rowEntity.set(STATUS, (Object)(status ? "1" : "0"));
                rowEntity.set(APPROVE_ACCOUNT, (Object)String.join((CharSequence)";", (List)centralSchemes.get(i).get("accounts")));
                rowEntity.set(APPROVE_ORG, (Object)String.join((CharSequence)";", (List)centralSchemes.get(i).get("entities")));
                rowEntity.set(APPROVERS, (Object)String.join((CharSequence)";", (List)centralSchemes.get(i).get(APPROVERS)));
                rowEntity.set(COLLECTENTITY_NUMBER, centralSchemes.get(i).get("collectEntityNumber"));
                rowEntity.set(COLLECTENTITY_NAME, centralSchemes.get(i).get("collectEntityName"));
                rowEntity.set(MODIFIER, centralSchemes.get(i).get(MODIFIER));
                rowEntity.set(MODIFIDATE, centralSchemes.get(i).get(MODIFIDATE));
                rowEntity.set(CREATER, centralSchemes.get(i).get(CREATER));
                rowEntity.set(CREATEDATE, centralSchemes.get(i).get(CREATEDATE));
            }
            this.getModel().endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private List<Map<String, Object>> buildCentralSchemeEntity(Map<Object, DynamicObject> dynamicObjects) {
        ArrayList<Map<String, Object>> centralSchemes = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject object : dynamicObjects.values()) {
            HashMap<String, Object> centralScheme = new HashMap<String, Object>(16);
            centralScheme.put("id", object.getLong("id"));
            centralScheme.put("number", object.getString("number"));
            centralScheme.put("name", object.getString("name"));
            centralScheme.put("entitynumber", object.getString("entitynumber.number"));
            centralScheme.put("entityname", object.getString("entitynumber.name"));
            centralScheme.put(CREATER, object.getString("creater.name"));
            centralScheme.put(CREATEDATE, object.getDate(CREATEDATE));
            centralScheme.put(MODIFIDATE, object.getDate(MODIFIDATE));
            centralScheme.put(MODIFIER, object.getString("modifier.name"));
            centralScheme.put(STATUS, object.getBoolean(STATUS));
            centralScheme.put("bizrangenumber", object.getString("bizrange.number"));
            centralScheme.put(BIZRANGE, object.getString("bizrange.name"));
            centralScheme.put(MODEL, object.getLong("model.id"));
            DynamicObjectCollection entryEntity1 = object.getDynamicObjectCollection("entryentity1");
            ArrayList<String> accountSet = new ArrayList<String>(16);
            ArrayList<SimpleMemberDto> accountMember = new ArrayList<SimpleMemberDto>(16);
            if (entryEntity1 != null && entryEntity1.size() > 0) {
                for (DynamicObject k : entryEntity1) {
                    SimpleMemberDto member = new SimpleMemberDto();
                    member.setId(Long.valueOf(k.getLong("accountnumber.id")));
                    member.setNumber(k.getString("accountnumber.number"));
                    member.setName(k.getString("accountnumber.name"));
                    member.setRange(RangeEnum.getRangeByVal((int)k.getInt("accountscope")));
                    accountMember.add(member);
                    accountSet.add(k.getString("accountnumber.name") + "_" + RangeEnum.getRangeByVal((int)k.getInt("accountscope")).getName());
                }
            }
            ArrayList<String> approver = new ArrayList<String>(16);
            HashSet<SimpleMemberDto> approverMembers = new HashSet<SimpleMemberDto>(16);
            String collectEntityNumber = null;
            String collectEntityName = null;
            DynamicObjectCollection entryentity2 = object.getDynamicObjectCollection("entryentity2");
            ArrayList<String> orgSet = new ArrayList<String>(16);
            ArrayList<SimpleMemberDto> orgMember = new ArrayList<SimpleMemberDto>(16);
            if (entryentity2 != null && entryentity2.size() > 0) {
                for (DynamicObject k : entryentity2) {
                    DynamicObjectCollection dynamicObjectCollection;
                    SimpleMemberDto member = new SimpleMemberDto();
                    member.setId(Long.valueOf(k.getLong("entitynumber1.id")));
                    member.setNumber(k.getString("entitynumber1.number"));
                    member.setName(k.getString("entitynumber1.name"));
                    member.setRange(RangeEnum.getRangeByVal((int)k.getInt("orgscope")));
                    orgMember.add(member);
                    orgSet.add(k.getString("entitynumber1.name") + RangeEnum.getRangeByVal((int)k.getInt("orgscope")).getName());
                    if (approver.size() == 0 && (dynamicObjectCollection = k.getDynamicObjectCollection("checker")) != null && dynamicObjectCollection.size() != 0) {
                        for (DynamicObject checkerObject : dynamicObjectCollection) {
                            SimpleMemberDto userDto = new SimpleMemberDto();
                            userDto.setId((Long)checkerObject.getPkValue());
                            userDto.setNumber(checkerObject.getString("FBasedataId.number"));
                            userDto.setName(checkerObject.getString("FBasedataId.name"));
                            approverMembers.add(userDto);
                            approver.add(checkerObject.getString("FBasedataId.name"));
                        }
                    }
                    if (collectEntityNumber != null) continue;
                    DynamicObject collectOrgObject = k.getDynamicObject("collectorg");
                    collectEntityNumber = collectOrgObject.getString("number");
                    collectEntityName = collectOrgObject.getString("name");
                }
            }
            centralScheme.put("accounts", accountSet);
            centralScheme.put("accountMembers", accountMember);
            centralScheme.put("entities", orgSet);
            centralScheme.put("entityMembers", orgMember);
            centralScheme.put(APPROVERS, approver);
            centralScheme.put("approverMembers", approverMembers);
            centralScheme.put("collectEntityNumber", collectEntityNumber);
            centralScheme.put("collectEntityName", collectEntityName);
            centralSchemes.add(centralScheme);
        }
        return centralSchemes;
    }

    private void modelChanged(Long modelId) {
        this.getPageCache().put(MODEL, modelId.toString());
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        this.refreshEntry();
    }

    private void setModelFilter() {
        QFilter filter1 = new QFilter("id", "=", (Object)this.getModelId());
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(MODEL);
        this.getView().getFormShowParameter().setAppId("bgm");
        List modelFilters = ModelUtil.getModelFilter((IFormView)this.getView());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(modelFilters.size());
        for (QFilter filter : modelFilters) {
            filter.or(filter1);
            filters.add(filter);
        }
        basedataEdit.setQFilters(filters);
    }

    @Override
    public Long getModelId() {
        Long modelId = (Long)this.getValue(MODEL, "id");
        if (modelId != null && modelId != 0L) {
            return modelId;
        }
        return 0L;
    }
}

