/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centerscheme;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CentralSchemeImportExportUtils {
    private static List<String> commonTitle;
    private static Set<String> rangeApproveEntityList;
    private static Set<String> rangeApproveAccountList;
    private static List<String> status;
    private static final CentralSchemeImportExportUtils instance;

    private CentralSchemeImportExportUtils() {
        this.initParams();
    }

    public static CentralSchemeImportExportUtils getInstance() {
        return instance;
    }

    private final void initParams() {
        commonTitle = Arrays.asList(ResManager.loadKDString((String)"*\u5f52\u53e3\u65b9\u6848\u7f16\u7801", (String)"CentralSchemeImportExportUtils_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5f52\u53e3\u65b9\u6848\u540d\u79f0", (String)"CentralSchemeImportExportUtils_1", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u4e1a\u52a1\u6a21\u578b\u7f16\u7801", (String)"CentralSchemeImportExportUtils_2", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u540d\u79f0", (String)"CentralSchemeImportExportUtils_3", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5f52\u53e3\u7ec4\u7ec7\u7f16\u7801", (String)"CentralSchemeImportExportUtils_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f52\u53e3\u7ec4\u7ec7\u540d\u79f0", (String)"CentralSchemeImportExportUtils_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u7f16\u7801\uff08Entity)", (String)"CentralSchemeImportExportUtils_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u540d\u79f0", (String)"CentralSchemeImportExportUtils_7", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u8303\u56f4", (String)"CentralSchemeImportExportUtils_8", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5ba1\u6279\u79d1\u76ee\u7f16\u7801", (String)"CentralSchemeImportExportUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6279\u79d1\u76ee\u540d\u79f0", (String)"CentralSchemeImportExportUtils_10", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5ba1\u6279\u79d1\u76ee\u8303\u56f4", (String)"CentralSchemeImportExportUtils_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u5ba1\u6279\u4eba\u7f16\u7801", (String)"CentralSchemeImportExportUtils_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5ba1\u6279\u4eba\u540d\u79f0", (String)"CentralSchemeImportExportUtils_13", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"*\u72b6\u6001", (String)"CentralSchemeImportExportUtils_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        rangeApproveEntityList = Sets.newHashSet((Object[])new String[]{RangeEnum.ONLY.getName(), RangeEnum.DIRECTSUB_EXCLUDE.getName(), RangeEnum.DIRECTSUB.getName(), RangeEnum.ALL_DETAIL.getName()});
        rangeApproveAccountList = Sets.newHashSet((Object[])new String[]{RangeEnum.ONLY.getName(), RangeEnum.DIRECTSUB_EXCLUDE.getName(), RangeEnum.DIRECTSUB.getName(), RangeEnum.ALL_EXCLUDE.getName(), RangeEnum.ALL.getName(), RangeEnum.ALL_DETAIL.getName(), RangeEnum.ALL_NOTDETAIL.getName()});
        status = Arrays.asList(ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralSchemeImportExportUtils_15", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u95ed", (String)"CentralSchemeImportExportUtils_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    public Set<String> getRangeApproveEntityList() {
        return rangeApproveEntityList;
    }

    public Set<String> getRangeApproveAccountList() {
        return rangeApproveAccountList;
    }

    public List<String> getStatus() {
        return status;
    }

    public void createDimExplain(BgExcelWriter excelWriter) {
        excelWriter.createSheet(ResManager.loadKDString((String)"\u6a21\u677f\u4f7f\u7528\u8bf4\u660e", (String)"CentralSchemeImportExportUtils_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        List<String> explainInfo = Arrays.asList(ResManager.loadKDString((String)"\u6a21\u677f\u4f7f\u7528\u8bf4\u660e\u4fe1\u606f", (String)"CentralSchemeImportExportUtils_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"1. \u7b2c\u4e00\u884c\u5f52\u53e3\u65b9\u6848\uff08\u7ec4\u7ec7\uff09\u5230\u7b2c\u4e8c\u884c\u5f52\u53e3\u65b9\u6848\uff08\u7ec4\u7ec7\uff09\u4e4b\u95f4\u7684\u5ba1\u6279\u8303\u56f4\u6570\u636e\u90fd\u5c5e\u4e8e\u7b2c\u4e00\u4e2a\u5f52\u53e3\u65b9\u6848\u7684\u5ba1\u6279\u8303\u56f4\uff1b", (String)"CentralSchemeImportExportUtils_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"2. \u5f52\u53e3\u65b9\u6848\u7f16\u7801\u76f8\u540c\uff0c\u89c6\u4e3a\u540c\u4e00\u6761\u6570\u636e\u5bfc\u5165\uff1b\u5f52\u53e3\u65b9\u6848\u7f16\u7801\u4e0d\u540c\u89c6\u4e3a\u4e0d\u540c\u6570\u636e\u5bfc\u5165", (String)"CentralSchemeImportExportUtils_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        for (String info : explainInfo) {
            excelWriter.createRow(new Object[]{info});
        }
    }

    public Boolean checkTemplateFormat(List<String> strings) {
        for (int i = 0; i < strings.size(); ++i) {
            if (commonTitle.get(i).equals(strings.get(i))) continue;
            return true;
        }
        return false;
    }

    public CentralSchemeDataOfModel getCentralSchemeDataOfModel(Long modelId) {
        HashSet<String> nameSet = new HashSet<String>(16);
        HashSet<String> numberSet = new HashSet<String>(16);
        HashMap<String, SimpleCentralScheme> centralSchemeDtoMap = new HashMap<String, SimpleCentralScheme>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_centralscheme", (String)"name,number,bizrange.number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        if (dynamicObjects != null) {
            for (DynamicObject object : dynamicObjects) {
                nameSet.add(object.getString("name"));
                numberSet.add(object.getString("number"));
                SimpleCentralScheme centralSchemeDto = new SimpleCentralScheme();
                centralSchemeDto.setBizRangeNumber(object.getString("bizrange.number"));
                centralSchemeDto.setNumber(object.getString("number"));
                centralSchemeDto.setName(object.getString("name"));
                centralSchemeDtoMap.put(object.getString("number"), centralSchemeDto);
            }
        }
        return new CentralSchemeDataOfModel(nameSet, numberSet, centralSchemeDtoMap);
    }

    public void modifyTitleRow(BgExcelWriter excelWriter, Boolean isErrorExcel) {
        int startColIndex = isErrorExcel != false ? 1 : 0;
        excelWriter.getWorkbook().setSheetName(0, ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848", (String)"BgCenterSchemeListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Sheet sheetAt = excelWriter.getWorkbook().getSheetAt(0);
        Row row0 = sheetAt.getRow(0);
        row0.getCell(startColIndex).setCellValue(ResManager.loadKDString((String)"\u5f52\u53e3\u65b9\u6848\u5bfc\u5165\u6a21\u677f", (String)"CentralSchemeImportExportUtils_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Row row1 = sheetAt.getRow(1);
        row1.getCell(startColIndex).setCellValue(ResManager.loadKDString((String)"\u7ea2\u8272*\u5fc5\u586b", (String)"CentralSchemeImportExportUtils_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        Row row2 = sheetAt.getRow(2);
        if (isErrorExcel.booleanValue()) {
            row2.getCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u8be6\u60c5\u5982\u4e0b", (String)"CentralSchemeImportExportUtils_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        int i = startColIndex;
        for (String column : commonTitle) {
            row2.getCell(i).setCellValue(column);
            ++i;
        }
    }

    static {
        instance = new CentralSchemeImportExportUtils();
    }

    static class SimpleCentralScheme {
        private String name;
        private String number;
        private String bizRangeNumber;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getBizRangeNumber() {
            return this.bizRangeNumber;
        }

        public void setBizRangeNumber(String bizRangeNumber) {
            this.bizRangeNumber = bizRangeNumber;
        }
    }

    static class CentralSchemeDataOfModel {
        Map<String, SimpleCentralScheme> allNumberToSchemeMap = new HashMap<String, SimpleCentralScheme>(16);
        private Set<String> allNames = new HashSet<String>(16);
        private Set<String> allNumbers = new HashSet<String>(16);

        public CentralSchemeDataOfModel(Set<String> allNames, Set<String> allNumbers, Map<String, SimpleCentralScheme> allNumberToSchemeMap) {
            this.allNames = allNames;
            this.allNumbers = allNumbers;
            this.allNumberToSchemeMap = allNumberToSchemeMap;
        }

        public Set<String> getAllNames() {
            return this.allNames;
        }

        public void setAllNames(Set<String> allNames) {
            this.allNames = allNames;
        }

        public Set<String> getAllNumbers() {
            return this.allNumbers;
        }

        public void setAllNumbers(Set<String> allNumbers) {
            this.allNumbers = allNumbers;
        }

        public Map<String, SimpleCentralScheme> getAllNumberToSchemeMap() {
            return this.allNumberToSchemeMap;
        }

        public void setAllNumberToSchemeMap(Map<String, SimpleCentralScheme> allNumberToSchemeMap) {
            this.allNumberToSchemeMap = allNumberToSchemeMap;
        }
    }
}

