/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centerscheme;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralApprovePlanService;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.CentralScheme;
import kd.epm.eb.common.centralapproval.entity.ApprovePlanDto;
import kd.epm.eb.common.enums.ImportEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UploadUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.excel.BgExcelReader;
import kd.epm.eb.common.utils.excel.BgExcelWriter;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.centerscheme.CentralSchemeImportExportUtils;
import kd.epm.eb.formplugin.centerscheme.ValidDataInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CentralSchemeImportPlugin
extends AbstractBasePlugin
implements UploadListener {
    protected static Log log = LogFactory.getLog(CentralSchemeImportPlugin.class);
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String BTN_OK = "btnok";
    CentralSchemeImportExportUtils instance = CentralSchemeImportExportUtils.getInstance();

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>(16);
        dataMap.put("maxatmcount", 1);
        this.getView().updateControlMetadata("attachmentpanelap", dataMap);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_DOWNLOAD, BTN_OK});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downImportTemplate();
                break;
            }
        }
    }

    private void importData() {
        String fileUrl = this.getPageCache().get("file_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"CentralSchemeImportPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        List inputStreams = UploadUtil.getFileInputStreams((String)fileUrl);
        ArrayList<List<String>> dataList = new ArrayList<List<String>>(10);
        try {
            for (InputStream inputStream : inputStreams) {
                BgExcelReader excelReader = BgExcelReader.getInstance().readByInputstream(inputStream);
                List list = excelReader.read(2, 0, 14);
                dataList.addAll(list);
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u6587\u6863\u3002", (String)"CentralSchemeImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(dataList) || dataList.get(0) == null || this.instance.checkTemplateFormat((List)dataList.get(0)).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0b\u8f7d\u6b63\u786e\u683c\u5f0f\u7684\u6a21\u677f\u3002", (String)"CentralSchemeImportPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ValidDataInfo validDataInfo = this.getExcelValidInfo(dataList);
        if (this.validExcel(dataList, validDataInfo)) {
            BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("dataintegration/centralScheme_err.xlsx");
            this.instance.modifyTitleRow(excelWriter, true);
            excelWriter.setStarPosition(3, 0);
            for (List list : dataList) {
                excelWriter.createRow((Iterable)list);
            }
            this.instance.createDimExplain(excelWriter);
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u9519\u8bef\u8be6\u60c5.xlsx", (String)"CentralSchemeImportPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            String string = excelWriter.getDownloadUrl(fileName);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)string);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u9519\u8bef\u8be6\u60c5\u3002", (String)"CentralSchemeImportPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<CentralScheme> mapObjList = this.toObj(dataList, validDataInfo);
        if (mapObjList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6709\u6548\u6570\u636e\u3002", (String)"CentralSchemeImportPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.saveData(mapObjList);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DataUploadAccountImportPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void saveData(List<CentralScheme> mapObjList) {
        if (CollectionUtils.isEmpty(mapObjList)) {
            return;
        }
        List numbers = mapObjList.stream().map(CentralScheme::getNumber).collect(Collectors.toList());
        Map<Object, Object> objectsMap = new HashMap(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_centralscheme", (String)"id,creater,createdate,number", (QFilter[])new QFilter[]{new QFilter("number", "in", numbers).and(new QFilter("model", "=", (Object)this.getModelId()))});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            objectsMap = dynamicObjects.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e));
        }
        ArrayList<Long> needDelData = new ArrayList<Long>(10);
        ArrayList<DynamicObject> centralSchemeObjects = new ArrayList<DynamicObject>(10);
        ArrayList<Object[]> entityObjs = new ArrayList<Object[]>(16);
        ArrayList<Object[]> accountObjs = new ArrayList<Object[]>(16);
        ArrayList<Object[]> approverObjs = new ArrayList<Object[]>(16);
        Long modelId = this.getModelId();
        Date now = TimeServiceHelper.now();
        Long userId = UserUtils.getUserId();
        for (CentralScheme scheme : mapObjList) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)(scheme.getAccountMembers().size() + scheme.getEntityMembers().size() + 1));
            DynamicObject object = (DynamicObject)objectsMap.get(scheme.getNumber());
            if (object != null) {
                ids[0] = object.getLong("id");
            }
            DynamicObject centralSchemeObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralscheme");
            this.packageSchemeObject(ids, scheme, centralSchemeObject, entityObjs, accountObjs, approverObjs, modelId, now, userId);
            if (object != null) {
                needDelData.add(object.getLong("id"));
                centralSchemeObject.set("creater", (Object)object.getLong("creater.id"));
                centralSchemeObject.set("createdate", (Object)object.getDate("createdate"));
            }
            if (CollectionUtils.isEmpty(accountObjs) || CollectionUtils.isEmpty(entityObjs) || CollectionUtils.isEmpty(approverObjs)) continue;
            centralSchemeObjects.add(centralSchemeObject);
        }
        this.executeSave(needDelData, entityObjs, accountObjs, approverObjs, centralSchemeObjects);
    }

    private void executeSave(List<Long> needDelData, List<Object[]> entityObjs, List<Object[]> accountObjs, List<Object[]> approverObjs, List<DynamicObject> centralSchemeObjects) {
        String centralSchemeOrgSql = "insert into t_eb_centralschemeorg(FId,forgid,fcollectorgid,forgscope,FSeq,FEntryId) VALUES (?,?,?,?,?,?)";
        String centralSchemeAccountSql = "insert into t_eb_centralschemeaccount(FId,faccountid,faccountscope,FSeq,FEntryId) VALUES (?,?,?,?,?)";
        String centralSchemeCheckerSql = "insert into t_eb_centralschemechecker(FEntryId,FBasedataId,Fpkid) VALUES (?,?,?)";
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            if (needDelData.size() > 0) {
                DeleteServiceHelper.delete((String)"eb_centralscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", needDelData)});
            }
            if (centralSchemeObjects.size() < 1) {
                return;
            }
            try {
                DBRoute epm = DBRoute.of((String)"epm");
                SaveServiceHelper.save((DynamicObject[])centralSchemeObjects.toArray(new DynamicObject[0]));
                this.executeOrBatch(epm, centralSchemeAccountSql, accountObjs, true);
                this.executeOrBatch(epm, centralSchemeOrgSql, entityObjs, true);
                this.executeOrBatch(epm, centralSchemeCheckerSql, approverObjs, true);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void executeOrBatch(DBRoute route, String sql, List<Object[]> paramsList, boolean isBatch) {
        if (isBatch) {
            DB.executeBatch((DBRoute)route, (String)sql, paramsList);
        } else {
            DB.execute((DBRoute)route, (String)sql);
        }
    }

    private void packageSchemeObject(long[] ids, CentralScheme scheme, DynamicObject centralSchemeObject, List<Object[]> entityObjs, List<Object[]> accountObjs, List<Object[]> approverObjs, Long modelId, Date now, Long userId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(scheme.getBizRangeId());
        centralSchemeObject.set("id", (Object)ids[0]);
        centralSchemeObject.set("number", (Object)scheme.getNumber());
        centralSchemeObject.set("name", (Object)scheme.getName());
        centralSchemeObject.set("bizrange", (Object)scheme.getBizRangeId());
        centralSchemeObject.set("model", (Object)modelId);
        centralSchemeObject.set("entitynumber", (Object)scheme.getCentralEntity());
        centralSchemeObject.set("status", (Object)scheme.getStatus());
        centralSchemeObject.set("creater", (Object)userId);
        centralSchemeObject.set("createdate", (Object)now);
        centralSchemeObject.set("modifier", (Object)userId);
        centralSchemeObject.set("modifydate", (Object)now);
        List entities = scheme.getEntityMembers();
        ArrayList<Object[]> curEntities = new ArrayList<Object[]>(10);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        for (int i = 0; i < entities.size(); ++i) {
            if (entityIds.contains(((Member)entities.get(i)).getId())) continue;
            Object[] obj = new Object[6];
            obj[0] = ids[0];
            obj[1] = ((Member)entities.get(i)).getId();
            obj[2] = this.getCollectEntity(scheme.getEntityMembers(), dimViewMap);
            RangeEnum rangeByName = RangeEnum.getRangeByName((String)((Member)entities.get(i)).getLongNumber());
            if (rangeByName == null) continue;
            obj[3] = rangeByName.getIndex();
            obj[4] = i + 1;
            obj[5] = ids[i + 1];
            entityObjs.add(obj);
            curEntities.add(obj);
            entityIds.add(((Member)entities.get(i)).getId());
        }
        List accounts = scheme.getAccountMembers();
        HashSet<Long> accountIds = new HashSet<Long>(16);
        for (int i = 0; i < accounts.size(); ++i) {
            if (accountIds.contains(((Member)accounts.get(i)).getId())) continue;
            Object[] obj = new Object[5];
            obj[0] = ids[0];
            obj[1] = ((Member)accounts.get(i)).getId();
            RangeEnum rangeByName = RangeEnum.getRangeByName((String)((Member)accounts.get(i)).getLongNumber());
            if (rangeByName == null) continue;
            obj[2] = rangeByName.getIndex();
            obj[3] = i + 1;
            obj[4] = ids[i + entities.size() + 1];
            accountObjs.add(obj);
            accountIds.add(((Member)accounts.get(i)).getId());
        }
        Set approvers = scheme.getApprovers();
        curEntities.forEach(e -> {
            for (Long id : approvers) {
                Object[] obj = new Object[]{e[5], id, GlobalIdUtil.genGlobalLongId()};
                approverObjs.add(obj);
            }
        });
    }

    private Object getCollectEntity(List<Member> entityMembers, Map<String, Long> dimViewMap) {
        Member member;
        ArrayList<String> entityMemberNumbers = new ArrayList<String>(10);
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        for (int i = 0; i < entityMembers.size(); ++i) {
            RangeEnum rangeByName = RangeEnum.getRangeByName((String)entityMembers.get(i).getLongNumber());
            if (rangeByName == null) continue;
            int orgScope = rangeByName.getIndex();
            String orgNumber = entityMembers.get(i).getNumber();
            List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewMap.get(SysDimensionEnum.Entity.getNumber()), orgNumber, orgScope);
            if (members == null || members.size() <= 0) continue;
            members.forEach(h -> entityMemberNumbers.add(h.getLongNumber()));
        }
        List<String> sameParent = this.getSameParent(entityMemberNumbers);
        if (!sameParent.isEmpty() && (member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewMap.get(SysDimensionEnum.Entity.getNumber()), sameParent.get(sameParent.size() - 1))) != null) {
            return member.getId();
        }
        return null;
    }

    private List<String> getSameParent(List<String> memberList) {
        List<String> longNumberList = new ArrayList<String>(16);
        for (String longNumber : memberList) {
            String[] longNUmberStrArray = longNumber.split("!");
            if (longNumberList.size() == 0) {
                longNumberList = Arrays.asList(longNUmberStrArray);
                continue;
            }
            int n = longNumberList.size();
            for (int m = 0; m < longNumberList.size(); ++m) {
                if (!longNumberList.get(m).equals(longNUmberStrArray[m])) {
                    n = m;
                    break;
                }
                if (m != longNUmberStrArray.length - 1) continue;
                n = longNUmberStrArray.length - 1;
                break;
            }
            if (n >= longNumberList.size()) continue;
            longNumberList = longNumberList.subList(0, n);
        }
        return longNumberList;
    }

    private boolean validExcel(List<List<String>> dataList, ValidDataInfo validDataInfo) {
        dataList.remove(0);
        boolean hasErr = false;
        String bizNumber = null;
        String schemeNumber = null;
        HashMap<String, String> schemeEntityNumberMap = new HashMap<String, String>(16);
        HashMap<String, Integer> schemeNumberRowMap = new HashMap<String, Integer>(16);
        CentralSchemeImportExportUtils.CentralSchemeDataOfModel centralSchemeData = this.instance.getCentralSchemeDataOfModel(this.getModelId());
        Map quotedCentralSchemeNumberInfo = CentralApprovePlanService.getInstance().getQuotedCentralSchemeNumbers(this.getModelId());
        boolean isAddAndUpdate = this.isAddAndUpdate();
        for (int i = 0; i < dataList.size(); ++i) {
            ArrayList<Object> emptyCollection = new ArrayList<Object>(Collections.nCopies(15, null));
            if (CollectionUtils.isEqualCollection((Collection)dataList.get(i), emptyCollection)) continue;
            List<String> row = dataList.get(i);
            ArrayList<String> errMsgList = new ArrayList<String>(4);
            Boolean isSchemeRow = Boolean.FALSE;
            if (row.get(0) != null && !"".equals(row.get(0)) || i == 0) {
                schemeNumber = row.get(0);
                bizNumber = row.get(2);
                isSchemeRow = Boolean.TRUE;
            }
            this.checkoutDataValid(row, errMsgList, bizNumber, isSchemeRow, schemeEntityNumberMap, schemeNumberRowMap, centralSchemeData, validDataInfo, isAddAndUpdate, quotedCentralSchemeNumberInfo);
            if (!errMsgList.isEmpty()) {
                hasErr = Boolean.TRUE;
                row.add(0, org.apache.commons.lang3.StringUtils.join(errMsgList, (String)","));
                continue;
            }
            if (isSchemeRow.booleanValue() && schemeEntityNumberMap.get(schemeNumber) == null) {
                schemeEntityNumberMap.put(schemeNumber, row.get(4));
                schemeNumberRowMap.put(schemeNumber, i + 4);
            }
            row.add(0, null);
        }
        return hasErr;
    }

    private void checkoutDataValid(List<String> row, List<String> errMsgList, String bizNumber, Boolean isSchemeRow, Map<String, String> schemeEntityNumberMap, Map<String, Integer> schemeNumberRowMap, CentralSchemeImportExportUtils.CentralSchemeDataOfModel centralSchemeData, ValidDataInfo validDataInfo, boolean isAddAndUpdate, Map<String, Set<String>> quotedCentralSchemeNumberInfo) {
        Map<String, Long> validBizModelInfo = validDataInfo.getValidBizModelInfo();
        Map<String, Long> validEntityInfo = validDataInfo.getValidEntityInfo().get(bizNumber);
        Map<String, Long> validAccountInfo = validDataInfo.getValidAccountInfo().get(bizNumber);
        Map<String, Long> validUserInfo = validDataInfo.getValidUserInfo();
        List<String> status = this.instance.getStatus();
        Set<String> rangeApproveEntityList = this.instance.getRangeApproveEntityList();
        Set<String> rangeApproveAccountList = this.instance.getRangeApproveAccountList();
        Set<String> allNames = centralSchemeData.getAllNames();
        Set<String> allNumbers = centralSchemeData.getAllNames();
        Map<String, CentralSchemeImportExportUtils.SimpleCentralScheme> allNumberToObjectMap = centralSchemeData.getAllNumberToSchemeMap();
        if (isSchemeRow.booleanValue()) {
            if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{row.get(0), row.get(1), row.get(2), row.get(4), row.get(6), row.get(8), row.get(9), row.get(11), row.get(12), row.get(14)})) {
                errMsgList.add(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u672a\u586b", (String)"CentralSchemeImportPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                if (!CheckStringsUtil.checkAllowNumStart((String)row.get(0))) {
                    errMsgList.add(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u3002", (String)"CentralSchemeImportPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (row.get(0).length() > 75) {
                    errMsgList.add(ResManager.loadKDString((String)"\u7f16\u7801\u6700\u591a\u652f\u630175\u4e2a\u5b57\u7b26\u3002", (String)"CentralSchemeImportPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    boolean existRepeatNumber = allNumbers.contains(row.get(0));
                    if (!isAddAndUpdate && existRepeatNumber) {
                        errMsgList.add(ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u7684\u65b9\u6848\u5df2\u5b58\u5728\u4e8e\u4f53\u7cfb\u4e2d\u3002", (String)"CentralSchemeImportPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                CentralSchemeImportExportUtils.SimpleCentralScheme centralSchemeDto = allNumberToObjectMap.get(row.get(0));
                if (!this.checkAllowNameStart(row.get(1))) {
                    errMsgList.add(ResManager.loadKDString((String)"\u540d\u79f0\u683c\u5f0f\u53ea\u53ef\u5305\u542b\u4e2d\u82f1\u6587,\u6570\u5b57\u6216\u82f1\u6587\u62ec\u53f7\u3001\u6a2a\u6760\u3001\u4e0b\u5212\u7ebf\u3002", (String)"CentralSchemeImportPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else if (row.get(1).length() > 75) {
                    errMsgList.add(ResManager.loadKDString((String)"\u540d\u79f0\u6700\u591a\u652f\u630175\u4e2a\u5b57\u7b26\u3002", (String)"CentralSchemeImportPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    boolean existRepeatName = allNames.contains(row.get(1));
                    if (isAddAndUpdate && centralSchemeDto != null && centralSchemeDto.getName() != null && !centralSchemeDto.getName().equals(row.get(1)) && existRepeatName) {
                        errMsgList.add(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u7684\u65b9\u6848\u5df2\u5b58\u5728\u4e8e\u4f53\u7cfb\u4e2d\u3002", (String)"CentralSchemeImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    } else if (!isAddAndUpdate && existRepeatName) {
                        errMsgList.add(ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u7684\u65b9\u6848\u5df2\u5b58\u5728\u4e8e\u4f53\u7cfb\u4e2d\u3002", (String)"CentralSchemeImportPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                if (isAddAndUpdate && centralSchemeDto != null && centralSchemeDto.getBizRangeNumber() != null && !centralSchemeDto.getBizRangeNumber().equals(row.get(2))) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u66f4\u65b0\u6570\u636e\u65f6\u4e0d\u80fd\u4fee\u6539\u4e1a\u52a1\u6a21\u578b\uff0c\u539f\u4e1a\u52a1\u6a21\u578b\u4e3a%1\u3002", (String)"CentralSchemeImportPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[]{centralSchemeDto.getBizRangeNumber()}));
                } else if (validBizModelInfo.size() < 1 || !validBizModelInfo.containsKey(row.get(2))) {
                    errMsgList.add(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0d\u5b58\u5728\u4e8e\u8be5\u4f53\u7cfb\u4e2d\u3002", (String)"CentralSchemeImportPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (validBizModelInfo.containsKey(bizNumber)) {
                    if (schemeEntityNumberMap.get(row.get(0)) != null && !row.get(4).equals(schemeEntityNumberMap.get(row.get(0)))) {
                        errMsgList.add(ResManager.loadResFormat((String)"\u4e0e\u7b2c%1\u884c\u5f52\u53e3\u65b9\u6848\u7f16\u7801\u76f8\u540c\uff0c\u5f52\u53e3\u7ec4\u7ec7\u4e0d\u540c\u3002", (String)"CentralSchemeImportPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{schemeNumberRowMap.get(row.get(0))}));
                    }
                    if (validEntityInfo == null || !validEntityInfo.containsKey(row.get(4))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\uff0c\u8be5\u5f52\u53e3\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (validEntityInfo == null || !validEntityInfo.containsKey(row.get(6))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\uff0c\u8be5\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if ("Entity".equals(row.get(6))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u65e0\u6cd5\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"CentralSchemeImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (!rangeApproveEntityList.contains(row.get(8))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u8303\u56f4\u4e0d\u5408\u6cd5", (String)"CentralSchemeImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (validAccountInfo == null || !validAccountInfo.containsKey(row.get(9))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\uff0c\u8be5\u5ba1\u6279\u79d1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if ("Account".equals(row.get(9))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u79d1\u76ee\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"CentralSchemeImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (!rangeApproveAccountList.contains(row.get(11))) {
                        errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u79d1\u76ee\u8303\u56f4\u4e0d\u5408\u6cd5", (String)"CentralSchemeImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                if (!validUserInfo.containsKey(row.get(12))) {
                    errMsgList.add(ResManager.loadKDString((String)"\u8be5\u5ba1\u6279\u4eba\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (isAddAndUpdate && status.get(1).equals(row.get(14)) && quotedCentralSchemeNumberInfo.containsKey(row.get(0))) {
                    errMsgList.add(ResManager.loadResFormat((String)"\u8be5\u5f52\u53e3\u65b9\u6848\u5df2\u88ab\u5ba1\u6279\u65b9\u6848\u201c%1\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5173\u95ed\u3002", (String)"CentralSchemeImportPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])quotedCentralSchemeNumberInfo.get(row.get(0)).toArray(), (String)",")}));
                }
                if (!status.contains(row.get(14))) {
                    errMsgList.add(ResManager.loadKDString((String)"\u72b6\u6001\u53ea\u53ef\u4ee5\u4e3a[\u542f\u7528]\u6216[\u5173\u95ed]", (String)"CentralSchemeImportPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (validBizModelInfo.size() > 0 && validBizModelInfo.containsKey(bizNumber)) {
            if (!(row.get(6) == null || "".equals(row.get(6)) || validEntityInfo != null && validEntityInfo.containsKey(row.get(6)))) {
                errMsgList.add(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\uff0c\u8be5\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if ("Entity".equals(row.get(6))) {
                errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u65e0\u6cd5\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"CentralSchemeImportPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (row.get(8) != null && !"".equals(row.get(8)) && !rangeApproveEntityList.contains(row.get(8))) {
                errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u7ec4\u7ec7\u8303\u56f4\u4e0d\u5408\u6cd5", (String)"CentralSchemeImportPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtil.isEmptyString((String)row.get(6)) && StringUtil.isEmptyString((String)row.get(8))) {
                errMsgList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5ba1\u6279\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"CentralSchemeImportPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!(row.get(9) == null || "".equals(row.get(9)) || validAccountInfo != null && validAccountInfo.containsKey(row.get(9)))) {
                errMsgList.add(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u4e0b\uff0c\u8be5\u5ba1\u6279\u79d1\u76ee\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if ("Account".equals(row.get(9))) {
                errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u79d1\u76ee\u4e0d\u5141\u8bb8\u9009\u62e9\u6839\u8282\u70b9\u3002", (String)"CentralSchemeImportPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (row.get(11) != null && !"".equals(row.get(11)) && !rangeApproveAccountList.contains(row.get(11))) {
                errMsgList.add(ResManager.loadKDString((String)"\u5ba1\u6279\u7f16\u5236\u79d1\u76ee\u8303\u56f4\u4e0d\u5408\u6cd5", (String)"CentralSchemeImportPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtil.isEmptyString((String)row.get(9)) && StringUtil.isEmptyString((String)row.get(11))) {
                errMsgList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5ba1\u6279\u79d1\u76ee\u8303\u56f4\u3002", (String)"CentralSchemeImportPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (row.get(12) != null && !"".equals(row.get(12)) && !validUserInfo.containsKey(row.get(12))) {
                errMsgList.add(ResManager.loadKDString((String)"\u8be5\u5ba1\u6279\u4eba\u4e0d\u5b58\u5728\u3002", (String)"CentralSchemeImportPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<CentralScheme> toObj(List<List<String>> dataList, ValidDataInfo validDataInfo) {
        ArrayList<Object> centralSchemes = new ArrayList<CentralScheme>();
        HashMap<String, CentralScheme> centralSchemeMap = new HashMap<String, CentralScheme>(16);
        Map<String, Long> validBizModelInfo = validDataInfo.getValidBizModelInfo();
        Map<String, Map<String, Long>> validEntityInfo = validDataInfo.getValidEntityInfo();
        Map<String, Map<String, Long>> validAccountInfo = validDataInfo.getValidAccountInfo();
        Map<String, Long> validUserInfo = validDataInfo.getValidUserInfo();
        String bizModelNumber = "";
        for (List<String> list : dataList) {
            CentralScheme centralScheme;
            if (list == null || list.size() <= 0) continue;
            if (!"".equals(list.get(1)) && list.get(1) != null) {
                centralScheme = new CentralScheme();
                centralScheme.setNumber(list.get(1));
                centralScheme.setName(list.get(2));
                bizModelNumber = list.get(3);
                centralScheme.setBizRangeId(validBizModelInfo.get(bizModelNumber));
                if (validEntityInfo.get(bizModelNumber) != null) {
                    centralScheme.setCentralEntity(validEntityInfo.get(bizModelNumber).get(list.get(5)));
                }
                centralScheme.setStatus(ResManager.loadKDString((String)"\u542f\u7528", (String)"CentralSchemeImportPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(list.get(15)) ? Boolean.TRUE : Boolean.FALSE);
                centralSchemes.add(centralScheme);
                centralSchemeMap.put(centralScheme.getNumber(), centralScheme);
            }
            centralScheme = (CentralScheme)centralSchemes.get(centralSchemes.size() - 1);
            if (!StringUtil.isEmptyString((String)list.get(7)) && !StringUtil.isEmptyString((String)list.get(9)) && validEntityInfo.get(bizModelNumber) != null) {
                Member entityMember = new Member();
                entityMember.setId(validEntityInfo.get(bizModelNumber).get(list.get(7)));
                entityMember.setNumber(list.get(7));
                entityMember.setLongNumber(list.get(9));
                if (centralScheme.getEntityMembers().size() > 0) {
                    centralScheme.getEntityMembers().removeIf(k -> k.getId().equals(entityMember.getId()) && k.getLongNumber().equals(entityMember.getLongNumber()));
                }
                centralScheme.getEntityMembers().add(entityMember);
            }
            if (!StringUtil.isEmptyString((String)list.get(10)) && !StringUtil.isEmptyString((String)list.get(12)) && validAccountInfo.get(bizModelNumber) != null) {
                Member accountMember = new Member();
                accountMember.setId(validAccountInfo.get(bizModelNumber).get(list.get(10)));
                accountMember.setNumber(list.get(10));
                accountMember.setLongNumber(list.get(12));
                if (centralScheme.getAccountMembers().size() > 0) {
                    centralScheme.getAccountMembers().removeIf(k -> k.getId().equals(accountMember.getId()) && k.getLongNumber().equals(accountMember.getLongNumber()));
                }
                centralScheme.getAccountMembers().add(accountMember);
            }
            if (StringUtil.isEmptyString((String)list.get(13))) continue;
            centralScheme.getApprovers().add(validUserInfo.get(list.get(13)));
        }
        if (centralSchemeMap.size() > 0) {
            centralSchemes = new ArrayList(centralSchemeMap.values());
        }
        return centralSchemes;
    }

    private void downImportTemplate() {
        BgExcelWriter excelWriter = BgExcelWriter.getInstance().readTemplateByClasspath("dataintegration/centralScheme.xlsx");
        this.instance.modifyTitleRow(excelWriter, false);
        this.instance.createDimExplain(excelWriter);
        String fileName = ResManager.loadResFormat((String)"\u5f52\u53e3\u65b9\u6848\u5bfc\u5165\u6a21\u677f%1.xlsx", (String)"CentralSchemeImportPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[]{DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        String url = excelWriter.getDownloadUrl(fileName);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
    }

    @Override
    public Long getModelId() {
        String modelId = this.getPageCache().get("model");
        if (modelId == null) {
            modelId = this.getView().getFormShowParameter().getCustomParam("model").toString();
            this.getPageCache().put("model", modelId);
        }
        return IDUtils.toLong((Object)modelId);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        String file_url = this.getPageCache().get("file_url");
        List urls = null;
        urls = file_url == null ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object url : evt.getUrls()) {
            urls.add((String)((Map)url).get("url"));
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString(urls));
    }

    public void afterRemove(UploadEvent evt) {
        Object[] objects;
        String file_url = this.getPageCache().get("file_url");
        if (file_url == null) {
            return;
        }
        List urls = (List)SerializationUtils.fromJsonString((String)file_url, List.class);
        for (Object object : objects = evt.getUrls()) {
            String url = (String)((Map)object).get("url");
            urls.remove(url);
        }
        this.getPageCache().put("file_url", SerializationUtils.toJsonString((Object)urls));
    }

    private boolean isAddAndUpdate() {
        return ImportEnum.IMPORTTYPE_ADDANDUPADTA.getIndex().equals(this.getModel().getValue("radiogroupfield"));
    }

    private String checkIsUsed(String number) {
        List approvePlan;
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralscheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", (Object)this.getModelId()))});
        if (object != null && (approvePlan = CentralApprovePlanService.getInstance().getApprovePlanByCentralPlanIds(Long.valueOf(object.getLong("id")), this.getModelId())).size() > 0) {
            return ((ApprovePlanDto)approvePlan.get(0)).getName();
        }
        return null;
    }

    private boolean checkAllowNameStart(String name) {
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FA5A-Za-z0-9()_\\-]+$");
        Matcher matcher = pattern.matcher(name);
        return matcher.matches();
    }

    private ValidDataInfo getExcelValidInfo(List<List<String>> dataList) {
        Long bizModelId;
        String bizModelNumber;
        Long modelId = this.getModelId();
        IModelCacheHelper modelCache = this.getIModelCacheHelper();
        HashSet<String> bizModelNumberInExcel = new HashSet<String>(16);
        HashSet<String> userNumberInExcel = new HashSet<String>(16);
        HashMap<String, Set> accountNumberInExcel = new HashMap<String, Set>(16);
        HashMap<String, Set> entityNumberInExcel = new HashMap<String, Set>(16);
        String bizNumber = "";
        for (int i = 1; i < dataList.size(); ++i) {
            ArrayList<Object> emptyCollection;
            List<String> row = dataList.get(i);
            if (CollectionUtils.isEqualCollection(row, emptyCollection = new ArrayList<Object>(Collections.nCopies(15, null)))) continue;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.get(2))) {
                bizModelNumberInExcel.add(row.get(2));
                bizNumber = row.get(2);
            }
            Iterator entityNumbers = entityNumberInExcel.computeIfAbsent(bizNumber, e -> new HashSet());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.get(4))) {
                entityNumbers.add((String)row.get(4));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.get(6))) {
                entityNumbers.add((String)row.get(6));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.get(9))) {
                Set numbers = accountNumberInExcel.computeIfAbsent(bizNumber, e -> new HashSet());
                numbers.add(row.get(9));
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)row.get(12))) continue;
            userNumberInExcel.add(row.get(12));
        }
        ValidDataInfo validDataInfo = new ValidDataInfo();
        HashMap<String, Long> validBizModelInfo = new HashMap<String, Long>(16);
        DynamicObjectCollection bizModelObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,number", (QFilter[])new QFilter("number", "in", bizModelNumberInExcel).and(new QFilter("model", "=", (Object)modelId)).toArray());
        if (bizModelObjects != null) {
            for (DynamicObject object : bizModelObjects) {
                validBizModelInfo.put(object.getString("number"), object.getLong("id"));
            }
            validDataInfo.setValidBizModelInfo(validBizModelInfo);
        }
        for (Map.Entry entry : entityNumberInExcel.entrySet()) {
            bizModelNumber = (String)entry.getKey();
            Set entityNumbers = (Set)entry.getValue();
            bizModelId = (Long)validBizModelInfo.get(bizModelNumber);
            if (!IDUtils.isNotEmptyLong((Long)bizModelId).booleanValue()) continue;
            Long viewId = modelCache.getViewByBusModelAndDimNumber(bizModelId, "Entity");
            Map<String, Long> validEntityInfo = this.getCurBizModelValidEntity(modelId, bizModelId, viewId, entityNumbers);
            validDataInfo.getValidEntityInfo().put(bizModelNumber, validEntityInfo);
        }
        for (Map.Entry entry : accountNumberInExcel.entrySet()) {
            bizModelNumber = (String)entry.getKey();
            Set accountNumbers = (Set)entry.getValue();
            bizModelId = (Long)validBizModelInfo.get(bizModelNumber);
            if (!IDUtils.isNotEmptyLong((Long)bizModelId).booleanValue()) continue;
            Map<String, Long> validAccountInfo = this.getCurBizModelValidAccount(modelId, bizModelId, accountNumbers);
            validDataInfo.getValidAccountInfo().put(bizModelNumber, validAccountInfo);
        }
        DynamicObjectCollection userObjects = QueryServiceHelper.query((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("number", "in", userNumberInExcel).toArray());
        if (userObjects != null) {
            Map<String, Long> validUserInfo = userObjects.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
            validDataInfo.setValidUserInfo(validUserInfo);
        }
        return validDataInfo;
    }

    private Map<String, Long> getCurBizModelValidAccount(Long modelId, Long bizModelId, Set<String> accountNumbers) {
        DynamicObjectCollection accountObjects;
        List datasetIds = DatasetServiceHelper.getInstance().getDataSetIdByBizModelId(bizModelId);
        Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)"Account", (Long)modelId, (Long)bizModelId, null, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("dataset", "in", (Object)datasetIds).and("number", "in", accountNumbers);
        if (permMembNumbers != null) {
            qFilter.and("number", "in", (Object)permMembNumbers);
        }
        if ((accountObjects = QueryServiceHelper.query((String)SysDimensionEnum.Account.getMemberTreemodel(), (String)"id,number", (QFilter[])qFilter.toArray())) != null) {
            return accountObjects.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
        }
        return new HashMap<String, Long>(0);
    }

    private Map<String, Long> getCurBizModelValidEntity(Long modelId, Long bizModelId, Long viewId, Set<String> entityNumbers) {
        Set permMembNumbers = DimMembPermHelper.getPermMembNumbers((String)"Entity", (Long)modelId, (Long)bizModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("number", "in", entityNumbers);
        if (permMembNumbers != null) {
            qFilter.and("number", "in", (Object)permMembNumbers);
        }
        if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
            DynamicObjectCollection entityObjects = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id,number", (QFilter[])qFilter.toArray());
            if (entityObjects != null) {
                return entityObjects.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
            }
        } else {
            qFilter.and("view", "=", (Object)viewId);
            DynamicObjectCollection entityObjects = QueryServiceHelper.query((String)"eb_viewmember", (String)"number,memberid", (QFilter[])qFilter.toArray());
            if (entityObjects != null) {
                return entityObjects.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("memberid")));
            }
        }
        return new HashMap<String, Long>(0);
    }
}

