/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class ApproveBillAttachmentPlugin
extends AbstractListPlugin
implements SearchEnterListener,
SetFilterListener,
CreateListDataProviderListener {
    private static final Log log = LogFactory.getLog(ApproveBillAttachmentPlugin.class);
    private String searchValue = "";

    public void afterCreateNewData(EventObject e) {
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addSetFilterListener((SetFilterListener)this);
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        List<Long> relationIds = this.getRelationIds();
        List<String> collect = relationIds.stream().map(Object::toString).collect(Collectors.toList());
        ArrayList<String> formIds = new ArrayList<String>(16);
        formIds.add("eb_bgapplybill");
        formIds.add("eb_centralappbill");
        List<DynamicObject> attachmentpanelap = this.getAttachments(collect, "attachmentpanelap", formIds);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : attachmentpanelap) {
            ids.add(dynamicObject.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", ids);
        FilterParameter fp = new FilterParameter();
        fp.setFilter(filter);
        billlistap.setFilterParameter(fp);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_view"});
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = new QFilter("fattachmentname", "like", (Object)("%" + this.searchValue + "%"));
        if (StringUtils.isNotEmpty((String)this.searchValue)) {
            e.getQFilters().add(qFilter);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search inputSearch = (Search)this.getControl("searchap");
        inputSearch.addEnterListener((SearchEnterListener)this);
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.addSetFilterListener((SetFilterListener)this);
        billlistap.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billlistap.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"btn_download")) {
            Map<Object, DynamicObject> selectedAttachmentObjs = this.getSelectedAttachmentObjs();
            for (Map.Entry<Object, DynamicObject> entry : selectedAttachmentObjs.entrySet()) {
                DynamicObject value = entry.getValue();
                String downloadUrl = this.getDownUrl(value.getString("ffileid"));
                this.getView().download(downloadUrl);
            }
        } else if (StringUtils.equals((String)operateKey, (String)"btn_view")) {
            DynamicObject focusRowObj = this.getFocusRowObj();
            String path = focusRowObj.getString("ffileid");
            String fattachmentname = focusRowObj.getString("fattachmentname");
            String previewUrl = this.getPreviewUrl(path, fattachmentname);
            this.getView().openUrl(previewUrl);
        }
    }

    private String getDownUrl(String path) {
        return this.getSelectedAttachmentFullUrl(path);
    }

    private DynamicObject getFocusRowObj() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        Object focusRowPkId = billlistap.getFocusRowPkId();
        return BusinessDataServiceHelper.loadSingleFromCache((Object)focusRowPkId, (String)"bos_attachment");
    }

    private String getSelectedAttachmentFullUrl(String path) {
        return UrlService.getAttachmentFullUrl((String)path);
    }

    private String getPreviewUrl(String path, String fileName) {
        String downloadUrl = this.getSelectedAttachmentFullUrl(path);
        this.saveToTemp(downloadUrl, fileName);
        return UrlService.getAttachmentPreviewUrl((String)path);
    }

    private String saveToTemp(String selectedAttachmentFullUrl, String fattachmentname) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream fileInputStream = null;
        try {
            fileInputStream = FileServiceFactory.getAttachmentFileService().getInputStream(selectedAttachmentFullUrl);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return tempFileCache.saveAsUrl(fattachmentname, fileInputStream, 7200);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent event) {
        super.hyperLinkClick(event);
        this.openBillPage();
    }

    private void openBillPage() {
        DynamicObject focusRowObj = this.getFocusRowObj();
        long billId = focusRowObj.getLong("finterid");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)focusRowObj.getString("fbilltype"));
        String billtype = dynamicObject.getString("billtype");
        ApplyBillType billTypeEnum = ApplyBillType.getBillTypeByNumber((String)billtype);
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("eb_bgapplybill");
        baseShowParameter.setCustomParam("pkId", (Object)billId);
        baseShowParameter.setCustomParam("schemeId", (Object)dynamicObject.getLong("applyscheme.id"));
        baseShowParameter.setCustomParam("orgId", (Object)dynamicObject.getLong("org.id"));
        baseShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        baseShowParameter.setCustomParam("bill_type", (Object)billTypeEnum.getNumber());
        baseShowParameter.setCaption(billTypeEnum.getName());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.addCustPlugin(billTypeEnum.getBillPlugin());
        baseShowParameter.setPkId((Object)billId);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        IFormView parentView = this.getView().getParentView();
        baseShowParameter.setPageId(this.getView().getPageId() + billId);
        baseShowParameter.setParentPageId(parentView.getPageId());
        baseShowParameter.setParentFormId(parentView.getEntityId());
        parentView.showForm((FormShowParameter)baseShowParameter);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    @Override
    public Long getModelId() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object modelId = customParams.get("modelId");
        if (modelId == null) {
            return 0L;
        }
        return Long.parseLong(modelId.toString());
    }

    private Map<Object, DynamicObject> getSelectedAttachmentObjs() {
        BillList billlistap = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u9644\u4ef6\u3002", (String)"ApproveBillAttachmentPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (ListSelectedRow selectedRow : selectedRows) {
            ids.add(selectedRow.getPrimaryKeyValue());
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"bos_attachment");
    }

    private List<Long> getRelationIds() {
        ArrayList<Long> result = new ArrayList<Long>(16);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null) {
            Object relationIds = customParams.get("relationIds");
            if (relationIds == null) {
                return result;
            }
            return (List)SerializationUtils.deSerializeFromBase64((String)relationIds.toString());
        }
        return result;
    }

    private Map<Object, DynamicObject> getApplyBillList() {
        List<Long> relationIds = this.getRelationIds();
        return BusinessDataServiceHelper.loadFromCache((Object[])relationIds.toArray(), (String)"eb_bgapplybill");
    }

    private Map<Object, DynamicObject> getCenBillList() {
        List<Long> relationIds = this.getRelationIds();
        return BusinessDataServiceHelper.loadFromCache((Object[])relationIds.toArray(), (String)"eb_centralappbill");
    }

    private List<DynamicObject> getAttachments(List<String> relationIds, String attachId, List<String> formIds) {
        QFilter filter = new QFilter("finterid", "in", relationIds);
        filter.and("fattachmentpanel", "=", (Object)attachId);
        filter.and("fbilltype", "in", formIds);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])filter.toArray());
        return new ArrayList<DynamicObject>(dynamicObjectMap.values());
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.searchValue = searchEnterEvent.getText();
        BillList billlistap = (BillList)this.getControl("billlistap");
        billlistap.refresh();
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"fbillno")) {
                return rows;
            }
            Map billList = ApproveBillAttachmentPlugin.this.getApplyBillList();
            if (billList == null) {
                return rows;
            }
            for (DynamicObject row : rows) {
                long finterid = row.getLong("finterid");
                DynamicObject dynamicObject = (DynamicObject)billList.get(finterid);
                if (dynamicObject == null) continue;
                row.set("fbillno", (Object)dynamicObject.getString("billnumber"));
            }
            Map cenBillList = ApproveBillAttachmentPlugin.this.getCenBillList();
            for (DynamicObject row : rows) {
                long finterid = row.getLong("finterid");
                DynamicObject dynamicObject = (DynamicObject)cenBillList.get(finterid);
                if (dynamicObject == null) continue;
                row.set("fbillno", (Object)dynamicObject.getString("billno"));
            }
            return rows;
        }
    }
}

