/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ApproveBillStatusListPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String idStr = (String)formShowParameter.getCustomParam("id");
        if (StringUtils.isEmpty((String)idStr)) {
            return;
        }
        Set ids = (Set)SerializationUtils.deSerializeFromBase64((String)idStr);
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.setListData(ids);
    }

    private void setListData(Set<Long> ids) {
        CentralAppBillService instance = CentralAppBillService.getInstance();
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(new QFilter("id", "in", ids));
        if (approveBills == null || approveBills.size() == 0) {
            return;
        }
        Map status = WorkflowServiceHelper.getBizProcessStatus((String[])((String[])ids.stream().map(e -> e + "").distinct().toArray(String[]::new)));
        Map showText = instance.getCentralAppBillShowText(approveBills);
        for (ApproveBill appBill : approveBills) {
            Object centralEntity;
            String id = String.valueOf(appBill.getId());
            Map infoText = (Map)showText.get(id);
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("billno", (Object)infoText.get("billno").toString(), index);
            this.getModel().setValue("name", infoText.get("name"), index);
            this.getModel().setValue("status", infoText.get("billstatus"), index);
            this.getModel().setValue("dealer", (Object)String.join((CharSequence)"; ", instance.getDealer((List)status.get(id), id)), index);
            Object modifyTime = infoText.get("modifytime");
            if (modifyTime != null) {
                this.getModel().setValue("modifydate", modifyTime, index);
            }
            if ((centralEntity = infoText.get("centralentity")) == null && (centralEntity = infoText.get("entity")) == null) continue;
            this.getModel().setValue("centralentity", (Object)String.join((CharSequence)"; ", (Set)centralEntity), index);
        }
    }
}

