/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.business.utils.CheckStringsUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveAdjDimTypeEnum;
import kd.epm.eb.common.centralapproval.ApproverRelationEnum;
import kd.epm.eb.common.centralapproval.ApproverTypeEnum;
import kd.epm.eb.common.centralapproval.entity.ApproveAdjDimDto;
import kd.epm.eb.common.centralapproval.entity.ApproveAdjMemberRangeDto;
import kd.epm.eb.common.centralapproval.entity.AuditorRelationEntity;
import kd.epm.eb.common.centralapproval.entity.AuditorRoleEntity;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.centralapproval.approveplan.helper.DynamicObjectParseHelper;
import kd.epm.eb.formplugin.utils.TreeSearchUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ApprovePlanEditPlugin
extends AbstractBaseFormPlugin
implements BeforeF7SelectListener,
TreeNodeCheckListener,
RowClickEventListener {
    private static final String TEMPLATETREE = "treeviewap";
    private static final int MAX_LEVEL = 20;
    private static final String TEMPLATECACHEIDS = "templatecacheids";
    public static final String BIZMODEL = "bizmodel";
    public static final String MODEL = "model";
    public static final String BEFORE_MODE_TYPE = "beforeapptemplatetype";
    public static final String MODE_TYPE = "apptemplatetype";
    public static final String APP_REL_TYPE = "apprelatype";
    public static final String BILL_ENTITY = "entryentity";
    public static final String templateEntity = "eb_applytemplate";
    public static final String queryFiled = "id,name,number,templatetype as templatecatalog,templatestatus";
    public static final String SAVE_ENTITY = "eb_centralappplanentity";
    public static final String BUSI_RANG = "busirang";
    private static final String EB_CENTRALAUDITORRELATION = "eb_centralauditorrelation";
    private static final String EB_CENTRALAUDITORROLE = "eb_centralauditorrole";
    private static final String EB_CENTRALADJSCHEME = "eb_centraladjscheme";
    private static final String EB_CENTRALADJDIM = "eb_centraladjdim";
    private static final String EB_CENTALADJSCHEMELIST = "eb_centaladjschemelist";
    private static final String BTN_ADDRELATION = "btn_addrelation";
    private static final String BTN_ADDROLE = "btn_addrole";
    private static final String BTN_ADDUSER = "btn_adduser";
    private static final String BTN_ADDDIMENSION = "btn_adddimension";
    private static final String BTN_ADJDIMMODIFY = "btn_adjdimmodify";
    private static final String BTN_ADJDIMREMOVE = "btn_adjdimremove";
    private static final String AUDITORENTRYENTITY = "auditorentryentity";
    private static final String CENTRALIZEDENTRYENTITY = "centralizedentryentity";
    private static final String ADJDIMENTRYENTITY = "adjdimentryentity";
    private static final String BTN_IMPORTSCHEME = "btn_importscheme";
    private static final String BTN_SAVESCHEME = "btn_savescheme";
    private IModelCacheHelper modelCacheHelper;
    private static Map<String, MultiLangEnumBridge> billTypeMap = new LinkedHashMap<String, MultiLangEnumBridge>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "auditorrange"});
        TreeView treeView = (TreeView)this.getView().getControl(TEMPLATETREE);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                TreeSearchUtil.searchMember(event.getText().toLowerCase().trim(), this.getView(), this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\uff0c\u6309\u56de\u8f66\u952e\u786e\u8ba4\u3002", (String)"ApprovePlanEditPlugin_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        });
        BasedataEdit busirRangEdit = (BasedataEdit)this.getControl(BUSI_RANG);
        busirRangEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit appTypeEdit = (BasedataEdit)this.getControl("apptype");
        appTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit appRelaEdit = (BasedataEdit)this.getControl("apprela");
        appRelaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billTemplateEdit = (BasedataEdit)this.getControl("billtemplate");
        billTemplateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reportTemplateEdit = (BasedataEdit)this.getControl("reporttemplate");
        reportTemplateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit centralizedscheme = (BasedataEdit)this.getControl("centralizedscheme");
        centralizedscheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit approveclassify = (BasedataEdit)this.getControl("approveclassify");
        approveclassify.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(AUDITORENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.setAuditorEntryCurrentRow(row);
    }

    private void setAuditorEntryCurrentRow(int row) {
        this.getPageCache().put("auditorentryentitycurrentRow", row + "");
    }

    private int getAuditorEntryCurrentRow() {
        String row = this.getPageCache().get("auditorentryentitycurrentRow");
        if (StringUtils.isNotEmpty((String)row)) {
            return Integer.parseInt(row);
        }
        return -1;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "searchbefore": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TreeSearchUtil.SearchBtnStatus.LEFT));
                break;
            }
            case "searchnext": {
                TreeSearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE, TreeSearchUtil.SearchBtnStatus.RIGHT));
                break;
            }
            case "auditorrange": {
                int currentRow = this.getAuditorEntryCurrentRow();
                if (currentRow == -1) {
                    return;
                }
                Object auditortype = this.getModel().getValue("auditortype", currentRow);
                if (auditortype == null) {
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("row", currentRow);
                ApproverTypeEnum approverEnumByValue = ApproverTypeEnum.getApproverEnumByValue((String)auditortype.toString());
                if (approverEnumByValue == ApproverTypeEnum.PERSON) {
                    DynamicObject person = (DynamicObject)this.getModel().getValue("person", currentRow);
                    params.put("person", person.getLong("id"));
                    this.handleAddUserOperation(params);
                    break;
                }
                if (approverEnumByValue == ApproverTypeEnum.RELATE) {
                    Object referenceperson = this.getModel().getValue("referenceperson", currentRow);
                    Object relation = this.getModel().getValue("relation", currentRow);
                    Object relationtype = this.getModel().getValue("relationtype", currentRow);
                    params.put("referenceperson", referenceperson);
                    params.put("relation", relation);
                    params.put("relationtype", relationtype);
                    this.handleAddRelationOperation(params);
                    break;
                }
                if (approverEnumByValue != ApproverTypeEnum.WORKFLOW_ROLE) break;
                DynamicObject wfrole = (DynamicObject)this.getModel().getValue("wfrole", currentRow);
                Object billorgkey = this.getModel().getValue("billorgkey", currentRow);
                params.put("roleId", wfrole.getLong("id"));
                params.put("billorgkey", billorgkey);
                this.handleAddRoleOperation(params);
                break;
            }
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent arg0) {
        Long nodeId = Long.parseLong(arg0.getNodeId().toString());
        Object beforeAppTemplateType = this.getModel().getValue(BEFORE_MODE_TYPE);
        Object appTemplateType = this.getModel().getValue(MODE_TYPE);
        if (beforeAppTemplateType == null || appTemplateType == null || !beforeAppTemplateType.equals(appTemplateType)) {
            return;
        }
        String appTemplateFiled = "billtemplate";
        if (appTemplateType != null && "2".equals(appTemplateType.toString())) {
            appTemplateFiled = "reporttemplate";
        }
        String templateStrs = this.getPageCache().get(TEMPLATECACHEIDS);
        HashSet<String> templateIds = new HashSet(16);
        ArrayList<Long> children = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)templateStrs)) {
            templateIds = (Set)JSON.parseObject((String)templateStrs, Set.class);
        }
        if (templateIds.contains(nodeId.toString())) {
            children.add(nodeId);
        } else {
            String rootNodeStr = this.getPageCache().get(nodeId.toString());
            if (StringUtils.isNotEmpty((String)rootNodeStr)) {
                TreeNode rootNode = (TreeNode)JSON.parseObject((String)rootNodeStr, TreeNode.class);
                this.getAllChildren(rootNode, children, templateIds);
            }
        }
        if (children != null && children.size() > 0) {
            this.initNewRow(children, arg0.getChecked(), appTemplateFiled);
            this.getView().updateView(BILL_ENTITY);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.planExist()) {
            return;
        }
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "model": {
                this.clearValueModelChange();
                this.initLeftTree();
                break;
            }
            case "beforeapptemplatetype": {
                this.initLeftTree();
                break;
            }
            case "apptemplatetype": {
                this.getModel().deleteEntryData(BILL_ENTITY);
                break;
            }
            case "busirang": {
                this.clearValueRangChange();
                this.initLeftTree();
                this.initDimensionList();
                this.clearAuditInfo();
                break;
            }
            case "dimension": {
                this.handleDimensionPropChange(e);
                break;
            }
            case "centralizedscheme": {
                if (newValue == null) {
                    return;
                }
                this.handleCentralizedSchemePropChange((DynamicObject)newValue, rowIndex);
                break;
            }
        }
    }

    private void clearAuditInfo() {
        this.getModel().deleteEntryData(AUDITORENTRYENTITY);
        this.getModel().deleteEntryData(CENTRALIZEDENTRYENTITY);
        this.getModel().deleteEntryData(ADJDIMENTRYENTITY);
        this.getModel().deleteEntryData("adjmemberentryentity");
    }

    private void handleCentralizedSchemePropChange(DynamicObject dynamicObject, int rowIndex) {
        if (dynamicObject == null) {
            return;
        }
        ArrayList<String> accountNames = new ArrayList<String>(16);
        ArrayList<String> orgNames = new ArrayList<String>(16);
        ArrayList<String> approveUserNames = new ArrayList<String>(16);
        DynamicObjectCollection accountEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity1");
        for (DynamicObject object : accountEntryEntity) {
            DynamicObject account = object.getDynamicObject("accountnumber");
            if (account == null) continue;
            accountNames.add(account.getString("name") + "_" + RangeEnum.getRangeByVal((int)object.getInt("accountscope")).getName());
        }
        DynamicObjectCollection orgEntryEntity = dynamicObject.getDynamicObjectCollection("entryentity2");
        for (DynamicObject object : orgEntryEntity) {
            DynamicObject entityObj = object.getDynamicObject("entitynumber1");
            orgNames.add(entityObj.getString("name") + "_" + RangeEnum.getRangeByVal((int)object.getInt("orgscope")).getName());
            DynamicObjectCollection checker = object.getDynamicObjectCollection("checker");
            if (approveUserNames.size() > 0) continue;
            for (DynamicObject checkerObj : checker) {
                String name = checkerObj.getDynamicObject("fbasedataid").getString("name");
                approveUserNames.add(name);
            }
        }
        this.getModel().setValue("auditaccounts", (Object)String.join((CharSequence)",", accountNames), rowIndex);
        this.getModel().setValue("auditbudgetentity", (Object)String.join((CharSequence)",", orgNames), rowIndex);
        this.getModel().setValue("auditors", (Object)String.join((CharSequence)",", approveUserNames), rowIndex);
        this.deleteSameCentralSchemeRows();
    }

    private void deleteSameCentralSchemeRows() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(CENTRALIZEDENTRYENTITY);
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            return;
        }
        HashSet<String> numbers = new HashSet<String>(16);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int rowCount = this.getModel().getEntryEntity(CENTRALIZEDENTRYENTITY).getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object centralizedscheme = this.getModel().getValue("centralizedscheme", i);
            if (centralizedscheme == null) continue;
            String number = ((DynamicObject)centralizedscheme).getString("number");
            if (numbers.contains(number)) {
                list.add(i);
                continue;
            }
            numbers.add(number);
        }
        int[] a = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            a[i] = (Integer)list.get(i);
        }
        this.getModel().deleteEntryRows(CENTRALIZEDENTRYENTITY, a);
    }

    private void handleDimensionPropChange(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newValue == null) {
            this.getModel().setValue("dimensionnum", (Object)"", rowIndex);
            this.getModel().setValue("dimensionid", (Object)0, rowIndex);
        } else {
            String dimIdAndNumber = newValue.toString();
            String[] split = dimIdAndNumber.split("#");
            Long dimId = Long.parseLong(split[0]);
            String dimNumber = split[1];
            this.initDimMemberLevelCombo(dimNumber);
            this.getModel().setValue("dimensionnum", (Object)dimNumber, rowIndex);
            this.getModel().setValue("dimensionid", (Object)dimId, rowIndex);
        }
    }

    private String initDimMemberLevelCombo(String dimNumber) {
        ComboEdit dimmemlevel = (ComboEdit)this.getControl("dimmemlevel");
        Set<Integer> levels = this.getAdjDimMemberLevel(dimNumber);
        Map typeOneLevels = ApproveAdjDimTypeEnum.getLevelsByDimNumber((String)dimNumber, levels);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String defaultKey = "";
        for (Map.Entry entry : typeOneLevels.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)defaultKey)) {
                defaultKey = key;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(key);
            comboItem.setCaption(new LocaleString(value));
            items.add(comboItem);
        }
        dimmemlevel.setComboItems(items);
        return defaultKey;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initLeftTree();
        this.initPageData();
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getModelId();
        Object focusNodeId = this.getView().getFormShowParameter().getCustomParam("focusNodeId");
        if (focusNodeId != null) {
            this.getModel().setValue("approveclassify", focusNodeId);
        }
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL, (boolean)false);
        }
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"ApprovePlanEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue(MODEL, (Object)modelId);
        this.initPageData();
    }

    public Long getModelId() {
        IDataModel model;
        DynamicObject m;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (m = (DynamicObject)(model = parentView.getModel()).getValue(MODEL)) != null) {
            return m.getLong("id");
        }
        return 0L;
    }

    private void initPageData() {
        this.initApproverTypeList();
        this.initDimensionList();
        this.initRangeTypeList();
        this.initDimMemberRange();
        this.initCentralSchemeData();
        this.setBatchApproverTypeDesc();
        this.setVisible();
    }

    private void setVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_addrow", "btn_deleterow", "labelap"});
    }

    private void setBatchApproverTypeDesc() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUDITORENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            this.setApproverTypeDesc(dynamicObject);
        }
        this.getView().updateView(AUDITORENTRYENTITY);
    }

    private void setApproverTypeDesc(DynamicObject dynamicObject) {
        String auditortype = dynamicObject.getString("auditortype");
        Object referenceperson = dynamicObject.get("referenceperson");
        ApproverTypeEnum approverEnumByValue = ApproverTypeEnum.getApproverEnumByValue((String)auditortype);
        if (approverEnumByValue == ApproverTypeEnum.PERSON) {
            dynamicObject.set("approvetype", (Object)ApproverTypeEnum.PERSON.getDesc());
        } else if (approverEnumByValue == ApproverTypeEnum.WORKFLOW_ROLE) {
            dynamicObject.set("approvetype", (Object)ApproverTypeEnum.WORKFLOW_ROLE.getDesc());
        } else {
            List<Map<String, String>> bosUserBaseEntityData = DynamicObjectParseHelper.getBosUserBaseEntityData(this.getBillType());
            for (Map<String, String> map : bosUserBaseEntityData) {
                String referencepersonName = map.get(referenceperson.toString());
                if (!StringUtils.isNotEmpty((String)referencepersonName)) continue;
                dynamicObject.set("approvetype", (Object)(ApproverTypeEnum.RELATE.getDesc() + "-" + referencepersonName));
                break;
            }
        }
    }

    private void initCentralSchemeData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CENTRALIZEDENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            this.handleCentralizedSchemePropChange(dynamicObject.getDynamicObject("centralizedscheme"), i);
        }
    }

    private void initDimMemberRange() {
        DynamicObjectCollection adjdimentryentity = this.getModel().getEntryEntity(ADJDIMENTRYENTITY);
        HashMap<String, ApproveAdjMemberRangeDto> memberRangeRows = new HashMap<String, ApproveAdjMemberRangeDto>(16);
        HashMap<String, List> maps = new HashMap<String, List>(16);
        DynamicObjectCollection adjmemberentryentity = this.getModel().getEntryEntity("adjmemberentryentity");
        for (DynamicObject dynamicObject : adjmemberentryentity) {
            String relationrowid = dynamicObject.getString("relationrowid");
            List members = maps.computeIfAbsent(relationrowid, t -> new ArrayList(16));
            HashMap<String, String> member = new HashMap<String, String>(16);
            member.put("id", dynamicObject.getDynamicObject("memberid").getString("id"));
            member.put("basedataid", dynamicObject.getString("basedatatype"));
            member.put("name", dynamicObject.getDynamicObject("memberid").getString("name"));
            members.add(member);
        }
        for (int i = 0; i < adjdimentryentity.size(); ++i) {
            DynamicObject dynamicObject;
            dynamicObject = (DynamicObject)adjdimentryentity.get(i);
            String rowid = dynamicObject.getString("rowid");
            ApproveAdjMemberRangeDto approveAdjMemberRangeDto = memberRangeRows.computeIfAbsent(rowid, t -> new ApproveAdjMemberRangeDto());
            approveAdjMemberRangeDto.setRowIndex(i);
            List members = (List)maps.get(rowid);
            String rangetype = dynamicObject.getString("rangetype");
            String dimtype = dynamicObject.getString("dimtype");
            ApproveAdjDimTypeEnum typeByDimNumber = ApproveAdjDimTypeEnum.getTypeByDimNumber((String)dynamicObject.get("dimensionnum").toString());
            if (typeByDimNumber != null) {
                dimtype = typeByDimNumber.getValue();
            }
            String orgreferencefield = dynamicObject.getString("orgreferencefield");
            String dimmemlevel = dynamicObject.getString("dimmemlevel");
            ApproveAdjDimTypeEnum.RangeTypeEnum typeByValue = ApproveAdjDimTypeEnum.RangeTypeEnum.getTypeByValue((String)rangetype);
            ApproveAdjDimTypeEnum dimTypeEnum = ApproveAdjDimTypeEnum.getTypeByValue((String)dimtype);
            approveAdjMemberRangeDto.setMembers(members);
            approveAdjMemberRangeDto.setRangeType(typeByValue);
            approveAdjMemberRangeDto.setDimType(dimTypeEnum);
            approveAdjMemberRangeDto.setOrgReferenceField(orgreferencefield);
            approveAdjMemberRangeDto.setBillType(this.getBillType());
            approveAdjMemberRangeDto.setBillTypeName(this.getBillTypeName());
            approveAdjMemberRangeDto.setDimMemLevel(dimmemlevel);
            List<Map<String, String>> budgetEntityBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(this.getBillType());
            approveAdjMemberRangeDto.setBudgetEntityBaseEntityData(budgetEntityBaseEntityData);
            this.setDimMemberRange(approveAdjMemberRangeDto);
        }
    }

    private void setDimMemberRange(ApproveAdjMemberRangeDto approveAdjMemberRangeDto) {
        String dimMemRangeValue = ApproveAdjDimTypeEnum.getDimMemberRange((ApproveAdjMemberRangeDto)approveAdjMemberRangeDto, (boolean)false);
        this.getModel().setValue("dimmemrange", (Object)dimMemRangeValue, approveAdjMemberRangeDto.getRowIndex());
    }

    private void initRangeTypeList() {
        ApproveAdjDimTypeEnum.RangeTypeEnum[] values = ApproveAdjDimTypeEnum.RangeTypeEnum.values();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        String defaultValue = "";
        for (ApproveAdjDimTypeEnum.RangeTypeEnum value : values) {
            String value1 = value.getValue();
            String desc = value.getDesc();
            if (StringUtils.isEmpty((String)defaultValue)) {
                defaultValue = value1;
            }
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(value1);
            comboItem.setCaption(new LocaleString(desc));
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("rangetype");
        comboEdit.setComboItems(comboItems);
    }

    private void initApproverTypeList() {
        ArrayList<ComboItem> auditorTypeItems = new ArrayList<ComboItem>(16);
        ComboEdit auditorCom = (ComboEdit)this.getControl("auditortype");
        for (ApproverTypeEnum value : ApproverTypeEnum.values()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(value.getDesc()));
            comboItem.setValue(value.getValue());
            auditorTypeItems.add(comboItem);
        }
        auditorCom.setComboItems(auditorTypeItems);
    }

    private void initDimensionList() {
        Object businessModel = this.getModel().getValue(BUSI_RANG);
        if (businessModel != null) {
            DynamicObject businessModelObj = (DynamicObject)businessModel;
            List dimensions = this.getIModelCacheHelper().getDimensionListByBusModel(Long.valueOf(businessModelObj.getLong("id")));
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            String defaultValue = "";
            for (Dimension value : dimensions) {
                String number = value.getNumber();
                ComboItem comboItem = new ComboItem();
                if (!ApproveAdjDimTypeEnum.isAdjDim((String)number)) continue;
                String v = value.getId() + "#" + value.getNumber();
                if (StringUtils.isEmpty((String)defaultValue)) {
                    defaultValue = v;
                }
                comboItem.setValue(v);
                comboItem.setCaption(new LocaleString(value.getName()));
                comboItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("dimension");
            comboEdit.setComboItems(comboItems);
            this.initDimMemberLevelCombo(defaultValue);
        }
    }

    private IModelCacheHelper getIModelCacheHelper() {
        if (this.modelCacheHelper != null) {
            return this.modelCacheHelper;
        }
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        return this.modelCacheHelper;
    }

    private Set<Integer> getAdjDimMemberLevel(String dimNumber) {
        Long businessModelId = this.getBizModelId();
        Map dimViewMap = this.getIModelCacheHelper().getViewsByBusModel(businessModelId);
        HashSet<Integer> result = new HashSet<Integer>(16);
        List members = this.getIModelCacheHelper().getMembers((Long)dimViewMap.get(dimNumber), dimNumber);
        for (Member member : members) {
            this.getMemberAllChildren(member, result);
        }
        return result;
    }

    private void getMemberAllChildren(Member member, Set<Integer> levels) {
        if (member == null) {
            return;
        }
        List memberChildren = member.getChildren();
        if (CollectionUtils.isEmpty((Collection)memberChildren)) {
            return;
        }
        levels.add(member.getLevel());
        for (Member memberChild : memberChildren) {
            this.getMemberAllChildren(memberChild, levels);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"save")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADJDIMREMOVE)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ADJDIMENTRYENTITY);
            entryGrid.selectRows(-1);
        } else if (StringUtils.equals((String)operateKey, (String)"btn_auditorremove")) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(AUDITORENTRYENTITY);
            entryGrid.selectRows(-1);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((String)itemKey, (String)"btn_closed")) {
            return;
        }
        boolean b = this.planExist();
        if (!b) {
            evt.setCancel(true);
        }
    }

    private boolean planExist() {
        boolean exists;
        Object id = this.getModel().getValue("id");
        if (!IDUtils.isEmptyLong((Long)IDUtils.toLong((Object)id)).booleanValue() && !(exists = QueryServiceHelper.exists((String)SAVE_ENTITY, (Object)id))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5ba1\u6279\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"ApprovePlanEditPlugin_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!this.planExist()) {
            args.setCancel(true);
        }
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject planDyo = this.getModel().getDataEntity();
            Object pk = planDyo.getPkValue();
            String name = "";
            OrmLocaleValue nameLocal = (OrmLocaleValue)this.getModel().getValue("name");
            if (nameLocal != null) {
                name = nameLocal.getLocaleValue();
            }
            if (name != null && StringUtils.isEmpty((String)name.trim())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5168\u4e3a\u7a7a\u683c\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApprovePlanEditPlugin_04", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            if (pk == null || Long.parseLong(pk.toString()) == 0L) {
                String number = planDyo.getString("number");
                DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
                Long modelId = model.getLong("id");
                if (!CheckStringsUtil.checkAllowNumStart((String)number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\u7ec4\u6210\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApprovePlanEditPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                    args.setCancel(true);
                    return;
                }
                QFilter numberFilter = new QFilter("number", "=", (Object)number);
                QFilter modelFilter = new QFilter(MODEL, "=", (Object)modelId);
                Map numberMap = BusinessDataServiceHelper.loadFromCache((String)SAVE_ENTITY, (QFilter[])new QFilter[]{numberFilter, modelFilter});
                if (numberMap != null && numberMap.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"ApprovePlanEditPlugin_06", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            this.dealBeforeApproveTemplate();
            this.dealApproveTemplate();
            this.handleCentralizedStatusSave();
            this.deleteAuditorRangeIsEmpty();
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADDRELATION)) {
            this.handleAddRelationOperation(null);
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADDROLE)) {
            this.handleAddRoleOperation(null);
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADDUSER)) {
            this.handleAddUserOperation(null);
        } else if (StringUtils.equals((String)operateKey, (String)BTN_SAVESCHEME)) {
            this.handleSaveSchemeOperation();
        } else if (StringUtils.equals((String)operateKey, (String)BTN_IMPORTSCHEME)) {
            this.handleImportScheme();
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADDDIMENSION)) {
            this.handleAddDimension();
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADJDIMMODIFY)) {
            this.handleAdjDimModify();
        } else if (StringUtils.equals((String)operateKey, (String)BTN_ADJDIMREMOVE)) {
            this.handleAdjDimRemove();
        }
    }

    private void deleteAuditorRangeIsEmpty() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUDITORENTRYENTITY);
        ArrayList<Integer> needDelIndexList = new ArrayList<Integer>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String auditorrange = dynamicObject.getString("auditorrange");
            if (!StringUtils.isEmpty((String)auditorrange)) continue;
            needDelIndexList.add(i);
        }
        int[] del = new int[needDelIndexList.size()];
        for (int i = 0; i < del.length; ++i) {
            del[i] = (Integer)needDelIndexList.get(i);
        }
        this.getModel().deleteEntryRows(AUDITORENTRYENTITY, del);
    }

    private void handleAdjDimRemove() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ADJDIMENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Integer> deleteRowIndex = new ArrayList<Integer>(16);
        for (int selectRow : selectRows) {
            Object rowid = this.getModel().getValue("rowid", selectRow);
            if (rowid == null) continue;
            DynamicObjectCollection adjmemberentryentity = this.getModel().getEntryEntity("adjmemberentryentity");
            for (int i = 0; i < adjmemberentryentity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)adjmemberentryentity.get(i);
                String relationrowid = dynamicObject.getString("relationrowid");
                if (!StringUtils.equals((String)relationrowid, (String)rowid.toString())) continue;
                deleteRowIndex.add(i);
            }
        }
        this.getModel().deleteEntryRows("adjmemberentryentity", deleteRowIndex.stream().mapToInt(Integer::valueOf).toArray());
    }

    private void handleAdjDimModify() {
        Object businessModel = this.getModel().getValue(BUSI_RANG);
        if (businessModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ADJDIMENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u4fee\u6539\u3002", (String)"ApprovePlanEditPlugin_08", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ADJDIMENTRYENTITY);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ADJDIMENTRYENTITY, entryCurrentRowIndex);
        String rowid = entryRowEntity.getString("rowid");
        ArrayList<Long> memberIds = new ArrayList<Long>(16);
        DynamicObjectCollection adjmemberentryentity = this.getModel().getEntryEntity("adjmemberentryentity");
        for (DynamicObject dynamicObject : adjmemberentryentity) {
            String relationrowid = dynamicObject.getString("relationrowid");
            if (!StringUtils.equals((String)relationrowid, (String)rowid)) continue;
            DynamicObject member = dynamicObject.getDynamicObject("memberid");
            long id = member.getLong("id");
            memberIds.add(id);
        }
        DynamicObject businessModelObj = (DynamicObject)businessModel;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_CENTRALADJDIM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object billtype = this.getModel().getValue("billtype");
        if (billtype != null) {
            formShowParameter.setCustomParam("billtype", billtype);
        }
        formShowParameter.setCustomParam("memberIds", (Object)SerializationUtils.serializeToBase64(memberIds));
        formShowParameter.setCustomParam("businessModelId", (Object)businessModelObj.getLong("id"));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCustomParam("currentSelectedRow", (Object)SerializationUtils.serializeToBase64((Object)entryRowEntity));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_ADJDIMMODIFY));
        this.getView().showForm(formShowParameter);
    }

    private void handleAddDimension() {
        Object businessModel = this.getModel().getValue(BUSI_RANG);
        if (businessModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject businessModelObj = (DynamicObject)businessModel;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_CENTRALADJDIM);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object billtype = this.getModel().getValue("billtype");
        if (billtype != null) {
            formShowParameter.setCustomParam("billtype", billtype);
        }
        formShowParameter.setCustomParam("businessModelId", (Object)businessModelObj.getLong("id"));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_CENTRALADJDIM));
        this.getView().showForm(formShowParameter);
    }

    private void handleCentralizedStatusSave() {
        Object centralizedstatus = this.getModel().getValue("centralizedstatus");
        if (((Boolean)centralizedstatus).booleanValue()) {
            this.getModel().deleteEntryData(AUDITORENTRYENTITY);
        } else {
            this.getModel().deleteEntryData(CENTRALIZEDENTRYENTITY);
        }
    }

    private void handleImportScheme() {
        Object businessModel = this.getModel().getValue(BUSI_RANG);
        if (businessModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject businessModelObj = (DynamicObject)businessModel;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_CENTALADJSCHEMELIST);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("businessModelId", (Object)businessModelObj.getLong("id"));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        formShowParameter.setCustomParam("billType", (Object)this.getBillType());
        formShowParameter.setCustomParam("billTypeName", (Object)this.getBillTypeName());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_CENTALADJSCHEMELIST));
        this.getView().showForm(formShowParameter);
    }

    private void handleSaveSchemeOperation() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ADJDIMENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u751f\u6210\u65b9\u6848\u7684\u5ba1\u6279\u8c03\u6574\u7ef4\u5ea6\u8bb0\u5f55\u3002", (String)"ApprovePlanEditPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Object businessModel = this.getModel().getValue(BUSI_RANG);
        if (businessModel == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject businessModelObj = (DynamicObject)businessModel;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_CENTRALADJSCHEME);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("businessModelId", (Object)businessModelObj.getLong("id"));
        formShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ADJDIMENTRYENTITY);
        DynamicObjectCollection adjmemberentryentity = this.getModel().getEntryEntity("adjmemberentryentity");
        ArrayList<Object> params = new ArrayList<Object>(16);
        HashSet<String> rowidList = new HashSet<String>(16);
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow);
            String rowid = dynamicObject.getString("rowid");
            if (StringUtils.isEmpty((String)rowid)) continue;
            rowidList.add(rowid);
            params.add(entryEntity.get(selectRow));
        }
        ArrayList<DynamicObject> memberObjs = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : adjmemberentryentity) {
            String relationrowid = dynamicObject.getString("relationrowid");
            if (!rowidList.contains(relationrowid)) continue;
            memberObjs.add(dynamicObject);
        }
        formShowParameter.setCustomParam("adjdims", (Object)SerializationUtils.serializeToBase64(params));
        formShowParameter.setCustomParam("adjmembers", (Object)SerializationUtils.serializeToBase64(memberObjs));
        this.getView().showForm(formShowParameter);
    }

    private void handleAddUserOperation(Map<String, Object> params) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("bos_user");
        showParameter.setFormId("bos_usertreelistf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setHeight("680");
        css.setWidth("1060");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setLookUp(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5ba1\u6279\u4eba-\u4eba\u5458", (String)"ApprovePlanEditPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_ADDUSER);
        if (params != null) {
            Object person = params.get("person");
            showParameter.setSelectedRow(person);
        }
        this.setAuditorEntryCurrentRow(-1);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void handleAddRoleOperation(Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_CENTRALAUDITORROLE);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_CENTRALAUDITORROLE));
        String billType = this.getBillType();
        if (StringUtils.isNotEmpty((String)billType)) {
            List<Map<String, String>> bosUserBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(billType);
            formShowParameter.setCustomParam("bosUserBaseEntityData", (Object)SerializationUtils.serializeToBase64(bosUserBaseEntityData));
        }
        if (params != null) {
            formShowParameter.getCustomParams().putAll(params);
        }
        this.getView().showForm(formShowParameter);
    }

    private String getBillType() {
        Object billtype = this.getModel().getValue("billtype");
        if (billtype == null) {
            return "";
        }
        return billtype.toString().split("#")[0];
    }

    private static MultiLangEnumBridge getApproveBillTypeName() {
        return new MultiLangEnumBridge("\u5ba1\u6279\u5355\u636e", "ApprovePlanEditPlugin_19", "epm-eb-formplugin");
    }

    private String getBillTypeName() {
        Object billtype = this.getModel().getValue("billtype");
        if (billtype == null) {
            return "";
        }
        return billTypeMap.get(billtype.toString().split("#")[0]).loadKDString();
    }

    private void handleAddRelationOperation(Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(EB_CENTRALAUDITORRELATION);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_CENTRALAUDITORRELATION));
        String billType = this.getBillType();
        if (StringUtils.isNotEmpty((String)billType)) {
            List<Map<String, String>> bosUserBaseEntityData = DynamicObjectParseHelper.getBosUserBaseEntityData(billType);
            formShowParameter.setCustomParam("bosUserBaseEntityData", (Object)SerializationUtils.serializeToBase64(bosUserBaseEntityData));
        }
        if (params != null) {
            formShowParameter.getCustomParams().putAll(params);
        }
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((String)actionId, (String)EB_CENTRALAUDITORRELATION)) {
            this.handleAddRelationAction(event);
        } else if (StringUtils.equals((String)actionId, (String)EB_CENTRALAUDITORROLE)) {
            this.handleAddRoleAction(event);
        } else if (StringUtils.equals((String)actionId, (String)BTN_ADDUSER)) {
            this.handleAddUserAction(event);
        } else if (StringUtils.equals((String)actionId, (String)EB_CENTALADJSCHEMELIST)) {
            this.handleImportSchemeAction(event);
        } else if (StringUtils.equals((String)actionId, (String)EB_CENTRALADJDIM)) {
            this.handleAddDimensionAction(event);
        } else if (StringUtils.equals((String)actionId, (String)BTN_ADJDIMMODIFY)) {
            this.handleModifyDimensionAction(event);
        }
    }

    private void handleModifyDimensionAction(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        ApproveAdjDimDto approveAdjDimDto = (ApproveAdjDimDto)returnData;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ADJDIMENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        this.handleAdjDimRemove();
        this.setAdjDimEntryEntity(approveAdjDimDto, selectRows[0]);
    }

    private void handleAddDimensionAction(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        ApproveAdjDimDto approveAdjDimDto = (ApproveAdjDimDto)returnData;
        int newEntryRow = this.getModel().createNewEntryRow(ADJDIMENTRYENTITY);
        this.setAdjDimEntryEntity(approveAdjDimDto, newEntryRow);
    }

    private void setAdjDimEntryEntity(ApproveAdjDimDto approveAdjDimDto, int rowIndex) {
        ApproveAdjDimTypeEnum typeByDimNumber = ApproveAdjDimTypeEnum.getTypeByDimNumber((String)approveAdjDimDto.getDimNum());
        ApproveAdjDimTypeEnum.RangeTypeEnum typeByValue = ApproveAdjDimTypeEnum.RangeTypeEnum.getTypeByValue((String)approveAdjDimDto.getRangeType());
        String rowId = Uuid8.generateShortUuid().toLowerCase();
        this.getModel().setValue("rowid", (Object)rowId, rowIndex);
        this.getModel().setValue("rangetype", (Object)approveAdjDimDto.getRangeType(), rowIndex);
        this.getModel().setValue("dimmemlevel", (Object)approveAdjDimDto.getDimMemLevel(), rowIndex);
        this.getModel().setValue("dimensionnum", (Object)approveAdjDimDto.getDimNum(), rowIndex);
        this.getModel().setValue("dimensionid", (Object)IDUtils.toLong((Object)approveAdjDimDto.getDimId()), rowIndex);
        this.getModel().setValue("basedataid", (Object)approveAdjDimDto.getBaseDataId(), rowIndex);
        this.getModel().setValue("orgreferencefield", (Object)approveAdjDimDto.getReferenceField(), rowIndex);
        if (typeByDimNumber != null) {
            this.getModel().setValue("dimtype", (Object)typeByDimNumber.getValue(), rowIndex);
            ApproveAdjMemberRangeDto approveAdjMemberRangeDto = new ApproveAdjMemberRangeDto();
            List members = approveAdjDimDto.getMembers();
            approveAdjMemberRangeDto.setRowIndex(rowIndex);
            approveAdjMemberRangeDto.setMembers(members);
            approveAdjMemberRangeDto.setDimType(typeByDimNumber);
            approveAdjMemberRangeDto.setRangeType(typeByValue);
            approveAdjMemberRangeDto.setBillTypeName(this.getBillTypeName());
            approveAdjMemberRangeDto.setBillType(this.getBillType());
            approveAdjMemberRangeDto.setOrgReferenceField(approveAdjDimDto.getReferenceField());
            List<Map<String, String>> budgetEntityBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(this.getBillType());
            approveAdjMemberRangeDto.setBudgetEntityBaseEntityData(budgetEntityBaseEntityData);
            approveAdjMemberRangeDto.setDimMemLevel(approveAdjDimDto.getDimMemLevel());
            this.setDimMemberRange(approveAdjMemberRangeDto);
            this.setMemberEntryEntity(members, rowId);
        }
        this.getModel().setValue("dimension", (Object)approveAdjDimDto.getDimension(), rowIndex);
    }

    private void setMemberEntryEntity(List<Map<String, String>> members, String rowId) {
        if (CollectionUtils.isEmpty(members) || StringUtils.isEmpty((String)rowId)) {
            return;
        }
        int[] batchCreateNewEntryRow = this.getModel().batchCreateNewEntryRow("adjmemberentryentity", members.size());
        for (int i = 0; i < members.size(); ++i) {
            Map<String, String> map = members.get(i);
            String id = map.get("id");
            String basedataid = map.get("basedataid");
            this.getModel().setValue("basedatatype", (Object)basedataid, batchCreateNewEntryRow[i]);
            this.getModel().setValue("relationrowid", (Object)rowId, batchCreateNewEntryRow[i]);
            this.getModel().setValue("memberid", (Object)IDUtils.toLong((Object)id), batchCreateNewEntryRow[i]);
        }
    }

    private void handleImportSchemeAction(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        List entity = (List)SerializationUtils.deSerializeFromBase64((String)returnData.toString());
        for (DynamicObject dynamicObject : entity) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(BILL_ENTITY);
            DynamicObjectCollection adjmemberentryentity = dynamicObject.getDynamicObjectCollection("adjmemberentryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) continue;
            int[] batchCreateNewEntryRow = this.getModel().batchCreateNewEntryRow(ADJDIMENTRYENTITY, entryentity.size());
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject object = (DynamicObject)entryentity.get(i);
                String rowId = Uuid8.generateShortUuid().toLowerCase();
                this.getModel().setValue("rowid", (Object)rowId, batchCreateNewEntryRow[i]);
                this.getModel().setValue("dimension", object.get("dimension"), batchCreateNewEntryRow[i]);
                this.getModel().setValue("rangetype", object.get("rangetype"), batchCreateNewEntryRow[i]);
                this.getModel().setValue("dimmemlevel", object.get("dimmemlevel"), batchCreateNewEntryRow[i]);
                this.getModel().setValue("dimmemrange", (Object)this.getDimMeRange(object, adjmemberentryentity), batchCreateNewEntryRow[i]);
                this.getModel().setValue("dimensionnum", object.get("dimensionnum"), batchCreateNewEntryRow[i]);
                this.getModel().setValue("dimensionid", (Object)object.getDynamicObject("dimensionid").getLong("id"), batchCreateNewEntryRow[i]);
                ApproveAdjDimTypeEnum typeByDimNumber = ApproveAdjDimTypeEnum.getTypeByDimNumber((String)object.get("dimensionnum").toString());
                if (typeByDimNumber != null) {
                    this.getModel().setValue("dimtype", (Object)typeByDimNumber.getValue(), batchCreateNewEntryRow[i]);
                }
                this.getModel().setValue("basedataid", object.get("basedataid"), batchCreateNewEntryRow[i]);
                this.getModel().setValue("orgreferencefield", object.get("orgreferencefield"), batchCreateNewEntryRow[i]);
                if (CollectionUtils.isEmpty((Collection)adjmemberentryentity)) continue;
                int[] rows = this.getModel().batchCreateNewEntryRow("adjmemberentryentity", adjmemberentryentity.size());
                for (int j = 0; j < adjmemberentryentity.size(); ++j) {
                    DynamicObject object1 = (DynamicObject)adjmemberentryentity.get(j);
                    this.getModel().setValue("basedatatype", (Object)object1.getString("basedatatype"), rows[j]);
                    this.getModel().setValue("memberid", (Object)object1.getDynamicObject("memberid").getLong("id"), rows[j]);
                    this.getModel().setValue("relationrowid", (Object)rowId, rows[j]);
                }
            }
        }
    }

    private String getDimMeRange(DynamicObject dynamicObject, DynamicObjectCollection adjmemberentryentity) {
        List members;
        ArrayList<String> approveRanges = new ArrayList<String>(16);
        HashMap<String, List> maps = new HashMap<String, List>(16);
        for (DynamicObject memberObj : adjmemberentryentity) {
            String relationrowid = memberObj.getString("relationrowid");
            members = maps.computeIfAbsent(relationrowid, t -> new ArrayList(16));
            HashMap<String, String> member = new HashMap<String, String>(16);
            member.put("id", memberObj.getDynamicObject("memberid").getString("id"));
            member.put("basedataid", memberObj.getString("basedatatype"));
            member.put("name", memberObj.getDynamicObject("memberid").getString("name"));
            members.add(member);
        }
        String dimmemlevel = dynamicObject.getString("dimmemlevel");
        String orgreferencefield = dynamicObject.getString("orgreferencefield");
        String rowid = dynamicObject.getString("rowid");
        members = (List)maps.get(rowid);
        String rangetype = dynamicObject.getString("rangetype");
        String dimtype = dynamicObject.getString("dimtype");
        ApproveAdjDimTypeEnum.RangeTypeEnum typeByValue = ApproveAdjDimTypeEnum.RangeTypeEnum.getTypeByValue((String)rangetype);
        ApproveAdjDimTypeEnum dimTypeEnum = ApproveAdjDimTypeEnum.getTypeByValue((String)dimtype);
        ApproveAdjMemberRangeDto approveAdjMemberRangeDto = new ApproveAdjMemberRangeDto();
        approveAdjMemberRangeDto.setMembers(members);
        approveAdjMemberRangeDto.setRangeType(typeByValue);
        approveAdjMemberRangeDto.setDimType(dimTypeEnum);
        approveAdjMemberRangeDto.setOrgReferenceField(orgreferencefield);
        approveAdjMemberRangeDto.setBillType(this.getBillType());
        approveAdjMemberRangeDto.setBillTypeName(this.getBillTypeName());
        approveAdjMemberRangeDto.setDimMemLevel(dimmemlevel);
        List<Map<String, String>> budgetEntityBaseEntityData = DynamicObjectParseHelper.getBudgetEntityBaseEntityData(this.getBillType());
        approveAdjMemberRangeDto.setBudgetEntityBaseEntityData(budgetEntityBaseEntityData);
        String dimmemrange = ApproveAdjDimTypeEnum.getDimMemberRange((ApproveAdjMemberRangeDto)approveAdjMemberRangeDto, (boolean)false);
        approveRanges.add(dimmemrange);
        return StringUtils.join(approveRanges, (String)";");
    }

    private void handleAddUserAction(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)returnData;
        if (selectedRow.size() == 0) {
            return;
        }
        for (ListSelectedRow listSelectedRow : selectedRow) {
            String name = listSelectedRow.getName();
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            int modifyUserRowIndex = this.getModifyUserRowIndex(primaryKeyValue);
            if (modifyUserRowIndex > -1) {
                this.getModel().setValue("auditorrange", (Object)name, modifyUserRowIndex);
                this.getModel().setValue("person", primaryKeyValue, modifyUserRowIndex);
                this.getModel().setValue("approvetype", (Object)ApproverTypeEnum.PERSON.getDesc(), modifyUserRowIndex);
                this.getModel().setValue("auditortype", (Object)ApproverTypeEnum.PERSON.getValue(), modifyUserRowIndex);
                continue;
            }
            int newEntryRow = this.getModel().createNewEntryRow(AUDITORENTRYENTITY);
            this.getModel().setValue("auditorrange", (Object)name, newEntryRow);
            this.getModel().setValue("person", primaryKeyValue, newEntryRow);
            this.getModel().setValue("approvetype", (Object)ApproverTypeEnum.PERSON.getDesc(), newEntryRow);
            this.getModel().setValue("auditortype", (Object)ApproverTypeEnum.PERSON.getValue(), newEntryRow);
        }
    }

    private int getModifyUserRowIndex(Object primaryKeyValue) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUDITORENTRYENTITY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            long id;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            Object person = dynamicObject.get("person");
            if (!(person instanceof DynamicObject) || (id = ((DynamicObject)person).getLong("id")) != Long.parseLong(primaryKeyValue.toString()) || id == 0L) continue;
            return i;
        }
        return -1;
    }

    private void handleAddRoleAction(ClosedCallBackEvent event) {
        Integer row;
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        AuditorRoleEntity roleEntity = (AuditorRoleEntity)returnData;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUDITORENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject dynamicObject : entryEntity) {
                String billorgkey = dynamicObject.getString("billorgkey");
                String auditorrange = dynamicObject.getString("auditorrange");
                if (StringUtils.isEmpty((String)billorgkey) || StringUtils.isEmpty((String)auditorrange)) continue;
                String billorgkey1 = roleEntity.getBillorgkey();
                String roleName = roleEntity.getRoleName();
                boolean isEqual = StringUtils.equals((String)billorgkey, (String)billorgkey1) && StringUtils.equals((String)auditorrange, (String)roleName);
                if (!isEqual) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89d2\u8272\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u65b0\u589e\u3002", (String)"ApprovePlanEditPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ((row = roleEntity.getRow()) == null || row < 0) {
            row = this.getModel().createNewEntryRow(AUDITORENTRYENTITY);
        }
        this.getModel().setValue("approvetype", (Object)ApproverTypeEnum.WORKFLOW_ROLE.getDesc(), row.intValue());
        this.getModel().setValue("auditortype", (Object)ApproverTypeEnum.WORKFLOW_ROLE.getValue(), row.intValue());
        Long roleId = roleEntity.getRoleId();
        String roleName = roleEntity.getRoleName();
        this.getModel().setValue("auditorrange", (Object)roleName, row.intValue());
        this.getModel().setValue("wfrole", (Object)roleId, row.intValue());
        this.getModel().setValue("billorgkey", (Object)roleEntity.getBillorgkey(), row.intValue());
    }

    private void handleAddRelationAction(ClosedCallBackEvent event) {
        Integer row;
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        AuditorRelationEntity relationEntity = (AuditorRelationEntity)returnData;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(AUDITORENTRYENTITY);
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject dynamicObject : entryEntity) {
                String relation = dynamicObject.getString("relation");
                String relationtype = dynamicObject.getString("relationtype");
                String referenceperson = dynamicObject.getString("referenceperson");
                if (StringUtils.isEmpty((String)relation) || StringUtils.isEmpty((String)relationtype) || StringUtils.isEmpty((String)referenceperson)) continue;
                String referencepersonNew = relationEntity.getReferenceperson();
                Integer relationNew = relationEntity.getRelation();
                Integer relationtypeNew = relationEntity.getRelationtype();
                boolean isEqual = Integer.parseInt(relation) == relationNew && Integer.parseInt(relationtype) == relationtypeNew && StringUtils.equals((String)referencepersonNew, (String)referenceperson);
                if (!isEqual) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u7684\u5173\u7cfb\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u65b0\u589e\u3002", (String)"ApprovePlanEditPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ((row = relationEntity.getRow()) == null || row < 0) {
            row = this.getModel().createNewEntryRow(AUDITORENTRYENTITY);
        }
        this.addOrModifyRelationRow(relationEntity, row);
    }

    private void addOrModifyRelationRow(AuditorRelationEntity relationEntity, int row) {
        List<Map<String, String>> bosUserBaseEntityData = DynamicObjectParseHelper.getBosUserBaseEntityData(this.getBillType());
        for (Map<String, String> map : bosUserBaseEntityData) {
            String referencepersonName = map.get(relationEntity.getReferenceperson());
            if (!StringUtils.isNotEmpty((String)referencepersonName)) continue;
            this.getModel().setValue("approvetype", (Object)(ApproverTypeEnum.RELATE.getDesc() + "-" + referencepersonName), row);
            break;
        }
        this.getModel().setValue("auditortype", (Object)ApproverTypeEnum.RELATE.getValue(), row);
        ApproverRelationEnum approverRelationEnum = ApproverRelationEnum.getByValue((int)relationEntity.getRelation());
        this.getModel().setValue("auditorrange", (Object)(approverRelationEnum == null ? "" : approverRelationEnum.getDesc()), row);
        this.getModel().setValue("relation", (Object)relationEntity.getRelation(), row);
        this.getModel().setValue("relationtype", (Object)relationEntity.getRelationtype(), row);
        this.getModel().setValue("referenceperson", (Object)relationEntity.getReferenceperson(), row);
    }

    private void initLeftTree() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        treeView.deleteAllNodes();
        ArrayList<TreeNode> selectedTreeNode = new ArrayList<TreeNode>();
        TreeNode allNode = this.getAllNode(selectedTreeNode);
        this.deleteNoTempCatalog(allNode);
        this.getPageCache().put("treeCacheName", SerializationUtils.toJsonString((Object)allNode));
        if (allNode != null) {
            this.getPageCache().put(allNode.getId(), JSON.toJSONString((Object)allNode));
            allNode.setParentid("");
            treeView.updateNode(allNode);
            treeView.addNode(allNode);
            treeView.expand(allNode.getId());
            if (selectedTreeNode.size() > 0) {
                treeView.checkNodes(selectedTreeNode);
            }
        }
        TreeSearchUtil.clearSearchPageCache(this.getPageCache(), new TreeSearchUtil.TreeSearchParam(TEMPLATETREE));
    }

    private TreeNode getAllNode(List<TreeNode> selectedTreeNode) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(MODEL);
        long modelId = 0L;
        if (model == null) {
            return null;
        }
        modelId = Long.parseLong(model.getPkValue().toString());
        DynamicObject busiRang = (DynamicObject)this.getModel().getValue(BUSI_RANG);
        long rangId = 0L;
        if (busiRang == null) {
            return null;
        }
        rangId = Long.parseLong(busiRang.getPkValue().toString());
        QFilter modelQf = new QFilter(MODEL, "=", (Object)modelId);
        QFilter busiModelQf = new QFilter("dataset.businessmodel", "=", (Object)rangId);
        busiModelQf.and(new QFilter("dataset.model", "=", (Object)modelId));
        QFilter tempStatusQf = new QFilter("templatestatus", "!=", (Object)"0");
        HashMap<String, ArrayList<TreeNode>> map = new HashMap<String, ArrayList<TreeNode>>(16);
        HashSet<String> templateIds = new HashSet<String>(16);
        Object beforeappmodel = this.getModel().getValue(BEFORE_MODE_TYPE);
        String entityName = templateEntity;
        String selectFileds = queryFiled;
        DynamicObjectCollection remplate = this.getModel().getEntryEntity("beforebilltemp");
        String templateCatalog = "eb_applytemplatelog";
        if (beforeappmodel != null && "2".equals(beforeappmodel.toString())) {
            entityName = "eb_templateentity";
            selectFileds = "id,name,number,templatecatalog,templatetype,templatestatus";
            tempStatusQf = new QFilter("templatestatus", "!=", (Object)"A");
            templateCatalog = "eb_templatecatalog";
            remplate = this.getModel().getEntryEntity("beforereporttemp");
        }
        List templateList = null;
        if (remplate != null) {
            templateList = remplate.stream().map(remplateDo -> remplateDo.getString("fbasedataid_id")).collect(Collectors.toList());
        }
        try (DataSet templateDataSet = QueryServiceHelper.queryDataSet((String)"queryebtemplate", (String)entityName, (String)selectFileds, (QFilter[])new QFilter[]{modelQf, busiModelQf, tempStatusQf}, null);){
            while (templateDataSet.hasNext()) {
                Row next = templateDataSet.next();
                TreeNode treeNode = new TreeNode();
                String id = next.getString("id");
                treeNode.setId(id);
                templateIds.add(id);
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("number") + " " + next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "template");
                dataMap.put("flag", "1");
                treeNode.setData(dataMap);
                if (templateList != null && templateList.contains(id)) {
                    selectedTreeNode.add(treeNode);
                }
                ArrayList<TreeNode> treeNodes = (ArrayList<TreeNode>)map.get(next.getString("templatecatalog"));
                treeNode.setParentid(next.getString("templatecatalog"));
                if (treeNodes == null) {
                    treeNodes = new ArrayList<TreeNode>(16);
                    map.put(next.getString("templatecatalog"), treeNodes);
                }
                treeNodes.add(treeNode);
            }
        }
        this.getPageCache().put(TEMPLATECACHEIDS, JSON.toJSONString(templateIds));
        TreeNode rootNode = null;
        HashMap<String, TreeNode> catalogMap = new HashMap<String, TreeNode>(16);
        try (DataSet catalogDataSet = QueryServiceHelper.queryDataSet((String)"querytemplatecatalog", (String)templateCatalog, (String)"id,name,number,parent", (QFilter[])modelQf.toArray(), (String)"level,sequence");){
            while (catalogDataSet.hasNext()) {
                Row next = catalogDataSet.next();
                TreeNode treeNode = new TreeNode();
                treeNode.setId(next.getString("id"));
                treeNode.setLongNumber(next.getString("number"));
                treeNode.setText(next.getString("name"));
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("type", "templatecatalog");
                dataMap.put("flag", "0");
                treeNode.setData(dataMap);
                catalogMap.put(next.getString("id"), treeNode);
                String parent = next.getString("parent");
                if (StringUtils.isEmpty((String)parent) || "0".equals(parent)) {
                    rootNode = treeNode;
                } else {
                    treeNode.setParentid(parent);
                    TreeNode treeNode1 = (TreeNode)catalogMap.get(parent);
                    ArrayList<TreeNode> children = treeNode1.getChildren();
                    if (children == null) {
                        children = new ArrayList<TreeNode>(16);
                        treeNode1.setChildren(children);
                    }
                    children.add(treeNode);
                }
                if (map.containsKey(next.getString("id"))) {
                    List treeNodes = (List)map.get(next.getString("id"));
                    treeNode.setChildren(treeNodes);
                }
                this.getPageCache().put(next.getString("id"), JSON.toJSONString((Object)treeNode));
            }
        }
        return rootNode;
    }

    private void deleteNoTempCatalog(TreeNode root) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        this.getNeedDeleteList(root, list);
        if (list.size() == 0) {
            return;
        }
        for (TreeNode treeNode : list) {
            String nodeId = treeNode.getId();
            root.getTreeNode(nodeId, 20);
            root.deleteChildNode(nodeId);
        }
    }

    private void getNeedDeleteList(TreeNode root, List<TreeNode> list) {
        if (root == null || root.getChildren() == null || root.getChildren().size() == 0) {
            return;
        }
        List childs = root.getChildren();
        for (TreeNode child : childs) {
            this.getNeedDeleteList(child, list);
            Map dataMap = (Map)child.getData();
            if ("1".equals(dataMap.get("flag"))) {
                Map rootMap = (Map)root.getData();
                rootMap.put("flag", "1");
                continue;
            }
            list.add(child);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        switch (key = event.getProperty().getName()) {
            case "busirang": 
            case "apptype": {
                this.setF7FilterByModel(event);
                break;
            }
            case "apprela": 
            case "billtemplate": 
            case "reporttemplate": {
                this.setF7FilterByModelAndRang(event);
                break;
            }
            case "centralizedscheme": {
                QFilter filter = new QFilter(MODEL, "=", (Object)this.getModelId());
                filter.and("status", "=", (Object)true);
                Object bizModelObj = this.getModel().getValue(BUSI_RANG);
                if (bizModelObj == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanListPlugin_other_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                filter.and("bizrange", "=", (Object)((DynamicObject)bizModelObj).getLong("id"));
                int row = event.getRow();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CENTRALIZEDENTRYENTITY);
                if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                    ArrayList<Long> ids = new ArrayList<Long>(16);
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        DynamicObject dynamicObject;
                        DynamicObject centralizedscheme;
                        if (i == row || (centralizedscheme = (dynamicObject = (DynamicObject)entryEntity.get(i)).getDynamicObject("centralizedscheme")) == null) continue;
                        ids.add(centralizedscheme.getLong("id"));
                    }
                    if (CollectionUtils.isNotEmpty(ids)) {
                        filter.and("id", "not in", ids);
                    }
                }
                event.getCustomQFilters().add(filter);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                showParameter.setMultiSelect(true);
                break;
            }
            case "approveclassify": {
                QFilter filter1 = new QFilter(MODEL, "=", (Object)this.getModelId());
                event.getCustomQFilters().add(filter1);
                break;
            }
        }
    }

    private void dealBeforeApproveTemplate() {
        TreeView treeView = (TreeView)this.getControl(TEMPLATETREE);
        List selectedNodeId = treeView.getTreeState().getCheckedNodeIds();
        Object beforeAppTemplateType = this.getModel().getValue(BEFORE_MODE_TYPE);
        String beforeAppTemplate = "beforebilltemp";
        if (beforeAppTemplateType != null) {
            int rowCount;
            if ("2".equals(beforeAppTemplateType.toString())) {
                beforeAppTemplate = "beforereporttemp";
            } else if (StringUtils.equals((String)"1", (String)beforeAppTemplateType.toString()) && (rowCount = this.getModel().getEntryRowCount(BILL_ENTITY)) > 10) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a0\u5341\u4e2a\u5355\u636e\u6a21\u677f\u3002", (String)"ApprovePlanEditPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection doc = new DynamicObjectCollection();
        DynamicObject saveDyo = null;
        for (String id : selectedNodeId) {
            String templateStrs = this.getPageCache().get(TEMPLATECACHEIDS);
            Set templateIds = new HashSet(16);
            if (StringUtils.isNotEmpty((String)templateStrs)) {
                templateIds = (Set)JSON.parseObject((String)templateStrs, Set.class);
            }
            if (!templateIds.contains(id)) continue;
            saveDyo = BusinessDataServiceHelper.newDynamicObject((String)templateEntity);
            saveDyo.set("id", (Object)id);
            doc.add((Object)saveDyo);
        }
        if (doc != null && doc.size() > 0) {
            this.getModel().setValue(beforeAppTemplate, (Object)doc);
        }
    }

    private void dealApproveTemplate() {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(BILL_ENTITY);
        Object appTemplateType = this.getModel().getValue(MODE_TYPE);
        String appTemplate = "billtemplate";
        if (appTemplateType != null && "2".equals(appTemplateType.toString())) {
            appTemplate = "reporttemplate";
        }
        if (CollectionUtils.isEmpty((Collection)doc)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5ba1\u6279\u6a21\u677f\u3002", (String)"ApprovePlanEditPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        DynamicObject templateDo = null;
        for (DynamicObject entityDo : doc) {
            templateDo = entityDo.getDynamicObject(appTemplate);
            if (templateDo == null) continue;
            if (sb.length() == 0) {
                sb.append(templateDo.getString("name"));
                continue;
            }
            sb.append(",").append(templateDo.getString("name"));
        }
        this.getModel().setValue("apptemplate", (Object)sb.toString());
    }

    private void clearValueModelChange() {
        this.getModel().setValue(BUSI_RANG, null);
        this.getModel().setValue("apptype", null);
        this.getModel().setValue("apprela", null);
        this.getModel().deleteEntryData(BILL_ENTITY);
        this.getView().updateView();
    }

    private void setF7FilterByModel(BeforeF7SelectEvent event) {
        DynamicObject modelDo = (DynamicObject)this.getModel().getValue(MODEL);
        long modelId = 0L;
        if (modelDo == null || modelDo.getPkValue() == null || Long.parseLong(modelDo.getPkValue().toString()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"ApprovePlanEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        modelId = Long.parseLong(modelDo.getPkValue().toString());
        if (event.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("apptype")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(16);
            }
            qFilterList.add(new QFilter(MODEL, "=", (Object)modelId));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    private void setF7FilterByModelAndRang(BeforeF7SelectEvent event) {
        DynamicObject modelDo = (DynamicObject)this.getModel().getValue(MODEL);
        long modelId = 0L;
        if (modelDo == null || modelDo.getPkValue() == null || Long.parseLong(modelDo.getPkValue().toString()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"ApprovePlanEditPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject busiRangDo = (DynamicObject)this.getModel().getValue(BUSI_RANG);
        if (busiRangDo == null || busiRangDo.getPkValue() == null || Long.parseLong(busiRangDo.getPkValue().toString()) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanEditPlugin_09", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        List filterList = event.getCustomQFilters();
        modelId = Long.parseLong(modelDo.getPkValue().toString());
        filterList.add(new QFilter(MODEL, "=", (Object)modelId));
        Map viewsByBusModel = this.getIModelCacheHelper().getViewsByBusModel(IDUtils.toLong((Object)busiRangDo.getPkValue()));
        Long orgViewId = (Long)viewsByBusModel.get(SysDimensionEnum.Entity.getNumber());
        if (IDUtils.isNotEmptyLong((Long)orgViewId).booleanValue()) {
            // empty if block
        }
    }

    private void clearValueRangChange() {
        this.getModel().setValue("apprela", null);
        this.getModel().deleteEntryData(BILL_ENTITY);
        this.getView().updateView();
    }

    private void getAllChildren(TreeNode rootNode, List<Long> allTemplateList, Set<String> templateList) {
        if (rootNode == null) {
            return;
        }
        String nodeId = rootNode.getId();
        if (templateList.contains(nodeId)) {
            allTemplateList.add(Long.parseLong(nodeId));
        } else {
            List children = rootNode.getChildren();
            if (children == null || children.size() == 0) {
                return;
            }
            for (TreeNode child : children) {
                this.getAllChildren(child, allTemplateList, templateList);
            }
        }
    }

    private void initNewRow(List<Long> nodeIdList, Boolean isChecked, String appTemplateFiled) {
        if (isChecked.booleanValue()) {
            HashSet<Long> refTempalteIds = new HashSet<Long>(16);
            int index = 0;
            int row = this.getModel().getEntryRowCount(BILL_ENTITY);
            if (row > 0) {
                DynamicObjectCollection refTemplates = this.getModel().getEntryEntity(BILL_ENTITY);
                for (DynamicObject refTemplate : refTemplates) {
                    Long templateId;
                    DynamicObject dyo = refTemplate.getDynamicObject(appTemplateFiled);
                    if (dyo == null || (templateId = Long.valueOf(dyo.getLong("id"))) == 0L) continue;
                    refTempalteIds.add(templateId);
                }
            }
            for (Long nodeId : nodeIdList) {
                if (refTempalteIds.contains(nodeId)) continue;
                refTempalteIds.add(nodeId);
                index = row++;
                this.getModel().beginInit();
                this.getModel().insertEntryRow(BILL_ENTITY, index);
                this.getModel().setValue(appTemplateFiled, (Object)nodeId, index);
                this.getModel().endInit();
            }
        } else {
            int row = this.getModel().getEntryRowCount(BILL_ENTITY);
            if (row > 0) {
                DynamicObjectCollection refTemplates = this.getModel().getEntryEntity(BILL_ENTITY);
                ArrayList<Integer> removeRows = new ArrayList<Integer>();
                for (int rowIndex = 0; rowIndex < row; ++rowIndex) {
                    Long templateId;
                    DynamicObject refTemplate = (DynamicObject)refTemplates.get(rowIndex);
                    DynamicObject dyo = refTemplate.getDynamicObject(appTemplateFiled);
                    if (dyo == null || !nodeIdList.contains(templateId = Long.valueOf(dyo.getLong("id")))) continue;
                    removeRows.add(rowIndex);
                }
                if (removeRows.size() > 0) {
                    int[] rows = removeRows.stream().mapToInt(Integer::valueOf).toArray();
                    this.getModel().deleteEntryRows(BILL_ENTITY, rows);
                }
            }
        }
    }

    private Long getBizModelId() {
        Object bizModelObj = this.getModel().getValue(BUSI_RANG);
        if (bizModelObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanDimAdjPlugin_05", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return ((DynamicObject)bizModelObj).getLong("id");
    }

    static {
        billTypeMap.put("eb_centralappbill", ApprovePlanEditPlugin.getApproveBillTypeName());
    }
}

