/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.centralapproval.entity.ApprovePlanClassifyEntity;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ApprovePlanListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
SearchEnterListener,
TreeNodeClickListener {
    private static final String BILL_LIST = "billlistap";
    private static final String ENTITY_NAME = "eb_centralappplanentity";
    private static final String COPY_BAK = "copy";
    private static final String EB_CENPLANCLASSIFYENTITY = "eb_cenplanclassifyentity";
    private String modelNumber = "";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_delete"});
        this.addF7SelectListener(this, new String[]{"model"});
        TreeView treeview = (TreeView)this.getControl("treeview");
        treeview.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = this.getSearchAp();
        search.addEnterListener((SearchEnterListener)this);
    }

    private Search getSearchAp() {
        return (Search)this.getControl("searchap");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.refreshBillList();
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchValue = searchEnterEvent.getText();
        if (StringUtils.isEmpty((String)searchValue)) {
            return;
        }
        List<String> searchResult = this.createSearchResult(searchValue);
        if (CollectionUtils.isEmpty(searchResult)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5ba1\u6279\u5206\u7c7b\u3002", (String)"ApprovePlanListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.focusSearchNode(searchResult.get(0));
    }

    private List<String> createSearchResult(String searchValue) {
        QFilter filter = new QFilter("name", "like", (Object)("%" + searchValue + "%"));
        filter.or("number", "like", (Object)("%" + searchValue + "%"));
        filter.and("model", "=", (Object)this.getModelId());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)EB_CENPLANCLASSIFYENTITY, (String)"id, modifydate", (QFilter[])filter.toArray(), (String)"modifydate asc");
        ArrayList<String> resultIds = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : load) {
            resultIds.add(dynamicObject.getString("id"));
        }
        return resultIds;
    }

    private void focusSearchNode(String nodeId) {
        TreeView classifyTreeView = this.getClassifyTreeView();
        String nodeStr = this.getPageCache().get(nodeId);
        if (StringUtils.isNotEmpty((String)nodeStr)) {
            TreeNode focusNode = (TreeNode)SerializationUtils.fromJsonString((String)nodeStr, TreeNode.class);
            classifyTreeView.focusNode(focusNode);
            String parentid = focusNode.getParentid();
            TreeNode parentNode = this.getTreeNodeFromCache(parentid);
            TreeNode rootNodeFromCache = this.getRootNodeFromCache();
            if (rootNodeFromCache == null || parentNode == null) {
                return;
            }
            classifyTreeView.expand(parentNode.getId());
            this.expandTreeNodeChild(rootNodeFromCache, parentNode);
        }
    }

    private void expandTreeNodeChild(TreeNode node, TreeNode parentNode) {
        if (node == null) {
            return;
        }
        TreeView classifyTreeView = this.getClassifyTreeView();
        classifyTreeView.expand(node.getId());
        List children = node.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode child : children) {
            if (StringUtils.equals((String)parentNode.getId(), (String)child.getId())) continue;
            classifyTreeView.expand(child.getId());
            this.expandTreeNodeChild(child, parentNode);
        }
    }

    private TreeView getClassifyTreeView() {
        return (TreeView)this.getControl("treeview");
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)name, (String)"model")) {
            PluginUtils.setModelFilter(beforeF7SelectEvent, this.getView());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        Long modelId = this.getModelId();
        this.getModel().setValue("model", (Object)modelId);
        UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        this.initLeftTree();
        this.setVisible();
    }

    private void setVisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_up", "btn_down"});
    }

    private void initLeftTree() {
        this.buildClassifyTree();
    }

    private TreeNode buildClassifyTreeRootNode() {
        TreeNode root = this.getRootNode();
        List<ApprovePlanClassifyEntity> planClassifyList = this.getPlanClassifyList();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (ApprovePlanClassifyEntity approvePlanClassifyEntity : planClassifyList) {
            TreeNode node = new TreeNode();
            node.setId(approvePlanClassifyEntity.getId() + "");
            node.setText(approvePlanClassifyEntity.getName());
            node.setParentid(approvePlanClassifyEntity.getParentId() + "");
            nodeMap.put(node.getId(), node);
            this.getPageCache().put(node.getId(), SerializationUtils.toJsonString((Object)node));
        }
        for (ApprovePlanClassifyEntity approvePlanClassifyEntity : planClassifyList) {
            Long parentId = approvePlanClassifyEntity.getParentId();
            Long id = approvePlanClassifyEntity.getId();
            TreeNode node = (TreeNode)nodeMap.get(id + "");
            TreeNode parentNode = (TreeNode)nodeMap.get(parentId + "");
            if (parentNode == null) {
                root.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return root;
    }

    private TreeNode getRootNode() {
        TreeNode root = new TreeNode();
        root.setId("-1");
        root.setText(ResManager.loadKDString((String)"\u5ba1\u6279\u5206\u7c7b", (String)"ApprovePlanListPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        return root;
    }

    private void buildClassifyTree() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeNode rootNode = this.buildClassifyTreeRootNode();
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        treeView.updateNode(rootNode);
        treeView.expand(rootNode.getId());
        treeView.focusNode(rootNode);
        this.cacheRootNode(rootNode);
    }

    private void cacheRootNode(TreeNode rootNode) {
        this.getPageCache().put(rootNode.getId(), SerializationUtils.toJsonString((Object)rootNode));
        this.getPageCache().put(String.format("%s.root", this.getView().getPageId()), SerializationUtils.toJsonString((Object)rootNode));
    }

    private TreeNode getRootNodeFromCache() {
        String nodeStr = this.getPageCache().get(String.format("%s.root", this.getView().getPageId()));
        if (StringUtils.isEmpty((String)nodeStr)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)nodeStr, TreeNode.class);
    }

    private Map<String, ApprovePlanClassifyEntity> getApprovePlanClassifyEntityMap() {
        DynamicObject[] dynamicObjects;
        HashMap<String, ApprovePlanClassifyEntity> result = new HashMap<String, ApprovePlanClassifyEntity>(16);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        for (DynamicObject value : dynamicObjects = BusinessDataServiceHelper.load((String)EB_CENPLANCLASSIFYENTITY, (String)"id, model, name, number, parentid", (QFilter[])filter.toArray(), (String)"modifydate asc")) {
            long id = value.getLong("id");
            ApprovePlanClassifyEntity approvePlanClassifyEntity = new ApprovePlanClassifyEntity();
            approvePlanClassifyEntity.setId(Long.valueOf(value.getLong("id")));
            approvePlanClassifyEntity.setModelId(Long.valueOf(value.getLong("model.id")));
            approvePlanClassifyEntity.setName(value.getString("name"));
            approvePlanClassifyEntity.setNumber(value.getString("number"));
            approvePlanClassifyEntity.setParentId(Long.valueOf(value.getLong("parentid")));
            result.put(id + "", approvePlanClassifyEntity);
        }
        return result;
    }

    private List<ApprovePlanClassifyEntity> getApprovePlanClassifyList() {
        DynamicObject[] dynamicObjects;
        ArrayList<ApprovePlanClassifyEntity> result = new ArrayList<ApprovePlanClassifyEntity>(16);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        for (DynamicObject value : dynamicObjects = BusinessDataServiceHelper.load((String)EB_CENPLANCLASSIFYENTITY, (String)"id, model, name, number, parentid", (QFilter[])filter.toArray(), (String)"modifydate asc")) {
            ApprovePlanClassifyEntity approvePlanClassifyEntity = new ApprovePlanClassifyEntity();
            approvePlanClassifyEntity.setId(Long.valueOf(value.getLong("id")));
            approvePlanClassifyEntity.setModelId(Long.valueOf(value.getLong("model.id")));
            approvePlanClassifyEntity.setName(value.getString("name"));
            approvePlanClassifyEntity.setNumber(value.getString("number"));
            approvePlanClassifyEntity.setParentId(Long.valueOf(value.getLong("parentid")));
            result.add(approvePlanClassifyEntity);
        }
        return result;
    }

    private List<ApprovePlanClassifyEntity> getPlanClassifyList() {
        List<ApprovePlanClassifyEntity> approvePlanClassifyList = this.getApprovePlanClassifyList();
        HashMap<String, List> childsMap = new HashMap<String, List>(16);
        for (ApprovePlanClassifyEntity approvePlanClassifyEntity : approvePlanClassifyList) {
            List approvePlanClassifyEntities = childsMap.computeIfAbsent(approvePlanClassifyEntity.getParentId() + "", t -> new ArrayList(16));
            approvePlanClassifyEntities.add(approvePlanClassifyEntity);
        }
        for (ApprovePlanClassifyEntity value : approvePlanClassifyList) {
            Long id = value.getId();
            List approvePlanClassifyEntities = (List)childsMap.get(id + "");
            if (!CollectionUtils.isNotEmpty((Collection)approvePlanClassifyEntities)) continue;
            value.getChildren().addAll(approvePlanClassifyEntities);
        }
        return approvePlanClassifyList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        BillList billentry = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection rows = billentry.getSelectedRows();
        switch (itemKey) {
            case "btn_setapprelat": {
                if (rows == null || rows.size() == 0) {
                    return;
                }
                this.openAppScenarioPage(itemKey);
                break;
            }
            case "btn_enable": {
                if (rows == null || rows.size() == 0) {
                    return;
                }
                this.updateEnaleStatus(rows, Boolean.TRUE);
                break;
            }
            case "btn_unable": {
                if (rows == null || rows.size() == 0) {
                    return;
                }
                this.updateEnaleStatus(rows, Boolean.FALSE);
                break;
            }
            case "btn_copy": {
                if (rows == null || rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ApprovePlanListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.copyListRows(rows);
                break;
            }
            case "settemplate": {
                HashSet<Long> set = new HashSet<Long>(16);
                String modelAndbus = this.checkModelAndBussnessmodel(set);
                this.openMoreTemplatePage(modelAndbus, set);
                break;
            }
            case "btn_refresh": {
                this.refreshPage();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((String)key, (String)"btn_delete")) {
            TreeNode focusNode = this.getFocusNode();
            if (focusNode == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8981\u5220\u9664\u7684\u5ba1\u6279\u5206\u7c7b\u8282\u70b9\u3002", (String)"ApprovePlanListPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode rootNode = this.getRootNode();
            if (StringUtils.equals((String)rootNode.getId(), (String)focusNode.getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u9664\u3002", (String)"ApprovePlanListPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("approveclassify", "=", (Object)IDUtils.toLong((Object)focusNode.getId()));
            filter.and("model", "=", (Object)this.getModelId());
            DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"effectstatus,name", (QFilter[])filter.toArray());
            ArrayList<String> enablePlanNames = new ArrayList<String>(16);
            for (DynamicObject value : load) {
                String effectstatus = value.getString("effectstatus");
                if (!StringUtils.equals((String)"true", (String)effectstatus)) continue;
                enablePlanNames.add(value.getString("name"));
            }
            if (CollectionUtils.isNotEmpty(enablePlanNames)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5ba1\u6279\u5206\u7c7b\u4e2d\u5305\u542b\u5df2\u542f\u7528\u7684\u5ba1\u6279\u65b9\u6848\u201c%1\u201d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApprovePlanListPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", enablePlanNames)}));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u6b64\u5ba1\u6279\u5206\u7c7b\u53ca\u5176\u4e0b\u6240\u6709\u5ba1\u6279\u65b9\u6848\uff1f", (String)"ApprovePlanListPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteClassify", (IFormPlugin)this));
        }
    }

    private ListSelectedRowCollection getSelectedRowData() {
        BillList billList = (BillList)this.getControl(BILL_LIST);
        return billList.getSelectedRows();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (StringUtils.equals((String)callBackId, (String)"deleteClassify")) {
            if (result == MessageBoxResult.Cancel) {
                return;
            }
            try (TXHandle tx = TX.requiresNew((String)"BgmdTaskListUpgrade");){
                try {
                    this.deleteApprovePlanByClassify();
                    this.deleteApproveClassifyByFocusNode();
                    this.refreshPage();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ApprovePlanListPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    tx.markRollback();
                }
            }
        }
    }

    private String checkModelAndBussnessmodel(Set<Long> set) {
        BillList billlistap = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ApprovePlanListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return null;
        }
        return this.queryapproveCen(selectedRows, set);
    }

    private String queryapproveCen(ListSelectedRowCollection selectedRows, Set<Long> set) {
        String modelAndbus = "";
        ArrayList<Long> list = new ArrayList<Long>(selectedRows.size());
        HashSet<Long> modelSet = new HashSet<Long>(8);
        HashSet<Long> bussSet = new HashSet<Long>(8);
        for (ListSelectedRow selectedRow : selectedRows) {
            list.add((Long)selectedRow.getPrimaryKeyValue());
            set.add((Long)selectedRow.getPrimaryKeyValue());
        }
        DynamicObjectCollection message = QueryServiceHelper.query((String)ENTITY_NAME, (String)"model.id,busirang.id", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
        for (DynamicObject dny : message) {
            modelSet.add(dny.getLong("model.id"));
            bussSet.add(dny.getLong("busirang.id"));
        }
        if (modelSet.size() > 1 || bussSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u4f53\u7cfb\u548c\u4e1a\u52a1\u6a21\u578b\u3002", (String)"ApprovePlanListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        modelAndbus = modelSet.toArray()[0] + "!!" + bussSet.toArray()[0];
        return modelAndbus;
    }

    private void openMoreTemplatePage(String modelAndbus, Set<Long> set) {
        if (StringUtils.isEmpty((String)modelAndbus) || set == null || set.size() == 0) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_setmoretemplate_new");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "moeretemplate"));
        formShowParameter.setCustomParam("modelAndbus", (Object)modelAndbus);
        formShowParameter.setCustomParam("ids", (Object)SerializationUtils.serializeToBase64(set));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void openAppScenarioPage(String key) {
        if ("btn_setapprelat".equals(key)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"eb_centralapprelentity", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if ("btn_setapprelat".equals(key)) {
            BillList billentry = (BillList)this.getView().getControl(BILL_LIST);
            ListSelectedRowCollection selectRows = billentry.getSelectedRows();
            DynamicObjectCollection updateObjectCollect = new DynamicObjectCollection();
            DynamicObject updateObj = null;
            if (closedCallBackEvent.getReturnData() != null) {
                ListSelectedRowCollection returnRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                ArrayList relatIdList = new ArrayList();
                returnRows.forEach(e -> {
                    Long reletId = Long.parseLong(e.getPrimaryKeyValue().toString());
                    relatIdList.add(reletId);
                });
                QFilter filter = new QFilter("id", "in", relatIdList);
                DynamicObject[] apprelaCollect = BusinessDataServiceHelper.load((String)"eb_centralapprelentity", (String)"id", (QFilter[])new QFilter[]{filter});
                Long userId = this.getUserId();
                Date sysDate = TimeServiceHelper.now();
                for (ListSelectedRow row : selectRows) {
                    updateObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
                    updateObj.set("id", row.getPrimaryKeyValue());
                    DynamicObjectCollection updateDyo = updateObj.getDynamicObjectCollection("apprela");
                    DynamicObjectType objectType = updateDyo.getDynamicObjectType();
                    if (apprelaCollect != null && apprelaCollect.length > 0) {
                        for (DynamicObject dyo : apprelaCollect) {
                            DynamicObject saveDyo = new DynamicObject(objectType);
                            saveDyo.set("fbasedataid", (Object)dyo.getLong("id"));
                            updateDyo.add((Object)saveDyo);
                        }
                    }
                    updateObj.set("modifier", (Object)userId);
                    updateObj.set("modifydate", (Object)sysDate);
                    updateObjectCollect.add((Object)updateObj);
                }
                if (updateObjectCollect.size() > 0) {
                    SaveServiceHelper.update((DynamicObject[])((DynamicObject[])updateObjectCollect.toArray((Object[])new DynamicObject[0])));
                    this.refreshBillList();
                }
            }
        } else if ("moeretemplate".equals(key)) {
            this.refreshBillList();
        } else if (StringUtils.equals((String)EB_CENPLANCLASSIFYENTITY, (String)key)) {
            this.handleAddApproveClassifyAction(closedCallBackEvent);
        }
    }

    private void handleAddApproveClassifyAction(ClosedCallBackEvent event) {
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        TreeNode focusNode = this.getFocusNode();
        if (focusNode == null) {
            return;
        }
        Map map = (Map)returnData;
        String id = map.get("id").toString();
        if (IDUtils.isEmptyLong((Long)IDUtils.toLong((Object)id)).booleanValue()) {
            return;
        }
        this.initLeftTree();
        TreeNode treeNodeFromCache = this.getTreeNodeFromCache(id);
        if (treeNodeFromCache != null) {
            this.focusSearchNode(treeNodeFromCache.getId());
        }
        this.refreshBillList();
    }

    private TreeNode getFocusNode() {
        TreeView treeview = (TreeView)this.getControl("treeview");
        String focusNodeId = treeview.getTreeState().getFocusNodeId();
        String nodeStr = this.getPageCache().get(focusNodeId);
        if (StringUtils.isEmpty((String)nodeStr)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)nodeStr, TreeNode.class);
    }

    private void updateEnaleStatus(ListSelectedRowCollection selectRows, Boolean isEnable) {
        String userId = RequestContext.get().getUserId();
        String status = "0";
        if (isEnable.booleanValue()) {
            status = "1";
        }
        if (selectRows != null && selectRows.size() > 0) {
            String sql = "update t_eb_centralappplan set feffectstatus = " + status + ",fmodifier=" + userId + ",fmodifydate=  now()  where fid in " + selectRows.stream().map(e -> e.getPrimaryKeyValue().toString()).collect(Collectors.joining(",", "(", ")"));
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql);
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(BILL_LIST);
        billList.clearSelection();
        billList.refresh();
    }

    private void copyListRows(ListSelectedRowCollection rows) {
        DynamicObject[] selectPlans;
        ArrayList<DynamicObject> copyPlans = new ArrayList<DynamicObject>(16);
        long userId = this.getUserId();
        Date sysDate = TimeServiceHelper.now();
        Set<String> numbers = this.getAllNumbers(this.getModelId());
        Object[] selectIds = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray();
        for (DynamicObject plan : selectPlans = BusinessDataServiceHelper.load((Object[])selectIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME).getDynamicObjectType())) {
            DynamicObject new_plan = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            DynamicObjectUtils.copy((DynamicObject)plan, (DynamicObject)new_plan);
            String number = this.getNewNumber(plan.getString("number"), numbers);
            if (number.length() > 50) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002\u590d\u5236\u540e\u7684\u65b9\u6848\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26\u3002", (String)"ApprovePlanListPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            new_plan.set("number", (Object)number);
            new_plan.set("creater", (Object)userId);
            new_plan.set("createdate", (Object)sysDate);
            copyPlans.add(new_plan);
        }
        SaveServiceHelper.save((DynamicObject[])copyPlans.toArray(new DynamicObject[0]));
        this.refreshBillList();
    }

    private String getNewNumber(String number, Set<String> numberSet) {
        StringBuilder temp = new StringBuilder(number);
        temp.append(COPY_BAK);
        int i = 1;
        while (numberSet.contains(temp.toString())) {
            String tmp = temp.toString();
            if (!numberSet.contains(tmp + i)) {
                temp.append(i);
            }
            ++i;
        }
        String newNumber = temp.toString();
        numberSet.add(newNumber);
        return newNumber;
    }

    private Set<String> getAllNumbers(Long model) {
        HashSet<String> numberSet = new HashSet<String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_NAME, (String)"number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model)});
        if (query == null || query.size() == 0) {
            return numberSet;
        }
        query.forEach(e -> numberSet.add(e.getString("number")));
        return numberSet;
    }

    private String getModelNumber() {
        Object model = this.getModel().getValue("model");
        if (model instanceof DynamicObject) {
            DynamicObject modelObj = (DynamicObject)model;
            return modelObj.getString("shownumber");
        }
        return "";
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().forEach(customQFilter -> {
            String property = customQFilter.getProperty();
            if (StringUtils.equals((String)"modelid.id", (String)property)) {
                customQFilter.__setProperty("model.id");
            }
        });
        this.modelNumber = this.getModelNumber();
        e.getCustomQFilters().add(new QFilter("model.shownumber", "=", (Object)this.modelNumber));
        TreeNode rootNode = this.getRootNode();
        TreeNode focusNode = this.getFocusNode();
        if (focusNode != null && !StringUtils.equals((String)rootNode.getId(), (String)focusNode.getId())) {
            List<Long> focusNodeAllChildrenIds = this.getFocusNodeAllChildrenIds();
            e.getCustomQFilters().add(new QFilter("approveclassify", "in", focusNodeAllChildrenIds));
        }
    }

    private List<Long> getFocusNodeAllChildrenIds() {
        ArrayList<Long> result = new ArrayList<Long>(16);
        TreeNode focusNode = this.getFocusNode();
        if (focusNode == null) {
            return result;
        }
        result.add(IDUtils.toLong((Object)focusNode.getId()));
        List<ApprovePlanClassifyEntity> planClassifyList = this.getPlanClassifyList();
        for (ApprovePlanClassifyEntity approvePlanClassifyEntity : planClassifyList) {
            if (!IDUtils.toLong((Object)focusNode.getId()).equals(approvePlanClassifyEntity.getId())) continue;
            this.getAllChildrenIds(result, approvePlanClassifyEntity);
            break;
        }
        return result;
    }

    private void getAllChildrenIds(List<Long> childIds, ApprovePlanClassifyEntity approvePlanClassifyEntity) {
        if (approvePlanClassifyEntity == null) {
            return;
        }
        childIds.add(approvePlanClassifyEntity.getId());
        List children = approvePlanClassifyEntity.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (ApprovePlanClassifyEntity child : children) {
            this.getAllChildrenIds(childIds, child);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((String)name, (String)"model")) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApprovePlanListPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("modelId", newValue.getString("id"));
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)this.getModelId());
            this.refreshPage();
        }
    }

    @Override
    public Long getModelId() {
        String modelIdCache = this.getPageCache().get("modelId");
        if (StringUtils.isEmpty((String)modelIdCache)) {
            Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
            if (IDUtils.isNull((Long)modelId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"ApproveRelatFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("modelId", modelId.toString());
            return modelId;
        }
        return IDUtils.toLong((Object)modelIdCache);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List selectMainOrgIds = args.getSearchClickEvent().getSelectMainOrgIds();
        this.getPageCache().put("modelId", ObjectSerialUtil.toByteSerialized((Object)(selectMainOrgIds.size() > 0 ? selectMainOrgIds.get(0) : Long.valueOf(0L))));
        List selectFields = args.getFilterParameter().getSelectFields();
        if (selectFields != null && selectFields.size() > 0 && ((String)selectFields.get(0)).equals("model.id")) {
            this.getPageCache().put("permmodelId", selectMainOrgIds.size() > 0 ? ((Long)selectMainOrgIds.get(0)).toString() : "");
        }
        if (selectMainOrgIds.size() == 1) {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)((Long)selectMainOrgIds.get(0)));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (type.equals("new")) {
            if (this.getModel().getValue("model") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AnalyzeListSet_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            TreeNode focusNode = this.getFocusNode();
            TreeNode root = this.getRootNode();
            if (focusNode == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5ba1\u6279\u5206\u7c7b\u8282\u70b9\u3002", (String)"ApprovePlanListPlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else if (StringUtils.equals((String)focusNode.getId(), (String)root.getId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u5ba1\u6279\u5206\u7c7b\u6839\u8282\u70b9\u4e0a\u65b0\u589e\u5ba1\u6279\u65b9\u6848\u3002", (String)"ApprovePlanListPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if (StringUtils.equals((String)"btn_addnew", (String)type)) {
            this.openAddApproveClassifyDialog();
        } else if (StringUtils.equals((String)"btn_modify", (String)type)) {
            this.openModifyApproveClassifyDialog();
        } else if (StringUtils.equals((String)"searchbefore", (String)type)) {
            Search search = this.getSearchAp();
            String searchKey = search.getSearchKey();
            this.searchClassifyTree(searchKey, false);
        } else if (StringUtils.equals((String)"searchnext", (String)type)) {
            Search search = this.getSearchAp();
            String searchKey = search.getSearchKey();
            this.searchClassifyTree(searchKey, true);
        } else if (StringUtils.equals((String)"refresh", (String)type)) {
            e.setCancel(true);
        } else if (StringUtils.equals((String)"btn_delete", (String)type)) {
            e.setCancel(true);
        } else if (StringUtils.equals((String)"delete", (String)type)) {
            ListSelectedRowCollection selectedRowData = this.getSelectedRowData();
            HashSet<Long> ids = new HashSet<Long>(16);
            if (CollectionUtils.isNotEmpty((Collection)selectedRowData)) {
                for (ListSelectedRow selectedRowDatum : selectedRowData) {
                    Object primaryKeyValue = selectedRowDatum.getPrimaryKeyValue();
                    ids.add(IDUtils.toLong((Object)primaryKeyValue));
                }
            }
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"effectstatus", (QFilter[])filter.toArray());
            ArrayList<String> enablePlanNames = new ArrayList<String>(16);
            for (DynamicObject value : load) {
                String effectstatus = value.getString("effectstatus");
                if (!StringUtils.equals((String)"true", (String)effectstatus)) continue;
                enablePlanNames.add(value.getString("name"));
            }
            if (CollectionUtils.isNotEmpty(enablePlanNames)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5ba1\u6279\u65b9\u6848\u201c%1\u201d\u5df2\u542f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"ApprovePlanListPlugin_other_01", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", enablePlanNames)}));
                e.setCancel(true);
            }
        }
    }

    private void searchClassifyTree(String searchKey, boolean isNext) {
        List<String> searchResult = this.createSearchResult(searchKey);
        if (CollectionUtils.isEmpty(searchResult)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u5ba1\u6279\u5206\u7c7b\u3002", (String)"ApprovePlanListPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode focusNode = this.getFocusNode();
        TreeNode searchFocusNode = null;
        if (focusNode == null) {
            searchFocusNode = this.getTreeNodeFromCache(searchResult.get(0));
        } else {
            int index = 0;
            for (int i = 0; i < searchResult.size(); ++i) {
                String nodeId = searchResult.get(i);
                if (!StringUtils.equals((String)nodeId, (String)focusNode.getId())) continue;
                if (isNext) {
                    if (i == searchResult.size() - 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5230\u8fbe\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u3002", (String)"ApprovePlanListPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    index = i + 1;
                    if (index < searchResult.size()) {
                        searchFocusNode = this.getTreeNodeFromCache(searchResult.get(index));
                        break;
                    }
                    searchFocusNode = this.getTreeNodeFromCache(searchResult.get(searchResult.size() - 1));
                    break;
                }
                if (i == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5230\u8fbe\u7b2c\u4e00\u4e2a\u8282\u70b9\u3002", (String)"ApprovePlanListPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                index = i - 1;
                if (index > 0) {
                    searchFocusNode = this.getTreeNodeFromCache(searchResult.get(index));
                    break;
                }
                searchFocusNode = this.getTreeNodeFromCache(searchResult.get(0));
                break;
            }
        }
        if (searchFocusNode == null) {
            this.focusSearchNode(searchResult.get(0));
        } else {
            this.focusSearchNode(searchFocusNode.getId());
        }
    }

    private TreeNode getTreeNodeFromCache(String nodeId) {
        String nodeStr = this.getPageCache().get(nodeId);
        if (StringUtils.isEmpty((String)nodeStr)) {
            return null;
        }
        return (TreeNode)SerializationUtils.fromJsonString((String)nodeStr, TreeNode.class);
    }

    private void openModifyApproveClassifyDialog() {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(EB_CENPLANCLASSIFYENTITY);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        TreeNode focusNode = this.getFocusNode();
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u5ba1\u6279\u5206\u7c7b\u8282\u70b9\u3002", (String)"ApprovePlanListPlugin_other_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equals((String)this.getRootNode().getId(), (String)focusNode.getId())) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ApprovePlanListPlugin_other_03", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, ApprovePlanClassifyEntity> approvePlanClassifyEntityMap = this.getApprovePlanClassifyEntityMap();
        ApprovePlanClassifyEntity approvePlanClassifyEntity = approvePlanClassifyEntityMap.get(focusNode.getId());
        baseShowParameter.setCustomParam("focusNode", (Object)SerializationUtils.toJsonString((Object)focusNode));
        baseShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        baseShowParameter.setCustomParam("classifyEntity", (Object)SerializationUtils.toJsonString((Object)approvePlanClassifyEntity));
        baseShowParameter.setCustomParam("isEdit", (Object)true);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_CENPLANCLASSIFYENTITY));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String type = ((AbstractOperate)e.getSource()).getOperateKey();
        if (StringUtils.equals((String)type, (String)"btn_delete")) {
            this.refreshPage();
        }
    }

    private void refreshPage() {
        this.initLeftTree();
        this.refreshBillList();
    }

    private void deleteApprovePlanByClassify() {
        List<Long> classifyIds = this.getFocusNodeAllChildrenIds();
        if (CollectionUtils.isEmpty(classifyIds)) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("approveclassify", "in", classifyIds);
        QFilter filter1 = new QFilter("model", "=", (Object)this.getModelId());
        filter1.and("approveclassify", "in", classifyIds);
        filter1.and("effectstatus", "=", (Object)true);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"effectstatus", (QFilter[])filter1.toArray());
        if (load != null && load.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5ba1\u6279\u5206\u7c7b\u4e0b\u5b58\u5728\u5df2\u542f\u7528\u7684\u5ba1\u6279\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ApprovePlanListPlugin_other_04", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            throw new KDBizException("exit valid scheme");
        }
        DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])filter.toArray());
    }

    private void deleteApproveClassifyByFocusNode() {
        List<Long> focusNodeAllChildrenIds = this.getFocusNodeAllChildrenIds();
        List<Long> collect = focusNodeAllChildrenIds.stream().map(IDUtils::toLong).collect(Collectors.toList());
        this.deleteApproveClassify(this.getModelId(), collect);
    }

    private void deleteApproveClassify(Long modelId, List<Long> ids) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("id", "in", ids);
        DeleteServiceHelper.delete((String)EB_CENPLANCLASSIFYENTITY, (QFilter[])filter.toArray());
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        TreeNode focusNode = this.getFocusNode();
        if (focusNode != null) {
            parameter.setCustomParam("focusNodeId", (Object)focusNode.getId());
        }
    }

    private void openAddApproveClassifyDialog() {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(EB_CENPLANCLASSIFYENTITY);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        TreeNode focusNode = this.getFocusNode();
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u5ba1\u6279\u5206\u7c7b\u7684\u7236\u8282\u70b9\u3002", (String)"ApprovePlanListPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        baseShowParameter.setCustomParam("focusNode", (Object)SerializationUtils.toJsonString((Object)focusNode));
        baseShowParameter.setCustomParam("modelId", (Object)this.getModelId());
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EB_CENPLANCLASSIFYENTITY));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject row : rows) {
                ids.add(row.getLong("id"));
            }
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)ApprovePlanListPlugin.ENTITY_NAME);
            for (DynamicObject row : rows) {
                Object dynamicObject2;
                long id = row.getLong("id");
                DynamicObject scheme = (DynamicObject)dynamicObjectMap.get(id);
                DynamicObjectCollection centralizedentryentity = scheme.getDynamicObjectCollection("centralizedentryentity");
                ArrayList<String> names = new ArrayList<String>(16);
                HashSet<String> userNames = new HashSet<String>(16);
                for (Object dynamicObject2 : centralizedentryentity) {
                    DynamicObjectCollection collection;
                    DynamicObject centralizedscheme = dynamicObject2.getDynamicObject("centralizedscheme");
                    DynamicObjectCollection entryentity2 = centralizedscheme.getDynamicObjectCollection("entryentity2");
                    String name = centralizedscheme.getString("name");
                    if (StringUtils.isEmpty((String)name)) continue;
                    names.add(name);
                    if (CollectionUtils.isEmpty((Collection)entryentity2) || (collection = ((DynamicObject)entryentity2.get(0)).getDynamicObjectCollection("checker")) == null) continue;
                    for (DynamicObject checker : collection) {
                        if (StringUtils.isEmpty((String)checker.get("fbasedataid.name").toString())) continue;
                        userNames.add(checker.get("fbasedataid.name").toString());
                    }
                }
                DynamicObjectCollection auditorentryentity = scheme.getDynamicObjectCollection("auditorentryentity");
                dynamicObject2 = auditorentryentity.iterator();
                while (dynamicObject2.hasNext()) {
                    DynamicObject dynamicObject3 = (DynamicObject)dynamicObject2.next();
                    String auditorrange = dynamicObject3.getString("auditorrange");
                    if (StringUtils.isEmpty((String)auditorrange)) continue;
                    userNames.add(auditorrange);
                }
                row.set("explain", (Object)"");
                if (CollectionUtils.isNotEmpty(names)) {
                    row.set("explain", (Object)String.join((CharSequence)";", names));
                }
                row.set("bapprela", (Object)"");
                if (!CollectionUtils.isNotEmpty(userNames)) continue;
                String join = String.join((CharSequence)";", userNames);
                row.set("bapprela", (Object)join);
            }
            return rows;
        }
    }
}

