/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.rejectbill.entity.RejectBill;
import kd.epm.eb.business.rejectbill.entity.RejectLog;
import kd.epm.eb.business.rejectbill.entity.RejectLogDetail;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.centralapproval.AdjustRecordColInfo;
import kd.epm.eb.common.centralapproval.AdjustRecordConstant;
import kd.epm.eb.common.centralapproval.AppAdjustRecord;
import kd.epm.eb.common.centralapproval.AppRecordColType;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.RecordSearchEntry;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralapproval.ShowColumn;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class ApproveRecordListFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(ApproveRecordListFormPlugin.class);
    private static final String PRE_ENTITY = "entryentity";
    private static final String PRE_TAB = "tabpageap";
    private static final String REJECT_TAB_PREFIX = "rejecttab";
    private static final String REJECT_ENTITY = "rejectentryentity";
    private static final String TAB_AP = "tabap";
    private static String recordSearchEntry_copy = null;
    private static String adjustRecordMap_copy = null;
    private static String showColumnMap_copy = null;
    private RecordSearchEntry recordSearchEntry = null;
    private final Map<String, Long> templateEntityMap = new HashMap<String, Long>(16);
    private final Map<String, List<AppAdjustRecord>> adjustRecordMap = new HashMap<String, List<AppAdjustRecord>>(16);
    private Map<String, ShowColumn> showColumnsMap = null;
    private static String[] formats = new String[]{"MM/dd/yyyy HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss.SS", "yyyy-MM-dd HH:mm:ss.SSS", "EEE MMM dd HH:mm:ss zzz yyyy", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.S", "yyyy/MM/dd HH:mm:ss.SS", "yyyy/MM/dd HH:mm:ss.SSS"};
    private Map<Long, String> userMap = Maps.newLinkedHashMap();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addHyperLinkedClickListeners();
        Map<String, Long> templateInfo = this.getTemplateInfo();
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        for (String entityKey : templateInfo.keySet()) {
            this.bindApproveData(showColumnMap, entityKey, false);
        }
        this.bindApproveData(showColumnMap, REJECT_ENTITY, true);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PRE_ENTITY);
        if (entryGrid == null) {
            return;
        }
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void openAppopenApproveBillPrepare(int rowIndex) {
        IFormView parentView = this.getView().getParentView();
        String splitcentral = (String)this.getModel().getValue("splitcentral", rowIndex);
        if (splitcentral != null && !"\u2714".equals(splitcentral)) {
            String billno = (String)this.getModel().getValue("billno", rowIndex);
            DynamicObject approveId = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            Object pkId = approveId.get("id");
            if (pkId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u952e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveBillListNew_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (!CentralAppBillService.getInstance().checkExist("eb_centralappbill", "id", pkId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApproveBillListNew_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String pageId = this.getView().getPageId() + "_" + pkId;
            IFormView childFormView = this.getView().getView(pageId);
            if (childFormView != null) {
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
                return;
            }
            this.openApproveBillPage(pkId);
        }
    }

    private void openApproveBillPage(Object pkId) {
        IFormView parentView1;
        HashMap<String, String> openParameter = new HashMap<String, String>(16);
        openParameter.put("formId", "eb_centralappbill");
        openParameter.put("pkId", pkId.toString());
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setShowTitle(true);
        String pageId = this.getView().getPageId() + "_" + pkId;
        formShowParameter.setPageId(pageId);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (parentView1 = parentView.getParentView()) != null) {
            formShowParameter.setParentPageId(parentView1.getPageId());
            parentView.showForm(formShowParameter);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void addHyperLinkedClickListeners() {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        EntryGrid entryGrid = null;
        for (String entityKey : templateInfo.keySet()) {
            entryGrid = (EntryGrid)this.getControl(entityKey);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void entryRowClick(RowClickEvent e) {
        super.entryRowClick(e);
        TreeEntryGrid treentity = (TreeEntryGrid)this.getView().getControl(PRE_ENTITY);
        int[] selectRows = treentity.getSelectRows();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PRE_ENTITY);
        DynamicObjectCollection queryAll = QueryServiceHelper.query((String)"eb_centralappadjrecord", (String)"approvedate,approvebillno,nodenumber", (QFilter[])new QFilter[]{new QFilter("approvebillno", "like", (Object)("%" + ((DynamicObject)entryentity.get(0)).getString("billno") + "%"))});
        HashMap<String, Object> chackrecords = new HashMap<String, Object>();
        if (selectRows.length == 0) {
            String string = ((DynamicObject)entryentity.get(0)).getString("approvedate");
            String enddate = new Date().toString();
            HashMap<String, String> chackrecord = null;
            try {
                chackrecord = this.chackrecordanddDate(this.convertToDesiredFormat(string), this.convertToDesiredFormat(enddate), queryAll);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            chackrecords.putAll(chackrecord);
        } else {
            for (int selectRow : selectRows) {
                if (!"\u2714".equals(((DynamicObject)entryentity.get(selectRow)).getString("approvaladjustmen"))) continue;
                if (((DynamicObject)entryentity.get(selectRow)).getLong("pid") == 0L && selectRow != 0) {
                    HashMap<String, String> chackrecord;
                    String stardate = null;
                    String enddate = null;
                    if (!"wait".equals(((DynamicObject)entryentity.get(selectRow)).getString("processstatus"))) {
                        stardate = ((DynamicObject)entryentity.get(selectRow - 1)).getString("approvedate");
                        enddate = ((DynamicObject)entryentity.get(selectRow)).getString("approvedate");
                        chackrecord = null;
                        try {
                            chackrecord = this.chackrecordanddDate(this.convertToDesiredFormat(stardate), this.convertToDesiredFormat(enddate), queryAll);
                        }
                        catch (ParseException ex) {
                            throw new RuntimeException(ex);
                        }
                        chackrecords.putAll(chackrecord);
                        continue;
                    }
                    if ("wait".equals(((DynamicObject)entryentity.get(selectRow - 1)).getString("processstatus"))) continue;
                    stardate = ((DynamicObject)entryentity.get(selectRow - 1)).getString("approvedate");
                    enddate = new Date().toString();
                    chackrecord = null;
                    try {
                        chackrecord = this.chackrecordanddDate(this.convertToDesiredFormat(stardate), this.convertToDesiredFormat(enddate), queryAll);
                    }
                    catch (ParseException ex) {
                        throw new RuntimeException(ex);
                    }
                    chackrecords.putAll(chackrecord);
                    continue;
                }
                String billno = ((DynamicObject)entryentity.get(selectRow)).getString("billno");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (DynamicObject dynamicObject : queryAll) {
                    String approvebillno = dynamicObject.getString("approvebillno");
                    if (!billno.equals(approvebillno)) continue;
                    String nodenumber = dynamicObject.getString("nodenumber");
                    String approvedate = dynamicObject.getString("approvedate");
                    hashMap.put(approvebillno + "_" + approvedate, nodenumber);
                }
                chackrecords.putAll(hashMap);
            }
        }
        Map<String, Long> map = this.getTemplateInfo();
        if (map.size() == 0) {
            return;
        }
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        for (String entityKey : map.keySet()) {
            String entityTab = entityKey.replace(PRE_ENTITY, PRE_TAB);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{entityTab});
            this.updataEntryEntityData2(entityKey, showColumnMap, chackrecords);
            EntryGrid entity = (EntryGrid)this.getView().getControl(entityKey);
            if (entity.getEntryData().getDataEntitys().length != 0) continue;
            this.getModel().deleteEntryData(entityKey);
        }
        this.hiddenColumns(showColumnMap, map);
    }

    private void hiddenColumns(Map<String, ShowColumn> showColumnMap, Map<String, Long> templateInfo) {
        for (String entityKey : templateInfo.keySet()) {
            HashMap map = new HashMap(16);
            EntryGrid entity = (EntryGrid)this.getView().getControl(entityKey);
            DynamicObject[] dataEntitys = entity.getEntryData().getDataEntitys();
            if (dataEntitys.length <= 0) continue;
            ShowColumn showColumn = showColumnMap.get(entityKey);
            List<BaseColumn> baseColumns = showColumn.getMeasureCols();
            baseColumns.addAll(showColumn.getOtherCols());
            for (BaseColumn baseColumn : baseColumns) {
                HashSet<Boolean> isNull = new HashSet<Boolean>(templateInfo.size());
                String columnKey = baseColumn.getKey();
                this.getView().setVisible(Boolean.valueOf(true), new String[]{columnKey});
                for (DynamicObject dataEntity : dataEntitys) {
                    Object value = dataEntity.get(columnKey);
                    if ("".equals(value) || value == null) {
                        isNull.add(true);
                        continue;
                    }
                    isNull.add(false);
                }
                map.put(columnKey, isNull);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((HashSet)entry.getValue()).contains(false)) continue;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{(String)entry.getKey()});
            }
        }
    }

    public boolean isTimeInRange(String startTimeStr, String endTimeStr, String targetTimeStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = LocalDateTime.parse(startTimeStr, formatter);
        LocalDateTime endTime = LocalDateTime.parse(endTimeStr, formatter);
        LocalDateTime targetTime = LocalDateTime.parse(targetTimeStr.split("\\.")[0], formatter);
        return targetTime.isAfter(startTime) && !targetTime.isAfter(endTime);
    }

    private void updataEntryEntityData2(String entityKey, Map<String, ShowColumn> showColumnMap, HashMap<String, Object> map) {
        this.getModel().deleteEntryData(entityKey);
        List<AppAdjustRecord> records = this.getRecords(entityKey);
        if (records == null || records.size() == 0) {
            return;
        }
        int entityIndex = Integer.parseInt(entityKey.replace(PRE_ENTITY, ""));
        ShowColumn showColumn = showColumnMap.get(entityKey);
        for (AppAdjustRecord record : records) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String billnodate = entry.getKey();
                Object value = entry.getValue();
                String[] split = billnodate.split("_");
                if (!split[0].equals(record.getApproveBill()) || !split[1].equals(record.getApproveTime().toString()) || !value.equals(record.getNodeNumber())) continue;
                int rowIndex = this.getModel().createNewEntryRow(entityKey);
                Map dimMemberMap = record.getDimMemberMap();
                this.fillDimData(dimMemberMap, showColumn.getRowDims(), rowIndex, record.getModel());
                List colDataInfos = record.getColDataInfos();
                this.fillMeasureAndOtherData(colDataInfos, rowIndex);
                this.fillFixColData(record, rowIndex, entityIndex);
                this.cacheAdjustRecordBillNumIndexMap(record.getApproveBill(), rowIndex);
            }
        }
        this.getView().updateView(PRE_ENTITY + entityIndex);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        RecordSearchEntry recordSearchEntry = this.getRecordSearchEntry(formShowParameter);
        AdjustShowTypeEnum showType = recordSearchEntry.getType();
        if (showType == null) {
            return;
        }
        List<String> billnos = this.QuerySubBillNo(recordSearchEntry.getBillNo());
        List appAdjustRecords = ApproveRecordUtil.getInstance().getAppAdjustRecordNew(recordSearchEntry, billnos);
        Map<Long, List<AppAdjustRecord>> groupRecords = this.getGroupRecords(appAdjustRecords);
        ArrayList<Long> templates = new ArrayList<Long>(16);
        HashMap<Long, String> templateInfo = new HashMap<Long, String>(16);
        this.preInitTemplateInfo(templates, templateInfo);
        Map<Long, ShowColumn> showColumnsMap = this.getShowColumnMapByTemplate(templates, groupRecords, recordSearchEntry, formShowParameter);
        switch (showType) {
            case Adjust: {
                this.initRejectEntryEntities(showColumnsMap, templates, e);
            }
            case ApproveAdjust: {
                this.initAdjustEntryEntities(showColumnsMap, templates, templateInfo, groupRecords, e);
                break;
            }
        }
    }

    private List<String> QuerySubBillNo(String billno) {
        DynamicObjectCollection ebCentralAppBills;
        ArrayList<String> billnos = new ArrayList<String>(16);
        billnos.add(billno);
        DynamicObject ebCentralAppBillId = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"parentid,id,billno,ishassubitems,splitnode,centralorg", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (ebCentralAppBillId != null && ebCentralAppBillId.getBoolean("ishassubitems") && (ebCentralAppBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"parentid,id,billno,ishassubitems,splitnode,centralorg", (QFilter[])new QFilter[]{new QFilter("parentid", "=", ebCentralAppBillId.get("id"))})) != null && ebCentralAppBills.size() > 0) {
            for (DynamicObject ebCentralAppBill : ebCentralAppBills) {
                billnos.add(ebCentralAppBill.getString("billno"));
            }
        }
        return billnos;
    }

    private void updateShowColumnCache(FormShowParameter formShowParameter, String entityKey, ShowColumn showColumn) {
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(formShowParameter);
        if (showColumnMap == null) {
            showColumnMap = new HashMap<String, ShowColumn>(16);
        }
        showColumnMap.put(entityKey, showColumn);
        formShowParameter.setCustomParam("showColumnMap", (Object)SerializationUtils.serializeToBase64(showColumnMap));
    }

    private Map<String, ShowColumn> getShowColumnMap(FormShowParameter formShowParameter) {
        if (this.showColumnsMap == null) {
            if (formShowParameter == null) {
                formShowParameter = this.getView().getFormShowParameter();
            }
            String showColumnJson = (String)formShowParameter.getCustomParam("showColumnMap");
            if (showColumnMap_copy == null) {
                showColumnMap_copy = showColumnJson;
            }
            if (StringUtils.isNotEmpty((String)showColumnJson)) {
                this.showColumnsMap = (Map)SerializationUtils.deSerializeFromBase64((String)showColumnJson);
            }
        }
        return this.showColumnsMap;
    }

    private void preInitTemplateInfo(List<Long> templates, Map<Long, String> templateInfo) {
        Long model = this.recordSearchEntry.getModel();
        List<String> billnos = this.QuerySubBillNo(this.recordSearchEntry.getBillNo());
        Long template = this.recordSearchEntry.getTemplate();
        if (template == 0L) {
            QFilter qFilter = new QFilter("model", "=", (Object)model);
            qFilter.and(new QFilter("approvebillno", "in", billnos));
            DynamicObjectCollection records = QueryServiceHelper.query((String)"eb_centralappadjrecord", (String)"template.id, template.name", (QFilter[])new QFilter[]{qFilter});
            if (records.size() == 0) {
                DynamicObjectCollection centralTemplateObj = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,parentid,ishassubitems,centralapprptentity.template.id,centralapprptentity.template.name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)this.recordSearchEntry.getBillNo()).and(new QFilter("model", "=", (Object)model))});
                if (centralTemplateObj.size() == 0) {
                    return;
                }
                if (((DynamicObject)centralTemplateObj.get(0)).getLong("parentid") == 0L) {
                    centralTemplateObj.forEach(e -> {
                        Long templateId = e.getLong("centralapprptentity.template.id");
                        if (!templates.contains(templateId)) {
                            templates.add(templateId);
                        }
                        templateInfo.put(templateId, e.getString("centralapprptentity.template.name"));
                    });
                    if (((DynamicObject)centralTemplateObj.get(0)).getBoolean("ishassubitems")) {
                        List approveBills = ApproveBillUtil.getInstance().getApproveBills(new QFilter("parentid", "=", ((DynamicObject)centralTemplateObj.get(0)).get("id")));
                        HashSet<Long> tmplateIds = new HashSet<Long>(16);
                        for (ApproveBill approveBill : approveBills) {
                            for (ApproveBillConfig approveBillConfig : approveBill.getApproveconfig()) {
                                tmplateIds.add(approveBillConfig.getTemplateId());
                            }
                        }
                        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", tmplateIds)});
                        query.forEach(e -> {
                            Long templateId = e.getLong("id");
                            if (!templates.contains(templateId)) {
                                templates.add(templateId);
                            }
                            templateInfo.put(templateId, e.getString("name"));
                        });
                    }
                } else {
                    List approveBills = ApproveBillUtil.getInstance().getApproveBills(new QFilter("id", "=", ((DynamicObject)centralTemplateObj.get(0)).get("id")));
                    HashSet<Long> tmplateIds = new HashSet<Long>(16);
                    for (ApproveBill approveBill : approveBills) {
                        for (ApproveBillConfig approveBillConfig : approveBill.getApproveconfig()) {
                            tmplateIds.add(approveBillConfig.getTemplateId());
                        }
                    }
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", tmplateIds)});
                    query.forEach(e -> {
                        Long templateId = e.getLong("id");
                        if (!templates.contains(templateId)) {
                            templates.add(templateId);
                        }
                        templateInfo.put(templateId, e.getString("name"));
                    });
                }
            } else {
                records.forEach(e -> {
                    Long templateId = e.getLong("template.id");
                    if (!templates.contains(templateId)) {
                        templates.add(templateId);
                    }
                    templateInfo.put(templateId, e.getString("template.name"));
                });
            }
        } else {
            DynamicObject one = QueryServiceHelper.queryOne((String)"eb_applytemplate", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)template)});
            if (one == null) {
                return;
            }
            templates.add(template);
            templateInfo.put(template, one.getString("name"));
        }
    }

    private void initRejectEntryEntities(Map<Long, ShowColumn> showColumnsMap, List<Long> templates, LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        for (Long templateId : templates) {
            String entityKey = REJECT_ENTITY;
            ShowColumn showColumns = showColumnsMap.get(templateId);
            EntryAp entryAp = this.createEntryAp(formShowParameter, entityKey, showColumns, true, true);
            HashMap<String, String> mapEntry = new HashMap<String, String>(1);
            mapEntry.put("id", entityKey);
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            args.getItems().add(mapEntry);
        }
    }

    private void initAdjustEntryEntities(Map<Long, ShowColumn> showColumnsMap, List<Long> templates, Map<Long, String> templateInfo, Map<Long, List<AppAdjustRecord>> groupRecords, LoadCustomControlMetasArgs args) {
        HashMap<String, Long> templateEntityMap = new HashMap<String, Long>(16);
        HashMap<String, List<AppAdjustRecord>> records = new HashMap<String, List<AppAdjustRecord>>(16);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        for (Long templateId : templates) {
            int index = templates.indexOf(templateId) + 1;
            String entityKey = PRE_ENTITY + index;
            ShowColumn showColumns = showColumnsMap.get(templateId);
            EntryAp entryAp = this.createEntryAp(formShowParameter, entityKey, showColumns, false, true);
            HashMap<String, String> mapEntry = new HashMap<String, String>(1);
            mapEntry.put("id", entityKey);
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            args.getItems().add(mapEntry);
            HashMap<String, String> props = new HashMap<String, String>(1);
            props.put("id", entityKey.replace(PRE_ENTITY, PRE_TAB));
            props.put("text", (String)new LocaleString(templateInfo.get(templateId)));
            args.getItems().add(props);
            templateEntityMap.put(entityKey, templateId);
            records.put(entityKey, groupRecords.get(templateId));
        }
        this.cacheRecordMap(formShowParameter, records);
        this.cacheTemplateMap(formShowParameter, templateEntityMap);
    }

    private void cacheRecordMap(FormShowParameter formShowParameter, Map<String, List<AppAdjustRecord>> records) {
        String templateInfo = SerializationUtils.serializeToBase64(records);
        formShowParameter.setCustomParam("adjustRecordMap", (Object)templateInfo);
        this.adjustRecordMap.putAll(records);
    }

    private void cacheTemplateMap(FormShowParameter formShowParameter, Map<String, Long> templateEntityMap) {
        String templateInfo = SerializationUtils.serializeToBase64(templateEntityMap);
        formShowParameter.setCustomParam("templateInfo", (Object)templateInfo);
        this.templateEntityMap.putAll(templateEntityMap);
    }

    private Map<String, Long> getTemplateInfo() {
        if (this.templateEntityMap.size() == 0) {
            String templateInfo = (String)this.getView().getFormShowParameter().getCustomParam("templateInfo");
            this.templateEntityMap.putAll((Map)SerializationUtils.deSerializeFromBase64((String)templateInfo));
        }
        return this.templateEntityMap;
    }

    private Map<Long, ShowColumn> getShowColumnMapByTemplate(List<Long> templateIds, Map<Long, List<AppAdjustRecord>> groupRecords, RecordSearchEntry recordSearchEntry, FormShowParameter formShowParameter) {
        HashMap<Long, ShowColumn> showColumnsMap = new HashMap<Long, ShowColumn>(16);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id, dataset,number, entrycfgjson_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)});
        if (templates == null || templates.size() == 0) {
            return showColumnsMap;
        }
        Map<String, Map<String, String>> varInfo = this.getVarInfoByScheme(recordSearchEntry);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)recordSearchEntry.getModel());
        HashMap templateBhMapKeys = new HashMap(16);
        templates.forEach(e -> {
            Long datasetId = e.getLong("dataset");
            ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)e);
            ApplyTemplateUtils.changeVarOnColumn((ColumnList)columnList, (Long)datasetId, (IModelCacheHelper)modelCacheHelper, (Map)varInfo);
            Collection columns = columnList.getColumns();
            ShowColumn showColumns = new ShowColumn();
            Long templateId = e.getLong("id");
            showColumns.setTemplateId(templateId);
            List appAdjustRecords = (List)groupRecords.get(templateId);
            HashSet keys = new HashSet(16);
            if (appAdjustRecords != null) {
                appAdjustRecords.forEach(h -> {
                    String mkey = h.getTemplate() + "!" + h.getRejectBillNo();
                    Set keyss = templateBhMapKeys.computeIfAbsent(mkey, s -> new HashSet(16));
                    h.getColDataInfos().forEach(k -> {
                        keys.add(k.getKey());
                        keyss.add(k.getKey());
                    });
                });
            }
            columns.stream().filter(h -> h.getKey().startsWith("h")).forEach(h -> {
                String key = h.getKey();
                if (h instanceof DimensionColumn || h instanceof RelationDimensionColumn || h instanceof RowDimensionColumn) {
                    showColumns.getRowDims().add((BaseColumn)h);
                } else if (keys.contains(key)) {
                    if (h instanceof MeasureColumn || h instanceof DimensionDataColumn && h.getFieldtype() == FieldTypeEnum.NumberField) {
                        showColumns.getMeasureCols().add((BaseColumn)h);
                    } else {
                        this.typeChange((BaseColumn)h);
                        showColumns.getOtherCols().add((BaseColumn)h);
                    }
                }
            });
            showColumnsMap.put(templateId, showColumns);
        });
        formShowParameter.getCustomParams().put("templateMapkeys", SerializationUtils.toJsonString(templateBhMapKeys));
        return showColumnsMap;
    }

    private Map<String, Map<String, String>> getVarInfoByScheme(RecordSearchEntry recordSearchEntry) {
        if (recordSearchEntry == null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            recordSearchEntry = this.getRecordSearchEntry(formShowParameter);
        }
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(recordSearchEntry.getModel(), recordSearchEntry.getReportSchemeId(), recordSearchEntry.getYearId(), recordSearchEntry.getVersionId(), recordSearchEntry.getDataTypeId());
        return ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
    }

    private void typeChange(BaseColumn column) {
        FieldTypeEnum fieldType = column.getFieldtype();
        if (FieldTypeEnum.NumberField == fieldType) {
            column.setFieldtype(FieldTypeEnum.TextField);
        }
    }

    private EntryAp createEntryAp(FormShowParameter formShowParameter, String entityKey, ShowColumn showColumns, Boolean isReject, Boolean isFirst) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entityKey);
        entryAp.setPageRow(10000);
        if (isReject.booleanValue()) {
            ArrayList<BaseColumn> rowDims = new ArrayList(16);
            ArrayList<BaseColumn> measureColumns = new ArrayList(16);
            ArrayList<BaseColumn> otherColumns = new ArrayList(16);
            ArrayList<BaseColumn> fixColumns = new ArrayList(16);
            int index = 0;
            if (isFirst.booleanValue()) {
                ShowColumn showColumn = new ShowColumn();
                showColumn.setTemplateId(showColumns.getTemplateId());
                rowDims = this.copyCols(showColumns.getRowDims());
                showColumn.setRowDims(rowDims);
                for (BaseColumn baseColumn : showColumns.getMeasureCols()) {
                    String category;
                    int sort;
                    ColumnEnum type;
                    FieldTypeEnum fieldtype;
                    String key;
                    MeasureColumn measureColumnReject;
                    MeasureColumn measureColumnPre;
                    MeasureColumn measureColumn;
                    if (baseColumn instanceof MeasureColumn) {
                        measureColumn = (MeasureColumn)baseColumn;
                        measureColumnPre = new MeasureColumn();
                        measureColumnReject = new MeasureColumn();
                        key = baseColumn.getKey();
                        fieldtype = baseColumn.getFieldtype();
                        type = baseColumn.getType();
                        sort = baseColumn.getSort();
                        category = baseColumn.getCategory();
                        measureColumnPre.setKey(key + "_pre_rej");
                        measureColumnPre.setTitle(ResManager.loadResFormat((String)"%1(\u9a73\u56de)", (String)"ApproveRecordListFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{baseColumn.getTitle()}));
                        measureColumnPre.setDataMapDimensions(measureColumn.getDataMapDimensions());
                        measureColumnPre.setType(type);
                        measureColumnPre.setFieldtype(fieldtype);
                        measureColumnPre.setSort(sort);
                        measureColumnPre.setCategory(category);
                        measureColumnReject.setKey(key + "_rej");
                        measureColumnReject.setTitle(ResManager.loadResFormat((String)"%1(\u8c03\u6574)", (String)"ApproveRecordListFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{baseColumn.getTitle()}));
                        measureColumnReject.setDataMapDimensions(measureColumn.getDataMapDimensions());
                        measureColumnReject.setType(type);
                        measureColumnReject.setFieldtype(fieldtype);
                        measureColumnReject.setSort(sort);
                        measureColumnReject.setCategory(category);
                        measureColumns.add((BaseColumn)measureColumnReject);
                        measureColumns.add((BaseColumn)measureColumnPre);
                        continue;
                    }
                    if (!(baseColumn instanceof DimensionDataColumn)) continue;
                    measureColumn = (DimensionDataColumn)baseColumn;
                    measureColumnPre = new DimensionDataColumn();
                    measureColumnReject = new DimensionDataColumn();
                    key = baseColumn.getKey();
                    fieldtype = baseColumn.getFieldtype();
                    type = baseColumn.getType();
                    sort = baseColumn.getSort();
                    category = baseColumn.getCategory();
                    measureColumnPre.setKey(key + "_pre_rej");
                    measureColumnPre.setTitle(ResManager.loadResFormat((String)"%1(\u9a73\u56de)", (String)"ApproveRecordListFormPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{baseColumn.getTitle()}));
                    measureColumnPre.setDataMapDimensions(measureColumn.getDataMapDimensions());
                    measureColumnPre.setType(type);
                    measureColumnPre.setFieldtype(fieldtype);
                    measureColumnPre.setSort(sort);
                    measureColumnPre.setCategory(category);
                    measureColumnReject.setKey(key + "_rej");
                    measureColumnReject.setTitle(ResManager.loadResFormat((String)"%1(\u8c03\u6574)", (String)"ApproveRecordListFormPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{baseColumn.getTitle()}));
                    measureColumnReject.setDataMapDimensions(measureColumn.getDataMapDimensions());
                    measureColumnReject.setType(type);
                    measureColumnReject.setFieldtype(fieldtype);
                    measureColumnReject.setSort(sort);
                    measureColumnReject.setCategory(category);
                    measureColumns.add((BaseColumn)measureColumnReject);
                    measureColumns.add((BaseColumn)measureColumnPre);
                }
                showColumn.setMeasureCols(measureColumns);
                List<BaseColumn> otherCols = showColumns.getOtherCols();
                for (BaseColumn otherCol : otherCols) {
                    BaseColumn baseColumn = new BaseColumn();
                    baseColumn.setKey(otherCol.getKey() + "_rej");
                    baseColumn.setTitle(otherCol.getTitle());
                    baseColumn.setType(otherCol.getType());
                    baseColumn.setFieldtype(otherCol.getFieldtype());
                    baseColumn.setSort(otherCol.getSort());
                    baseColumn.setCategory(otherCol.getCategory());
                    otherColumns.add(baseColumn);
                }
                showColumn.setOtherCols(otherColumns);
                fixColumns = this.getFixFieldCols(AdjustRecordConstant.REJECT_FIX_FIELD_KEYS, AdjustRecordConstant.REJECT_FIX_FIELD_NAMES, index);
                showColumn.setFixCols(fixColumns);
                this.updateShowColumnCache(formShowParameter, entityKey, showColumn);
            } else {
                rowDims = showColumns.getRowDims();
                measureColumns = showColumns.getMeasureCols();
                otherColumns = showColumns.getOtherCols();
                fixColumns = showColumns.getFixCols();
            }
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, rowDims, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, measureColumns, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, otherColumns, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, fixColumns, (boolean)true, null);
        } else {
            List<BaseColumn> preCols = null;
            List<BaseColumn> nodeNameCols = null;
            List<BaseColumn> rowDims = showColumns.getRowDims();
            List<BaseColumn> measureCols = showColumns.getMeasureCols();
            List<BaseColumn> planFixCols = null;
            List<BaseColumn> adjustFixCols = null;
            int index = Integer.parseInt(entityKey.replace(PRE_ENTITY, ""));
            if (isFirst.booleanValue()) {
                preCols = this.getFixFieldCols(AdjustRecordConstant.PRE_FILED_KEYS, AdjustRecordConstant.PRE_FILED_NAMES, index);
                showColumns.setPreCols(preCols);
                nodeNameCols = this.getFixFieldCols(AdjustRecordConstant.APPROVE_NODE_NAME_KEYS, AdjustRecordConstant.APPROVE_NODE_NAMEs, index);
                showColumns.setNodeNameCols(nodeNameCols);
                planFixCols = this.getFixFieldCols(AdjustRecordConstant.APPROVE_PLAN_FILED_KEYS, AdjustRecordConstant.APPROVE_PLAN_FILED_NAMES, index);
                showColumns.setPlanFixCols(planFixCols);
                measureCols = this.addAfterCols(measureCols);
                showColumns.setMeasureCols(measureCols);
                adjustFixCols = this.getFixFieldCols(AdjustRecordConstant.ADJUST_FIX_FIELD_KEYS, AdjustRecordConstant.ADJUST_FIX_FIELD_NAMES, index);
                showColumns.setFixCols(adjustFixCols);
                this.updateShowColumnCache(formShowParameter, entityKey, showColumns);
            } else {
                planFixCols = showColumns.getPlanFixCols();
                adjustFixCols = showColumns.getFixCols();
                preCols = showColumns.getPreCols();
                nodeNameCols = showColumns.getNodeNameCols();
            }
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, preCols, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, rowDims, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, nodeNameCols, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, planFixCols, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, measureCols, (boolean)true, null);
            List<BaseColumn> list = showColumns.getOtherCols();
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, list, (boolean)true, null);
            ApplyTemplateUtils.addFieldAps((EntryAp)entryAp, null, adjustFixCols, (boolean)true, null);
        }
        entryAp.setShowSeq(true);
        return entryAp;
    }

    private List<BaseColumn> copyCols(List<BaseColumn> rowDims) {
        ArrayList<BaseColumn> cols = new ArrayList<BaseColumn>(16);
        for (BaseColumn rowDim : rowDims) {
            DimensionColumn column = new DimensionColumn();
            column.setKey(rowDim.getKey() + "_rej");
            column.setTitle(rowDim.getTitle());
            column.setIsmustinput(false);
            column.setFieldtype(rowDim.getFieldtype());
            column.setBaseEntityId(rowDim.getBaseEntityId());
            cols.add((BaseColumn)column);
        }
        return cols;
    }

    private List<BaseColumn> getFixFieldCols(List<String> fieldKeys, List<String> fieldNames, int index) {
        ArrayList<BaseColumn> columns = new ArrayList<BaseColumn>(16);
        for (int i = 0; i < fieldKeys.size(); ++i) {
            String fieldKey = fieldKeys.get(i);
            String fieldName = fieldNames.get(i);
            BaseColumn column = null;
            String fieldKey_real = fieldKey + index;
            if (index == 0) {
                fieldKey_real = fieldKey;
            }
            if (AdjustRecordConstant.BASE_FIELD_KEYS.contains(fieldKey)) {
                column = new BaseColumn(fieldName, fieldKey_real, FieldTypeEnum.BaseDataField, null);
                column.setIsmustinput(false);
                column.setBaseEntityId((String)AdjustRecordConstant.BASE_ENTITY_ID.get(AdjustRecordConstant.BASE_FIELD_KEYS.indexOf(fieldKey)));
            } else if (AdjustRecordConstant.DATE_FIELD_KEYS.contains(fieldKey)) {
                column = new BaseColumn(fieldName, fieldKey_real, FieldTypeEnum.DateTime, null);
            } else if (AdjustRecordConstant.TEXT_FIELD_KEYS.contains(fieldKey)) {
                column = new TextColumn();
                column.setTitle(fieldName);
                column.setKey(fieldKey_real);
                if ("btn_showreject".equals(fieldKey)) {
                    ((TextColumn)column).setHyperLink(true);
                }
            } else if (AdjustRecordConstant.NUMBER_FIELD_KEYS.contains(fieldKey)) {
                column = new NumberColumn();
                column.setTitle(fieldName);
                column.setKey(fieldKey_real);
            }
            if (column == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u9884\u7f6e\u5217%1\u672a\u80fd\u83b7\u53d6\u5230\u5217\u7c7b\u578b\u3002", (String)"ApproveRecordListFormPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{fieldName}));
            }
            columns.add(column);
        }
        return columns;
    }

    private List<BaseColumn> addAfterCols(List<BaseColumn> measureCols) {
        ArrayList<BaseColumn> measureCols_new = new ArrayList<BaseColumn>(16);
        for (BaseColumn measureCol : measureCols) {
            MeasureColumn column;
            List enumData;
            MeasureColumn measureColumn;
            String key = measureCol.getKey();
            String title = measureCol.getTitle();
            FieldTypeEnum fieldType = FieldTypeEnum.NumberField == measureCol.getFieldtype() ? FieldTypeEnum.TextField : measureCol.getFieldtype();
            measureCol.setFieldtype(fieldType);
            measureCol.setKey(key + "_pre");
            measureCol.setTitle(ResManager.loadResFormat((String)"%1(\u8c03\u6574\u524d)", (String)"ApproveRecordListFormPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{title}));
            measureCols_new.add(measureCol);
            if (measureCol instanceof MeasureColumn) {
                measureColumn = (MeasureColumn)measureCol;
                enumData = measureColumn.getEnumdata();
                column = new MeasureColumn();
                column.setKey(key + "_after");
                column.setTitle(ResManager.loadResFormat((String)"%1(\u8c03\u6574\u540e)", (String)"ApproveRecordListFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{title}));
                column.setIsmustinput(false);
                column.setFieldtype(fieldType);
                column.setEnumdata(enumData);
                measureCols_new.add((BaseColumn)column);
                continue;
            }
            if (!(measureCol instanceof DimensionDataColumn)) continue;
            measureColumn = (DimensionDataColumn)measureCol;
            enumData = measureColumn.getEnumdata();
            column = new DimensionDataColumn();
            column.setKey(key + "_after");
            column.setTitle(ResManager.loadResFormat((String)"%1(\u8c03\u6574\u540e)", (String)"ApproveRecordListFormPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{title}));
            column.setIsmustinput(false);
            column.setFieldtype(fieldType);
            column.setEnumdata(enumData);
            measureCols_new.add((BaseColumn)column);
        }
        return measureCols_new;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initVisible();
        this.initEnable();
        this.initData();
    }

    private void initEnable() {
        ArrayList<String> enables = new ArrayList<String>(16);
        for (int i = 1; i <= 10; ++i) {
            enables.add(PRE_ENTITY + i);
        }
        enables.add(REJECT_ENTITY);
        this.getView().setEnable(Boolean.valueOf(false), enables.toArray(new String[0]));
    }

    private void initVisible() {
        ArrayList<String> hideKeys = new ArrayList<String>(16);
        if (!this.isShowAdjust().booleanValue()) {
            hideKeys.addAll(this.getAllShowRejectKeys());
        }
        hideKeys.add("rejectpanel");
        hideKeys.addAll(this.getHideTabKeys());
        this.getView().setVisible(Boolean.valueOf(false), hideKeys.toArray(new String[0]));
    }

    private void updateRejectVisible() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"rejectpanel"});
    }

    private Set<String> getAllShowRejectKeys() {
        HashSet<String> showRejectKeys = new HashSet<String>(16);
        for (int i = 1; i <= 10; ++i) {
            showRejectKeys.add("btn_showreject" + i);
        }
        return showRejectKeys;
    }

    private String getCurTab() {
        Tab tab = (Tab)this.getControl(TAB_AP);
        return tab.getCurrentTab();
    }

    private Set<String> getHideTabKeys() {
        HashSet<String> entityKeys = new HashSet<String>(16);
        for (int i = 1; i <= 10; ++i) {
            entityKeys.add(PRE_ENTITY + i);
        }
        HashSet<String> tabKeys = new HashSet<String>(16);
        Map<String, Long> templateInfo = this.getTemplateInfo();
        if (templateInfo.size() != 0) {
            entityKeys.removeAll(templateInfo.keySet());
            tabKeys.addAll(entityKeys.stream().map(e -> e.replace(PRE_ENTITY, PRE_TAB)).collect(Collectors.toSet()));
        } else {
            tabKeys.add("flexpanelap2");
        }
        return tabKeys;
    }

    private void initData() {
        this.initRecordData();
        this.initAdjustRecordData();
    }

    private void initRecordData() {
        if (this.isShowAdjust().booleanValue()) {
            return;
        }
        RecordSearchEntry recordSearchEntry = this.getRecordSearchEntry(this.getView().getFormShowParameter());
        this.ApprovalRecords(recordSearchEntry);
    }

    private void ApprovalRecords(RecordSearchEntry recordSearchEntry) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"approver", "org", "status", "processstatus"});
        String billNo = recordSearchEntry.getBillNo();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"billstatus,id,centralorg.name,parentid,ismainbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        List approvalRecords = WorkFlowUtil.getApprovalRecords((String)"eb_centralappbill", (String)dynamicObject.getString("id"), (boolean)true);
        List nextApprovalUserIds = WorkflowServiceHelper.getNextUserTaskNodeByBusinessKey((String)dynamicObject.getString("id"));
        DynamicObjectCollection record = null;
        DynamicObjectCollection queryAll = null;
        if ("true".equals(dynamicObject.getString("ismainbill"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"splitcentral"});
            queryAll = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billstatus,centralorg.name,billno,createdate,splitnode", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)dynamicObject.getLong("id"))});
            record = QueryServiceHelper.query((String)"eb_centralappadjrecord", (String)"approvedate,approvebillno,nodenumber", (QFilter[])new QFilter[]{new QFilter("approvebillno", "like", (Object)("%" + billNo + "%"))});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcentral"});
            record = QueryServiceHelper.query((String)"eb_centralappadjrecord", (String)"approvedate,approvebillno,nodenumber", (QFilter[])new QFilter[]{new QFilter("approvebillno", "like", (Object)("%" + billNo + "%"))});
        }
        if (approvalRecords == null || approvalRecords.isEmpty()) {
            return;
        }
        for (int i = 0; i < approvalRecords.size(); ++i) {
            DynamicObjectCollection chackrecord;
            ArrayList<String> starallTimes;
            List upchildrentime;
            IApprovalRecordGroup iApprovalRecordGroup;
            String endTime;
            String starTime;
            Map map;
            List childrentime;
            IApprovalRecordGroup recordGroup = (IApprovalRecordGroup)approvalRecords.get(i);
            int index = this.getModel().createNewEntryRow(PRE_ENTITY);
            if (recordGroup == null || (childrentime = recordGroup.getChildren()).isEmpty()) continue;
            ArrayList<String> allTimes = new ArrayList<String>();
            for (IApprovalRecordItem child : childrentime) {
                allTimes.add(child.getTime());
            }
            IApprovalRecordItem iApprovalRecordItem = (IApprovalRecordItem)recordGroup.getChildren().get(0);
            this.getModel().setValue("order", (Object)(StringUtils.isEmpty((String)recordGroup.getActivityName()) ? iApprovalRecordItem.getActivityName() : recordGroup.getActivityName()), index);
            this.getModel().setValue("status", (Object)dynamicObject.getString("billstatus"), index);
            this.getModel().setValue("processstatus", (Object)recordGroup.getGroupDecisionType(), index);
            this.getModel().setValue("approvalstatus", (Object)((IApprovalRecordItem)childrentime.get(childrentime.size() - 1)).getResult(), index);
            this.getModel().setValue("approvedate", (Object)this.findMaxTime(allTimes), index);
            this.getModel().setValue("id", (Object)((long)index + 123L), index);
            this.getModel().setValue("billno", (Object)billNo, index);
            this.getModel().setValue("orderno", (Object)iApprovalRecordItem.getActivityId(), index);
            this.getModel().setValue("pid", (Object)0L, index);
            int m = approvalRecords.size() - 1;
            if (nextApprovalUserIds != null && nextApprovalUserIds.size() > 0 && m == index && (map = (Map)nextApprovalUserIds.get(0)) != null && map.size() > 0) {
                this.getModel().setValue("nextapprovers", map.get("users"), index);
            }
            ArrayList<Long> allIdsp = new ArrayList<Long>();
            String allMessagesp = "";
            StringBuilder allMessagespV = new StringBuilder();
            if (recordGroup.getChildren().size() > 0) {
                for (IApprovalRecordItem child : recordGroup.getChildren()) {
                    allIdsp.add(child.getUserId());
                    if (child.getMessage() == null) continue;
                    if (recordGroup.getChildren().size() == 1) {
                        allMessagespV.append(child.getMessage()).append(";");
                        continue;
                    }
                    if (recordGroup.getChildren().size() <= 1) continue;
                    allMessagespV.append(this.getUserName(child.getUserId())).append("-").append(child.getMessage()).append("\uff1b");
                }
                ArrayList userMainOrgIds = new ArrayList();
                List userMainOrgId = UserServiceHelper.getUserMainOrgId(allIdsp);
                for (Map longLongMap : userMainOrgId) {
                    userMainOrgIds.addAll(longLongMap.values());
                }
                if (StringUtils.isNotEmpty((String)allMessagespV.toString())) {
                    allMessagesp = allMessagespV.substring(0, allMessagespV.length() - 1);
                }
                if (allIdsp.size() != 0 && userMainOrgIds.size() != 0) {
                    this.getModel().setValue("approvers", (Object)allIdsp.toArray(), index);
                    this.getModel().setValue("orgs", (Object)userMainOrgIds.toArray(), index);
                    this.getModel().setValue("suggestion", (Object)allMessagesp, index);
                }
            }
            if (((IApprovalRecordItem)recordGroup.getChildren().get(0)).getActivityId().contains("CallActivity") || ((IApprovalRecordItem)recordGroup.getChildren().get(0)).getActivityId().contains("YunzhijiaTask")) {
                Object child2;
                starTime = null;
                endTime = null;
                iApprovalRecordGroup = (IApprovalRecordGroup)approvalRecords.get(i - 1);
                upchildrentime = iApprovalRecordGroup.getChildren();
                starallTimes = new ArrayList<String>();
                for (Object child2 : upchildrentime) {
                    starallTimes.add(child2.getTime());
                }
                if ("wait".equals(recordGroup.getGroupDecisionType())) {
                    endTime = this.formattednewDate();
                    starTime = ((IApprovalRecordItem)iApprovalRecordGroup.getChildren().get(0)).getActivityId().contains("CallActivity") ? (!"wait".equals(iApprovalRecordGroup.getGroupDecisionType()) ? this.findMinTime(starallTimes) : this.formattednewDate()) : this.findMinTime(starallTimes);
                    chackrecord = this.chackrecord(starTime, endTime, record);
                    if (chackrecord.size() != 0) {
                        this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                    }
                } else {
                    starTime = this.findMinTime(starallTimes);
                    chackrecord = this.chackrecord(starTime, endTime = this.findMaxTime(allTimes), record);
                    if (chackrecord.size() != 0) {
                        this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                    }
                }
                if (!((IApprovalRecordItem)recordGroup.getChildren().get(0)).getActivityId().contains("CallActivity")) continue;
                this.getModel().setValue("splitcentral", (Object)"\u2714", index);
                starTime = this.findMinTime(starallTimes);
                endTime = this.findMinTime(allTimes);
                if (queryAll == null) continue;
                DynamicObjectCollection chackApproval = this.chackApproval(ApproveRecordListFormPlugin.addMinutesToTime(starTime, 1L), endTime, queryAll);
                child2 = chackApproval.iterator();
                while (child2.hasNext()) {
                    Map map2;
                    DynamicObject pid = (DynamicObject)child2.next();
                    if (!((IApprovalRecordItem)recordGroup.getChildren().get(0)).getActivityId().contains(pid.getString("splitnode"))) continue;
                    List childNextApprovalUserIds = WorkflowServiceHelper.getNextUserTaskNodeByBusinessKey((String)pid.getString("id"));
                    List allApprovalRecord = WorkflowServiceHelper.getAllApprovalRecord((String)pid.getString("id"));
                    if (allApprovalRecord.isEmpty()) continue;
                    int intexs = this.getModel().insertEntryRow(PRE_ENTITY, index);
                    IApprovalRecordGroup iApprovalRecordGroups = (IApprovalRecordGroup)allApprovalRecord.get(allApprovalRecord.size() - 1);
                    List iApprovalRecordItemList = iApprovalRecordGroups.getChildren();
                    IApprovalRecordItem iApprovalRecordItemes = (IApprovalRecordItem)iApprovalRecordItemList.get(0);
                    this.getModel().setValue("order", (Object)iApprovalRecordItemes.getActivityName(), intexs);
                    this.getModel().setValue("status", (Object)pid.getString("billstatus"), intexs);
                    this.getModel().setValue("processstatus", (Object)iApprovalRecordGroups.getGroupDecisionType(), intexs);
                    this.getModel().setValue("approvalstatus", (Object)this.getBillStatus(pid.getString("billstatus")), intexs);
                    ArrayList<String> iTime = new ArrayList<String>();
                    for (IApprovalRecordItem child3 : iApprovalRecordItemList) {
                        iTime.add(child3.getTime());
                    }
                    this.getModel().setValue("approvedate", (Object)this.findMinTime(iTime), intexs);
                    this.getModel().setValue("id", (Object)((long)intexs + 12345L), intexs);
                    this.getModel().setValue("billno", (Object)pid.getString("billno"), intexs);
                    this.getModel().setValue("orderno", (Object)iApprovalRecordItemes.getActivityId(), intexs);
                    this.getModel().setValue("pid", (Object)((long)index + 123L), intexs);
                    this.getModel().setValue("splitcentral", pid.get("centralorg.name"), intexs);
                    this.getModel().setValue("combofield", (Object)true, intexs);
                    for (DynamicObject object : record) {
                        if (!pid.getString("billno").equals(object.getString("approvebillno"))) continue;
                        this.getModel().setValue("approvaladjustmen", (Object)"\u2714", intexs);
                        this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                    }
                    if (childNextApprovalUserIds != null && childNextApprovalUserIds.size() > 0 && (map2 = (Map)childNextApprovalUserIds.get(0)) != null && map2.size() > 0) {
                        this.getModel().setValue("nextapprovers", map2.get("users"), intexs);
                    }
                    ArrayList<Long> allIds = new ArrayList<Long>();
                    String allMessages = "";
                    StringBuilder allMessagesV = new StringBuilder();
                    if (iApprovalRecordItemList.size() <= 0) continue;
                    for (IApprovalRecordItem child4 : iApprovalRecordItemList) {
                        allIds.add(child4.getUserId());
                        if (child4.getMessage() == null) continue;
                        if (iApprovalRecordItemList.size() == 1) {
                            allMessagesV.append(child4.getMessage()).append(";");
                            continue;
                        }
                        if (iApprovalRecordItemList.size() <= 1) continue;
                        allMessagesV.append(this.getUserName(child4.getUserId())).append("-").append(child4.getMessage());
                    }
                    ArrayList userMainOrgIds = new ArrayList();
                    List userMainOrgId = UserServiceHelper.getUserMainOrgId(allIds);
                    for (Map longLongMap : userMainOrgId) {
                        userMainOrgIds.addAll(longLongMap.values());
                    }
                    if (StringUtils.isNotEmpty((String)allMessagesV.toString())) {
                        allMessages = allMessagesV.substring(0, allMessagesV.length() - 1);
                    }
                    this.getModel().setValue("approvers", (Object)allIds.toArray(), intexs);
                    this.getModel().setValue("orgs", (Object)userMainOrgIds.toArray(), intexs);
                    this.getModel().setValue("suggestion", (Object)allMessages, intexs);
                }
                continue;
            }
            starTime = null;
            endTime = null;
            if ("submit".equals(recordGroup.getGroupDecisionType())) continue;
            iApprovalRecordGroup = (IApprovalRecordGroup)approvalRecords.get(i - 1);
            upchildrentime = iApprovalRecordGroup.getChildren();
            starallTimes = new ArrayList();
            for (Object child2 : upchildrentime) {
                starallTimes.add(child2.getTime());
            }
            if (!"wait".equals(recordGroup.getGroupDecisionType()) && dynamicObject.getBoolean("ismainbill")) {
                DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(PRE_ENTITY);
                if (entryentity.size() > i) {
                    DynamicObject dyObj = (DynamicObject)entryentity.get(entryentity.size() - 2);
                    if (dyObj == null) continue;
                    ArrayList<String> objects = new ArrayList<String>(16);
                    objects.add(dyObj.getString("approvedate"));
                    starTime = this.findMaxTime(objects);
                    endTime = this.findMinTime(allTimes);
                    DynamicObjectCollection chackrecord2 = this.chackrecord(starTime, endTime, record);
                    if (chackrecord2.size() == 0) continue;
                    this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                    continue;
                }
                starTime = this.findMaxTime(starallTimes);
                DynamicObjectCollection chackrecord3 = this.chackrecord(starTime, endTime = this.findMinTime(allTimes), record);
                if (chackrecord3.size() == 0) continue;
                this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                continue;
            }
            if ("wait".equals(recordGroup.getGroupDecisionType()) && !dynamicObject.getBoolean("ismainbill")) {
                starTime = this.findMaxTime(starallTimes);
                chackrecord = this.chackrecord(starTime, endTime = this.formattednewDate(), record);
                if (chackrecord.size() == 0) continue;
                this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                continue;
            }
            if ("wait".equals(recordGroup.getGroupDecisionType()) && dynamicObject.getBoolean("ismainbill")) {
                starTime = this.findMaxTime(starallTimes);
                endTime = new Date().toString();
                chackrecord = null;
                try {
                    chackrecord = this.chackrecord(starTime, this.convertToDesiredFormat(endTime), record);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                if (chackrecord.size() == 0) continue;
                this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
                continue;
            }
            starTime = this.findMinTime(starallTimes);
            chackrecord = this.chackrecord(starTime, endTime = this.findMinTime(allTimes), record);
            if (chackrecord.size() == 0) continue;
            this.getModel().setValue("approvaladjustmen", (Object)"\u2714", index);
        }
    }

    private String getBillStatus(String billStatus) {
        switch (billStatus) {
            case "A": {
                return ResManager.loadKDString((String)"\u6682\u5b58", (String)"BgTaskSubmitDetailPluginDown_18", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            case "B": {
                return ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"BgTaskSubmitDetailPluginDown_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            case "C": {
                return ResManager.loadKDString((String)"\u5ba1\u6838\u4e2d", (String)"BgTaskSubmitDetailPluginDown_19", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            case "D": {
                return ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"BgTaskSubmitDetailPluginDown_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            case "E": {
                return ResManager.loadKDString((String)"\u91cd\u65b0\u5ba1\u6838", (String)"BgTaskSubmitDetailPluginDown_20", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            case "F": {
                return ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"BgTaskSubmitDetailPluginDown_21", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
            case "G": {
                return ResManager.loadKDString((String)"\u5ba1\u6838\u4e0d\u901a\u8fc7", (String)"BgTaskSubmitDetailPluginDown_22", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private String getUserName(Long userId) {
        if (IDUtils.isNull((Long)userId)) {
            return null;
        }
        return this.userMap.computeIfAbsent(userId, f -> {
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id, name");
            if (user != null) {
                return user.getString("name");
            }
            return null;
        });
    }

    public String findMinTime(List<String> timeList) {
        if (timeList == null || timeList.isEmpty()) {
            return null;
        }
        String timeString = timeList.get(0);
        String format = this.convertToDesiredDataFormat(timeString);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime minTime = LocalDateTime.parse(format, formatter);
        for (String timeStr : timeList) {
            String time = this.convertToDesiredDataFormat(timeStr);
            LocalDateTime currentTime = LocalDateTime.parse(time, formatter);
            if (!currentTime.isBefore(minTime)) continue;
            minTime = currentTime;
        }
        return minTime.format(formatter);
    }

    public static String addMinutesToTime(String inputTime, long minutesToAdd) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(inputTime, formatter);
        LocalDateTime newDateTime = dateTime.minusMinutes(minutesToAdd);
        return newDateTime.format(formatter);
    }

    private String formattednewDate() {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(currentDate);
    }

    public String findMaxTime(List<String> timeList) {
        if (timeList == null || timeList.isEmpty()) {
            return null;
        }
        String timeString = timeList.get(0);
        String format = this.convertToDesiredDataFormat(timeString);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime maxTime = LocalDateTime.parse(format, formatter);
        for (String timeStr : timeList) {
            String time = this.convertToDesiredDataFormat(timeStr);
            LocalDateTime currentTime = LocalDateTime.parse(time, formatter);
            if (!currentTime.isAfter(maxTime)) continue;
            maxTime = currentTime;
        }
        return maxTime.format(formatter);
    }

    private String convertToDesiredDataFormat(String dataString) {
        Date parsedDate = null;
        for (String format : formats) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            try {
                parsedDate = dateFormat.parse(dataString);
                break;
            }
            catch (ParseException parseException) {
            }
        }
        String format = null;
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (parsedDate != null) {
            format = outputFormat.format(parsedDate);
        } else {
            try {
                SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
                format = outputFormat.format(sdf1.parse(dataString));
            }
            catch (Exception exception) {
                log.warn(exception.getMessage());
                format = dataString;
            }
        }
        return format;
    }

    public String convertToDesiredFormat(String inputTime) throws ParseException {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("E MMM dd HH:mm:ss z yyyy", Locale.US);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(inputTime, inputFormatter);
        return localDateTime.format(outputFormatter);
    }

    private DynamicObjectCollection chackrecord(String time, String nextNodeTime, DynamicObjectCollection record) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : record) {
            String string = dynamicObject.getString("approvedate");
            if (!this.isTimeInRange(time, nextNodeTime, string)) continue;
            dynamicObjects.add((Object)dynamicObject);
        }
        return dynamicObjects;
    }

    private HashMap<String, String> chackrecordanddDate(String time, String nextNodeTime, DynamicObjectCollection record) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : record) {
            String string = dynamicObject.getString("approvedate");
            if (!this.isTimeInRange(time, nextNodeTime, string)) continue;
            String approvebillno = dynamicObject.getString("approvebillno");
            String nodenumber = dynamicObject.getString("nodenumber");
            String approvedate = dynamicObject.getString("approvedate");
            hashMap.put(approvebillno + "_" + approvedate, nodenumber);
        }
        return hashMap;
    }

    private DynamicObjectCollection chackApproval(String time, String time1, DynamicObjectCollection record) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : record) {
            String string = dynamicObject.getString("createdate");
            if (!this.isTimeInRange(time, time1, string)) continue;
            dynamicObjects.add((Object)dynamicObject);
        }
        return dynamicObjects;
    }

    private void initAdjustRecordData() {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        if (templateInfo.size() == 0) {
            return;
        }
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        for (String entityKey : templateInfo.keySet()) {
            this.loadEntryEntityData(entityKey, showColumnMap);
        }
        this.getView().updateView();
    }

    private void loadEntryEntityData(String entityKey, Map<String, ShowColumn> showColumnMap) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity(entityKey);
        if (entity.size() != 0) {
            return;
        }
        List<AppAdjustRecord> records = this.getRecords(entityKey);
        if (records == null || records.size() == 0) {
            return;
        }
        int entityIndex = Integer.parseInt(entityKey.replace(PRE_ENTITY, ""));
        ShowColumn showColumn = showColumnMap.get(entityKey);
        for (AppAdjustRecord record : records) {
            int rowIndex = this.getModel().createNewEntryRow(entityKey);
            Map dimMemberMap = record.getDimMemberMap();
            this.fillDimData(dimMemberMap, showColumn.getRowDims(), rowIndex, record.getModel());
            List colDataInfos = record.getColDataInfos();
            this.fillMeasureAndOtherData(colDataInfos, rowIndex);
            this.fillFixColData(record, rowIndex, entityIndex);
            this.cacheAdjustRecordBillNumIndexMap(record.getApproveBill(), rowIndex);
        }
    }

    private void cacheAdjustRecordBillNumIndexMap(String billNumber, Integer index) {
        Map<String, String> indexBillNumMap = new HashMap<String, String>(16);
        String indexBillNumMapStr = this.getPageCache().get("indexBillNumMap");
        if (StringUtils.isNotEmpty((String)indexBillNumMapStr)) {
            indexBillNumMap = (Map)SerializationUtils.fromJsonString((String)indexBillNumMapStr, HashMap.class);
        }
        indexBillNumMap.put(index + "", billNumber);
        this.getPageCache().put("indexBillNumMap", SerializationUtils.toJsonString(indexBillNumMap));
    }

    private String getAdjRowBillNum(Integer rowIndex) {
        List<AppAdjustRecord> records = this.getRecords(this.getCurTab().replace(PRE_TAB, PRE_ENTITY));
        if (records != null) {
            AppAdjustRecord appAdjustRecord = records.get(rowIndex);
            String rejectBillNo = appAdjustRecord.getRejectBillNo();
            return rejectBillNo == null ? "" : rejectBillNo;
        }
        return "";
    }

    private void fillDimData(Map<String, Long> dimMemberMap, List<BaseColumn> rowDims, int rowIndex, Long model) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        for (BaseColumn rowDim : rowDims) {
            String dimNumber = BgApplyBillUtils.getInstance().getDimOrRelateDimNumber(rowDim, modelCacheHelper);
            Long memberId = dimMemberMap.get(dimNumber);
            String fieldKey = rowDim.getKey();
            this.getModel().setValue(fieldKey, (Object)memberId, rowIndex);
        }
    }

    private void fillMeasureAndOtherData(List<AdjustRecordColInfo> colDataInfos, int rowIndex) {
        for (AdjustRecordColInfo colDataInfo : colDataInfos) {
            String fieldKey = colDataInfo.getKey();
            AppRecordColType type = colDataInfo.getType();
            if (AppRecordColType.MEASURE == type) {
                this.setMeasureData(rowIndex, colDataInfo, fieldKey);
                continue;
            }
            Object afterAdjust = colDataInfo.getAfterAdjust();
            if (this.existProperty(fieldKey)) {
                this.getModel().setValue(fieldKey, afterAdjust, rowIndex);
                continue;
            }
            this.setMeasureData(rowIndex, colDataInfo, fieldKey);
        }
    }

    private void setMeasureData(int rowIndex, AdjustRecordColInfo colDataInfo, String fieldKey) {
        Object preAdjust = colDataInfo.getPreAdjust();
        if (this.existProperty(fieldKey + "_pre")) {
            this.getModel().setValue(fieldKey + "_pre", this.changeBigDecimalShow(preAdjust), rowIndex);
        }
        Object afterAdjust = colDataInfo.getAfterAdjust();
        if (this.existProperty(fieldKey + "_after")) {
            this.getModel().setValue(fieldKey + "_after", this.changeBigDecimalShow(afterAdjust), rowIndex);
        } else if (this.existProperty(fieldKey)) {
            this.getModel().setValue(fieldKey, afterAdjust, rowIndex);
        }
    }

    private boolean existProperty(String propertyKey) {
        IDataEntityProperty property = this.getModel().getProperty(propertyKey);
        return property != null;
    }

    private Object changeBigDecimalShow(Object adjust) {
        BigDecimal bigDecimal = ConvertUtils.toDecimal((Object)adjust);
        if (bigDecimal == null) {
            return "0.00";
        }
        return bigDecimal.setScale(2, 4);
    }

    private void fillFixColData(AppAdjustRecord record, int rowIndex, int entityIndex) {
        DynamicObject centralTemplateObj = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id,parentid,ishassubitems,centralorg.name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)record.getApproveBill()).and(new QFilter("model", "=", (Object)record.getModel()))});
        if (centralTemplateObj != null) {
            if (centralTemplateObj.getLong("parentid") == 0L) {
                DynamicObject adminOrgObj = QueryServiceHelper.queryOne((String)"bos_adminorg", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)record.getOrg())});
                if (adminOrgObj == null) {
                    this.getModel().setValue("approve_adjustentity" + entityIndex, (Object)"", rowIndex);
                } else {
                    this.getModel().setValue("approve_adjustentity" + entityIndex, (Object)adminOrgObj.getString("name"), rowIndex);
                }
            } else {
                this.getModel().setValue("approve_adjustentity" + entityIndex, (Object)centralTemplateObj.getString("centralorg.name"), rowIndex);
            }
        } else {
            DynamicObject adminOrgObj = QueryServiceHelper.queryOne((String)"bos_adminorg", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)record.getOrg())});
            if (adminOrgObj == null) {
                this.getModel().setValue("approve_adjustentity" + entityIndex, (Object)"", rowIndex);
            } else {
                this.getModel().setValue("approve_adjustentity" + entityIndex, (Object)adminOrgObj.getString("name"), rowIndex);
            }
        }
        this.getModel().setValue("approver" + entityIndex, (Object)record.getApprover(), rowIndex);
        this.getModel().setValue("adminorg" + entityIndex, (Object)record.getOrg(), rowIndex);
        this.getModel().setValue("approvedate" + entityIndex, (Object)record.getApproveTime(), rowIndex);
        if ("0".equals(record.getAdjustType())) {
            this.getModel().setValue("btn_showreject" + entityIndex, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ApproveRecordListFormPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), rowIndex);
        }
        this.getModel().setValue("billno" + entityIndex, (Object)record.getApproveBill(), rowIndex);
        this.getModel().setValue("nodename" + entityIndex, (Object)record.getNodeName(), rowIndex);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        int rowIndex = evt.getRowIndex();
        if (!"splitcentral".equals(evt.getFieldName())) {
            this.setRejectInfo(rowIndex);
            this.updateRejectVisible();
        } else {
            this.openAppopenApproveBillPrepare(rowIndex);
        }
    }

    private void setRejectInfo(int rowIndex) {
        Object keys;
        Map templateMapkeysMap;
        this.getModel().deleteEntryData(REJECT_ENTITY);
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        ShowColumn showColumn = showColumnMap.get(REJECT_ENTITY);
        List<BaseColumn> rowDims = showColumn.getRowDims();
        List<BaseColumn> measureCols = showColumn.getMeasureCols();
        List<BaseColumn> otherCols = showColumn.getOtherCols();
        List<String> dimKeyList = rowDims.stream().map(t -> t.getKey().replace("_rej", "")).collect(Collectors.toList());
        Long templateId = showColumn.getTemplateId();
        RecordSearchEntry recordSearchEntry = this.getRecordSearchEntry(this.getView().getFormShowParameter());
        Long modelId = recordSearchEntry.getModel();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplateID((Long)templateId);
        Map<String, Map<String, String>> varInfo = this.getVarInfoByScheme(null);
        ApplyTemplateUtils.changeVarOnColumn((ColumnList)columnList, (Long)recordSearchEntry.getDataSetId(), (IModelCacheHelper)modelCacheHelper, varInfo);
        ArrayList columns = new ArrayList(columnList.getColumns());
        List baseColumns = columns.stream().filter(t -> t.getKey().startsWith("h_")).collect(Collectors.toList());
        String index = this.getCurTab().replace(PRE_TAB, "");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(PRE_ENTITY + index, rowIndex);
        String adjRowBillNum = this.getAdjRowBillNum(rowIndex);
        HashSet<Long> adjDimMemberIdSet = new HashSet<Long>(16);
        for (BaseColumn rowDim : rowDims) {
            String key = rowDim.getKey();
            String rejKey = key.replace("_rej", "");
            DynamicObject dynamicObject = entryRowEntity.getDynamicObject(rejKey);
            if (dynamicObject == null) continue;
            long id = dynamicObject.getLong("id");
            adjDimMemberIdSet.add(id);
        }
        String templateMapkeys = (String)this.getView().getFormShowParameter().getCustomParam("templateMapkeys");
        ArrayList templateMapkeySet = null;
        if (templateMapkeys != null && (templateMapkeysMap = (Map)SerializationUtils.fromJsonString((String)templateMapkeys, Map.class)) != null && !templateMapkeysMap.isEmpty() && (keys = templateMapkeysMap.get(templateId + "!" + adjRowBillNum)) instanceof ArrayList) {
            templateMapkeySet = (ArrayList)keys;
        }
        QFilter qf = new QFilter("bhbillnumber", "=", (Object)adjRowBillNum);
        List rejectLogs = RejectBillService.getInstance().getRejectLogsByFilter(qf);
        ArrayList rejectAdjRowData = new ArrayList(16);
        for (RejectLog rejectLog : rejectLogs) {
            Long templateId1 = rejectLog.getTemplateId();
            if (!templateId1.equals(templateId)) continue;
            List rejectLogDetails = rejectLog.getRejectLogDetails();
            for (RejectLogDetail rejectLogDetail : rejectLogDetails) {
                String rejKey;
                String key;
                String fmodifyrowdatajson = rejectLogDetail.getFmodifyrowdatajson();
                String fmodifyrowdatajsonnew = rejectLogDetail.getFmodifyrowdatajsonnew();
                List modifyrowdatajsonList = StringUtils.isEmpty((String)fmodifyrowdatajson) ? (List)SerializationUtils.fromJsonString((String)fmodifyrowdatajsonnew, List.class) : (List)SerializationUtils.fromJsonString((String)fmodifyrowdatajson, List.class);
                HashMap<String, Object> item = new HashMap<String, Object>(16);
                boolean flag = this.compareDimCombination(modifyrowdatajsonList.toArray(), adjDimMemberIdSet, dimKeyList);
                if (!flag) continue;
                Map oldAndNewRowData = RejectBillService.getInstance().getOldRowData(rejectLogDetail, baseColumns);
                Object[] oldRowData = (Object[])oldAndNewRowData.get("old");
                Object[] newRowData = (Object[])oldAndNewRowData.get("new");
                if (oldRowData == null || newRowData == null) continue;
                for (BaseColumn rowDim : rowDims) {
                    key = rowDim.getKey();
                    String rej = key.replace("_rej", "");
                    Object memberId = RejectBillService.getInstance().getValueFromRowDataArray(oldRowData, rej);
                    item.put(key, memberId);
                }
                for (BaseColumn baseColumn : measureCols) {
                    key = baseColumn.getKey();
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{key});
                    if (key.endsWith("_pre_rej")) {
                        rejKey = key.replace("_pre_rej", "");
                        Object oldVal = RejectBillService.getInstance().getValueFromRowDataArray(oldRowData, rejKey);
                        item.put(key, oldVal);
                        if (templateMapkeySet == null || templateMapkeySet.size() <= 0 || templateMapkeySet.contains(rejKey)) continue;
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{key});
                        continue;
                    }
                    rejKey = key.replace("_rej", "");
                    Object newVal = RejectBillService.getInstance().getValueFromRowDataArray(newRowData, rejKey);
                    item.put(key, newVal);
                    if (templateMapkeySet == null || templateMapkeySet.size() <= 0 || templateMapkeySet.contains(rejKey)) continue;
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{key});
                }
                for (BaseColumn baseColumn : otherCols) {
                    key = baseColumn.getKey();
                    rejKey = key.replace("_rej", "");
                    Object o = RejectBillService.getInstance().getValueFromRowDataArray(newRowData, rejKey);
                    if (o instanceof Boolean) continue;
                    item.put(baseColumn.getKey(), o);
                }
                RejectBill rejectBill = RejectBillService.getInstance().getRejectBill(rejectLog.getBhbillNumber(), this.getModelId());
                Long modifier = rejectBill.getModifier();
                Date modifyDate = rejectBill.getModifyDate();
                Long creator = rejectLog.getCreator();
                Date createdate = rejectLog.getCreatedate();
                item.put("rejector", creator);
                item.put("rejectdate", createdate);
                item.put("rejectbillno", rejectBill.getId());
                item.put("adjuster", modifier);
                item.put("adjustdate", modifyDate);
                rejectAdjRowData.add(item);
            }
        }
        for (Map map : rejectAdjRowData) {
            int newEntryRow = this.getModel().createNewEntryRow(REJECT_ENTITY);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.getModel().setValue(key, value, newEntryRow);
            }
        }
    }

    private boolean compareDimCombination(Object[] data, Set<Long> dimMemberIdSet, List<String> dimKeyList) {
        boolean flag = true;
        for (Object o : data) {
            Map valueMap;
            Object[] values;
            if (!(o instanceof Map) || !((values = (valueMap = (Map)o).values().toArray())[0] instanceof Long)) continue;
            for (String dimKey : dimKeyList) {
                Object dimMemberId = valueMap.get(dimKey);
                if (dimMemberId == null || dimMemberIdSet.contains(IDUtils.toLong(dimMemberId))) continue;
                return false;
            }
        }
        return flag;
    }

    private List<AppAdjustRecord> getRecords(String entityKey) {
        Map<String, List<AppAdjustRecord>> appAdjustRecords = this.getAppAdjustRecords();
        return appAdjustRecords.get(entityKey);
    }

    private Map<String, List<AppAdjustRecord>> getAppAdjustRecords() {
        if (this.adjustRecordMap.size() == 0) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String adjustRecordMapJson = (String)formShowParameter.getCustomParam("adjustRecordMap");
            if (adjustRecordMap_copy == null) {
                adjustRecordMap_copy = adjustRecordMapJson;
            }
            if (StringUtils.isNotEmpty((String)adjustRecordMapJson)) {
                Map appAdjustRecords = (Map)SerializationUtils.deSerializeFromBase64((String)adjustRecordMapJson);
                if (appAdjustRecords.size() != 0) {
                    this.adjustRecordMap.putAll(appAdjustRecords);
                } else {
                    this.adjustRecordMap.putAll(this.getGroupRecords());
                    formShowParameter.setCustomParam("adjustRecordMap", (Object)SerializationUtils.serializeToBase64(this.adjustRecordMap));
                }
            } else {
                this.adjustRecordMap.putAll(this.getGroupRecords());
                formShowParameter.setCustomParam("adjustRecordMap", (Object)SerializationUtils.serializeToBase64(this.adjustRecordMap));
            }
        }
        return this.adjustRecordMap;
    }

    private List<AppAdjustRecord> getAllAdjustRecord() {
        RecordSearchEntry recordSearchEntry = this.getRecordSearchEntry(this.getView().getFormShowParameter());
        return ApproveRecordUtil.getInstance().getAppAdjustRecords(recordSearchEntry);
    }

    private Map<Long, List<AppAdjustRecord>> getGroupRecords(List<AppAdjustRecord> appAdjustRecords) {
        HashMap<Long, List<AppAdjustRecord>> groupedRecords = new HashMap<Long, List<AppAdjustRecord>>(16);
        for (AppAdjustRecord appAdjustRecord : appAdjustRecords) {
            Long template = appAdjustRecord.getTemplate();
            List records = groupedRecords.computeIfAbsent(template, k -> new ArrayList(16));
            records.add(appAdjustRecord);
        }
        return groupedRecords;
    }

    private Map<String, List<AppAdjustRecord>> getGroupRecords() {
        HashMap<String, List<AppAdjustRecord>> records = new HashMap<String, List<AppAdjustRecord>>(16);
        Map<Long, List<AppAdjustRecord>> groupRecords = this.getGroupRecords(this.getAllAdjustRecord());
        Map<String, Long> templateInfo = this.getTemplateInfo();
        templateInfo.forEach((key, value) -> {
            List cfr_ignored_0 = (List)records.put((String)key, (List<AppAdjustRecord>)groupRecords.get(value));
        });
        return records;
    }

    private RecordSearchEntry getRecordSearchEntry(FormShowParameter formShowParameter) {
        if (this.recordSearchEntry == null) {
            String entryJson = (String)formShowParameter.getCustomParam("recordSearchEntry");
            if (StringUtils.isEmpty((String)entryJson)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u67e5\u8be2\u5ba1\u6279\u8bb0\u5f55\u7684\u6761\u4ef6\u3002", (String)"ApproveRecordListFormPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.recordSearchEntry = (RecordSearchEntry)SerializationUtils.fromJsonString((String)entryJson, RecordSearchEntry.class);
        }
        return this.recordSearchEntry;
    }

    private Boolean isShowAdjust() {
        RecordSearchEntry recordSearchEntry = this.getRecordSearchEntry(this.getView().getFormShowParameter());
        AdjustShowTypeEnum type = recordSearchEntry.getType();
        return AdjustShowTypeEnum.Adjust == type;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        for (String entityKey : templateInfo.keySet()) {
            this.registerDynamicProp(newMainType, showColumnMap, entityKey, false);
        }
        this.registerDynamicProp(newMainType, showColumnMap, REJECT_ENTITY, true);
    }

    private void registerDynamicProp(MainEntityType newMainType, Map<String, ShowColumn> showColumnMap, String entityKey, boolean isReject) {
        if (showColumnMap == null) {
            return;
        }
        ShowColumn showColumn = showColumnMap.get(entityKey);
        if (showColumn == null) {
            return;
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(entityKey);
        entryType.createPropIndexs();
        this.registerFields(entryType, showColumn, isReject);
        EntryAp entryAp = this.createEntryAp(this.getView().getFormShowParameter(), entityKey, showColumn, isReject, false);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map control = entryAp.createControl();
        clientViewProxy.preInvokeControlMethod(entityKey, "createGridColumns", new Object[]{control});
    }

    private void registerFields(EntryType entryType, ShowColumn showColumn, boolean isReject) {
        if (!isReject) {
            ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getPlanFixCols());
            ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getPreCols());
        }
        ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getRowDims());
        ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getMeasureCols());
        ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getOtherCols());
        ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getFixCols());
        ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, showColumn.getNodeNameCols());
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String controlKey = e.getKey();
        String controlKey_fix = controlKey.substring(0, controlKey.length() - 1);
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        if (controlKey.startsWith("h_")) {
            this.initBaseColControl(e, showColumnMap, controlKey, controlKey.endsWith("_rej"));
        } else if (AdjustRecordConstant.APPROVE_PLAN_FILED_KEYS.contains(controlKey_fix)) {
            this.initPlanColControl(e, showColumnMap, controlKey);
        } else if (AdjustRecordConstant.ADJUST_FIX_FIELD_KEYS.contains(controlKey_fix) || AdjustRecordConstant.REJECT_FIX_FIELD_KEYS.contains(controlKey)) {
            this.initFixColControl(e, showColumnMap, controlKey, AdjustRecordConstant.REJECT_FIX_FIELD_KEYS.contains(controlKey));
        } else if (controlKey.startsWith(PRE_ENTITY) || controlKey.startsWith(REJECT_ENTITY)) {
            this.initEntityControl(e, showColumnMap, controlKey);
        } else if (AdjustRecordConstant.PRE_FILED_KEYS.contains(controlKey_fix)) {
            this.initPreColControl(e, showColumnMap, controlKey);
        }
    }

    private void initPreColControl(OnGetControlArgs e, Map<String, ShowColumn> showColumnMap, String controlKey) {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        for (String entityKey : templateInfo.keySet()) {
            ShowColumn showColumn = showColumnMap.get(entityKey);
            List<BaseColumn> preCols = showColumn.getPreCols();
            List cols = preCols.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
            if (cols.size() == 0) continue;
            EntryGrid grid = (EntryGrid)this.getControl(entityKey);
            ApplyTemplateUtils.initControl((OnGetControlArgs)e, (String)controlKey, (String)entityKey, (EntryGrid)grid, cols);
            break;
        }
    }

    private void initBaseColControl(OnGetControlArgs e, Map<String, ShowColumn> showColumnMap, String controlKey, boolean isReject) {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        for (String value : templateInfo.keySet()) {
            List<BaseColumn> otherCols;
            List<BaseColumn> measureCols;
            ShowColumn showColumn;
            List cols = null;
            String entityKey = null;
            if (isReject) {
                entityKey = REJECT_ENTITY;
                showColumn = showColumnMap.get(entityKey);
                List<BaseColumn> planFixCols = showColumn.getRowDims();
                cols = planFixCols.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
                if (cols.size() == 0 && (cols = (measureCols = showColumn.getMeasureCols()).stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList())).size() == 0) {
                    otherCols = showColumn.getOtherCols();
                    cols = otherCols.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
                }
            } else {
                entityKey = value;
                showColumn = showColumnMap.get(entityKey);
                List<BaseColumn> rowDims = showColumn.getRowDims();
                cols = rowDims.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
                if (cols.size() == 0 && (cols = (measureCols = showColumn.getMeasureCols()).stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList())).size() == 0) {
                    otherCols = showColumn.getOtherCols();
                    cols = otherCols.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
                }
            }
            if (cols.size() == 0) continue;
            EntryGrid grid = (EntryGrid)this.getControl(entityKey);
            ApplyTemplateUtils.initControl((OnGetControlArgs)e, (String)controlKey, (String)entityKey, (EntryGrid)grid, cols);
            break;
        }
    }

    private void initPlanColControl(OnGetControlArgs e, Map<String, ShowColumn> showColumnMap, String controlKey) {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        for (String entityKey : templateInfo.keySet()) {
            ShowColumn showColumn = showColumnMap.get(entityKey);
            List<BaseColumn> planFixCols = showColumn.getPlanFixCols();
            List cols = planFixCols.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
            if (cols.size() == 0) continue;
            EntryGrid grid = (EntryGrid)this.getControl(entityKey);
            ApplyTemplateUtils.initControl((OnGetControlArgs)e, (String)controlKey, (String)entityKey, (EntryGrid)grid, cols);
            break;
        }
    }

    private void initFixColControl(OnGetControlArgs e, Map<String, ShowColumn> showColumnMap, String controlKey, boolean isReject) {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        for (String value : templateInfo.keySet()) {
            String entityKey = isReject ? REJECT_ENTITY : value;
            ShowColumn showColumn = showColumnMap.get(entityKey);
            List<BaseColumn> fixCols = showColumn.getFixCols();
            List cols = fixCols.stream().filter(ee -> controlKey.equals(ee.getKey())).collect(Collectors.toList());
            if (cols.size() == 0) continue;
            EntryGrid grid = (EntryGrid)this.getControl(entityKey);
            ApplyTemplateUtils.initControl((OnGetControlArgs)e, (String)controlKey, (String)entityKey, (EntryGrid)grid, cols);
            break;
        }
    }

    private void initEntityControl(OnGetControlArgs e, Map<String, ShowColumn> showColumnMap, String controlKey) {
        Control entryControl = e.getControl();
        if (entryControl != null) {
            EntryGrid entryGrid = (EntryGrid)entryControl;
            entryGrid.setPageRow(10000);
            if (entryGrid.getItems().isEmpty()) {
                ShowColumn showColumn = showColumnMap.get(controlKey);
                EntryAp entryAp = this.createEntryAp(this.getView().getFormShowParameter(), controlKey, showColumn, controlKey.startsWith(REJECT_ENTITY), false);
                List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
                this.addThisViewToEntryGrid(entryGrid, fieldEdits);
            }
        }
    }

    private void addThisViewToEntryGrid(EntryGrid entryGrid, List<Control> fieldEdits) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                }
                fieldEdit.setView(this.getView());
            } else if (fieldEdit != null) {
                fieldEdit.setView(this.getView());
            }
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private void addThisViewToEntryEditField(List<Control> items) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                }
                fieldEdit.setView(this.getView());
                continue;
            }
            if (fieldEdit == null) continue;
            fieldEdit.setView(this.getView());
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        Map<String, Long> templateInfo = this.getTemplateInfo();
        Map<String, ShowColumn> showColumnMap = this.getShowColumnMap(null);
        for (String entityKey : templateInfo.keySet()) {
            this.bindApproveData(showColumnMap, entityKey, false);
        }
        this.bindApproveData(showColumnMap, REJECT_ENTITY, true);
    }

    private void bindApproveData(Map<String, ShowColumn> showColumnMap, String entityKey, boolean isReject) {
        if (showColumnMap == null) {
            return;
        }
        ShowColumn showColumns = showColumnMap.get(entityKey);
        if (showColumns == null) {
            return;
        }
        EntryAp dynamicEntryAp = this.createEntryAp(this.getView().getFormShowParameter(), entityKey, showColumns, isReject, false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operate = args.getSource();
        if (operate instanceof Donothing) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rejectpanel"});
        }
    }
}

