/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.centralapproval.ApproveSelAppBillEntity;

public class ApproveSelAppBillListPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
EntryGridBindDataListener,
SelectRowsEventListener {
    private static final String TREE_ENTRYENTITY = "treeentryentity";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String appbillstatusfilter = "appbillstatusfilter";
    private static final Integer INI = 16;
    private static final Log log = LogFactory.getLog(ApproveSelAppBillListPlugin.class);
    private static final String LOGINFO = "selectapprovebill:";
    private static final String[] lockFields = new String[]{"orgnum", "orgname", "appbillno", "appbillstatus", "appbillid", "sourebillno"};

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRYENTITY);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String actionKey = ((Control)evt.getSource()).getKey();
        if (actionKey.equals(BTN_OK)) {
            this.getView().returnDataToParent(this.getSelectedBillIds());
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (appbillstatusfilter.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            this.getModel().deleteEntryData(TREE_ENTRYENTITY);
            String entryData = this.getPageCache().get("entryData");
            List appBills = SerializationUtils.fromJsonStringToList((String)entryData, ApproveSelAppBillEntity.class);
            if (newValue != null && StringUtils.isNotEmpty((String)newValue.toString())) {
                Set appBillsFilter = appBills.stream().filter(item -> item.getAppBillStatus() != null && newValue.equals(item.getAppBillStatus())).collect(Collectors.toSet());
                Set pidSet = appBillsFilter.stream().map(ApproveSelAppBillEntity::getParentId).collect(Collectors.toSet());
                List appBillsFilter2 = appBills.stream().filter(item -> pidSet.contains(item.getSumOrgId())).collect(Collectors.toList());
                while (!appBillsFilter2.isEmpty()) {
                    appBillsFilter.addAll(appBillsFilter2);
                    Set pidSet2 = appBillsFilter2.stream().map(ApproveSelAppBillEntity::getParentId).collect(Collectors.toSet());
                    appBillsFilter2 = appBills.stream().filter(item -> pidSet2.contains(item.getSumOrgId())).collect(Collectors.toList());
                }
                ArrayList<ApproveSelAppBillEntity> appBillsListFilter = new ArrayList<ApproveSelAppBillEntity>(appBillsFilter);
                appBillsListFilter.sort((o1, o2) -> {
                    String sumOrgNumber1 = o1.getSumOrgNumber();
                    String sumOrgNumber2 = o2.getSumOrgNumber();
                    return sumOrgNumber1.compareTo(sumOrgNumber2);
                });
                this.setListData(appBillsListFilter, null, null);
            } else {
                this.setListData(appBills, null, null);
            }
            String lockRows = this.getPageCache().get("lockRows");
            List needLockRows = new ArrayList(INI);
            if (lockRows != null && !lockRows.isEmpty()) {
                needLockRows = (List)SerializationUtils.fromJsonString((String)lockRows, List.class);
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, lockFields);
                if (!needLockRows.contains(i)) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"sel"});
            }
        }
    }

    private Set<Long> getSelectedBillIds() {
        HashSet<Long> returns = new HashSet<Long>();
        HashMap<String, Long> numberAndIds = new HashMap<String, Long>(16);
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        if (treeGrid.getEntryData() == null) {
            return returns;
        }
        int i = treeGrid.getEntryData().getEndIndex();
        for (int j = 0; j < i; ++j) {
            Long appBillId;
            if (!((Boolean)this.getModel().getValue("sel", j)).booleanValue() || (appBillId = ConvertUtils.toLong((Object)this.getModel().getValue("appbillid", j))) == 0L) continue;
            returns.add(appBillId);
            String longNumber = this.getModel().getValue("orglongnum", j).toString();
            Set<String> repeatNumbers = this.getRepeatNumber(numberAndIds, longNumber);
            if (repeatNumbers.size() == 0) {
                numberAndIds.put(longNumber, appBillId);
                continue;
            }
            repeatNumbers.forEach(numberAndIds::remove);
        }
        HashSet billIds = new HashSet(numberAndIds.values());
        this.getView().getParentView().getPageCache().put("selBillAfterFilter", SerializationUtils.toJsonString(billIds));
        return returns;
    }

    private Set<String> getRepeatNumber(Map<String, Long> numberAndIds, String number) {
        HashSet<String> repeatNumbers = new HashSet<String>(16);
        if (numberAndIds.size() == 0 || StringUtils.isEmpty((String)number)) {
            return repeatNumbers;
        }
        Set<String> numbers = numberAndIds.keySet();
        for (String num : numbers) {
            if (num.contains(number)) {
                repeatNumbers.add(num);
                continue;
            }
            if (!number.contains(num)) continue;
            repeatNumbers.add(number);
        }
        return repeatNumbers;
    }

    public void afterCreateNewData(EventObject e) {
        Set ids;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appids = (String)formShowParameter.getCustomParam("id");
        String reportBillNosStr = (String)formShowParameter.getCustomParam("reportBillNos");
        String selappbills = (String)formShowParameter.getCustomParam("selappbills");
        Long orgid = (Long)formShowParameter.getCustomParam("org");
        Long modelid = (Long)formShowParameter.getCustomParam("model");
        Long bizModelId = (Long)formShowParameter.getCustomParam("bizModel");
        if (StringUtils.isEmpty((String)appids)) {
            log.info("selectapprovebill:appids is null");
            return;
        }
        Map dynamicObjectMap = new HashMap(16);
        if (StringUtils.isNotEmpty((String)reportBillNosStr)) {
            Set reportBillNos = (Set)SerializationUtils.deSerializeFromBase64((String)reportBillNosStr);
            dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (String)"billnumber,org.id,org.name,org.number,billstatus", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", (Object)reportBillNos)});
        }
        if ((ids = (Set)SerializationUtils.deSerializeFromBase64((String)appids)) == null || ids.size() == 0) {
            log.info("selectapprovebill:ids is null");
        }
        Set selappbillIds = null;
        if (selappbills != null && !selappbills.isEmpty()) {
            selappbillIds = (Set)SerializationUtils.fromJsonString((String)selappbills, Set.class);
        }
        log.info("selectapprovebill:begin getOrgTree");
        Map<Long, Long> orgTrees = this.getOrgTree(modelid, bizModelId, orgid);
        log.info("selectapprovebill:begin getOrgTree");
        Set<Long> directChildrenOrgs = null;
        log.info("selectapprovebill:begin getAppBillLsts");
        List<ApproveSelAppBillEntity> appBills = this.getAppBillLsts2(modelid, bizModelId, orgTrees, ids);
        HashSet<ApproveSelAppBillEntity> reportBills = new HashSet<ApproveSelAppBillEntity>(16);
        if (dynamicObjectMap.size() > 0) {
            ArrayList<Long> reportEntityIds = new ArrayList<Long>(16);
            for (ApproveSelAppBillEntity appBill : appBills) {
                for (Map.Entry entry : dynamicObjectMap.entrySet()) {
                    DynamicObject value = (DynamicObject)entry.getValue();
                    if (!appBill.getSumOrgId().equals(value.getLong("org.id"))) continue;
                    Long reportEntityId = value.getLong("org.id");
                    if (reportEntityIds.contains(reportEntityId)) {
                        this.addRowApproveSelAppBillEntity(orgTrees, value, reportBills);
                        continue;
                    }
                    if (appBill.getSourceBillno() == null || appBill.getAppBillNo() == null) {
                        appBill.setSourceBillno(value.getString("billnumber"));
                        appBill.setAppBillStatus(value.getString("billstatus"));
                        reportEntityIds.add(appBill.getSumOrgId());
                        continue;
                    }
                    this.addRowApproveSelAppBillEntity(orgTrees, value, reportBills);
                }
            }
        }
        appBills.addAll(reportBills);
        appBills.sort(new Comparator<ApproveSelAppBillEntity>(){

            @Override
            public int compare(ApproveSelAppBillEntity o1, ApproveSelAppBillEntity o2) {
                String sumOrgNumber1 = o1.getSumOrgNumber();
                String sumOrgNumber2 = o2.getSumOrgNumber();
                return sumOrgNumber1.compareTo(sumOrgNumber2);
            }
        });
        log.info("selectapprovebill:begin setListData");
        String entryDataHasCache = this.getPageCache().get("entryDataHasCache");
        if (!Boolean.parseBoolean(entryDataHasCache)) {
            this.getPageCache().put("entryDataHasCache", "true");
            this.getPageCache().put("entryData", SerializationUtils.toJsonString(appBills));
        }
        this.setListData(appBills, selappbillIds, directChildrenOrgs);
    }

    private void addRowApproveSelAppBillEntity(Map<Long, Long> orgTrees, DynamicObject value, Set<ApproveSelAppBillEntity> reportBills) {
        ApproveSelAppBillEntity appBillSingle = new ApproveSelAppBillEntity();
        appBillSingle.setSumOrgId(GlobalIdUtil.genGlobalLongId());
        appBillSingle.setParentId(orgTrees.get(value.getLong("org.id")));
        appBillSingle.setSumOrgNumber(value.getString("org.number"));
        appBillSingle.setSumOrgName(value.getString("org.name"));
        appBillSingle.setSourceBillno(value.getString("billnumber"));
        appBillSingle.setAppBillStatus(value.getString("billstatus"));
        reportBills.add(appBillSingle);
    }

    private ApproveSelAppBillEntity copyAppBill(ApproveSelAppBillEntity appBill) {
        ApproveSelAppBillEntity appBillSingle = new ApproveSelAppBillEntity();
        appBillSingle.setAppBillId(appBill.getAppBillId());
        appBillSingle.setAppBillNo(appBill.getAppBillNo());
        appBillSingle.setAppBillStatus(appBill.getAppBillStatus());
        appBillSingle.setPkID(GlobalIdUtil.genGlobalLongId());
        appBillSingle.setSumOrgId(appBill.getSumOrgId());
        appBillSingle.setSumOrgNumber(appBill.getSumOrgNumber());
        appBillSingle.setSumOrgName(appBill.getSumOrgName());
        appBillSingle.setOrgId(appBill.getOrgId());
        appBillSingle.setOrgNumber(appBill.getOrgNumber());
        appBillSingle.setOrgName(appBill.getOrgName());
        return appBillSingle;
    }

    private Map<Long, Long> getOrgTree(Long modelid, Long bizModelId, Long orgid) {
        if (modelid == null) {
            return null;
        }
        if (orgid == null) {
            return null;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelid);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        Long dimViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
        Member org = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewId, orgid);
        if (org == null) {
            return null;
        }
        List members = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewId, org.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        if (members == null) {
            return null;
        }
        HashMap<Long, Long> returns = new HashMap<Long, Long>(members.size());
        for (Member member : members) {
            returns.put(member.getId(), member.getParentId());
        }
        returns.put(orgid, 0L);
        return returns;
    }

    private List<ApproveBill> getAppInfos(Set<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        return ApproveBillUtil.getInstance().getApproveBills(new QFilter("id", "in", ids));
    }

    private Set<Long> getChildrenOrgs(Map<Long, Long> orgTrees, Long parentOrgId) {
        if (orgTrees == null || orgTrees.size() == 0) {
            return null;
        }
        HashSet<Long> returns = new HashSet<Long>(INI);
        for (Map.Entry<Long, Long> orgTree : orgTrees.entrySet()) {
            if (orgTree.getValue().compareTo(orgTree.getKey()) == 0 || orgTree.getValue().compareTo(parentOrgId) != 0) continue;
            returns.add(orgTree.getKey());
        }
        return returns;
    }

    private Long getParentPKID(Map<Long, Long> orgTrees, List<ApproveSelAppBillEntity> appBills, Long childrenOrgId) {
        if (orgTrees == null || orgTrees.size() == 0) {
            return 0L;
        }
        if (appBills == null || appBills.size() == 0) {
            return 0L;
        }
        Long parentOrgId = orgTrees.get(childrenOrgId);
        if (parentOrgId == null || parentOrgId.compareTo(childrenOrgId) == 0) {
            return 0L;
        }
        for (ApproveSelAppBillEntity appBill : appBills) {
            if (appBill.getSumOrgId().compareTo(parentOrgId) != 0) continue;
            return appBill.getPkID();
        }
        return 0L;
    }

    private List<ApproveSelAppBillEntity> getChildrenRowsBySingleOrg(List<ApproveSelAppBillEntity> appBills, Set<Long> childrenOrgIds) {
        if (appBills == null || appBills.size() == 0) {
            return null;
        }
        ArrayList<ApproveSelAppBillEntity> reuturns = new ArrayList<ApproveSelAppBillEntity>(INI);
        for (ApproveSelAppBillEntity appBill : appBills) {
            if (!childrenOrgIds.contains(appBill.getSumOrgId())) continue;
            reuturns.add(appBill);
        }
        return reuturns;
    }

    private void setListData(List<ApproveSelAppBillEntity> appBills, Set<Long> selappbillIds, Set<Long> directChildrenOrgs) {
        if (appBills == null || appBills.size() == 0) {
            log.info("selectapprovebill:appBills is null");
            return;
        }
        log.info("selectapprovebill:appBills.count:" + appBills.size());
        int[] rowIndex = this.getModel().batchCreateNewEntryRow(TREE_ENTRYENTITY, appBills.size());
        int i = 0;
        ArrayList<Integer> needLockRows = new ArrayList<Integer>(INI);
        int expandIndex = 0;
        for (int j = 0; j < rowIndex.length; ++j) {
            ApproveSelAppBillEntity appBill = appBills.get(j);
            this.getModel().setValue("orgnum", (Object)appBill.getSumOrgNumber(), j);
            this.getModel().setValue("orglongnum", (Object)appBill.getSumOrgLongNumber(), j);
            this.getModel().setValue("orgname", (Object)appBill.getSumOrgName(), j);
            this.getModel().setValue("appbillno", (Object)appBill.getAppBillNo(), j);
            this.getModel().setValue("sourebillno", (Object)appBill.getSourceBillno(), j);
            this.getModel().setValue("appbillstatus", (Object)appBill.getAppBillStatus(), j);
            this.getModel().setValue("appbillid", (Object)appBill.getAppBillId(), j);
            this.getModel().setValue("treeentryentity.id", (Object)appBill.getSumOrgId(), j);
            this.getModel().setValue("pid", (Object)appBill.getParentId(), j);
            if (appBill.getParentId() == 0L) {
                this.getModel().setValue("isgroupnode", (Object)true, j);
                expandIndex = j;
            }
            if (!"D".equalsIgnoreCase(appBill.getAppBillStatus())) {
                needLockRows.add(i);
            }
            ++i;
        }
        TreeEntryGrid treeGrid = (TreeEntryGrid)this.getControl(TREE_ENTRYENTITY);
        treeGrid.expandOne(expandIndex);
        if (needLockRows.size() > 0) {
            this.getPageCache().put("lockRows", SerializationUtils.toJsonString(needLockRows));
        } else {
            this.getPageCache().put("lockRows", "");
        }
        this.getView().updateView(TREE_ENTRYENTITY);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRYENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREE_ENTRYENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addClickListener((ClickListener)this);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        String lockRows = this.getPageCache().get("lockRows");
        List needLockRows = new ArrayList(INI);
        if (lockRows != null && !lockRows.isEmpty()) {
            needLockRows = (List)SerializationUtils.fromJsonString((String)lockRows, List.class);
        }
        for (RowDataEntity row : e.getRows()) {
            int rowIndex = row.getRowIndex();
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, lockFields);
            if (!needLockRows.contains(rowIndex)) continue;
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"sel"});
        }
    }

    public void afterBindData(EventObject e) {
    }

    private List<ApproveSelAppBillEntity> getAppBillLsts2(Long modelId, Long bizModelId, Map<Long, Long> orgTrees, Set<Long> ids) {
        List<ApproveBill> appBillsOld = this.getAppInfos(ids);
        List<Object> appBills = new ArrayList(16);
        if (appBillsOld != null) {
            appBills = appBillsOld.stream().filter(e -> e.isMainbill() || IDUtils.isNull((Long)e.getParentId())).collect(Collectors.toList());
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        ArrayList<ApproveSelAppBillEntity> returns = new ArrayList<ApproveSelAppBillEntity>(orgTrees.size());
        for (Map.Entry<Long, Long> org : orgTrees.entrySet()) {
            Long orgid = org.getKey();
            Long parentOrgId = org.getValue();
            List<Object> findbills = new ArrayList(16);
            if (appBills != null) {
                findbills = appBills.stream().filter(s -> orgid.equals(s.getReportEntity())).collect(Collectors.toList());
            }
            if (!findbills.isEmpty()) {
                for (ApproveBill appBill : findbills) {
                    ApproveSelAppBillEntity appBillSingle = new ApproveSelAppBillEntity();
                    List appSumOrg = returns.stream().map(ApproveSelAppBillEntity::getSumOrgId).collect(Collectors.toList());
                    returns.add(appBillSingle);
                    String applybillno = "";
                    List approveBillEntries = appBill.getApproveBillEntries();
                    if (approveBillEntries != null && !approveBillEntries.isEmpty()) {
                        String reportbillno;
                        ApproveBillEntry entry = (ApproveBillEntry)approveBillEntries.get(0);
                        String sumbillno = entry.getSumBillNo();
                        applybillno = reportbillno = entry.getReportBillNo();
                        if (StringUtils.isNotEmpty((String)sumbillno) && StringUtils.isNotEmpty((String)sumbillno.trim())) {
                            applybillno = sumbillno;
                        }
                    }
                    appBillSingle.setAppBillId(appBill.getId());
                    appBillSingle.setSourceBillno(applybillno);
                    appBillSingle.setAppBillNo(appBill.getBillNo());
                    appBillSingle.setAppBillStatus(appBill.getBillStatus().getNumber());
                    Long reportEntityId = appBill.getReportEntity();
                    appBillSingle.setSumOrgId(reportEntityId);
                    appBillSingle.setParentId(parentOrgId);
                    Long dimViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
                    Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewId, reportEntityId);
                    if (member != null) {
                        appBillSingle.setSumOrgLongNumber(member.getLongNumber());
                        appBillSingle.setSumOrgNumber(member.getNumber());
                        appBillSingle.setSumOrgName(member.getName());
                    }
                    if (!appSumOrg.contains(reportEntityId)) continue;
                    appBillSingle.setSumOrgId(GlobalIdUtil.genGlobalLongId());
                }
                continue;
            }
            ApproveSelAppBillEntity appBillSingle = new ApproveSelAppBillEntity();
            returns.add(appBillSingle);
            Long reportEntityId = orgid;
            appBillSingle.setSumOrgId(reportEntityId);
            appBillSingle.setParentId(parentOrgId);
            Long dimViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
            Member member = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewId, reportEntityId);
            if (member == null) continue;
            appBillSingle.setSumOrgLongNumber(member.getLongNumber());
            appBillSingle.setSumOrgNumber(member.getNumber());
            appBillSingle.setSumOrgName(member.getName());
        }
        return returns;
    }
}

