/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.utils.IDUtils;

public class ApproveWaitCondition
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(ApproveWaitCondition.class);

    public boolean hasTrueCondition(AgentExecution execution) {
        WorkflowElement element;
        String number;
        Object planNum;
        HashSet<Long> reportEntities = new HashSet<Long>(16);
        HashSet<Long> entities = new HashSet<Long>(16);
        HashSet<Long> templates = new HashSet<Long>(16);
        String businessKey = execution.getBusinessKey();
        ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)IDUtils.toLong((Object)businessKey)));
        this.fillBillInfos(approveBill.getApproveBillEntries(), entities, templates, reportEntities);
        Long model = approveBill.getModel();
        if (entities.size() == 0 || entities.size() == 1 && entities.contains(0L)) {
            entities.addAll(reportEntities);
        }
        if ((planNum = execution.getVariable(number = (element = execution.getCurrentFlowElement()).getNumber())) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8282\u70b9\u65b9\u6848\u7f16\u7801\u5931\u8d25\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
        List plans = CentralAppBillService.getInstance().getPlanByCenApproveBill(templates, entities, planNum.toString(), model);
        log.info("ApproveWaitCondition.planNum: " + planNum);
        log.info("ApproveWaitCondition.planNum: " + plans.toString());
        try (TXHandle tx = TX.requiresNew((String)"updateApprove");){
            try {
                this.updateApproveBill(businessKey, planNum, plans.size() != 0);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ResManager.loadResFormat((String)"\u5ba1\u6279\u5355\u636e\u66f4\u65b0\u65b9\u6848\u4fe1\u606f\u5931\u8d25\uff1a\u201c%1\u201d\u3002", (String)"ApproveWaitCondition_1", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return plans.size() != 0;
    }

    protected void fillBillInfos(List<ApproveBillEntry> approveBillEntries, Set<Long> entities, Set<Long> templates, Set<Long> reportEntities) {
        approveBillEntries.forEach(e -> {
            entities.add(e.getCentralEntity());
            templates.add(e.getTemplate());
            reportEntities.add(e.getEntity());
        });
    }

    private void updateApproveBill(String businessKey, Object planNums, boolean pass) {
        ApproveBillUtil instance = ApproveBillUtil.getInstance();
        ApproveBill approveBill = instance.getApproveBill(new QFilter("id", "=", (Object)IDUtils.toLong((Object)businessKey)));
        if (!pass) {
            if (planNums != null) {
                Object[] split = planNums.toString().trim().split(",");
                approveBill.setCentralWaitPlan((Set)Sets.newHashSet((Object[])split));
            }
        } else {
            approveBill.setCentralWaitPlan(new HashSet(16));
        }
        instance.save(Collections.singletonList(approveBill));
    }
}

