/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.applybill.util.BgApplyBillListBasePlugin;

public class BgDecomposeBillListPlugin
extends BgApplyBillListBasePlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String TREESEARCHKEY = "schemetree_search";
    private static final String YERA_KEY = "year";
    private static final String DATATYPE_KEY = "datatype";
    private static final String VERSION_KEY = "version";
    private static final String MODEL_KEY = "model";
    private static final String BILL_LISTAP = "billlistap";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_splitschedule": {
                this.viewSplitSchedule();
                break;
            }
            case "btn_refresh": {
                this.reflesh();
            }
        }
    }

    private void viewSplitSchedule() {
        BillList billList = (BillList)this.getView().getControl(BILL_LISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ec5\u9009\u62e9\u4e00\u4e2a\u5206\u89e3\u5355\u3002", (String)"BgDecomposeBillListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long splitBillId = IDUtils.toLong((Object)selectedRows.get(0).getPrimaryKeyValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)splitBillId, (String)"eb_bgdecompose");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u89e3\u5355\u4e0d\u5b58\u5728\u6216\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BgDecomposeBillListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long splitSchemeId = dynamicObject.getLong("decomposescheme.id");
        Long sourceBillId = dynamicObject.getLong("sourcebillid");
        if (this.isLastStep(splitBillId, splitSchemeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u89e3\u5355\u4e3a\u5206\u89e3\u65b9\u6848\u6b65\u9aa4\u7684\u6700\u540e\u4e00\u6b65\uff0c\u65e0\u9700\u67e5\u770b\u5206\u89e3\u8fdb\u5ea6\u3002", (String)"BgDecomposeBillListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openSplitSchedulePage(splitBillId, splitSchemeId, sourceBillId);
    }

    @Override
    protected void addCustomFilter(QFBuilder qb) {
        super.addCustomFilter(qb);
        Long userId = UserUtils.getUserId();
        Long modelId = this.getModelId();
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)userId, (Long)modelId)) {
            qb.add("mudecomposeperson.fbasedataid", "=", (Object)userId);
        }
    }

    private boolean isLastStep(Long splitBillId, Long splitSchemeId) {
        DynamicObject splitBill = BusinessDataServiceHelper.loadSingle((Object)splitBillId, (String)"eb_bgdecompose");
        Long splitOrgId = splitBill.getLong("splitorg.id");
        DynamicObject splitScheme = BusinessDataServiceHelper.loadSingle((Object)splitSchemeId, (String)"eb_decomposescheme");
        String rowsDataJson = splitScheme.getString("rowsdata");
        DecpStepManager decpStepManager = (DecpStepManager)SerializationUtils.fromJsonString((String)rowsDataJson, DecpStepManager.class);
        DecpStepManager curSplitBillStepData = new DecpStepManager();
        this.getCurSplitBillStepData(curSplitBillStepData, null, decpStepManager, 1, splitOrgId);
        return curSplitBillStepData.getStepKeys().size() == 0;
    }

    @Override
    protected String getOrgKey() {
        return "splitorg";
    }

    @Override
    protected String getApplySchemeKey() {
        return "bgapplyscheme";
    }

    private void getCurSplitBillStepData(DecpStepManager curSplitBillStepData, Set<Long> curOrderOrgIds, DecpStepManager decpStepManager, Integer stepNum, Long curBillSplitOrg) {
        if (stepNum > decpStepManager.size()) {
            return;
        }
        DecpStepData stepData = decpStepManager.getStepDataByNumber("step" + stepNum);
        HashSet<Long> matchOrderOrgIds = new HashSet<Long>(16);
        ArrayList<DecpRowData> matchRowData = new ArrayList<DecpRowData>();
        List rowDataList = stepData.getRowDataList();
        for (DecpRowData decpRowData : rowDataList) {
            if ((curOrderOrgIds == null || curOrderOrgIds.size() == 0) && curBillSplitOrg.equals(decpRowData.getDecpOrgId())) {
                matchOrderOrgIds.add(decpRowData.getDecpOrgId());
                break;
            }
            if (curOrderOrgIds == null || curOrderOrgIds.size() <= 0 || !curOrderOrgIds.contains(decpRowData.getOrderOrgId())) continue;
            matchRowData.add(decpRowData);
            matchOrderOrgIds.add(decpRowData.getDecpOrgId());
        }
        if (matchRowData.size() > 0) {
            DecpStepData matchStepData = new DecpStepData(stepData.getName(), stepData.getNumber());
            matchStepData.getRowDataList().addAll(matchRowData);
            curSplitBillStepData.addStepData(matchStepData);
        }
        stepNum = stepNum + 1;
        this.getCurSplitBillStepData(curSplitBillStepData, matchOrderOrgIds, decpStepManager, stepNum, curBillSplitOrg);
    }

    private void openSplitSchedulePage(Long splitBillId, Long splitSchemeId, Long sourceBillId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_splitschedulequery");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam(MODEL_KEY, (Object)this.getModelId());
        showParameter.setCustomParam("splitBillId", (Object)splitBillId);
        showParameter.setCustomParam("splitSchemeId", (Object)splitSchemeId);
        showParameter.setCustomParam("sourceBillId", (Object)sourceBillId);
        showParameter.setPageId(this.getView().getPageId() + splitBillId + "splitScheduleQuery");
        this.getView().showForm(showParameter);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"billnumber", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            if (!CentralAppBillService.getInstance().checkExist("eb_centralappbill", "id", this.getSourceBillId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5206\u89e3\u5355\u5173\u8054\u7684\u5ba1\u6279\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BgDecomposeBillListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            String pageId = this.getView().getPageId() + this.getFocusRowPkId();
            IFormView childFormView = this.getView().getView(pageId);
            if (childFormView != null) {
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("activate", (Object)pageId);
            } else {
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setFormId("eb_bgdecompose");
                baseShowParameter.setPageId(pageId);
                baseShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u89e3\u5355", (String)"BgDecomposeBillListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                baseShowParameter.setPkId(this.getFocusRowPkId());
                baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                baseShowParameter.setStatus(OperationStatus.EDIT);
                baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editBill"));
                this.getView().showForm((FormShowParameter)baseShowParameter);
            }
        }
    }

    private Object getSourceBillId() {
        Object focusRowPkId = this.getFocusRowPkId();
        DynamicObject decomposeBill = QueryServiceHelper.queryOne((String)"eb_bgdecompose", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "=", focusRowPkId)});
        if (decomposeBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u89e3\u5355\u4e0d\u5b58\u5728\u6216\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BgDecomposeBillListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return decomposeBill.getLong("sourcebillid");
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        this.refleshRightBillList();
    }
}

