/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.applybill.util.BgApplySplitUtil;
import kd.epm.eb.business.centralapproval.AppBillDataFilterService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.centralapproval.BaseAppBillShowPlugin;

public class BgDecomposeBillPlugin
extends BaseAppBillShowPlugin {
    private static final Log log = LogFactory.getLog(BgDecomposeBillPlugin.class);

    @Override
    protected void filterDataByPerm() {
        Set entitySet = this.showInfo.getEntitySet();
        Long bizModel = this.showInfo.getBizModel();
        Set accountSet = AppBillDataFilterService.getInstance().getAccountInPerm(this.getModelId(), bizModel, this.getPermType(), UserUtils.getUserId());
        log.info("CentralAppBillShowPlugin.accountInPerm: " + accountSet.toString());
        log.info("orgSet1: " + entitySet.size());
        if (!this.isModelAdmin()) {
            Set<Long> permOrgs = this.getDimMemInPerm(SysDimensionEnum.Entity.getNumber(), Collections.singleton(bizModel), this.getPermType());
            entitySet.retainAll(permOrgs);
            log.info("orgSet2: \u6821\u9a8c\u4f53\u7cfb\u6743\u9650\u7ec4\u7ec7");
        }
        log.info("orgSet2: " + entitySet.size());
        DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("splitorg");
        Set childMems = this.getAllDimensionByMem(this.getModelId(), orgDy.getLong("id"), SysDimensionEnum.Entity.getNumber());
        if (childMems != null && childMems.size() != 0) {
            childMems.retainAll(entitySet);
        } else {
            childMems = entitySet;
        }
        this.showInfo.setEntitySet(childMems);
        this.showInfo.setAccountSet(accountSet);
    }

    @Override
    protected void beforeShowApprovePage() {
        super.beforeShowApprovePage();
        String billNo = this.getModel().getDataEntity().getString("billnumber");
        this.showInfo.setBillNo(billNo);
        CentralAppChain centralAppChain = this.showInfo.getCentralAppChain();
        String appBillNo = this.showInfo.getCentralBillNo();
        String stepPath = this.getModel().getDataEntity().getString("decppath");
        String[] splitStepNums = stepPath.split("!");
        centralAppChain.getHeadElements().remove(appBillNo);
        centralAppChain.getHeadElements().add(billNo);
        for (int i = splitStepNums.length - 1; i > 0; --i) {
            centralAppChain.getElementRelation().put(splitStepNums[i], Collections.singleton(splitStepNums[i - 1]));
        }
        centralAppChain.getElementRelation().put(splitStepNums[0], Collections.singleton(appBillNo));
        Set allChildBillNumbers = BgApplySplitUtil.getInstance().getAllChildBillNumbers(this.getModelId(), stepPath);
        allChildBillNumbers.addAll(this.showInfo.getRefedBillNos());
        this.showInfo.setRefedBillNos(allChildBillNumbers);
        this.showInfo.setCentralAppChain(centralAppChain);
    }

    @Override
    protected BaseShowParameter getBaseShowParameter() {
        BaseShowParameter baseShowParameter = super.getBaseShowParameter();
        Long orderOrgId = this.getModel().getDataEntity().getLong("splitorg.id");
        baseShowParameter.setCustomParam("orderOrgId", (Object)orderOrgId);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u89e3\u5355", (String)"BgDecomposeBillListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return baseShowParameter;
    }

    @Override
    public String getBillShowType() {
        return ApplyBillType.SPLIT.getNumber();
    }

    @Override
    protected ApproveBill getCurApproveBill() {
        Long applyBillId = this.getModel().getDataEntity().getLong("sourcebillid");
        return ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)applyBillId));
    }

    private Set<Long> getAllDimensionByMem(Long model, Long curMemberNum, String dimensionNum) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(this.showInfo.getBizModel());
        Member curMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber()), curMemberNum);
        List members = modelCacheHelper.getMemberSort(dimensionNum, (Long)dimViewMap.get(dimensionNum), curMember.getNumber(), RangeEnum.ALL.getIndex());
        if (members == null || members.size() == 0) {
            return new HashSet<Long>(16);
        }
        return members.stream().map(BaseCache::getId).collect(Collectors.toSet());
    }
}

