/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgSplitScheduleQueryPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BgSplitScheduleQueryPlugin.class);

    public void afterCreateNewData(EventObject e) {
        this.updateSplitProcess(null);
        this.refreshEntry(null);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        super.hyperLinkClick(evt);
        String fieldName = evt.getFieldName();
        if (fieldName.equals("splitbillnumber")) {
            int rowIndex = evt.getRowIndex();
            Object splitBillId = this.getModel().getValue("splitbillid", rowIndex);
            this.checkCurUserPermission(rowIndex);
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("eb_bgdecompose");
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u5206\u89e3\u5355", (String)"BgSplitScheduleQueryPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            baseShowParameter.setPkId((Object)IDUtils.toLong((Object)splitBillId));
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }

    private void checkCurUserPermission(int rowIndex) {
        if (!ModelServiceHelper.isUserHasRootPermByModel((long)this.getUserId(), (Long)this.getModelId())) {
            DynamicObjectCollection chargePerson = (DynamicObjectCollection)this.getModel().getValue("chargeperson", rowIndex);
            if (chargePerson == null) {
                return;
            }
            HashSet<Long> userIds = new HashSet<Long>();
            for (DynamicObject object : chargePerson) {
                userIds.add(object.getLong("fbasedataid_id"));
            }
            if (!userIds.contains(this.getUserId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\u3002", (String)"BgSplitScheduleQueryPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void refreshEntry(String step) {
        Map<Long, DynamicObject> orgSplitMap = this.getSplitBillsByScheme();
        DecpStepManager curSplitBillStepData = this.getCurSplitBillStepData();
        if (curSplitBillStepData != null) {
            DecpStepData stepData = new DecpStepData();
            if (step == null) {
                stepData = (DecpStepData)curSplitBillStepData.getStepDataList().get(0);
            } else if (curSplitBillStepData.getStepDataByNumber(step) != null) {
                stepData = curSplitBillStepData.getStepDataByNumber(step);
            }
            List rowDataList = stepData.getRowDataList();
            this.getModel().deleteEntryData("entryentity");
            int[] indexs = this.getModel().batchCreateNewEntryRow("entryentity", stepData.getRowDataList().size());
            for (int i = 0; i < rowDataList.size(); ++i) {
                DynamicObject dynamicObject;
                int index = indexs[i];
                DecpRowData rowData = (DecpRowData)rowDataList.get(i);
                this.getModel().setValue("orderorg", (Object)rowData.getOrderOrgId(), index);
                this.getModel().setValue("decporg", (Object)rowData.getDecpOrgId(), index);
                List chargePersonsId = rowData.getChargePersonsId();
                if (CollectionUtils.isNotEmpty((Collection)chargePersonsId)) {
                    this.getModel().setValue("chargeperson", (Object)chargePersonsId.toArray(new Object[0]), index);
                }
                if (rowData.getDecpOrgId() == null || (dynamicObject = orgSplitMap.get(rowData.getDecpOrgId())) == null) continue;
                this.getModel().setValue("splitbillnumber", (Object)dynamicObject.getString("billnumber"), index);
                this.getModel().setValue("splitstatus", (Object)dynamicObject.getString("splitstatus"), index);
                this.getModel().setValue("splitbillid", (Object)dynamicObject.getString("id"), index);
            }
        }
    }

    private Map<Long, DynamicObject> getSplitBillsByScheme() {
        Object splitSchemeId = this.getView().getFormShowParameter().getCustomParam("splitSchemeId");
        Object model = this.getView().getFormShowParameter().getCustomParam("model");
        Object sourceBillId = this.getView().getFormShowParameter().getCustomParam("sourceBillId");
        QFilter qFilter = new QFilter("decomposescheme", "=", (Object)IDUtils.toLong((Object)splitSchemeId));
        qFilter.and(new QFilter("model", "=", (Object)IDUtils.toLong((Object)model)));
        qFilter.and(new QFilter("sourcebillid", "=", (Object)String.valueOf(sourceBillId)));
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgdecompose", (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> orgSplitMap = new HashMap<Long, DynamicObject>(16);
        if (objectDynamicObjectMap != null) {
            for (Map.Entry map : objectDynamicObjectMap.entrySet()) {
                DynamicObject value = (DynamicObject)map.getValue();
                orgSplitMap.put(value.getLong("splitorg.id"), value);
            }
        }
        return orgSplitMap;
    }

    private void updateSplitProcess(String clickStep) {
        DecpStepManager curSplitBillStepData = this.getCurSplitBillStepData();
        if (curSplitBillStepData != null) {
            List stepDataList = curSplitBillStepData.getStepDataList();
            FlexPanelAp flexPanelAp = new FlexPanelAp();
            flexPanelAp.setKey("stepFlexPanelAp");
            flexPanelAp.setId("stepFlexPanelAp");
            if (clickStep == null) {
                clickStep = (String)curSplitBillStepData.getStepKeys().get(0);
            }
            for (int i = 0; i < stepDataList.size(); ++i) {
                String name = ((DecpStepData)stepDataList.get(i)).getName();
                String number = ((DecpStepData)stepDataList.get(i)).getNumber();
                LabelAp labelAp = new LabelAp();
                labelAp.setKey(number);
                labelAp.setName(new LocaleString(name));
                labelAp.setClickable(true);
                if (clickStep.equals(number)) {
                    labelAp.setForeColor("blue");
                }
                labelAp.setFontSize(15);
                flexPanelAp.getItems().add(labelAp);
                labelAp.setClickable(true);
                if (i < stepDataList.size() - 1) {
                    LabelAp labelSignAp = new LabelAp();
                    labelSignAp.setKey(number + "_sign");
                    labelSignAp.setName(new LocaleString(">>"));
                    labelSignAp.setFontSize(20);
                    flexPanelAp.getItems().add(labelSignAp);
                }
                this.getView().updateControlMetadata(flexPanelAp.getKey(), flexPanelAp.createControl());
            }
        }
    }

    private DecpStepManager getCurSplitBillStepData() {
        String curSplitBillStepDataCache = this.getView().getPageCache().get("curSplitBillStepData");
        if (curSplitBillStepDataCache != null) {
            return (DecpStepManager)SerializationUtils.deSerializeFromBase64((String)curSplitBillStepDataCache);
        }
        DynamicObject splitBill = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("splitBillId"), (String)"eb_bgdecompose");
        Long splitOrgId = splitBill.getLong("splitorg.id");
        Long splitSchemeId = (Long)this.getView().getFormShowParameter().getCustomParam("splitSchemeId");
        DynamicObject splitScheme = BusinessDataServiceHelper.loadSingle((Object)splitSchemeId, (String)"eb_decomposescheme");
        String rowsDataJson = splitScheme.getString("rowsdata");
        DecpStepManager decpStepManager = (DecpStepManager)SerializationUtils.fromJsonString((String)rowsDataJson, DecpStepManager.class);
        DecpStepManager curSplitBillStepData = new DecpStepManager();
        this.getCurSplitBillStepData(curSplitBillStepData, null, decpStepManager, 1, splitOrgId);
        this.getView().getPageCache().put("curSplitBillStepData", SerializationUtils.serializeToBase64((Object)curSplitBillStepData));
        return curSplitBillStepData;
    }

    private void getCurSplitBillStepData(DecpStepManager curSplitBillStepData, Set<Long> curOrderOrgIds, DecpStepManager decpStepManager, Integer stepNum, Long curBillSplitOrg) {
        if (stepNum > decpStepManager.size()) {
            return;
        }
        DecpStepData stepData = decpStepManager.getStepDataByNumber("step" + stepNum);
        HashSet<Long> matchOrderOrgIds = new HashSet<Long>(16);
        ArrayList<DecpRowData> matchRowData = new ArrayList<DecpRowData>();
        List rowDataList = stepData.getRowDataList();
        for (DecpRowData decpRowData : rowDataList) {
            if ((curOrderOrgIds == null || curOrderOrgIds.size() == 0) && curBillSplitOrg.equals(decpRowData.getDecpOrgId())) {
                matchOrderOrgIds.add(decpRowData.getDecpOrgId());
                break;
            }
            if (curOrderOrgIds == null || curOrderOrgIds.size() <= 0 || !curOrderOrgIds.contains(decpRowData.getOrderOrgId())) continue;
            matchRowData.add(decpRowData);
            matchOrderOrgIds.add(decpRowData.getDecpOrgId());
        }
        if (matchRowData.size() > 0) {
            DecpStepData matchStepData = new DecpStepData(stepData.getName(), stepData.getNumber());
            matchStepData.getRowDataList().addAll(matchRowData);
            curSplitBillStepData.addStepData(matchStepData);
        }
        stepNum = stepNum + 1;
        this.getCurSplitBillStepData(curSplitBillStepData, matchOrderOrgIds, decpStepManager, stepNum, curBillSplitOrg);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshEntry(null);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("step")) {
            this.updateSplitProcess(key);
            this.refreshEntry(key);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key != null && key.startsWith("step")) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            label.setModel(this.getModel());
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }
}

