/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.utils.IDUtils;

public class CentralApproveBillList
extends AbstractListPlugin {
    private static final String UPDATE_CENTRAL_RELATION = "udpatecentralrelation";
    private static final Log log = LogFactory.getLog(CentralApproveBillList.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)UPDATE_CENTRAL_RELATION, (CharSequence)itemKey)) {
            BillList dataCont = (BillList)this.getControl("billlistap");
            if (dataCont.getSelectedRows() == null || dataCont.getSelectedRows().size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"CentralApproveBillList_01", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Object[] pkids = dataCont.getSelectedRows().getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "in", (Object)pkids);
            DynamicObject[] ebCentralappbills = BusinessDataServiceHelper.load((String)"eb_centralappbill", (String)"id,parentid,approveconfig_tag,centralorg", (QFilter[])filter.toArray());
            if (ebCentralappbills != null) {
                ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(16);
                for (DynamicObject ebCentralappbill : ebCentralappbills) {
                    long parentid = ebCentralappbill.getLong("parentid");
                    if (parentid == 0L) continue;
                    updates.add(ebCentralappbill);
                    long centralorg = ebCentralappbill.getLong("centralorg.id");
                    String approveconfigTag = ebCentralappbill.getString("approveconfig_tag");
                    if (!StringUtils.isNotEmpty((CharSequence)approveconfigTag)) continue;
                    List configs = SerializationUtils.fromJsonStringToList((String)approveconfigTag, ApproveBillConfig.class);
                    ApproveBill mainApproveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)IDUtils.toLong((Object)parentid)));
                    this.updateCentralDatas(configs, centralorg, mainApproveBill, ebCentralappbill);
                }
                if (!updates.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])updates.toArray(new DynamicObject[0]));
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\u3002", (String)"CentralApproveBillList_02", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void updateCentralDatas(List<ApproveBillConfig> configs, Long centralOrg, ApproveBill mainBill, DynamicObject updateData) {
        configs.clear();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)mainBill.getModel());
        Set tempIds = BgApplyBillUtils.getInstance().getTemplateByOrg(mainBill.getReportEntity(), mainBill.getReportScheme(), mainBill.getModel());
        Map templateDataMap = BusinessDataServiceHelper.loadFromCache((Object[])tempIds.toArray(), (String)"eb_applytemplate");
        ArrayList templateDatas = new ArrayList(templateDataMap.values());
        Set approvetypes = mainBill.getApprovetypes();
        Map approveTypes = BusinessDataServiceHelper.loadFromCache((Object[])approvetypes.toArray(), (String)"eb_approvaltypeentity");
        if (approveTypes == null || approveTypes.isEmpty()) {
            log.info(((Object)((Object)this)).getClass().getName() + "updateCentralDatas\u6ca1\u6709\u627e\u5230\u5ba1\u6279\u7c7b\u578b\u3002");
            return;
        }
        ArrayList approveTypeDatas = new ArrayList(approveTypes.values());
        Map approveIdMapcentralSchemaIds = CentralAppBillService.getInstance().getCentralSchemaIds(approveTypeDatas, mainBill.getReportEntity(), modelCacheHelper);
        HashSet schemeIds = new HashSet(16);
        for (Set value : approveIdMapcentralSchemaIds.values()) {
            schemeIds.addAll(value);
        }
        log.info(((Object)((Object)this)).getClass().getName() + "updateCentralDatas==>\u6240\u6709\u5ba1\u6279\u7c7b\u578b\u5bf9\u5e94\u7684\u65b9\u6848id\uff1a" + ((Object)schemeIds).toString());
        QFilter qFilter = new QFilter("scheme", "in", schemeIds);
        qFilter.and("status", "=", (Object)"1");
        qFilter.and("entity", "=", (Object)centralOrg);
        DynamicObjectCollection allrelations = QueryServiceHelper.query((String)"eb_centralrelation", (String)"scheme,entity,meminfojson,enabledate,disabledate,entryseq", (QFilter[])qFilter.toArray(), (String)"scheme,entryseq");
        HashMap templateMapTableName = new HashMap(16);
        Map temlateDimonColumn = CentralAppBillService.getInstance().getTemlateDimonColumn(tempIds, templateMapTableName);
        for (Long tempId : tempIds) {
            Set otherCurentSchemaIds;
            ApproveBillConfig config = new ApproveBillConfig();
            config.setTemplateId(tempId);
            config.setCentralOrg(centralOrg);
            Optional<DynamicObject> findTemplate = templateDatas.stream().filter(s -> s.getLong("id") == tempId.longValue()).findFirst();
            findTemplate.ifPresent(dynamicObject -> config.setTemplateNumber(dynamicObject.getString("number")));
            DynamicObject currentApproveType = null;
            block2: for (DynamicObject approveTypeData : approveTypeDatas) {
                DynamicObjectCollection entrys = approveTypeData.getDynamicObjectCollection("entryentity");
                Iterator iterator = entrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    Long applytemplate = entry.getLong("applytemplate.id");
                    if (!applytemplate.equals(tempId)) continue;
                    currentApproveType = approveTypeData;
                    continue block2;
                }
            }
            if (currentApproveType == null) continue;
            HashSet curentSchemaIds = new HashSet(16);
            List findcfgs = configs.stream().filter(s -> s.getTemplateId().equals(tempId)).collect(Collectors.toList());
            if (!findcfgs.isEmpty()) {
                for (ApproveBillConfig findcfg : findcfgs) {
                    curentSchemaIds.addAll(findcfg.getCentralSchemaIds());
                }
            }
            if (curentSchemaIds.isEmpty() && (otherCurentSchemaIds = (Set)approveIdMapcentralSchemaIds.get(currentApproveType.getLong("id"))) != null) {
                curentSchemaIds.addAll(otherCurentSchemaIds);
            }
            List currentRelations = allrelations.stream().filter(s -> curentSchemaIds.contains(s.getLong("scheme"))).collect(Collectors.toList());
            config.setCentralSchemaIds(curentSchemaIds);
            config.setApproveType(Long.valueOf(currentApproveType.getLong("id")));
            config.setApproveTypeNumber(currentApproveType.getString("number"));
            boolean centralsplit = currentApproveType.getBoolean("centralsplit");
            HashSet<String> centralDims = new HashSet<String>(16);
            config.setSplitCentral(centralsplit);
            Map centralRelations = CentralAppBillService.getInstance().getCentralRelations(currentRelations, modelCacheHelper, centralDims);
            if (centralRelations.isEmpty()) continue;
            List<Map<String, Set<Long>>> relations = centralRelations.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (!centralsplit) continue;
            Map dimonKeyMap = (Map)temlateDimonColumn.get(tempId);
            String tableName = (String)templateMapTableName.get(tempId);
            boolean otherExist = this.getOtherApproveConfig(mainBill, tableName, dimonKeyMap, tempId, config, relations, centralDims);
            if (!otherExist) continue;
            configs.add(config);
        }
        if (!configs.isEmpty()) {
            updateData.set("approveconfig_tag", (Object)SerializationUtils.toJsonString(configs));
        }
    }

    private boolean getOtherApproveConfig(ApproveBill mainBill, String tableName, Map<String, String> dimkeyMapfieldKey, Long tempId, ApproveBillConfig config, List<Map<String, Set<Long>>> relations, Set<String> centralDims) {
        boolean bl;
        DynamicObject templateData = BusinessDataServiceHelper.loadSingleFromCache((Object)tempId, (String)"eb_applytemplate");
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)templateData);
        List main_collect = columnList.getColumns().stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
        Map columnIndexMap = ApplyTemplateUtils.getColumnIndexMap(main_collect);
        List rows = CentralAppBillService.getInstance().queryDataFromDb(mainBill, tempId, "", tableName, columnList);
        boolean isContainRowDim = false;
        for (String string : centralDims) {
            if (!dimkeyMapfieldKey.containsKey(string)) continue;
            isContainRowDim = true;
            break;
        }
        if (!isContainRowDim) {
            config.setMatchMemberIds(relations);
            return true;
        }
        HashMap<String, Integer> dimNumberMapIndex = new HashMap<String, Integer>(16);
        for (String dimnumber : centralDims) {
            String fieldKey = dimkeyMapfieldKey.get(dimnumber);
            if (fieldKey == null) continue;
            Integer index = (Integer)columnIndexMap.get(fieldKey);
            dimNumberMapIndex.put(dimnumber, index);
        }
        boolean bl2 = false;
        for (Map<String, Set<Long>> dimvalue : relations) {
            bl = CentralAppBillService.getInstance().filterRows(rows, dimvalue, dimNumberMapIndex);
            if (!bl) continue;
            break;
        }
        if (bl) {
            config.setMatchMemberIds(relations);
            return true;
        }
        return false;
    }
}

