/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillSubStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;

public class CentralSplitBillWorkPlugin
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(CentralSplitBillWorkPlugin.class);

    public void notify(AgentExecution execution) {
        this.centralSplitBill(execution);
    }

    private void centralSplitBill(AgentExecution execution) {
        String businessKey = execution.getBusinessKey();
        if (StringUtils.isEmpty((CharSequence)businessKey)) {
            return;
        }
        String auditNode = execution.getCurrentFlowElement().getNumber();
        ApproveBill mainApproveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)IDUtils.toLong((Object)businessKey)));
        if (mainApproveBill == null) {
            return;
        }
        Set tempIds = BgApplyBillUtils.getInstance().getTemplateByOrg(mainApproveBill.getReportEntity(), mainApproveBill.getReportScheme(), mainApproveBill.getModel());
        String mainBillNo = mainApproveBill.getBillNo();
        Map templateDataMap = BusinessDataServiceHelper.loadFromCache((Object[])tempIds.toArray(), (String)"eb_applytemplate");
        ArrayList templateDatas = new ArrayList(templateDataMap.values());
        if (templateDatas.isEmpty()) {
            log.error(this.getClass().getName() + "splitBill==>" + mainBillNo + "\u6a21\u677f\u4e3a\u7a7a");
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CentralSplitBillWorkPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long bizModelId = 0L;
        DynamicObject dataset = ((DynamicObject)templateDatas.get(0)).getDynamicObject("dataset");
        if (dataset != null) {
            bizModelId = dataset.getLong("businessmodel.id");
        }
        Map paramMap = execution.getCurrentWFPluginParams();
        mainApproveBill.setSubStatusEnum(AppBillSubStatusEnum.NO_APPROVE);
        mainApproveBill.setHasSubitems(true);
        ApproveBillUtil.getInstance().save(Collections.singletonList(mainApproveBill));
        if (CollectionUtils.isNotEmpty((Map)paramMap)) {
            HashSet<String> schemaNumbers = new HashSet<String>(paramMap.size());
            for (Object number : paramMap.values()) {
                schemaNumbers.add((String)number);
            }
            QFilter qFilter = new QFilter("centralrange.model", "=", (Object)mainApproveBill.getModel());
            qFilter.and(new QFilter("number", "in", schemaNumbers));
            DynamicObject[] centralSchemaArr = BusinessDataServiceHelper.load((String)"eb_centralrelscheme", (String)"id,entity.id", (QFilter[])qFilter.toArray());
            HashMap<Long, Long> centralSchemaMap = new HashMap<Long, Long>(centralSchemaArr.length);
            for (DynamicObject centralSchema : centralSchemaArr) {
                Long centralSchemaId = centralSchema.getLong("id");
                Long entityId = centralSchema.getLong("entity.id");
                centralSchemaMap.put(centralSchemaId, entityId);
            }
            if (CollectionUtils.isEmpty(centralSchemaMap)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5f52\u53e3\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u5f52\u53e3\u65b9\u6848\u7f16\u7801\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"CentralSplitBillWorkPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)mainApproveBill.getModel());
            Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
            Long dimViewId = (Long)dimViewMap.get(SysDimensionEnum.Entity.getNumber());
            Member entityMember = modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), dimViewId, mainApproveBill.getReportEntity());
            List memberList = modelCacheHelper.getParents(dimViewId, entityMember, true);
            List memberIds = memberList.stream().map(member -> member.getId()).collect(Collectors.toList());
            HashSet<Long> centralSchemaIds = new HashSet<Long>(centralSchemaMap.size());
            for (Map.Entry entry : centralSchemaMap.entrySet()) {
                Long centralSchemaId = (Long)entry.getKey();
                Long budgetOrgId = (Long)entry.getValue();
                if (!memberIds.contains(budgetOrgId)) continue;
                centralSchemaIds.add(centralSchemaId);
            }
            CentralAppBillService.getInstance().splitBillHandle(mainApproveBill, centralSchemaIds, auditNode);
        } else {
            CentralAppBillService.getInstance().splitBillHandle(mainApproveBill, new HashSet(16), auditNode);
        }
    }
}

