/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.WorkflowElement;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApprovePlanUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApprovePlan;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class CentralWorkflowApprover
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(CentralWorkflowApprover.class);

    public List<Long> calcUserIds(AgentExecution execution) {
        ArrayList<Long> retApprovers = new ArrayList<Long>(16);
        String businessKey = execution.getBusinessKey();
        HashSet entities = new HashSet(16);
        HashSet reportEntities = new HashSet(16);
        HashSet<Long> templates = new HashSet<Long>(16);
        HashSet reportBillNos = new HashSet(16);
        CentralAppBillService instance = CentralAppBillService.getInstance();
        ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)IDUtils.toLong((Object)businessKey)));
        List approveBillEntries = approveBill.getApproveBillEntries();
        approveBillEntries.forEach(e -> {
            reportBillNos.add(e.getReportBillNo());
            entities.add(e.getCentralEntity());
            reportEntities.add(e.getEntity());
            templates.add(e.getTemplate());
        });
        Long model = approveBill.getModel();
        String billNo = approveBill.getBillNo();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        if (entities.size() == 0 || entities.size() == 1 && entities.contains(0L)) {
            entities.addAll(reportEntities);
        }
        log.info("CentralWorkflowApprover.approveBillInfos: Entity --->" + ((Object)entities).toString() + "Template --->" + ((Object)templates).toString() + "Model --->" + model.toString());
        WorkflowElement element = execution.getCurrentFlowElement();
        log.info("CentralWorkflowApprover.element: " + element);
        String number = element.getNumber();
        log.info("CentralWorkflowApprover.elementNumber: " + number);
        Object planNums = execution.getVariable(number);
        if (planNums == null) {
            log.info("CentralWorkflowApprover.planInElement: planVariable is null!!");
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8282\u70b9\u65b9\u6848\u7f16\u7801\u5931\u8d25\u3002", (String)"", (String)"", (Object[])new Object[0]));
        }
        log.info("CentralWorkflowApprover.planInElement: " + planNums.toString());
        List plans = instance.getPlanByCenApproveBill(templates, entities, planNums.toString(), model);
        if (plans.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u5ba1\u6279\u65b9\u6848\u3002", (String)"CentralWorkflowApprover_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Set<Long> approverIds = this.getApproverIds(plans, approveBill);
        if (approverIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5ba1\u6279\u4eba\u4fe1\u606f\u3002", (String)"CentralWorkflowApprover_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject appSchemeObj = BgApplyBillUtils.getInstance().getBgAppSchemeObj(approveBill);
        CentralAppChain centralAppChainByBills = instance.getCentralAppChainByBills(billNo, model);
        HashSet<String> billNos = new HashSet<String>(reportBillNos);
        List centralAppChains = instance.getCentralAppChains(centralAppChainByBills);
        centralAppChains.forEach(billNos::addAll);
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(model, Long.valueOf(appSchemeObj.getLong("id")), approveBill.getYear(), approveBill.getVersion(), approveBill.getDatatype());
        Set<Long> accountInBill = this.getAccountSetInBill(templates, billNos, modelCacheHelper, schemeAssignDimGroup);
        Set<Long> accountInPlan = this.getFilterAccountFromPlan(plans);
        accountInBill.retainAll(accountInPlan);
        if (accountInPlan.size() == 0 || accountInBill.size() != 0) {
            retApprovers.addAll(approverIds);
        }
        return retApprovers;
    }

    private Set<Long> getFilterAccountFromPlan(List<ApprovePlan> plans) {
        HashSet<Long> accounts = new HashSet<Long>(16);
        for (ApprovePlan plan : plans) {
            List centralPlans = plan.getCentralPlans();
            List centralSchemes = ApprovePlanUtil.getInstance().getCentralSchemesById(centralPlans, Boolean.valueOf(false));
            centralSchemes.forEach(e -> accounts.addAll(e.getAccounts()));
        }
        return accounts;
    }

    private Set<Long> getAccountSetInBill(Set<Long> templates, Set<String> billNos, IModelCacheHelper modelCacheHelper, SchemeAssignDimGroup schemeAssignDimGroup) {
        HashSet<Long> accounts = new HashSet<Long>(16);
        String number = SysDimensionEnum.Account.getNumber();
        HashMap<String, String> accountKeys = new HashMap<String, String>(16);
        Map allDimVarSettings = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        DynamicObjectCollection templateInfos = QueryServiceHelper.query((String)"eb_applytemplate", (String)"number, dataset,entrycfgjson_tag, cachedata_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", templates)});
        for (DynamicObject template : templateInfos) {
            Map hiddenDimMemMap;
            Long accountId;
            boolean isRowDim = false;
            ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
            HashSet<Long> curTemplateAccount = new HashSet<Long>(16);
            ColumnList columnList = this.getEntryCfgByApplyTemplateID(template);
            Long datasetId = template.getLong("dataset");
            ApplyTemplateUtils.changeVarOnColumn((ColumnList)columnList, (Long)datasetId, (IModelCacheHelper)modelCacheHelper, (Map)allDimVarSettings);
            Map entityInfoMap = columnList.getEntityinfomap();
            String tableName = (String)entityInfoMap.get("mainentryentity");
            Collection columns = columnList.getColumns();
            for (BaseColumn column : columns) {
                if (column instanceof DimensionColumn || column instanceof RelationDimensionColumn || column instanceof RowDimensionColumn) {
                    String dimNumber = instance.getDimOrRelateDimNumber(column, modelCacheHelper);
                    if (!dimNumber.equals(number)) continue;
                    accountKeys.put(tableName, column.getKey());
                    isRowDim = true;
                    break;
                }
                if (!(column instanceof MeasureColumn) && !(column instanceof CalculateColumn) && !(column instanceof DimensionDataColumn)) continue;
                measureCols.add(column);
            }
            if (isRowDim) continue;
            Map allColDimMembers = instance.getAllColDimMembers(measureCols, datasetId, modelCacheHelper, Boolean.valueOf(false));
            allColDimMembers.values().forEach(e -> {
                String dimMember = (String)e.get(number);
                if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)dimMember)) {
                    curTemplateAccount.add(IDUtils.toLong((Object)dimMember));
                }
            });
            if (curTemplateAccount.size() == 0 && (accountId = (Long)(hiddenDimMemMap = instance.getHiddenDimMemMap(template.getString("cachedata_tag"), datasetId, modelCacheHelper, allDimVarSettings)).get(number)) != null && accountId != 0L) {
                curTemplateAccount.add(accountId);
            }
            accounts.addAll(curTemplateAccount);
        }
        accountKeys.forEach((key, value) -> accounts.addAll(this.getAccountFromDataBase((String)key, (String)value, billNos)));
        return accounts;
    }

    private Set<Long> getAccountFromDataBase(String table, String fieldKey, Set<String> billNos) {
        HashSet<Long> accounts = new HashSet<Long>(16);
        String selectFieldKey = "f" + fieldKey;
        String sql = "select " + selectFieldKey + " from " + table + " where fbillnumber in " + billNos.stream().collect(Collectors.joining("', '", "('", "')"));
        DataSet dataSet = DB.queryDataSet((String)"queryAccount", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return accounts;
        }
        Row row = null;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            accounts.add(row.getLong(selectFieldKey));
        }
        return accounts;
    }

    private ColumnList getEntryCfgByApplyTemplateID(DynamicObject template) {
        String json = template.getString("entrycfgjson_tag");
        String number = template.getString("number");
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u6ca1\u6709\u5206\u5f55\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyTemplateUtils_0", (String)"epm-eb-common", (Object[])new Object[]{number}));
        }
        return (ColumnList)SerializationUtils.fromJsonString((String)json, ColumnList.class);
    }

    private Set<Long> getApproverIds(List<ApprovePlan> plans, ApproveBill approveBill) {
        HashSet<String> planNumbers = new HashSet<String>(16);
        ApprovePlanUtil instance = ApprovePlanUtil.getInstance();
        HashSet<Long> approverIds = new HashSet<Long>(16);
        for (ApprovePlan plan : plans) {
            planNumbers.add(plan.getNumber());
            if (plan.isCenApprove().booleanValue()) {
                List centralPlans = plan.getCentralPlans();
                log.info("CentralWorkflowApprover.centralPlans: " + centralPlans.toString());
                approverIds.addAll(this.getApproverIdsInCenPlan(centralPlans));
                continue;
            }
            Map approvers = plan.getApprovers();
            approvers.forEach((key, value) -> approverIds.addAll(instance.getApprovers(key, value, approveBill)));
        }
        log.info("CentralWorkflowApprover.filterPlanNums: " + ((Object)planNumbers).toString());
        log.info("CentralWorkflowApprover.approveIds: " + ((Object)approverIds).toString());
        return approverIds;
    }

    private Set<Long> getApproverIdsInCenPlan(List<Long> centralPlans) {
        HashSet<Long> approvers = new HashSet<Long>(16);
        List centralSchemes = ApprovePlanUtil.getInstance().getCentralSchemesById(centralPlans, Boolean.valueOf(false));
        log.info("CentralWorkflowApprover.centralSchemes: " + centralSchemes.toString());
        centralSchemes.forEach(e -> approvers.addAll(e.getApprovers()));
        return approvers;
    }
}

