/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.epm.eb.common.DynamicCreate.CreateItemApHelper;
import kd.epm.eb.common.DynamicCreate.CreateItemCtrlHelper;
import kd.epm.eb.common.DynamicCreate.FieldItemType;
import kd.epm.eb.common.centralapproval.CustomSelectGroup;
import kd.epm.eb.common.centralapproval.CustomSelectItem;
import kd.epm.eb.common.centralapproval.CustomSelectItemSetting;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class CustomSelectBasePlugin
extends AbstractFormPlugin {
    private List<CustomSelectGroup> groups = null;
    private final Map<String, List<String>> groupMap = new HashMap<String, List<String>>(16);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bnt_conform"});
    }

    public void afterCreateNewData(EventObject e) {
        List<CustomSelectGroup> groups = this.getCustomSelectGroup(null);
        if (groups == null) {
            return;
        }
        ArrayList unVisible = new ArrayList(16);
        ArrayList unEnable = new ArrayList(16);
        groups.forEach(k -> {
            List customSelectItems = k.getCustomSelectItems();
            if (customSelectItems != null) {
                customSelectItems.forEach(j -> {
                    Boolean enable;
                    String key = j.getKey();
                    Boolean visible = j.getVisible();
                    if (!visible.booleanValue()) {
                        unVisible.add(key);
                    }
                    if (!(enable = j.getEnable()).booleanValue()) {
                        unEnable.add(key);
                    }
                });
            }
        });
        if (unVisible.size() != 0) {
            this.getView().setVisible(Boolean.valueOf(false), unVisible.toArray(new String[0]));
        }
        if (unEnable.size() != 0) {
            this.getView().setEnable(Boolean.valueOf(false), unEnable.toArray(new String[0]));
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container control = (Container)this.getControl("dimcolumnpanel");
        FlexPanelAp flexPanelAp = this.getFlexPanelAp(this.getView().getFormShowParameter());
        IFormView view = this.getView();
        List items = ((Container)flexPanelAp.buildRuntimeControl()).getItems();
        items.forEach(k -> {
            k.setView(view);
            control.getItems().add(k);
            this.addChildItemView((Control)k);
        });
        this.getView().createControlIndex(control.getItems());
    }

    private void addChildItemView(Control control) {
        IFormView view = this.getView();
        if (control instanceof Container) {
            Container container = (Container)control;
            List items = container.getItems();
            if (items != null) {
                items.forEach(e -> {
                    e.setView(view);
                    this.addChildItemView((Control)e);
                });
            }
        } else if (control != null) {
            control.setView(view);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        FlexPanelAp panelAp = this.getFlexPanelAp(formShowParameter);
        e.getItems().add(panelAp.createControl());
    }

    private FlexPanelAp getFlexPanelAp(FormShowParameter formShowParameter) {
        List<CustomSelectGroup> groups = this.getCustomSelectGroup(formShowParameter);
        FlexPanelAp panelAp = this.getOuterFlexPanelAp(formShowParameter);
        if (groups != null && groups.size() != 0) {
            this.initSaveKeyMap(groups, formShowParameter);
            groups.forEach(k -> {
                FlexPanelAp groupPanelAp = this.getGroupPanelAp((CustomSelectGroup)k, formShowParameter);
                List items = panelAp.getItems();
                this.setGroupPanelWidthPadding(groupPanelAp, items);
                items.add(groupPanelAp);
            });
        }
        return panelAp;
    }

    private void initSaveKeyMap(List<CustomSelectGroup> groups, FormShowParameter formShowParameter) {
        HashMap<String, String> keyMap = new HashMap<String, String>(16);
        for (CustomSelectGroup group : groups) {
            String groupKey = this.getDivideKey(group.getKey());
            List customSelectItems = group.getCustomSelectItems();
            for (CustomSelectItem customSelectItem : customSelectItems) {
                String key = customSelectItem.getKey();
                String key_afterChange = groupKey + "!" + key.toLowerCase();
                keyMap.put(key_afterChange, key);
                customSelectItem.setKey(key_afterChange);
            }
        }
        formShowParameter.setCustomParam("keyMap", (Object)SerializationUtils.toJsonString(keyMap));
    }

    private void setGroupPanelWidthPadding(FlexPanelAp groupPanelAp, List<ControlAp<?>> items) {
        String key = this.getDivideKey(groupPanelAp.getKey());
        if (key != null) {
            for (ControlAp<?> item : items) {
                ControlAp controlAp;
                String itemKey = this.getDivideKey(item.getKey());
                if (!key.equals(itemKey)) continue;
                List flexPanelItems = ((FlexPanelAp)item).getItems();
                if (flexPanelItems.size() == 0 || !((controlAp = (ControlAp)flexPanelItems.get(0)) instanceof FlexPanelAp) && !(controlAp instanceof LabelAp)) break;
                int px = 50;
                if (controlAp instanceof LabelAp) {
                    String name = controlAp.getName().getLocaleValue();
                    px = this.getStringPx(name) + 50;
                }
                Style style = new Style();
                Padding padding = new Padding();
                padding.setLeft(px + "px");
                padding.setRight(px + "px");
                style.setPadding(padding);
                groupPanelAp.setStyle(style);
                groupPanelAp.setOverflow("hidden");
                break;
            }
        }
    }

    private int getStringPx(String key) {
        char[] chars;
        int px = 0;
        if (StringUtils.isEmpty((String)key)) {
            return px;
        }
        for (char aChar : chars = key.toCharArray()) {
            if (this.isAllChar(aChar)) {
                px += 12;
                continue;
            }
            px += 7;
        }
        return px + 12;
    }

    private String getDivideKey(String key) {
        String[] split = key.split("!");
        return split[0];
    }

    private FlexPanelAp getGroupPanelAp(CustomSelectGroup group, FormShowParameter formShowParameter) {
        String key = group.getKey();
        FlexPanelAp panelAp = this.createGroupPanelAp(key);
        String name = group.getName();
        if (StringUtils.isEmpty((String)name)) {
            this.setPanelApStyle(panelAp);
            this.addSelectItems(panelAp, group, formShowParameter);
        } else {
            Boolean divideShow = group.getDivideShow();
            if (divideShow.booleanValue()) {
                FlexPanelAp panelAp_name = CreateItemApHelper.createFlexPanelAp((String)(key + "_name"));
                this.setGroupTitleStyle(panelAp_name);
                panelAp_name.getItems().add(this.getTitleLabel(key, name));
                panelAp.getItems().add(panelAp_name);
                FlexPanelAp panelAp_selects = CreateItemApHelper.createFlexPanelAp((String)(key + "_select"));
                this.setPanelApStyle(panelAp_selects);
                this.addSelectItems(panelAp_selects, group, formShowParameter);
                panelAp.getItems().add(panelAp_selects);
            } else {
                this.setPanelApStyle(panelAp);
                panelAp.getItems().add(this.getTitleLabel(key, name));
                this.addSelectItems(panelAp, group, formShowParameter);
            }
        }
        return panelAp;
    }

    private FlexPanelAp createGroupPanelAp(String key) {
        FlexPanelAp panelAp = CreateItemApHelper.createFlexPanelAp((String)(key + "_ap"));
        panelAp.setDirection("column");
        panelAp.setAlignItems("stretch");
        panelAp.setJustifyContent("central");
        panelAp.setGrow(0);
        panelAp.setShrink(0);
        panelAp.setWrap(false);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("20px");
        style.setPadding(padding);
        panelAp.setStyle(style);
        return panelAp;
    }

    private void setGroupTitleStyle(FlexPanelAp panelAp) {
        panelAp.setDirection("column");
        panelAp.setAlignItems("flex-start");
        panelAp.setJustifyContent("central");
        panelAp.setGrow(0);
        panelAp.setShrink(0);
        panelAp.setWrap(false);
    }

    private LabelAp getTitleLabel(String key, String name) {
        LabelAp labelAp = CreateItemApHelper.createLableAp((String)(key + "_label"), (String)(name + ResManager.loadKDString((String)"\uff1a", (String)"", (String)"", (Object[])new Object[0])));
        labelAp.setFontSize(15);
        labelAp.setLineHeight("20px");
        Style labelApStyle = new Style();
        Padding padding = new Padding();
        padding.setTop("10px");
        padding.setRight("20px");
        labelApStyle.setPadding(padding);
        labelAp.setStyle(labelApStyle);
        labelAp.setShrink(0);
        labelAp.setGrow(0);
        return labelAp;
    }

    private void setPanelApStyle(FlexPanelAp panelAp) {
        panelAp.setDirection("row");
        panelAp.setAlignItems("flex-start");
        panelAp.setJustifyContent("flex-start");
        panelAp.setGrow(0);
        panelAp.setShrink(0);
        panelAp.setWrap(false);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("30px");
        style.setPadding(padding);
        panelAp.setStyle(style);
    }

    private void addSelectItems(FlexPanelAp panelAp, CustomSelectGroup group, FormShowParameter formShowParameter) {
        CustomSelectItemSetting setting = group.getSetting();
        Boolean mustInput = setting.getMustInput();
        List customSelectItems = group.getCustomSelectItems();
        if (customSelectItems == null || customSelectItems.size() == 0) {
            return;
        }
        int itemNameSplitLength = this.getItemNameSplitLength(formShowParameter);
        int width = this.getFieldApWidth(itemNameSplitLength);
        customSelectItems.forEach(e -> {
            String name = e.getName();
            FieldAp fieldAp = CreateItemApHelper.getFieldAp((String)(e.getKey() + "_item"), (String)this.replaceName(name, itemNameSplitLength), (boolean)false, (FieldItemType)FieldItemType.CHECKBO);
            fieldAp.setFireUpdEvt(true);
            fieldAp.setWidth(new LocaleString(width + "px"));
            fieldAp.setHeight(new LocaleString("25px"));
            fieldAp.setGrow(0);
            fieldAp.setShrink(0);
            CheckBoxField field = (CheckBoxField)fieldAp.getField();
            field.setShowStyle(group.getTypeIndex());
            field.setMustInput(mustInput != false ? true : e.getMustInput());
            List items = panelAp.getItems();
            items.add(fieldAp);
        });
    }

    private int getFieldApWidth(int itemNameSplitLength) {
        return 9 * itemNameSplitLength;
    }

    private int getItemNameSplitLength(FormShowParameter formShowParameter) {
        Object splitLength = formShowParameter.getCustomParam("splitLength");
        if (splitLength != null) {
            return Integer.parseInt(splitLength.toString());
        }
        return 0;
    }

    private boolean isAllChar(char aChar) {
        String tmp = String.valueOf(aChar);
        return tmp.matches("[^\\x00-\\xff]");
    }

    private String replaceName(String name, int itemNameSplitLength) {
        int size = 7 * itemNameSplitLength;
        int index = 0;
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (this.isAllChar(aChar)) {
                if (size < 12) {
                    index = i;
                    break;
                }
                size -= 12;
                continue;
            }
            if (size < 7) {
                index = i;
                break;
            }
            size -= 7;
        }
        if (index == 0) {
            return name;
        }
        String subString = name.substring(0, index);
        if (size % 12 >= 7) {
            subString = subString + ".";
        }
        return subString + "...";
    }

    private FlexPanelAp getOuterFlexPanelAp(FormShowParameter formShowParameter) {
        FlexPanelAp panelAp = CreateItemApHelper.createFlexPanelAp((String)"dimcolumnpanel");
        panelAp.setDirection("column");
        panelAp.setAlignItems("flex-start");
        panelAp.setJustifyContent("center");
        panelAp.setGrow(0);
        panelAp.setShrink(0);
        StyleCss inlineStyleCss = formShowParameter.getOpenStyle().getInlineStyleCss();
        if (inlineStyleCss != null) {
            String heightStr = inlineStyleCss.getHeight();
            heightStr = heightStr.replace("px", "");
            int height = Integer.parseInt(heightStr);
            panelAp.setHeight(new LocaleString(height - 50 + "px"));
        }
        Style panelApStyle = new Style();
        Padding padding = new Padding();
        padding.setBottom("20px");
        panelApStyle.setPadding(padding);
        panelAp.setStyle(panelApStyle);
        panelAp.setWrap(false);
        panelAp.setOverflow("hidden");
        return panelAp;
    }

    private List<CustomSelectGroup> getCustomSelectGroup(FormShowParameter formShowParameter) {
        if (this.groups == null) {
            String selectGroups;
            if (formShowParameter == null) {
                formShowParameter = this.getView().getFormShowParameter();
            }
            if (StringUtils.isNotEmpty((String)(selectGroups = (String)formShowParameter.getCustomParam("selectGroups")))) {
                this.groups = (List)ObjectSerialUtil.parseObject((String)selectGroups, (TypeReference)new TypeReference<List<CustomSelectGroup>>(){}, (Feature[])new Feature[0]);
            }
        }
        return this.groups;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.isNotEmpty((String)key) && key.endsWith("_item")) {
            FieldEdit checkbox = CreateItemCtrlHelper.createCheckBoxItemCtrl((String)key, (IFormView)this.getView(), (IDataModel)this.getModel());
            e.setControl((Control)checkbox);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        List<CustomSelectGroup> customSelectGroups = this.getCustomSelectGroup(null);
        customSelectGroups.forEach(e -> {
            List customSelectItems = e.getCustomSelectItems();
            String groupKey = this.getDivideKey(e.getKey());
            customSelectItems.forEach(k -> {
                String key = groupKey + "!" + k.getKey();
                BooleanProp booleanProp = new BooleanProp();
                booleanProp.setName(key + "_item");
                booleanProp.setDbIgnore(true);
                newMainType.addProperty((DynamicProperty)booleanProp);
            });
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (!(newValue instanceof Boolean)) {
            return;
        }
        if (!((Boolean)newValue).booleanValue()) {
            return;
        }
        Map<String, List<String>> groupMap = this.getGroupMap(false);
        if (groupMap.size() == 0) {
            return;
        }
        groupMap.forEach((key, value) -> {
            if (value.contains(name)) {
                value.forEach(k -> {
                    Object booleanValue;
                    if (!k.equals(name) && (booleanValue = this.getModel().getValue(k)) != null && ((Boolean)booleanValue).booleanValue()) {
                        this.getModel().setValue(k, (Object)false);
                    }
                });
            }
        });
    }

    private Map<String, List<String>> getGroupMap(Boolean isAll) {
        if (isAll.booleanValue() || this.groupMap.size() == 0) {
            List<CustomSelectGroup> groups = this.getCustomSelectGroup(null);
            groups.forEach(e -> {
                CustomSelectItemSetting setting = e.getSetting();
                Boolean multiply = setting.getMultiply();
                if (isAll.booleanValue() || !multiply.booleanValue()) {
                    String divideKey = this.getDivideKey(e.getKey());
                    List items = this.groupMap.computeIfAbsent(divideKey, k -> new ArrayList(16));
                    e.getCustomSelectItems().forEach(k -> items.add(divideKey + "!" + k.getKey().toLowerCase() + "_item"));
                }
            });
        }
        return this.groupMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Map<String, Object> selectInfo = this.getUserSelectMap();
        this.getView().returnDataToParent(selectInfo);
        this.getView().close();
    }

    private Map<String, Object> getUserSelectMap() {
        Map<String, List<String>> groupMap = this.getGroupMap(true);
        HashMap<String, Object> retData = new HashMap<String, Object>(16);
        String keyMapJson = (String)this.getView().getFormShowParameter().getCustomParam("keyMap");
        Map keyMap = (Map)SerializationUtils.fromJsonString((String)keyMapJson, Map.class);
        groupMap.forEach((key, value) -> {
            ArrayList selects = new ArrayList(16);
            value.forEach(e -> {
                if (this.isValid((String)e)) {
                    selects.add(this.getRetValue((String)e, keyMap));
                }
            });
            retData.put((String)key, selects);
        });
        return retData;
    }

    private boolean isValid(String key) {
        Object value = this.getModel().getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private Object getRetValue(String key, Map<String, String> keyMap) {
        return keyMap.get(key.replace("_item", ""));
    }
}

