/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.centralapproval;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.exception.WFEngineException;
import kd.epm.eb.business.applybill.util.ApplyBillAttachmentHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.centralapproval.CentralAppThreadManager;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.AppBillSubStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.utils.StringUtils;

public class DealAppBillWorkFlowPlugin
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(CentralAppBillService.class);

    public void notify(AgentExecution execution) {
        String businessKey = execution.getBusinessKey();
        this.handleNotify(businessKey);
    }

    public void handleNotify(String businessKey) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(businessKey), (String)"eb_centralappbill");
        dynamicObject.set("billstatus", (Object)AppBillStatusEnum.AUDITFAIL.getNumber());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        Long parentid = dynamicObject.getLong("parentid");
        boolean isparentBill = false;
        if (parentid == 0L || parentid == null) {
            parentid = (Long)dynamicObject.getPkValue();
            isparentBill = true;
            try {
                this.querySbBill(parentid, dynamicObject.getDynamicObject("model").getLong("id"));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u63d2\u4ef6\u5f02\u5e38\uff01", (String)"DealAppBillWorkFlowPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        QFilter qFilter = new QFilter("parentid", "=", (Object)parentid).and("id", "!=", (Object)parentid);
        Map childBill = BusinessDataServiceHelper.loadFromCache((String)"eb_centralappbill", (QFilter[])new QFilter[]{qFilter});
        boolean isAllReturn = true;
        for (Map.Entry entry : childBill.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            String billstatus = value.getString("billstatus");
            if (billstatus.equals(AppBillStatusEnum.AUDITFAIL.getNumber())) continue;
            isAllReturn = false;
            break;
        }
        if (childBill.size() == 0) {
            isAllReturn = false;
        }
        HashSet<String> billNos = new HashSet<String>(16);
        HashSet<Long> billIds = new HashSet<Long>(16);
        billNos.add(dynamicObject.getString("billno"));
        billIds.add(Long.parseLong(businessKey));
        DynamicObject model = dynamicObject.getDynamicObject("model");
        Long modelId = (Long)model.getPkValue();
        this.newRollBackData(billNos, modelId, isparentBill, parentid);
        this.deletBillCount(billNos, billIds, modelId, false);
        if (isAllReturn || isparentBill) {
            this.endWorkFlow(parentid);
        }
    }

    private void newRollBackData(Set<String> billNos, Long modelId, boolean isparentBill, Long parentid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("billno", "in", billNos));
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        Map<String, ApproveBill> approveBillMap = approveBills.stream().collect(Collectors.toMap(ApproveBill::getBillNo, e -> e));
        this.rollBackData(billNos, approveBillMap, modelId, isparentBill, parentid);
    }

    private void querySbBill(Long parentid, Long model) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "=", (Object)parentid));
        DataSet agAppBill = ORM.create().queryDataSet(this.getClass().getName(), "eb_centralappbill", "centralapprptentity.reportbillno as reportbillno,centralapprptentity.sumbillno as sumbillno", filters.toArray(new QFilter[0]));
        HashSet<String> reportbillnoList = new HashSet<String>();
        HashSet<String> sumbillnoList = new HashSet<String>();
        DataSet dataSet = agAppBill.copy();
        for (Row next : dataSet) {
            String reportbillno = next.getString("reportbillno");
            String sumbillno = next.getString("sumbillno");
            if (!reportbillno.isEmpty() || !reportbillno.equals("")) {
                reportbillnoList.add(reportbillno);
            }
            if (sumbillno.isEmpty() && sumbillno.equals("")) continue;
            sumbillnoList.add(sumbillno);
        }
        if (reportbillnoList.size() != 0 && sumbillnoList.size() != 0) {
            QFilter filter = new QFilter("model", "=", (Object)model);
            if (sumbillnoList.size() > 0) {
                filter.and("billnumber", "in", sumbillnoList);
            } else if (reportbillnoList.size() > 0) {
                filter.and("billnumber", "in", reportbillnoList);
            }
            DynamicObject bgApply = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgapplybill", (QFilter[])filter.toArray());
            bgApply.set("billstatus", (Object)AppBillStatusEnum.REAUDIT.getNumber());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bgApply});
        }
    }

    private void endWorkFlow(Long parentid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)parentid, (String)"eb_centralappbill");
        DynamicObject model = dynamicObject.getDynamicObject("model");
        Long modelId = (Long)model.getPkValue();
        Long pkId = (Long)dynamicObject.getPkValue();
        String billNo = dynamicObject.getString("billno");
        this.DealChildBill(pkId, billNo, modelId);
        dynamicObject.set("itemstatus", (Object)AppBillSubStatusEnum.ALL_RETURN.getNumber());
        dynamicObject.set("billstatus", (Object)AppBillStatusEnum.AUDITFAIL.getNumber());
        dynamicObject.set("ishassubitems", (Object)false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        this.querySbBill(parentid, dynamicObject.getDynamicObject("model").getLong("id"));
    }

    private void DealChildBill(Long pkId, String billno, Long modelId) {
        HashSet<String> billNos = new HashSet<String>(16);
        ArrayList<String> pkIds = new ArrayList<String>(16);
        HashSet<Long> billIds = new HashSet<Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("parentid", "=", (Object)pkId)};
        DynamicObjectCollection subBills = QueryServiceHelper.query((String)"eb_centralappbill", (String)"id,billno", (QFilter[])filters);
        if (subBills != null && !subBills.isEmpty()) {
            for (DynamicObject subBill : subBills) {
                String billnumber = subBill.getString("billno");
                String billid = subBill.getString("id");
                billNos.add(billnumber);
                pkIds.add(billid);
                billIds.add(Long.parseLong(billid));
            }
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("billno", "in", billNos));
        List approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
        Map<String, ApproveBill> approveBillMap = approveBills.stream().collect(Collectors.toMap(ApproveBill::getBillNo, e -> e));
        this.stopWorkFlowProcess(pkIds);
        this.deletBillCount(billNos, billIds, modelId, true);
        this.deleteRejectDataBySpNumbers(billNos, modelId);
        ApplyBillAttachmentHelper.removeApproveBillAttachments(billNos, (Long)modelId);
    }

    private void deletBillCount(Set<String> billNos, Set<Long> billIds, Long modelId, Boolean isdelect) {
        Map refBillNumMap = RejectBillService.getInstance().getBhNumbersBySpNumbers(billNos);
        HashSet<String> refBillNums = new HashSet<String>(16);
        refBillNumMap.values().forEach(refBillNums::addAll);
        this.deleteBillAndReferences(billIds, billNos, refBillNums, modelId, isdelect);
    }

    private void rollBackData(Set<String> billNos, Map<String, ApproveBill> approveBills, Long modelId, boolean isparentBill, Long parentid) {
        for (String billNum : billNos) {
            ApproveBill approveBill = approveBills.get(billNum);
            this.getApproveBill(modelId, isparentBill, parentid, approveBill);
            CentralAppShowInfo showInfo = CentralAppBillService.getInstance().createShowInfo(approveBill);
            Set refBillNumbs = RejectBillService.getInstance().getBhNumbersBySpNumber(billNum);
            String billType = CentralAppBillService.getInstance().getAuditBillType(approveBill.getApproveBillEntries());
            SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(modelId, approveBill.getReportScheme(), approveBill.getYear(), approveBill.getVersion(), approveBill.getDatatype());
            ApplyBillPluginUitl.rollbackBillData((String)billNum, (SchemeAssignDimGroup)schemeAssignDimGroup, (Set)refBillNumbs, (Long)modelId, (String)billType, (CentralAppShowInfo)showInfo);
        }
    }

    private ApproveBill getApproveBill(Long modelId, boolean isparentBill, Long parentid, ApproveBill approveBill) {
        if (!isparentBill) {
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and(new QFilter("id", "=", (Object)parentid));
            List approveBills = ApproveBillUtil.getInstance().getApproveBills(qFilter);
            Map<String, ApproveBill> approveBillMap = approveBills.stream().collect(Collectors.toMap(ApproveBill::getBillNo, e -> e));
            if (approveBillMap != null) {
                return approveBillMap.values().iterator().next();
            }
        }
        return approveBill;
    }

    public void deleteBillAndReferences(Set<Long> centralBillIds, Set<String> centralBillNos, Set<String> refBillNums, Long model, boolean needDelBill) {
        BgApplyBillUtils instance = BgApplyBillUtils.getInstance();
        refBillNums.addAll(centralBillNos);
        instance.deleteDimQuote(centralBillIds);
        DeleteServiceHelper.delete((String)"eb_centralappadjrecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "in", refBillNums)});
        DeleteServiceHelper.delete((String)"eb_centralapprecord", (QFilter[])new QFilter[]{new QFilter("approvebillno", "in", refBillNums)});
        if (needDelBill) {
            DeleteServiceHelper.delete((String)"eb_centralappbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", centralBillNos)});
        }
    }

    public void stopWorkFlowProcess(List<String> businessKeys) {
        if (businessKeys == null || businessKeys.size() == 0) {
            return;
        }
        for (String businessKey : businessKeys) {
            Long processId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)businessKey);
            if (processId == null || processId == 0L || !WorkflowServiceHelper.inProcess((String)businessKey)) continue;
            try {
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            catch (WFEngineException e) {
                log.info(" --- stop workflow process(businessKey): " + businessKey);
                this.createCancelWorkFlowProcessThread(businessKey);
            }
        }
    }

    private void createCancelWorkFlowProcessThread(String businessKey) {
        RequestContext context = RequestContextCreator.createForThreadPool();
        ExecutorService centralAppProPool = CentralAppThreadManager.getCentralAppProPool();
        CancelWorkFlow cancelWorkFlow = new CancelWorkFlow(context, businessKey);
        centralAppProPool.submit(cancelWorkFlow);
    }

    public void deleteRejectDataBySpNumbers(Set<String> spNumbers, Long modelId) {
        QFilter filter = new QFilter("srcbillnumber", "in", spNumbers);
        filter.and("model", "=", (Object)modelId);
        filter.and("billstatus", "!=", (Object)AppBillStatusEnum.STORAGE.getNumber());
        DeleteServiceHelper.delete((String)"eb_bgapplybill", (QFilter[])filter.toArray());
        QFilter filter1 = new QFilter("spbillnumber", "in", spNumbers);
        filter1.and("model", "=", (Object)modelId);
        DeleteServiceHelper.delete((String)"eb_billrejectlog", (QFilter[])filter1.toArray());
    }

    static class CancelWorkFlow
    implements Runnable {
        private RequestContext context = null;
        private String key = null;

        public CancelWorkFlow(RequestContext context, String key) {
            this.context = context;
            this.key = key;
        }

        @Override
        public void run() {
            if (StringUtils.isEmpty((String)this.key)) {
                return;
            }
            log.info(" --- workflow cancel process start: Thread ---> " + Thread.currentThread().getId() + " businessKey ---> " + this.key);
            int index = 0;
            RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
            boolean continueAbandon = true;
            while (continueAbandon) {
                try {
                    Thread.sleep(60000L);
                    ++index;
                    WorkflowServiceHelper.abandonByBusienssKey((String)this.key);
                    continueAbandon = false;
                    log.info(" --- cancel workflow process successful(businessKey): " + this.key);
                }
                catch (InterruptedException | WFEngineException e) {
                    if (e instanceof WFEngineException) {
                        if (index >= 15) {
                            continueAbandon = false;
                        }
                        log.info(" --- continue to cancel workflow process(businessKey): " + this.key);
                        continue;
                    }
                    continueAbandon = false;
                    log.info(e.getMessage());
                }
            }
        }
    }
}

